/*
 * Decompiled with CFR 0.152.
 */
package SharpTools;

import SharpTools.CellPoint;
import SharpTools.CellRange;
import SharpTools.Debug;
import SharpTools.History;
import SharpTools.MainApplet;
import SharpTools.Node;
import SharpTools.SharpOptionPane;
import SharpTools.SharpTableModel;
import SharpTools.SharpTools;
import SharpTools.SortDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class TableOp
implements ActionListener {
    private SharpTools sharp;
    public SharpOptionPane sharpoptionpane;
    private JTable table;
    private SharpTableModel tableModel;
    private History history;
    private JToolBar toolBar;
    final ImageIcon colwidthIcon = new ImageIcon(this.getClass().getResource("/images/colwidth.gif"));

    TableOp(SharpTools sharp) {
        this.init(sharp);
        sharp.checkFindNextState();
        KeyStroke insertrow = KeyStroke.getKeyStroke(155, 2, false);
        KeyStroke insertcolumn = KeyStroke.getKeyStroke(155, 3, false);
        KeyStroke deleterow = KeyStroke.getKeyStroke(127, 2, false);
        KeyStroke deletecolumn = KeyStroke.getKeyStroke(127, 3, false);
        this.table.registerKeyboardAction(this, SharpTools.translation.getProperty("Insert_Row"), insertrow, 0);
        this.table.registerKeyboardAction(this, SharpTools.translation.getProperty("Insert_Column"), insertcolumn, 0);
        this.table.registerKeyboardAction(this, SharpTools.translation.getProperty("Delete_Row"), deleterow, 0);
        this.table.registerKeyboardAction(this, SharpTools.translation.getProperty("Delete_Column"), deletecolumn, 0);
    }

    private void init(SharpTools sharp) {
        this.sharp = sharp;
        this.table = sharp.getTable();
        this.tableModel = sharp.getTableModel();
        this.history = sharp.getHistory();
        this.toolBar = sharp.getToolBar();
    }

    public void insert(boolean byRow) {
        int insertNum = this.table.getSelectedRowCount();
        if (insertNum != 0) {
            if (byRow) {
                int row = this.table.getSelectedRow();
                CellRange range = new CellRange(new CellPoint(row, SharpTools.baseCol), new CellPoint(row + insertNum - 1, this.tableModel.getColumnCount() - 1));
                this.history.add(this.tableModel, range, 1);
                this.tableModel.insertRow(range);
            } else {
                insertNum = this.table.getSelectedColumnCount();
                int column = this.table.getSelectedColumn();
                CellRange range = new CellRange(new CellPoint(SharpTools.baseRow, column), new CellPoint(this.tableModel.getRowCount() - 1, column + insertNum - 1));
                this.history.add(this.tableModel, range, 2);
                this.tableModel.insertColumn(range);
            }
        } else {
            this.sharp.noCellsSelected("Insert");
        }
    }

    public void remove(boolean byRow) {
        int removeNum = this.table.getSelectedRowCount();
        if (removeNum != 0) {
            if (byRow) {
                if (removeNum == this.table.getRowCount() - 1) {
                    this.tooMuchDeletion();
                    return;
                }
                int row = this.table.getSelectedRow();
                CellRange range = new CellRange(new CellPoint(row, SharpTools.baseCol), new CellPoint(row + removeNum - 1, this.tableModel.getColumnCount() - 1));
                if (this.tableModel.isDeletionSafe(range, true) || this.unsafeDeletion()) {
                    this.history.add(this.tableModel, range, 3);
                    Debug.println(range);
                    this.tableModel.removeRow(range);
                    Debug.println("Delete row range " + range);
                }
            } else {
                int column = this.table.getSelectedColumn();
                removeNum = this.table.getSelectedColumnCount();
                if (removeNum == this.table.getColumnCount() - 1) {
                    this.tooMuchDeletion();
                    return;
                }
                CellRange range = new CellRange(new CellPoint(SharpTools.baseRow, column), new CellPoint(this.tableModel.getRowCount() - 1, column + removeNum - 1));
                Debug.println("Delete column range " + range);
                if (this.tableModel.isDeletionSafe(range, false) || this.unsafeDeletion()) {
                    this.history.add(this.tableModel, range, 4);
                    Debug.println(range);
                    this.tableModel.removeColumn(range);
                }
            }
        } else {
            this.sharp.noCellsSelected(SharpTools.translation.getProperty("Remove"));
        }
    }

    public void sort(boolean byRow) {
        if (this.table.getSelectedRowCount() != 0) {
            int i;
            CellRange range = new CellRange(this.table.getSelectedRows(), this.table.getSelectedColumns());
            Vector<String> primary = new Vector<String>();
            Vector<String> secondary = new Vector<String>();
            secondary.add("None");
            if (byRow) {
                for (i = range.getStartRow(); i <= range.getEndRow(); ++i) {
                    primary.add(SharpTools.translation.getProperty("Row") + " " + Node.translateRow(i));
                    secondary.add(SharpTools.translation.getProperty("Row") + " " + Node.translateRow(i));
                }
            } else {
                for (i = range.getStartCol(); i <= range.getEndCol(); ++i) {
                    primary.add(SharpTools.translation.getProperty("Column") + " " + Node.translateColumn(i));
                    secondary.add(SharpTools.translation.getProperty("Column") + " " + Node.translateColumn(i));
                }
            }
            SortDialog sortDialog = new SortDialog(this.sharp, primary, secondary);
            sortDialog.pack();
            sortDialog.setLocationRelativeTo(this.sharp);
            sortDialog.setVisible(true);
            Debug.println("Here we go " + sortDialog.getCriteriaA() + ": And : " + sortDialog.getCriteriaB());
            Debug.println(sortDialog.firstAscending() + " : " + sortDialog.secondAscending());
            int first = sortDialog.getCriteriaA();
            if (first >= 0) {
                this.history.add(this.tableModel, range);
                first = byRow ? (first += range.getStartRow()) : (first += range.getStartCol());
                int second = sortDialog.getCriteriaB();
                if (second > 0) {
                    second = byRow ? (second += range.getStartRow() - 1) : (second += range.getStartCol() - 1);
                    this.tableModel.sort(range, first, second, byRow, sortDialog.firstAscending(), sortDialog.secondAscending());
                } else {
                    this.tableModel.sort(range, first, first, byRow, sortDialog.firstAscending(), sortDialog.secondAscending());
                }
            }
        } else {
            this.sharp.noCellsSelected(SharpTools.translation.getProperty("Sort"));
        }
    }

    public void setColumnWidth() {
        int width = !SharpTools.inapplet ? SharpTools.getConfig().getInt("COLUMNWIDTH") : MainApplet.COLUMNWIDTH;
        String inValue = JOptionPane.showInputDialog(SharpTools.translation.getProperty("Default_width") + "\n" + SharpTools.translation.getProperty("rem1") + ":");
        if (inValue != null) {
            try {
                int newwidth = Integer.parseInt(inValue, 10);
                if (newwidth != width && newwidth >= 0) {
                    if (!SharpTools.inapplet) {
                        SharpTools.getConfig().setInt("COLUMNWIDTH", newwidth);
                    }
                    this.sharp.setColumnWidth(newwidth);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setFirstColumnWidth() {
        int width = !SharpTools.inapplet ? SharpTools.getConfig().getInt("FIRSTCOLUMNWIDTH") : MainApplet.FIRSTCOLUMNWIDTH;
        String inValue = JOptionPane.showInputDialog(SharpTools.translation.getProperty("Default_width") + "\n" + SharpTools.translation.getProperty("rem2") + ":");
        if (inValue != null) {
            try {
                int newwidth = Integer.parseInt(inValue, 10);
                if (newwidth != width && newwidth >= 0) {
                    if (!SharpTools.inapplet) {
                        SharpTools.getConfig().setInt("FIRSTCOLUMNWIDTH", newwidth);
                    }
                    this.sharp.setBaseColumnWidth(newwidth);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int getColumnWidth() {
        int width = 0;
        return width;
    }

    private boolean unsafeDeletion() {
        int choice = SharpOptionPane.showOptionDialog(this.sharp, SharpTools.translation.getProperty("rem4") + "\n" + SharpTools.translation.getProperty("rem3") + "\n\n", SharpTools.translation.getProperty("Delete"), 0, 2, null, 1);
        return choice == 0;
    }

    private void tooMuchDeletion() {
        SharpOptionPane.showMessageDialog(this.sharp, SharpTools.translation.getProperty("rem5"), SharpTools.translation.getProperty("Delete"), 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().compareTo(SharpTools.translation.getProperty("Insert_Row")) == 0) {
            this.insert(true);
        } else if (e.getActionCommand().compareTo(SharpTools.translation.getProperty("Insert_Column")) == 0) {
            this.insert(false);
        } else if (e.getActionCommand().compareTo(SharpTools.translation.getProperty("Delete_Row")) == 0) {
            this.remove(true);
        } else if (e.getActionCommand().compareTo(SharpTools.translation.getProperty("Delete_Column")) == 0) {
            this.remove(false);
        }
    }
}

