/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.7
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */

#define SWIGJAVA

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__))
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__))
# else
#   define SWIGUNUSED
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#  ifndef GCC_HASCLASSVISIBILITY
#    define GCC_HASCLASSVISIBILITY
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif

/* Deal with Apple's deprecated 'AssertMacros.h' from Carbon-framework */
#if defined(__APPLE__) && !defined(__ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES)
# define __ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES 0
#endif

/* Intel's compiler complains if a variable which was never initialised is
 * cast to void, which is a common idiom which we use to indicate that we
 * are aware a variable isn't used.  So we just silence that warning.
 * See: https://github.com/swig/swig/issues/192 for more discussion.
 */
#ifdef __INTEL_COMPILER
# pragma warning disable 592
#endif


/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTEL_COMPILER)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" }
  };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  (*jenv)->ExceptionClear(jenv);
  excep = (*jenv)->FindClass(jenv, except_ptr->java_exception);
  if (excep)
    (*jenv)->ThrowNew(jenv, excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else


#include <stdint.h>		// Use the C99 official header


#include "wiredtiger.h"
#include "src/include/wt_internal.h"

/*
 * Closed handle checking:
 *
 * The typedef WT_CURSOR_NULLABLE used in wiredtiger.h is only made
 * visible to the SWIG parser and is used to identify arguments of
 * Cursor type that are permitted to be null.  Likewise, typedefs
 * WT_{CURSOR,SESSION,CONNECTION}_CLOSED identify 'close' calls that
 * need explicit nulling of the swigCPtr.  These typedefs permit
 * special casing in typemaps for input args.
 *
 * We want SWIG to see these 'fake' typenames, but not the compiler.
 */
#define WT_CURSOR_NULLABLE		WT_CURSOR
#define WT_CURSOR_CLOSED		WT_CURSOR
#define WT_SESSION_CLOSED		WT_SESSION
#define WT_CONNECTION_CLOSED		WT_CONNECTION

/*
 * For Connections, Sessions and Cursors created in Java, each of
 * WT_CONNECTION_IMPL, WT_SESSION_IMPL and WT_CURSOR have a
 * lang_private field that store a pointer to a JAVA_CALLBACK, alloced
 * during the various open calls.  {conn,session,cursor}CloseHandler()
 * functions reach into the associated java object, set the swigCPtr
 * to 0, and free the JAVA_CALLBACK. Typemaps matching Connection,
 * Session, Cursor args use the NULL_CHECK macro, which checks if
 * swigCPtr is 0.
 */
typedef struct {
	JavaVM *javavm;		/* Used in async threads to craft a jnienv */
	JNIEnv *jnienv;		/* jni env that created the Session/Cursor */
	WT_SESSION_IMPL *session; /* session used for alloc/free */
	bool cursor_raw;	/* is the cursor opened raw? */
	jobject jobj;		/* the java Session/Cursor/AsyncOp object */
	jobject jcallback;	/* callback object for async ops */
	jfieldID cptr_fid;	/* cached Cursor.swigCPtr field id in session */
	jfieldID asynccptr_fid;	/* cached AsyncOp.swigCptr fid in conn */
	jfieldID kunp_fid;	/* cached AsyncOp.keyUnpacker fid in conn */
	jfieldID vunp_fid;	/* cached AsyncOp.valueUnpacker fid in conn */
	jmethodID notify_mid;	/* cached AsyncCallback.notify mid in conn */
} JAVA_CALLBACK;

static void throwWiredTigerException(JNIEnv *jenv, int err) {
	const char *clname;
	jclass excep;

	clname = NULL;
	excep = NULL;
	if (err == WT_PANIC)
		clname = "com/wiredtiger/db/WiredTigerPanicException";
	else if (err == WT_ROLLBACK)
		clname = "com/wiredtiger/db/WiredTigerRollbackException";
	else
		clname = "com/wiredtiger/db/WiredTigerException";
	if (clname)
		excep = (*jenv)->FindClass(jenv, clname);
	if (excep)
		(*jenv)->ThrowNew(jenv, excep, wiredtiger_strerror(err));
}

struct __wt_java_modify_impl;
struct __wt_java_modify_list;
typedef struct __wt_java_modify_impl WT_MODIFY_IMPL;
typedef struct __wt_java_modify_list WT_MODIFY_LIST;
static void modify_impl_release(WT_MODIFY_IMPL *impl);
static void modify_list_release(WT_MODIFY_LIST *impl);

/*
 * An extension to the WT_MODIFY struct, so we can associate some Java-specific
 * information with it.
 */
typedef struct __wt_java_modify_impl {
	WT_MODIFY modify;
	JNIEnv *jnienv;
	jobject ref;
} WT_MODIFY_IMPL;



enum SearchStatus { FOUND, NOTFOUND, SMALLER, LARGER };


typedef struct __wt_java_item_hold {
#ifndef SWIG
	void *data;
	size_t size;
	JNIEnv *jnienv;
	jobject ref;
#endif
} WT_ITEM_HOLD;

/*
 * An internal Java class encapsulates a list of Modify objects (stored as a
 * WT_MODIFY array in C).
 */
typedef struct __wt_java_modify_list {
#ifndef SWIG
	WT_MODIFY *mod_array;
	jobject *ref_array;
	JNIEnv *jnienv;
	int count;
#endif
} WT_MODIFY_LIST;

SWIGINTERN struct __wt_java_modify_list *new___wt_java_modify_list(int count){
		WT_MODIFY_LIST *self;
		if (__wt_calloc_def(NULL, 1, &self) != 0)
			return (NULL);
		if (__wt_calloc_def(NULL, (size_t)count,
		    &self->mod_array) != 0) {
			__wt_free(NULL, self);
			return (NULL);
		}
		if (__wt_calloc_def(NULL, (size_t)count,
		    &self->ref_array) != 0) {
			__wt_free(NULL, self->mod_array);
			__wt_free(NULL, self);
			return (NULL);
		}
		self->count = count;
		return (self);
	}
SWIGINTERN void delete___wt_java_modify_list(struct __wt_java_modify_list *self){
		modify_list_release(self);
		__wt_free(NULL, self);
	}
SWIGINTERN void __wt_java_modify_list_set(struct __wt_java_modify_list *self,int i,WT_MODIFY *m){
		WT_MODIFY_IMPL *impl = (WT_MODIFY_IMPL *)m;
		self->mod_array[i] = *m;
		self->ref_array[i] = impl->ref;
		impl->ref = (jobject)0;
		self->jnienv = impl->jnienv;
	}

static void modify_list_release(WT_MODIFY_LIST *list) {
	for (int i = 0; i < list->count; i++)
		if (list->ref_array[i] != (jobject)0) {
			(*list->jnienv)->ReleaseByteArrayElements(
			    list->jnienv, list->ref_array[i],
			    (jbyte *)list->mod_array[i].data.data, 0);
			(*list->jnienv)->DeleteGlobalRef(
			    list->jnienv, list->ref_array[i]);
		}
	__wt_free(NULL, list->ref_array);
	__wt_free(NULL, list->mod_array);
	list->count = 0;
}

static void modify_impl_release(WT_MODIFY_IMPL *impl) {
	if (impl->ref != (jobject)0) {
		(*impl->jnienv)->ReleaseByteArrayElements(
		    impl->jnienv, impl->ref,
		    (jbyte *)impl->modify.data.data, 0);
		(*impl->jnienv)->DeleteGlobalRef(impl->jnienv, impl->ref);
		impl->ref = (jobject)0;
	}
}

SWIGINTERN struct __wt_modify *new___wt_modify__SWIG_0(void){
		WT_MODIFY_IMPL *self;
		if (__wt_calloc_def(NULL, 1, &self) != 0)
			return (NULL);
		self->modify.data.data = NULL;
		self->modify.data.size = 0;
		self->modify.offset = 0;
		self->modify.size = 0;
		return (&self->modify);
	}
SWIGINTERN struct __wt_modify *new___wt_modify__SWIG_1(WT_ITEM_HOLD *itemdata,size_t offset,size_t size){
		WT_MODIFY_IMPL *self;
		if (__wt_calloc_def(NULL, 1, &self) != 0)
			return (NULL);
		self->modify.data.data = itemdata->data;
		self->modify.data.size = itemdata->size;
		self->modify.offset = offset;
		self->modify.size = size;
		self->ref = itemdata->ref;
		self->jnienv = itemdata->jnienv;
		return (&self->modify);
	}
SWIGINTERN void delete___wt_modify(struct __wt_modify *self){
		modify_impl_release((WT_MODIFY_IMPL *)self);
		__wt_free(NULL, self);
	}
SWIGINTERN WT_ITEM __wt_cursor_get_key_wrap(struct __wt_cursor *self,JNIEnv *jenv){
		WT_ITEM k;
		int ret;
		k.data = NULL;
		if ((ret = self->get_key(self, &k)) != 0)
			throwWiredTigerException(jenv, ret);
		return (k);
	}
SWIGINTERN WT_ITEM __wt_cursor_get_value_wrap(struct __wt_cursor *self,JNIEnv *jenv){
		WT_ITEM v;
		int ret;
		v.data = NULL;
		if ((ret = self->get_value(self, &v)) != 0)
			throwWiredTigerException(jenv, ret);
		return (v);
	}
SWIGINTERN int __wt_cursor_insert_wrap(struct __wt_cursor *self,WT_ITEM *k,WT_ITEM *v){
		self->set_key(self, k);
		self->set_value(self, v);
		return (self->insert(self));
	}
SWIGINTERN int __wt_cursor_remove_wrap(struct __wt_cursor *self,WT_ITEM *k){
		self->set_key(self, k);
		return (self->remove(self));
	}
SWIGINTERN int __wt_cursor_reset_wrap(struct __wt_cursor *self){
		return self->reset(self);
	}
SWIGINTERN int __wt_cursor_search_wrap(struct __wt_cursor *self,WT_ITEM *k){
		self->set_key(self, k);
		return (self->search(self));
	}
SWIGINTERN enum SearchStatus __wt_cursor_search_near_wrap(struct __wt_cursor *self,JNIEnv *jenv,WT_ITEM *k){
		int cmp, ret;

		self->set_key(self, k);
		ret = self->search_near(self, &cmp);
		if (ret != 0 && ret != WT_NOTFOUND)
			throwWiredTigerException(jenv, ret);
		if (ret == 0)
			return (cmp == 0 ? FOUND : cmp < 0 ? SMALLER : LARGER);
		return (NOTFOUND);
	}
SWIGINTERN int __wt_cursor_update_wrap(struct __wt_cursor *self,WT_ITEM *k,WT_ITEM *v){
		self->set_key(self, k);
		self->set_value(self, v);
		return (self->update(self));
	}
SWIGINTERN int __wt_cursor_compare_wrap(struct __wt_cursor *self,JNIEnv *jenv,WT_CURSOR *other){
		int cmp, ret = self->compare(self, other, &cmp);
		if (ret != 0)
			throwWiredTigerException(jenv, ret);
		return (cmp);
	}
SWIGINTERN int __wt_cursor_equals_wrap(struct __wt_cursor *self,JNIEnv *jenv,WT_CURSOR *other){
		int cmp, ret = self->equals(self, other, &cmp);
		if (ret != 0)
			throwWiredTigerException(jenv, ret);
		return (cmp);
	}
SWIGINTERN bool __wt_cursor__java_raw(struct __wt_cursor *self,JNIEnv *jenv){
		(void)jenv;
		JAVA_CALLBACK *jcb = (JAVA_CALLBACK *)self->lang_private;
		return (jcb->cursor_raw);
	}
SWIGINTERN int __wt_cursor__java_init(struct __wt_cursor *self,jobject jcursor){
		JAVA_CALLBACK *jcb = (JAVA_CALLBACK *)self->lang_private;
		jcb->jobj = (*jcb->jnienv)->NewGlobalRef(jcb->jnienv, jcursor);
		(*jcb->jnienv)->DeleteLocalRef(jcb->jnienv, jcursor);
		return (0);
	}
SWIGINTERN int __wt_cursor_modify_wrap(struct __wt_cursor *self,WT_MODIFY_LIST *list,WT_ITEM *k){
		int ret;

		self->set_key(self, k);
		ret = self->modify(self, list->mod_array, list->count);
		modify_list_release(list);
		return (ret);
	}
SWIGINTERN bool __wt_cursor__new_check_modify_list(struct __wt_cursor *self,WT_MODIFY_LIST *list){
		JAVA_CALLBACK *jcb;
		if (list == NULL) {
			jcb = (JAVA_CALLBACK *)self->lang_private;
			throwWiredTigerException(jcb->jnienv, ENOMEM);
			return (false);
		}
		return (true);
	}
SWIGINTERN bool __wt_cursor__new_check_modify(struct __wt_cursor *self,WT_MODIFY *mod){
		JAVA_CALLBACK *jcb;
		if (mod == NULL) {
			jcb = (JAVA_CALLBACK *)self->lang_private;
			throwWiredTigerException(jcb->jnienv, ENOMEM);
			return (false);
		}
		return (true);
	}
SWIGINTERN WT_ITEM __wt_async_op_get_key_wrap(struct __wt_async_op *self,JNIEnv *jenv){
		WT_ITEM k;
		int ret;
		k.data = NULL;
		if ((ret = self->get_key(self, &k)) != 0)
			throwWiredTigerException(jenv, ret);
		return (k);
	}
SWIGINTERN WT_ITEM __wt_async_op_get_value_wrap(struct __wt_async_op *self,JNIEnv *jenv){
		WT_ITEM v;
		int ret;
		v.data = NULL;
		if ((ret = self->get_value(self, &v)) != 0)
			throwWiredTigerException(jenv, ret);
		return (v);
	}
SWIGINTERN int __wt_async_op_insert_wrap(struct __wt_async_op *self,WT_ITEM *k,WT_ITEM *v){
		self->set_key(self, k);
		self->set_value(self, v);
		return (self->insert(self));
	}
SWIGINTERN int __wt_async_op_remove_wrap(struct __wt_async_op *self,WT_ITEM *k){
		self->set_key(self, k);
		return (self->remove(self));
	}
SWIGINTERN int __wt_async_op_search_wrap(struct __wt_async_op *self,WT_ITEM *k){
		self->set_key(self, k);
		return (self->search(self));
	}
SWIGINTERN int __wt_async_op_update_wrap(struct __wt_async_op *self,WT_ITEM *k,WT_ITEM *v){
		self->set_key(self, k);
		self->set_value(self, v);
		return (self->update(self));
	}
SWIGINTERN bool __wt_async_op__java_raw(struct __wt_async_op *self,JNIEnv *jenv){
		(void)jenv;
		JAVA_CALLBACK *jcb = (JAVA_CALLBACK *)self->c.lang_private;
		return (jcb->cursor_raw);
	}
SWIGINTERN int __wt_async_op__java_init(struct __wt_async_op *self,jobject jasyncop){
		JAVA_CALLBACK *jcb =
		    (JAVA_CALLBACK *)self->c.lang_private;
		jcb->jobj = (*jcb->jnienv)->NewGlobalRef(jcb->jnienv, jasyncop);
		(*jcb->jnienv)->DeleteLocalRef(jcb->jnienv, jasyncop);
		return (0);
	}
SWIGINTERN long __wt_async_op_get_id_wrap(struct __wt_async_op *self,JNIEnv *jenv){
		WT_UNUSED(jenv);
		return ((long)self->get_id(self));
	}
SWIGINTERN int __wt_session__java_init(struct __wt_session *self,jobject jsess){
		WT_SESSION_IMPL *session = (WT_SESSION_IMPL *)self;
		JAVA_CALLBACK *jcb = (JAVA_CALLBACK *)session->lang_private;
		jcb->jobj = (*jcb->jnienv)->NewGlobalRef(jcb->jnienv, jsess);
		(*jcb->jnienv)->DeleteLocalRef(jcb->jnienv, jsess);
		return (0);
	}
SWIGINTERN WT_CURSOR *__wt_session_open_cursor_wrap(struct __wt_session *self,JNIEnv *jenv,char const *uri,WT_CURSOR_NULLABLE *to_dup,char const *config){
		WT_CURSOR *cursor = NULL;
		JAVA_CALLBACK *jcb;
		int ret;

		if ((ret = self->open_cursor(self, uri, to_dup, config, &cursor)) != 0)
			goto err;

		if ((ret = __wt_calloc_def((WT_SESSION_IMPL *)cursor->session,
			    1, &jcb)) != 0)
			goto err;

		if ((cursor->flags & WT_CURSTD_RAW) != 0)
			jcb->cursor_raw = true;
		if ((cursor->flags & WT_CURSTD_DUMP_JSON) == 0)
			cursor->flags |= WT_CURSTD_RAW;

		jcb->jnienv = jenv;
		jcb->session = (WT_SESSION_IMPL *)cursor->session;
		cursor->lang_private = jcb;

err:		if (ret != 0)
			throwWiredTigerException(jenv, ret);
		return (cursor);
	}
SWIGINTERN long __wt_session_transaction_pinned_range_wrap(struct __wt_session *self,JNIEnv *jenv){
		int ret;
		uint64_t range = 0;
		ret = self->transaction_pinned_range(self, &range);
		if (ret != 0)
			throwWiredTigerException(jenv, ret);
		return ((long)range);
	}
SWIGINTERN int __wt_connection__java_init(struct __wt_connection *self,jobject jsess){
		WT_CONNECTION_IMPL *session = (WT_CONNECTION_IMPL *)self;
		JAVA_CALLBACK *jcb = (JAVA_CALLBACK *)session->lang_private;
		jcb->jobj = (*jcb->jnienv)->NewGlobalRef(jcb->jnienv, jsess);
		(*jcb->jnienv)->DeleteLocalRef(jcb->jnienv, jsess);
		return (0);
	}
SWIGINTERN WT_ASYNC_OP *__wt_connection_async_new_op_wrap(struct __wt_connection *self,JNIEnv *jenv,char const *uri,char const *config,jobject callbackObject){
		extern WT_ASYNC_CALLBACK javaApiAsyncHandler;
		WT_ASYNC_OP *asyncop = NULL;
		WT_CONNECTION_IMPL *connimpl;
		JAVA_CALLBACK *jcb;
		int ret;

		if ((ret = self->async_new_op(self, uri, config, &javaApiAsyncHandler, &asyncop)) != 0)
			goto err;

		connimpl = (WT_CONNECTION_IMPL *)self;
		if ((ret = __wt_calloc_def(connimpl->default_session, 1, &jcb)) != 0)
			goto err;

		jcb->jnienv = jenv;
		jcb->session = connimpl->default_session;
		(*jenv)->GetJavaVM(jenv, &jcb->javavm);
		jcb->jcallback = (*jenv)->NewGlobalRef(jenv, callbackObject);
		(*jenv)->DeleteLocalRef(jenv, callbackObject);
		asyncop->c.lang_private = jcb;
		asyncop->c.flags |= WT_CURSTD_RAW;

err:		if (ret != 0)
			throwWiredTigerException(jenv, ret);
		return (asyncop);
	}
SWIGINTERN WT_SESSION *__wt_connection_open_session_wrap(struct __wt_connection *self,JNIEnv *jenv,char const *config){
		extern WT_EVENT_HANDLER javaApiEventHandler;
		WT_SESSION *session = NULL;
		WT_SESSION_IMPL *sessionimpl;
		JAVA_CALLBACK *jcb;
		int ret;

		if ((ret = self->open_session(self, &javaApiEventHandler, config, &session)) != 0)
			goto err;

		sessionimpl = (WT_SESSION_IMPL *)session;
		if ((ret = __wt_calloc_def(sessionimpl, 1, &jcb)) != 0)
			goto err;

		jcb->jnienv = jenv;
		sessionimpl->lang_private = jcb;

err:		if (ret != 0)
			throwWiredTigerException(jenv, ret);
		return (session);
	}

WT_CONNECTION *wiredtiger_open_wrap(JNIEnv *jenv, const char *home, const char *config) {
	extern WT_EVENT_HANDLER javaApiEventHandler;
	WT_CONNECTION *conn = NULL;
	WT_CONNECTION_IMPL *connimpl;
	JAVA_CALLBACK *jcb;
	int ret;
	if ((ret = wiredtiger_open(home, &javaApiEventHandler, config, &conn)) != 0)
		goto err;

	connimpl = (WT_CONNECTION_IMPL *)conn;
	if ((ret = __wt_calloc_def(connimpl->default_session, 1, &jcb)) != 0)
		goto err;

	jcb->jnienv = jenv;
	connimpl->lang_private = jcb;

err:	if (ret != 0)
		throwWiredTigerException(jenv, ret);
	return (conn);
}


#ifdef __cplusplus
extern "C" {
#endif


/* Zero out SWIG's pointer to the C object,
 * equivalent to 'jobj.swigCPtr = 0;' in java.
 * We expect that either env in non-null (if called
 * via an explicit session/cursor close() call), or
 * that session is non-null (if called implicitly
 * as part of connection/session close).
 */
static int
javaClose(JNIEnv *env, WT_SESSION *session, JAVA_CALLBACK *jcb, jfieldID *pfid)
{
	jclass cls;
	jfieldID fid;
	WT_CONNECTION_IMPL *conn;

	/* If we were not called via an implicit close call,
	 * we won't have a JNIEnv yet.  Get one from the connection,
	 * since the thread that started the session may have
	 * terminated.
	 */
	if (env == NULL) {
		conn = (WT_CONNECTION_IMPL *)session->connection;
		env = ((JAVA_CALLBACK *)conn->lang_private)->jnienv;
	}
	if (pfid == NULL || *pfid == NULL) {
		cls = (*env)->GetObjectClass(env, jcb->jobj);
		fid = (*env)->GetFieldID(env, cls, "swigCPtr", "J");
		if (pfid != NULL)
			*pfid = fid;
	} else
		fid = *pfid;

	(*env)->SetLongField(env, jcb->jobj, fid, 0L);
	(*env)->DeleteGlobalRef(env, jcb->jobj);
	__wt_free(jcb->session, jcb);
	return (0);
}

/* Connection and Session close handler. */
static int
closeHandler(JNIEnv *env, WT_SESSION *session, JAVA_CALLBACK *jcb)
{
	return (javaClose(env, session, jcb, NULL));
}

/* Cursor specific close handler. */
static int
cursorCloseHandler(JNIEnv *env, WT_SESSION *wt_session, JAVA_CALLBACK *jcb)
{
	int ret;
	JAVA_CALLBACK *sess_jcb;
	WT_SESSION_IMPL *session;

	session = (WT_SESSION_IMPL *)wt_session;
	sess_jcb = (JAVA_CALLBACK *)session->lang_private;
	ret = javaClose(env, wt_session, jcb,
	    sess_jcb ? &sess_jcb->cptr_fid : NULL);

	return (ret);
}

/* Add event handler support. */
static int
javaCloseHandler(WT_EVENT_HANDLER *handler, WT_SESSION *session,
	WT_CURSOR *cursor)
{
	int ret;
	JAVA_CALLBACK *jcb;

	WT_UNUSED(handler);

	ret = 0;
	if (cursor != NULL) {
		if ((jcb = (JAVA_CALLBACK *)cursor->lang_private) != NULL) {
			ret = cursorCloseHandler(NULL, session, jcb);
			cursor->lang_private = NULL;
		}
	} else if ((jcb = ((WT_SESSION_IMPL *)session)->lang_private) != NULL) {
		ret = closeHandler(NULL, session, jcb);
		((WT_SESSION_IMPL *)session)->lang_private = NULL;
	}
	return (ret);
}

WT_EVENT_HANDLER javaApiEventHandler = {NULL, NULL, NULL, javaCloseHandler};

static int
javaAsyncHandler(WT_ASYNC_CALLBACK *cb, WT_ASYNC_OP *asyncop, int opret,
    uint32_t flags)
{
	int ret, envret;
	JAVA_CALLBACK *jcb, *conn_jcb;
	JavaVM *javavm;
	jclass cls;
	jfieldID fid;
	jmethodID mid;
	jobject jcallback;
	JNIEnv *jenv;
	WT_ASYNC_OP_IMPL *op;
	WT_SESSION_IMPL *session;

	WT_UNUSED(cb);
	WT_UNUSED(flags);
	op = (WT_ASYNC_OP_IMPL *)asyncop;
	session = O2S(op);
	jcb = (JAVA_CALLBACK *)asyncop->c.lang_private;
	conn_jcb = (JAVA_CALLBACK *)S2C(session)->lang_private;
	asyncop->c.lang_private = NULL;
	jcallback = jcb->jcallback;

	/*
	 * We rely on the fact that the async machinery uses a pool of
	 * threads.  Here we attach the current native (POSIX)
	 * thread to a Java thread and never detach it.  If the native
	 * thread was previously seen by this callback, it will be
	 * attached to the same Java thread as before without
	 * incurring the cost of the thread initialization.
	 * Marking the Java thread as a daemon means its existence
	 * won't keep an application from exiting.
	 */
	javavm = jcb->javavm;
	envret = (*javavm)->GetEnv(javavm, (void **)&jenv, JNI_VERSION_1_6);
	if (envret == JNI_EDETACHED) {
		if ((*javavm)->AttachCurrentThreadAsDaemon(javavm,
		    (void **)&jenv, NULL) != 0) {
			ret = EBUSY;
			goto err;
		}
	} else if (envret != JNI_OK) {
		ret = EBUSY;
		goto err;
	}

	/*
	 * Look up any needed field and method ids, and cache them
	 * in the connection's lang_private.  fid and mids are
	 * stable.
	 */
	if (conn_jcb->notify_mid == NULL) {
		/* Any JNI error until the actual callback is unexpected. */
		ret = EINVAL;

		cls = (*jenv)->GetObjectClass(jenv, jcb->jobj);
		if (cls == NULL)
			goto err;
		fid = (*jenv)->GetFieldID(jenv, cls,
		    "keyUnpacker", "Lcom/wiredtiger/db/PackInputStream;");
		if (fid == NULL)
			goto err;
		conn_jcb->kunp_fid = fid;

		fid = (*jenv)->GetFieldID(jenv, cls,
		    "valueUnpacker", "Lcom/wiredtiger/db/PackInputStream;");
		if (fid == NULL)
			goto err;
		conn_jcb->vunp_fid = fid;

		cls = (*jenv)->GetObjectClass(jenv, jcallback);
		if (cls == NULL)
			goto err;
		mid = (*jenv)->GetMethodID(jenv, cls, "notify",
		    "(Lcom/wiredtiger/db/AsyncOp;II)I");
		if (mid == NULL)
			goto err;
		conn_jcb->notify_mid = mid;
	}

	/*
	 * Invalidate the unpackers so any calls to op.getKey()
	 * and op.getValue get fresh results.
	 */
	(*jenv)->SetObjectField(jenv, jcb->jobj, conn_jcb->kunp_fid, NULL);
	(*jenv)->SetObjectField(jenv, jcb->jobj, conn_jcb->vunp_fid, NULL);

	/* Call the registered callback. */
	ret = (*jenv)->CallIntMethod(jenv, jcallback, conn_jcb->notify_mid,
	    jcb->jobj, opret, flags);

	if ((*jenv)->ExceptionOccurred(jenv)) {
		(*jenv)->ExceptionDescribe(jenv);
		(*jenv)->ExceptionClear(jenv);
	}
	if (0) {
err:		__wt_err(session, ret, "Java async callback error");
	}

	/* Invalidate the AsyncOp, further use throws NullPointerException. */
	ret = javaClose(jenv, NULL, jcb, &conn_jcb->asynccptr_fid);

	(*jenv)->DeleteGlobalRef(jenv, jcallback);

	if (ret == 0 && (opret == 0 || opret == WT_NOTFOUND))
		return (0);
	else
		return (1);
}

WT_ASYNC_CALLBACK javaApiAsyncHandler = {javaAsyncHandler};

SWIGEXPORT jlong JNICALL Java_com_wiredtiger_db_wiredtigerJNI_new_1WT_1MODIFY_1LIST(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  struct __wt_java_modify_list *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (struct __wt_java_modify_list *)new___wt_java_modify_list(arg1);
  *(struct __wt_java_modify_list **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_wiredtiger_db_wiredtigerJNI_delete_1WT_1MODIFY_1LIST(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  struct __wt_java_modify_list *arg1 = (struct __wt_java_modify_list *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct __wt_java_modify_list **)&jarg1; 
  delete___wt_java_modify_list(arg1);
}


SWIGEXPORT void JNICALL Java_com_wiredtiger_db_wiredtigerJNI_WT_1MODIFY_1LIST_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  struct __wt_java_modify_list *arg1 = (struct __wt_java_modify_list *) 0 ;
  int arg2 ;
  WT_MODIFY *arg3 = (WT_MODIFY *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(struct __wt_java_modify_list **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = *(WT_MODIFY **)&jarg3; 
  __wt_java_modify_list_set(arg1,arg2,arg3);
}


SWIGEXPORT void JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Modify_1offset_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  struct __wt_modify *arg1 = (struct __wt_modify *) 0 ;
  size_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct __wt_modify **)&jarg1; 
  arg2 = (size_t)jarg2; 
  if (arg1) (arg1)->offset = arg2;
}


SWIGEXPORT jlong JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Modify_1offset_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  struct __wt_modify *arg1 = (struct __wt_modify *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct __wt_modify **)&jarg1; 
  result =  ((arg1)->offset);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_wiredtiger_db_wiredtigerJNI_new_1Modify_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  struct __wt_modify *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (struct __wt_modify *)new___wt_modify__SWIG_0();
  *(struct __wt_modify **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_wiredtiger_db_wiredtigerJNI_new_1Modify_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jbyteArray jarg1, jlong jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  WT_ITEM_HOLD *arg1 = (WT_ITEM_HOLD *) 0 ;
  size_t arg2 ;
  size_t arg3 ;
  WT_ITEM_HOLD item1 ;
  struct __wt_modify *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  arg1 = &item1;
  arg1->data = (*jenv)->GetByteArrayElements(jenv, jarg1, 0);
  arg1->size = (size_t)(*jenv)->GetArrayLength(jenv, jarg1);
  arg1->jnienv = jenv;
  arg1->ref = (*jenv)->NewGlobalRef(jenv, jarg1);
  
  arg2 = (size_t)jarg2; 
  arg3 = (size_t)jarg3; 
  result = (struct __wt_modify *)new___wt_modify__SWIG_1(arg1,arg2,arg3);
  *(struct __wt_modify **)&jresult = result; 
  
  /* Explicitly don't release the byte array elements here. */
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_wiredtiger_db_wiredtigerJNI_delete_1Modify(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  struct __wt_modify *arg1 = (struct __wt_modify *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct __wt_modify **)&jarg1; 
  delete___wt_modify(arg1);
}


SWIGEXPORT jlong JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Cursor_1session_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  struct __wt_cursor *arg1 = (struct __wt_cursor *) 0 ;
  WT_SESSION *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  {
    arg1 = *(struct __wt_cursor **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  result = (WT_SESSION *) ((arg1)->session);
  *(WT_SESSION **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Cursor_1uri_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  struct __wt_cursor *arg1 = (struct __wt_cursor *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  {
    arg1 = *(struct __wt_cursor **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  result = (char *) ((arg1)->uri);
  if (result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Cursor_1key_1format_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  struct __wt_cursor *arg1 = (struct __wt_cursor *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  {
    arg1 = *(struct __wt_cursor **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  result = (char *) ((arg1)->key_format);
  if (result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Cursor_1value_1format_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  struct __wt_cursor *arg1 = (struct __wt_cursor *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  {
    arg1 = *(struct __wt_cursor **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  result = (char *) ((arg1)->value_format);
  if (result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Cursor_1next_1wrap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct __wt_cursor *arg1 = (struct __wt_cursor *) 0 ;
  WT_CURSOR *arg2 = (WT_CURSOR *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  {
    arg2 = *(struct __wt_cursor **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "cursor" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_cursor **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  {
    result = (int)(arg1)->next(arg2);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Cursor_1prev_1wrap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct __wt_cursor *arg1 = (struct __wt_cursor *) 0 ;
  WT_CURSOR *arg2 = (WT_CURSOR *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  {
    arg2 = *(struct __wt_cursor **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "cursor" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_cursor **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  {
    result = (int)(arg1)->prev(arg2);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Cursor_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct __wt_cursor *arg1 = (struct __wt_cursor *) 0 ;
  WT_CURSOR *arg2 = (WT_CURSOR *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  {
    arg2 = *(struct __wt_cursor **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "cursor" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_cursor **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  {
    result = (int)(arg1)->reserve(arg2);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Cursor_1close(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct __wt_cursor *arg1 = (struct __wt_cursor *) 0 ;
  WT_CURSOR_CLOSED *arg2 = (WT_CURSOR_CLOSED *) 0 ;
  WT_SESSION *savesess2 ;
  JAVA_CALLBACK *jcb2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  {
    arg2 = *(struct __wt_cursor **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "cursor" " is null");
      return (0);
    }
    /*@SWIG@*/
    savesess2 = arg2->session;
    jcb2 = (JAVA_CALLBACK *)(((WT_CURSOR *)arg2)->lang_private);
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_cursor **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  {
    result = (int)(arg1)->close(arg2);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  {
    cursorCloseHandler(jenv, savesess2, jcb2);
  }
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Cursor_1reconfigure(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg3) {
  jint jresult = 0 ;
  struct __wt_cursor *arg1 = (struct __wt_cursor *) 0 ;
  WT_CURSOR *arg2 = (WT_CURSOR *) 0 ;
  char *arg3 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg3 = NULL; 
  {
    arg2 = *(struct __wt_cursor **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "cursor" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_cursor **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  {
    result = (int)(arg1)->reconfigure(arg2,(char const *)arg3);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jbyteArray JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Cursor_1get_1key_1wrap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jbyteArray jresult = 0 ;
  struct __wt_cursor *arg1 = (struct __wt_cursor *) 0 ;
  JNIEnv *arg2 = (JNIEnv *) 0 ;
  WT_ITEM result;
  
  (void)jenv;
  (void)jcls;
  arg2 = jenv; 
  (void)jarg1_;
  {
    arg1 = *(struct __wt_cursor **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  result = __wt_cursor_get_key_wrap(arg1,arg2);
  
  if ((&result)->data == NULL)
  jresult = NULL;
  else if ((jresult = (*jenv)->NewByteArray(jenv, (jsize)(&result)->size)) != NULL) {
    (*jenv)->SetByteArrayRegion(jenv,
      jresult, 0, (jsize)(&result)->size, (&result)->data);
  }
  
  return jresult;
}


SWIGEXPORT jbyteArray JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Cursor_1get_1value_1wrap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jbyteArray jresult = 0 ;
  struct __wt_cursor *arg1 = (struct __wt_cursor *) 0 ;
  JNIEnv *arg2 = (JNIEnv *) 0 ;
  WT_ITEM result;
  
  (void)jenv;
  (void)jcls;
  arg2 = jenv; 
  (void)jarg1_;
  {
    arg1 = *(struct __wt_cursor **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  result = __wt_cursor_get_value_wrap(arg1,arg2);
  
  if ((&result)->data == NULL)
  jresult = NULL;
  else if ((jresult = (*jenv)->NewByteArray(jenv, (jsize)(&result)->size)) != NULL) {
    (*jenv)->SetByteArrayRegion(jenv,
      jresult, 0, (jsize)(&result)->size, (&result)->data);
  }
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Cursor_1insert_1wrap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jbyteArray jarg3) {
  jint jresult = 0 ;
  struct __wt_cursor *arg1 = (struct __wt_cursor *) 0 ;
  WT_ITEM *arg2 = (WT_ITEM *) 0 ;
  WT_ITEM *arg3 = (WT_ITEM *) 0 ;
  WT_ITEM item2 ;
  WT_ITEM item3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  {
    arg1 = *(struct __wt_cursor **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  
  arg2 = &item2;
  arg2->data = (*jenv)->GetByteArrayElements(jenv, jarg2, 0);
  arg2->size = (size_t)(*jenv)->GetArrayLength(jenv, jarg2);
  
  
  arg3 = &item3;
  arg3->data = (*jenv)->GetByteArrayElements(jenv, jarg3, 0);
  arg3->size = (size_t)(*jenv)->GetArrayLength(jenv, jarg3);
  
  result = (int)__wt_cursor_insert_wrap(arg1,arg2,arg3);
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  
  (*jenv)->ReleaseByteArrayElements(jenv, jarg2, (void *)arg2->data, 0);
  
  
  (*jenv)->ReleaseByteArrayElements(jenv, jarg3, (void *)arg3->data, 0);
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Cursor_1remove_1wrap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2) {
  jint jresult = 0 ;
  struct __wt_cursor *arg1 = (struct __wt_cursor *) 0 ;
  WT_ITEM *arg2 = (WT_ITEM *) 0 ;
  WT_ITEM item2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  {
    arg1 = *(struct __wt_cursor **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  
  arg2 = &item2;
  arg2->data = (*jenv)->GetByteArrayElements(jenv, jarg2, 0);
  arg2->size = (size_t)(*jenv)->GetArrayLength(jenv, jarg2);
  
  result = (int)__wt_cursor_remove_wrap(arg1,arg2);
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  
  (*jenv)->ReleaseByteArrayElements(jenv, jarg2, (void *)arg2->data, 0);
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Cursor_1reset_1wrap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct __wt_cursor *arg1 = (struct __wt_cursor *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  {
    arg1 = *(struct __wt_cursor **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  result = (int)__wt_cursor_reset_wrap(arg1);
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Cursor_1search_1wrap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2) {
  jint jresult = 0 ;
  struct __wt_cursor *arg1 = (struct __wt_cursor *) 0 ;
  WT_ITEM *arg2 = (WT_ITEM *) 0 ;
  WT_ITEM item2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  {
    arg1 = *(struct __wt_cursor **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  
  arg2 = &item2;
  arg2->data = (*jenv)->GetByteArrayElements(jenv, jarg2, 0);
  arg2->size = (size_t)(*jenv)->GetArrayLength(jenv, jarg2);
  
  result = (int)__wt_cursor_search_wrap(arg1,arg2);
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  
  (*jenv)->ReleaseByteArrayElements(jenv, jarg2, (void *)arg2->data, 0);
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Cursor_1search_1near_1wrap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg3) {
  jint jresult = 0 ;
  struct __wt_cursor *arg1 = (struct __wt_cursor *) 0 ;
  JNIEnv *arg2 = (JNIEnv *) 0 ;
  WT_ITEM *arg3 = (WT_ITEM *) 0 ;
  WT_ITEM item3 ;
  enum SearchStatus result;
  
  (void)jenv;
  (void)jcls;
  arg2 = jenv; 
  (void)jarg1_;
  {
    arg1 = *(struct __wt_cursor **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  
  arg3 = &item3;
  arg3->data = (*jenv)->GetByteArrayElements(jenv, jarg3, 0);
  arg3->size = (size_t)(*jenv)->GetArrayLength(jenv, jarg3);
  
  result = (enum SearchStatus)__wt_cursor_search_near_wrap(arg1,arg2,arg3);
  jresult = (jint)result; 
  
  (*jenv)->ReleaseByteArrayElements(jenv, jarg3, (void *)arg3->data, 0);
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Cursor_1update_1wrap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jbyteArray jarg3) {
  jint jresult = 0 ;
  struct __wt_cursor *arg1 = (struct __wt_cursor *) 0 ;
  WT_ITEM *arg2 = (WT_ITEM *) 0 ;
  WT_ITEM *arg3 = (WT_ITEM *) 0 ;
  WT_ITEM item2 ;
  WT_ITEM item3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  {
    arg1 = *(struct __wt_cursor **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  
  arg2 = &item2;
  arg2->data = (*jenv)->GetByteArrayElements(jenv, jarg2, 0);
  arg2->size = (size_t)(*jenv)->GetArrayLength(jenv, jarg2);
  
  
  arg3 = &item3;
  arg3->data = (*jenv)->GetByteArrayElements(jenv, jarg3, 0);
  arg3->size = (size_t)(*jenv)->GetArrayLength(jenv, jarg3);
  
  result = (int)__wt_cursor_update_wrap(arg1,arg2,arg3);
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  
  (*jenv)->ReleaseByteArrayElements(jenv, jarg2, (void *)arg2->data, 0);
  
  
  (*jenv)->ReleaseByteArrayElements(jenv, jarg3, (void *)arg3->data, 0);
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Cursor_1compare_1wrap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg3, jobject jarg3_) {
  jint jresult = 0 ;
  struct __wt_cursor *arg1 = (struct __wt_cursor *) 0 ;
  JNIEnv *arg2 = (JNIEnv *) 0 ;
  WT_CURSOR *arg3 = (WT_CURSOR *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg2 = jenv; 
  (void)jarg1_;
  (void)jarg3_;
  {
    arg1 = *(struct __wt_cursor **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  {
    arg3 = *(struct __wt_cursor **)&jarg3;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "other" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  result = (int)__wt_cursor_compare_wrap(arg1,arg2,arg3);
  
  jresult = result;
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Cursor_1equals_1wrap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg3, jobject jarg3_) {
  jint jresult = 0 ;
  struct __wt_cursor *arg1 = (struct __wt_cursor *) 0 ;
  JNIEnv *arg2 = (JNIEnv *) 0 ;
  WT_CURSOR *arg3 = (WT_CURSOR *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg2 = jenv; 
  (void)jarg1_;
  (void)jarg3_;
  {
    arg1 = *(struct __wt_cursor **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  {
    arg3 = *(struct __wt_cursor **)&jarg3;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "other" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  result = (int)__wt_cursor_equals_wrap(arg1,arg2,arg3);
  
  jresult = result;
  
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Cursor_1_1java_1raw(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  struct __wt_cursor *arg1 = (struct __wt_cursor *) 0 ;
  JNIEnv *arg2 = (JNIEnv *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg2 = jenv; 
  (void)jarg1_;
  {
    arg1 = *(struct __wt_cursor **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  result = (bool)__wt_cursor__java_raw(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Cursor_1_1java_1init(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jint jresult = 0 ;
  struct __wt_cursor *arg1 = (struct __wt_cursor *) 0 ;
  jobject arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  {
    arg1 = *(struct __wt_cursor **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg2 = jarg2; 
  result = (int)__wt_cursor__java_init(arg1,arg2);
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Cursor_1modify_1wrap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jbyteArray jarg3) {
  jint jresult = 0 ;
  struct __wt_cursor *arg1 = (struct __wt_cursor *) 0 ;
  WT_MODIFY_LIST *arg2 = (WT_MODIFY_LIST *) 0 ;
  WT_ITEM *arg3 = (WT_ITEM *) 0 ;
  WT_ITEM item3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  {
    arg1 = *(struct __wt_cursor **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg2 = *(WT_MODIFY_LIST **)&jarg2; 
  
  arg3 = &item3;
  arg3->data = (*jenv)->GetByteArrayElements(jenv, jarg3, 0);
  arg3->size = (size_t)(*jenv)->GetArrayLength(jenv, jarg3);
  
  result = (int)__wt_cursor_modify_wrap(arg1,arg2,arg3);
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  
  (*jenv)->ReleaseByteArrayElements(jenv, jarg3, (void *)arg3->data, 0);
  
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Cursor_1_1new_1check_1modify_1list(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  struct __wt_cursor *arg1 = (struct __wt_cursor *) 0 ;
  WT_MODIFY_LIST *arg2 = (WT_MODIFY_LIST *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  {
    arg1 = *(struct __wt_cursor **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg2 = *(WT_MODIFY_LIST **)&jarg2; 
  result = (bool)__wt_cursor__new_check_modify_list(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Cursor_1_1new_1check_1modify(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  struct __wt_cursor *arg1 = (struct __wt_cursor *) 0 ;
  WT_MODIFY *arg2 = (WT_MODIFY *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  {
    arg1 = *(struct __wt_cursor **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg2 = *(WT_MODIFY **)&jarg2; 
  result = (bool)__wt_cursor__new_check_modify(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_wiredtiger_db_wiredtigerJNI_AsyncOp_1connection_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  struct __wt_async_op *arg1 = (struct __wt_async_op *) 0 ;
  WT_CONNECTION *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  {
    arg1 = *(struct __wt_async_op **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  result = (WT_CONNECTION *) ((arg1)->connection);
  *(WT_CONNECTION **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_wiredtiger_db_wiredtigerJNI_AsyncOp_1key_1format_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  struct __wt_async_op *arg1 = (struct __wt_async_op *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  {
    arg1 = *(struct __wt_async_op **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  result = (char *) ((arg1)->key_format);
  if (result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_wiredtiger_db_wiredtigerJNI_AsyncOp_1value_1format_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  struct __wt_async_op *arg1 = (struct __wt_async_op *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  {
    arg1 = *(struct __wt_async_op **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  result = (char *) ((arg1)->value_format);
  if (result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_AsyncOp_1compact(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct __wt_async_op *arg1 = (struct __wt_async_op *) 0 ;
  WT_ASYNC_OP *arg2 = (WT_ASYNC_OP *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  {
    arg2 = *(struct __wt_async_op **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "op" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_async_op **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  {
    result = (int)(arg1)->compact(arg2);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_AsyncOp_1getType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct __wt_async_op *arg1 = (struct __wt_async_op *) 0 ;
  WT_ASYNC_OP *arg2 = (WT_ASYNC_OP *) 0 ;
  WT_ASYNC_OPTYPE result;
  
  (void)jenv;
  (void)jcls;
  {
    arg2 = *(struct __wt_async_op **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "op" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_async_op **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  {
    result = (WT_ASYNC_OPTYPE)(arg1)->get_type(arg2);; 
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jbyteArray JNICALL Java_com_wiredtiger_db_wiredtigerJNI_AsyncOp_1get_1key_1wrap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jbyteArray jresult = 0 ;
  struct __wt_async_op *arg1 = (struct __wt_async_op *) 0 ;
  JNIEnv *arg2 = (JNIEnv *) 0 ;
  WT_ITEM result;
  
  (void)jenv;
  (void)jcls;
  arg2 = jenv; 
  (void)jarg1_;
  {
    arg1 = *(struct __wt_async_op **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  result = __wt_async_op_get_key_wrap(arg1,arg2);
  
  if ((&result)->data == NULL)
  jresult = NULL;
  else if ((jresult = (*jenv)->NewByteArray(jenv, (jsize)(&result)->size)) != NULL) {
    (*jenv)->SetByteArrayRegion(jenv,
      jresult, 0, (jsize)(&result)->size, (&result)->data);
  }
  
  return jresult;
}


SWIGEXPORT jbyteArray JNICALL Java_com_wiredtiger_db_wiredtigerJNI_AsyncOp_1get_1value_1wrap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jbyteArray jresult = 0 ;
  struct __wt_async_op *arg1 = (struct __wt_async_op *) 0 ;
  JNIEnv *arg2 = (JNIEnv *) 0 ;
  WT_ITEM result;
  
  (void)jenv;
  (void)jcls;
  arg2 = jenv; 
  (void)jarg1_;
  {
    arg1 = *(struct __wt_async_op **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  result = __wt_async_op_get_value_wrap(arg1,arg2);
  
  if ((&result)->data == NULL)
  jresult = NULL;
  else if ((jresult = (*jenv)->NewByteArray(jenv, (jsize)(&result)->size)) != NULL) {
    (*jenv)->SetByteArrayRegion(jenv,
      jresult, 0, (jsize)(&result)->size, (&result)->data);
  }
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_AsyncOp_1insert_1wrap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jbyteArray jarg3) {
  jint jresult = 0 ;
  struct __wt_async_op *arg1 = (struct __wt_async_op *) 0 ;
  WT_ITEM *arg2 = (WT_ITEM *) 0 ;
  WT_ITEM *arg3 = (WT_ITEM *) 0 ;
  WT_ITEM item2 ;
  WT_ITEM item3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  {
    arg1 = *(struct __wt_async_op **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  
  arg2 = &item2;
  arg2->data = (*jenv)->GetByteArrayElements(jenv, jarg2, 0);
  arg2->size = (size_t)(*jenv)->GetArrayLength(jenv, jarg2);
  
  
  arg3 = &item3;
  arg3->data = (*jenv)->GetByteArrayElements(jenv, jarg3, 0);
  arg3->size = (size_t)(*jenv)->GetArrayLength(jenv, jarg3);
  
  result = (int)__wt_async_op_insert_wrap(arg1,arg2,arg3);
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  
  (*jenv)->ReleaseByteArrayElements(jenv, jarg2, (void *)arg2->data, 0);
  
  
  (*jenv)->ReleaseByteArrayElements(jenv, jarg3, (void *)arg3->data, 0);
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_AsyncOp_1remove_1wrap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2) {
  jint jresult = 0 ;
  struct __wt_async_op *arg1 = (struct __wt_async_op *) 0 ;
  WT_ITEM *arg2 = (WT_ITEM *) 0 ;
  WT_ITEM item2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  {
    arg1 = *(struct __wt_async_op **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  
  arg2 = &item2;
  arg2->data = (*jenv)->GetByteArrayElements(jenv, jarg2, 0);
  arg2->size = (size_t)(*jenv)->GetArrayLength(jenv, jarg2);
  
  result = (int)__wt_async_op_remove_wrap(arg1,arg2);
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  
  (*jenv)->ReleaseByteArrayElements(jenv, jarg2, (void *)arg2->data, 0);
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_AsyncOp_1search_1wrap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2) {
  jint jresult = 0 ;
  struct __wt_async_op *arg1 = (struct __wt_async_op *) 0 ;
  WT_ITEM *arg2 = (WT_ITEM *) 0 ;
  WT_ITEM item2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  {
    arg1 = *(struct __wt_async_op **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  
  arg2 = &item2;
  arg2->data = (*jenv)->GetByteArrayElements(jenv, jarg2, 0);
  arg2->size = (size_t)(*jenv)->GetArrayLength(jenv, jarg2);
  
  result = (int)__wt_async_op_search_wrap(arg1,arg2);
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  
  (*jenv)->ReleaseByteArrayElements(jenv, jarg2, (void *)arg2->data, 0);
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_AsyncOp_1update_1wrap(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jbyteArray jarg3) {
  jint jresult = 0 ;
  struct __wt_async_op *arg1 = (struct __wt_async_op *) 0 ;
  WT_ITEM *arg2 = (WT_ITEM *) 0 ;
  WT_ITEM *arg3 = (WT_ITEM *) 0 ;
  WT_ITEM item2 ;
  WT_ITEM item3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  {
    arg1 = *(struct __wt_async_op **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  
  arg2 = &item2;
  arg2->data = (*jenv)->GetByteArrayElements(jenv, jarg2, 0);
  arg2->size = (size_t)(*jenv)->GetArrayLength(jenv, jarg2);
  
  
  arg3 = &item3;
  arg3->data = (*jenv)->GetByteArrayElements(jenv, jarg3, 0);
  arg3->size = (size_t)(*jenv)->GetArrayLength(jenv, jarg3);
  
  result = (int)__wt_async_op_update_wrap(arg1,arg2,arg3);
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  
  (*jenv)->ReleaseByteArrayElements(jenv, jarg2, (void *)arg2->data, 0);
  
  
  (*jenv)->ReleaseByteArrayElements(jenv, jarg3, (void *)arg3->data, 0);
  
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_wiredtiger_db_wiredtigerJNI_AsyncOp_1_1java_1raw(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  struct __wt_async_op *arg1 = (struct __wt_async_op *) 0 ;
  JNIEnv *arg2 = (JNIEnv *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg2 = jenv; 
  (void)jarg1_;
  {
    arg1 = *(struct __wt_async_op **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  result = (bool)__wt_async_op__java_raw(arg1,arg2);
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_AsyncOp_1_1java_1init(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jint jresult = 0 ;
  struct __wt_async_op *arg1 = (struct __wt_async_op *) 0 ;
  jobject arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  {
    arg1 = *(struct __wt_async_op **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg2 = jarg2; 
  result = (int)__wt_async_op__java_init(arg1,arg2);
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_AsyncOp_1getId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct __wt_async_op *arg1 = (struct __wt_async_op *) 0 ;
  JNIEnv *arg2 = (JNIEnv *) 0 ;
  long result;
  
  (void)jenv;
  (void)jcls;
  arg2 = jenv; 
  (void)jarg1_;
  {
    arg1 = *(struct __wt_async_op **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  {
    result = (long)__wt_async_op_get_id_wrap(arg1,arg2);; 
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Session_1connection_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  struct __wt_session *arg1 = (struct __wt_session *) 0 ;
  WT_CONNECTION *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  {
    arg1 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  result = (WT_CONNECTION *) ((arg1)->connection);
  *(WT_CONNECTION **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Session_1alter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg3, jstring jarg4) {
  jint jresult = 0 ;
  struct __wt_session *arg1 = (struct __wt_session *) 0 ;
  WT_SESSION_CLOSED *arg2 = (WT_SESSION_CLOSED *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  WT_SESSION *savesess2 ;
  JAVA_CALLBACK *jcb2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg4 = NULL; 
  {
    arg2 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "session" " is null");
      return (0);
    }
    /*@SWIG@*/
    savesess2 = arg2;
    jcb2 = (JAVA_CALLBACK *)(((WT_SESSION_IMPL *)arg2)->lang_private);
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return 0;
  }
  {
    result = (int)(arg1)->alter(arg2,(char const *)arg3,(char const *)arg4);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  {
    closeHandler(jenv, savesess2, jcb2);
  }
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Session_1close(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg3) {
  jint jresult = 0 ;
  struct __wt_session *arg1 = (struct __wt_session *) 0 ;
  WT_SESSION_CLOSED *arg2 = (WT_SESSION_CLOSED *) 0 ;
  char *arg3 = (char *) 0 ;
  WT_SESSION *savesess2 ;
  JAVA_CALLBACK *jcb2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg3 = NULL; 
  {
    arg2 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "session" " is null");
      return (0);
    }
    /*@SWIG@*/
    savesess2 = arg2;
    jcb2 = (JAVA_CALLBACK *)(((WT_SESSION_IMPL *)arg2)->lang_private);
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  {
    result = (int)(arg1)->close(arg2,(char const *)arg3);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  {
    closeHandler(jenv, savesess2, jcb2);
  }
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Session_1reconfigure(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg3) {
  jint jresult = 0 ;
  struct __wt_session *arg1 = (struct __wt_session *) 0 ;
  WT_SESSION *arg2 = (WT_SESSION *) 0 ;
  char *arg3 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg3 = NULL; 
  {
    arg2 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "session" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  {
    result = (int)(arg1)->reconfigure(arg2,(char const *)arg3);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Session_1strerror(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg3) {
  jstring jresult = 0 ;
  struct __wt_session *arg1 = (struct __wt_session *) 0 ;
  WT_SESSION *arg2 = (WT_SESSION *) 0 ;
  int arg3 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    arg2 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "session" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg3 = (int)jarg3; 
  {
    result = (char *)(arg1)->strerror(arg2,arg3);; 
  }
  if (result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Session_1create(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg3, jstring jarg4) {
  jint jresult = 0 ;
  struct __wt_session *arg1 = (struct __wt_session *) 0 ;
  WT_SESSION *arg2 = (WT_SESSION *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg4 = NULL; 
  {
    arg2 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "session" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return 0;
  }
  {
    result = (int)(arg1)->create(arg2,(char const *)arg3,(char const *)arg4);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Session_1compact(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg3, jstring jarg4) {
  jint jresult = 0 ;
  struct __wt_session *arg1 = (struct __wt_session *) 0 ;
  WT_SESSION *arg2 = (WT_SESSION *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg4 = NULL; 
  {
    arg2 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "session" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return 0;
  }
  {
    result = (int)(arg1)->compact(arg2,(char const *)arg3,(char const *)arg4);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Session_1drop(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg3, jstring jarg4) {
  jint jresult = 0 ;
  struct __wt_session *arg1 = (struct __wt_session *) 0 ;
  WT_SESSION *arg2 = (WT_SESSION *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg4 = NULL; 
  {
    arg2 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "session" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return 0;
  }
  {
    result = (int)(arg1)->drop(arg2,(char const *)arg3,(char const *)arg4);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Session_1join(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jstring jarg5) {
  jint jresult = 0 ;
  struct __wt_session *arg1 = (struct __wt_session *) 0 ;
  WT_SESSION *arg2 = (WT_SESSION *) 0 ;
  WT_CURSOR *arg3 = (WT_CURSOR *) 0 ;
  WT_CURSOR *arg4 = (WT_CURSOR *) 0 ;
  char *arg5 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg5 = NULL; 
  {
    arg2 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "session" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  (void)jarg3_;
  (void)jarg4_;
  {
    arg1 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  {
    arg3 = *(struct __wt_cursor **)&jarg3;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "join_cursor" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  {
    arg4 = *(struct __wt_cursor **)&jarg4;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg4) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "ref_cursor" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg5, 0);
    if (!arg5) return 0;
  }
  {
    result = (int)(arg1)->join(arg2,arg3,arg4,(char const *)arg5);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  if (arg5) (*jenv)->ReleaseStringUTFChars(jenv, jarg5, (const char *)arg5);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Session_1log_1flush(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg3) {
  jint jresult = 0 ;
  struct __wt_session *arg1 = (struct __wt_session *) 0 ;
  WT_SESSION *arg2 = (WT_SESSION *) 0 ;
  char *arg3 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg3 = NULL; 
  {
    arg2 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "session" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  {
    result = (int)(arg1)->log_flush(arg2,(char const *)arg3);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Session_1log_1printf(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg3) {
  jint jresult = 0 ;
  struct __wt_session *arg1 = (struct __wt_session *) 0 ;
  WT_SESSION *arg2 = (WT_SESSION *) 0 ;
  char *arg3 = (char *) 0 ;
  void *arg4 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  {
    arg2 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "session" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  {
    result = (int)(arg1)->log_printf(arg2,(char const *)arg3,arg4);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Session_1rebalance(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg3, jstring jarg4) {
  jint jresult = 0 ;
  struct __wt_session *arg1 = (struct __wt_session *) 0 ;
  WT_SESSION *arg2 = (WT_SESSION *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg4 = NULL; 
  {
    arg2 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "session" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return 0;
  }
  {
    result = (int)(arg1)->rebalance(arg2,(char const *)arg3,(char const *)arg4);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Session_1rename(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg3, jstring jarg4, jstring jarg5) {
  jint jresult = 0 ;
  struct __wt_session *arg1 = (struct __wt_session *) 0 ;
  WT_SESSION *arg2 = (WT_SESSION *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  char *arg5 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg5 = NULL; 
  {
    arg2 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "session" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg5, 0);
    if (!arg5) return 0;
  }
  {
    result = (int)(arg1)->rename(arg2,(char const *)arg3,(char const *)arg4,(char const *)arg5);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, (const char *)arg4);
  if (arg5) (*jenv)->ReleaseStringUTFChars(jenv, jarg5, (const char *)arg5);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Session_1reset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct __wt_session *arg1 = (struct __wt_session *) 0 ;
  WT_SESSION *arg2 = (WT_SESSION *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  {
    arg2 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "session" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  {
    result = (int)(arg1)->reset(arg2);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Session_1salvage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg3, jstring jarg4) {
  jint jresult = 0 ;
  struct __wt_session *arg1 = (struct __wt_session *) 0 ;
  WT_SESSION *arg2 = (WT_SESSION *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg4 = NULL; 
  {
    arg2 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "session" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return 0;
  }
  {
    result = (int)(arg1)->salvage(arg2,(char const *)arg3,(char const *)arg4);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Session_1truncate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg3, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_, jstring jarg6) {
  jint jresult = 0 ;
  struct __wt_session *arg1 = (struct __wt_session *) 0 ;
  WT_SESSION *arg2 = (WT_SESSION *) 0 ;
  char *arg3 = (char *) 0 ;
  WT_CURSOR_NULLABLE *arg4 = (WT_CURSOR_NULLABLE *) 0 ;
  WT_CURSOR_NULLABLE *arg5 = (WT_CURSOR_NULLABLE *) 0 ;
  char *arg6 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg6 = NULL; 
  {
    arg2 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "session" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  (void)jarg4_;
  (void)jarg5_;
  {
    arg1 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  {
    arg4 = *(struct __wt_cursor **)&jarg4;
  }
  {
    arg5 = *(struct __wt_cursor **)&jarg5;
  }
  arg6 = 0;
  if (jarg6) {
    arg6 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg6, 0);
    if (!arg6) return 0;
  }
  {
    result = (int)(arg1)->truncate(arg2,(char const *)arg3,arg4,arg5,(char const *)arg6);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  if (arg6) (*jenv)->ReleaseStringUTFChars(jenv, jarg6, (const char *)arg6);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Session_1upgrade(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg3, jstring jarg4) {
  jint jresult = 0 ;
  struct __wt_session *arg1 = (struct __wt_session *) 0 ;
  WT_SESSION *arg2 = (WT_SESSION *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg4 = NULL; 
  {
    arg2 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "session" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return 0;
  }
  {
    result = (int)(arg1)->upgrade(arg2,(char const *)arg3,(char const *)arg4);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Session_1verify(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg3, jstring jarg4) {
  jint jresult = 0 ;
  struct __wt_session *arg1 = (struct __wt_session *) 0 ;
  WT_SESSION *arg2 = (WT_SESSION *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg4 = NULL; 
  {
    arg2 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "session" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return 0;
  }
  {
    result = (int)(arg1)->verify(arg2,(char const *)arg3,(char const *)arg4);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Session_1begin_1transaction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg3) {
  jint jresult = 0 ;
  struct __wt_session *arg1 = (struct __wt_session *) 0 ;
  WT_SESSION *arg2 = (WT_SESSION *) 0 ;
  char *arg3 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg3 = NULL; 
  {
    arg2 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "session" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  {
    result = (int)(arg1)->begin_transaction(arg2,(char const *)arg3);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Session_1commit_1transaction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg3) {
  jint jresult = 0 ;
  struct __wt_session *arg1 = (struct __wt_session *) 0 ;
  WT_SESSION *arg2 = (WT_SESSION *) 0 ;
  char *arg3 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg3 = NULL; 
  {
    arg2 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "session" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  {
    result = (int)(arg1)->commit_transaction(arg2,(char const *)arg3);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Session_1rollback_1transaction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg3) {
  jint jresult = 0 ;
  struct __wt_session *arg1 = (struct __wt_session *) 0 ;
  WT_SESSION *arg2 = (WT_SESSION *) 0 ;
  char *arg3 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg3 = NULL; 
  {
    arg2 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "session" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  {
    result = (int)(arg1)->rollback_transaction(arg2,(char const *)arg3);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Session_1checkpoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg3) {
  jint jresult = 0 ;
  struct __wt_session *arg1 = (struct __wt_session *) 0 ;
  WT_SESSION *arg2 = (WT_SESSION *) 0 ;
  char *arg3 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg3 = NULL; 
  {
    arg2 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "session" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  {
    result = (int)(arg1)->checkpoint(arg2,(char const *)arg3);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Session_1snapshot(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg3) {
  jint jresult = 0 ;
  struct __wt_session *arg1 = (struct __wt_session *) 0 ;
  WT_SESSION *arg2 = (WT_SESSION *) 0 ;
  char *arg3 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg3 = NULL; 
  {
    arg2 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "session" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  {
    result = (int)(arg1)->snapshot(arg2,(char const *)arg3);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Session_1transaction_1sync(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg3) {
  jint jresult = 0 ;
  struct __wt_session *arg1 = (struct __wt_session *) 0 ;
  WT_SESSION *arg2 = (WT_SESSION *) 0 ;
  char *arg3 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg3 = NULL; 
  {
    arg2 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "session" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  {
    result = (int)(arg1)->transaction_sync(arg2,(char const *)arg3);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Session_1_1java_1init(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jint jresult = 0 ;
  struct __wt_session *arg1 = (struct __wt_session *) 0 ;
  jobject arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  {
    arg1 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg2 = jarg2; 
  {
    result = (int)__wt_session__java_init(arg1,arg2);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Session_1open_1cursor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg3, jlong jarg4, jobject jarg4_, jstring jarg5) {
  jlong jresult = 0 ;
  struct __wt_session *arg1 = (struct __wt_session *) 0 ;
  JNIEnv *arg2 = (JNIEnv *) 0 ;
  char *arg3 = (char *) 0 ;
  WT_CURSOR_NULLABLE *arg4 = (WT_CURSOR_NULLABLE *) 0 ;
  char *arg5 = (char *) 0 ;
  WT_CURSOR *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg5 = NULL; 
  arg2 = jenv; 
  (void)jarg1_;
  (void)jarg4_;
  {
    arg1 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  {
    arg4 = *(struct __wt_cursor **)&jarg4;
  }
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg5, 0);
    if (!arg5) return 0;
  }
  {
    result = (WT_CURSOR *)__wt_session_open_cursor_wrap(arg1,arg2,(char const *)arg3,arg4,(char const *)arg5);; 
  }
  *(WT_CURSOR **)&jresult = result; 
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  if (arg5) (*jenv)->ReleaseStringUTFChars(jenv, jarg5, (const char *)arg5);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Session_1transaction_1pinned_1range(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct __wt_session *arg1 = (struct __wt_session *) 0 ;
  JNIEnv *arg2 = (JNIEnv *) 0 ;
  long result;
  
  (void)jenv;
  (void)jcls;
  arg2 = jenv; 
  (void)jarg1_;
  {
    arg1 = *(struct __wt_session **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  {
    result = (long)__wt_session_transaction_pinned_range_wrap(arg1,arg2);; 
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Connection_1async_1flush(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct __wt_connection *arg1 = (struct __wt_connection *) 0 ;
  WT_CONNECTION *arg2 = (WT_CONNECTION *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  {
    arg2 = *(struct __wt_connection **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "connection" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_connection **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  {
    result = (int)(arg1)->async_flush(arg2);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Connection_1close(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg3) {
  jint jresult = 0 ;
  struct __wt_connection *arg1 = (struct __wt_connection *) 0 ;
  WT_CONNECTION_CLOSED *arg2 = (WT_CONNECTION_CLOSED *) 0 ;
  char *arg3 = (char *) 0 ;
  WT_SESSION *savesess2 ;
  JAVA_CALLBACK *jcb2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg3 = NULL; 
  {
    arg2 = *(struct __wt_connection **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "connection" " is null");
      return (0);
    }
    /*@SWIG@*/
    savesess2 = NULL;
    jcb2 = (JAVA_CALLBACK *)(((WT_CONNECTION_IMPL *)arg2)->lang_private);
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_connection **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  {
    result = (int)(arg1)->close(arg2,(char const *)arg3);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  {
    closeHandler(jenv, savesess2, jcb2);
  }
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Connection_1reconfigure(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg3) {
  jint jresult = 0 ;
  struct __wt_connection *arg1 = (struct __wt_connection *) 0 ;
  WT_CONNECTION *arg2 = (WT_CONNECTION *) 0 ;
  char *arg3 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg3 = NULL; 
  {
    arg2 = *(struct __wt_connection **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "connection" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_connection **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  {
    result = (int)(arg1)->reconfigure(arg2,(char const *)arg3);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Connection_1get_1home(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  struct __wt_connection *arg1 = (struct __wt_connection *) 0 ;
  WT_CONNECTION *arg2 = (WT_CONNECTION *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    arg2 = *(struct __wt_connection **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "connection" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_connection **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  {
    result = (char *)(arg1)->get_home(arg2);; 
  }
  if (result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Connection_1configure_1method(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg3, jstring jarg4, jstring jarg5, jstring jarg6, jstring jarg7) {
  jint jresult = 0 ;
  struct __wt_connection *arg1 = (struct __wt_connection *) 0 ;
  WT_CONNECTION *arg2 = (WT_CONNECTION *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  char *arg5 = (char *) 0 ;
  char *arg6 = (char *) 0 ;
  char *arg7 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg5 = NULL; 
  {
    arg2 = *(struct __wt_connection **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "connection" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_connection **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg5, 0);
    if (!arg5) return 0;
  }
  arg6 = 0;
  if (jarg6) {
    arg6 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg6, 0);
    if (!arg6) return 0;
  }
  arg7 = 0;
  if (jarg7) {
    arg7 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg7, 0);
    if (!arg7) return 0;
  }
  {
    result = (int)(arg1)->configure_method(arg2,(char const *)arg3,(char const *)arg4,(char const *)arg5,(char const *)arg6,(char const *)arg7);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, (const char *)arg4);
  if (arg5) (*jenv)->ReleaseStringUTFChars(jenv, jarg5, (const char *)arg5);
  if (arg6) (*jenv)->ReleaseStringUTFChars(jenv, jarg6, (const char *)arg6);
  if (arg7) (*jenv)->ReleaseStringUTFChars(jenv, jarg7, (const char *)arg7);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Connection_1is_1new(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct __wt_connection *arg1 = (struct __wt_connection *) 0 ;
  WT_CONNECTION *arg2 = (WT_CONNECTION *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  {
    arg2 = *(struct __wt_connection **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "connection" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_connection **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  {
    result = (int)(arg1)->is_new(arg2);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Connection_1load_1extension(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg3, jstring jarg4) {
  jint jresult = 0 ;
  struct __wt_connection *arg1 = (struct __wt_connection *) 0 ;
  WT_CONNECTION *arg2 = (WT_CONNECTION *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg4 = NULL; 
  {
    arg2 = *(struct __wt_connection **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "connection" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  (void)jarg1_;
  {
    arg1 = *(struct __wt_connection **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return 0;
  }
  {
    result = (int)(arg1)->load_extension(arg2,(char const *)arg3,(char const *)arg4);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Connection_1_1java_1init(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jint jresult = 0 ;
  struct __wt_connection *arg1 = (struct __wt_connection *) 0 ;
  jobject arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  {
    arg1 = *(struct __wt_connection **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg2 = jarg2; 
  {
    result = (int)__wt_connection__java_init(arg1,arg2);; 
  }
  
  if (result != 0 && result != WT_NOTFOUND) {
    throwWiredTigerException(jenv, result);
    return (0);
  }
  jresult = result;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Connection_1async_1new_1op(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg3, jstring jarg4, jobject jarg5) {
  jlong jresult = 0 ;
  struct __wt_connection *arg1 = (struct __wt_connection *) 0 ;
  JNIEnv *arg2 = (JNIEnv *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  jobject arg5 ;
  WT_ASYNC_OP *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg4 = NULL; 
  arg2 = jenv; 
  (void)jarg1_;
  {
    arg1 = *(struct __wt_connection **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = jarg5; 
  {
    result = (WT_ASYNC_OP *)__wt_connection_async_new_op_wrap(arg1,arg2,(char const *)arg3,(char const *)arg4,arg5);; 
  }
  *(WT_ASYNC_OP **)&jresult = result; 
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_wiredtiger_db_wiredtigerJNI_Connection_1open_1session(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg3) {
  jlong jresult = 0 ;
  struct __wt_connection *arg1 = (struct __wt_connection *) 0 ;
  JNIEnv *arg2 = (JNIEnv *) 0 ;
  char *arg3 = (char *) 0 ;
  WT_SESSION *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg3 = NULL; 
  arg2 = jenv; 
  (void)jarg1_;
  {
    arg1 = *(struct __wt_connection **)&jarg1;
    /*@SWIG:wiredtiger.i,217,NULL_CHECK@*/
    if (!arg1) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException,
        "self" " is null");
      return (0);
    }
    /*@SWIG@*/
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  {
    result = (WT_SESSION *)__wt_connection_open_session_wrap(arg1,arg2,(char const *)arg3);; 
  }
  *(WT_SESSION **)&jresult = result; 
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_wiredtiger_db_wiredtigerJNI_wiredtiger_1strerror(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  int arg1 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  {
    result = (char *)wiredtiger_strerror(arg1);; 
  }
  if (result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_wiredtiger_db_wiredtigerJNI_open(JNIEnv *jenv, jclass jcls, jstring jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  JNIEnv *arg1 = (JNIEnv *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  WT_CONNECTION *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg3 = NULL; 
  arg1 = jenv; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  {
    result = (WT_CONNECTION *)wiredtiger_open_wrap(arg1,(char const *)arg2,(char const *)arg3);; 
  }
  *(WT_CONNECTION **)&jresult = result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  return jresult;
}


#ifdef __cplusplus
}
#endif

