/*
 *  Test large and small years.
 *
 *  Related bug: test-bug-date-insane-setyear.js.
 *
 *  The expect strings are combined from V8.  There seems to be a Rhino bug,
 *  careful when comparing:
 *
 *    $ node
 *    > new Date(-271820,1,1).toISOString()
 *    '-271820-01-31T22:00:00.000Z'
 *
 *    $ rhino
 *    Rhino 1.7 release 4 2013 08 27
 *    js> new Date(-271820,1,1).toISOString()
 *    271816-09-02T22:00:00.000Z
 */

function testYear(i) {
    var d = new Date(0);
    d.setUTCFullYear(i);
    try {
        print(i, d.toISOString());
    } catch (e) {
        print(i, e.name);
    }
}

/*===
negative edge
-271850 RangeError
-271849 RangeError
-271848 RangeError
-271847 RangeError
-271846 RangeError
-271845 RangeError
-271844 RangeError
-271843 RangeError
-271842 RangeError
-271841 RangeError
-271840 RangeError
-271839 RangeError
-271838 RangeError
-271837 RangeError
-271836 RangeError
-271835 RangeError
-271834 RangeError
-271833 RangeError
-271832 RangeError
-271831 RangeError
-271830 RangeError
-271829 RangeError
-271828 RangeError
-271827 RangeError
-271826 RangeError
-271825 RangeError
-271824 RangeError
-271823 RangeError
-271822 RangeError
-271821 RangeError
-271820 -271820-01-01T00:00:00.000Z
-271819 -271819-01-01T00:00:00.000Z
-271818 -271818-01-01T00:00:00.000Z
-271817 -271817-01-01T00:00:00.000Z
-271816 -271816-01-01T00:00:00.000Z
-271815 -271815-01-01T00:00:00.000Z
-271814 -271814-01-01T00:00:00.000Z
-271813 -271813-01-01T00:00:00.000Z
-271812 -271812-01-01T00:00:00.000Z
-271811 -271811-01-01T00:00:00.000Z
-271810 -271810-01-01T00:00:00.000Z
-271809 -271809-01-01T00:00:00.000Z
-271808 -271808-01-01T00:00:00.000Z
-271807 -271807-01-01T00:00:00.000Z
-271806 -271806-01-01T00:00:00.000Z
-271805 -271805-01-01T00:00:00.000Z
-271804 -271804-01-01T00:00:00.000Z
-271803 -271803-01-01T00:00:00.000Z
-271802 -271802-01-01T00:00:00.000Z
-271801 -271801-01-01T00:00:00.000Z
-271800 -271800-01-01T00:00:00.000Z
-271799 -271799-01-01T00:00:00.000Z
-271798 -271798-01-01T00:00:00.000Z
-271797 -271797-01-01T00:00:00.000Z
-271796 -271796-01-01T00:00:00.000Z
-271795 -271795-01-01T00:00:00.000Z
-271794 -271794-01-01T00:00:00.000Z
-271793 -271793-01-01T00:00:00.000Z
-271792 -271792-01-01T00:00:00.000Z
-271791 -271791-01-01T00:00:00.000Z
-271790 -271790-01-01T00:00:00.000Z
-271789 -271789-01-01T00:00:00.000Z
-271788 -271788-01-01T00:00:00.000Z
-271787 -271787-01-01T00:00:00.000Z
-271786 -271786-01-01T00:00:00.000Z
-271785 -271785-01-01T00:00:00.000Z
-271784 -271784-01-01T00:00:00.000Z
-271783 -271783-01-01T00:00:00.000Z
-271782 -271782-01-01T00:00:00.000Z
-271781 -271781-01-01T00:00:00.000Z
-271780 -271780-01-01T00:00:00.000Z
-271779 -271779-01-01T00:00:00.000Z
-271778 -271778-01-01T00:00:00.000Z
-271777 -271777-01-01T00:00:00.000Z
-271776 -271776-01-01T00:00:00.000Z
-271775 -271775-01-01T00:00:00.000Z
-271774 -271774-01-01T00:00:00.000Z
-271773 -271773-01-01T00:00:00.000Z
-271772 -271772-01-01T00:00:00.000Z
-271771 -271771-01-01T00:00:00.000Z
-271770 -271770-01-01T00:00:00.000Z
-271769 -271769-01-01T00:00:00.000Z
-271768 -271768-01-01T00:00:00.000Z
-271767 -271767-01-01T00:00:00.000Z
-271766 -271766-01-01T00:00:00.000Z
-271765 -271765-01-01T00:00:00.000Z
-271764 -271764-01-01T00:00:00.000Z
-271763 -271763-01-01T00:00:00.000Z
-271762 -271762-01-01T00:00:00.000Z
-271761 -271761-01-01T00:00:00.000Z
-271760 -271760-01-01T00:00:00.000Z
-271759 -271759-01-01T00:00:00.000Z
-271758 -271758-01-01T00:00:00.000Z
-271757 -271757-01-01T00:00:00.000Z
-271756 -271756-01-01T00:00:00.000Z
-271755 -271755-01-01T00:00:00.000Z
-271754 -271754-01-01T00:00:00.000Z
-271753 -271753-01-01T00:00:00.000Z
-271752 -271752-01-01T00:00:00.000Z
-271751 -271751-01-01T00:00:00.000Z
-271750 -271750-01-01T00:00:00.000Z
===*/

function negativeEdgeTest() {
    var i;

    /*
     *  Edge cases
     *
     *  > new Date(-271821,1,1)
     *  Invalid Date
     *  > new Date(-271820,1,1)
     *  Tue Feb 01 -271820 00:00:00 GMT+0200 (EET)
     */

    for (i = -271850; i <= -271750; i++) {
        testYear(i);
    }
}

/*===
positive edge
275700 +275700-01-01T00:00:00.000Z
275701 +275701-01-01T00:00:00.000Z
275702 +275702-01-01T00:00:00.000Z
275703 +275703-01-01T00:00:00.000Z
275704 +275704-01-01T00:00:00.000Z
275705 +275705-01-01T00:00:00.000Z
275706 +275706-01-01T00:00:00.000Z
275707 +275707-01-01T00:00:00.000Z
275708 +275708-01-01T00:00:00.000Z
275709 +275709-01-01T00:00:00.000Z
275710 +275710-01-01T00:00:00.000Z
275711 +275711-01-01T00:00:00.000Z
275712 +275712-01-01T00:00:00.000Z
275713 +275713-01-01T00:00:00.000Z
275714 +275714-01-01T00:00:00.000Z
275715 +275715-01-01T00:00:00.000Z
275716 +275716-01-01T00:00:00.000Z
275717 +275717-01-01T00:00:00.000Z
275718 +275718-01-01T00:00:00.000Z
275719 +275719-01-01T00:00:00.000Z
275720 +275720-01-01T00:00:00.000Z
275721 +275721-01-01T00:00:00.000Z
275722 +275722-01-01T00:00:00.000Z
275723 +275723-01-01T00:00:00.000Z
275724 +275724-01-01T00:00:00.000Z
275725 +275725-01-01T00:00:00.000Z
275726 +275726-01-01T00:00:00.000Z
275727 +275727-01-01T00:00:00.000Z
275728 +275728-01-01T00:00:00.000Z
275729 +275729-01-01T00:00:00.000Z
275730 +275730-01-01T00:00:00.000Z
275731 +275731-01-01T00:00:00.000Z
275732 +275732-01-01T00:00:00.000Z
275733 +275733-01-01T00:00:00.000Z
275734 +275734-01-01T00:00:00.000Z
275735 +275735-01-01T00:00:00.000Z
275736 +275736-01-01T00:00:00.000Z
275737 +275737-01-01T00:00:00.000Z
275738 +275738-01-01T00:00:00.000Z
275739 +275739-01-01T00:00:00.000Z
275740 +275740-01-01T00:00:00.000Z
275741 +275741-01-01T00:00:00.000Z
275742 +275742-01-01T00:00:00.000Z
275743 +275743-01-01T00:00:00.000Z
275744 +275744-01-01T00:00:00.000Z
275745 +275745-01-01T00:00:00.000Z
275746 +275746-01-01T00:00:00.000Z
275747 +275747-01-01T00:00:00.000Z
275748 +275748-01-01T00:00:00.000Z
275749 +275749-01-01T00:00:00.000Z
275750 +275750-01-01T00:00:00.000Z
275751 +275751-01-01T00:00:00.000Z
275752 +275752-01-01T00:00:00.000Z
275753 +275753-01-01T00:00:00.000Z
275754 +275754-01-01T00:00:00.000Z
275755 +275755-01-01T00:00:00.000Z
275756 +275756-01-01T00:00:00.000Z
275757 +275757-01-01T00:00:00.000Z
275758 +275758-01-01T00:00:00.000Z
275759 +275759-01-01T00:00:00.000Z
275760 +275760-01-01T00:00:00.000Z
275761 RangeError
275762 RangeError
275763 RangeError
275764 RangeError
275765 RangeError
275766 RangeError
275767 RangeError
275768 RangeError
275769 RangeError
275770 RangeError
275771 RangeError
275772 RangeError
275773 RangeError
275774 RangeError
275775 RangeError
275776 RangeError
275777 RangeError
275778 RangeError
275779 RangeError
275780 RangeError
275781 RangeError
275782 RangeError
275783 RangeError
275784 RangeError
275785 RangeError
275786 RangeError
275787 RangeError
275788 RangeError
275789 RangeError
275790 RangeError
275791 RangeError
275792 RangeError
275793 RangeError
275794 RangeError
275795 RangeError
275796 RangeError
275797 RangeError
275798 RangeError
275799 RangeError
275800 RangeError
===*/

function positiveEdgeTest() {
    var i;

    /*
     *  Edge cases
     *
     *  > new Date(275760,1,1)
     *  Fri Feb 01 275760 00:00:00 GMT+0200 (EET)
     *  > new Date(275761,1,1)
     *  Invalid Date
     */

    for (i = 275700; i <= 275800; i++) {
        testYear(i);
    }
}

/*===
other
-1000000000 RangeError
-990000000 RangeError
-980000000 RangeError
-970000000 RangeError
-960000000 RangeError
-950000000 RangeError
-940000000 RangeError
-930000000 RangeError
-920000000 RangeError
-910000000 RangeError
-900000000 RangeError
-890000000 RangeError
-880000000 RangeError
-870000000 RangeError
-860000000 RangeError
-850000000 RangeError
-840000000 RangeError
-830000000 RangeError
-820000000 RangeError
-810000000 RangeError
-800000000 RangeError
-790000000 RangeError
-780000000 RangeError
-770000000 RangeError
-760000000 RangeError
-750000000 RangeError
-740000000 RangeError
-730000000 RangeError
-720000000 RangeError
-710000000 RangeError
-700000000 RangeError
-690000000 RangeError
-680000000 RangeError
-670000000 RangeError
-660000000 RangeError
-650000000 RangeError
-640000000 RangeError
-630000000 RangeError
-620000000 RangeError
-610000000 RangeError
-600000000 RangeError
-590000000 RangeError
-580000000 RangeError
-570000000 RangeError
-560000000 RangeError
-550000000 RangeError
-540000000 RangeError
-530000000 RangeError
-520000000 RangeError
-510000000 RangeError
-500000000 RangeError
-490000000 RangeError
-480000000 RangeError
-470000000 RangeError
-460000000 RangeError
-450000000 RangeError
-440000000 RangeError
-430000000 RangeError
-420000000 RangeError
-410000000 RangeError
-400000000 RangeError
-390000000 RangeError
-380000000 RangeError
-370000000 RangeError
-360000000 RangeError
-350000000 RangeError
-340000000 RangeError
-330000000 RangeError
-320000000 RangeError
-310000000 RangeError
-300000000 RangeError
-290000000 RangeError
-280000000 RangeError
-270000000 RangeError
-260000000 RangeError
-250000000 RangeError
-240000000 RangeError
-230000000 RangeError
-220000000 RangeError
-210000000 RangeError
-200000000 RangeError
-190000000 RangeError
-180000000 RangeError
-170000000 RangeError
-160000000 RangeError
-150000000 RangeError
-140000000 RangeError
-130000000 RangeError
-120000000 RangeError
-110000000 RangeError
-100000000 RangeError
-90000000 RangeError
-80000000 RangeError
-70000000 RangeError
-60000000 RangeError
-50000000 RangeError
-40000000 RangeError
-30000000 RangeError
-20000000 RangeError
-10000000 RangeError
0 0000-01-01T00:00:00.000Z
10000000 RangeError
20000000 RangeError
30000000 RangeError
40000000 RangeError
50000000 RangeError
60000000 RangeError
70000000 RangeError
80000000 RangeError
90000000 RangeError
100000000 RangeError
110000000 RangeError
120000000 RangeError
130000000 RangeError
140000000 RangeError
150000000 RangeError
160000000 RangeError
170000000 RangeError
180000000 RangeError
190000000 RangeError
200000000 RangeError
210000000 RangeError
220000000 RangeError
230000000 RangeError
240000000 RangeError
250000000 RangeError
260000000 RangeError
270000000 RangeError
280000000 RangeError
290000000 RangeError
300000000 RangeError
310000000 RangeError
320000000 RangeError
330000000 RangeError
340000000 RangeError
350000000 RangeError
360000000 RangeError
370000000 RangeError
380000000 RangeError
390000000 RangeError
400000000 RangeError
410000000 RangeError
420000000 RangeError
430000000 RangeError
440000000 RangeError
450000000 RangeError
460000000 RangeError
470000000 RangeError
480000000 RangeError
490000000 RangeError
500000000 RangeError
510000000 RangeError
520000000 RangeError
530000000 RangeError
540000000 RangeError
550000000 RangeError
560000000 RangeError
570000000 RangeError
580000000 RangeError
590000000 RangeError
600000000 RangeError
610000000 RangeError
620000000 RangeError
630000000 RangeError
640000000 RangeError
650000000 RangeError
660000000 RangeError
670000000 RangeError
680000000 RangeError
690000000 RangeError
700000000 RangeError
710000000 RangeError
720000000 RangeError
730000000 RangeError
740000000 RangeError
750000000 RangeError
760000000 RangeError
770000000 RangeError
780000000 RangeError
790000000 RangeError
800000000 RangeError
810000000 RangeError
820000000 RangeError
830000000 RangeError
840000000 RangeError
850000000 RangeError
860000000 RangeError
870000000 RangeError
880000000 RangeError
890000000 RangeError
900000000 RangeError
910000000 RangeError
920000000 RangeError
930000000 RangeError
940000000 RangeError
950000000 RangeError
960000000 RangeError
970000000 RangeError
980000000 RangeError
990000000 RangeError
1000000000 RangeError
-100000000000000
-99000000000000
-98000000000000
-97000000000000
-96000000000000
-95000000000000
-94000000000000
-93000000000000
-92000000000000
-91000000000000
-90000000000000
-89000000000000
-88000000000000
-87000000000000
-86000000000000
-85000000000000
-84000000000000
-83000000000000
-82000000000000
-81000000000000
-80000000000000
-79000000000000
-78000000000000
-77000000000000
-76000000000000
-75000000000000
-74000000000000
-73000000000000
-72000000000000
-71000000000000
-70000000000000
-69000000000000
-68000000000000
-67000000000000
-66000000000000
-65000000000000
-64000000000000
-63000000000000
-62000000000000
-61000000000000
-60000000000000
-59000000000000
-58000000000000
-57000000000000
-56000000000000
-55000000000000
-54000000000000
-53000000000000
-52000000000000
-51000000000000
-50000000000000
-49000000000000
-48000000000000
-47000000000000
-46000000000000
-45000000000000
-44000000000000
-43000000000000
-42000000000000
-41000000000000
-40000000000000
-39000000000000
-38000000000000
-37000000000000
-36000000000000
-35000000000000
-34000000000000
-33000000000000
-32000000000000
-31000000000000
-30000000000000
-29000000000000
-28000000000000
-27000000000000
-26000000000000
-25000000000000
-24000000000000
-23000000000000
-22000000000000
-21000000000000
-20000000000000
-19000000000000
-18000000000000
-17000000000000
-16000000000000
-15000000000000
-14000000000000
-13000000000000
-12000000000000
-11000000000000
-10000000000000
-9000000000000
-8000000000000
-7000000000000
-6000000000000
-5000000000000
-4000000000000
-3000000000000
-2000000000000
-1000000000000
0
1000000000000
2000000000000
3000000000000
4000000000000
5000000000000
6000000000000
7000000000000
8000000000000
9000000000000
10000000000000
11000000000000
12000000000000
13000000000000
14000000000000
15000000000000
16000000000000
17000000000000
18000000000000
19000000000000
20000000000000
21000000000000
22000000000000
23000000000000
24000000000000
25000000000000
26000000000000
27000000000000
28000000000000
29000000000000
30000000000000
31000000000000
32000000000000
33000000000000
34000000000000
35000000000000
36000000000000
37000000000000
38000000000000
39000000000000
40000000000000
41000000000000
42000000000000
43000000000000
44000000000000
45000000000000
46000000000000
47000000000000
48000000000000
49000000000000
50000000000000
51000000000000
52000000000000
53000000000000
54000000000000
55000000000000
56000000000000
57000000000000
58000000000000
59000000000000
60000000000000
61000000000000
62000000000000
63000000000000
64000000000000
65000000000000
66000000000000
67000000000000
68000000000000
69000000000000
70000000000000
71000000000000
72000000000000
73000000000000
74000000000000
75000000000000
76000000000000
77000000000000
78000000000000
79000000000000
80000000000000
81000000000000
82000000000000
83000000000000
84000000000000
85000000000000
86000000000000
87000000000000
88000000000000
89000000000000
90000000000000
91000000000000
92000000000000
93000000000000
94000000000000
95000000000000
96000000000000
97000000000000
98000000000000
99000000000000
100000000000000
===*/

function otherTest() {
    var i, d;

    for (i = -1e9; i <= 1e9; i += 1e7) {
        testYear(i);
    }

    // The assert offender in test-bug-date-insane-setyear was
    // 123912921921321 ~= 1.23e14.  setUTCFullYear() does not
    // trigger the bug, so use setFullYear() but avoid printing
    // the result (which would depend on timezone).

    for (i = -1e14; i <= 1e14; i += 1e12) {
        d = new Date(0);
        d.setUTCFullYear(i);
        d.setFullYear(i);
        print(i);
    }
}

try {
    print('negative edge');
    negativeEdgeTest();
} catch (e) {
    print(e.stack || e);
}

try {
    print('positive edge');
    positiveEdgeTest();
} catch (e) {
    print(e.stack || e);
}

try {
    print('other');
    otherTest();
} catch (e) {
    print(e.stack || e);
}
