/* search-provider.c generated by valac 0.40.6, the Vala compiler
 * generated from search-provider.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2014 Michael Catanzaro
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */


#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <langinfo.h>
#include <float.h>
#include <math.h>
#include <stdio.h>
#include <locale.h>


#define TYPE_SEARCH_PROVIDER (search_provider_get_type ())
#define SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_PROVIDER, SearchProvider))
#define SEARCH_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_PROVIDER, SearchProviderClass))
#define IS_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_PROVIDER))
#define IS_SEARCH_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_PROVIDER))
#define SEARCH_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_PROVIDER, SearchProviderClass))

typedef struct _SearchProvider SearchProvider;
typedef struct _SearchProviderClass SearchProviderClass;
typedef struct _SearchProviderPrivate SearchProviderPrivate;
enum  {
	SEARCH_PROVIDER_0_PROPERTY,
	SEARCH_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* search_provider_properties[SEARCH_PROVIDER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define TYPE_SEARCH_PROVIDER_APP (search_provider_app_get_type ())
#define SEARCH_PROVIDER_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_PROVIDER_APP, SearchProviderApp))
#define SEARCH_PROVIDER_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_PROVIDER_APP, SearchProviderAppClass))
#define IS_SEARCH_PROVIDER_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_PROVIDER_APP))
#define IS_SEARCH_PROVIDER_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_PROVIDER_APP))
#define SEARCH_PROVIDER_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_PROVIDER_APP, SearchProviderAppClass))

typedef struct _SearchProviderApp SearchProviderApp;
typedef struct _SearchProviderAppClass SearchProviderAppClass;
typedef struct _SearchProviderAppPrivate SearchProviderAppPrivate;
enum  {
	SEARCH_PROVIDER_APP_0_PROPERTY,
	SEARCH_PROVIDER_APP_NUM_PROPERTIES
};
static GParamSpec* search_provider_app_properties[SEARCH_PROVIDER_APP_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SearchProvider {
	GObject parent_instance;
	SearchProviderPrivate * priv;
};

struct _SearchProviderClass {
	GObjectClass parent_class;
};

struct _SearchProviderApp {
	GApplication parent_instance;
	SearchProviderAppPrivate * priv;
};

struct _SearchProviderAppClass {
	GApplicationClass parent_class;
};


static gpointer search_provider_parent_class = NULL;
static gpointer search_provider_app_parent_class = NULL;

GType search_provider_get_type (void) G_GNUC_CONST;
guint search_provider_register_object (void* object,
                                       GDBusConnection* connection,
                                       const gchar* path,
                                       GError** error);
static gchar* search_provider_terms_to_equation (gchar** terms,
                                          int terms_length1);
static gboolean search_provider_can_parse (gchar** terms,
                                    int terms_length1);
static gchar** search_provider_get_result_identifier (gchar** terms,
                                               int terms_length1,
                                               int* result_length1);
gchar** search_provider_get_initial_result_set (SearchProvider* self,
                                                gchar** terms,
                                                int terms_length1,
                                                int* result_length1);
gchar** search_provider_get_subsearch_result_set (SearchProvider* self,
                                                  gchar** previous_results,
                                                  int previous_results_length1,
                                                  gchar** terms,
                                                  int terms_length1,
                                                  int* result_length1);
GHashTable** search_provider_get_result_metas (SearchProvider* self,
                                               gchar** results,
                                               int results_length1,
                                               int* result_length1);
static void _vala_array_add1 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static GVariant* _variant_new1 (const gchar* value);
static GVariant* _variant_new2 (const gchar* value);
static GVariant* _variant_new3 (gchar* value);
static void search_provider_spawn_and_display_equation (gchar** terms,
                                                 int terms_length1);
void search_provider_activate_result (SearchProvider* self,
                                      const gchar* _result_,
                                      gchar** terms,
                                      int terms_length1,
                                      guint32 timestamp);
void search_provider_launch_search (SearchProvider* self,
                                    gchar** terms,
                                    int terms_length1,
                                    guint32 timestamp);
SearchProvider* search_provider_new (void);
SearchProvider* search_provider_construct (GType object_type);
static void _dbus_search_provider_get_initial_result_set (SearchProvider* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation);
static void _dbus_search_provider_get_subsearch_result_set (SearchProvider* self,
                                                     GVariant* _parameters_,
                                                     GDBusMethodInvocation* invocation);
static void _dbus_search_provider_get_result_metas (SearchProvider* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation);
static void _dbus_search_provider_activate_result (SearchProvider* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation);
static void _dbus_search_provider_launch_search (SearchProvider* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation);
static void search_provider_dbus_interface_method_call (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* method_name,
                                                 GVariant* parameters,
                                                 GDBusMethodInvocation* invocation,
                                                 gpointer user_data);
static GVariant* search_provider_dbus_interface_get_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GError** error,
                                                       gpointer user_data);
static gboolean search_provider_dbus_interface_set_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GVariant* value,
                                                      GError** error,
                                                      gpointer user_data);
static void _search_provider_unregister_object (gpointer user_data);
GType search_provider_app_get_type (void) G_GNUC_CONST;
SearchProviderApp* search_provider_app_new (void);
SearchProviderApp* search_provider_app_construct (GType object_type);
static gboolean search_provider_app_real_dbus_register (GApplication* base,
                                                 GDBusConnection* connection,
                                                 const gchar* object_path,
                                                 GError** error);
gint _vala_main (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static const GDBusArgInfo _search_provider_dbus_arg_info_get_initial_result_set_terms = {-1, "terms", "as"};
static const GDBusArgInfo _search_provider_dbus_arg_info_get_initial_result_set_result = {-1, "result", "as"};
static const GDBusArgInfo * const _search_provider_dbus_arg_info_get_initial_result_set_in[] = {&_search_provider_dbus_arg_info_get_initial_result_set_terms, NULL};
static const GDBusArgInfo * const _search_provider_dbus_arg_info_get_initial_result_set_out[] = {&_search_provider_dbus_arg_info_get_initial_result_set_result, NULL};
static const GDBusMethodInfo _search_provider_dbus_method_info_get_initial_result_set = {-1, "GetInitialResultSet", (GDBusArgInfo **) (&_search_provider_dbus_arg_info_get_initial_result_set_in), (GDBusArgInfo **) (&_search_provider_dbus_arg_info_get_initial_result_set_out)};
static const GDBusArgInfo _search_provider_dbus_arg_info_get_subsearch_result_set_previous_results = {-1, "previous_results", "as"};
static const GDBusArgInfo _search_provider_dbus_arg_info_get_subsearch_result_set_terms = {-1, "terms", "as"};
static const GDBusArgInfo _search_provider_dbus_arg_info_get_subsearch_result_set_result = {-1, "result", "as"};
static const GDBusArgInfo * const _search_provider_dbus_arg_info_get_subsearch_result_set_in[] = {&_search_provider_dbus_arg_info_get_subsearch_result_set_previous_results, &_search_provider_dbus_arg_info_get_subsearch_result_set_terms, NULL};
static const GDBusArgInfo * const _search_provider_dbus_arg_info_get_subsearch_result_set_out[] = {&_search_provider_dbus_arg_info_get_subsearch_result_set_result, NULL};
static const GDBusMethodInfo _search_provider_dbus_method_info_get_subsearch_result_set = {-1, "GetSubsearchResultSet", (GDBusArgInfo **) (&_search_provider_dbus_arg_info_get_subsearch_result_set_in), (GDBusArgInfo **) (&_search_provider_dbus_arg_info_get_subsearch_result_set_out)};
static const GDBusArgInfo _search_provider_dbus_arg_info_get_result_metas_results = {-1, "results", "as"};
static const GDBusArgInfo _search_provider_dbus_arg_info_get_result_metas_result = {-1, "result", "aa{sv}"};
static const GDBusArgInfo * const _search_provider_dbus_arg_info_get_result_metas_in[] = {&_search_provider_dbus_arg_info_get_result_metas_results, NULL};
static const GDBusArgInfo * const _search_provider_dbus_arg_info_get_result_metas_out[] = {&_search_provider_dbus_arg_info_get_result_metas_result, NULL};
static const GDBusMethodInfo _search_provider_dbus_method_info_get_result_metas = {-1, "GetResultMetas", (GDBusArgInfo **) (&_search_provider_dbus_arg_info_get_result_metas_in), (GDBusArgInfo **) (&_search_provider_dbus_arg_info_get_result_metas_out)};
static const GDBusArgInfo _search_provider_dbus_arg_info_activate_result_result = {-1, "result", "s"};
static const GDBusArgInfo _search_provider_dbus_arg_info_activate_result_terms = {-1, "terms", "as"};
static const GDBusArgInfo _search_provider_dbus_arg_info_activate_result_timestamp = {-1, "timestamp", "u"};
static const GDBusArgInfo * const _search_provider_dbus_arg_info_activate_result_in[] = {&_search_provider_dbus_arg_info_activate_result_result, &_search_provider_dbus_arg_info_activate_result_terms, &_search_provider_dbus_arg_info_activate_result_timestamp, NULL};
static const GDBusArgInfo * const _search_provider_dbus_arg_info_activate_result_out[] = {NULL};
static const GDBusMethodInfo _search_provider_dbus_method_info_activate_result = {-1, "ActivateResult", (GDBusArgInfo **) (&_search_provider_dbus_arg_info_activate_result_in), (GDBusArgInfo **) (&_search_provider_dbus_arg_info_activate_result_out)};
static const GDBusArgInfo _search_provider_dbus_arg_info_launch_search_terms = {-1, "terms", "as"};
static const GDBusArgInfo _search_provider_dbus_arg_info_launch_search_timestamp = {-1, "timestamp", "u"};
static const GDBusArgInfo * const _search_provider_dbus_arg_info_launch_search_in[] = {&_search_provider_dbus_arg_info_launch_search_terms, &_search_provider_dbus_arg_info_launch_search_timestamp, NULL};
static const GDBusArgInfo * const _search_provider_dbus_arg_info_launch_search_out[] = {NULL};
static const GDBusMethodInfo _search_provider_dbus_method_info_launch_search = {-1, "LaunchSearch", (GDBusArgInfo **) (&_search_provider_dbus_arg_info_launch_search_in), (GDBusArgInfo **) (&_search_provider_dbus_arg_info_launch_search_out)};
static const GDBusMethodInfo * const _search_provider_dbus_method_info[] = {&_search_provider_dbus_method_info_get_initial_result_set, &_search_provider_dbus_method_info_get_subsearch_result_set, &_search_provider_dbus_method_info_get_result_metas, &_search_provider_dbus_method_info_activate_result, &_search_provider_dbus_method_info_launch_search, NULL};
static const GDBusSignalInfo * const _search_provider_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _search_provider_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _search_provider_dbus_interface_info = {-1, "org.gnome.Shell.SearchProvider2", (GDBusMethodInfo **) (&_search_provider_dbus_method_info), (GDBusSignalInfo **) (&_search_provider_dbus_signal_info), (GDBusPropertyInfo **) (&_search_provider_dbus_property_info)};
static const GDBusInterfaceVTable _search_provider_dbus_interface_vtable = {search_provider_dbus_interface_method_call, search_provider_dbus_interface_get_property, search_provider_dbus_interface_set_property};

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  int str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp20_;
		gint _tmp22_;
		gint _tmp23_;
		gsize _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		const gchar* res = NULL;
		gsize _tmp28_;
		void* _tmp29_;
		void* ptr = NULL;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		void* _tmp32_;
		const gchar* _tmp45_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp12_ = 0;
				gint _tmp13_;
				const gchar* _tmp14_;
				gsize _tmp19_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					gint _tmp8_;
					_tmp8_ = i;
					_tmp7_ = _tmp8_ < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp9_ = FALSE;
					if (str_array_length1 == -1) {
						gint _tmp10_;
						const gchar* _tmp11_;
						_tmp10_ = i;
						_tmp11_ = str_array[_tmp10_];
						_tmp9_ = _tmp11_ != NULL;
					} else {
						_tmp9_ = FALSE;
					}
					_tmp6_ = _tmp9_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp13_ = i;
				_tmp14_ = str_array[_tmp13_];
				if (_tmp14_ != NULL) {
					gint _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp15_ = i;
					_tmp16_ = str_array[_tmp15_];
					_tmp17_ = strlen ((const gchar*) _tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_;
				} else {
					_tmp12_ = 0;
				}
				_tmp19_ = len;
				len = _tmp19_ + _tmp12_;
			}
		}
		_tmp20_ = i;
		if (_tmp20_ == 0) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("");
			result = _tmp21_;
			return result;
		}
		_tmp22_ = i;
		str_array_length1 = _tmp22_;
		_tmp23_ = str_array_length1;
		_tmp24_ = len;
		_tmp25_ = strlen ((const gchar*) separator);
		_tmp26_ = _tmp25_;
		_tmp27_ = i;
		len = _tmp24_ + (_tmp26_ * (_tmp27_ - 1));
		_tmp28_ = len;
		_tmp29_ = g_malloc (_tmp28_);
		res = _tmp29_;
		_tmp30_ = res;
		_tmp31_ = str_array[0];
		_tmp32_ = g_stpcpy ((void*) _tmp30_, (const gchar*) _tmp31_);
		ptr = _tmp32_;
		{
			gboolean _tmp33_ = FALSE;
			i = 1;
			_tmp33_ = TRUE;
			while (TRUE) {
				gint _tmp35_;
				void* _tmp36_;
				void* _tmp37_;
				const gchar* _tmp38_ = NULL;
				gint _tmp39_;
				const gchar* _tmp40_;
				void* _tmp43_;
				void* _tmp44_;
				if (!_tmp33_) {
					gint _tmp34_;
					_tmp34_ = i;
					i = _tmp34_ + 1;
				}
				_tmp33_ = FALSE;
				_tmp35_ = i;
				if (!(_tmp35_ < str_array_length1)) {
					break;
				}
				_tmp36_ = ptr;
				_tmp37_ = g_stpcpy (_tmp36_, (const gchar*) separator);
				ptr = _tmp37_;
				_tmp39_ = i;
				_tmp40_ = str_array[_tmp39_];
				if (_tmp40_ != NULL) {
					gint _tmp41_;
					const gchar* _tmp42_;
					_tmp41_ = i;
					_tmp42_ = str_array[_tmp41_];
					_tmp38_ = (const gchar*) _tmp42_;
				} else {
					_tmp38_ = "";
				}
				_tmp43_ = ptr;
				_tmp44_ = g_stpcpy (_tmp43_, _tmp38_);
				ptr = _tmp44_;
			}
		}
		_tmp45_ = res;
		res = NULL;
		result = (gchar*) _tmp45_;
		return result;
	} else {
		gchar* _tmp46_;
		_tmp46_ = g_strdup ("");
		result = _tmp46_;
		return result;
	}
}


static gchar*
search_provider_terms_to_equation (gchar** terms,
                                   int terms_length1)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	_tmp0_ = _vala_g_strjoinv (" ", terms, terms_length1);
	result = _tmp0_;
	return result;
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gboolean
double_try_parse (const gchar* str,
                  gdouble* _result_,
                  const gchar* * unparsed)
{
	gdouble _vala_result = 0.0;
	const gchar* _vala_unparsed = NULL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	gdouble _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp1_ = g_ascii_strtod (str, &_tmp0_);
	endptr = _tmp0_;
	_vala_result = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
	if (unparsed) {
		*unparsed = _vala_unparsed;
	}
}


static gboolean
search_provider_can_parse (gchar** terms,
                           int terms_length1)
{
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gint exit_status = 0;
		gchar* tsep_string = NULL;
		const gchar* _tmp0_;
		gchar* _tmp1_;
		gboolean _tmp2_ = FALSE;
		const gchar* _tmp3_;
		gchar* decimal = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* equation = NULL;
		gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		gboolean _tmp19_;
		gchar* stdout_buf = NULL;
		gchar* stderr_buf = NULL;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		gint _tmp28_;
		_tmp0_ = nl_langinfo (THOUSEP);
		_tmp1_ = g_strdup (_tmp0_);
		tsep_string = _tmp1_;
		_tmp3_ = tsep_string;
		if (_tmp3_ == NULL) {
			_tmp2_ = TRUE;
		} else {
			const gchar* _tmp4_;
			_tmp4_ = tsep_string;
			_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
		}
		if (_tmp2_) {
			gchar* _tmp5_;
			_tmp5_ = g_strdup (" ");
			_g_free0 (tsep_string);
			tsep_string = _tmp5_;
		}
		_tmp6_ = nl_langinfo (RADIXCHAR);
		_tmp7_ = g_strdup (_tmp6_);
		decimal = _tmp7_;
		_tmp8_ = decimal;
		if (_tmp8_ == NULL) {
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("");
			_g_free0 (decimal);
			decimal = _tmp9_;
		}
		_tmp10_ = search_provider_terms_to_equation (terms, terms_length1);
		_tmp11_ = _tmp10_;
		_tmp12_ = tsep_string;
		_tmp13_ = string_replace (_tmp11_, _tmp12_, "");
		_tmp14_ = _tmp13_;
		_tmp15_ = decimal;
		_tmp16_ = string_replace (_tmp14_, _tmp15_, ".");
		_tmp17_ = _tmp16_;
		_g_free0 (_tmp14_);
		_g_free0 (_tmp11_);
		equation = _tmp17_;
		_tmp18_ = equation;
		_tmp19_ = double_try_parse (_tmp18_, NULL, NULL);
		if (_tmp19_) {
			result = FALSE;
			_g_free0 (equation);
			_g_free0 (decimal);
			_g_free0 (tsep_string);
			return result;
		}
		_tmp20_ = equation;
		_tmp21_ = g_shell_quote (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat ("gnome-calculator --solve ", _tmp22_, NULL);
		_tmp24_ = _tmp23_;
		g_spawn_command_line_sync (_tmp24_, &_tmp25_, &_tmp26_, &_tmp27_, &_inner_error_);
		_g_free0 (stdout_buf);
		stdout_buf = _tmp25_;
		_g_free0 (stderr_buf);
		stderr_buf = _tmp26_;
		exit_status = _tmp27_;
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (stderr_buf);
			_g_free0 (stdout_buf);
			_g_free0 (equation);
			_g_free0 (decimal);
			_g_free0 (tsep_string);
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			goto __catch0_g_error;
		}
		_tmp28_ = exit_status;
		g_spawn_check_exit_status (_tmp28_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (stderr_buf);
			_g_free0 (stdout_buf);
			_g_free0 (equation);
			_g_free0 (decimal);
			_g_free0 (tsep_string);
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			goto __catch0_g_error;
		}
		_g_free0 (stderr_buf);
		_g_free0 (stdout_buf);
		_g_free0 (equation);
		_g_free0 (decimal);
		_g_free0 (tsep_string);
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		const gchar* _tmp29_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp29_ = e->message;
		g_error ("search-provider.vala:53: Failed to spawn Calculator: %s", _tmp29_);
		_g_error_free0 (e);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp30_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp30_;
	}
	result = TRUE;
	return result;
}


static gchar**
search_provider_get_result_identifier (gchar** terms,
                                       int terms_length1,
                                       int* result_length1)
{
	gchar** result = NULL;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar** _tmp10_;
	gint _tmp10__length1;
	if (search_provider_can_parse (terms, terms_length1)) {
		gchar* _tmp0_;
		gchar** _tmp1_;
		gchar** _tmp2_;
		gint _tmp2__length1;
		gchar** _tmp3_;
		gint _tmp3__length1;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp0_ = search_provider_terms_to_equation (terms, terms_length1);
		_tmp1_ = g_new0 (gchar*, 1 + 1);
		_tmp1_[0] = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp2__length1 = 1;
		if (result_length1) {
			*result_length1 = _tmp2__length1;
		}
		result = _tmp2_;
		_tmp3_ = result;
		_tmp3__length1 = *result_length1;
		_tmp4_ = result;
		_tmp4__length1 = *result_length1;
		_vala_warn_if_fail ((_tmp3__length1 == 0) || (_tmp4__length1 == 1), "result.length == 0 || result.length == 1");
		return result;
	} else {
		gchar** _tmp5_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		gchar** _tmp7_;
		gint _tmp7__length1;
		gchar** _tmp8_;
		gint _tmp8__length1;
		_tmp5_ = g_new0 (gchar*, 0 + 1);
		_tmp6_ = _tmp5_;
		_tmp6__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp6__length1;
		}
		result = _tmp6_;
		_tmp7_ = result;
		_tmp7__length1 = *result_length1;
		_tmp8_ = result;
		_tmp8__length1 = *result_length1;
		_vala_warn_if_fail ((_tmp7__length1 == 0) || (_tmp8__length1 == 1), "result.length == 0 || result.length == 1");
		return result;
	}
	_tmp9_ = result;
	_tmp9__length1 = *result_length1;
	_tmp10_ = result;
	_tmp10__length1 = *result_length1;
	_vala_warn_if_fail ((_tmp9__length1 == 0) || (_tmp10__length1 == 1), "result.length == 0 || result.length == 1");
}


gchar**
search_provider_get_initial_result_set (SearchProvider* self,
                                        gchar** terms,
                                        int terms_length1,
                                        int* result_length1)
{
	gchar** result = NULL;
	gint _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = search_provider_get_result_identifier (terms, terms_length1, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}


gchar**
search_provider_get_subsearch_result_set (SearchProvider* self,
                                          gchar** previous_results,
                                          int previous_results_length1,
                                          gchar** terms,
                                          int terms_length1,
                                          int* result_length1)
{
	gchar** result = NULL;
	gint _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = search_provider_get_result_identifier (terms, terms_length1, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}


static void
_vala_array_add1 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add2 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}


static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}


static GVariant*
_variant_new1 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GVariant*
_variant_new2 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}


static gchar*
string_strip (const gchar* self)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static GVariant*
_variant_new3 (gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}


GHashTable**
search_provider_get_result_metas (SearchProvider* self,
                                  gchar** results,
                                  int results_length1,
                                  int* result_length1)
{
	GHashTable** result = NULL;
	GSubprocess* subprocess = NULL;
	gchar* stdout_buf = NULL;
	gchar* stderr_buf = NULL;
	gchar** argv = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint argv_length1;
	gint _argv_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	GHashTable** metadata = NULL;
	GHashTable** _tmp15_;
	gint metadata_length1;
	gint _metadata_size_;
	GHashFunc _tmp16_;
	GEqualFunc _tmp17_;
	GHashTable* _tmp18_;
	GHashTable* _tmp19_;
	GHashTable* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	GVariant* _tmp23_;
	GHashTable* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	GVariant* _tmp27_;
	GHashTable* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	GVariant* _tmp34_;
	GHashTable** _tmp35_;
	gint _tmp35__length1;
	GHashTable** _tmp36_;
	gint _tmp36__length1;
	GHashTable** _tmp37_;
	gint _tmp37__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_return_val_if_fail (results_length1 == 1, "results.length == 1", NULL);
	_tmp0_ = g_strdup ("gnome-calculator");
	_tmp1_ = g_strdup ("--solve");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	argv = _tmp2_;
	argv_length1 = 2;
	_argv_size_ = argv_length1;
	_tmp3_ = argv;
	_tmp3__length1 = argv_length1;
	_tmp4_ = results[0];
	_tmp5_ = g_strdup (_tmp4_);
	_vala_array_add1 (&argv, &argv_length1, &_argv_size_, _tmp5_);
	_tmp6_ = argv;
	_tmp6__length1 = argv_length1;
	_vala_array_add2 (&argv, &argv_length1, &_argv_size_, NULL);
	{
		GSubprocess* _tmp7_ = NULL;
		gchar** _tmp8_;
		gint _tmp8__length1;
		GSubprocess* _tmp9_;
		GSubprocess* _tmp10_;
		_tmp8_ = argv;
		_tmp8__length1 = argv_length1;
		_tmp9_ = g_subprocess_newv (_tmp8_, G_SUBPROCESS_FLAGS_STDOUT_PIPE | G_SUBPROCESS_FLAGS_STDERR_PIPE, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		_g_object_unref0 (subprocess);
		subprocess = _tmp10_;
		_g_object_unref0 (_tmp7_);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = e->message;
		g_error ("search-provider.vala:101: Failed to spawn Calculator: %s", _tmp11_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (stderr_buf);
		_g_free0 (stdout_buf);
		_g_object_unref0 (subprocess);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		g_subprocess_communicate_utf8 (subprocess, NULL, NULL, &_tmp12_, &_tmp13_, &_inner_error_);
		_g_free0 (stdout_buf);
		stdout_buf = _tmp12_;
		_g_free0 (stderr_buf);
		stderr_buf = _tmp13_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp14_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = e->message;
		g_error ("search-provider.vala:110: Failed reading result: %s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (stderr_buf);
		_g_free0 (stdout_buf);
		_g_object_unref0 (subprocess);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp15_ = g_new0 (GHashTable*, 1 + 1);
	metadata = _tmp15_;
	metadata_length1 = 1;
	_metadata_size_ = metadata_length1;
	_tmp16_ = g_str_hash;
	_tmp17_ = g_str_equal;
	_tmp18_ = g_hash_table_new_full (_tmp16_, _tmp17_, _g_free0_, _g_variant_unref0_);
	_g_hash_table_unref0 (metadata[0]);
	metadata[0] = _tmp18_;
	_tmp19_ = metadata[0];
	_tmp20_ = metadata[0];
	_tmp21_ = g_strdup ("id");
	_tmp22_ = results[0];
	_tmp23_ = _variant_new1 (_tmp22_);
	g_hash_table_insert (_tmp20_, _tmp21_, _tmp23_);
	_tmp24_ = metadata[0];
	_tmp25_ = g_strdup ("name");
	_tmp26_ = results[0];
	_tmp27_ = _variant_new2 (_tmp26_);
	g_hash_table_insert (_tmp24_, _tmp25_, _tmp27_);
	_tmp28_ = metadata[0];
	_tmp29_ = g_strdup ("description");
	_tmp30_ = string_strip (stdout_buf);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_strconcat (" = ", _tmp31_, NULL);
	_tmp33_ = _tmp32_;
	_tmp34_ = _variant_new3 (_tmp33_);
	g_hash_table_insert (_tmp28_, _tmp29_, _tmp34_);
	_g_free0 (_tmp33_);
	_g_free0 (_tmp31_);
	_tmp35_ = metadata;
	_tmp35__length1 = metadata_length1;
	if (result_length1) {
		*result_length1 = _tmp35__length1;
	}
	result = _tmp35_;
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (stderr_buf);
	_g_free0 (stdout_buf);
	_g_object_unref0 (subprocess);
	_tmp36_ = result;
	_tmp36__length1 = *result_length1;
	_vala_warn_if_fail (_tmp36__length1 == 1, "result.length == 1");
	return result;
}


static void
search_provider_spawn_and_display_equation (gchar** terms,
                                            int terms_length1)
{
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp0_ = search_provider_terms_to_equation (terms, terms_length1);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_shell_quote (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat ("gnome-calculator --equation ", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		g_spawn_command_line_async (_tmp5_, &_inner_error_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
		_g_free0 (_tmp1_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch4_g_spawn_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally4;
	__catch4_g_spawn_error:
	{
		GError* e = NULL;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e->message;
		g_error ("search-provider.vala:131: Failed to spawn Calculator: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void
search_provider_activate_result (SearchProvider* self,
                                 const gchar* _result_,
                                 gchar** terms,
                                 int terms_length1,
                                 guint32 timestamp)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (_result_ != NULL);
	search_provider_spawn_and_display_equation (terms, terms_length1);
}


void
search_provider_launch_search (SearchProvider* self,
                               gchar** terms,
                               int terms_length1,
                               guint32 timestamp)
{
	g_return_if_fail (self != NULL);
	search_provider_spawn_and_display_equation (terms, terms_length1);
}


SearchProvider*
search_provider_construct (GType object_type)
{
	SearchProvider * self = NULL;
	self = (SearchProvider*) g_object_new (object_type, NULL);
	return self;
}


SearchProvider*
search_provider_new (void)
{
	return search_provider_construct (TYPE_SEARCH_PROVIDER);
}


static void
search_provider_class_init (SearchProviderClass * klass)
{
	search_provider_parent_class = g_type_class_peek_parent (klass);
}


static void
search_provider_instance_init (SearchProvider * self)
{
}


GType
search_provider_get_type (void)
{
	static volatile gsize search_provider_type_id__volatile = 0;
	if (g_once_init_enter (&search_provider_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SearchProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchProvider), 0, (GInstanceInitFunc) search_provider_instance_init, NULL };
		GType search_provider_type_id;
		search_provider_type_id = g_type_register_static (G_TYPE_OBJECT, "SearchProvider", &g_define_type_info, 0);
		g_type_set_qdata (search_provider_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) search_provider_register_object);
		g_once_init_leave (&search_provider_type_id__volatile, search_provider_type_id);
	}
	return search_provider_type_id__volatile;
}


static void
_dbus_search_provider_get_initial_result_set (SearchProvider* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar** terms = NULL;
	int terms_length1 = 0;
	GVariant* _tmp0_;
	gchar** _tmp1_;
	int _tmp1__length;
	int _tmp1__size;
	int _tmp1__length1;
	GVariantIter _tmp2_;
	GVariant* _tmp3_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	int result_length1 = 0;
	gchar** _tmp4_;
	GVariantBuilder _tmp5_;
	int _tmp6_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp1_ = g_new (gchar*, 5);
	_tmp1__length = 0;
	_tmp1__size = 4;
	_tmp1__length1 = 0;
	g_variant_iter_init (&_tmp2_, _tmp0_);
	for (; (_tmp3_ = g_variant_iter_next_value (&_tmp2_)) != NULL; _tmp1__length1++) {
		if (_tmp1__size == _tmp1__length) {
			_tmp1__size = 2 * _tmp1__size;
			_tmp1_ = g_renew (gchar*, _tmp1_, _tmp1__size + 1);
		}
		_tmp1_[_tmp1__length++] = g_variant_dup_string (_tmp3_, NULL);
		g_variant_unref (_tmp3_);
	}
	terms_length1 = _tmp1__length1;
	_tmp1_[_tmp1__length] = NULL;
	terms = _tmp1_;
	g_variant_unref (_tmp0_);
	result = search_provider_get_initial_result_set (self, terms, terms_length1, &result_length1);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp4_ = result;
	g_variant_builder_init (&_tmp5_, G_VARIANT_TYPE ("as"));
	for (_tmp6_ = 0; _tmp6_ < result_length1; _tmp6_++) {
		g_variant_builder_add_value (&_tmp5_, g_variant_new_string (*_tmp4_));
		_tmp4_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp5_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	terms = (_vala_array_free (terms, terms_length1, (GDestroyNotify) g_free), NULL);
}


static void
_dbus_search_provider_get_subsearch_result_set (SearchProvider* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar** previous_results = NULL;
	int previous_results_length1 = 0;
	GVariant* _tmp7_;
	gchar** _tmp8_;
	int _tmp8__length;
	int _tmp8__size;
	int _tmp8__length1;
	GVariantIter _tmp9_;
	GVariant* _tmp10_;
	gchar** terms = NULL;
	int terms_length1 = 0;
	GVariant* _tmp11_;
	gchar** _tmp12_;
	int _tmp12__length;
	int _tmp12__size;
	int _tmp12__length1;
	GVariantIter _tmp13_;
	GVariant* _tmp14_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	int result_length1 = 0;
	gchar** _tmp15_;
	GVariantBuilder _tmp16_;
	int _tmp17_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp8_ = g_new (gchar*, 5);
	_tmp8__length = 0;
	_tmp8__size = 4;
	_tmp8__length1 = 0;
	g_variant_iter_init (&_tmp9_, _tmp7_);
	for (; (_tmp10_ = g_variant_iter_next_value (&_tmp9_)) != NULL; _tmp8__length1++) {
		if (_tmp8__size == _tmp8__length) {
			_tmp8__size = 2 * _tmp8__size;
			_tmp8_ = g_renew (gchar*, _tmp8_, _tmp8__size + 1);
		}
		_tmp8_[_tmp8__length++] = g_variant_dup_string (_tmp10_, NULL);
		g_variant_unref (_tmp10_);
	}
	previous_results_length1 = _tmp8__length1;
	_tmp8_[_tmp8__length] = NULL;
	previous_results = _tmp8_;
	g_variant_unref (_tmp7_);
	_tmp11_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp12_ = g_new (gchar*, 5);
	_tmp12__length = 0;
	_tmp12__size = 4;
	_tmp12__length1 = 0;
	g_variant_iter_init (&_tmp13_, _tmp11_);
	for (; (_tmp14_ = g_variant_iter_next_value (&_tmp13_)) != NULL; _tmp12__length1++) {
		if (_tmp12__size == _tmp12__length) {
			_tmp12__size = 2 * _tmp12__size;
			_tmp12_ = g_renew (gchar*, _tmp12_, _tmp12__size + 1);
		}
		_tmp12_[_tmp12__length++] = g_variant_dup_string (_tmp14_, NULL);
		g_variant_unref (_tmp14_);
	}
	terms_length1 = _tmp12__length1;
	_tmp12_[_tmp12__length] = NULL;
	terms = _tmp12_;
	g_variant_unref (_tmp11_);
	result = search_provider_get_subsearch_result_set (self, previous_results, previous_results_length1, terms, terms_length1, &result_length1);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp15_ = result;
	g_variant_builder_init (&_tmp16_, G_VARIANT_TYPE ("as"));
	for (_tmp17_ = 0; _tmp17_ < result_length1; _tmp17_++) {
		g_variant_builder_add_value (&_tmp16_, g_variant_new_string (*_tmp15_));
		_tmp15_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp16_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	previous_results = (_vala_array_free (previous_results, previous_results_length1, (GDestroyNotify) g_free), NULL);
	terms = (_vala_array_free (terms, terms_length1, (GDestroyNotify) g_free), NULL);
}


static void
_dbus_search_provider_get_result_metas (SearchProvider* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar** results = NULL;
	int results_length1 = 0;
	GVariant* _tmp18_;
	gchar** _tmp19_;
	int _tmp19__length;
	int _tmp19__size;
	int _tmp19__length1;
	GVariantIter _tmp20_;
	GVariant* _tmp21_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GHashTable** result;
	int result_length1 = 0;
	GHashTable** _tmp22_;
	GVariantBuilder _tmp23_;
	int _tmp24_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp18_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp19_ = g_new (gchar*, 5);
	_tmp19__length = 0;
	_tmp19__size = 4;
	_tmp19__length1 = 0;
	g_variant_iter_init (&_tmp20_, _tmp18_);
	for (; (_tmp21_ = g_variant_iter_next_value (&_tmp20_)) != NULL; _tmp19__length1++) {
		if (_tmp19__size == _tmp19__length) {
			_tmp19__size = 2 * _tmp19__size;
			_tmp19_ = g_renew (gchar*, _tmp19_, _tmp19__size + 1);
		}
		_tmp19_[_tmp19__length++] = g_variant_dup_string (_tmp21_, NULL);
		g_variant_unref (_tmp21_);
	}
	results_length1 = _tmp19__length1;
	_tmp19_[_tmp19__length] = NULL;
	results = _tmp19_;
	g_variant_unref (_tmp18_);
	result = search_provider_get_result_metas (self, results, results_length1, &result_length1);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp22_ = result;
	g_variant_builder_init (&_tmp23_, G_VARIANT_TYPE ("aa{sv}"));
	for (_tmp24_ = 0; _tmp24_ < result_length1; _tmp24_++) {
		GVariantBuilder _tmp25_;
		GHashTableIter _tmp26_;
		gpointer _tmp27_;
		gpointer _tmp28_;
		g_hash_table_iter_init (&_tmp26_, *_tmp22_);
		g_variant_builder_init (&_tmp25_, G_VARIANT_TYPE ("a{sv}"));
		while (g_hash_table_iter_next (&_tmp26_, &_tmp27_, &_tmp28_)) {
			gchar* _key;
			GVariant* _value;
			_key = (gchar*) _tmp27_;
			_value = (GVariant*) _tmp28_;
			g_variant_builder_add (&_tmp25_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
		}
		g_variant_builder_add_value (&_tmp23_, g_variant_builder_end (&_tmp25_));
		_tmp22_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp23_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	results = (_vala_array_free (results, results_length1, (GDestroyNotify) g_free), NULL);
}


static void
_dbus_search_provider_activate_result (SearchProvider* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* _result_ = NULL;
	GVariant* _tmp29_;
	gchar** terms = NULL;
	int terms_length1 = 0;
	GVariant* _tmp30_;
	gchar** _tmp31_;
	int _tmp31__length;
	int _tmp31__size;
	int _tmp31__length1;
	GVariantIter _tmp32_;
	GVariant* _tmp33_;
	guint32 timestamp = 0U;
	GVariant* _tmp34_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp29_ = g_variant_iter_next_value (&_arguments_iter);
	_result_ = g_variant_dup_string (_tmp29_, NULL);
	g_variant_unref (_tmp29_);
	_tmp30_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp31_ = g_new (gchar*, 5);
	_tmp31__length = 0;
	_tmp31__size = 4;
	_tmp31__length1 = 0;
	g_variant_iter_init (&_tmp32_, _tmp30_);
	for (; (_tmp33_ = g_variant_iter_next_value (&_tmp32_)) != NULL; _tmp31__length1++) {
		if (_tmp31__size == _tmp31__length) {
			_tmp31__size = 2 * _tmp31__size;
			_tmp31_ = g_renew (gchar*, _tmp31_, _tmp31__size + 1);
		}
		_tmp31_[_tmp31__length++] = g_variant_dup_string (_tmp33_, NULL);
		g_variant_unref (_tmp33_);
	}
	terms_length1 = _tmp31__length1;
	_tmp31_[_tmp31__length] = NULL;
	terms = _tmp31_;
	g_variant_unref (_tmp30_);
	_tmp34_ = g_variant_iter_next_value (&_arguments_iter);
	timestamp = g_variant_get_uint32 (_tmp34_);
	g_variant_unref (_tmp34_);
	search_provider_activate_result (self, _result_, terms, terms_length1, timestamp);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_g_free0 (_result_);
	terms = (_vala_array_free (terms, terms_length1, (GDestroyNotify) g_free), NULL);
}


static void
_dbus_search_provider_launch_search (SearchProvider* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar** terms = NULL;
	int terms_length1 = 0;
	GVariant* _tmp35_;
	gchar** _tmp36_;
	int _tmp36__length;
	int _tmp36__size;
	int _tmp36__length1;
	GVariantIter _tmp37_;
	GVariant* _tmp38_;
	guint32 timestamp = 0U;
	GVariant* _tmp39_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp35_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp36_ = g_new (gchar*, 5);
	_tmp36__length = 0;
	_tmp36__size = 4;
	_tmp36__length1 = 0;
	g_variant_iter_init (&_tmp37_, _tmp35_);
	for (; (_tmp38_ = g_variant_iter_next_value (&_tmp37_)) != NULL; _tmp36__length1++) {
		if (_tmp36__size == _tmp36__length) {
			_tmp36__size = 2 * _tmp36__size;
			_tmp36_ = g_renew (gchar*, _tmp36_, _tmp36__size + 1);
		}
		_tmp36_[_tmp36__length++] = g_variant_dup_string (_tmp38_, NULL);
		g_variant_unref (_tmp38_);
	}
	terms_length1 = _tmp36__length1;
	_tmp36_[_tmp36__length] = NULL;
	terms = _tmp36_;
	g_variant_unref (_tmp35_);
	_tmp39_ = g_variant_iter_next_value (&_arguments_iter);
	timestamp = g_variant_get_uint32 (_tmp39_);
	g_variant_unref (_tmp39_);
	search_provider_launch_search (self, terms, terms_length1, timestamp);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	terms = (_vala_array_free (terms, terms_length1, (GDestroyNotify) g_free), NULL);
}


static void
search_provider_dbus_interface_method_call (GDBusConnection* connection,
                                            const gchar* sender,
                                            const gchar* object_path,
                                            const gchar* interface_name,
                                            const gchar* method_name,
                                            GVariant* parameters,
                                            GDBusMethodInvocation* invocation,
                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetInitialResultSet") == 0) {
		_dbus_search_provider_get_initial_result_set (object, parameters, invocation);
	} else if (strcmp (method_name, "GetSubsearchResultSet") == 0) {
		_dbus_search_provider_get_subsearch_result_set (object, parameters, invocation);
	} else if (strcmp (method_name, "GetResultMetas") == 0) {
		_dbus_search_provider_get_result_metas (object, parameters, invocation);
	} else if (strcmp (method_name, "ActivateResult") == 0) {
		_dbus_search_provider_activate_result (object, parameters, invocation);
	} else if (strcmp (method_name, "LaunchSearch") == 0) {
		_dbus_search_provider_launch_search (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant*
search_provider_dbus_interface_get_property (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* property_name,
                                             GError** error,
                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean
search_provider_dbus_interface_set_property (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* property_name,
                                             GVariant* value,
                                             GError** error,
                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint
search_provider_register_object (gpointer object,
                                 GDBusConnection* connection,
                                 const gchar* path,
                                 GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_search_provider_dbus_interface_info), &_search_provider_dbus_interface_vtable, data, _search_provider_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void
_search_provider_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


SearchProviderApp*
search_provider_app_construct (GType object_type)
{
	SearchProviderApp * self = NULL;
	self = (SearchProviderApp*) g_object_new (object_type, "application-id", "org.gnome.Calculator.SearchProvider", "flags", G_APPLICATION_IS_SERVICE, "inactivity-timeout", 60000, NULL);
	return self;
}


SearchProviderApp*
search_provider_app_new (void)
{
	return search_provider_app_construct (TYPE_SEARCH_PROVIDER_APP);
}


static gboolean
search_provider_app_real_dbus_register (GApplication* base,
                                        GDBusConnection* connection,
                                        const gchar* object_path,
                                        GError** error)
{
	SearchProviderApp * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (SearchProviderApp*) base;
	g_return_val_if_fail (connection != NULL, FALSE);
	g_return_val_if_fail (object_path != NULL, FALSE);
	{
		SearchProvider* _tmp0_;
		SearchProvider* _tmp1_;
		_tmp0_ = search_provider_new ();
		_tmp1_ = _tmp0_;
		search_provider_register_object (_tmp1_, connection, object_path, &_inner_error_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp2_ = FALSE;
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch5_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp2_;
		}
	}
	goto __finally5;
	__catch5_g_io_error:
	{
		GError* _error_ = NULL;
		FILE* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = stderr;
		_tmp4_ = _error_;
		_tmp5_ = _tmp4_->message;
		fprintf (_tmp3_, "Could not register service: %s\n", _tmp5_);
		g_application_quit ((GApplication*) self);
		_g_error_free0 (_error_);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp6_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp6_;
	}
	result = TRUE;
	return result;
}


static void
search_provider_app_class_init (SearchProviderAppClass * klass)
{
	search_provider_app_parent_class = g_type_class_peek_parent (klass);
	((GApplicationClass *) klass)->dbus_register = (gboolean (*) (GApplication *, GDBusConnection*, const gchar*, GError**)) search_provider_app_real_dbus_register;
}


static void
search_provider_app_instance_init (SearchProviderApp * self)
{
}


GType
search_provider_app_get_type (void)
{
	static volatile gsize search_provider_app_type_id__volatile = 0;
	if (g_once_init_enter (&search_provider_app_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SearchProviderAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_provider_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchProviderApp), 0, (GInstanceInitFunc) search_provider_app_instance_init, NULL };
		GType search_provider_app_type_id;
		search_provider_app_type_id = g_type_register_static (g_application_get_type (), "SearchProviderApp", &g_define_type_info, 0);
		g_once_init_leave (&search_provider_app_type_id__volatile, search_provider_app_type_id);
	}
	return search_provider_app_type_id__volatile;
}


gint
_vala_main (void)
{
	gint result = 0;
	SearchProviderApp* _tmp0_;
	SearchProviderApp* _tmp1_;
	gint _tmp2_;
	setlocale (LC_ALL, "");
	_tmp0_ = search_provider_app_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_application_run ((GApplication*) _tmp1_, 0, NULL);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}


int
main (int argc,
      char ** argv)
{
	return _vala_main ();
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



