/*
 * Copyright (C) 2021 Red Hat, Inc.
 *
 * This file is part of GnuTLS.
 *
 * GnuTLS is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * GnuTLS is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>
 */

/* This file is autogenerated with tls13-early-data.c.
 * To reproduce, see the comments in that file.
 */

#ifndef GNUTLS_TESTS_CLIENT_SECRETS_H
#define GNUTLS_TESTS_CLIENT_SECRETS_H

static const struct secret client_normal_0[] = {
	{
		GNUTLS_ENCRYPTION_LEVEL_HANDSHAKE,
		32,
		(const uint8_t
			 *)"\xdc\x47\xf1\x8b\x33\xd6\x08\x26\xa1\xad\xd9\xb0\x81\xee\x32\x01\xb6\xfc\xce\x9a\xa0\x35\xd1\x30\x61\x85\x2d\xff\x3d\xb1\xe5\x49",
		(const uint8_t
			 *)"\x24\x24\xaf\xad\xa8\x0e\x40\xc6\xa1\xc3\x05\xff\x5a\xe5\x04\xb9\xc4\xc2\xff\xd6\x2b\x9a\xb8\x43\x85\x78\x92\x1e\x69\x44\x3d\xe2",
	},
	{
		GNUTLS_ENCRYPTION_LEVEL_APPLICATION,
		32,
		(const uint8_t
			 *)"\x03\x38\xcf\x43\x68\x90\x01\x7a\xdb\x06\x7d\x92\x08\xcf\x67\x22\x41\xa7\xd3\xe7\x7e\x3a\xaf\x50\xd6\x5c\xaa\xfe\x90\xa4\x87\xa2",
		(const uint8_t
			 *)"\x5c\x6f\xe8\x8b\xac\x0a\x7b\x04\x76\x9f\xe8\x2a\x7c\x06\x19\x4c\xa7\x51\x5c\xfe\xb9\x31\x25\x0d\x3b\x07\x78\xa9\xdd\x2d\x27\x72",
	},
};

static const struct secret client_normal_1[] = {
	{
		GNUTLS_ENCRYPTION_LEVEL_EARLY,
		32,
		NULL,
		(const uint8_t
			 *)"\x6f\x16\x97\x8e\x90\x94\x77\x40\x0f\x00\xff\x79\x1c\x15\x20\x19\xeb\xc6\x10\x59\x8f\x92\xac\xab\xe6\xc8\x3c\x12\x30\x94\x91\x12",
	},
	{
		GNUTLS_ENCRYPTION_LEVEL_HANDSHAKE,
		32,
		(const uint8_t
			 *)"\xf0\x91\x46\x67\xe1\x36\xb5\xd2\x30\x71\xc9\x1d\xcc\x56\xc3\x9d\xee\xfa\x26\xdb\xe4\xe2\x17\xb7\x3d\xb9\x27\x6a\x7c\xa5\xe7\xa9",
		NULL,
	},
	{
		GNUTLS_ENCRYPTION_LEVEL_HANDSHAKE,
		32,
		NULL,
		(const uint8_t
			 *)"\xe7\xf5\x57\x48\x54\x71\xae\xc0\xba\x8d\x12\x90\xc5\x25\xef\xe3\xc7\xea\x39\x09\x24\xe8\x20\x6d\x03\x8d\x80\x1e\xdd\x24\xbb\x5a",
	},
	{
		GNUTLS_ENCRYPTION_LEVEL_APPLICATION,
		32,
		(const uint8_t
			 *)"\xf8\xa9\xd5\xe6\x18\xbb\xb7\x07\x1d\xb3\x8f\x78\x61\x30\x63\x01\xa5\x49\xc6\x05\x92\x7f\x67\x98\x72\x76\x75\xb1\x31\x1f\x14\xf9",
		(const uint8_t
			 *)"\xab\xa3\xf5\x4f\xcc\x3f\xd7\xb7\x23\x73\x51\x6e\x64\xc1\xaa\x6b\xa9\x77\x30\x58\xe6\xd4\xf5\xe9\xa5\xd2\x0d\x35\x42\x65\xda\xf1",
	},
};

static const struct secret client_normal_2[] = {
	{
		GNUTLS_ENCRYPTION_LEVEL_EARLY,
		32,
		NULL,
		(const uint8_t
			 *)"\x6f\x16\x97\x8e\x90\x94\x77\x40\x0f\x00\xff\x79\x1c\x15\x20\x19\xeb\xc6\x10\x59\x8f\x92\xac\xab\xe6\xc8\x3c\x12\x30\x94\x91\x12",
	},
	{
		GNUTLS_ENCRYPTION_LEVEL_HANDSHAKE,
		32,
		(const uint8_t
			 *)"\xf0\x91\x46\x67\xe1\x36\xb5\xd2\x30\x71\xc9\x1d\xcc\x56\xc3\x9d\xee\xfa\x26\xdb\xe4\xe2\x17\xb7\x3d\xb9\x27\x6a\x7c\xa5\xe7\xa9",
		NULL,
	},
	{
		GNUTLS_ENCRYPTION_LEVEL_HANDSHAKE,
		32,
		NULL,
		(const uint8_t
			 *)"\xe7\xf5\x57\x48\x54\x71\xae\xc0\xba\x8d\x12\x90\xc5\x25\xef\xe3\xc7\xea\x39\x09\x24\xe8\x20\x6d\x03\x8d\x80\x1e\xdd\x24\xbb\x5a",
	},
	{
		GNUTLS_ENCRYPTION_LEVEL_APPLICATION,
		32,
		(const uint8_t
			 *)"\xd8\xdf\x24\xd6\xe1\xdc\x86\x3b\x88\x3d\x2b\xad\x56\xec\x22\xd4\x5c\xaf\xa9\x24\xa3\x90\x20\xa1\xae\x77\x5c\x7d\xef\x3d\xcc\x5b",
		(const uint8_t
			 *)"\x8d\x02\xe0\xe8\x5f\x9a\xcc\xc7\x8c\x81\x3b\x58\x5f\xa9\xdb\xfd\x98\xb1\x1f\xcc\x3e\x7b\xca\xe7\xef\x05\x4c\x84\x6c\xe1\x11\x25",
	},
};

static const struct secret client_small_0[] = {
	{
		GNUTLS_ENCRYPTION_LEVEL_HANDSHAKE,
		32,
		(const uint8_t
			 *)"\xdc\x47\xf1\x8b\x33\xd6\x08\x26\xa1\xad\xd9\xb0\x81\xee\x32\x01\xb6\xfc\xce\x9a\xa0\x35\xd1\x30\x61\x85\x2d\xff\x3d\xb1\xe5\x49",
		(const uint8_t
			 *)"\x24\x24\xaf\xad\xa8\x0e\x40\xc6\xa1\xc3\x05\xff\x5a\xe5\x04\xb9\xc4\xc2\xff\xd6\x2b\x9a\xb8\x43\x85\x78\x92\x1e\x69\x44\x3d\xe2",
	},
	{
		GNUTLS_ENCRYPTION_LEVEL_APPLICATION,
		32,
		(const uint8_t
			 *)"\x03\x38\xcf\x43\x68\x90\x01\x7a\xdb\x06\x7d\x92\x08\xcf\x67\x22\x41\xa7\xd3\xe7\x7e\x3a\xaf\x50\xd6\x5c\xaa\xfe\x90\xa4\x87\xa2",
		(const uint8_t
			 *)"\x5c\x6f\xe8\x8b\xac\x0a\x7b\x04\x76\x9f\xe8\x2a\x7c\x06\x19\x4c\xa7\x51\x5c\xfe\xb9\x31\x25\x0d\x3b\x07\x78\xa9\xdd\x2d\x27\x72",
	},
};

static const struct secret client_small_1[] = {
	{
		GNUTLS_ENCRYPTION_LEVEL_EARLY,
		32,
		NULL,
		(const uint8_t
			 *)"\x6f\x16\x97\x8e\x90\x94\x77\x40\x0f\x00\xff\x79\x1c\x15\x20\x19\xeb\xc6\x10\x59\x8f\x92\xac\xab\xe6\xc8\x3c\x12\x30\x94\x91\x12",
	},
	{
		GNUTLS_ENCRYPTION_LEVEL_HANDSHAKE,
		32,
		(const uint8_t
			 *)"\xf0\x91\x46\x67\xe1\x36\xb5\xd2\x30\x71\xc9\x1d\xcc\x56\xc3\x9d\xee\xfa\x26\xdb\xe4\xe2\x17\xb7\x3d\xb9\x27\x6a\x7c\xa5\xe7\xa9",
		NULL,
	},
	{
		GNUTLS_ENCRYPTION_LEVEL_HANDSHAKE,
		32,
		NULL,
		(const uint8_t
			 *)"\xe7\xf5\x57\x48\x54\x71\xae\xc0\xba\x8d\x12\x90\xc5\x25\xef\xe3\xc7\xea\x39\x09\x24\xe8\x20\x6d\x03\x8d\x80\x1e\xdd\x24\xbb\x5a",
	},
	{
		GNUTLS_ENCRYPTION_LEVEL_APPLICATION,
		32,
		(const uint8_t
			 *)"\xf8\xa9\xd5\xe6\x18\xbb\xb7\x07\x1d\xb3\x8f\x78\x61\x30\x63\x01\xa5\x49\xc6\x05\x92\x7f\x67\x98\x72\x76\x75\xb1\x31\x1f\x14\xf9",
		(const uint8_t
			 *)"\xab\xa3\xf5\x4f\xcc\x3f\xd7\xb7\x23\x73\x51\x6e\x64\xc1\xaa\x6b\xa9\x77\x30\x58\xe6\xd4\xf5\xe9\xa5\xd2\x0d\x35\x42\x65\xda\xf1",
	},
};

static const struct secret client_small_2[] = {
	{
		GNUTLS_ENCRYPTION_LEVEL_EARLY,
		32,
		NULL,
		(const uint8_t
			 *)"\x6f\x16\x97\x8e\x90\x94\x77\x40\x0f\x00\xff\x79\x1c\x15\x20\x19\xeb\xc6\x10\x59\x8f\x92\xac\xab\xe6\xc8\x3c\x12\x30\x94\x91\x12",
	},
	{
		GNUTLS_ENCRYPTION_LEVEL_HANDSHAKE,
		32,
		(const uint8_t
			 *)"\xf0\x91\x46\x67\xe1\x36\xb5\xd2\x30\x71\xc9\x1d\xcc\x56\xc3\x9d\xee\xfa\x26\xdb\xe4\xe2\x17\xb7\x3d\xb9\x27\x6a\x7c\xa5\xe7\xa9",
		NULL,
	},
	{
		GNUTLS_ENCRYPTION_LEVEL_HANDSHAKE,
		32,
		NULL,
		(const uint8_t
			 *)"\xe7\xf5\x57\x48\x54\x71\xae\xc0\xba\x8d\x12\x90\xc5\x25\xef\xe3\xc7\xea\x39\x09\x24\xe8\x20\x6d\x03\x8d\x80\x1e\xdd\x24\xbb\x5a",
	},
	{
		GNUTLS_ENCRYPTION_LEVEL_APPLICATION,
		32,
		(const uint8_t
			 *)"\xd8\xdf\x24\xd6\xe1\xdc\x86\x3b\x88\x3d\x2b\xad\x56\xec\x22\xd4\x5c\xaf\xa9\x24\xa3\x90\x20\xa1\xae\x77\x5c\x7d\xef\x3d\xcc\x5b",
		(const uint8_t
			 *)"\x8d\x02\xe0\xe8\x5f\x9a\xcc\xc7\x8c\x81\x3b\x58\x5f\xa9\xdb\xfd\x98\xb1\x1f\xcc\x3e\x7b\xca\xe7\xef\x05\x4c\x84\x6c\xe1\x11\x25",
	},
};

static const struct secret client_empty_0[] = {
	{
		GNUTLS_ENCRYPTION_LEVEL_HANDSHAKE,
		32,
		(const uint8_t
			 *)"\xdc\x47\xf1\x8b\x33\xd6\x08\x26\xa1\xad\xd9\xb0\x81\xee\x32\x01\xb6\xfc\xce\x9a\xa0\x35\xd1\x30\x61\x85\x2d\xff\x3d\xb1\xe5\x49",
		(const uint8_t
			 *)"\x24\x24\xaf\xad\xa8\x0e\x40\xc6\xa1\xc3\x05\xff\x5a\xe5\x04\xb9\xc4\xc2\xff\xd6\x2b\x9a\xb8\x43\x85\x78\x92\x1e\x69\x44\x3d\xe2",
	},
	{
		GNUTLS_ENCRYPTION_LEVEL_APPLICATION,
		32,
		(const uint8_t
			 *)"\x03\x38\xcf\x43\x68\x90\x01\x7a\xdb\x06\x7d\x92\x08\xcf\x67\x22\x41\xa7\xd3\xe7\x7e\x3a\xaf\x50\xd6\x5c\xaa\xfe\x90\xa4\x87\xa2",
		(const uint8_t
			 *)"\x5c\x6f\xe8\x8b\xac\x0a\x7b\x04\x76\x9f\xe8\x2a\x7c\x06\x19\x4c\xa7\x51\x5c\xfe\xb9\x31\x25\x0d\x3b\x07\x78\xa9\xdd\x2d\x27\x72",
	},
};

static const struct secret client_empty_1[] = {
	{
		GNUTLS_ENCRYPTION_LEVEL_HANDSHAKE,
		32,
		(const uint8_t
			 *)"\xac\xc2\x07\x48\xba\x3d\x59\x2f\x5f\xce\x79\xda\xa6\x04\x4b\x55\x06\x2c\x9f\x0e\xdf\xda\x42\x51\x9d\x0b\xd9\x39\x4b\x8c\xb2\x7e",
		(const uint8_t
			 *)"\x87\x07\x01\xdc\x13\xdc\xb7\x93\x26\x53\xff\xa4\x2d\x28\xed\xca\xef\x5b\xa7\x94\x17\x26\xdf\x1f\x8c\x7b\x79\x32\x55\x5e\xcb\x79",
	},
	{
		GNUTLS_ENCRYPTION_LEVEL_APPLICATION,
		32,
		(const uint8_t
			 *)"\x73\x16\xe6\x0a\x66\xe1\x81\xd8\x74\xfa\x25\xe3\xf3\x1a\xf2\x4d\x84\xd6\xc6\x7a\x1b\x27\x79\x0a\x09\x9e\xd2\xd4\x1d\xdf\x0f\x53",
		(const uint8_t
			 *)"\x5f\x8e\xfe\x3e\xa0\x41\x27\x9e\xbb\xba\xf2\xa9\x22\xc6\x06\x58\xb5\xbf\x6e\x29\x3d\x84\x10\x4e\x3f\xe3\xc0\x1f\x7a\x2c\xf5\x21",
	},
};

static const struct secret client_empty_2[] = {
	{
		GNUTLS_ENCRYPTION_LEVEL_HANDSHAKE,
		32,
		(const uint8_t
			 *)"\xac\xc2\x07\x48\xba\x3d\x59\x2f\x5f\xce\x79\xda\xa6\x04\x4b\x55\x06\x2c\x9f\x0e\xdf\xda\x42\x51\x9d\x0b\xd9\x39\x4b\x8c\xb2\x7e",
		(const uint8_t
			 *)"\x87\x07\x01\xdc\x13\xdc\xb7\x93\x26\x53\xff\xa4\x2d\x28\xed\xca\xef\x5b\xa7\x94\x17\x26\xdf\x1f\x8c\x7b\x79\x32\x55\x5e\xcb\x79",
	},
	{
		GNUTLS_ENCRYPTION_LEVEL_APPLICATION,
		32,
		(const uint8_t
			 *)"\x73\x16\xe6\x0a\x66\xe1\x81\xd8\x74\xfa\x25\xe3\xf3\x1a\xf2\x4d\x84\xd6\xc6\x7a\x1b\x27\x79\x0a\x09\x9e\xd2\xd4\x1d\xdf\x0f\x53",
		(const uint8_t
			 *)"\x5f\x8e\xfe\x3e\xa0\x41\x27\x9e\xbb\xba\xf2\xa9\x22\xc6\x06\x58\xb5\xbf\x6e\x29\x3d\x84\x10\x4e\x3f\xe3\xc0\x1f\x7a\x2c\xf5\x21",
	},
};

static const struct secret client_explicit_0[] = {
	{
		GNUTLS_ENCRYPTION_LEVEL_HANDSHAKE,
		32,
		(const uint8_t
			 *)"\xdc\x47\xf1\x8b\x33\xd6\x08\x26\xa1\xad\xd9\xb0\x81\xee\x32\x01\xb6\xfc\xce\x9a\xa0\x35\xd1\x30\x61\x85\x2d\xff\x3d\xb1\xe5\x49",
		(const uint8_t
			 *)"\x24\x24\xaf\xad\xa8\x0e\x40\xc6\xa1\xc3\x05\xff\x5a\xe5\x04\xb9\xc4\xc2\xff\xd6\x2b\x9a\xb8\x43\x85\x78\x92\x1e\x69\x44\x3d\xe2",
	},
	{
		GNUTLS_ENCRYPTION_LEVEL_APPLICATION,
		32,
		(const uint8_t
			 *)"\x03\x38\xcf\x43\x68\x90\x01\x7a\xdb\x06\x7d\x92\x08\xcf\x67\x22\x41\xa7\xd3\xe7\x7e\x3a\xaf\x50\xd6\x5c\xaa\xfe\x90\xa4\x87\xa2",
		(const uint8_t
			 *)"\x5c\x6f\xe8\x8b\xac\x0a\x7b\x04\x76\x9f\xe8\x2a\x7c\x06\x19\x4c\xa7\x51\x5c\xfe\xb9\x31\x25\x0d\x3b\x07\x78\xa9\xdd\x2d\x27\x72",
	},
};

static const struct secret client_explicit_1[] = {
	{
		GNUTLS_ENCRYPTION_LEVEL_EARLY,
		32,
		NULL,
		(const uint8_t
			 *)"\x6f\x16\x97\x8e\x90\x94\x77\x40\x0f\x00\xff\x79\x1c\x15\x20\x19\xeb\xc6\x10\x59\x8f\x92\xac\xab\xe6\xc8\x3c\x12\x30\x94\x91\x12",
	},
	{
		GNUTLS_ENCRYPTION_LEVEL_HANDSHAKE,
		32,
		(const uint8_t
			 *)"\xf0\x91\x46\x67\xe1\x36\xb5\xd2\x30\x71\xc9\x1d\xcc\x56\xc3\x9d\xee\xfa\x26\xdb\xe4\xe2\x17\xb7\x3d\xb9\x27\x6a\x7c\xa5\xe7\xa9",
		NULL,
	},
	{
		GNUTLS_ENCRYPTION_LEVEL_HANDSHAKE,
		32,
		NULL,
		(const uint8_t
			 *)"\xe7\xf5\x57\x48\x54\x71\xae\xc0\xba\x8d\x12\x90\xc5\x25\xef\xe3\xc7\xea\x39\x09\x24\xe8\x20\x6d\x03\x8d\x80\x1e\xdd\x24\xbb\x5a",
	},
	{
		GNUTLS_ENCRYPTION_LEVEL_APPLICATION,
		32,
		(const uint8_t
			 *)"\xf8\xa9\xd5\xe6\x18\xbb\xb7\x07\x1d\xb3\x8f\x78\x61\x30\x63\x01\xa5\x49\xc6\x05\x92\x7f\x67\x98\x72\x76\x75\xb1\x31\x1f\x14\xf9",
		(const uint8_t
			 *)"\xab\xa3\xf5\x4f\xcc\x3f\xd7\xb7\x23\x73\x51\x6e\x64\xc1\xaa\x6b\xa9\x77\x30\x58\xe6\xd4\xf5\xe9\xa5\xd2\x0d\x35\x42\x65\xda\xf1",
	},
};

static const struct secret client_explicit_2[] = {
	{
		GNUTLS_ENCRYPTION_LEVEL_EARLY,
		32,
		NULL,
		(const uint8_t
			 *)"\x6f\x16\x97\x8e\x90\x94\x77\x40\x0f\x00\xff\x79\x1c\x15\x20\x19\xeb\xc6\x10\x59\x8f\x92\xac\xab\xe6\xc8\x3c\x12\x30\x94\x91\x12",
	},
	{
		GNUTLS_ENCRYPTION_LEVEL_HANDSHAKE,
		32,
		(const uint8_t
			 *)"\xf0\x91\x46\x67\xe1\x36\xb5\xd2\x30\x71\xc9\x1d\xcc\x56\xc3\x9d\xee\xfa\x26\xdb\xe4\xe2\x17\xb7\x3d\xb9\x27\x6a\x7c\xa5\xe7\xa9",
		NULL,
	},
	{
		GNUTLS_ENCRYPTION_LEVEL_HANDSHAKE,
		32,
		NULL,
		(const uint8_t
			 *)"\xe7\xf5\x57\x48\x54\x71\xae\xc0\xba\x8d\x12\x90\xc5\x25\xef\xe3\xc7\xea\x39\x09\x24\xe8\x20\x6d\x03\x8d\x80\x1e\xdd\x24\xbb\x5a",
	},
	{
		GNUTLS_ENCRYPTION_LEVEL_APPLICATION,
		32,
		(const uint8_t
			 *)"\xd8\xdf\x24\xd6\xe1\xdc\x86\x3b\x88\x3d\x2b\xad\x56\xec\x22\xd4\x5c\xaf\xa9\x24\xa3\x90\x20\xa1\xae\x77\x5c\x7d\xef\x3d\xcc\x5b",
		(const uint8_t
			 *)"\x8d\x02\xe0\xe8\x5f\x9a\xcc\xc7\x8c\x81\x3b\x58\x5f\xa9\xdb\xfd\x98\xb1\x1f\xcc\x3e\x7b\xca\xe7\xef\x05\x4c\x84\x6c\xe1\x11\x25",
	},
};

#endif /* GNUTLS_TESTS_CLIENT_SECRETS_H */
