// SPDX-License-Identifier: GPL-2.0
/*
 * r8a7778 processor support - PFC hardware block
 *
 * Copyright (C) 2013  Renesas Solutions Corp.
 * Copyright (C) 2013  Kuninori Morimoto <kuninori.morimoto.gx@renesas.com>
 * Copyright (C) 2013  Cogent Embedded, Inc.
 * Copyright (C) 2015  Ulrich Hecht
 *
 * based on
 * Copyright (C) 2011  Renesas Solutions Corp.
 * Copyright (C) 2011  Magnus Damm
 */

#include <linux/io.h>
#include <linux/kernel.h>
#include <linux/pinctrl/pinconf-generic.h>

#include "core.h"
#include "sh_pfc.h"

#define PORT_GP_PUP_1(bank, pin, fn, sfx)	\
	PORT_GP_CFG_1(bank, pin, fn, sfx, SH_PFC_PIN_CFG_PULL_UP)

#define CPU_ALL_GP(fn, sfx)		\
	PORT_GP_CFG_32(0, fn, sfx, SH_PFC_PIN_CFG_PULL_UP),		\
	PORT_GP_CFG_32(1, fn, sfx, SH_PFC_PIN_CFG_PULL_UP),		\
	PORT_GP_CFG_32(2, fn, sfx, SH_PFC_PIN_CFG_PULL_UP),		\
	PORT_GP_CFG_32(3, fn, sfx, SH_PFC_PIN_CFG_PULL_UP),		\
	PORT_GP_CFG_27(4, fn, sfx, SH_PFC_PIN_CFG_PULL_UP)

#define CPU_ALL_NOGP(fn)		\
	PIN_NOGP(CLKOUT, "B25", fn),	\
	PIN_NOGP(CS0, "A20", fn),	\
	PIN_NOGP(CS1_A26, "C20", fn)

enum {
	PINMUX_RESERVED = 0,

	PINMUX_DATA_BEGIN,
	GP_ALL(DATA), /* GP_0_0_DATA -> GP_4_26_DATA */
	PINMUX_DATA_END,

	PINMUX_FUNCTION_BEGIN,
	GP_ALL(FN), /* GP_0_0_FN -> GP_4_26_FN */

	/* GPSR0 */
	FN_IP0_1_0,	FN_PENC0,	FN_PENC1,	FN_IP0_4_2,
	FN_IP0_7_5,	FN_IP0_11_8,	FN_IP0_14_12,	FN_A1,
	FN_A2,		FN_A3,		FN_IP0_15,	FN_IP0_16,
	FN_IP0_17,	FN_IP0_18,	FN_IP0_19,	FN_IP0_20,
	FN_IP0_21,	FN_IP0_22,	FN_IP0_23,	FN_IP0_24,
	FN_IP0_25,	FN_IP0_26,	FN_IP0_27,	FN_IP0_28,
	FN_IP0_29,	FN_IP0_30,	FN_IP1_0,	FN_IP1_1,
	FN_IP1_4_2,	FN_IP1_7_5,	FN_IP1_10_8,	FN_IP1_14_11,

	/* GPSR1 */
	FN_IP1_23_21,	FN_WE0,		FN_IP1_24,	FN_IP1_27_25,
	FN_IP1_29_28,	FN_IP2_2_0,	FN_IP2_5_3,	FN_IP2_8_6,
	FN_IP2_11_9,	FN_IP2_13_12,	FN_IP2_16_14,	FN_IP2_17,
	FN_IP2_30,	FN_IP2_31,	FN_IP3_1_0,	FN_IP3_4_2,
	FN_IP3_7_5,	FN_IP3_9_8,	FN_IP3_12_10,	FN_IP3_15_13,
	FN_IP3_18_16,	FN_IP3_20_19,	FN_IP3_23_21,	FN_IP3_26_24,
	FN_IP3_27,	FN_IP3_28,	FN_IP3_29,	FN_IP3_30,
	FN_IP3_31,	FN_IP4_0,	FN_IP4_3_1,	FN_IP4_6_4,

	/* GPSR2 */
	FN_IP4_7,	FN_IP4_8,	FN_IP4_10_9,	FN_IP4_12_11,
	FN_IP4_14_13,	FN_IP4_16_15,	FN_IP4_20_17,	FN_IP4_24_21,
	FN_IP4_26_25,	FN_IP4_28_27,	FN_IP4_30_29,	FN_IP5_1_0,
	FN_IP5_3_2,	FN_IP5_5_4,	FN_IP5_6,	FN_IP5_7,
	FN_IP5_9_8,	FN_IP5_11_10,	FN_IP5_12,	FN_IP5_14_13,
	FN_IP5_17_15,	FN_IP5_20_18,	FN_AUDIO_CLKA,	FN_AUDIO_CLKB,
	FN_IP5_22_21,	FN_IP5_25_23,	FN_IP5_28_26,	FN_IP5_30_29,
	FN_IP6_1_0,	FN_IP6_4_2,	FN_IP6_6_5,	FN_IP6_7,

	/* GPSR3 */
	FN_IP6_8,	FN_IP6_9,	FN_SSI_SCK34,	FN_IP6_10,
	FN_IP6_12_11,	FN_IP6_13,	FN_IP6_15_14,	FN_IP6_16,
	FN_IP6_18_17,	FN_IP6_20_19,	FN_IP6_21,	FN_IP6_23_22,
	FN_IP6_25_24,	FN_IP6_27_26,	FN_IP6_29_28,	FN_IP6_31_30,
	FN_IP7_1_0,	FN_IP7_3_2,	FN_IP7_5_4,	FN_IP7_8_6,
	FN_IP7_11_9,	FN_IP7_14_12,	FN_IP7_17_15,	FN_IP7_20_18,
	FN_IP7_21,	FN_IP7_24_22,	FN_IP7_28_25,	FN_IP7_31_29,
	FN_IP8_2_0,	FN_IP8_5_3,	FN_IP8_8_6,	FN_IP8_10_9,

	/* GPSR4 */
	FN_IP8_13_11,	FN_IP8_15_14,	FN_IP8_18_16,	FN_IP8_21_19,
	FN_IP8_23_22,	FN_IP8_26_24,	FN_IP8_29_27,	FN_IP9_2_0,
	FN_IP9_5_3,	FN_IP9_8_6,	FN_IP9_11_9,	FN_IP9_14_12,
	FN_IP9_17_15,	FN_IP9_20_18,	FN_IP9_23_21,	FN_IP9_26_24,
	FN_IP9_29_27,	FN_IP10_2_0,	FN_IP10_5_3,	FN_IP10_8_6,
	FN_IP10_12_9,	FN_IP10_15_13,	FN_IP10_18_16,	FN_IP10_21_19,
	FN_IP10_24_22,	FN_AVS1,	FN_AVS2,

	/* IPSR0 */
	FN_PRESETOUT,	FN_PWM1,	FN_AUDATA0,	FN_ARM_TRACEDATA_0,
	FN_GPSCLK_C,	FN_USB_OVC0,	FN_TX2_E,	FN_SDA2_B,
	FN_AUDATA1,	FN_ARM_TRACEDATA_1,		FN_GPSIN_C,
	FN_USB_OVC1,	FN_RX2_E,	FN_SCL2_B,	FN_SD1_DAT2_A,
	FN_MMC_D2,	FN_BS,		FN_ATADIR0_A,	FN_SDSELF_A,
	FN_PWM4_B,	FN_SD1_DAT3_A,	FN_MMC_D3,	FN_A0,
	FN_ATAG0_A,	FN_REMOCON_B,	FN_A4,		FN_A5,
	FN_A6,		FN_A7,		FN_A8,		FN_A9,
	FN_A10,		FN_A11,		FN_A12,		FN_A13,
	FN_A14,		FN_A15,		FN_A16,		FN_A17,
	FN_A18,		FN_A19,

	/* IPSR1 */
	FN_A20,		FN_HSPI_CS1_B,	FN_A21,		FN_HSPI_CLK1_B,
	FN_A22,		FN_HRTS0_B,	FN_RX2_B,	FN_DREQ2_A,
	FN_A23,		FN_HTX0_B,	FN_TX2_B,	FN_DACK2_A,
	FN_TS_SDEN0_A,	FN_SD1_CD_A,	FN_MMC_D6,	FN_A24,
	FN_DREQ1_A,	FN_HRX0_B,	FN_TS_SPSYNC0_A,
	FN_SD1_WP_A,	FN_MMC_D7,	FN_A25,	FN_DACK1_A,
	FN_HCTS0_B,	FN_RX3_C,	FN_TS_SDAT0_A,	FN_CLKOUT,
	FN_HSPI_TX1_B,	FN_PWM0_B,	FN_CS0,		FN_HSPI_RX1_B,
	FN_SSI_SCK1_B,	FN_ATAG0_B,	FN_CS1_A26,	FN_SDA2_A,
	FN_SCK2_B,	FN_MMC_D5,	FN_ATADIR0_B,	FN_RD_WR,
	FN_WE1,		FN_ATAWR0_B,	FN_SSI_WS1_B,	FN_EX_CS0,
	FN_SCL2_A,	FN_TX3_C,	FN_TS_SCK0_A,	FN_EX_CS1,
	FN_MMC_D4,

	/* IPSR2 */
	FN_SD1_CLK_A,	FN_MMC_CLK,	FN_ATACS00,	FN_EX_CS2,
	FN_SD1_CMD_A,	FN_MMC_CMD,	FN_ATACS10,	FN_EX_CS3,
	FN_SD1_DAT0_A,	FN_MMC_D0,	FN_ATARD0,	FN_EX_CS4,
	FN_EX_WAIT1_A,	FN_SD1_DAT1_A,	FN_MMC_D1,	FN_ATAWR0_A,
	FN_EX_CS5,	FN_EX_WAIT2_A,	FN_DREQ0_A,	FN_RX3_A,
	FN_DACK0,	FN_TX3_A,	FN_DRACK0,	FN_EX_WAIT0,
	FN_PWM0_C,	FN_D0,		FN_D1,		FN_D2,
	FN_D3,		FN_D4,		FN_D5,		FN_D6,
	FN_D7,		FN_D8,		FN_D9,		FN_D10,
	FN_D11,		FN_RD_WR_B,	FN_IRQ0,	FN_MLB_CLK,
	FN_IRQ1_A,

	/* IPSR3 */
	FN_MLB_SIG,	FN_RX5_B,	FN_SDA3_A,	FN_IRQ2_A,
	FN_MLB_DAT,	FN_TX5_B,	FN_SCL3_A,	FN_IRQ3_A,
	FN_SDSELF_B,	FN_SD1_CMD_B,	FN_SCIF_CLK,	FN_AUDIO_CLKOUT_B,
	FN_CAN_CLK_B,	FN_SDA3_B,	FN_SD1_CLK_B,	FN_HTX0_A,
	FN_TX0_A,	FN_SD1_DAT0_B,	FN_HRX0_A,	FN_RX0_A,
	FN_SD1_DAT1_B,	FN_HSCK0,	FN_SCK0,	FN_SCL3_B,
	FN_SD1_DAT2_B,	FN_HCTS0_A,	FN_CTS0,	FN_SD1_DAT3_B,
	FN_HRTS0_A,	FN_RTS0,	FN_SSI_SCK4,	FN_DU0_DR0,
	FN_LCDOUT0,	FN_AUDATA2,	FN_ARM_TRACEDATA_2,
	FN_SDA3_C,	FN_ADICHS1,	FN_TS_SDEN0_B,	FN_SSI_WS4,
	FN_DU0_DR1,	FN_LCDOUT1,	FN_AUDATA3,	FN_ARM_TRACEDATA_3,
	FN_SCL3_C,	FN_ADICHS2,	FN_TS_SPSYNC0_B,
	FN_DU0_DR2,	FN_LCDOUT2,	FN_DU0_DR3,	FN_LCDOUT3,
	FN_DU0_DR4,	FN_LCDOUT4,	FN_DU0_DR5,	FN_LCDOUT5,
	FN_DU0_DR6,	FN_LCDOUT6,

	/* IPSR4 */
	FN_DU0_DR7,	FN_LCDOUT7,	FN_DU0_DG0,	FN_LCDOUT8,
	FN_AUDATA4,	FN_ARM_TRACEDATA_4,		FN_TX1_D,
	FN_CAN0_TX_A,	FN_ADICHS0,	FN_DU0_DG1,	FN_LCDOUT9,
	FN_AUDATA5,	FN_ARM_TRACEDATA_5,		FN_RX1_D,
	FN_CAN0_RX_A,	FN_ADIDATA,	FN_DU0_DG2,	FN_LCDOUT10,
	FN_DU0_DG3,	FN_LCDOUT11,	FN_DU0_DG4,	FN_LCDOUT12,
	FN_RX0_B,	FN_DU0_DG5,	FN_LCDOUT13,	FN_TX0_B,
	FN_DU0_DG6,	FN_LCDOUT14,	FN_RX4_A,	FN_DU0_DG7,
	FN_LCDOUT15,	FN_TX4_A,	FN_SSI_SCK2_B,	FN_VI0_R0_B,
	FN_DU0_DB0,	FN_LCDOUT16,	FN_AUDATA6,	FN_ARM_TRACEDATA_6,
	FN_GPSCLK_A,	FN_PWM0_A,	FN_ADICLK,	FN_TS_SDAT0_B,
	FN_AUDIO_CLKC,	FN_VI0_R1_B,	FN_DU0_DB1,	FN_LCDOUT17,
	FN_AUDATA7,	FN_ARM_TRACEDATA_7,		FN_GPSIN_A,
	FN_ADICS_SAMP,	FN_TS_SCK0_B,	FN_VI0_R2_B,	FN_DU0_DB2,
	FN_LCDOUT18,	FN_VI0_R3_B,	FN_DU0_DB3,	FN_LCDOUT19,
	FN_VI0_R4_B,	FN_DU0_DB4,	FN_LCDOUT20,

	/* IPSR5 */
	FN_VI0_R5_B,	FN_DU0_DB5,	FN_LCDOUT21,	FN_VI1_DATA10_B,
	FN_DU0_DB6,	FN_LCDOUT22,	FN_VI1_DATA11_B,
	FN_DU0_DB7,	FN_LCDOUT23,	FN_DU0_DOTCLKIN,
	FN_QSTVA_QVS,	FN_DU0_DOTCLKO_UT0,		FN_QCLK,
	FN_DU0_DOTCLKO_UT1,		FN_QSTVB_QVE,	FN_AUDIO_CLKOUT_A,
	FN_REMOCON_C,	FN_SSI_WS2_B,	FN_DU0_EXHSYNC_DU0_HSYNC,
	FN_QSTH_QHS,	FN_DU0_EXVSYNC_DU0_VSYNC,	FN_QSTB_QHE,
	FN_DU0_EXODDF_DU0_ODDF_DISP_CDE,
	FN_QCPV_QDE,	FN_FMCLK_D,	FN_SSI_SCK1_A,	FN_DU0_DISP,
	FN_QPOLA,	FN_AUDCK,	FN_ARM_TRACECLK,
	FN_BPFCLK_D,	FN_SSI_WS1_A,	FN_DU0_CDE,	FN_QPOLB,
	FN_AUDSYNC,	FN_ARM_TRACECTL,		FN_FMIN_D,
	FN_SD1_CD_B,	FN_SSI_SCK78,	FN_HSPI_RX0_B,	FN_TX1_B,
	FN_SD1_WP_B,	FN_SSI_WS78,	FN_HSPI_CLK0_B,	FN_RX1_B,
	FN_CAN_CLK_D,	FN_SSI_SDATA8,	FN_SSI_SCK2_A,	FN_HSPI_CS0_B,
	FN_TX2_A,	FN_CAN0_TX_B,	FN_SSI_SDATA7,	FN_HSPI_TX0_B,
	FN_RX2_A,	FN_CAN0_RX_B,

	/* IPSR6 */
	FN_SSI_SCK6,	FN_HSPI_RX2_A,	FN_FMCLK_B,	FN_CAN1_TX_B,
	FN_SSI_WS6,	FN_HSPI_CLK2_A,	FN_BPFCLK_B,	FN_CAN1_RX_B,
	FN_SSI_SDATA6,	FN_HSPI_TX2_A,	FN_FMIN_B,	FN_SSI_SCK5,
	FN_RX4_C,	FN_SSI_WS5,	FN_TX4_C,	FN_SSI_SDATA5,
	FN_RX0_D,	FN_SSI_WS34,	FN_ARM_TRACEDATA_8,
	FN_SSI_SDATA4,	FN_SSI_WS2_A,	FN_ARM_TRACEDATA_9,
	FN_SSI_SDATA3,	FN_ARM_TRACEDATA_10,
	FN_SSI_SCK012,	FN_ARM_TRACEDATA_11,
	FN_TX0_D,	FN_SSI_WS012,	FN_ARM_TRACEDATA_12,
	FN_SSI_SDATA2,	FN_HSPI_CS2_A,	FN_ARM_TRACEDATA_13,
	FN_SDA1_A,	FN_SSI_SDATA1,	FN_ARM_TRACEDATA_14,
	FN_SCL1_A,	FN_SCK2_A,	FN_SSI_SDATA0,
	FN_ARM_TRACEDATA_15,
	FN_SD0_CLK,	FN_SUB_TDO,	FN_SD0_CMD,	FN_SUB_TRST,
	FN_SD0_DAT0,	FN_SUB_TMS,	FN_SD0_DAT1,	FN_SUB_TCK,
	FN_SD0_DAT2,	FN_SUB_TDI,

	/* IPSR7 */
	FN_SD0_DAT3,	FN_IRQ1_B,	FN_SD0_CD,	FN_TX5_A,
	FN_SD0_WP,	FN_RX5_A,	FN_VI1_CLKENB,	FN_HSPI_CLK0_A,
	FN_HTX1_A,	FN_RTS1_C,	FN_VI1_FIELD,	FN_HSPI_CS0_A,
	FN_HRX1_A,	FN_SCK1_C,	FN_VI1_HSYNC,	FN_HSPI_RX0_A,
	FN_HRTS1_A,	FN_FMCLK_A,	FN_RX1_C,	FN_VI1_VSYNC,
	FN_HSPI_TX0,	FN_HCTS1_A,	FN_BPFCLK_A,	FN_TX1_C,
	FN_TCLK0,	FN_HSCK1_A,	FN_FMIN_A,	FN_IRQ2_C,
	FN_CTS1_C,	FN_SPEEDIN,	FN_VI0_CLK,	FN_CAN_CLK_A,
	FN_VI0_CLKENB,	FN_SD2_DAT2_B,	FN_VI1_DATA0,	FN_DU1_DG6,
	FN_HSPI_RX1_A,	FN_RX4_B,	FN_VI0_FIELD,	FN_SD2_DAT3_B,
	FN_VI0_R3_C,	FN_VI1_DATA1,	FN_DU1_DG7,	FN_HSPI_CLK1_A,
	FN_TX4_B,	FN_VI0_HSYNC,	FN_SD2_CD_B,	FN_VI1_DATA2,
	FN_DU1_DR2,	FN_HSPI_CS1_A,	FN_RX3_B,

	/* IPSR8 */
	FN_VI0_VSYNC,	FN_SD2_WP_B,	FN_VI1_DATA3,	FN_DU1_DR3,
	FN_HSPI_TX1_A,	FN_TX3_B,	FN_VI0_DATA0_VI0_B0,
	FN_DU1_DG2,	FN_IRQ2_B,	FN_RX3_D,	FN_VI0_DATA1_VI0_B1,
	FN_DU1_DG3,	FN_IRQ3_B,	FN_TX3_D,	FN_VI0_DATA2_VI0_B2,
	FN_DU1_DG4,	FN_RX0_C,	FN_VI0_DATA3_VI0_B3,
	FN_DU1_DG5,	FN_TX1_A,	FN_TX0_C,	FN_VI0_DATA4_VI0_B4,
	FN_DU1_DB2,	FN_RX1_A,	FN_VI0_DATA5_VI0_B5,
	FN_DU1_DB3,	FN_SCK1_A,	FN_PWM4,	FN_HSCK1_B,
	FN_VI0_DATA6_VI0_G0,		FN_DU1_DB4,	FN_CTS1_A,
	FN_PWM5,	FN_VI0_DATA7_VI0_G1,		FN_DU1_DB5,
	FN_RTS1_A,	FN_VI0_G2,	FN_SD2_CLK_B,	FN_VI1_DATA4,
	FN_DU1_DR4,	FN_HTX1_B,	FN_VI0_G3,	FN_SD2_CMD_B,
	FN_VI1_DATA5,	FN_DU1_DR5,	FN_HRX1_B,

	/* IPSR9 */
	FN_VI0_G4,	FN_SD2_DAT0_B,	FN_VI1_DATA6,	FN_DU1_DR6,
	FN_HRTS1_B,	FN_VI0_G5,	FN_SD2_DAT1_B,	FN_VI1_DATA7,
	FN_DU1_DR7,	FN_HCTS1_B,	FN_VI0_R0_A,	FN_VI1_CLK,
	FN_ETH_REF_CLK,	FN_DU1_DOTCLKIN,		FN_VI0_R1_A,
	FN_VI1_DATA8,	FN_DU1_DB6,	FN_ETH_TXD0,	FN_PWM2,
	FN_TCLK1,	FN_VI0_R2_A,	FN_VI1_DATA9,	FN_DU1_DB7,
	FN_ETH_TXD1,	FN_PWM3,	FN_VI0_R3_A,	FN_ETH_CRS_DV,
	FN_IECLK,	FN_SCK2_C,	FN_VI0_R4_A,	FN_ETH_TX_EN,
	FN_IETX,	FN_TX2_C,	FN_VI0_R5_A,	FN_ETH_RX_ER,
	FN_FMCLK_C,	FN_IERX,	FN_RX2_C,	FN_VI1_DATA10_A,
	FN_DU1_DOTCLKOUT,		FN_ETH_RXD0,	FN_BPFCLK_C,
	FN_TX2_D,	FN_SDA2_C,	FN_VI1_DATA11_A,
	FN_DU1_EXHSYNC_DU1_HSYNC,	FN_ETH_RXD1,	FN_FMIN_C,
	FN_RX2_D,	FN_SCL2_C,

	/* IPSR10 */
	FN_SD2_CLK_A,	FN_DU1_EXVSYNC_DU1_VSYNC,	FN_ATARD1,
	FN_ETH_MDC,	FN_SDA1_B,	FN_SD2_CMD_A,
	FN_DU1_EXODDF_DU1_ODDF_DISP_CDE,		FN_ATAWR1,
	FN_ETH_MDIO,	FN_SCL1_B,	FN_SD2_DAT0_A,	FN_DU1_DISP,
	FN_ATACS01,	FN_DREQ1_B,	FN_ETH_LINK,	FN_CAN1_RX_A,
	FN_SD2_DAT1_A,	FN_DU1_CDE,	FN_ATACS11,	FN_DACK1_B,
	FN_ETH_MAGIC,	FN_CAN1_TX_A,	FN_PWM6,	FN_SD2_DAT2_A,
	FN_VI1_DATA12,	FN_DREQ2_B,	FN_ATADIR1,	FN_HSPI_CLK2_B,
	FN_GPSCLK_B,	FN_SD2_DAT3_A,	FN_VI1_DATA13,	FN_DACK2_B,
	FN_ATAG1,	FN_HSPI_CS2_B,	FN_GPSIN_B,	FN_SD2_CD_A,
	FN_VI1_DATA14,	FN_EX_WAIT1_B,	FN_DREQ0_B,	FN_HSPI_RX2_B,
	FN_REMOCON_A,	FN_SD2_WP_A,	FN_VI1_DATA15,	FN_EX_WAIT2_B,
	FN_DACK0_B,	FN_HSPI_TX2_B,	FN_CAN_CLK_C,

	/* SEL */
	FN_SEL_SCIF5_A,	FN_SEL_SCIF5_B,
	FN_SEL_SCIF4_A,	FN_SEL_SCIF4_B,	FN_SEL_SCIF4_C,
	FN_SEL_SCIF3_A,	FN_SEL_SCIF3_B,	FN_SEL_SCIF3_C,	FN_SEL_SCIF3_D,
	FN_SEL_SCIF2_A,	FN_SEL_SCIF2_B,	FN_SEL_SCIF2_C,	FN_SEL_SCIF2_D,	FN_SEL_SCIF2_E,
	FN_SEL_SCIF1_A,	FN_SEL_SCIF1_B,	FN_SEL_SCIF1_C,	FN_SEL_SCIF1_D,
	FN_SEL_SCIF0_A,	FN_SEL_SCIF0_B,	FN_SEL_SCIF0_C,	FN_SEL_SCIF0_D,
	FN_SEL_SSI2_A,	FN_SEL_SSI2_B,
	FN_SEL_SSI1_A,	FN_SEL_SSI1_B,
	FN_SEL_VI1_A,	FN_SEL_VI1_B,
	FN_SEL_VI0_A,	FN_SEL_VI0_B,	FN_SEL_VI0_C,	FN_SEL_VI0_D,
	FN_SEL_SD2_A,	FN_SEL_SD2_B,
	FN_SEL_SD1_A,	FN_SEL_SD1_B,
	FN_SEL_IRQ3_A,	FN_SEL_IRQ3_B,
	FN_SEL_IRQ2_A,	FN_SEL_IRQ2_B,	FN_SEL_IRQ2_C,
	FN_SEL_IRQ1_A,	FN_SEL_IRQ1_B,
	FN_SEL_DREQ2_A,	FN_SEL_DREQ2_B,
	FN_SEL_DREQ1_A,	FN_SEL_DREQ1_B,
	FN_SEL_DREQ0_A,	FN_SEL_DREQ0_B,
	FN_SEL_WAIT2_A,	FN_SEL_WAIT2_B,
	FN_SEL_WAIT1_A,	FN_SEL_WAIT1_B,
	FN_SEL_CAN1_A,	FN_SEL_CAN1_B,
	FN_SEL_CAN0_A,	FN_SEL_CAN0_B,
	FN_SEL_CANCLK_A,	FN_SEL_CANCLK_B,
	FN_SEL_CANCLK_C,	FN_SEL_CANCLK_D,
	FN_SEL_HSCIF1_A,	FN_SEL_HSCIF1_B,
	FN_SEL_HSCIF0_A,	FN_SEL_HSCIF0_B,
	FN_SEL_REMOCON_A,	FN_SEL_REMOCON_B,	FN_SEL_REMOCON_C,
	FN_SEL_FM_A,	FN_SEL_FM_B,	FN_SEL_FM_C,	FN_SEL_FM_D,
	FN_SEL_GPS_A,	FN_SEL_GPS_B,	FN_SEL_GPS_C,
	FN_SEL_TSIF0_A,	FN_SEL_TSIF0_B,
	FN_SEL_HSPI2_A,	FN_SEL_HSPI2_B,
	FN_SEL_HSPI1_A,	FN_SEL_HSPI1_B,
	FN_SEL_HSPI0_A,	FN_SEL_HSPI0_B,
	FN_SEL_I2C3_A,	FN_SEL_I2C3_B,	FN_SEL_I2C3_C,
	FN_SEL_I2C2_A,	FN_SEL_I2C2_B,	FN_SEL_I2C2_C,
	FN_SEL_I2C1_A,	FN_SEL_I2C1_B,
	PINMUX_FUNCTION_END,

	PINMUX_MARK_BEGIN,

	/* GPSR0 */
	PENC0_MARK,	PENC1_MARK,	A1_MARK,	A2_MARK,	A3_MARK,

	/* GPSR1 */
	WE0_MARK,

	/* GPSR2 */
	AUDIO_CLKA_MARK,
	AUDIO_CLKB_MARK,

	/* GPSR3 */
	SSI_SCK34_MARK,

	/* GPSR4 */
	AVS1_MARK,
	AVS2_MARK,

	VI0_R0_C_MARK,		/* see sel_vi0 */
	VI0_R1_C_MARK,		/* see sel_vi0 */
	VI0_R2_C_MARK,		/* see sel_vi0 */
	/* VI0_R3_C_MARK, */
	VI0_R4_C_MARK,		/* see sel_vi0 */
	VI0_R5_C_MARK,		/* see sel_vi0 */

	VI0_R0_D_MARK,		/* see sel_vi0 */
	VI0_R1_D_MARK,		/* see sel_vi0 */
	VI0_R2_D_MARK,		/* see sel_vi0 */
	VI0_R3_D_MARK,		/* see sel_vi0 */
	VI0_R4_D_MARK,		/* see sel_vi0 */
	VI0_R5_D_MARK,		/* see sel_vi0 */

	/* IPSR0 */
	PRESETOUT_MARK,	PWM1_MARK,	AUDATA0_MARK,
	ARM_TRACEDATA_0_MARK,		GPSCLK_C_MARK,	USB_OVC0_MARK,
	TX2_E_MARK,	SDA2_B_MARK,	AUDATA1_MARK,	ARM_TRACEDATA_1_MARK,
	GPSIN_C_MARK,	USB_OVC1_MARK,	RX2_E_MARK,	SCL2_B_MARK,
	SD1_DAT2_A_MARK,		MMC_D2_MARK,	BS_MARK,
	ATADIR0_A_MARK,	SDSELF_A_MARK,	PWM4_B_MARK,	SD1_DAT3_A_MARK,
	MMC_D3_MARK,	A0_MARK,	ATAG0_A_MARK,	REMOCON_B_MARK,
	A4_MARK,	A5_MARK,	A6_MARK,	A7_MARK,
	A8_MARK,	A9_MARK,	A10_MARK,	A11_MARK,
	A12_MARK,	A13_MARK,	A14_MARK,	A15_MARK,
	A16_MARK,	A17_MARK,	A18_MARK,	A19_MARK,

	/* IPSR1 */
	A20_MARK,	HSPI_CS1_B_MARK,		A21_MARK,
	HSPI_CLK1_B_MARK,		A22_MARK,	HRTS0_B_MARK,
	RX2_B_MARK,	DREQ2_A_MARK,	A23_MARK,	HTX0_B_MARK,
	TX2_B_MARK,	DACK2_A_MARK,	TS_SDEN0_A_MARK,
	SD1_CD_A_MARK,	MMC_D6_MARK,	A24_MARK,	DREQ1_A_MARK,
	HRX0_B_MARK,	TS_SPSYNC0_A_MARK,		SD1_WP_A_MARK,
	MMC_D7_MARK,	A25_MARK,	DACK1_A_MARK,	HCTS0_B_MARK,
	RX3_C_MARK,	TS_SDAT0_A_MARK,		CLKOUT_MARK,
	HSPI_TX1_B_MARK,		PWM0_B_MARK,	CS0_MARK,
	HSPI_RX1_B_MARK,		SSI_SCK1_B_MARK,
	ATAG0_B_MARK,	CS1_A26_MARK,	SDA2_A_MARK,	SCK2_B_MARK,
	MMC_D5_MARK,	ATADIR0_B_MARK,	RD_WR_MARK,	WE1_MARK,
	ATAWR0_B_MARK,	SSI_WS1_B_MARK,	EX_CS0_MARK,	SCL2_A_MARK,
	TX3_C_MARK,	TS_SCK0_A_MARK,	EX_CS1_MARK,	MMC_D4_MARK,

	/* IPSR2 */
	SD1_CLK_A_MARK,	MMC_CLK_MARK,	ATACS00_MARK,	EX_CS2_MARK,
	SD1_CMD_A_MARK,	MMC_CMD_MARK,	ATACS10_MARK,	EX_CS3_MARK,
	SD1_DAT0_A_MARK,		MMC_D0_MARK,	ATARD0_MARK,
	EX_CS4_MARK,	EX_WAIT1_A_MARK,		SD1_DAT1_A_MARK,
	MMC_D1_MARK,	ATAWR0_A_MARK,	EX_CS5_MARK,	EX_WAIT2_A_MARK,
	DREQ0_A_MARK,	RX3_A_MARK,	DACK0_MARK,	TX3_A_MARK,
	DRACK0_MARK,	EX_WAIT0_MARK,	PWM0_C_MARK,	D0_MARK,
	D1_MARK,	D2_MARK,	D3_MARK,	D4_MARK,
	D5_MARK,	D6_MARK,	D7_MARK,	D8_MARK,
	D9_MARK,	D10_MARK,	D11_MARK,	RD_WR_B_MARK,
	IRQ0_MARK,	MLB_CLK_MARK,	IRQ1_A_MARK,

	/* IPSR3 */
	MLB_SIG_MARK,	RX5_B_MARK,	SDA3_A_MARK,	IRQ2_A_MARK,
	MLB_DAT_MARK,	TX5_B_MARK,	SCL3_A_MARK,	IRQ3_A_MARK,
	SDSELF_B_MARK,	SD1_CMD_B_MARK,	SCIF_CLK_MARK,	AUDIO_CLKOUT_B_MARK,
	CAN_CLK_B_MARK,	SDA3_B_MARK,	SD1_CLK_B_MARK,	HTX0_A_MARK,
	TX0_A_MARK,	SD1_DAT0_B_MARK,		HRX0_A_MARK,
	RX0_A_MARK,	SD1_DAT1_B_MARK,		HSCK0_MARK,
	SCK0_MARK,	SCL3_B_MARK,	SD1_DAT2_B_MARK,
	HCTS0_A_MARK,	CTS0_MARK,	SD1_DAT3_B_MARK,
	HRTS0_A_MARK,	RTS0_MARK,	SSI_SCK4_MARK,
	DU0_DR0_MARK,	LCDOUT0_MARK,	AUDATA2_MARK,	ARM_TRACEDATA_2_MARK,
	SDA3_C_MARK,	ADICHS1_MARK,	TS_SDEN0_B_MARK,
	SSI_WS4_MARK,	DU0_DR1_MARK,	LCDOUT1_MARK,	AUDATA3_MARK,
	ARM_TRACEDATA_3_MARK,		SCL3_C_MARK,	ADICHS2_MARK,
	TS_SPSYNC0_B_MARK,		DU0_DR2_MARK,	LCDOUT2_MARK,
	DU0_DR3_MARK,	LCDOUT3_MARK,	DU0_DR4_MARK,	LCDOUT4_MARK,
	DU0_DR5_MARK,	LCDOUT5_MARK,	DU0_DR6_MARK,	LCDOUT6_MARK,

	/* IPSR4 */
	DU0_DR7_MARK,	LCDOUT7_MARK,	DU0_DG0_MARK,	LCDOUT8_MARK,
	AUDATA4_MARK,	ARM_TRACEDATA_4_MARK,
	TX1_D_MARK,	CAN0_TX_A_MARK,	ADICHS0_MARK,	DU0_DG1_MARK,
	LCDOUT9_MARK,	AUDATA5_MARK,	ARM_TRACEDATA_5_MARK,
	RX1_D_MARK,	CAN0_RX_A_MARK,	ADIDATA_MARK,	DU0_DG2_MARK,
	LCDOUT10_MARK,	DU0_DG3_MARK,	LCDOUT11_MARK,	DU0_DG4_MARK,
	LCDOUT12_MARK,	RX0_B_MARK,	DU0_DG5_MARK,	LCDOUT13_MARK,
	TX0_B_MARK,	DU0_DG6_MARK,	LCDOUT14_MARK,	RX4_A_MARK,
	DU0_DG7_MARK,	LCDOUT15_MARK,	TX4_A_MARK,	SSI_SCK2_B_MARK,
	VI0_R0_B_MARK,	DU0_DB0_MARK,	LCDOUT16_MARK,	AUDATA6_MARK,
	ARM_TRACEDATA_6_MARK,		GPSCLK_A_MARK,	PWM0_A_MARK,
	ADICLK_MARK,	TS_SDAT0_B_MARK,		AUDIO_CLKC_MARK,
	VI0_R1_B_MARK,	DU0_DB1_MARK,	LCDOUT17_MARK,	AUDATA7_MARK,
	ARM_TRACEDATA_7_MARK,		GPSIN_A_MARK,	ADICS_SAMP_MARK,
	TS_SCK0_B_MARK,	VI0_R2_B_MARK,	DU0_DB2_MARK,	LCDOUT18_MARK,
	VI0_R3_B_MARK,	DU0_DB3_MARK,	LCDOUT19_MARK,	VI0_R4_B_MARK,
	DU0_DB4_MARK,	LCDOUT20_MARK,

	/* IPSR5 */
	VI0_R5_B_MARK,	DU0_DB5_MARK,	LCDOUT21_MARK,	VI1_DATA10_B_MARK,
	DU0_DB6_MARK,	LCDOUT22_MARK,	VI1_DATA11_B_MARK,
	DU0_DB7_MARK,	LCDOUT23_MARK,	DU0_DOTCLKIN_MARK,
	QSTVA_QVS_MARK,	DU0_DOTCLKO_UT0_MARK,
	QCLK_MARK,	DU0_DOTCLKO_UT1_MARK,		QSTVB_QVE_MARK,
	AUDIO_CLKOUT_A_MARK,		REMOCON_C_MARK,	SSI_WS2_B_MARK,
	DU0_EXHSYNC_DU0_HSYNC_MARK,	QSTH_QHS_MARK,
	DU0_EXVSYNC_DU0_VSYNC_MARK,	QSTB_QHE_MARK,
	DU0_EXODDF_DU0_ODDF_DISP_CDE_MARK,
	QCPV_QDE_MARK,	FMCLK_D_MARK,	SSI_SCK1_A_MARK,
	DU0_DISP_MARK,	QPOLA_MARK,	AUDCK_MARK,	ARM_TRACECLK_MARK,
	BPFCLK_D_MARK,	SSI_WS1_A_MARK,	DU0_CDE_MARK,	QPOLB_MARK,
	AUDSYNC_MARK,	ARM_TRACECTL_MARK,		FMIN_D_MARK,
	SD1_CD_B_MARK,	SSI_SCK78_MARK,	HSPI_RX0_B_MARK,
	TX1_B_MARK,	SD1_WP_B_MARK,	SSI_WS78_MARK,	HSPI_CLK0_B_MARK,
	RX1_B_MARK,	CAN_CLK_D_MARK,	SSI_SDATA8_MARK,
	SSI_SCK2_A_MARK,		HSPI_CS0_B_MARK,
	TX2_A_MARK,	CAN0_TX_B_MARK,	SSI_SDATA7_MARK,
	HSPI_TX0_B_MARK,		RX2_A_MARK,	CAN0_RX_B_MARK,

	/* IPSR6 */
	SSI_SCK6_MARK,	HSPI_RX2_A_MARK,		FMCLK_B_MARK,
	CAN1_TX_B_MARK,	SSI_WS6_MARK,	HSPI_CLK2_A_MARK,
	BPFCLK_B_MARK,	CAN1_RX_B_MARK,	SSI_SDATA6_MARK,
	HSPI_TX2_A_MARK,		FMIN_B_MARK,	SSI_SCK5_MARK,
	RX4_C_MARK,	SSI_WS5_MARK,	TX4_C_MARK,	SSI_SDATA5_MARK,
	RX0_D_MARK,	SSI_WS34_MARK,	ARM_TRACEDATA_8_MARK,
	SSI_SDATA4_MARK,		SSI_WS2_A_MARK,	ARM_TRACEDATA_9_MARK,
	SSI_SDATA3_MARK,		ARM_TRACEDATA_10_MARK,
	SSI_SCK012_MARK,		ARM_TRACEDATA_11_MARK,
	TX0_D_MARK,	SSI_WS012_MARK,	ARM_TRACEDATA_12_MARK,
	SSI_SDATA2_MARK,		HSPI_CS2_A_MARK,
	ARM_TRACEDATA_13_MARK,		SDA1_A_MARK,	SSI_SDATA1_MARK,
	ARM_TRACEDATA_14_MARK,		SCL1_A_MARK,	SCK2_A_MARK,
	SSI_SDATA0_MARK,		ARM_TRACEDATA_15_MARK,
	SD0_CLK_MARK,	SUB_TDO_MARK,	SD0_CMD_MARK,	SUB_TRST_MARK,
	SD0_DAT0_MARK,	SUB_TMS_MARK,	SD0_DAT1_MARK,	SUB_TCK_MARK,
	SD0_DAT2_MARK,	SUB_TDI_MARK,

	/* IPSR7 */
	SD0_DAT3_MARK,	IRQ1_B_MARK,	SD0_CD_MARK,	TX5_A_MARK,
	SD0_WP_MARK,	RX5_A_MARK,	VI1_CLKENB_MARK,
	HSPI_CLK0_A_MARK,	HTX1_A_MARK,	RTS1_C_MARK,	VI1_FIELD_MARK,
	HSPI_CS0_A_MARK,	HRX1_A_MARK,	SCK1_C_MARK,	VI1_HSYNC_MARK,
	HSPI_RX0_A_MARK,	HRTS1_A_MARK,	FMCLK_A_MARK,	RX1_C_MARK,
	VI1_VSYNC_MARK,	HSPI_TX0_MARK,	HCTS1_A_MARK,	BPFCLK_A_MARK,
	TX1_C_MARK,	TCLK0_MARK,	HSCK1_A_MARK,	FMIN_A_MARK,
	IRQ2_C_MARK,	CTS1_C_MARK,	SPEEDIN_MARK,	VI0_CLK_MARK,
	CAN_CLK_A_MARK,	VI0_CLKENB_MARK,		SD2_DAT2_B_MARK,
	VI1_DATA0_MARK,	DU1_DG6_MARK,	HSPI_RX1_A_MARK,
	RX4_B_MARK,	VI0_FIELD_MARK,	SD2_DAT3_B_MARK,
	VI0_R3_C_MARK,	VI1_DATA1_MARK,	DU1_DG7_MARK,	HSPI_CLK1_A_MARK,
	TX4_B_MARK,	VI0_HSYNC_MARK,	SD2_CD_B_MARK,	VI1_DATA2_MARK,
	DU1_DR2_MARK,	HSPI_CS1_A_MARK,		RX3_B_MARK,

	/* IPSR8 */
	VI0_VSYNC_MARK,	SD2_WP_B_MARK,	VI1_DATA3_MARK,	DU1_DR3_MARK,
	HSPI_TX1_A_MARK,		TX3_B_MARK,	VI0_DATA0_VI0_B0_MARK,
	DU1_DG2_MARK,	IRQ2_B_MARK,	RX3_D_MARK,	VI0_DATA1_VI0_B1_MARK,
	DU1_DG3_MARK,	IRQ3_B_MARK,	TX3_D_MARK,	VI0_DATA2_VI0_B2_MARK,
	DU1_DG4_MARK,	RX0_C_MARK,	VI0_DATA3_VI0_B3_MARK,
	DU1_DG5_MARK,	TX1_A_MARK,	TX0_C_MARK,	VI0_DATA4_VI0_B4_MARK,
	DU1_DB2_MARK,	RX1_A_MARK,	VI0_DATA5_VI0_B5_MARK,
	DU1_DB3_MARK,	SCK1_A_MARK,	PWM4_MARK,	HSCK1_B_MARK,
	VI0_DATA6_VI0_G0_MARK,		DU1_DB4_MARK,	CTS1_A_MARK,
	PWM5_MARK,	VI0_DATA7_VI0_G1_MARK,		DU1_DB5_MARK,
	RTS1_A_MARK,	VI0_G2_MARK,	SD2_CLK_B_MARK,	VI1_DATA4_MARK,
	DU1_DR4_MARK,	HTX1_B_MARK,	VI0_G3_MARK,	SD2_CMD_B_MARK,
	VI1_DATA5_MARK,	DU1_DR5_MARK,	HRX1_B_MARK,

	/* IPSR9 */
	VI0_G4_MARK,	SD2_DAT0_B_MARK,		VI1_DATA6_MARK,
	DU1_DR6_MARK,	HRTS1_B_MARK,	VI0_G5_MARK,	SD2_DAT1_B_MARK,
	VI1_DATA7_MARK,	DU1_DR7_MARK,	HCTS1_B_MARK,	VI0_R0_A_MARK,
	VI1_CLK_MARK,	ETH_REF_CLK_MARK,		DU1_DOTCLKIN_MARK,
	VI0_R1_A_MARK,	VI1_DATA8_MARK,	DU1_DB6_MARK,	ETH_TXD0_MARK,
	PWM2_MARK,	TCLK1_MARK,	VI0_R2_A_MARK,	VI1_DATA9_MARK,
	DU1_DB7_MARK,	ETH_TXD1_MARK,	PWM3_MARK,	VI0_R3_A_MARK,
	ETH_CRS_DV_MARK,		IECLK_MARK,	SCK2_C_MARK,
	VI0_R4_A_MARK,			ETH_TX_EN_MARK,	IETX_MARK,
	TX2_C_MARK,	VI0_R5_A_MARK,	ETH_RX_ER_MARK,	FMCLK_C_MARK,
	IERX_MARK,	RX2_C_MARK,	VI1_DATA10_A_MARK,
	DU1_DOTCLKOUT_MARK,		ETH_RXD0_MARK,
	BPFCLK_C_MARK,	TX2_D_MARK,	SDA2_C_MARK,	VI1_DATA11_A_MARK,
	DU1_EXHSYNC_DU1_HSYNC_MARK,	ETH_RXD1_MARK,	FMIN_C_MARK,
	RX2_D_MARK,	SCL2_C_MARK,

	/* IPSR10 */
	SD2_CLK_A_MARK,	DU1_EXVSYNC_DU1_VSYNC_MARK,	ATARD1_MARK,
	ETH_MDC_MARK,	SDA1_B_MARK,	SD2_CMD_A_MARK,
	DU1_EXODDF_DU1_ODDF_DISP_CDE_MARK,		ATAWR1_MARK,
	ETH_MDIO_MARK,	SCL1_B_MARK,	SD2_DAT0_A_MARK,
	DU1_DISP_MARK,	ATACS01_MARK,	DREQ1_B_MARK,	ETH_LINK_MARK,
	CAN1_RX_A_MARK,	SD2_DAT1_A_MARK,		DU1_CDE_MARK,
	ATACS11_MARK,	DACK1_B_MARK,	ETH_MAGIC_MARK,	CAN1_TX_A_MARK,
	PWM6_MARK,	SD2_DAT2_A_MARK,		VI1_DATA12_MARK,
	DREQ2_B_MARK,	ATADIR1_MARK,	HSPI_CLK2_B_MARK,
	GPSCLK_B_MARK,	SD2_DAT3_A_MARK,		VI1_DATA13_MARK,
	DACK2_B_MARK,	ATAG1_MARK,	HSPI_CS2_B_MARK,
	GPSIN_B_MARK,	SD2_CD_A_MARK,	VI1_DATA14_MARK,
	EX_WAIT1_B_MARK,		DREQ0_B_MARK,	HSPI_RX2_B_MARK,
	REMOCON_A_MARK,	SD2_WP_A_MARK,	VI1_DATA15_MARK,
	EX_WAIT2_B_MARK,		DACK0_B_MARK,
	HSPI_TX2_B_MARK,		CAN_CLK_C_MARK,

	PINMUX_MARK_END,
};

static const u16 pinmux_data[] = {
	PINMUX_DATA_GP_ALL(), /* PINMUX_DATA(GP_M_N_DATA, GP_M_N_FN...), */

	PINMUX_SINGLE(PENC0),
	PINMUX_SINGLE(PENC1),
	PINMUX_SINGLE(A1),
	PINMUX_SINGLE(A2),
	PINMUX_SINGLE(A3),
	PINMUX_SINGLE(WE0),
	PINMUX_SINGLE(AUDIO_CLKA),
	PINMUX_SINGLE(AUDIO_CLKB),
	PINMUX_SINGLE(SSI_SCK34),
	PINMUX_SINGLE(AVS1),
	PINMUX_SINGLE(AVS2),

	/* IPSR0 */
	PINMUX_IPSR_GPSR(IP0_1_0,	PRESETOUT),
	PINMUX_IPSR_GPSR(IP0_1_0,	PWM1),

	PINMUX_IPSR_GPSR(IP0_4_2,	AUDATA0),
	PINMUX_IPSR_GPSR(IP0_4_2,	ARM_TRACEDATA_0),
	PINMUX_IPSR_MSEL(IP0_4_2,	GPSCLK_C,	SEL_GPS_C),
	PINMUX_IPSR_GPSR(IP0_4_2,	USB_OVC0),
	PINMUX_IPSR_GPSR(IP0_4_2,	TX2_E),
	PINMUX_IPSR_MSEL(IP0_4_2,	SDA2_B,		SEL_I2C2_B),

	PINMUX_IPSR_GPSR(IP0_7_5,	AUDATA1),
	PINMUX_IPSR_GPSR(IP0_7_5,	ARM_TRACEDATA_1),
	PINMUX_IPSR_MSEL(IP0_7_5,	GPSIN_C,	SEL_GPS_C),
	PINMUX_IPSR_GPSR(IP0_7_5,	USB_OVC1),
	PINMUX_IPSR_MSEL(IP0_7_5,	RX2_E,		SEL_SCIF2_E),
	PINMUX_IPSR_MSEL(IP0_7_5,	SCL2_B,		SEL_I2C2_B),

	PINMUX_IPSR_MSEL(IP0_11_8,	SD1_DAT2_A,	SEL_SD1_A),
	PINMUX_IPSR_GPSR(IP0_11_8,	MMC_D2),
	PINMUX_IPSR_GPSR(IP0_11_8,	BS),
	PINMUX_IPSR_GPSR(IP0_11_8,	ATADIR0_A),
	PINMUX_IPSR_GPSR(IP0_11_8,	SDSELF_A),
	PINMUX_IPSR_GPSR(IP0_11_8,	PWM4_B),

	PINMUX_IPSR_MSEL(IP0_14_12,	SD1_DAT3_A,	SEL_SD1_A),
	PINMUX_IPSR_GPSR(IP0_14_12,	MMC_D3),
	PINMUX_IPSR_GPSR(IP0_14_12,	A0),
	PINMUX_IPSR_GPSR(IP0_14_12,	ATAG0_A),
	PINMUX_IPSR_MSEL(IP0_14_12,	REMOCON_B,	SEL_REMOCON_B),

	PINMUX_IPSR_GPSR(IP0_15,	A4),
	PINMUX_IPSR_GPSR(IP0_16,	A5),
	PINMUX_IPSR_GPSR(IP0_17,	A6),
	PINMUX_IPSR_GPSR(IP0_18,	A7),
	PINMUX_IPSR_GPSR(IP0_19,	A8),
	PINMUX_IPSR_GPSR(IP0_20,	A9),
	PINMUX_IPSR_GPSR(IP0_21,	A10),
	PINMUX_IPSR_GPSR(IP0_22,	A11),
	PINMUX_IPSR_GPSR(IP0_23,	A12),
	PINMUX_IPSR_GPSR(IP0_24,	A13),
	PINMUX_IPSR_GPSR(IP0_25,	A14),
	PINMUX_IPSR_GPSR(IP0_26,	A15),
	PINMUX_IPSR_GPSR(IP0_27,	A16),
	PINMUX_IPSR_GPSR(IP0_28,	A17),
	PINMUX_IPSR_GPSR(IP0_29,	A18),
	PINMUX_IPSR_GPSR(IP0_30,	A19),

	/* IPSR1 */
	PINMUX_IPSR_GPSR(IP1_0,		A20),
	PINMUX_IPSR_MSEL(IP1_0,		HSPI_CS1_B,	SEL_HSPI1_B),

	PINMUX_IPSR_GPSR(IP1_1,		A21),
	PINMUX_IPSR_MSEL(IP1_1,		HSPI_CLK1_B,	SEL_HSPI1_B),

	PINMUX_IPSR_GPSR(IP1_4_2,	A22),
	PINMUX_IPSR_MSEL(IP1_4_2,	HRTS0_B,	SEL_HSCIF0_B),
	PINMUX_IPSR_MSEL(IP1_4_2,	RX2_B,		SEL_SCIF2_B),
	PINMUX_IPSR_MSEL(IP1_4_2,	DREQ2_A,	SEL_DREQ2_A),

	PINMUX_IPSR_GPSR(IP1_7_5,	A23),
	PINMUX_IPSR_GPSR(IP1_7_5,	HTX0_B),
	PINMUX_IPSR_GPSR(IP1_7_5,	TX2_B),
	PINMUX_IPSR_GPSR(IP1_7_5,	DACK2_A),
	PINMUX_IPSR_MSEL(IP1_7_5,	TS_SDEN0_A,	SEL_TSIF0_A),

	PINMUX_IPSR_MSEL(IP1_10_8,	SD1_CD_A,	SEL_SD1_A),
	PINMUX_IPSR_GPSR(IP1_10_8,	MMC_D6),
	PINMUX_IPSR_GPSR(IP1_10_8,	A24),
	PINMUX_IPSR_MSEL(IP1_10_8,	DREQ1_A,	SEL_DREQ1_A),
	PINMUX_IPSR_MSEL(IP1_10_8,	HRX0_B,		SEL_HSCIF0_B),
	PINMUX_IPSR_MSEL(IP1_10_8,	TS_SPSYNC0_A,	SEL_TSIF0_A),

	PINMUX_IPSR_MSEL(IP1_14_11,	SD1_WP_A,	SEL_SD1_A),
	PINMUX_IPSR_GPSR(IP1_14_11,	MMC_D7),
	PINMUX_IPSR_GPSR(IP1_14_11,	A25),
	PINMUX_IPSR_GPSR(IP1_14_11,	DACK1_A),
	PINMUX_IPSR_MSEL(IP1_14_11,	HCTS0_B,	SEL_HSCIF0_B),
	PINMUX_IPSR_MSEL(IP1_14_11,	RX3_C,		SEL_SCIF3_C),
	PINMUX_IPSR_MSEL(IP1_14_11,	TS_SDAT0_A,	SEL_TSIF0_A),

	PINMUX_IPSR_NOGP(IP1_16_15,	CLKOUT),
	PINMUX_IPSR_NOGP(IP1_16_15,	HSPI_TX1_B),
	PINMUX_IPSR_NOGP(IP1_16_15,	PWM0_B),

	PINMUX_IPSR_NOGP(IP1_17,	CS0),
	PINMUX_IPSR_NOGM(IP1_17,	HSPI_RX1_B,	SEL_HSPI1_B),

	PINMUX_IPSR_NOGM(IP1_20_18,	SSI_SCK1_B,	SEL_SSI1_B),
	PINMUX_IPSR_NOGP(IP1_20_18,	ATAG0_B),
	PINMUX_IPSR_NOGP(IP1_20_18,	CS1_A26),
	PINMUX_IPSR_NOGM(IP1_20_18,	SDA2_A,		SEL_I2C2_A),
	PINMUX_IPSR_NOGM(IP1_20_18,	SCK2_B,		SEL_SCIF2_B),

	PINMUX_IPSR_GPSR(IP1_23_21,	MMC_D5),
	PINMUX_IPSR_GPSR(IP1_23_21,	ATADIR0_B),
	PINMUX_IPSR_GPSR(IP1_23_21,	RD_WR),

	PINMUX_IPSR_GPSR(IP1_24,	WE1),
	PINMUX_IPSR_GPSR(IP1_24,	ATAWR0_B),

	PINMUX_IPSR_MSEL(IP1_27_25,	SSI_WS1_B,	SEL_SSI1_B),
	PINMUX_IPSR_GPSR(IP1_27_25,	EX_CS0),
	PINMUX_IPSR_MSEL(IP1_27_25,	SCL2_A,		SEL_I2C2_A),
	PINMUX_IPSR_GPSR(IP1_27_25,	TX3_C),
	PINMUX_IPSR_MSEL(IP1_27_25,	TS_SCK0_A,	SEL_TSIF0_A),

	PINMUX_IPSR_GPSR(IP1_29_28,	EX_CS1),
	PINMUX_IPSR_GPSR(IP1_29_28,	MMC_D4),

	/* IPSR2 */
	PINMUX_IPSR_GPSR(IP2_2_0,	SD1_CLK_A),
	PINMUX_IPSR_GPSR(IP2_2_0,	MMC_CLK),
	PINMUX_IPSR_GPSR(IP2_2_0,	ATACS00),
	PINMUX_IPSR_GPSR(IP2_2_0,	EX_CS2),

	PINMUX_IPSR_MSEL(IP2_5_3,	SD1_CMD_A,	SEL_SD1_A),
	PINMUX_IPSR_GPSR(IP2_5_3,	MMC_CMD),
	PINMUX_IPSR_GPSR(IP2_5_3,	ATACS10),
	PINMUX_IPSR_GPSR(IP2_5_3,	EX_CS3),

	PINMUX_IPSR_MSEL(IP2_8_6,	SD1_DAT0_A,	SEL_SD1_A),
	PINMUX_IPSR_GPSR(IP2_8_6,	MMC_D0),
	PINMUX_IPSR_GPSR(IP2_8_6,	ATARD0),
	PINMUX_IPSR_GPSR(IP2_8_6,	EX_CS4),
	PINMUX_IPSR_MSEL(IP2_8_6,	EX_WAIT1_A,	SEL_WAIT1_A),

	PINMUX_IPSR_MSEL(IP2_11_9,	SD1_DAT1_A,	SEL_SD1_A),
	PINMUX_IPSR_GPSR(IP2_11_9,	MMC_D1),
	PINMUX_IPSR_GPSR(IP2_11_9,	ATAWR0_A),
	PINMUX_IPSR_GPSR(IP2_11_9,	EX_CS5),
	PINMUX_IPSR_MSEL(IP2_11_9,	EX_WAIT2_A,	SEL_WAIT2_A),

	PINMUX_IPSR_MSEL(IP2_13_12,	DREQ0_A,	SEL_DREQ0_A),
	PINMUX_IPSR_MSEL(IP2_13_12,	RX3_A,		SEL_SCIF3_A),

	PINMUX_IPSR_GPSR(IP2_16_14,	DACK0),
	PINMUX_IPSR_GPSR(IP2_16_14,	TX3_A),
	PINMUX_IPSR_GPSR(IP2_16_14,	DRACK0),

	PINMUX_IPSR_GPSR(IP2_17,	EX_WAIT0),
	PINMUX_IPSR_GPSR(IP2_17,	PWM0_C),

	PINMUX_IPSR_NOGP(IP2_18,	D0),
	PINMUX_IPSR_NOGP(IP2_19,	D1),
	PINMUX_IPSR_NOGP(IP2_20,	D2),
	PINMUX_IPSR_NOGP(IP2_21,	D3),
	PINMUX_IPSR_NOGP(IP2_22,	D4),
	PINMUX_IPSR_NOGP(IP2_23,	D5),
	PINMUX_IPSR_NOGP(IP2_24,	D6),
	PINMUX_IPSR_NOGP(IP2_25,	D7),
	PINMUX_IPSR_NOGP(IP2_26,	D8),
	PINMUX_IPSR_NOGP(IP2_27,	D9),
	PINMUX_IPSR_NOGP(IP2_28,	D10),
	PINMUX_IPSR_NOGP(IP2_29,	D11),

	PINMUX_IPSR_GPSR(IP2_30,	RD_WR_B),
	PINMUX_IPSR_GPSR(IP2_30,	IRQ0),

	PINMUX_IPSR_GPSR(IP2_31,	MLB_CLK),
	PINMUX_IPSR_MSEL(IP2_31,	IRQ1_A,		SEL_IRQ1_A),

	/* IPSR3 */
	PINMUX_IPSR_GPSR(IP3_1_0,	MLB_SIG),
	PINMUX_IPSR_MSEL(IP3_1_0,	RX5_B,		SEL_SCIF5_B),
	PINMUX_IPSR_MSEL(IP3_1_0,	SDA3_A,		SEL_I2C3_A),
	PINMUX_IPSR_MSEL(IP3_1_0,	IRQ2_A,		SEL_IRQ2_A),

	PINMUX_IPSR_GPSR(IP3_4_2,	MLB_DAT),
	PINMUX_IPSR_GPSR(IP3_4_2,	TX5_B),
	PINMUX_IPSR_MSEL(IP3_4_2,	SCL3_A,		SEL_I2C3_A),
	PINMUX_IPSR_MSEL(IP3_4_2,	IRQ3_A,		SEL_IRQ3_A),
	PINMUX_IPSR_GPSR(IP3_4_2,	SDSELF_B),

	PINMUX_IPSR_MSEL(IP3_7_5,	SD1_CMD_B,	SEL_SD1_B),
	PINMUX_IPSR_GPSR(IP3_7_5,	SCIF_CLK),
	PINMUX_IPSR_GPSR(IP3_7_5,	AUDIO_CLKOUT_B),
	PINMUX_IPSR_MSEL(IP3_7_5,	CAN_CLK_B,	SEL_CANCLK_B),
	PINMUX_IPSR_MSEL(IP3_7_5,	SDA3_B,		SEL_I2C3_B),

	PINMUX_IPSR_GPSR(IP3_9_8,	SD1_CLK_B),
	PINMUX_IPSR_GPSR(IP3_9_8,	HTX0_A),
	PINMUX_IPSR_GPSR(IP3_9_8,	TX0_A),

	PINMUX_IPSR_MSEL(IP3_12_10,	SD1_DAT0_B,	SEL_SD1_B),
	PINMUX_IPSR_MSEL(IP3_12_10,	HRX0_A,		SEL_HSCIF0_A),
	PINMUX_IPSR_MSEL(IP3_12_10,	RX0_A,		SEL_SCIF0_A),

	PINMUX_IPSR_MSEL(IP3_15_13,	SD1_DAT1_B,	SEL_SD1_B),
	PINMUX_IPSR_MSEL(IP3_15_13,	HSCK0,		SEL_HSCIF0_A),
	PINMUX_IPSR_GPSR(IP3_15_13,	SCK0),
	PINMUX_IPSR_MSEL(IP3_15_13,	SCL3_B,		SEL_I2C3_B),

	PINMUX_IPSR_MSEL(IP3_18_16,	SD1_DAT2_B,	SEL_SD1_B),
	PINMUX_IPSR_MSEL(IP3_18_16,	HCTS0_A,	SEL_HSCIF0_A),
	PINMUX_IPSR_GPSR(IP3_18_16,	CTS0),

	PINMUX_IPSR_MSEL(IP3_20_19,	SD1_DAT3_B,	SEL_SD1_B),
	PINMUX_IPSR_MSEL(IP3_20_19,	HRTS0_A,	SEL_HSCIF0_A),
	PINMUX_IPSR_GPSR(IP3_20_19,	RTS0),

	PINMUX_IPSR_GPSR(IP3_23_21,	SSI_SCK4),
	PINMUX_IPSR_GPSR(IP3_23_21,	DU0_DR0),
	PINMUX_IPSR_GPSR(IP3_23_21,	LCDOUT0),
	PINMUX_IPSR_GPSR(IP3_23_21,	AUDATA2),
	PINMUX_IPSR_GPSR(IP3_23_21,	ARM_TRACEDATA_2),
	PINMUX_IPSR_MSEL(IP3_23_21,	SDA3_C,		SEL_I2C3_C),
	PINMUX_IPSR_GPSR(IP3_23_21,	ADICHS1),
	PINMUX_IPSR_MSEL(IP3_23_21,	TS_SDEN0_B,	SEL_TSIF0_B),

	PINMUX_IPSR_GPSR(IP3_26_24,	SSI_WS4),
	PINMUX_IPSR_GPSR(IP3_26_24,	DU0_DR1),
	PINMUX_IPSR_GPSR(IP3_26_24,	LCDOUT1),
	PINMUX_IPSR_GPSR(IP3_26_24,	AUDATA3),
	PINMUX_IPSR_GPSR(IP3_26_24,	ARM_TRACEDATA_3),
	PINMUX_IPSR_MSEL(IP3_26_24,	SCL3_C,		SEL_I2C3_C),
	PINMUX_IPSR_GPSR(IP3_26_24,	ADICHS2),
	PINMUX_IPSR_MSEL(IP3_26_24,	TS_SPSYNC0_B,	SEL_TSIF0_B),

	PINMUX_IPSR_GPSR(IP3_27,	DU0_DR2),
	PINMUX_IPSR_GPSR(IP3_27,	LCDOUT2),

	PINMUX_IPSR_GPSR(IP3_28,	DU0_DR3),
	PINMUX_IPSR_GPSR(IP3_28,	LCDOUT3),

	PINMUX_IPSR_GPSR(IP3_29,	DU0_DR4),
	PINMUX_IPSR_GPSR(IP3_29,	LCDOUT4),

	PINMUX_IPSR_GPSR(IP3_30,	DU0_DR5),
	PINMUX_IPSR_GPSR(IP3_30,	LCDOUT5),

	PINMUX_IPSR_GPSR(IP3_31,	DU0_DR6),
	PINMUX_IPSR_GPSR(IP3_31,	LCDOUT6),

	/* IPSR4 */
	PINMUX_IPSR_GPSR(IP4_0,		DU0_DR7),
	PINMUX_IPSR_GPSR(IP4_0,		LCDOUT7),

	PINMUX_IPSR_GPSR(IP4_3_1,	DU0_DG0),
	PINMUX_IPSR_GPSR(IP4_3_1,	LCDOUT8),
	PINMUX_IPSR_GPSR(IP4_3_1,	AUDATA4),
	PINMUX_IPSR_GPSR(IP4_3_1,	ARM_TRACEDATA_4),
	PINMUX_IPSR_GPSR(IP4_3_1,	TX1_D),
	PINMUX_IPSR_GPSR(IP4_3_1,	CAN0_TX_A),
	PINMUX_IPSR_GPSR(IP4_3_1,	ADICHS0),

	PINMUX_IPSR_GPSR(IP4_6_4,	DU0_DG1),
	PINMUX_IPSR_GPSR(IP4_6_4,	LCDOUT9),
	PINMUX_IPSR_GPSR(IP4_6_4,	AUDATA5),
	PINMUX_IPSR_GPSR(IP4_6_4,	ARM_TRACEDATA_5),
	PINMUX_IPSR_MSEL(IP4_6_4,	RX1_D,		SEL_SCIF1_D),
	PINMUX_IPSR_MSEL(IP4_6_4,	CAN0_RX_A,	SEL_CAN0_A),
	PINMUX_IPSR_GPSR(IP4_6_4,	ADIDATA),

	PINMUX_IPSR_GPSR(IP4_7,		DU0_DG2),
	PINMUX_IPSR_GPSR(IP4_7,		LCDOUT10),

	PINMUX_IPSR_GPSR(IP4_8,		DU0_DG3),
	PINMUX_IPSR_GPSR(IP4_8,		LCDOUT11),

	PINMUX_IPSR_GPSR(IP4_10_9,	DU0_DG4),
	PINMUX_IPSR_GPSR(IP4_10_9,	LCDOUT12),
	PINMUX_IPSR_MSEL(IP4_10_9,	RX0_B,		SEL_SCIF0_B),

	PINMUX_IPSR_GPSR(IP4_12_11,	DU0_DG5),
	PINMUX_IPSR_GPSR(IP4_12_11,	LCDOUT13),
	PINMUX_IPSR_GPSR(IP4_12_11,	TX0_B),

	PINMUX_IPSR_GPSR(IP4_14_13,	DU0_DG6),
	PINMUX_IPSR_GPSR(IP4_14_13,	LCDOUT14),
	PINMUX_IPSR_MSEL(IP4_14_13,	RX4_A,		SEL_SCIF4_A),

	PINMUX_IPSR_GPSR(IP4_16_15,	DU0_DG7),
	PINMUX_IPSR_GPSR(IP4_16_15,	LCDOUT15),
	PINMUX_IPSR_GPSR(IP4_16_15,	TX4_A),

	PINMUX_IPSR_MSEL(IP4_20_17,	SSI_SCK2_B,	SEL_SSI2_B),
	PINMUX_DATA(VI0_R0_B_MARK,	FN_IP4_20_17,	FN_VI0_R0_B,	FN_SEL_VI0_B), /* see sel_vi0 */
	PINMUX_DATA(VI0_R0_D_MARK,	FN_IP4_20_17,	FN_VI0_R0_B,	FN_SEL_VI0_D), /* see sel_vi0 */
	PINMUX_IPSR_GPSR(IP4_20_17,	DU0_DB0),
	PINMUX_IPSR_GPSR(IP4_20_17,	LCDOUT16),
	PINMUX_IPSR_GPSR(IP4_20_17,	AUDATA6),
	PINMUX_IPSR_GPSR(IP4_20_17,	ARM_TRACEDATA_6),
	PINMUX_IPSR_MSEL(IP4_20_17,	GPSCLK_A,	SEL_GPS_A),
	PINMUX_IPSR_GPSR(IP4_20_17,	PWM0_A),
	PINMUX_IPSR_GPSR(IP4_20_17,	ADICLK),
	PINMUX_IPSR_MSEL(IP4_20_17,	TS_SDAT0_B,	SEL_TSIF0_B),

	PINMUX_IPSR_GPSR(IP4_24_21,	AUDIO_CLKC),
	PINMUX_DATA(VI0_R1_B_MARK,	FN_IP4_24_21,	FN_VI0_R1_B,	FN_SEL_VI0_B), /* see sel_vi0 */
	PINMUX_DATA(VI0_R1_D_MARK,	FN_IP4_24_21,	FN_VI0_R1_B,	FN_SEL_VI0_D), /* see sel_vi0 */
	PINMUX_IPSR_GPSR(IP4_24_21,	DU0_DB1),
	PINMUX_IPSR_GPSR(IP4_24_21,	LCDOUT17),
	PINMUX_IPSR_GPSR(IP4_24_21,	AUDATA7),
	PINMUX_IPSR_GPSR(IP4_24_21,	ARM_TRACEDATA_7),
	PINMUX_IPSR_MSEL(IP4_24_21,	GPSIN_A,	SEL_GPS_A),
	PINMUX_IPSR_GPSR(IP4_24_21,	ADICS_SAMP),
	PINMUX_IPSR_MSEL(IP4_24_21,	TS_SCK0_B,	SEL_TSIF0_B),

	PINMUX_DATA(VI0_R2_B_MARK,	FN_IP4_26_25,	FN_VI0_R2_B,	FN_SEL_VI0_B), /* see sel_vi0 */
	PINMUX_DATA(VI0_R2_D_MARK,	FN_IP4_26_25,	FN_VI0_R2_B,	FN_SEL_VI0_D), /* see sel_vi0 */
	PINMUX_IPSR_GPSR(IP4_26_25,	DU0_DB2),
	PINMUX_IPSR_GPSR(IP4_26_25,	LCDOUT18),

	PINMUX_IPSR_MSEL(IP4_28_27,	VI0_R3_B,	SEL_VI0_B),
	PINMUX_IPSR_GPSR(IP4_28_27,	DU0_DB3),
	PINMUX_IPSR_GPSR(IP4_28_27,	LCDOUT19),

	PINMUX_DATA(VI0_R4_B_MARK,	FN_IP4_30_29,	FN_VI0_R4_B,	FN_SEL_VI0_B), /* see sel_vi0 */
	PINMUX_DATA(VI0_R4_D_MARK,	FN_IP4_30_29,	FN_VI0_R4_B,	FN_SEL_VI0_D), /* see sel_vi0 */
	PINMUX_IPSR_GPSR(IP4_30_29,	DU0_DB4),
	PINMUX_IPSR_GPSR(IP4_30_29,	LCDOUT20),

	/* IPSR5 */
	PINMUX_DATA(VI0_R5_B_MARK,	FN_IP5_1_0,	FN_VI0_R5_B,	FN_SEL_VI0_B), /* see sel_vi0 */
	PINMUX_DATA(VI0_R5_D_MARK,	FN_IP5_1_0,	FN_VI0_R5_B,	FN_SEL_VI0_D), /* see sel_vi0 */
	PINMUX_IPSR_GPSR(IP5_1_0,	DU0_DB5),
	PINMUX_IPSR_GPSR(IP5_1_0,	LCDOUT21),

	PINMUX_IPSR_MSEL(IP5_3_2,	VI1_DATA10_B,	SEL_VI1_B),
	PINMUX_IPSR_GPSR(IP5_3_2,	DU0_DB6),
	PINMUX_IPSR_GPSR(IP5_3_2,	LCDOUT22),

	PINMUX_IPSR_MSEL(IP5_5_4,	VI1_DATA11_B,	SEL_VI1_B),
	PINMUX_IPSR_GPSR(IP5_5_4,	DU0_DB7),
	PINMUX_IPSR_GPSR(IP5_5_4,	LCDOUT23),

	PINMUX_IPSR_GPSR(IP5_6,		DU0_DOTCLKIN),
	PINMUX_IPSR_GPSR(IP5_6,		QSTVA_QVS),

	PINMUX_IPSR_GPSR(IP5_7,		DU0_DOTCLKO_UT0),
	PINMUX_IPSR_GPSR(IP5_7,		QCLK),

	PINMUX_IPSR_GPSR(IP5_9_8,	DU0_DOTCLKO_UT1),
	PINMUX_IPSR_GPSR(IP5_9_8,	QSTVB_QVE),
	PINMUX_IPSR_GPSR(IP5_9_8,	AUDIO_CLKOUT_A),
	PINMUX_IPSR_MSEL(IP5_9_8,	REMOCON_C,	SEL_REMOCON_C),

	PINMUX_IPSR_MSEL(IP5_11_10,	SSI_WS2_B,	SEL_SSI2_B),
	PINMUX_IPSR_GPSR(IP5_11_10,	DU0_EXHSYNC_DU0_HSYNC),
	PINMUX_IPSR_GPSR(IP5_11_10,	QSTH_QHS),

	PINMUX_IPSR_GPSR(IP5_12,	DU0_EXVSYNC_DU0_VSYNC),
	PINMUX_IPSR_GPSR(IP5_12,	QSTB_QHE),

	PINMUX_IPSR_GPSR(IP5_14_13,	DU0_EXODDF_DU0_ODDF_DISP_CDE),
	PINMUX_IPSR_GPSR(IP5_14_13,	QCPV_QDE),
	PINMUX_IPSR_MSEL(IP5_14_13,	FMCLK_D,	SEL_FM_D),

	PINMUX_IPSR_MSEL(IP5_17_15,	SSI_SCK1_A,	SEL_SSI1_A),
	PINMUX_IPSR_GPSR(IP5_17_15,	DU0_DISP),
	PINMUX_IPSR_GPSR(IP5_17_15,	QPOLA),
	PINMUX_IPSR_GPSR(IP5_17_15,	AUDCK),
	PINMUX_IPSR_GPSR(IP5_17_15,	ARM_TRACECLK),
	PINMUX_IPSR_GPSR(IP5_17_15,	BPFCLK_D),

	PINMUX_IPSR_MSEL(IP5_20_18,	SSI_WS1_A,	SEL_SSI1_A),
	PINMUX_IPSR_GPSR(IP5_20_18,	DU0_CDE),
	PINMUX_IPSR_GPSR(IP5_20_18,	QPOLB),
	PINMUX_IPSR_GPSR(IP5_20_18,	AUDSYNC),
	PINMUX_IPSR_GPSR(IP5_20_18,	ARM_TRACECTL),
	PINMUX_IPSR_MSEL(IP5_20_18,	FMIN_D,		SEL_FM_D),

	PINMUX_IPSR_MSEL(IP5_22_21,	SD1_CD_B,	SEL_SD1_B),
	PINMUX_IPSR_GPSR(IP5_22_21,	SSI_SCK78),
	PINMUX_IPSR_MSEL(IP5_22_21,	HSPI_RX0_B,	SEL_HSPI0_B),
	PINMUX_IPSR_GPSR(IP5_22_21,	TX1_B),

	PINMUX_IPSR_MSEL(IP5_25_23,	SD1_WP_B,	SEL_SD1_B),
	PINMUX_IPSR_GPSR(IP5_25_23,	SSI_WS78),
	PINMUX_IPSR_MSEL(IP5_25_23,	HSPI_CLK0_B,	SEL_HSPI0_B),
	PINMUX_IPSR_MSEL(IP5_25_23,	RX1_B,		SEL_SCIF1_B),
	PINMUX_IPSR_MSEL(IP5_25_23,	CAN_CLK_D,	SEL_CANCLK_D),

	PINMUX_IPSR_GPSR(IP5_28_26,	SSI_SDATA8),
	PINMUX_IPSR_MSEL(IP5_28_26,	SSI_SCK2_A,	SEL_SSI2_A),
	PINMUX_IPSR_MSEL(IP5_28_26,	HSPI_CS0_B,	SEL_HSPI0_B),
	PINMUX_IPSR_GPSR(IP5_28_26,	TX2_A),
	PINMUX_IPSR_GPSR(IP5_28_26,	CAN0_TX_B),

	PINMUX_IPSR_GPSR(IP5_30_29,	SSI_SDATA7),
	PINMUX_IPSR_GPSR(IP5_30_29,	HSPI_TX0_B),
	PINMUX_IPSR_MSEL(IP5_30_29,	RX2_A,		SEL_SCIF2_A),
	PINMUX_IPSR_MSEL(IP5_30_29,	CAN0_RX_B,	SEL_CAN0_B),

	/* IPSR6 */
	PINMUX_IPSR_GPSR(IP6_1_0,	SSI_SCK6),
	PINMUX_IPSR_MSEL(IP6_1_0,	HSPI_RX2_A,	SEL_HSPI2_A),
	PINMUX_IPSR_MSEL(IP6_1_0,	FMCLK_B,	SEL_FM_B),
	PINMUX_IPSR_GPSR(IP6_1_0,	CAN1_TX_B),

	PINMUX_IPSR_GPSR(IP6_4_2,	SSI_WS6),
	PINMUX_IPSR_MSEL(IP6_4_2,	HSPI_CLK2_A,	SEL_HSPI2_A),
	PINMUX_IPSR_GPSR(IP6_4_2,	BPFCLK_B),
	PINMUX_IPSR_MSEL(IP6_4_2,	CAN1_RX_B,	SEL_CAN1_B),

	PINMUX_IPSR_GPSR(IP6_6_5,	SSI_SDATA6),
	PINMUX_IPSR_GPSR(IP6_6_5,	HSPI_TX2_A),
	PINMUX_IPSR_MSEL(IP6_6_5,	FMIN_B,		SEL_FM_B),

	PINMUX_IPSR_GPSR(IP6_7,		SSI_SCK5),
	PINMUX_IPSR_MSEL(IP6_7,		RX4_C,		SEL_SCIF4_C),

	PINMUX_IPSR_GPSR(IP6_8,		SSI_WS5),
	PINMUX_IPSR_GPSR(IP6_8,		TX4_C),

	PINMUX_IPSR_GPSR(IP6_9,		SSI_SDATA5),
	PINMUX_IPSR_MSEL(IP6_9,		RX0_D,		SEL_SCIF0_D),

	PINMUX_IPSR_GPSR(IP6_10,	SSI_WS34),
	PINMUX_IPSR_GPSR(IP6_10,	ARM_TRACEDATA_8),

	PINMUX_IPSR_GPSR(IP6_12_11,	SSI_SDATA4),
	PINMUX_IPSR_MSEL(IP6_12_11,	SSI_WS2_A,	SEL_SSI2_A),
	PINMUX_IPSR_GPSR(IP6_12_11,	ARM_TRACEDATA_9),

	PINMUX_IPSR_GPSR(IP6_13,	SSI_SDATA3),
	PINMUX_IPSR_GPSR(IP6_13,	ARM_TRACEDATA_10),

	PINMUX_IPSR_GPSR(IP6_15_14,	SSI_SCK012),
	PINMUX_IPSR_GPSR(IP6_15_14,	ARM_TRACEDATA_11),
	PINMUX_IPSR_GPSR(IP6_15_14,	TX0_D),

	PINMUX_IPSR_GPSR(IP6_16,	SSI_WS012),
	PINMUX_IPSR_GPSR(IP6_16,	ARM_TRACEDATA_12),

	PINMUX_IPSR_GPSR(IP6_18_17,	SSI_SDATA2),
	PINMUX_IPSR_MSEL(IP6_18_17,	HSPI_CS2_A,	SEL_HSPI2_A),
	PINMUX_IPSR_GPSR(IP6_18_17,	ARM_TRACEDATA_13),
	PINMUX_IPSR_MSEL(IP6_18_17,	SDA1_A,		SEL_I2C1_A),

	PINMUX_IPSR_GPSR(IP6_20_19,	SSI_SDATA1),
	PINMUX_IPSR_GPSR(IP6_20_19,	ARM_TRACEDATA_14),
	PINMUX_IPSR_MSEL(IP6_20_19,	SCL1_A,		SEL_I2C1_A),
	PINMUX_IPSR_MSEL(IP6_20_19,	SCK2_A,		SEL_SCIF2_A),

	PINMUX_IPSR_GPSR(IP6_21,	SSI_SDATA0),
	PINMUX_IPSR_GPSR(IP6_21,	ARM_TRACEDATA_15),

	PINMUX_IPSR_GPSR(IP6_23_22,	SD0_CLK),
	PINMUX_IPSR_GPSR(IP6_23_22,	SUB_TDO),

	PINMUX_IPSR_GPSR(IP6_25_24,	SD0_CMD),
	PINMUX_IPSR_GPSR(IP6_25_24,	SUB_TRST),

	PINMUX_IPSR_GPSR(IP6_27_26,	SD0_DAT0),
	PINMUX_IPSR_GPSR(IP6_27_26,	SUB_TMS),

	PINMUX_IPSR_GPSR(IP6_29_28,	SD0_DAT1),
	PINMUX_IPSR_GPSR(IP6_29_28,	SUB_TCK),

	PINMUX_IPSR_GPSR(IP6_31_30,	SD0_DAT2),
	PINMUX_IPSR_GPSR(IP6_31_30,	SUB_TDI),

	/* IPSR7 */
	PINMUX_IPSR_GPSR(IP7_1_0,	SD0_DAT3),
	PINMUX_IPSR_MSEL(IP7_1_0,	IRQ1_B,		SEL_IRQ1_B),

	PINMUX_IPSR_GPSR(IP7_3_2,	SD0_CD),
	PINMUX_IPSR_GPSR(IP7_3_2,	TX5_A),

	PINMUX_IPSR_GPSR(IP7_5_4,	SD0_WP),
	PINMUX_IPSR_MSEL(IP7_5_4,	RX5_A,		SEL_SCIF5_A),

	PINMUX_IPSR_GPSR(IP7_8_6,	VI1_CLKENB),
	PINMUX_IPSR_MSEL(IP7_8_6,	HSPI_CLK0_A,	SEL_HSPI0_A),
	PINMUX_IPSR_GPSR(IP7_8_6,	HTX1_A),
	PINMUX_IPSR_MSEL(IP7_8_6,	RTS1_C,		SEL_SCIF1_C),

	PINMUX_IPSR_GPSR(IP7_11_9,	VI1_FIELD),
	PINMUX_IPSR_MSEL(IP7_11_9,	HSPI_CS0_A,	SEL_HSPI0_A),
	PINMUX_IPSR_MSEL(IP7_11_9,	HRX1_A,		SEL_HSCIF1_A),
	PINMUX_IPSR_MSEL(IP7_11_9,	SCK1_C,		SEL_SCIF1_C),

	PINMUX_IPSR_GPSR(IP7_14_12,	VI1_HSYNC),
	PINMUX_IPSR_MSEL(IP7_14_12,	HSPI_RX0_A,	SEL_HSPI0_A),
	PINMUX_IPSR_MSEL(IP7_14_12,	HRTS1_A,	SEL_HSCIF1_A),
	PINMUX_IPSR_MSEL(IP7_14_12,	FMCLK_A,	SEL_FM_A),
	PINMUX_IPSR_MSEL(IP7_14_12,	RX1_C,		SEL_SCIF1_C),

	PINMUX_IPSR_GPSR(IP7_17_15,	VI1_VSYNC),
	PINMUX_IPSR_GPSR(IP7_17_15,	HSPI_TX0),
	PINMUX_IPSR_MSEL(IP7_17_15,	HCTS1_A,	SEL_HSCIF1_A),
	PINMUX_IPSR_GPSR(IP7_17_15,	BPFCLK_A),
	PINMUX_IPSR_GPSR(IP7_17_15,	TX1_C),

	PINMUX_IPSR_GPSR(IP7_20_18,	TCLK0),
	PINMUX_IPSR_MSEL(IP7_20_18,	HSCK1_A,	SEL_HSCIF1_A),
	PINMUX_IPSR_MSEL(IP7_20_18,	FMIN_A,		SEL_FM_A),
	PINMUX_IPSR_MSEL(IP7_20_18,	IRQ2_C,		SEL_IRQ2_C),
	PINMUX_IPSR_MSEL(IP7_20_18,	CTS1_C,		SEL_SCIF1_C),
	PINMUX_IPSR_GPSR(IP7_20_18,	SPEEDIN),

	PINMUX_IPSR_GPSR(IP7_21,	VI0_CLK),
	PINMUX_IPSR_MSEL(IP7_21,	CAN_CLK_A,	SEL_CANCLK_A),

	PINMUX_IPSR_GPSR(IP7_24_22,	VI0_CLKENB),
	PINMUX_IPSR_MSEL(IP7_24_22,	SD2_DAT2_B,	SEL_SD2_B),
	PINMUX_IPSR_GPSR(IP7_24_22,	VI1_DATA0),
	PINMUX_IPSR_GPSR(IP7_24_22,	DU1_DG6),
	PINMUX_IPSR_MSEL(IP7_24_22,	HSPI_RX1_A,	SEL_HSPI1_A),
	PINMUX_IPSR_MSEL(IP7_24_22,	RX4_B,		SEL_SCIF4_B),

	PINMUX_IPSR_GPSR(IP7_28_25,	VI0_FIELD),
	PINMUX_IPSR_MSEL(IP7_28_25,	SD2_DAT3_B,	SEL_SD2_B),
	PINMUX_DATA(VI0_R3_C_MARK,	FN_IP7_28_25,	FN_VI0_R3_C,	FN_SEL_VI0_C), /* see sel_vi0 */
	PINMUX_DATA(VI0_R3_D_MARK,	FN_IP7_28_25,	FN_VI0_R3_C,	FN_SEL_VI0_D), /* see sel_vi0 */
	PINMUX_IPSR_GPSR(IP7_28_25,	VI1_DATA1),
	PINMUX_IPSR_GPSR(IP7_28_25,	DU1_DG7),
	PINMUX_IPSR_MSEL(IP7_28_25,	HSPI_CLK1_A,	SEL_HSPI1_A),
	PINMUX_IPSR_GPSR(IP7_28_25,	TX4_B),

	PINMUX_IPSR_GPSR(IP7_31_29,	VI0_HSYNC),
	PINMUX_IPSR_MSEL(IP7_31_29,	SD2_CD_B,	SEL_SD2_B),
	PINMUX_IPSR_GPSR(IP7_31_29,	VI1_DATA2),
	PINMUX_IPSR_GPSR(IP7_31_29,	DU1_DR2),
	PINMUX_IPSR_MSEL(IP7_31_29,	HSPI_CS1_A,	SEL_HSPI1_A),
	PINMUX_IPSR_MSEL(IP7_31_29,	RX3_B,		SEL_SCIF3_B),

	/* IPSR8 */
	PINMUX_IPSR_GPSR(IP8_2_0,	VI0_VSYNC),
	PINMUX_IPSR_MSEL(IP8_2_0,	SD2_WP_B,	SEL_SD2_B),
	PINMUX_IPSR_GPSR(IP8_2_0,	VI1_DATA3),
	PINMUX_IPSR_GPSR(IP8_2_0,	DU1_DR3),
	PINMUX_IPSR_GPSR(IP8_2_0,	HSPI_TX1_A),
	PINMUX_IPSR_GPSR(IP8_2_0,	TX3_B),

	PINMUX_IPSR_GPSR(IP8_5_3,	VI0_DATA0_VI0_B0),
	PINMUX_IPSR_GPSR(IP8_5_3,	DU1_DG2),
	PINMUX_IPSR_MSEL(IP8_5_3,	IRQ2_B,		SEL_IRQ2_B),
	PINMUX_IPSR_MSEL(IP8_5_3,	RX3_D,		SEL_SCIF3_D),

	PINMUX_IPSR_GPSR(IP8_8_6,	VI0_DATA1_VI0_B1),
	PINMUX_IPSR_GPSR(IP8_8_6,	DU1_DG3),
	PINMUX_IPSR_MSEL(IP8_8_6,	IRQ3_B,		SEL_IRQ3_B),
	PINMUX_IPSR_GPSR(IP8_8_6,	TX3_D),

	PINMUX_IPSR_GPSR(IP8_10_9,	VI0_DATA2_VI0_B2),
	PINMUX_IPSR_GPSR(IP8_10_9,	DU1_DG4),
	PINMUX_IPSR_MSEL(IP8_10_9,	RX0_C,		SEL_SCIF0_C),

	PINMUX_IPSR_GPSR(IP8_13_11,	VI0_DATA3_VI0_B3),
	PINMUX_IPSR_GPSR(IP8_13_11,	DU1_DG5),
	PINMUX_IPSR_GPSR(IP8_13_11,	TX1_A),
	PINMUX_IPSR_GPSR(IP8_13_11,	TX0_C),

	PINMUX_IPSR_GPSR(IP8_15_14,	VI0_DATA4_VI0_B4),
	PINMUX_IPSR_GPSR(IP8_15_14,	DU1_DB2),
	PINMUX_IPSR_MSEL(IP8_15_14,	RX1_A,		SEL_SCIF1_A),

	PINMUX_IPSR_GPSR(IP8_18_16,	VI0_DATA5_VI0_B5),
	PINMUX_IPSR_GPSR(IP8_18_16,	DU1_DB3),
	PINMUX_IPSR_MSEL(IP8_18_16,	SCK1_A,		SEL_SCIF1_A),
	PINMUX_IPSR_GPSR(IP8_18_16,	PWM4),
	PINMUX_IPSR_MSEL(IP8_18_16,	HSCK1_B,	SEL_HSCIF1_B),

	PINMUX_IPSR_GPSR(IP8_21_19,	VI0_DATA6_VI0_G0),
	PINMUX_IPSR_GPSR(IP8_21_19,	DU1_DB4),
	PINMUX_IPSR_MSEL(IP8_21_19,	CTS1_A,		SEL_SCIF1_A),
	PINMUX_IPSR_GPSR(IP8_21_19,	PWM5),

	PINMUX_IPSR_GPSR(IP8_23_22,	VI0_DATA7_VI0_G1),
	PINMUX_IPSR_GPSR(IP8_23_22,	DU1_DB5),
	PINMUX_IPSR_MSEL(IP8_23_22,	RTS1_A,		SEL_SCIF1_A),

	PINMUX_IPSR_GPSR(IP8_26_24,	VI0_G2),
	PINMUX_IPSR_GPSR(IP8_26_24,	SD2_CLK_B),
	PINMUX_IPSR_GPSR(IP8_26_24,	VI1_DATA4),
	PINMUX_IPSR_GPSR(IP8_26_24,	DU1_DR4),
	PINMUX_IPSR_GPSR(IP8_26_24,	HTX1_B),

	PINMUX_IPSR_GPSR(IP8_29_27,	VI0_G3),
	PINMUX_IPSR_MSEL(IP8_29_27,	SD2_CMD_B,	SEL_SD2_B),
	PINMUX_IPSR_GPSR(IP8_29_27,	VI1_DATA5),
	PINMUX_IPSR_GPSR(IP8_29_27,	DU1_DR5),
	PINMUX_IPSR_MSEL(IP8_29_27,	HRX1_B,		SEL_HSCIF1_B),

	/* IPSR9 */
	PINMUX_IPSR_GPSR(IP9_2_0,	VI0_G4),
	PINMUX_IPSR_MSEL(IP9_2_0,	SD2_DAT0_B,	SEL_SD2_B),
	PINMUX_IPSR_GPSR(IP9_2_0,	VI1_DATA6),
	PINMUX_IPSR_GPSR(IP9_2_0,	DU1_DR6),
	PINMUX_IPSR_MSEL(IP9_2_0,	HRTS1_B,	SEL_HSCIF1_B),

	PINMUX_IPSR_GPSR(IP9_5_3,	VI0_G5),
	PINMUX_IPSR_MSEL(IP9_5_3,	SD2_DAT1_B,	SEL_SD2_B),
	PINMUX_IPSR_GPSR(IP9_5_3,	VI1_DATA7),
	PINMUX_IPSR_GPSR(IP9_5_3,	DU1_DR7),
	PINMUX_IPSR_MSEL(IP9_5_3,	HCTS1_B,	SEL_HSCIF1_B),

	PINMUX_DATA(VI0_R0_A_MARK,	FN_IP9_8_6,	FN_VI0_R0_A,	FN_SEL_VI0_A), /* see sel_vi0 */
	PINMUX_DATA(VI0_R0_C_MARK,	FN_IP9_8_6,	FN_VI0_R0_A,	FN_SEL_VI0_C), /* see sel_vi0 */
	PINMUX_IPSR_GPSR(IP9_8_6,	VI1_CLK),
	PINMUX_IPSR_GPSR(IP9_8_6,	ETH_REF_CLK),
	PINMUX_IPSR_GPSR(IP9_8_6,	DU1_DOTCLKIN),

	PINMUX_DATA(VI0_R1_A_MARK,	FN_IP9_11_9,	FN_VI0_R1_A,	FN_SEL_VI0_A), /* see sel_vi0 */
	PINMUX_DATA(VI0_R1_C_MARK,	FN_IP9_11_9,	FN_VI0_R1_A,	FN_SEL_VI0_C), /* see sel_vi0 */
	PINMUX_IPSR_GPSR(IP9_11_9,	VI1_DATA8),
	PINMUX_IPSR_GPSR(IP9_11_9,	DU1_DB6),
	PINMUX_IPSR_GPSR(IP9_11_9,	ETH_TXD0),
	PINMUX_IPSR_GPSR(IP9_11_9,	PWM2),
	PINMUX_IPSR_GPSR(IP9_11_9,	TCLK1),

	PINMUX_DATA(VI0_R2_A_MARK,	FN_IP9_14_12,	FN_VI0_R2_A,	FN_SEL_VI0_A), /* see sel_vi0 */
	PINMUX_DATA(VI0_R2_C_MARK,	FN_IP9_14_12,	FN_VI0_R2_A,	FN_SEL_VI0_C), /* see sel_vi0 */
	PINMUX_IPSR_GPSR(IP9_14_12,	VI1_DATA9),
	PINMUX_IPSR_GPSR(IP9_14_12,	DU1_DB7),
	PINMUX_IPSR_GPSR(IP9_14_12,	ETH_TXD1),
	PINMUX_IPSR_GPSR(IP9_14_12,	PWM3),

	PINMUX_IPSR_MSEL(IP9_17_15,	VI0_R3_A,	SEL_VI0_A),
	PINMUX_IPSR_GPSR(IP9_17_15,	ETH_CRS_DV),
	PINMUX_IPSR_GPSR(IP9_17_15,	IECLK),
	PINMUX_IPSR_MSEL(IP9_17_15,	SCK2_C,		SEL_SCIF2_C),

	PINMUX_DATA(VI0_R4_A_MARK,	FN_IP9_20_18,	FN_VI0_R4_A,	FN_SEL_VI0_A), /* see sel_vi0 */
	PINMUX_DATA(VI0_R3_C_MARK,	FN_IP9_20_18,	FN_VI0_R4_A,	FN_SEL_VI0_C), /* see sel_vi0 */
	PINMUX_IPSR_GPSR(IP9_20_18,	ETH_TX_EN),
	PINMUX_IPSR_GPSR(IP9_20_18,	IETX),
	PINMUX_IPSR_GPSR(IP9_20_18,	TX2_C),

	PINMUX_DATA(VI0_R5_A_MARK,	FN_IP9_23_21,	FN_VI0_R5_A,	FN_SEL_VI0_A), /* see sel_vi0 */
	PINMUX_DATA(VI0_R5_C_MARK,	FN_IP9_23_21,	FN_VI0_R5_A,	FN_SEL_VI0_C), /* see sel_vi0 */
	PINMUX_IPSR_GPSR(IP9_23_21,	ETH_RX_ER),
	PINMUX_IPSR_MSEL(IP9_23_21,	FMCLK_C,	SEL_FM_C),
	PINMUX_IPSR_GPSR(IP9_23_21,	IERX),
	PINMUX_IPSR_MSEL(IP9_23_21,	RX2_C,		SEL_SCIF2_C),

	PINMUX_IPSR_MSEL(IP9_26_24,	VI1_DATA10_A,	SEL_VI1_A),
	PINMUX_IPSR_GPSR(IP9_26_24,	DU1_DOTCLKOUT),
	PINMUX_IPSR_GPSR(IP9_26_24,	ETH_RXD0),
	PINMUX_IPSR_GPSR(IP9_26_24,	BPFCLK_C),
	PINMUX_IPSR_GPSR(IP9_26_24,	TX2_D),
	PINMUX_IPSR_MSEL(IP9_26_24,	SDA2_C,		SEL_I2C2_C),

	PINMUX_IPSR_MSEL(IP9_29_27,	VI1_DATA11_A,	SEL_VI1_A),
	PINMUX_IPSR_GPSR(IP9_29_27,	DU1_EXHSYNC_DU1_HSYNC),
	PINMUX_IPSR_GPSR(IP9_29_27,	ETH_RXD1),
	PINMUX_IPSR_MSEL(IP9_29_27,	FMIN_C,		SEL_FM_C),
	PINMUX_IPSR_MSEL(IP9_29_27,	RX2_D,		SEL_SCIF2_D),
	PINMUX_IPSR_MSEL(IP9_29_27,	SCL2_C,		SEL_I2C2_C),

	/* IPSR10 */
	PINMUX_IPSR_GPSR(IP10_2_0,	SD2_CLK_A),
	PINMUX_IPSR_GPSR(IP10_2_0,	DU1_EXVSYNC_DU1_VSYNC),
	PINMUX_IPSR_GPSR(IP10_2_0,	ATARD1),
	PINMUX_IPSR_GPSR(IP10_2_0,	ETH_MDC),
	PINMUX_IPSR_MSEL(IP10_2_0,	SDA1_B,		SEL_I2C1_B),

	PINMUX_IPSR_MSEL(IP10_5_3,	SD2_CMD_A,	SEL_SD2_A),
	PINMUX_IPSR_GPSR(IP10_5_3,	DU1_EXODDF_DU1_ODDF_DISP_CDE),
	PINMUX_IPSR_GPSR(IP10_5_3,	ATAWR1),
	PINMUX_IPSR_GPSR(IP10_5_3,	ETH_MDIO),
	PINMUX_IPSR_MSEL(IP10_5_3,	SCL1_B,		SEL_I2C1_B),

	PINMUX_IPSR_MSEL(IP10_8_6,	SD2_DAT0_A,	SEL_SD2_A),
	PINMUX_IPSR_GPSR(IP10_8_6,	DU1_DISP),
	PINMUX_IPSR_GPSR(IP10_8_6,	ATACS01),
	PINMUX_IPSR_MSEL(IP10_8_6,	DREQ1_B,	SEL_DREQ1_B),
	PINMUX_IPSR_GPSR(IP10_8_6,	ETH_LINK),
	PINMUX_IPSR_MSEL(IP10_8_6,	CAN1_RX_A,	SEL_CAN1_A),

	PINMUX_IPSR_MSEL(IP10_12_9,	SD2_DAT1_A,	SEL_SD2_A),
	PINMUX_IPSR_GPSR(IP10_12_9,	DU1_CDE),
	PINMUX_IPSR_GPSR(IP10_12_9,	ATACS11),
	PINMUX_IPSR_GPSR(IP10_12_9,	DACK1_B),
	PINMUX_IPSR_GPSR(IP10_12_9,	ETH_MAGIC),
	PINMUX_IPSR_GPSR(IP10_12_9,	CAN1_TX_A),
	PINMUX_IPSR_GPSR(IP10_12_9,	PWM6),

	PINMUX_IPSR_MSEL(IP10_15_13,	SD2_DAT2_A,	SEL_SD2_A),
	PINMUX_IPSR_GPSR(IP10_15_13,	VI1_DATA12),
	PINMUX_IPSR_MSEL(IP10_15_13,	DREQ2_B,	SEL_DREQ2_B),
	PINMUX_IPSR_GPSR(IP10_15_13,	ATADIR1),
	PINMUX_IPSR_MSEL(IP10_15_13,	HSPI_CLK2_B,	SEL_HSPI2_B),
	PINMUX_IPSR_MSEL(IP10_15_13,	GPSCLK_B,	SEL_GPS_B),

	PINMUX_IPSR_MSEL(IP10_18_16,	SD2_DAT3_A,	SEL_SD2_A),
	PINMUX_IPSR_GPSR(IP10_18_16,	VI1_DATA13),
	PINMUX_IPSR_GPSR(IP10_18_16,	DACK2_B),
	PINMUX_IPSR_GPSR(IP10_18_16,	ATAG1),
	PINMUX_IPSR_MSEL(IP10_18_16,	HSPI_CS2_B,	SEL_HSPI2_B),
	PINMUX_IPSR_MSEL(IP10_18_16,	GPSIN_B,	SEL_GPS_B),

	PINMUX_IPSR_MSEL(IP10_21_19,	SD2_CD_A,	SEL_SD2_A),
	PINMUX_IPSR_GPSR(IP10_21_19,	VI1_DATA14),
	PINMUX_IPSR_MSEL(IP10_21_19,	EX_WAIT1_B,	SEL_WAIT1_B),
	PINMUX_IPSR_MSEL(IP10_21_19,	DREQ0_B,	SEL_DREQ0_B),
	PINMUX_IPSR_MSEL(IP10_21_19,	HSPI_RX2_B,	SEL_HSPI2_B),
	PINMUX_IPSR_MSEL(IP10_21_19,	REMOCON_A,	SEL_REMOCON_A),

	PINMUX_IPSR_MSEL(IP10_24_22,	SD2_WP_A,	SEL_SD2_A),
	PINMUX_IPSR_GPSR(IP10_24_22,	VI1_DATA15),
	PINMUX_IPSR_MSEL(IP10_24_22,	EX_WAIT2_B,	SEL_WAIT2_B),
	PINMUX_IPSR_GPSR(IP10_24_22,	DACK0_B),
	PINMUX_IPSR_GPSR(IP10_24_22,	HSPI_TX2_B),
	PINMUX_IPSR_MSEL(IP10_24_22,	CAN_CLK_C,	SEL_CANCLK_C),
};

/*
 * Pins not associated with a GPIO port.
 */
enum {
	GP_ASSIGN_LAST(),
	NOGP_ALL(),
};

static const struct sh_pfc_pin pinmux_pins[] = {
	PINMUX_GPIO_GP_ALL(),
	PINMUX_NOGP_ALL(),
};

/* - macro */
#define SH_PFC_PINS(name, args...) \
	static const unsigned int name ##_pins[] = { args }
#define SH_PFC_MUX1(name, arg1)					\
	static const unsigned int name ##_mux[]  = { arg1##_MARK }
#define SH_PFC_MUX2(name, arg1, arg2)					\
	static const unsigned int name ##_mux[]  = { arg1##_MARK, arg2##_MARK, }
#define SH_PFC_MUX3(name, arg1, arg2, arg3)					\
	static const unsigned int name ##_mux[]  = { arg1##_MARK, arg2##_MARK,	\
						     arg3##_MARK }
#define SH_PFC_MUX4(name, arg1, arg2, arg3, arg4)			\
	static const unsigned int name ##_mux[]  = { arg1##_MARK, arg2##_MARK, \
						     arg3##_MARK, arg4##_MARK }
#define SH_PFC_MUX8(name, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8) \
	static const unsigned int name ##_mux[]  = { arg1##_MARK, arg2##_MARK, \
						     arg3##_MARK, arg4##_MARK, \
						     arg5##_MARK, arg6##_MARK, \
						     arg7##_MARK, arg8##_MARK, }

/* - AUDIO macro -------------------------------------------------------------*/
#define AUDIO_PFC_PIN(name, pin)	SH_PFC_PINS(name, pin)
#define AUDIO_PFC_DAT(name, pin)	SH_PFC_MUX1(name, pin)

/* - AUDIO clock -------------------------------------------------------------*/
AUDIO_PFC_PIN(audio_clk_a,	RCAR_GP_PIN(2, 22));
AUDIO_PFC_DAT(audio_clk_a,	AUDIO_CLKA);
AUDIO_PFC_PIN(audio_clk_b,	RCAR_GP_PIN(2, 23));
AUDIO_PFC_DAT(audio_clk_b,	AUDIO_CLKB);
AUDIO_PFC_PIN(audio_clk_c,	RCAR_GP_PIN(2, 7));
AUDIO_PFC_DAT(audio_clk_c,	AUDIO_CLKC);
AUDIO_PFC_PIN(audio_clkout_a,	RCAR_GP_PIN(2, 16));
AUDIO_PFC_DAT(audio_clkout_a,	AUDIO_CLKOUT_A);
AUDIO_PFC_PIN(audio_clkout_b,	RCAR_GP_PIN(1, 16));
AUDIO_PFC_DAT(audio_clkout_b,	AUDIO_CLKOUT_B);

/* - CAN macro --------_----------------------------------------------------- */
#define CAN_PFC_PINS(name, args...)		SH_PFC_PINS(name, args)
#define CAN_PFC_DATA(name, tx, rx)		SH_PFC_MUX2(name, tx, rx)
#define CAN_PFC_CLK(name, clk)			SH_PFC_MUX1(name, clk)

/* - CAN0 ------------------------------------------------------------------- */
CAN_PFC_PINS(can0_data_a,	RCAR_GP_PIN(1, 30),	RCAR_GP_PIN(1, 31));
CAN_PFC_DATA(can0_data_a,	CAN0_TX_A,		CAN0_RX_A);
CAN_PFC_PINS(can0_data_b,	RCAR_GP_PIN(2, 26),	RCAR_GP_PIN(2, 27));
CAN_PFC_DATA(can0_data_b,	CAN0_TX_B,		CAN0_RX_B);

/* - CAN1 ------------------------------------------------------------------- */
CAN_PFC_PINS(can1_data_a,	RCAR_GP_PIN(4, 20),	RCAR_GP_PIN(4, 19));
CAN_PFC_DATA(can1_data_a,	CAN1_TX_A,		CAN1_RX_A);
CAN_PFC_PINS(can1_data_b,	RCAR_GP_PIN(2, 28),	RCAR_GP_PIN(2, 29));
CAN_PFC_DATA(can1_data_b,	CAN1_TX_B,		CAN1_RX_B);

/* - CAN_CLK  --------------------------------------------------------------- */
CAN_PFC_PINS(can_clk_a,		RCAR_GP_PIN(3, 24));
CAN_PFC_CLK(can_clk_a,		CAN_CLK_A);
CAN_PFC_PINS(can_clk_b,		RCAR_GP_PIN(1, 16));
CAN_PFC_CLK(can_clk_b,		CAN_CLK_B);
CAN_PFC_PINS(can_clk_c,		RCAR_GP_PIN(4, 24));
CAN_PFC_CLK(can_clk_c,		CAN_CLK_C);
CAN_PFC_PINS(can_clk_d,		RCAR_GP_PIN(2, 25));
CAN_PFC_CLK(can_clk_d,		CAN_CLK_D);

/* - Ether ------------------------------------------------------------------ */
SH_PFC_PINS(ether_rmii,		RCAR_GP_PIN(4, 10),	RCAR_GP_PIN(4, 11),
				RCAR_GP_PIN(4, 13),	RCAR_GP_PIN(4, 9),
				RCAR_GP_PIN(4, 15),	RCAR_GP_PIN(4, 16),
				RCAR_GP_PIN(4, 12),	RCAR_GP_PIN(4, 14),
				RCAR_GP_PIN(4, 18),	RCAR_GP_PIN(4, 17));
static const unsigned int ether_rmii_mux[] = {
	ETH_TXD0_MARK, ETH_TXD1_MARK, ETH_TX_EN_MARK,  ETH_REF_CLK_MARK,
	ETH_RXD0_MARK, ETH_RXD1_MARK, ETH_CRS_DV_MARK, ETH_RX_ER_MARK,
	ETH_MDIO_MARK, ETH_MDC_MARK,
};
SH_PFC_PINS(ether_link,		RCAR_GP_PIN(4, 19));
SH_PFC_MUX1(ether_link,		ETH_LINK);
SH_PFC_PINS(ether_magic,	RCAR_GP_PIN(4, 20));
SH_PFC_MUX1(ether_magic,	ETH_MAGIC);

/* - SCIF macro ------------------------------------------------------------- */
#define SCIF_PFC_PIN(name, args...)	SH_PFC_PINS(name, args)
#define SCIF_PFC_DAT(name, tx, rx)	SH_PFC_MUX2(name, tx, rx)
#define SCIF_PFC_CTR(name, cts, rts)	SH_PFC_MUX2(name, cts, rts)
#define SCIF_PFC_CLK(name, sck)		SH_PFC_MUX1(name, sck)

/* - HSCIF0 ----------------------------------------------------------------- */
SCIF_PFC_PIN(hscif0_data_a,	RCAR_GP_PIN(1, 17),	RCAR_GP_PIN(1, 18));
SCIF_PFC_DAT(hscif0_data_a,	HTX0_A,			HRX0_A);
SCIF_PFC_PIN(hscif0_data_b,	RCAR_GP_PIN(0, 29),	RCAR_GP_PIN(0, 30));
SCIF_PFC_DAT(hscif0_data_b,	HTX0_B,			HRX0_B);
SCIF_PFC_PIN(hscif0_ctrl_a,	RCAR_GP_PIN(1, 20),	RCAR_GP_PIN(1, 21));
SCIF_PFC_CTR(hscif0_ctrl_a,	HCTS0_A,		HRTS0_A);
SCIF_PFC_PIN(hscif0_ctrl_b,	RCAR_GP_PIN(0, 31),	RCAR_GP_PIN(0, 28));
SCIF_PFC_CTR(hscif0_ctrl_b,	HCTS0_B,		HRTS0_B);
SCIF_PFC_PIN(hscif0_clk,	RCAR_GP_PIN(1, 19));
SCIF_PFC_CLK(hscif0_clk,	HSCK0);

/* - HSCIF1 ----------------------------------------------------------------- */
SCIF_PFC_PIN(hscif1_data_a,	RCAR_GP_PIN(3, 19),	RCAR_GP_PIN(3, 20));
SCIF_PFC_DAT(hscif1_data_a,	HTX1_A,			HRX1_A);
SCIF_PFC_PIN(hscif1_data_b,	RCAR_GP_PIN(4, 5),	RCAR_GP_PIN(4, 6));
SCIF_PFC_DAT(hscif1_data_b,	HTX1_B,			HRX1_B);
SCIF_PFC_PIN(hscif1_ctrl_a,	RCAR_GP_PIN(3, 22),	RCAR_GP_PIN(3, 21));
SCIF_PFC_CTR(hscif1_ctrl_a,	HCTS1_A,		HRTS1_A);
SCIF_PFC_PIN(hscif1_ctrl_b,	RCAR_GP_PIN(4, 8),	RCAR_GP_PIN(4, 7));
SCIF_PFC_CTR(hscif1_ctrl_b,	HCTS1_B,		HRTS1_B);
SCIF_PFC_PIN(hscif1_clk_a,	RCAR_GP_PIN(3, 23));
SCIF_PFC_CLK(hscif1_clk_a,	HSCK1_A);
SCIF_PFC_PIN(hscif1_clk_b,	RCAR_GP_PIN(4, 2));
SCIF_PFC_CLK(hscif1_clk_b,	HSCK1_B);

/* - HSPI macro --------------------------------------------------------------*/
#define HSPI_PFC_PIN(name, args...)		SH_PFC_PINS(name, args)
#define HSPI_PFC_DAT(name, clk, cs, rx, tx)	SH_PFC_MUX4(name, clk, cs, rx, tx)

/* - HSPI0 -------------------------------------------------------------------*/
HSPI_PFC_PIN(hspi0_a,	RCAR_GP_PIN(3, 19),	RCAR_GP_PIN(3, 20),
			RCAR_GP_PIN(3, 21),	RCAR_GP_PIN(3, 22));
HSPI_PFC_DAT(hspi0_a,	HSPI_CLK0_A,		HSPI_CS0_A,
			HSPI_RX0_A,		HSPI_TX0);

HSPI_PFC_PIN(hspi0_b,	RCAR_GP_PIN(2, 25),	RCAR_GP_PIN(2, 26),
			RCAR_GP_PIN(2, 24),	RCAR_GP_PIN(2, 27));
HSPI_PFC_DAT(hspi0_b,	HSPI_CLK0_B,		HSPI_CS0_B,
			HSPI_RX0_B,		HSPI_TX0_B);

/* - HSPI1 -------------------------------------------------------------------*/
HSPI_PFC_PIN(hspi1_a,	RCAR_GP_PIN(3, 26),	RCAR_GP_PIN(3, 27),
			RCAR_GP_PIN(3, 25),	RCAR_GP_PIN(3, 28));
HSPI_PFC_DAT(hspi1_a,	HSPI_CLK1_A,		HSPI_CS1_A,
			HSPI_RX1_A,		HSPI_TX1_A);

HSPI_PFC_PIN(hspi1_b,	RCAR_GP_PIN(0, 27),	RCAR_GP_PIN(0, 26),
			PIN_CS0,		PIN_CLKOUT);
HSPI_PFC_DAT(hspi1_b,	HSPI_CLK1_B,		HSPI_CS1_B,
			HSPI_RX1_B,		HSPI_TX1_B);

/* - HSPI2 -------------------------------------------------------------------*/
HSPI_PFC_PIN(hspi2_a,	RCAR_GP_PIN(2, 29),	RCAR_GP_PIN(3, 8),
			RCAR_GP_PIN(2, 28),	RCAR_GP_PIN(2, 30));
HSPI_PFC_DAT(hspi2_a,	HSPI_CLK2_A,		HSPI_CS2_A,
			HSPI_RX2_A,		HSPI_TX2_A);

HSPI_PFC_PIN(hspi2_b,	RCAR_GP_PIN(4, 21),	RCAR_GP_PIN(4, 22),
			RCAR_GP_PIN(4, 23),	RCAR_GP_PIN(4, 24));
HSPI_PFC_DAT(hspi2_b,	HSPI_CLK2_B,		HSPI_CS2_B,
			HSPI_RX2_B,		HSPI_TX2_B);

/* - I2C macro ------------------------------------------------------------- */
#define I2C_PFC_PIN(name, args...)	SH_PFC_PINS(name, args)
#define I2C_PFC_MUX(name, sda, scl)	SH_PFC_MUX2(name, sda, scl)

/* - I2C1 ------------------------------------------------------------------ */
I2C_PFC_PIN(i2c1_a,	RCAR_GP_PIN(3, 8),	RCAR_GP_PIN(3, 9));
I2C_PFC_MUX(i2c1_a,	SDA1_A,			SCL1_A);
I2C_PFC_PIN(i2c1_b,	RCAR_GP_PIN(4, 17),	RCAR_GP_PIN(4, 18));
I2C_PFC_MUX(i2c1_b,	SDA1_B,			SCL1_B);

/* - I2C2 ------------------------------------------------------------------ */
I2C_PFC_PIN(i2c2_a,	PIN_CS1_A26,		RCAR_GP_PIN(1, 3));
I2C_PFC_MUX(i2c2_a,	SDA2_A,			SCL2_A);
I2C_PFC_PIN(i2c2_b,	RCAR_GP_PIN(0, 3),	RCAR_GP_PIN(0, 4));
I2C_PFC_MUX(i2c2_b,	SDA2_B,			SCL2_B);
I2C_PFC_PIN(i2c2_c,	RCAR_GP_PIN(4, 15),	RCAR_GP_PIN(4, 16));
I2C_PFC_MUX(i2c2_c,	SDA2_C,			SCL2_C);

/* - I2C3 ------------------------------------------------------------------ */
I2C_PFC_PIN(i2c3_a,	RCAR_GP_PIN(1, 14),	RCAR_GP_PIN(1, 15));
I2C_PFC_MUX(i2c3_a,	SDA3_A,			SCL3_A);
I2C_PFC_PIN(i2c3_b,	RCAR_GP_PIN(1, 16),	RCAR_GP_PIN(1, 19));
I2C_PFC_MUX(i2c3_b,	SDA3_B,			SCL3_B);
I2C_PFC_PIN(i2c3_c,	RCAR_GP_PIN(1, 22),	RCAR_GP_PIN(1, 23));
I2C_PFC_MUX(i2c3_c,	SDA3_C,			SCL3_C);

/* - MMC macro -------------------------------------------------------------- */
#define MMC_PFC_PINS(name, args...)		SH_PFC_PINS(name, args)
#define MMC_PFC_CTRL(name, clk, cmd)		SH_PFC_MUX2(name, clk, cmd)
#define MMC_PFC_DAT1(name, d0)			SH_PFC_MUX1(name, d0)
#define MMC_PFC_DAT4(name, d0, d1, d2, d3)	SH_PFC_MUX4(name, d0, d1, d2, d3)
#define MMC_PFC_DAT8(name, d0, d1, d2, d3, d4, d5, d6, d7)	\
			SH_PFC_MUX8(name, d0, d1, d2, d3, d4, d5, d6, d7)

/* - MMC -------------------------------------------------------------------- */
MMC_PFC_PINS(mmc_ctrl,		RCAR_GP_PIN(1, 5),	RCAR_GP_PIN(1, 6));
MMC_PFC_CTRL(mmc_ctrl,		MMC_CLK,		MMC_CMD);
MMC_PFC_PINS(mmc_data1,		RCAR_GP_PIN(1, 7));
MMC_PFC_DAT1(mmc_data1,		MMC_D0);
MMC_PFC_PINS(mmc_data4,		RCAR_GP_PIN(1, 7),	RCAR_GP_PIN(1, 8),
				RCAR_GP_PIN(0, 5),	RCAR_GP_PIN(0, 6));
MMC_PFC_DAT4(mmc_data4,		MMC_D0,			MMC_D1,
				MMC_D2,			MMC_D3);
MMC_PFC_PINS(mmc_data8,		RCAR_GP_PIN(1, 7),	RCAR_GP_PIN(1, 8),
				RCAR_GP_PIN(0, 5),	RCAR_GP_PIN(0, 6),
				RCAR_GP_PIN(1, 4),	RCAR_GP_PIN(1, 0),
				RCAR_GP_PIN(0, 30),	RCAR_GP_PIN(0, 31));
MMC_PFC_DAT8(mmc_data8,		MMC_D0,			MMC_D1,
				MMC_D2,			MMC_D3,
				MMC_D4,			MMC_D5,
				MMC_D6,			MMC_D7);

/* - SCIF CLOCK ------------------------------------------------------------- */
SCIF_PFC_PIN(scif_clk,		RCAR_GP_PIN(1, 16));
SCIF_PFC_CLK(scif_clk,		SCIF_CLK);

/* - SCIF0 ------------------------------------------------------------------ */
SCIF_PFC_PIN(scif0_data_a,	RCAR_GP_PIN(1, 17),	RCAR_GP_PIN(1, 18));
SCIF_PFC_DAT(scif0_data_a,	TX0_A,			RX0_A);
SCIF_PFC_PIN(scif0_data_b,	RCAR_GP_PIN(2, 3),	RCAR_GP_PIN(2, 2));
SCIF_PFC_DAT(scif0_data_b,	TX0_B,			RX0_B);
SCIF_PFC_PIN(scif0_data_c,	RCAR_GP_PIN(4, 0),	RCAR_GP_PIN(3, 31));
SCIF_PFC_DAT(scif0_data_c,	TX0_C,			RX0_C);
SCIF_PFC_PIN(scif0_data_d,	RCAR_GP_PIN(3, 6),	RCAR_GP_PIN(3, 1));
SCIF_PFC_DAT(scif0_data_d,	TX0_D,			RX0_D);
SCIF_PFC_PIN(scif0_ctrl,	RCAR_GP_PIN(1, 20),	RCAR_GP_PIN(1, 21));
SCIF_PFC_CTR(scif0_ctrl,	CTS0,			RTS0);
SCIF_PFC_PIN(scif0_clk,		RCAR_GP_PIN(1, 19));
SCIF_PFC_CLK(scif0_clk,		SCK0);

/* - SCIF1 ------------------------------------------------------------------ */
SCIF_PFC_PIN(scif1_data_a,	RCAR_GP_PIN(4, 0),	RCAR_GP_PIN(4, 1));
SCIF_PFC_DAT(scif1_data_a,	TX1_A,			RX1_A);
SCIF_PFC_PIN(scif1_data_b,	RCAR_GP_PIN(2, 24),	RCAR_GP_PIN(2, 25));
SCIF_PFC_DAT(scif1_data_b,	TX1_B,			RX1_B);
SCIF_PFC_PIN(scif1_data_c,	RCAR_GP_PIN(3, 22),	RCAR_GP_PIN(3, 21));
SCIF_PFC_DAT(scif1_data_c,	TX1_C,			RX1_C);
SCIF_PFC_PIN(scif1_data_d,	RCAR_GP_PIN(1, 30),	RCAR_GP_PIN(1, 31));
SCIF_PFC_DAT(scif1_data_d,	TX1_D,			RX1_D);
SCIF_PFC_PIN(scif1_ctrl_a,	RCAR_GP_PIN(4, 3),	RCAR_GP_PIN(4, 4));
SCIF_PFC_CTR(scif1_ctrl_a,	CTS1_A,			RTS1_A);
SCIF_PFC_PIN(scif1_ctrl_c,	RCAR_GP_PIN(3, 23),	RCAR_GP_PIN(3, 19));
SCIF_PFC_CTR(scif1_ctrl_c,	CTS1_C,			RTS1_C);
SCIF_PFC_PIN(scif1_clk_a,	RCAR_GP_PIN(4, 2));
SCIF_PFC_CLK(scif1_clk_a,	SCK1_A);
SCIF_PFC_PIN(scif1_clk_c,	RCAR_GP_PIN(3, 20));
SCIF_PFC_CLK(scif1_clk_c,	SCK1_C);

/* - SCIF2 ------------------------------------------------------------------ */
SCIF_PFC_PIN(scif2_data_a,	RCAR_GP_PIN(2, 26),	RCAR_GP_PIN(2, 27));
SCIF_PFC_DAT(scif2_data_a,	TX2_A,			RX2_A);
SCIF_PFC_PIN(scif2_data_b,	RCAR_GP_PIN(0, 29),	RCAR_GP_PIN(0, 28));
SCIF_PFC_DAT(scif2_data_b,	TX2_B,			RX2_B);
SCIF_PFC_PIN(scif2_data_c,	RCAR_GP_PIN(4, 13),	RCAR_GP_PIN(4, 14));
SCIF_PFC_DAT(scif2_data_c,	TX2_C,			RX2_C);
SCIF_PFC_PIN(scif2_data_d,	RCAR_GP_PIN(4, 15),	RCAR_GP_PIN(4, 16));
SCIF_PFC_DAT(scif2_data_d,	TX2_D,			RX2_D);
SCIF_PFC_PIN(scif2_data_e,	RCAR_GP_PIN(0, 3),	RCAR_GP_PIN(0, 4));
SCIF_PFC_DAT(scif2_data_e,	TX2_E,			RX2_E);
SCIF_PFC_PIN(scif2_clk_a,	RCAR_GP_PIN(3, 9));
SCIF_PFC_CLK(scif2_clk_a,	SCK2_A);
SCIF_PFC_PIN(scif2_clk_b,	PIN_CS1_A26);
SCIF_PFC_CLK(scif2_clk_b,	SCK2_B);
SCIF_PFC_PIN(scif2_clk_c,	RCAR_GP_PIN(4, 12));
SCIF_PFC_CLK(scif2_clk_c,	SCK2_C);

/* - SCIF3 ------------------------------------------------------------------ */
SCIF_PFC_PIN(scif3_data_a,	RCAR_GP_PIN(1, 10),	RCAR_GP_PIN(1, 9));
SCIF_PFC_DAT(scif3_data_a,	TX3_A,			RX3_A);
SCIF_PFC_PIN(scif3_data_b,	RCAR_GP_PIN(3, 28),	RCAR_GP_PIN(3, 27));
SCIF_PFC_DAT(scif3_data_b,	TX3_B,			RX3_B);
SCIF_PFC_PIN(scif3_data_c,	RCAR_GP_PIN(1, 3),	RCAR_GP_PIN(0, 31));
SCIF_PFC_DAT(scif3_data_c,	TX3_C,			RX3_C);
SCIF_PFC_PIN(scif3_data_d,	RCAR_GP_PIN(3, 30),	RCAR_GP_PIN(3, 29));
SCIF_PFC_DAT(scif3_data_d,	TX3_D,			RX3_D);

/* - SCIF4 ------------------------------------------------------------------ */
SCIF_PFC_PIN(scif4_data_a,	RCAR_GP_PIN(2, 5),	RCAR_GP_PIN(2, 4));
SCIF_PFC_DAT(scif4_data_a,	TX4_A,			RX4_A);
SCIF_PFC_PIN(scif4_data_b,	RCAR_GP_PIN(3, 26),	RCAR_GP_PIN(3, 25));
SCIF_PFC_DAT(scif4_data_b,	TX4_B,			RX4_B);
SCIF_PFC_PIN(scif4_data_c,	RCAR_GP_PIN(3, 0),	RCAR_GP_PIN(2, 31));
SCIF_PFC_DAT(scif4_data_c,	TX4_C,			RX4_C);

/* - SCIF5 ------------------------------------------------------------------ */
SCIF_PFC_PIN(scif5_data_a,	RCAR_GP_PIN(3, 17),	RCAR_GP_PIN(3, 18));
SCIF_PFC_DAT(scif5_data_a,	TX5_A,			RX5_A);
SCIF_PFC_PIN(scif5_data_b,	RCAR_GP_PIN(1, 15),	RCAR_GP_PIN(1, 14));
SCIF_PFC_DAT(scif5_data_b,	TX5_B,			RX5_B);

/* - SDHI macro ------------------------------------------------------------- */
#define SDHI_PFC_PINS(name, args...)		SH_PFC_PINS(name, args)
#define SDHI_PFC_DAT1(name, d0)			SH_PFC_MUX1(name, d0)
#define SDHI_PFC_DAT4(name, d0, d1, d2, d3)	SH_PFC_MUX4(name, d0, d1, d2, d3)
#define SDHI_PFC_CTRL(name, clk, cmd)		SH_PFC_MUX2(name, clk, cmd)
#define SDHI_PFC_CDPN(name, cd)			SH_PFC_MUX1(name, cd)
#define SDHI_PFC_WPPN(name, wp)			SH_PFC_MUX1(name, wp)

/* - SDHI0 ------------------------------------------------------------------ */
SDHI_PFC_PINS(sdhi0_cd,		RCAR_GP_PIN(3, 17));
SDHI_PFC_CDPN(sdhi0_cd,		SD0_CD);
SDHI_PFC_PINS(sdhi0_ctrl,	RCAR_GP_PIN(3, 11),	RCAR_GP_PIN(3, 12));
SDHI_PFC_CTRL(sdhi0_ctrl,	SD0_CLK,		SD0_CMD);
SDHI_PFC_PINS(sdhi0_data1,	RCAR_GP_PIN(3, 13));
SDHI_PFC_DAT1(sdhi0_data1,	SD0_DAT0);
SDHI_PFC_PINS(sdhi0_data4,	RCAR_GP_PIN(3, 13),	RCAR_GP_PIN(3, 14),
				RCAR_GP_PIN(3, 15),	RCAR_GP_PIN(3, 16));
SDHI_PFC_DAT4(sdhi0_data4,	SD0_DAT0,		SD0_DAT1,
				SD0_DAT2,		SD0_DAT3);
SDHI_PFC_PINS(sdhi0_wp,		RCAR_GP_PIN(3, 18));
SDHI_PFC_WPPN(sdhi0_wp,		SD0_WP);

/* - SDHI1 ------------------------------------------------------------------ */
SDHI_PFC_PINS(sdhi1_cd_a,	RCAR_GP_PIN(0, 30));
SDHI_PFC_CDPN(sdhi1_cd_a,	SD1_CD_A);
SDHI_PFC_PINS(sdhi1_cd_b,	RCAR_GP_PIN(2, 24));
SDHI_PFC_CDPN(sdhi1_cd_b,	SD1_CD_B);
SDHI_PFC_PINS(sdhi1_ctrl_a,	RCAR_GP_PIN(1, 5),	RCAR_GP_PIN(1, 6));
SDHI_PFC_CTRL(sdhi1_ctrl_a,	SD1_CLK_A,		SD1_CMD_A);
SDHI_PFC_PINS(sdhi1_ctrl_b,	RCAR_GP_PIN(1, 17),	RCAR_GP_PIN(1, 16));
SDHI_PFC_CTRL(sdhi1_ctrl_b,	SD1_CLK_B,		SD1_CMD_B);
SDHI_PFC_PINS(sdhi1_data1_a,	RCAR_GP_PIN(1, 7));
SDHI_PFC_DAT1(sdhi1_data1_a,	SD1_DAT0_A);
SDHI_PFC_PINS(sdhi1_data1_b,	RCAR_GP_PIN(1, 18));
SDHI_PFC_DAT1(sdhi1_data1_b,	SD1_DAT0_B);
SDHI_PFC_PINS(sdhi1_data4_a,	RCAR_GP_PIN(1, 7),	RCAR_GP_PIN(1, 8),
				RCAR_GP_PIN(0, 5),	RCAR_GP_PIN(0, 6));
SDHI_PFC_DAT4(sdhi1_data4_a,	SD1_DAT0_A,		SD1_DAT1_A,
				SD1_DAT2_A,		SD1_DAT3_A);
SDHI_PFC_PINS(sdhi1_data4_b,	RCAR_GP_PIN(1, 18),	RCAR_GP_PIN(1, 19),
				RCAR_GP_PIN(1, 20),	RCAR_GP_PIN(1, 21));
SDHI_PFC_DAT4(sdhi1_data4_b,	SD1_DAT0_B,		SD1_DAT1_B,
				SD1_DAT2_B,		SD1_DAT3_B);
SDHI_PFC_PINS(sdhi1_wp_a,	RCAR_GP_PIN(0, 31));
SDHI_PFC_WPPN(sdhi1_wp_a,	SD1_WP_A);
SDHI_PFC_PINS(sdhi1_wp_b,	RCAR_GP_PIN(2, 25));
SDHI_PFC_WPPN(sdhi1_wp_b,	SD1_WP_B);

/* - SDH2 ------------------------------------------------------------------- */
SDHI_PFC_PINS(sdhi2_cd_a,	RCAR_GP_PIN(4, 23));
SDHI_PFC_CDPN(sdhi2_cd_a,	SD2_CD_A);
SDHI_PFC_PINS(sdhi2_cd_b,	RCAR_GP_PIN(3, 27));
SDHI_PFC_CDPN(sdhi2_cd_b,	SD2_CD_B);
SDHI_PFC_PINS(sdhi2_ctrl_a,	RCAR_GP_PIN(4, 17),	RCAR_GP_PIN(4, 18));
SDHI_PFC_CTRL(sdhi2_ctrl_a,	SD2_CLK_A,		SD2_CMD_A);
SDHI_PFC_PINS(sdhi2_ctrl_b,	RCAR_GP_PIN(4, 5),	RCAR_GP_PIN(4, 6));
SDHI_PFC_CTRL(sdhi2_ctrl_b,	SD2_CLK_B,		SD2_CMD_B);
SDHI_PFC_PINS(sdhi2_data1_a,	RCAR_GP_PIN(4, 19));
SDHI_PFC_DAT1(sdhi2_data1_a,	SD2_DAT0_A);
SDHI_PFC_PINS(sdhi2_data1_b,	RCAR_GP_PIN(4, 7));
SDHI_PFC_DAT1(sdhi2_data1_b,	SD2_DAT0_B);
SDHI_PFC_PINS(sdhi2_data4_a,	RCAR_GP_PIN(4, 19),	RCAR_GP_PIN(4, 20),
				RCAR_GP_PIN(4, 21),	RCAR_GP_PIN(4, 22));
SDHI_PFC_DAT4(sdhi2_data4_a,	SD2_DAT0_A,		SD2_DAT1_A,
				SD2_DAT2_A,		SD2_DAT3_A);
SDHI_PFC_PINS(sdhi2_data4_b,	RCAR_GP_PIN(4, 7),	RCAR_GP_PIN(4, 8),
				RCAR_GP_PIN(3, 25),	RCAR_GP_PIN(3, 26));
SDHI_PFC_DAT4(sdhi2_data4_b,	SD2_DAT0_B,		SD2_DAT1_B,
				SD2_DAT2_B,		SD2_DAT3_B);
SDHI_PFC_PINS(sdhi2_wp_a,	RCAR_GP_PIN(4, 24));
SDHI_PFC_WPPN(sdhi2_wp_a,	SD2_WP_A);
SDHI_PFC_PINS(sdhi2_wp_b,	RCAR_GP_PIN(3, 28));
SDHI_PFC_WPPN(sdhi2_wp_b,	SD2_WP_B);

/* - SSI macro -------------------------------------------------------------- */
#define SSI_PFC_PINS(name, args...)		SH_PFC_PINS(name, args)
#define SSI_PFC_CTRL(name, sck, ws)		SH_PFC_MUX2(name, sck, ws)
#define SSI_PFC_DATA(name, d)			SH_PFC_MUX1(name, d)

/* - SSI 0/1/2 -------------------------------------------------------------- */
SSI_PFC_PINS(ssi012_ctrl,	RCAR_GP_PIN(3, 6),	RCAR_GP_PIN(3, 7));
SSI_PFC_CTRL(ssi012_ctrl,	SSI_SCK012,		SSI_WS012);
SSI_PFC_PINS(ssi0_data,		RCAR_GP_PIN(3, 10));
SSI_PFC_DATA(ssi0_data,		SSI_SDATA0);
SSI_PFC_PINS(ssi1_a_ctrl,	RCAR_GP_PIN(2, 20),	RCAR_GP_PIN(2, 21));
SSI_PFC_CTRL(ssi1_a_ctrl,	SSI_SCK1_A,		SSI_WS1_A);
SSI_PFC_PINS(ssi1_b_ctrl,	PIN_CS1_A26,		RCAR_GP_PIN(1, 3));
SSI_PFC_CTRL(ssi1_b_ctrl,	SSI_SCK1_B,		SSI_WS1_B);
SSI_PFC_PINS(ssi1_data,		RCAR_GP_PIN(3, 9));
SSI_PFC_DATA(ssi1_data,		SSI_SDATA1);
SSI_PFC_PINS(ssi2_a_ctrl,	RCAR_GP_PIN(2, 26),	RCAR_GP_PIN(3, 4));
SSI_PFC_CTRL(ssi2_a_ctrl,	SSI_SCK2_A,		SSI_WS2_A);
SSI_PFC_PINS(ssi2_b_ctrl,	RCAR_GP_PIN(2, 6),	RCAR_GP_PIN(2, 17));
SSI_PFC_CTRL(ssi2_b_ctrl,	SSI_SCK2_B,		SSI_WS2_B);
SSI_PFC_PINS(ssi2_data,		RCAR_GP_PIN(3, 8));
SSI_PFC_DATA(ssi2_data,		SSI_SDATA2);

/* - SSI 3/4 ---------------------------------------------------------------- */
SSI_PFC_PINS(ssi34_ctrl,	RCAR_GP_PIN(3, 2),	RCAR_GP_PIN(3, 3));
SSI_PFC_CTRL(ssi34_ctrl,	SSI_SCK34,		SSI_WS34);
SSI_PFC_PINS(ssi3_data,		RCAR_GP_PIN(3, 5));
SSI_PFC_DATA(ssi3_data,		SSI_SDATA3);
SSI_PFC_PINS(ssi4_ctrl,		RCAR_GP_PIN(1, 22),     RCAR_GP_PIN(1, 23));
SSI_PFC_CTRL(ssi4_ctrl,		SSI_SCK4,               SSI_WS4);
SSI_PFC_PINS(ssi4_data,		RCAR_GP_PIN(3, 4));
SSI_PFC_DATA(ssi4_data,		SSI_SDATA4);

/* - SSI 5 ------------------------------------------------------------------ */
SSI_PFC_PINS(ssi5_ctrl,		RCAR_GP_PIN(2, 31),	RCAR_GP_PIN(3, 0));
SSI_PFC_CTRL(ssi5_ctrl,		SSI_SCK5,		SSI_WS5);
SSI_PFC_PINS(ssi5_data,		RCAR_GP_PIN(3, 1));
SSI_PFC_DATA(ssi5_data,		SSI_SDATA5);

/* - SSI 6 ------------------------------------------------------------------ */
SSI_PFC_PINS(ssi6_ctrl,		RCAR_GP_PIN(2, 28),	RCAR_GP_PIN(2, 29));
SSI_PFC_CTRL(ssi6_ctrl,		SSI_SCK6,		SSI_WS6);
SSI_PFC_PINS(ssi6_data,		RCAR_GP_PIN(2, 30));
SSI_PFC_DATA(ssi6_data,		SSI_SDATA6);

/* - SSI 7/8  --------------------------------------------------------------- */
SSI_PFC_PINS(ssi78_ctrl,	RCAR_GP_PIN(2, 24),	RCAR_GP_PIN(2, 25));
SSI_PFC_CTRL(ssi78_ctrl,	SSI_SCK78,		SSI_WS78);
SSI_PFC_PINS(ssi7_data,		RCAR_GP_PIN(2, 27));
SSI_PFC_DATA(ssi7_data,		SSI_SDATA7);
SSI_PFC_PINS(ssi8_data,		RCAR_GP_PIN(2, 26));
SSI_PFC_DATA(ssi8_data,		SSI_SDATA8);

/* - USB0 ------------------------------------------------------------------- */
SH_PFC_PINS(usb0,		RCAR_GP_PIN(0, 1));
SH_PFC_MUX1(usb0,		PENC0);
SH_PFC_PINS(usb0_ovc,		RCAR_GP_PIN(0, 3));
SH_PFC_MUX1(usb0_ovc,		USB_OVC0);

/* - USB1 ------------------------------------------------------------------- */
SH_PFC_PINS(usb1,		RCAR_GP_PIN(0, 2));
SH_PFC_MUX1(usb1,		PENC1);
SH_PFC_PINS(usb1_ovc,		RCAR_GP_PIN(0, 4));
SH_PFC_MUX1(usb1_ovc,		USB_OVC1);

/* - VIN macros ------------------------------------------------------------- */
#define VIN_PFC_PINS(name, args...)		SH_PFC_PINS(name, args)
#define VIN_PFC_DAT8(name, d0, d1, d2, d3, d4, d5, d6, d7)	\
	SH_PFC_MUX8(name, d0, d1, d2, d3, d4, d5, d6, d7)
#define VIN_PFC_CLK(name, clk)			SH_PFC_MUX1(name, clk)
#define VIN_PFC_SYNC(name, hsync, vsync)	SH_PFC_MUX2(name, hsync, vsync)

/* - VIN0 ------------------------------------------------------------------- */
VIN_PFC_PINS(vin0_data8,	RCAR_GP_PIN(3, 29),	RCAR_GP_PIN(3, 30),
				RCAR_GP_PIN(3, 31),	RCAR_GP_PIN(4, 0),
				RCAR_GP_PIN(4, 1),	RCAR_GP_PIN(4, 2),
				RCAR_GP_PIN(4, 3),	RCAR_GP_PIN(4, 4));
VIN_PFC_DAT8(vin0_data8,	VI0_DATA0_VI0_B0,	VI0_DATA1_VI0_B1,
				VI0_DATA2_VI0_B2,	VI0_DATA3_VI0_B3,
				VI0_DATA4_VI0_B4,	VI0_DATA5_VI0_B5,
				VI0_DATA6_VI0_G0,	VI0_DATA7_VI0_G1);
VIN_PFC_PINS(vin0_clk,		RCAR_GP_PIN(3, 24));
VIN_PFC_CLK(vin0_clk,		VI0_CLK);
VIN_PFC_PINS(vin0_sync,		RCAR_GP_PIN(3, 27),	RCAR_GP_PIN(3, 28));
VIN_PFC_SYNC(vin0_sync,		VI0_HSYNC,		VI0_VSYNC);
/* - VIN1 ------------------------------------------------------------------- */
VIN_PFC_PINS(vin1_data8,	RCAR_GP_PIN(3, 25),	RCAR_GP_PIN(3, 26),
				RCAR_GP_PIN(3, 27),	RCAR_GP_PIN(3, 28),
				RCAR_GP_PIN(4, 5),	RCAR_GP_PIN(4, 6),
				RCAR_GP_PIN(4, 7),	RCAR_GP_PIN(4, 8));
VIN_PFC_DAT8(vin1_data8,	VI1_DATA0,		VI1_DATA1,
				VI1_DATA2,		VI1_DATA3,
				VI1_DATA4,		VI1_DATA5,
				VI1_DATA6,		VI1_DATA7);
VIN_PFC_PINS(vin1_clk,		RCAR_GP_PIN(4, 9));
VIN_PFC_CLK(vin1_clk,		VI1_CLK);
VIN_PFC_PINS(vin1_sync,		RCAR_GP_PIN(3, 21),	RCAR_GP_PIN(3, 22));
VIN_PFC_SYNC(vin1_sync,		VI1_HSYNC,		VI1_VSYNC);

static const struct sh_pfc_pin_group pinmux_groups[] = {
	SH_PFC_PIN_GROUP(audio_clk_a),
	SH_PFC_PIN_GROUP(audio_clk_b),
	SH_PFC_PIN_GROUP(audio_clk_c),
	SH_PFC_PIN_GROUP(audio_clkout_a),
	SH_PFC_PIN_GROUP(audio_clkout_b),
	SH_PFC_PIN_GROUP(can0_data_a),
	SH_PFC_PIN_GROUP(can0_data_b),
	SH_PFC_PIN_GROUP(can1_data_a),
	SH_PFC_PIN_GROUP(can1_data_b),
	SH_PFC_PIN_GROUP(can_clk_a),
	SH_PFC_PIN_GROUP(can_clk_b),
	SH_PFC_PIN_GROUP(can_clk_c),
	SH_PFC_PIN_GROUP(can_clk_d),
	SH_PFC_PIN_GROUP(ether_rmii),
	SH_PFC_PIN_GROUP(ether_link),
	SH_PFC_PIN_GROUP(ether_magic),
	SH_PFC_PIN_GROUP(hscif0_data_a),
	SH_PFC_PIN_GROUP(hscif0_data_b),
	SH_PFC_PIN_GROUP(hscif0_ctrl_a),
	SH_PFC_PIN_GROUP(hscif0_ctrl_b),
	SH_PFC_PIN_GROUP(hscif0_clk),
	SH_PFC_PIN_GROUP(hscif1_data_a),
	SH_PFC_PIN_GROUP(hscif1_data_b),
	SH_PFC_PIN_GROUP(hscif1_ctrl_a),
	SH_PFC_PIN_GROUP(hscif1_ctrl_b),
	SH_PFC_PIN_GROUP(hscif1_clk_a),
	SH_PFC_PIN_GROUP(hscif1_clk_b),
	SH_PFC_PIN_GROUP(hspi0_a),
	SH_PFC_PIN_GROUP(hspi0_b),
	SH_PFC_PIN_GROUP(hspi1_a),
	SH_PFC_PIN_GROUP(hspi1_b),
	SH_PFC_PIN_GROUP(hspi2_a),
	SH_PFC_PIN_GROUP(hspi2_b),
	SH_PFC_PIN_GROUP(i2c1_a),
	SH_PFC_PIN_GROUP(i2c1_b),
	SH_PFC_PIN_GROUP(i2c2_a),
	SH_PFC_PIN_GROUP(i2c2_b),
	SH_PFC_PIN_GROUP(i2c2_c),
	SH_PFC_PIN_GROUP(i2c3_a),
	SH_PFC_PIN_GROUP(i2c3_b),
	SH_PFC_PIN_GROUP(i2c3_c),
	SH_PFC_PIN_GROUP(mmc_ctrl),
	SH_PFC_PIN_GROUP(mmc_data1),
	SH_PFC_PIN_GROUP(mmc_data4),
	SH_PFC_PIN_GROUP(mmc_data8),
	SH_PFC_PIN_GROUP(scif_clk),
	SH_PFC_PIN_GROUP(scif0_data_a),
	SH_PFC_PIN_GROUP(scif0_data_b),
	SH_PFC_PIN_GROUP(scif0_data_c),
	SH_PFC_PIN_GROUP(scif0_data_d),
	SH_PFC_PIN_GROUP(scif0_ctrl),
	SH_PFC_PIN_GROUP(scif0_clk),
	SH_PFC_PIN_GROUP(scif1_data_a),
	SH_PFC_PIN_GROUP(scif1_data_b),
	SH_PFC_PIN_GROUP(scif1_data_c),
	SH_PFC_PIN_GROUP(scif1_data_d),
	SH_PFC_PIN_GROUP(scif1_ctrl_a),
	SH_PFC_PIN_GROUP(scif1_ctrl_c),
	SH_PFC_PIN_GROUP(scif1_clk_a),
	SH_PFC_PIN_GROUP(scif1_clk_c),
	SH_PFC_PIN_GROUP(scif2_data_a),
	SH_PFC_PIN_GROUP(scif2_data_b),
	SH_PFC_PIN_GROUP(scif2_data_c),
	SH_PFC_PIN_GROUP(scif2_data_d),
	SH_PFC_PIN_GROUP(scif2_data_e),
	SH_PFC_PIN_GROUP(scif2_clk_a),
	SH_PFC_PIN_GROUP(scif2_clk_b),
	SH_PFC_PIN_GROUP(scif2_clk_c),
	SH_PFC_PIN_GROUP(scif3_data_a),
	SH_PFC_PIN_GROUP(scif3_data_b),
	SH_PFC_PIN_GROUP(scif3_data_c),
	SH_PFC_PIN_GROUP(scif3_data_d),
	SH_PFC_PIN_GROUP(scif4_data_a),
	SH_PFC_PIN_GROUP(scif4_data_b),
	SH_PFC_PIN_GROUP(scif4_data_c),
	SH_PFC_PIN_GROUP(scif5_data_a),
	SH_PFC_PIN_GROUP(scif5_data_b),
	SH_PFC_PIN_GROUP(sdhi0_cd),
	SH_PFC_PIN_GROUP(sdhi0_ctrl),
	SH_PFC_PIN_GROUP(sdhi0_data1),
	SH_PFC_PIN_GROUP(sdhi0_data4),
	SH_PFC_PIN_GROUP(sdhi0_wp),
	SH_PFC_PIN_GROUP(sdhi1_cd_a),
	SH_PFC_PIN_GROUP(sdhi1_cd_b),
	SH_PFC_PIN_GROUP(sdhi1_ctrl_a),
	SH_PFC_PIN_GROUP(sdhi1_ctrl_b),
	SH_PFC_PIN_GROUP(sdhi1_data1_a),
	SH_PFC_PIN_GROUP(sdhi1_data1_b),
	SH_PFC_PIN_GROUP(sdhi1_data4_a),
	SH_PFC_PIN_GROUP(sdhi1_data4_b),
	SH_PFC_PIN_GROUP(sdhi1_wp_a),
	SH_PFC_PIN_GROUP(sdhi1_wp_b),
	SH_PFC_PIN_GROUP(sdhi2_cd_a),
	SH_PFC_PIN_GROUP(sdhi2_cd_b),
	SH_PFC_PIN_GROUP(sdhi2_ctrl_a),
	SH_PFC_PIN_GROUP(sdhi2_ctrl_b),
	SH_PFC_PIN_GROUP(sdhi2_data1_a),
	SH_PFC_PIN_GROUP(sdhi2_data1_b),
	SH_PFC_PIN_GROUP(sdhi2_data4_a),
	SH_PFC_PIN_GROUP(sdhi2_data4_b),
	SH_PFC_PIN_GROUP(sdhi2_wp_a),
	SH_PFC_PIN_GROUP(sdhi2_wp_b),
	SH_PFC_PIN_GROUP(ssi012_ctrl),
	SH_PFC_PIN_GROUP(ssi0_data),
	SH_PFC_PIN_GROUP(ssi1_a_ctrl),
	SH_PFC_PIN_GROUP(ssi1_b_ctrl),
	SH_PFC_PIN_GROUP(ssi1_data),
	SH_PFC_PIN_GROUP(ssi2_a_ctrl),
	SH_PFC_PIN_GROUP(ssi2_b_ctrl),
	SH_PFC_PIN_GROUP(ssi2_data),
	SH_PFC_PIN_GROUP(ssi34_ctrl),
	SH_PFC_PIN_GROUP(ssi3_data),
	SH_PFC_PIN_GROUP(ssi4_ctrl),
	SH_PFC_PIN_GROUP(ssi4_data),
	SH_PFC_PIN_GROUP(ssi5_ctrl),
	SH_PFC_PIN_GROUP(ssi5_data),
	SH_PFC_PIN_GROUP(ssi6_ctrl),
	SH_PFC_PIN_GROUP(ssi6_data),
	SH_PFC_PIN_GROUP(ssi78_ctrl),
	SH_PFC_PIN_GROUP(ssi7_data),
	SH_PFC_PIN_GROUP(ssi8_data),
	SH_PFC_PIN_GROUP(usb0),
	SH_PFC_PIN_GROUP(usb0_ovc),
	SH_PFC_PIN_GROUP(usb1),
	SH_PFC_PIN_GROUP(usb1_ovc),
	SH_PFC_PIN_GROUP(vin0_data8),
	SH_PFC_PIN_GROUP(vin0_clk),
	SH_PFC_PIN_GROUP(vin0_sync),
	SH_PFC_PIN_GROUP(vin1_data8),
	SH_PFC_PIN_GROUP(vin1_clk),
	SH_PFC_PIN_GROUP(vin1_sync),
};

static const char * const audio_clk_groups[] = {
	"audio_clk_a",
	"audio_clk_b",
	"audio_clk_c",
	"audio_clkout_a",
	"audio_clkout_b",
};

static const char * const can0_groups[] = {
	"can0_data_a",
	"can0_data_b",
	"can_clk_a",
	"can_clk_b",
	"can_clk_c",
	"can_clk_d",
};

static const char * const can1_groups[] = {
	"can1_data_a",
	"can1_data_b",
	"can_clk_a",
	"can_clk_b",
	"can_clk_c",
	"can_clk_d",
};

static const char * const ether_groups[] = {
	"ether_rmii",
	"ether_link",
	"ether_magic",
};

static const char * const hscif0_groups[] = {
	"hscif0_data_a",
	"hscif0_data_b",
	"hscif0_ctrl_a",
	"hscif0_ctrl_b",
	"hscif0_clk",
};

static const char * const hscif1_groups[] = {
	"hscif1_data_a",
	"hscif1_data_b",
	"hscif1_ctrl_a",
	"hscif1_ctrl_b",
	"hscif1_clk_a",
	"hscif1_clk_b",
};

static const char * const hspi0_groups[] = {
	"hspi0_a",
	"hspi0_b",
};

static const char * const hspi1_groups[] = {
	"hspi1_a",
	"hspi1_b",
};

static const char * const hspi2_groups[] = {
	"hspi2_a",
	"hspi2_b",
};

static const char * const i2c1_groups[] = {
	"i2c1_a",
	"i2c1_b",
};

static const char * const i2c2_groups[] = {
	"i2c2_a",
	"i2c2_b",
	"i2c2_c",
};

static const char * const i2c3_groups[] = {
	"i2c3_a",
	"i2c3_b",
	"i2c3_c",
};

static const char * const mmc_groups[] = {
	"mmc_ctrl",
	"mmc_data1",
	"mmc_data4",
	"mmc_data8",
};

static const char * const scif_clk_groups[] = {
	"scif_clk",
};

static const char * const scif0_groups[] = {
	"scif0_data_a",
	"scif0_data_b",
	"scif0_data_c",
	"scif0_data_d",
	"scif0_ctrl",
	"scif0_clk",
};

static const char * const scif1_groups[] = {
	"scif1_data_a",
	"scif1_data_b",
	"scif1_data_c",
	"scif1_data_d",
	"scif1_ctrl_a",
	"scif1_ctrl_c",
	"scif1_clk_a",
	"scif1_clk_c",
};

static const char * const scif2_groups[] = {
	"scif2_data_a",
	"scif2_data_b",
	"scif2_data_c",
	"scif2_data_d",
	"scif2_data_e",
	"scif2_clk_a",
	"scif2_clk_b",
	"scif2_clk_c",
};

static const char * const scif3_groups[] = {
	"scif3_data_a",
	"scif3_data_b",
	"scif3_data_c",
	"scif3_data_d",
};

static const char * const scif4_groups[] = {
	"scif4_data_a",
	"scif4_data_b",
	"scif4_data_c",
};

static const char * const scif5_groups[] = {
	"scif5_data_a",
	"scif5_data_b",
};


static const char * const sdhi0_groups[] = {
	"sdhi0_cd",
	"sdhi0_ctrl",
	"sdhi0_data1",
	"sdhi0_data4",
	"sdhi0_wp",
};

static const char * const sdhi1_groups[] = {
	"sdhi1_cd_a",
	"sdhi1_cd_b",
	"sdhi1_ctrl_a",
	"sdhi1_ctrl_b",
	"sdhi1_data1_a",
	"sdhi1_data1_b",
	"sdhi1_data4_a",
	"sdhi1_data4_b",
	"sdhi1_wp_a",
	"sdhi1_wp_b",
};

static const char * const sdhi2_groups[] = {
	"sdhi2_cd_a",
	"sdhi2_cd_b",
	"sdhi2_ctrl_a",
	"sdhi2_ctrl_b",
	"sdhi2_data1_a",
	"sdhi2_data1_b",
	"sdhi2_data4_a",
	"sdhi2_data4_b",
	"sdhi2_wp_a",
	"sdhi2_wp_b",
};

static const char * const ssi_groups[] = {
	"ssi012_ctrl",
	"ssi0_data",
	"ssi1_a_ctrl",
	"ssi1_b_ctrl",
	"ssi1_data",
	"ssi2_a_ctrl",
	"ssi2_b_ctrl",
	"ssi2_data",
	"ssi34_ctrl",
	"ssi3_data",
	"ssi4_ctrl",
	"ssi4_data",
	"ssi5_ctrl",
	"ssi5_data",
	"ssi6_ctrl",
	"ssi6_data",
	"ssi78_ctrl",
	"ssi7_data",
	"ssi8_data",
};

static const char * const usb0_groups[] = {
	"usb0",
	"usb0_ovc",
};

static const char * const usb1_groups[] = {
	"usb1",
	"usb1_ovc",
};

static const char * const vin0_groups[] = {
	"vin0_data8",
	"vin0_clk",
	"vin0_sync",
};

static const char * const vin1_groups[] = {
	"vin1_data8",
	"vin1_clk",
	"vin1_sync",
};

static const struct sh_pfc_function pinmux_functions[] = {
	SH_PFC_FUNCTION(audio_clk),
	SH_PFC_FUNCTION(can0),
	SH_PFC_FUNCTION(can1),
	SH_PFC_FUNCTION(ether),
	SH_PFC_FUNCTION(hscif0),
	SH_PFC_FUNCTION(hscif1),
	SH_PFC_FUNCTION(hspi0),
	SH_PFC_FUNCTION(hspi1),
	SH_PFC_FUNCTION(hspi2),
	SH_PFC_FUNCTION(i2c1),
	SH_PFC_FUNCTION(i2c2),
	SH_PFC_FUNCTION(i2c3),
	SH_PFC_FUNCTION(mmc),
	SH_PFC_FUNCTION(scif_clk),
	SH_PFC_FUNCTION(scif0),
	SH_PFC_FUNCTION(scif1),
	SH_PFC_FUNCTION(scif2),
	SH_PFC_FUNCTION(scif3),
	SH_PFC_FUNCTION(scif4),
	SH_PFC_FUNCTION(scif5),
	SH_PFC_FUNCTION(sdhi0),
	SH_PFC_FUNCTION(sdhi1),
	SH_PFC_FUNCTION(sdhi2),
	SH_PFC_FUNCTION(ssi),
	SH_PFC_FUNCTION(usb0),
	SH_PFC_FUNCTION(usb1),
	SH_PFC_FUNCTION(vin0),
	SH_PFC_FUNCTION(vin1),
};

static const struct pinmux_cfg_reg pinmux_config_regs[] = {
	{ PINMUX_CFG_REG("GPSR0", 0xfffc0004, 32, 1, GROUP(
		GP_0_31_FN,	FN_IP1_14_11,
		GP_0_30_FN,	FN_IP1_10_8,
		GP_0_29_FN,	FN_IP1_7_5,
		GP_0_28_FN,	FN_IP1_4_2,
		GP_0_27_FN,	FN_IP1_1,
		GP_0_26_FN,	FN_IP1_0,
		GP_0_25_FN,	FN_IP0_30,
		GP_0_24_FN,	FN_IP0_29,
		GP_0_23_FN,	FN_IP0_28,
		GP_0_22_FN,	FN_IP0_27,
		GP_0_21_FN,	FN_IP0_26,
		GP_0_20_FN,	FN_IP0_25,
		GP_0_19_FN,	FN_IP0_24,
		GP_0_18_FN,	FN_IP0_23,
		GP_0_17_FN,	FN_IP0_22,
		GP_0_16_FN,	FN_IP0_21,
		GP_0_15_FN,	FN_IP0_20,
		GP_0_14_FN,	FN_IP0_19,
		GP_0_13_FN,	FN_IP0_18,
		GP_0_12_FN,	FN_IP0_17,
		GP_0_11_FN,	FN_IP0_16,
		GP_0_10_FN,	FN_IP0_15,
		GP_0_9_FN,	FN_A3,
		GP_0_8_FN,	FN_A2,
		GP_0_7_FN,	FN_A1,
		GP_0_6_FN,	FN_IP0_14_12,
		GP_0_5_FN,	FN_IP0_11_8,
		GP_0_4_FN,	FN_IP0_7_5,
		GP_0_3_FN,	FN_IP0_4_2,
		GP_0_2_FN,	FN_PENC1,
		GP_0_1_FN,	FN_PENC0,
		GP_0_0_FN,	FN_IP0_1_0 ))
	},
	{ PINMUX_CFG_REG("GPSR1", 0xfffc0008, 32, 1, GROUP(
		GP_1_31_FN,	FN_IP4_6_4,
		GP_1_30_FN,	FN_IP4_3_1,
		GP_1_29_FN,	FN_IP4_0,
		GP_1_28_FN,	FN_IP3_31,
		GP_1_27_FN,	FN_IP3_30,
		GP_1_26_FN,	FN_IP3_29,
		GP_1_25_FN,	FN_IP3_28,
		GP_1_24_FN,	FN_IP3_27,
		GP_1_23_FN,	FN_IP3_26_24,
		GP_1_22_FN,	FN_IP3_23_21,
		GP_1_21_FN,	FN_IP3_20_19,
		GP_1_20_FN,	FN_IP3_18_16,
		GP_1_19_FN,	FN_IP3_15_13,
		GP_1_18_FN,	FN_IP3_12_10,
		GP_1_17_FN,	FN_IP3_9_8,
		GP_1_16_FN,	FN_IP3_7_5,
		GP_1_15_FN,	FN_IP3_4_2,
		GP_1_14_FN,	FN_IP3_1_0,
		GP_1_13_FN,	FN_IP2_31,
		GP_1_12_FN,	FN_IP2_30,
		GP_1_11_FN,	FN_IP2_17,
		GP_1_10_FN,	FN_IP2_16_14,
		GP_1_9_FN,	FN_IP2_13_12,
		GP_1_8_FN,	FN_IP2_11_9,
		GP_1_7_FN,	FN_IP2_8_6,
		GP_1_6_FN,	FN_IP2_5_3,
		GP_1_5_FN,	FN_IP2_2_0,
		GP_1_4_FN,	FN_IP1_29_28,
		GP_1_3_FN,	FN_IP1_27_25,
		GP_1_2_FN,	FN_IP1_24,
		GP_1_1_FN,	FN_WE0,
		GP_1_0_FN,	FN_IP1_23_21 ))
	},
	{ PINMUX_CFG_REG("GPSR2", 0xfffc000c, 32, 1, GROUP(
		GP_2_31_FN,	FN_IP6_7,
		GP_2_30_FN,	FN_IP6_6_5,
		GP_2_29_FN,	FN_IP6_4_2,
		GP_2_28_FN,	FN_IP6_1_0,
		GP_2_27_FN,	FN_IP5_30_29,
		GP_2_26_FN,	FN_IP5_28_26,
		GP_2_25_FN,	FN_IP5_25_23,
		GP_2_24_FN,	FN_IP5_22_21,
		GP_2_23_FN,	FN_AUDIO_CLKB,
		GP_2_22_FN,	FN_AUDIO_CLKA,
		GP_2_21_FN,	FN_IP5_20_18,
		GP_2_20_FN,	FN_IP5_17_15,
		GP_2_19_FN,	FN_IP5_14_13,
		GP_2_18_FN,	FN_IP5_12,
		GP_2_17_FN,	FN_IP5_11_10,
		GP_2_16_FN,	FN_IP5_9_8,
		GP_2_15_FN,	FN_IP5_7,
		GP_2_14_FN,	FN_IP5_6,
		GP_2_13_FN,	FN_IP5_5_4,
		GP_2_12_FN,	FN_IP5_3_2,
		GP_2_11_FN,	FN_IP5_1_0,
		GP_2_10_FN,	FN_IP4_30_29,
		GP_2_9_FN,	FN_IP4_28_27,
		GP_2_8_FN,	FN_IP4_26_25,
		GP_2_7_FN,	FN_IP4_24_21,
		GP_2_6_FN,	FN_IP4_20_17,
		GP_2_5_FN,	FN_IP4_16_15,
		GP_2_4_FN,	FN_IP4_14_13,
		GP_2_3_FN,	FN_IP4_12_11,
		GP_2_2_FN,	FN_IP4_10_9,
		GP_2_1_FN,	FN_IP4_8,
		GP_2_0_FN,	FN_IP4_7 ))
	},
	{ PINMUX_CFG_REG("GPSR3", 0xfffc0010, 32, 1, GROUP(
		GP_3_31_FN,	FN_IP8_10_9,
		GP_3_30_FN,	FN_IP8_8_6,
		GP_3_29_FN,	FN_IP8_5_3,
		GP_3_28_FN,	FN_IP8_2_0,
		GP_3_27_FN,	FN_IP7_31_29,
		GP_3_26_FN,	FN_IP7_28_25,
		GP_3_25_FN,	FN_IP7_24_22,
		GP_3_24_FN,	FN_IP7_21,
		GP_3_23_FN,	FN_IP7_20_18,
		GP_3_22_FN,	FN_IP7_17_15,
		GP_3_21_FN,	FN_IP7_14_12,
		GP_3_20_FN,	FN_IP7_11_9,
		GP_3_19_FN,	FN_IP7_8_6,
		GP_3_18_FN,	FN_IP7_5_4,
		GP_3_17_FN,	FN_IP7_3_2,
		GP_3_16_FN,	FN_IP7_1_0,
		GP_3_15_FN,	FN_IP6_31_30,
		GP_3_14_FN,	FN_IP6_29_28,
		GP_3_13_FN,	FN_IP6_27_26,
		GP_3_12_FN,	FN_IP6_25_24,
		GP_3_11_FN,	FN_IP6_23_22,
		GP_3_10_FN,	FN_IP6_21,
		GP_3_9_FN,	FN_IP6_20_19,
		GP_3_8_FN,	FN_IP6_18_17,
		GP_3_7_FN,	FN_IP6_16,
		GP_3_6_FN,	FN_IP6_15_14,
		GP_3_5_FN,	FN_IP6_13,
		GP_3_4_FN,	FN_IP6_12_11,
		GP_3_3_FN,	FN_IP6_10,
		GP_3_2_FN,	FN_SSI_SCK34,
		GP_3_1_FN,	FN_IP6_9,
		GP_3_0_FN,	FN_IP6_8 ))
	},
	{ PINMUX_CFG_REG("GPSR4", 0xfffc0014, 32, 1, GROUP(
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_4_26_FN,	FN_AVS2,
		GP_4_25_FN,	FN_AVS1,
		GP_4_24_FN,	FN_IP10_24_22,
		GP_4_23_FN,	FN_IP10_21_19,
		GP_4_22_FN,	FN_IP10_18_16,
		GP_4_21_FN,	FN_IP10_15_13,
		GP_4_20_FN,	FN_IP10_12_9,
		GP_4_19_FN,	FN_IP10_8_6,
		GP_4_18_FN,	FN_IP10_5_3,
		GP_4_17_FN,	FN_IP10_2_0,
		GP_4_16_FN,	FN_IP9_29_27,
		GP_4_15_FN,	FN_IP9_26_24,
		GP_4_14_FN,	FN_IP9_23_21,
		GP_4_13_FN,	FN_IP9_20_18,
		GP_4_12_FN,	FN_IP9_17_15,
		GP_4_11_FN,	FN_IP9_14_12,
		GP_4_10_FN,	FN_IP9_11_9,
		GP_4_9_FN,	FN_IP9_8_6,
		GP_4_8_FN,	FN_IP9_5_3,
		GP_4_7_FN,	FN_IP9_2_0,
		GP_4_6_FN,	FN_IP8_29_27,
		GP_4_5_FN,	FN_IP8_26_24,
		GP_4_4_FN,	FN_IP8_23_22,
		GP_4_3_FN,	FN_IP8_21_19,
		GP_4_2_FN,	FN_IP8_18_16,
		GP_4_1_FN,	FN_IP8_15_14,
		GP_4_0_FN,	FN_IP8_13_11 ))
	},

	{ PINMUX_CFG_REG_VAR("IPSR0", 0xfffc0020, 32,
			     GROUP(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
				   1, 1, 1, 1, 1, 3, 4, 3, 3, 2),
			     GROUP(
		/* IP0_31 [1] */
		0,	0,
		/* IP0_30 [1] */
		FN_A19,	0,
		/* IP0_29 [1] */
		FN_A18,	0,
		/* IP0_28 [1] */
		FN_A17,	0,
		/* IP0_27 [1] */
		FN_A16,	0,
		/* IP0_26 [1] */
		FN_A15,	0,
		/* IP0_25 [1] */
		FN_A14,	0,
		/* IP0_24 [1] */
		FN_A13,	0,
		/* IP0_23 [1] */
		FN_A12,	0,
		/* IP0_22 [1] */
		FN_A11,	0,
		/* IP0_21 [1] */
		FN_A10,	0,
		/* IP0_20 [1] */
		FN_A9,	0,
		/* IP0_19 [1] */
		FN_A8,	0,
		/* IP0_18 [1] */
		FN_A7,	0,
		/* IP0_17 [1] */
		FN_A6,	0,
		/* IP0_16 [1] */
		FN_A5,	0,
		/* IP0_15 [1] */
		FN_A4,	0,
		/* IP0_14_12 [3] */
		FN_SD1_DAT3_A,	FN_MMC_D3,	0,		FN_A0,
		FN_ATAG0_A,	0,		FN_REMOCON_B,	0,
		/* IP0_11_8 [4] */
		FN_SD1_DAT2_A,	FN_MMC_D2,	0,		FN_BS,
		FN_ATADIR0_A,	0,		FN_SDSELF_A,	0,
		FN_PWM4_B,	0,		0,		0,
		0,		0,		0,		0,
		/* IP0_7_5 [3] */
		FN_AUDATA1,	FN_ARM_TRACEDATA_1,	FN_GPSIN_C,	FN_USB_OVC1,
		FN_RX2_E,	FN_SCL2_B,		0,		0,
		/* IP0_4_2 [3] */
		FN_AUDATA0,	FN_ARM_TRACEDATA_0,	FN_GPSCLK_C,	FN_USB_OVC0,
		FN_TX2_E,	FN_SDA2_B,		0,		0,
		/* IP0_1_0 [2] */
		FN_PRESETOUT,	0,	FN_PWM1,	0,
		))
	},
	{ PINMUX_CFG_REG_VAR("IPSR1", 0xfffc0024, 32,
			     GROUP(1, 1, 2, 3, 1, 3, 3, 1, 2, 4, 3, 3,
				   3, 1, 1),
			     GROUP(
		/* IP1_31 [1] */
		0,	0,
		/* IP1_30 [1] */
		0,	0,
		/* IP1_29_28 [2] */
		FN_EX_CS1,	FN_MMC_D4,	0,	0,
		/* IP1_27_25 [3] */
		FN_SSI_WS1_B,	FN_EX_CS0,	FN_SCL2_A,	FN_TX3_C,
		FN_TS_SCK0_A,	0,		0,		0,
		/* IP1_24 [1] */
		FN_WE1,		FN_ATAWR0_B,
		/* IP1_23_21 [3] */
		FN_MMC_D5,	FN_ATADIR0_B,	0,		FN_RD_WR,
		0,		0,		0,		0,
		/* IP1_20_18 [3] */
		FN_SSI_SCK1_B,	FN_ATAG0_B,	FN_CS1_A26,	FN_SDA2_A,
		FN_SCK2_B,	0,		0,		0,
		/* IP1_17 [1] */
		FN_CS0,		FN_HSPI_RX1_B,
		/* IP1_16_15 [2] */
		FN_CLKOUT,	FN_HSPI_TX1_B,	FN_PWM0_B,	0,
		/* IP1_14_11 [4] */
		FN_SD1_WP_A,	FN_MMC_D7,	0,		FN_A25,
		FN_DACK1_A,	0,		FN_HCTS0_B,	FN_RX3_C,
		FN_TS_SDAT0_A,	0,		0,		0,
		0,		0,		0,		0,
		/* IP1_10_8 [3] */
		FN_SD1_CD_A,	FN_MMC_D6,	0,		FN_A24,
		FN_DREQ1_A,	0,		FN_HRX0_B,	FN_TS_SPSYNC0_A,
		/* IP1_7_5 [3] */
		FN_A23,		FN_HTX0_B,	FN_TX2_B,	FN_DACK2_A,
		FN_TS_SDEN0_A,	0,		0,		0,
		/* IP1_4_2 [3] */
		FN_A22,		FN_HRTS0_B,	FN_RX2_B,	FN_DREQ2_A,
		0,		0,		0,		0,
		/* IP1_1 [1] */
		FN_A21,		FN_HSPI_CLK1_B,
		/* IP1_0 [1] */
		FN_A20,		FN_HSPI_CS1_B,
		))
	},
	{ PINMUX_CFG_REG_VAR("IPSR2", 0xfffc0028, 32,
			     GROUP(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
				   1, 1, 1, 3, 2, 3, 3, 3, 3),
			     GROUP(
		/* IP2_31 [1] */
		FN_MLB_CLK,	FN_IRQ1_A,
		/* IP2_30 [1] */
		FN_RD_WR_B,	FN_IRQ0,
		/* IP2_29 [1] */
		FN_D11,		0,
		/* IP2_28 [1] */
		FN_D10,		0,
		/* IP2_27 [1] */
		FN_D9,		0,
		/* IP2_26 [1] */
		FN_D8,		0,
		/* IP2_25 [1] */
		FN_D7,		0,
		/* IP2_24 [1] */
		FN_D6,		0,
		/* IP2_23 [1] */
		FN_D5,		0,
		/* IP2_22 [1] */
		FN_D4,		0,
		/* IP2_21 [1] */
		FN_D3,		0,
		/* IP2_20 [1] */
		FN_D2,		0,
		/* IP2_19 [1] */
		FN_D1,		0,
		/* IP2_18 [1] */
		FN_D0,		0,
		/* IP2_17 [1] */
		FN_EX_WAIT0,	FN_PWM0_C,
		/* IP2_16_14 [3] */
		FN_DACK0,	0,	0,	FN_TX3_A,
		FN_DRACK0,	0,	0,	0,
		/* IP2_13_12 [2] */
		FN_DREQ0_A,	0,	0,	FN_RX3_A,
		/* IP2_11_9 [3] */
		FN_SD1_DAT1_A,	FN_MMC_D1,	0,	FN_ATAWR0_A,
		FN_EX_CS5,	FN_EX_WAIT2_A,	0,	0,
		/* IP2_8_6 [3] */
		FN_SD1_DAT0_A,	FN_MMC_D0,	0,	FN_ATARD0,
		FN_EX_CS4,	FN_EX_WAIT1_A,	0,	0,
		/* IP2_5_3 [3] */
		FN_SD1_CMD_A,	FN_MMC_CMD,	0,	FN_ATACS10,
		FN_EX_CS3,	0,		0,	0,
		/* IP2_2_0 [3] */
		FN_SD1_CLK_A,	FN_MMC_CLK,	0,	FN_ATACS00,
		FN_EX_CS2,	0,		0,	0,
		))
	},
	{ PINMUX_CFG_REG_VAR("IPSR3", 0xfffc002c, 32,
			     GROUP(1, 1, 1, 1, 1, 3, 3, 2, 3, 3, 3, 2,
				   3, 3, 2),
			     GROUP(
		/* IP3_31 [1] */
		FN_DU0_DR6,	FN_LCDOUT6,
		/* IP3_30 [1] */
		FN_DU0_DR5,	FN_LCDOUT5,
		/* IP3_29 [1] */
		FN_DU0_DR4,	FN_LCDOUT4,
		/* IP3_28 [1] */
		FN_DU0_DR3,	FN_LCDOUT3,
		/* IP3_27 [1] */
		FN_DU0_DR2,	FN_LCDOUT2,
		/* IP3_26_24 [3] */
		FN_SSI_WS4,		FN_DU0_DR1,	FN_LCDOUT1,	FN_AUDATA3,
		FN_ARM_TRACEDATA_3,	FN_SCL3_C,	FN_ADICHS2,	FN_TS_SPSYNC0_B,
		/* IP3_23_21 [3] */
		FN_SSI_SCK4,		FN_DU0_DR0,	FN_LCDOUT0,	FN_AUDATA2,
		FN_ARM_TRACEDATA_2,	FN_SDA3_C,	FN_ADICHS1,	FN_TS_SDEN0_B,
		/* IP3_20_19 [2] */
		FN_SD1_DAT3_B,	FN_HRTS0_A,	FN_RTS0,	0,
		/* IP3_18_16 [3] */
		FN_SD1_DAT2_B,	FN_HCTS0_A,	FN_CTS0,	0,
		0,		0,		0,		0,
		/* IP3_15_13 [3] */
		FN_SD1_DAT1_B,	FN_HSCK0,	FN_SCK0,	FN_SCL3_B,
		0,		0,		0,		0,
		/* IP3_12_10 [3] */
		FN_SD1_DAT0_B,	FN_HRX0_A,	FN_RX0_A,	0,
		0,		0,		0,		0,
		/* IP3_9_8 [2] */
		FN_SD1_CLK_B,	FN_HTX0_A,	FN_TX0_A,	0,
		/* IP3_7_5 [3] */
		FN_SD1_CMD_B,	FN_SCIF_CLK,	FN_AUDIO_CLKOUT_B,	FN_CAN_CLK_B,
		FN_SDA3_B,	0,		0,			0,
		/* IP3_4_2 [3] */
		FN_MLB_DAT,	FN_TX5_B,	FN_SCL3_A,	FN_IRQ3_A,
		FN_SDSELF_B,	0,		0,		0,
		/* IP3_1_0 [2] */
		FN_MLB_SIG,	FN_RX5_B,	FN_SDA3_A,	FN_IRQ2_A,
		))
	},
	{ PINMUX_CFG_REG_VAR("IPSR4", 0xfffc0030, 32,
			     GROUP(1, 2, 2, 2, 4, 4, 2, 2, 2, 2, 1, 1,
				   3, 3, 1),
			     GROUP(
		/* IP4_31 [1] */
		0,	0,
		/* IP4_30_29 [2] */
		FN_VI0_R4_B,	FN_DU0_DB4,	FN_LCDOUT20,	0,
		/* IP4_28_27 [2] */
		FN_VI0_R3_B,	FN_DU0_DB3,	FN_LCDOUT19,	0,
		/* IP4_26_25 [2] */
		FN_VI0_R2_B,	FN_DU0_DB2,	FN_LCDOUT18,	0,
		/* IP4_24_21 [4] */
		FN_AUDIO_CLKC,	FN_VI0_R1_B,		FN_DU0_DB1,	FN_LCDOUT17,
		FN_AUDATA7,	FN_ARM_TRACEDATA_7,	FN_GPSIN_A,	0,
		FN_ADICS_SAMP,	FN_TS_SCK0_B,		0,		0,
		0,		0,			0,		0,
		/* IP4_20_17 [4] */
		FN_SSI_SCK2_B,	FN_VI0_R0_B,		FN_DU0_DB0,	FN_LCDOUT16,
		FN_AUDATA6,	FN_ARM_TRACEDATA_6,	FN_GPSCLK_A,	FN_PWM0_A,
		FN_ADICLK,	FN_TS_SDAT0_B,		0,		0,
		0,		0,			0,		0,
		/* IP4_16_15 [2] */
		FN_DU0_DG7,	FN_LCDOUT15,	FN_TX4_A,	0,
		/* IP4_14_13 [2] */
		FN_DU0_DG6,	FN_LCDOUT14,	FN_RX4_A,	0,
		/* IP4_12_11 [2] */
		FN_DU0_DG5,	FN_LCDOUT13,	FN_TX0_B,	0,
		/* IP4_10_9 [2] */
		FN_DU0_DG4,	FN_LCDOUT12,	FN_RX0_B,	0,
		/* IP4_8 [1] */
		FN_DU0_DG3,	FN_LCDOUT11,
		/* IP4_7 [1] */
		FN_DU0_DG2,	FN_LCDOUT10,
		/* IP4_6_4 [3] */
		FN_DU0_DG1,	FN_LCDOUT9,	FN_AUDATA5,	FN_ARM_TRACEDATA_5,
		FN_RX1_D,	FN_CAN0_RX_A,	FN_ADIDATA,	0,
		/* IP4_3_1 [3] */
		FN_DU0_DG0,	FN_LCDOUT8,	FN_AUDATA4,	FN_ARM_TRACEDATA_4,
		FN_TX1_D,	FN_CAN0_TX_A,	FN_ADICHS0,	0,
		/* IP4_0 [1] */
		FN_DU0_DR7,	FN_LCDOUT7,
		))
	},
	{ PINMUX_CFG_REG_VAR("IPSR5", 0xfffc0034, 32,
			     GROUP(1, 2, 3, 3, 2, 3, 3, 2, 1, 2, 2, 1,
				   1, 2, 2, 2),
			     GROUP(

		/* IP5_31 [1] */
		0, 0,
		/* IP5_30_29 [2] */
		FN_SSI_SDATA7,	FN_HSPI_TX0_B,	FN_RX2_A,	FN_CAN0_RX_B,
		/* IP5_28_26 [3] */
		FN_SSI_SDATA8,	FN_SSI_SCK2_A,	FN_HSPI_CS0_B,	FN_TX2_A,
		FN_CAN0_TX_B,	0,		0,		0,
		/* IP5_25_23 [3] */
		FN_SD1_WP_B,	FN_SSI_WS78,	FN_HSPI_CLK0_B,	FN_RX1_B,
		FN_CAN_CLK_D,	0,		0,		0,
		/* IP5_22_21 [2] */
		FN_SD1_CD_B,	FN_SSI_SCK78,	FN_HSPI_RX0_B,	FN_TX1_B,
		/* IP5_20_18 [3] */
		FN_SSI_WS1_A,		FN_DU0_CDE,	FN_QPOLB,	FN_AUDSYNC,
		FN_ARM_TRACECTL,	FN_FMIN_D,	0,		0,
		/* IP5_17_15 [3] */
		FN_SSI_SCK1_A,		FN_DU0_DISP,	FN_QPOLA,	FN_AUDCK,
		FN_ARM_TRACECLK,	FN_BPFCLK_D,	0,		0,
		/* IP5_14_13 [2] */
		FN_DU0_EXODDF_DU0_ODDF_DISP_CDE,	FN_QCPV_QDE,
		FN_FMCLK_D,				0,
		/* IP5_12 [1] */
		FN_DU0_EXVSYNC_DU0_VSYNC,	FN_QSTB_QHE,
		/* IP5_11_10 [2] */
		FN_SSI_WS2_B,	FN_DU0_EXHSYNC_DU0_HSYNC,
		FN_QSTH_QHS,	0,
		/* IP5_9_8 [2] */
		FN_DU0_DOTCLKO_UT1,	FN_QSTVB_QVE,
		FN_AUDIO_CLKOUT_A,	FN_REMOCON_C,
		/* IP5_7 [1] */
		FN_DU0_DOTCLKO_UT0,	FN_QCLK,
		/* IP5_6 [1] */
		FN_DU0_DOTCLKIN,	FN_QSTVA_QVS,
		/* IP5_5_4 [2] */
		FN_VI1_DATA11_B,	FN_DU0_DB7,	FN_LCDOUT23,	0,
		/* IP5_3_2 [2] */
		FN_VI1_DATA10_B,	FN_DU0_DB6,	FN_LCDOUT22,	0,
		/* IP5_1_0 [2] */
		FN_VI0_R5_B,		FN_DU0_DB5,	FN_LCDOUT21,	0,
		))
	},
	{ PINMUX_CFG_REG_VAR("IPSR6", 0xfffc0038, 32,
			     GROUP(2, 2, 2, 2, 2, 1, 2, 2, 1, 2, 1, 2,
				   1, 1, 1, 1, 2, 3, 2),
			     GROUP(
		/* IP6_31_30 [2] */
		FN_SD0_DAT2,	0,	FN_SUB_TDI,	0,
		/* IP6_29_28 [2] */
		FN_SD0_DAT1,	0,	FN_SUB_TCK,	0,
		/* IP6_27_26 [2] */
		FN_SD0_DAT0,	0,	FN_SUB_TMS,	0,
		/* IP6_25_24 [2] */
		FN_SD0_CMD,	0,	FN_SUB_TRST,	0,
		/* IP6_23_22 [2] */
		FN_SD0_CLK,	0,	FN_SUB_TDO,	0,
		/* IP6_21 [1] */
		FN_SSI_SDATA0,		FN_ARM_TRACEDATA_15,
		/* IP6_20_19 [2] */
		FN_SSI_SDATA1,		FN_ARM_TRACEDATA_14,
		FN_SCL1_A,		FN_SCK2_A,
		/* IP6_18_17 [2] */
		FN_SSI_SDATA2,		FN_HSPI_CS2_A,
		FN_ARM_TRACEDATA_13,	FN_SDA1_A,
		/* IP6_16 [1] */
		FN_SSI_WS012,		FN_ARM_TRACEDATA_12,
		/* IP6_15_14 [2] */
		FN_SSI_SCK012,		FN_ARM_TRACEDATA_11,
		FN_TX0_D,		0,
		/* IP6_13 [1] */
		FN_SSI_SDATA3,		FN_ARM_TRACEDATA_10,
		/* IP6_12_11 [2] */
		FN_SSI_SDATA4,		FN_SSI_WS2_A,
		FN_ARM_TRACEDATA_9,	0,
		/* IP6_10 [1] */
		FN_SSI_WS34,		FN_ARM_TRACEDATA_8,
		/* IP6_9 [1] */
		FN_SSI_SDATA5,		FN_RX0_D,
		/* IP6_8 [1] */
		FN_SSI_WS5,		FN_TX4_C,
		/* IP6_7 [1] */
		FN_SSI_SCK5,		FN_RX4_C,
		/* IP6_6_5 [2] */
		FN_SSI_SDATA6,		FN_HSPI_TX2_A,
		FN_FMIN_B,		0,
		/* IP6_4_2 [3] */
		FN_SSI_WS6,		FN_HSPI_CLK2_A,
		FN_BPFCLK_B,		FN_CAN1_RX_B,
		0,	0,	0,	0,
		/* IP6_1_0 [2] */
		FN_SSI_SCK6,		FN_HSPI_RX2_A,
		FN_FMCLK_B,		FN_CAN1_TX_B,
		))
	},
	{ PINMUX_CFG_REG_VAR("IPSR7", 0xfffc003c, 32,
			     GROUP(3, 4, 3, 1, 3, 3, 3, 3, 3, 2, 2, 2),
			     GROUP(

		/* IP7_31_29 [3] */
		FN_VI0_HSYNC,	FN_SD2_CD_B,	FN_VI1_DATA2,	FN_DU1_DR2,
		0,		FN_HSPI_CS1_A,	FN_RX3_B,	0,
		/* IP7_28_25 [4] */
		FN_VI0_FIELD,	FN_SD2_DAT3_B,	FN_VI0_R3_C,	FN_VI1_DATA1,
		FN_DU1_DG7,	0,		FN_HSPI_CLK1_A,	FN_TX4_B,
		0,	0,	0,	0,
		0,	0,	0,	0,
		/* IP7_24_22 [3] */
		FN_VI0_CLKENB,	FN_SD2_DAT2_B,	FN_VI1_DATA0,	FN_DU1_DG6,
		0,		FN_HSPI_RX1_A,	FN_RX4_B,	0,
		/* IP7_21 [1] */
		FN_VI0_CLK,	FN_CAN_CLK_A,
		/* IP7_20_18 [3] */
		FN_TCLK0,	FN_HSCK1_A,	FN_FMIN_A,	0,
		FN_IRQ2_C,	FN_CTS1_C,	FN_SPEEDIN,	0,
		/* IP7_17_15 [3] */
		FN_VI1_VSYNC,	FN_HSPI_TX0,	FN_HCTS1_A,	FN_BPFCLK_A,
		0,		FN_TX1_C,	0,		0,
		/* IP7_14_12 [3] */
		FN_VI1_HSYNC,	FN_HSPI_RX0_A,	FN_HRTS1_A,	FN_FMCLK_A,
		0,		FN_RX1_C,	0,		0,
		/* IP7_11_9 [3] */
		FN_VI1_FIELD,	FN_HSPI_CS0_A,	FN_HRX1_A,	0,
		FN_SCK1_C,	0,		0,		0,
		/* IP7_8_6 [3] */
		FN_VI1_CLKENB,	FN_HSPI_CLK0_A,	FN_HTX1_A,	0,
		FN_RTS1_C,	0,		0,		0,
		/* IP7_5_4 [2] */
		FN_SD0_WP,	0,		FN_RX5_A,	0,
		/* IP7_3_2 [2] */
		FN_SD0_CD,	0,		FN_TX5_A,	0,
		/* IP7_1_0 [2] */
		FN_SD0_DAT3,	0,		FN_IRQ1_B,	0,
		))
	},
	{ PINMUX_CFG_REG_VAR("IPSR8", 0xfffc0040, 32,
			     GROUP(1, 1, 3, 3, 2, 3, 3, 2, 3, 2, 3, 3, 3),
			     GROUP(
		/* IP8_31 [1] */
		0, 0,
		/* IP8_30 [1] */
		0, 0,
		/* IP8_29_27 [3] */
		FN_VI0_G3,	FN_SD2_CMD_B,	FN_VI1_DATA5,	FN_DU1_DR5,
		0,		FN_HRX1_B,	0,		0,
		/* IP8_26_24 [3] */
		FN_VI0_G2,	FN_SD2_CLK_B,	FN_VI1_DATA4,	FN_DU1_DR4,
		0,		FN_HTX1_B,	0,		0,
		/* IP8_23_22 [2] */
		FN_VI0_DATA7_VI0_G1,	FN_DU1_DB5,
		FN_RTS1_A,		0,
		/* IP8_21_19 [3] */
		FN_VI0_DATA6_VI0_G0,	FN_DU1_DB4,
		FN_CTS1_A,		FN_PWM5,
		0,	0,	0,	0,
		/* IP8_18_16 [3] */
		FN_VI0_DATA5_VI0_B5,	FN_DU1_DB3,	FN_SCK1_A,	FN_PWM4,
		0,			FN_HSCK1_B,	0,		0,
		/* IP8_15_14 [2] */
		FN_VI0_DATA4_VI0_B4,	FN_DU1_DB2,	FN_RX1_A,	0,
		/* IP8_13_11 [3] */
		FN_VI0_DATA3_VI0_B3,	FN_DU1_DG5,	FN_TX1_A,	FN_TX0_C,
		0,			 0,		0,		0,
		/* IP8_10_9 [2] */
		FN_VI0_DATA2_VI0_B2,	FN_DU1_DG4,	FN_RX0_C,	0,
		/* IP8_8_6 [3] */
		FN_VI0_DATA1_VI0_B1,	FN_DU1_DG3,	FN_IRQ3_B,	FN_TX3_D,
		0,			 0,		0,		0,
		/* IP8_5_3 [3] */
		FN_VI0_DATA0_VI0_B0,	FN_DU1_DG2,	FN_IRQ2_B,	FN_RX3_D,
		0,			 0,		0,		0,
		/* IP8_2_0 [3] */
		FN_VI0_VSYNC,		FN_SD2_WP_B,	FN_VI1_DATA3,	FN_DU1_DR3,
		0,			FN_HSPI_TX1_A,	FN_TX3_B,	0,
		))
	},
	{ PINMUX_CFG_REG_VAR("IPSR9", 0xfffc0044, 32,
			     GROUP(1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3),
			     GROUP(
		/* IP9_31 [1] */
		0, 0,
		/* IP9_30 [1] */
		0, 0,
		/* IP9_29_27 [3] */
		FN_VI1_DATA11_A,	FN_DU1_EXHSYNC_DU1_HSYNC,
		FN_ETH_RXD1,		FN_FMIN_C,
		0,			FN_RX2_D,
		FN_SCL2_C,		0,
		/* IP9_26_24 [3] */
		FN_VI1_DATA10_A,	FN_DU1_DOTCLKOUT,
		FN_ETH_RXD0,		FN_BPFCLK_C,
		0,			FN_TX2_D,
		FN_SDA2_C,		0,
		/* IP9_23_21 [3] */
		FN_VI0_R5_A,	0,		FN_ETH_RX_ER,	FN_FMCLK_C,
		FN_IERX,	FN_RX2_C,	0,		0,
		/* IP9_20_18 [3] */
		FN_VI0_R4_A,	FN_ETH_TX_EN,	0,		0,
		FN_IETX,	FN_TX2_C,	0,		0,
		/* IP9_17_15 [3] */
		FN_VI0_R3_A,	FN_ETH_CRS_DV,	0,		FN_IECLK,
		FN_SCK2_C,	0,		0,		0,
		/* IP9_14_12 [3] */
		FN_VI0_R2_A,	FN_VI1_DATA9,	FN_DU1_DB7,	FN_ETH_TXD1,
		0,		FN_PWM3,	0,		0,
		/* IP9_11_9 [3] */
		FN_VI0_R1_A,	FN_VI1_DATA8,	FN_DU1_DB6,	FN_ETH_TXD0,
		0,		FN_PWM2,	FN_TCLK1,	0,
		/* IP9_8_6 [3] */
		FN_VI0_R0_A,	FN_VI1_CLK,	FN_ETH_REF_CLK,	FN_DU1_DOTCLKIN,
		0,		0,		0,		0,
		/* IP9_5_3 [3] */
		FN_VI0_G5,	FN_SD2_DAT1_B,	FN_VI1_DATA7,	FN_DU1_DR7,
		0,		FN_HCTS1_B,	0,		0,
		/* IP9_2_0 [3] */
		FN_VI0_G4,	FN_SD2_DAT0_B,	FN_VI1_DATA6,	FN_DU1_DR6,
		0,		FN_HRTS1_B,	0,		0,
		))
	},
	{ PINMUX_CFG_REG_VAR("IPSR10", 0xfffc0048, 32,
			     GROUP(1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 4,
				   3, 3, 3),
			     GROUP(

		/* IP10_31 [1] */
		0, 0,
		/* IP10_30 [1] */
		0, 0,
		/* IP10_29 [1] */
		0, 0,
		/* IP10_28 [1] */
		0, 0,
		/* IP10_27 [1] */
		0, 0,
		/* IP10_26 [1] */
		0, 0,
		/* IP10_25 [1] */
		0, 0,
		/* IP10_24_22 [3] */
		FN_SD2_WP_A,	FN_VI1_DATA15,	FN_EX_WAIT2_B,	FN_DACK0_B,
		FN_HSPI_TX2_B,	FN_CAN_CLK_C,	0,		0,
		/* IP10_21_19 [3] */
		FN_SD2_CD_A,	FN_VI1_DATA14,	FN_EX_WAIT1_B,	FN_DREQ0_B,
		FN_HSPI_RX2_B,	FN_REMOCON_A,	0,		0,
		/* IP10_18_16 [3] */
		FN_SD2_DAT3_A,	FN_VI1_DATA13,	FN_DACK2_B,	FN_ATAG1,
		FN_HSPI_CS2_B,	FN_GPSIN_B,	0,		0,
		/* IP10_15_13 [3] */
		FN_SD2_DAT2_A,	FN_VI1_DATA12,	FN_DREQ2_B,	FN_ATADIR1,
		FN_HSPI_CLK2_B,	FN_GPSCLK_B,	0,		0,
		/* IP10_12_9 [4] */
		FN_SD2_DAT1_A,	FN_DU1_CDE,	FN_ATACS11,	FN_DACK1_B,
		FN_ETH_MAGIC,	FN_CAN1_TX_A,	0,		FN_PWM6,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IP10_8_6 [3] */
		FN_SD2_DAT0_A,	FN_DU1_DISP,	FN_ATACS01,	FN_DREQ1_B,
		FN_ETH_LINK,	FN_CAN1_RX_A,	0,		0,
		/* IP10_5_3 [3] */
		FN_SD2_CMD_A,	FN_DU1_EXODDF_DU1_ODDF_DISP_CDE,
		FN_ATAWR1,	FN_ETH_MDIO,
		FN_SCL1_B,	0,
		0,		0,
		/* IP10_2_0 [3] */
		FN_SD2_CLK_A,	FN_DU1_EXVSYNC_DU1_VSYNC,
		FN_ATARD1,	FN_ETH_MDC,
		FN_SDA1_B,	0,
		0,		0,
		))
	},
	{ PINMUX_CFG_REG_VAR("MOD_SEL0", 0xfffc0050, 32,
			     GROUP(1, 1, 2, 2, 3, 2, 2, 1, 1, 1, 1, 2,
				   1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1),
			     GROUP(

		/* SEL 31  [1] */
		0, 0,
		/* SEL_30 (SCIF5) [1] */
		FN_SEL_SCIF5_A,		FN_SEL_SCIF5_B,
		/* SEL_29_28 (SCIF4) [2] */
		FN_SEL_SCIF4_A,		FN_SEL_SCIF4_B,
		FN_SEL_SCIF4_C,		0,
		/* SEL_27_26 (SCIF3) [2] */
		FN_SEL_SCIF3_A,		FN_SEL_SCIF3_B,
		FN_SEL_SCIF3_C,		FN_SEL_SCIF3_D,
		/* SEL_25_23 (SCIF2) [3] */
		FN_SEL_SCIF2_A,		FN_SEL_SCIF2_B,
		FN_SEL_SCIF2_C,		FN_SEL_SCIF2_D,
		FN_SEL_SCIF2_E,		0,
		0,			0,
		/* SEL_22_21 (SCIF1) [2] */
		FN_SEL_SCIF1_A,		FN_SEL_SCIF1_B,
		FN_SEL_SCIF1_C,		FN_SEL_SCIF1_D,
		/* SEL_20_19 (SCIF0) [2] */
		FN_SEL_SCIF0_A,		FN_SEL_SCIF0_B,
		FN_SEL_SCIF0_C,		FN_SEL_SCIF0_D,
		/* SEL_18 [1] */
		0, 0,
		/* SEL_17 (SSI2) [1] */
		FN_SEL_SSI2_A,		FN_SEL_SSI2_B,
		/* SEL_16 (SSI1) [1] */
		FN_SEL_SSI1_A,		FN_SEL_SSI1_B,
		/* SEL_15 (VI1) [1] */
		FN_SEL_VI1_A,		FN_SEL_VI1_B,
		/* SEL_14_13 (VI0) [2] */
		FN_SEL_VI0_A,		FN_SEL_VI0_B,
		FN_SEL_VI0_C,		FN_SEL_VI0_D,
		/* SEL_12 [1] */
		0, 0,
		/* SEL_11 (SD2) [1] */
		FN_SEL_SD2_A,		FN_SEL_SD2_B,
		/* SEL_10 (SD1) [1] */
		FN_SEL_SD1_A,		FN_SEL_SD1_B,
		/* SEL_9 (IRQ3) [1] */
		FN_SEL_IRQ3_A,		FN_SEL_IRQ3_B,
		/* SEL_8_7 (IRQ2) [2] */
		FN_SEL_IRQ2_A,		FN_SEL_IRQ2_B,
		FN_SEL_IRQ2_C,		0,
		/* SEL_6 (IRQ1) [1] */
		FN_SEL_IRQ1_A,		FN_SEL_IRQ1_B,
		/* SEL_5 [1] */
		0, 0,
		/* SEL_4 (DREQ2) [1] */
		FN_SEL_DREQ2_A,		FN_SEL_DREQ2_B,
		/* SEL_3 (DREQ1) [1] */
		FN_SEL_DREQ1_A,		FN_SEL_DREQ1_B,
		/* SEL_2 (DREQ0) [1] */
		FN_SEL_DREQ0_A,		FN_SEL_DREQ0_B,
		/* SEL_1 (WAIT2) [1] */
		FN_SEL_WAIT2_A,		FN_SEL_WAIT2_B,
		/* SEL_0 (WAIT1) [1] */
		FN_SEL_WAIT1_A,		FN_SEL_WAIT1_B,
		))
	},
	{ PINMUX_CFG_REG_VAR("MOD_SEL1", 0xfffc0054, 32,
			     GROUP(1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1,
				   1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 2, 2, 1),
			     GROUP(

		/* SEL_31 [1] */
		0, 0,
		/* SEL_30 [1] */
		0, 0,
		/* SEL_29 [1] */
		0, 0,
		/* SEL_28 [1] */
		0, 0,
		/* SEL_27 (CAN1) [1] */
		FN_SEL_CAN1_A,		FN_SEL_CAN1_B,
		/* SEL_26 (CAN0) [1] */
		FN_SEL_CAN0_A,		FN_SEL_CAN0_B,
		/* SEL_25_24 (CANCLK) [2] */
		FN_SEL_CANCLK_A,	FN_SEL_CANCLK_B,
		FN_SEL_CANCLK_C,	FN_SEL_CANCLK_D,
		/* SEL_23 (HSCIF1) [1] */
		FN_SEL_HSCIF1_A,	FN_SEL_HSCIF1_B,
		/* SEL_22 (HSCIF0) [1] */
		FN_SEL_HSCIF0_A,	FN_SEL_HSCIF0_B,
		/* SEL_21 [1] */
		0, 0,
		/* SEL_20 [1] */
		0, 0,
		/* SEL_19 [1] */
		0, 0,
		/* SEL_18 [1] */
		0, 0,
		/* SEL_17 [1] */
		0, 0,
		/* SEL_16 [1] */
		0, 0,
		/* SEL_15 [1] */
		0, 0,
		/* SEL_14_13 (REMOCON) [2] */
		FN_SEL_REMOCON_A,	FN_SEL_REMOCON_B,
		FN_SEL_REMOCON_C,	0,
		/* SEL_12_11 (FM) [2] */
		FN_SEL_FM_A,		FN_SEL_FM_B,
		FN_SEL_FM_C,		FN_SEL_FM_D,
		/* SEL_10_9 (GPS) [2] */
		FN_SEL_GPS_A,		FN_SEL_GPS_B,
		FN_SEL_GPS_C,		0,
		/* SEL_8 (TSIF0) [1] */
		FN_SEL_TSIF0_A,		FN_SEL_TSIF0_B,
		/* SEL_7 (HSPI2) [1] */
		FN_SEL_HSPI2_A,		FN_SEL_HSPI2_B,
		/* SEL_6 (HSPI1) [1] */
		FN_SEL_HSPI1_A,		FN_SEL_HSPI1_B,
		/* SEL_5 (HSPI0) [1] */
		FN_SEL_HSPI0_A,		FN_SEL_HSPI0_B,
		/* SEL_4_3 (I2C3) [2] */
		FN_SEL_I2C3_A,		FN_SEL_I2C3_B,
		FN_SEL_I2C3_C,		0,
		/* SEL_2_1 (I2C2) [2] */
		FN_SEL_I2C2_A,		FN_SEL_I2C2_B,
		FN_SEL_I2C2_C,		0,
		/* SEL_0 (I2C1) [1] */
		FN_SEL_I2C1_A,		FN_SEL_I2C1_B,
		))
	},
	{ },
};

static const struct pinmux_bias_reg pinmux_bias_regs[] = {
	{ PINMUX_BIAS_REG("PUPR0", 0xfffc0100, "N/A", 0) {
		[ 0] = RCAR_GP_PIN(0,  6),	/* A0 */
		[ 1] = RCAR_GP_PIN(0,  7),	/* A1 */
		[ 2] = RCAR_GP_PIN(0,  8),	/* A2 */
		[ 3] = RCAR_GP_PIN(0,  9),	/* A3 */
		[ 4] = RCAR_GP_PIN(0, 10),	/* A4 */
		[ 5] = RCAR_GP_PIN(0, 11),	/* A5 */
		[ 6] = RCAR_GP_PIN(0, 12),	/* A6 */
		[ 7] = RCAR_GP_PIN(0, 13),	/* A7 */
		[ 8] = RCAR_GP_PIN(0, 14),	/* A8 */
		[ 9] = RCAR_GP_PIN(0, 15),	/* A9 */
		[10] = RCAR_GP_PIN(0, 16),	/* A10 */
		[11] = RCAR_GP_PIN(0, 17),	/* A11 */
		[12] = RCAR_GP_PIN(0, 18),	/* A12 */
		[13] = RCAR_GP_PIN(0, 19),	/* A13 */
		[14] = RCAR_GP_PIN(0, 20),	/* A14 */
		[15] = RCAR_GP_PIN(0, 21),	/* A15 */
		[16] = RCAR_GP_PIN(0, 22),	/* A16 */
		[17] = RCAR_GP_PIN(0, 23),	/* A17 */
		[18] = RCAR_GP_PIN(0, 24),	/* A18 */
		[19] = RCAR_GP_PIN(0, 25),	/* A19 */
		[20] = RCAR_GP_PIN(0, 26),	/* A20 */
		[21] = RCAR_GP_PIN(0, 27),	/* A21 */
		[22] = RCAR_GP_PIN(0, 28),	/* A22 */
		[23] = RCAR_GP_PIN(0, 29),	/* A23 */
		[24] = RCAR_GP_PIN(0, 30),	/* A24 */
		[25] = RCAR_GP_PIN(0, 31),	/* A25 */
		[26] = RCAR_GP_PIN(1,  3),	/* /EX_CS0 */
		[27] = RCAR_GP_PIN(1,  4),	/* /EX_CS1 */
		[28] = RCAR_GP_PIN(1,  5),	/* /EX_CS2 */
		[29] = RCAR_GP_PIN(1,  6),	/* /EX_CS3 */
		[30] = RCAR_GP_PIN(1,  7),	/* /EX_CS4 */
		[31] = RCAR_GP_PIN(1,  8),	/* /EX_CS5 */
	} },
	{ PINMUX_BIAS_REG("PUPR1", 0xfffc0104, "N/A", 0) {
		[ 0] = RCAR_GP_PIN(0,  0),	/* /PRESETOUT	*/
		[ 1] = RCAR_GP_PIN(0,  5),	/* /BS		*/
		[ 2] = RCAR_GP_PIN(1,  0),	/* RD//WR	*/
		[ 3] = RCAR_GP_PIN(1,  1),	/* /WE0		*/
		[ 4] = RCAR_GP_PIN(1,  2),	/* /WE1		*/
		[ 5] = RCAR_GP_PIN(1, 11),	/* EX_WAIT0	*/
		[ 6] = RCAR_GP_PIN(1,  9),	/* DREQ0	*/
		[ 7] = RCAR_GP_PIN(1, 10),	/* DACK0	*/
		[ 8] = RCAR_GP_PIN(1, 12),	/* IRQ0		*/
		[ 9] = RCAR_GP_PIN(1, 13),	/* IRQ1		*/
		[10] = SH_PFC_PIN_NONE,
		[11] = SH_PFC_PIN_NONE,
		[12] = SH_PFC_PIN_NONE,
		[13] = SH_PFC_PIN_NONE,
		[14] = SH_PFC_PIN_NONE,
		[15] = SH_PFC_PIN_NONE,
		[16] = SH_PFC_PIN_NONE,
		[17] = SH_PFC_PIN_NONE,
		[18] = SH_PFC_PIN_NONE,
		[19] = SH_PFC_PIN_NONE,
		[20] = SH_PFC_PIN_NONE,
		[21] = SH_PFC_PIN_NONE,
		[22] = SH_PFC_PIN_NONE,
		[23] = SH_PFC_PIN_NONE,
		[24] = SH_PFC_PIN_NONE,
		[25] = SH_PFC_PIN_NONE,
		[26] = SH_PFC_PIN_NONE,
		[27] = SH_PFC_PIN_NONE,
		[28] = SH_PFC_PIN_NONE,
		[29] = SH_PFC_PIN_NONE,
		[30] = SH_PFC_PIN_NONE,
		[31] = SH_PFC_PIN_NONE,
	} },
	{ PINMUX_BIAS_REG("PUPR2", 0xfffc0108, "N/A", 0) {
		[ 0] = RCAR_GP_PIN(1, 22),	/* DU0_DR0	*/
		[ 1] = RCAR_GP_PIN(1, 23),	/* DU0_DR1	*/
		[ 2] = RCAR_GP_PIN(1, 24),	/* DU0_DR2	*/
		[ 3] = RCAR_GP_PIN(1, 25),	/* DU0_DR3	*/
		[ 4] = RCAR_GP_PIN(1, 26),	/* DU0_DR4	*/
		[ 5] = RCAR_GP_PIN(1, 27),	/* DU0_DR5	*/
		[ 6] = RCAR_GP_PIN(1, 28),	/* DU0_DR6	*/
		[ 7] = RCAR_GP_PIN(1, 29),	/* DU0_DR7	*/
		[ 8] = RCAR_GP_PIN(1, 30),	/* DU0_DG0	*/
		[ 9] = RCAR_GP_PIN(1, 31),	/* DU0_DG1	*/
		[10] = RCAR_GP_PIN(2,  0),	/* DU0_DG2	*/
		[11] = RCAR_GP_PIN(2,  1),	/* DU0_DG3	*/
		[12] = RCAR_GP_PIN(2,  2),	/* DU0_DG4	*/
		[13] = RCAR_GP_PIN(2,  3),	/* DU0_DG5	*/
		[14] = RCAR_GP_PIN(2,  4),	/* DU0_DG6	*/
		[15] = RCAR_GP_PIN(2,  5),	/* DU0_DG7	*/
		[16] = RCAR_GP_PIN(2,  6),	/* DU0_DB0	*/
		[17] = RCAR_GP_PIN(2,  7),	/* DU0_DB1	*/
		[18] = RCAR_GP_PIN(2,  8),	/* DU0_DB2	*/
		[19] = RCAR_GP_PIN(2,  9),	/* DU0_DB3	*/
		[20] = RCAR_GP_PIN(2, 10),	/* DU0_DB4	*/
		[21] = RCAR_GP_PIN(2, 11),	/* DU0_DB5	*/
		[22] = RCAR_GP_PIN(2, 12),	/* DU0_DB6	*/
		[23] = RCAR_GP_PIN(2, 13),	/* DU0_DB7	*/
		[24] = RCAR_GP_PIN(2, 14),	/* DU0_DOTCLKIN	*/
		[25] = RCAR_GP_PIN(2, 15),	/* DU0_DOTCLKOUT0 */
		[26] = RCAR_GP_PIN(2, 17),	/* DU0_HSYNC	*/
		[27] = RCAR_GP_PIN(2, 18),	/* DU0_VSYNC	*/
		[28] = RCAR_GP_PIN(2, 19),	/* DU0_EXODDF	*/
		[29] = RCAR_GP_PIN(2, 20),	/* DU0_DISP	*/
		[30] = RCAR_GP_PIN(2, 21),	/* DU0_CDE	*/
		[31] = RCAR_GP_PIN(2, 16),	/* DU0_DOTCLKOUT1 */
	} },
	{ PINMUX_BIAS_REG("PUPR3", 0xfffc010c, "N/A", 0) {
		[ 0] = RCAR_GP_PIN(3, 24),	/* VI0_CLK	*/
		[ 1] = RCAR_GP_PIN(3, 25),	/* VI0_CLKENB	*/
		[ 2] = RCAR_GP_PIN(3, 26),	/* VI0_FIELD	*/
		[ 3] = RCAR_GP_PIN(3, 27),	/* /VI0_HSYNC	*/
		[ 4] = RCAR_GP_PIN(3, 28),	/* /VI0_VSYNC	*/
		[ 5] = RCAR_GP_PIN(3, 29),	/* VI0_DATA0	*/
		[ 6] = RCAR_GP_PIN(3, 30),	/* VI0_DATA1	*/
		[ 7] = RCAR_GP_PIN(3, 31),	/* VI0_DATA2	*/
		[ 8] = RCAR_GP_PIN(4,  0),	/* VI0_DATA3	*/
		[ 9] = RCAR_GP_PIN(4,  1),	/* VI0_DATA4	*/
		[10] = RCAR_GP_PIN(4,  2),	/* VI0_DATA5	*/
		[11] = RCAR_GP_PIN(4,  3),	/* VI0_DATA6	*/
		[12] = RCAR_GP_PIN(4,  4),	/* VI0_DATA7	*/
		[13] = RCAR_GP_PIN(4,  5),	/* VI0_G2	*/
		[14] = RCAR_GP_PIN(4,  6),	/* VI0_G3	*/
		[15] = RCAR_GP_PIN(4,  7),	/* VI0_G4	*/
		[16] = RCAR_GP_PIN(4,  8),	/* VI0_G5	*/
		[17] = RCAR_GP_PIN(4, 21),	/* VI1_DATA12	*/
		[18] = RCAR_GP_PIN(4, 22),	/* VI1_DATA13	*/
		[19] = RCAR_GP_PIN(4, 23),	/* VI1_DATA14	*/
		[20] = RCAR_GP_PIN(4, 24),	/* VI1_DATA15	*/
		[21] = RCAR_GP_PIN(4,  9),	/* ETH_REF_CLK	*/
		[22] = RCAR_GP_PIN(4, 10),	/* ETH_TXD0	*/
		[23] = RCAR_GP_PIN(4, 11),	/* ETH_TXD1	*/
		[24] = RCAR_GP_PIN(4, 12),	/* ETH_CRS_DV	*/
		[25] = RCAR_GP_PIN(4, 13),	/* ETH_TX_EN	*/
		[26] = RCAR_GP_PIN(4, 14),	/* ETH_RX_ER	*/
		[27] = RCAR_GP_PIN(4, 15),	/* ETH_RXD0	*/
		[28] = RCAR_GP_PIN(4, 16),	/* ETH_RXD1	*/
		[29] = RCAR_GP_PIN(4, 17),	/* ETH_MDC	*/
		[30] = RCAR_GP_PIN(4, 18),	/* ETH_MDIO	*/
		[31] = RCAR_GP_PIN(4, 19),	/* ETH_LINK	*/
	} },
	{ PINMUX_BIAS_REG("PUPR4", 0xfffc0110, "N/A", 0) {
		[ 0] = RCAR_GP_PIN(3,  6),	/* SSI_SCK012	*/
		[ 1] = RCAR_GP_PIN(3,  7),	/* SSI_WS012	*/
		[ 2] = RCAR_GP_PIN(3, 10),	/* SSI_SDATA0	*/
		[ 3] = RCAR_GP_PIN(3,  9),	/* SSI_SDATA1	*/
		[ 4] = RCAR_GP_PIN(3,  8),	/* SSI_SDATA2	*/
		[ 5] = RCAR_GP_PIN(3,  2),	/* SSI_SCK34	*/
		[ 6] = RCAR_GP_PIN(3,  3),	/* SSI_WS34	*/
		[ 7] = RCAR_GP_PIN(3,  5),	/* SSI_SDATA3	*/
		[ 8] = RCAR_GP_PIN(3,  4),	/* SSI_SDATA4	*/
		[ 9] = RCAR_GP_PIN(2, 31),	/* SSI_SCK5	*/
		[10] = RCAR_GP_PIN(3,  0),	/* SSI_WS5	*/
		[11] = RCAR_GP_PIN(3,  1),	/* SSI_SDATA5	*/
		[12] = RCAR_GP_PIN(2, 28),	/* SSI_SCK6	*/
		[13] = RCAR_GP_PIN(2, 29),	/* SSI_WS6	*/
		[14] = RCAR_GP_PIN(2, 30),	/* SSI_SDATA6	*/
		[15] = RCAR_GP_PIN(2, 24),	/* SSI_SCK78	*/
		[16] = RCAR_GP_PIN(2, 25),	/* SSI_WS78	*/
		[17] = RCAR_GP_PIN(2, 27),	/* SSI_SDATA7	*/
		[18] = RCAR_GP_PIN(2, 26),	/* SSI_SDATA8	*/
		[19] = RCAR_GP_PIN(3, 23),	/* TCLK0	*/
		[20] = RCAR_GP_PIN(3, 11),	/* SD0_CLK	*/
		[21] = RCAR_GP_PIN(3, 12),	/* SD0_CMD	*/
		[22] = RCAR_GP_PIN(3, 13),	/* SD0_DAT0	*/
		[23] = RCAR_GP_PIN(3, 14),	/* SD0_DAT1	*/
		[24] = RCAR_GP_PIN(3, 15),	/* SD0_DAT2	*/
		[25] = RCAR_GP_PIN(3, 16),	/* SD0_DAT3	*/
		[26] = RCAR_GP_PIN(3, 17),	/* SD0_CD	*/
		[27] = RCAR_GP_PIN(3, 18),	/* SD0_WP	*/
		[28] = RCAR_GP_PIN(2, 22),	/* AUDIO_CLKA	*/
		[29] = RCAR_GP_PIN(2, 23),	/* AUDIO_CLKB	*/
		[30] = RCAR_GP_PIN(1, 14),	/* IRQ2		*/
		[31] = RCAR_GP_PIN(1, 15),	/* IRQ3		*/
	} },
	{ PINMUX_BIAS_REG("PUPR5", 0xfffc0114, "N/A", 0) {
		[ 0] = RCAR_GP_PIN(0,  1),	/* PENC0	*/
		[ 1] = RCAR_GP_PIN(0,  2),	/* PENC1	*/
		[ 2] = RCAR_GP_PIN(0,  3),	/* USB_OVC0	*/
		[ 3] = RCAR_GP_PIN(0,  4),	/* USB_OVC1	*/
		[ 4] = RCAR_GP_PIN(1, 16),	/* SCIF_CLK	*/
		[ 5] = RCAR_GP_PIN(1, 17),	/* TX0		*/
		[ 6] = RCAR_GP_PIN(1, 18),	/* RX0		*/
		[ 7] = RCAR_GP_PIN(1, 19),	/* SCK0		*/
		[ 8] = RCAR_GP_PIN(1, 20),	/* /CTS0	*/
		[ 9] = RCAR_GP_PIN(1, 21),	/* /RTS0	*/
		[10] = RCAR_GP_PIN(3, 19),	/* HSPI_CLK0	*/
		[11] = RCAR_GP_PIN(3, 20),	/* /HSPI_CS0	*/
		[12] = RCAR_GP_PIN(3, 21),	/* HSPI_RX0	*/
		[13] = RCAR_GP_PIN(3, 22),	/* HSPI_TX0	*/
		[14] = RCAR_GP_PIN(4, 20),	/* ETH_MAGIC	*/
		[15] = RCAR_GP_PIN(4, 25),	/* AVS1		*/
		[16] = RCAR_GP_PIN(4, 26),	/* AVS2		*/
		[17] = SH_PFC_PIN_NONE,
		[18] = SH_PFC_PIN_NONE,
		[19] = SH_PFC_PIN_NONE,
		[20] = SH_PFC_PIN_NONE,
		[21] = SH_PFC_PIN_NONE,
		[22] = SH_PFC_PIN_NONE,
		[23] = SH_PFC_PIN_NONE,
		[24] = SH_PFC_PIN_NONE,
		[25] = SH_PFC_PIN_NONE,
		[26] = SH_PFC_PIN_NONE,
		[27] = SH_PFC_PIN_NONE,
		[28] = SH_PFC_PIN_NONE,
		[29] = SH_PFC_PIN_NONE,
		[30] = SH_PFC_PIN_NONE,
		[31] = SH_PFC_PIN_NONE,
	} },
	{ /* sentinel */ },
};

static const struct sh_pfc_soc_operations r8a7778_pfc_ops = {
	.get_bias = rcar_pinmux_get_bias,
	.set_bias = rcar_pinmux_set_bias,
};

const struct sh_pfc_soc_info r8a7778_pinmux_info = {
	.name = "r8a7778_pfc",
	.ops  = &r8a7778_pfc_ops,

	.unlock_reg = 0xfffc0000, /* PMMR */

	.function = { PINMUX_FUNCTION_BEGIN, PINMUX_FUNCTION_END },

	.pins = pinmux_pins,
	.nr_pins = ARRAY_SIZE(pinmux_pins),

	.groups = pinmux_groups,
	.nr_groups = ARRAY_SIZE(pinmux_groups),

	.functions = pinmux_functions,
	.nr_functions = ARRAY_SIZE(pinmux_functions),

	.cfg_regs = pinmux_config_regs,
	.bias_regs = pinmux_bias_regs,

	.pinmux_data = pinmux_data,
	.pinmux_data_size = ARRAY_SIZE(pinmux_data),
};
