/*
 * Copyright 2019 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 */
#ifndef __RENOIR_PPT_H__
#define __RENOIR_PPT_H__

extern void renoir_set_ppt_funcs(struct smu_context *smu);

/* UMD PState Renoir Msg Parameters in MHz */
#define RENOIR_UMD_PSTATE_GFXCLK       700
#define RENOIR_UMD_PSTATE_SOCCLK       678
#define RENOIR_UMD_PSTATE_FCLK         800

#define GET_DPM_CUR_FREQ(table, clk_type, dpm_level, freq)		\
	do {								\
		switch (clk_type) {					\
		case SMU_SOCCLK:					\
			freq = table->SocClocks[dpm_level].Freq;	\
			break;						\
		case SMU_MCLK:						\
			freq = table->MemClocks[dpm_level].Freq;	\
			break;						\
		case SMU_DCEFCLK:					\
			freq = table->DcfClocks[dpm_level].Freq;	\
			break;						\
		case SMU_FCLK:						\
			freq = table->FClocks[dpm_level].Freq;		\
			break;						\
		default:						\
			break;						\
		}							\
	} while (0)

#endif
