/* SPDX-License-Identifier: GPL-2.0-only
 * Copyright (c) 2023-2024 Qualcomm Innovation Center, Inc. All rights reserved.
 */

#ifndef _WCD937X_REGISTERS_H
#define _WCD937X_REGISTERS_H

#include <linux/soundwire/sdw.h>
#include <linux/soundwire/sdw_type.h>

#define WCD937X_BASE_ADDRESS			0x3000
#define WCD937X_ANA_BIAS			0x3001
#define WCD937X_ANA_RX_SUPPLIES			0x3008
#define WCD937X_ANA_HPH				0x3009
#define WCD937X_ANA_EAR				0x300A
#define WCD937X_ANA_EAR_COMPANDER_CTL		0x300B
#define WCD937X_EAR_GAIN_MASK			GENMASK(6, 2)
#define WCD937X_ANA_TX_CH1			0x300E
#define WCD937X_ANA_TX_CH2			0x300F
#define WCD937X_ANA_TX_CH3			0x3010
#define WCD937X_ANA_TX_CH3_HPF			0x3011
#define WCD937X_ANA_MICB1_MICB2_DSP_EN_LOGIC	0x3012
#define WCD937X_ANA_MICB3_DSP_EN_LOGIC		0x3013
#define WCD937X_ANA_MBHC_MECH			0x3014
#define WCD937X_MBHC_L_DET_EN_MASK		BIT(7)
#define WCD937X_MBHC_L_DET_EN			BIT(7)
#define WCD937X_MBHC_GND_DET_EN_MASK		BIT(6)
#define WCD937X_MBHC_MECH_DETECT_TYPE_MASK	BIT(5)
#define WCD937X_MBHC_MECH_DETECT_TYPE_INS	1
#define WCD937X_MBHC_HPHL_PLUG_TYPE_MASK	BIT(4)
#define WCD937X_MBHC_HPHL_PLUG_TYPE_NO		1
#define WCD937X_MBHC_GND_PLUG_TYPE_MASK		BIT(3)
#define WCD937X_MBHC_GND_PLUG_TYPE_NO		1
#define WCD937X_MBHC_HSL_PULLUP_COMP_EN		BIT(2)
#define WCD937X_MBHC_HSG_PULLUP_COMP_EN		BIT(1)
#define WCD937X_MBHC_HPHL_100K_TO_GND_EN	BIT(0)
#define WCD937X_ANA_MBHC_ELECT			0x3015
#define WCD937X_ANA_MBHC_BD_ISRC_CTL_MASK	GENMASK(6, 4)
#define WCD937X_ANA_MBHC_BD_ISRC_100UA		GENMASK(5, 4)
#define WCD937X_ANA_MBHC_BD_ISRC_OFF		0
#define WCD937X_ANA_MBHC_BIAS_EN_MASK		BIT(0)
#define WCD937X_ANA_MBHC_BIAS_EN		BIT(0)
#define WCD937X_ANA_MBHC_ZDET			0x3016
#define WCD937X_ANA_MBHC_RESULT_1		0x3017
#define WCD937X_ANA_MBHC_RESULT_2		0x3018
#define WCD937X_ANA_MBHC_RESULT_3		0x3019
#define WCD937X_MBHC_BTN_RESULT_MASK		GENMASK(2, 0)
#define WCD937X_ANA_MBHC_BTN0			0x301A
#define WCD937X_MBHC_BTN_VTH_MASK		GENMASK(7, 2)
#define WCD937X_ANA_MBHC_BTN1			0x301B
#define WCD937X_ANA_MBHC_BTN2			0x301C
#define WCD937X_ANA_MBHC_BTN3			0x301D
#define WCD937X_ANA_MBHC_BTN4			0x301E
#define WCD937X_ANA_MBHC_BTN5			0x301F
#define WCD937X_VTH_MASK			GENMASK(7, 2)
#define WCD937X_ANA_MBHC_BTN6			0x3020
#define WCD937X_ANA_MBHC_BTN7			0x3021
#define WCD937X_ANA_MICB1			0x3022
#define WCD937X_MICB_VOUT_MASK			GENMASK(5, 0)
#define WCD937X_MICB_EN_MASK			GENMASK(7, 6)
#define WCD937X_MICB_DISABLE			0
#define WCD937X_MICB_ENABLE			1
#define WCD937X_MICB_PULL_UP			2
#define WCD937X_MICB_PULL_DOWN			3
#define WCD937X_ANA_MICB2			0x3023
#define WCD937X_ANA_MICB2_ENABLE		BIT(6)
#define WCD937X_ANA_MICB2_ENABLE_MASK		GENMASK(7, 6)
#define WCD937X_ANA_MICB2_VOUT_MASK		GENMASK(5, 0)
#define WCD937X_ANA_MICB2_RAMP			0x3024
#define WCD937X_RAMP_EN_MASK			BIT(7)
#define WCD937X_RAMP_SHIFT_CTRL_MASK		GENMASK(4, 2)
#define WCD937X_ANA_MICB3			0x3025
#define WCD937X_ANA_MICB_EN			GENMASK(7, 6)
#define WCD937X_MICB_DISABLE			0
#define WCD937X_MICB_ENABLE			1
#define WCD937X_MICB_PULL_UP			2
#define WCD937X_ANA_MICB_VOUT			GENMASK(5, 0)
#define WCD937X_BIAS_CTL			0x3028
#define WCD937X_BIAS_VBG_FINE_ADJ		0x3029
#define WCD937X_LDOL_VDDCX_ADJUST		0x3040
#define WCD937X_LDOL_DISABLE_LDOL		0x3041
#define WCD937X_MBHC_CTL_CLK			0x3056
#define WCD937X_MBHC_CTL_ANA			0x3057
#define WCD937X_MBHC_CTL_SPARE_1		0x3058
#define WCD937X_MBHC_CTL_SPARE_2		0x3059
#define WCD937X_MBHC_CTL_BCS			0x305A
#define WCD937X_MBHC_MOISTURE_DET_FSM_STATUS	0x305B
#define WCD937X_MBHC_TEST_CTL			0x305C
#define WCD937X_LDOH_MODE			0x3067
#define WCD937X_LDOH_BIAS			0x3068
#define WCD937X_LDOH_STB_LOADS			0x3069
#define WCD937X_LDOH_SLOWRAMP			0x306A
#define WCD937X_MICB1_TEST_CTL_1		0x306B
#define WCD937X_MICB1_TEST_CTL_2		0x306C
#define WCD937X_MICB1_TEST_CTL_3		0x306D
#define WCD937X_MICB2_TEST_CTL_1		0x306E
#define WCD937X_MICB2_TEST_CTL_2		0x306F
#define WCD937X_MICB2_TEST_CTL_3		0x3070
#define WCD937X_MICB3_TEST_CTL_1		0x3071
#define WCD937X_MICB3_TEST_CTL_2		0x3072
#define WCD937X_MICB3_TEST_CTL_3		0x3073
#define WCD937X_TX_COM_ADC_VCM			0x3077
#define WCD937X_TX_COM_BIAS_ATEST		0x3078
#define WCD937X_TX_COM_ADC_INT1_IB		0x3079
#define WCD937X_TX_COM_ADC_INT2_IB		0x307A
#define WCD937X_TX_COM_TXFE_DIV_CTL		0x307B
#define WCD937X_TX_COM_TXFE_DIV_START		0x307C
#define WCD937X_TX_COM_TXFE_DIV_STOP_9P6M	0x307D
#define WCD937X_TX_COM_TXFE_DIV_STOP_12P288M	0x307E
#define WCD937X_TX_1_2_TEST_EN			0x307F
#define WCD937X_TX_1_2_ADC_IB			0x3080
#define WCD937X_TX_1_2_ATEST_REFCTL		0x3081
#define WCD937X_TX_1_2_TEST_CTL			0x3082
#define WCD937X_TX_1_2_TEST_BLK_EN		0x3083
#define WCD937X_TX_1_2_TXFE_CLKDIV		0x3084
#define WCD937X_TX_1_2_SAR2_ERR			0x3085
#define WCD937X_TX_1_2_SAR1_ERR			0x3086
#define WCD937X_TX_3_TEST_EN			0x3087
#define WCD937X_TX_3_ADC_IB			0x3088
#define WCD937X_TX_3_ATEST_REFCTL		0x3089
#define WCD937X_TX_3_TEST_CTL			0x308A
#define WCD937X_TX_3_TEST_BLK_EN		0x308B
#define WCD937X_TX_3_TXFE_CLKDIV		0x308C
#define WCD937X_TX_3_SPARE_MONO			0x308D
#define WCD937X_TX_3_SAR1_ERR			0x308E
#define WCD937X_CLASSH_MODE_1			0x3097
#define WCD937X_CLASSH_MODE_2			0x3098
#define WCD937X_CLASSH_MODE_3			0x3099
#define WCD937X_CLASSH_CTRL_VCL_1		0x309A
#define WCD937X_CLASSH_CTRL_VCL_2		0x309B
#define WCD937X_CLASSH_CTRL_CCL_1		0x309C
#define WCD937X_CLASSH_CTRL_CCL_2		0x309D
#define WCD937X_CLASSH_CTRL_CCL_3		0x309E
#define WCD937X_CLASSH_CTRL_CCL_4		0x309F
#define WCD937X_CLASSH_CTRL_CCL_5		0x30A0
#define WCD937X_CLASSH_BUCK_TMUX_A_D		0x30A1
#define WCD937X_CLASSH_BUCK_SW_DRV_CNTL		0x30A2
#define WCD937X_CLASSH_SPARE			0x30A3
#define WCD937X_FLYBACK_EN			0x30A4
#define WCD937X_FLYBACK_VNEG_CTRL_1		0x30A5
#define WCD937X_FLYBACK_VNEG_CTRL_2		0x30A6
#define WCD937X_FLYBACK_VNEG_CTRL_3		0x30A7
#define WCD937X_FLYBACK_VNEG_CTRL_4		0x30A8
#define WCD937X_FLYBACK_VNEG_CTRL_5		0x30A9
#define WCD937X_FLYBACK_VNEG_CTRL_6		0x30AA
#define WCD937X_FLYBACK_VNEG_CTRL_7		0x30AB
#define WCD937X_FLYBACK_VNEG_CTRL_8		0x30AC
#define WCD937X_FLYBACK_VNEG_CTRL_9		0x30AD
#define WCD937X_FLYBACK_VNEGDAC_CTRL_1		0x30AE
#define WCD937X_FLYBACK_VNEGDAC_CTRL_2		0x30AF
#define WCD937X_FLYBACK_VNEGDAC_CTRL_3		0x30B0
#define WCD937X_FLYBACK_CTRL_1			0x30B1
#define WCD937X_FLYBACK_TEST_CTL		0x30B2
#define WCD937X_RX_AUX_SW_CTL			0x30B3
#define WCD937X_RX_PA_AUX_IN_CONN		0x30B4
#define WCD937X_RX_TIMER_DIV			0x30B5
#define WCD937X_RX_OCP_CTL			0x30B6
#define WCD937X_RX_OCP_COUNT			0x30B7
#define WCD937X_RX_BIAS_EAR_DAC			0x30B8
#define WCD937X_RX_BIAS_EAR_AMP			0x30B9
#define WCD937X_RX_BIAS_HPH_LDO			0x30BA
#define WCD937X_RX_BIAS_HPH_PA			0x30BB
#define WCD937X_RX_BIAS_HPH_RDACBUFF_CNP2	0x30BC
#define WCD937X_RX_BIAS_HPH_RDAC_LDO		0x30BD
#define WCD937X_RX_BIAS_HPH_CNP1		0x30BE
#define WCD937X_RX_BIAS_HPH_LOWPOWER		0x30BF
#define WCD937X_RX_BIAS_AUX_DAC			0x30C0
#define WCD937X_RX_BIAS_AUX_AMP			0x30C1
#define WCD937X_RX_BIAS_VNEGDAC_BLEEDER		0x30C2
#define WCD937X_RX_BIAS_MISC			0x30C3
#define WCD937X_RX_BIAS_BUCK_RST		0x30C4
#define WCD937X_RX_BIAS_BUCK_VREF_ERRAMP	0x30C5
#define WCD937X_RX_BIAS_FLYB_ERRAMP		0x30C6
#define WCD937X_RX_BIAS_FLYB_BUFF		0x30C7
#define WCD937X_RX_BIAS_FLYB_MID_RST		0x30C8
#define WCD937X_HPH_L_STATUS			0x30C9
#define WCD937X_HPH_R_STATUS			0x30CA
#define WCD937X_HPH_CNP_EN			0x30CB
#define WCD937X_HPH_CNP_WG_CTL			0x30CC
#define WCD937X_HPH_CNP_WG_TIME			0x30CD
#define WCD937X_HPH_OCP_CTL			0x30CE
#define WCD937X_HPH_AUTO_CHOP			0x30CF
#define WCD937X_HPH_CHOP_CTL			0x30D0
#define WCD937X_HPH_PA_CTL1			0x30D1
#define WCD937X_HPH_PA_CTL2			0x30D2
#define WCD937X_HPHPA_GND_R_MASK		BIT(6)
#define WCD937X_HPHPA_GND_L_MASK		BIT(4)
#define WCD937X_HPH_L_EN			0x30D3
#define WCD937X_HPH_L_TEST			0x30D4
#define WCD937X_HPH_L_ATEST			0x30D5
#define WCD937X_HPH_R_EN			0x30D6
#define WCD937X_GAIN_SRC_SEL_MASK		BIT(5)
#define WCD937X_GAIN_SRC_SEL_REGISTER		1
#define WCD937X_HPH_R_TEST			0x30D7
#define WCD937X_HPH_R_ATEST			0x30D8
#define WCD937X_HPH_RDAC_CLK_CTL1		0x30D9
#define WCD937X_HPHPA_GND_OVR_MASK		BIT(1)
#define WCD937X_CHOP_CLK_EN_MASK		BIT(7)
#define WCD937X_HPH_RDAC_CLK_CTL2		0x30DA
#define WCD937X_HPH_RDAC_LDO_CTL		0x30DB
#define WCD937X_HPH_RDAC_CHOP_CLK_LP_CTL	0x30DC
#define WCD937X_HPH_REFBUFF_UHQA_CTL		0x30DD
#define WCD937X_HPH_REFBUFF_LP_CTL		0x30DE
#define WCD937X_PREREF_FLIT_BYPASS_MASK		BIT(0)
#define WCD937X_HPH_L_DAC_CTL			0x30DF
#define WCD937X_HPH_R_DAC_CTL			0x30E0
#define WCD937X_HPH_SURGE_HPHLR_SURGE_COMP_SEL	0x30E1
#define WCD937X_HPH_SURGE_HPHLR_SURGE_EN	0x30E2
#define WCD937X_HPH_SURGE_HPHLR_SURGE_MISC1	0x30E3
#define WCD937X_HPH_SURGE_HPHLR_SURGE_STATUS	0x30E4
#define WCD937X_EAR_EAR_EN_REG			0x30E9
#define WCD937X_EAR_EAR_PA_CON			0x30EA
#define WCD937X_EAR_EAR_SP_CON			0x30EB
#define WCD937X_EAR_EAR_DAC_CON			0x30EC
#define WCD937X_EAR_EAR_CNP_FSM_CON		0x30ED
#define WCD937X_EAR_TEST_CTL			0x30EE
#define WCD937X_EAR_STATUS_REG_1		0x30EF
#define WCD937X_EAR_STATUS_REG_2		0x30F0
#define WCD937X_ANA_NEW_PAGE_REGISTER		0x3100
#define WCD937X_HPH_NEW_ANA_HPH2		0x3101
#define WCD937X_HPH_NEW_ANA_HPH3		0x3102
#define WCD937X_SLEEP_CTL			0x3103
#define WCD937X_SLEEP_WATCHDOG_CTL		0x3104
#define WCD937X_MBHC_NEW_ELECT_REM_CLAMP_CTL	0x311F
#define WCD937X_MBHC_NEW_CTL_1			0x3120
#define WCD937X_MBHC_CTL_RCO_EN_MASK		BIT(7)
#define WCD937X_MBHC_CTL_RCO_EN			BIT(7)
#define WCD937X_MBHC_BTN_DBNC_MASK		GENMASK(1, 0)
#define WCD937X_MBHC_BTN_DBNC_T_16_MS		0x2
#define WCD937X_MBHC_NEW_CTL_2			0x3121
#define WCD937X_MBHC_NEW_PLUG_DETECT_CTL	0x3122
#define WCD937X_MBHC_NEW_ZDET_ANA_CTL		0x3123
#define WCD937X_M_RTH_CTL_MASK			GENMASK(3, 2)
#define WCD937X_MBHC_HS_VREF_CTL_MASK		GENMASK(1, 0)
#define WCD937X_MBHC_HS_VREF_1P5_V		0x1
#define WCD937X_MBHC_DBNC_TIMER_INSREM_DBNC_T_96_MS	0x6
#define WCD937X_ZDET_RANGE_CTL_MASK		GENMASK(3, 0)
#define WCD937X_ZDET_MAXV_CTL_MASK		GENMASK(6, 4)
#define WCD937X_MBHC_NEW_ZDET_RAMP_CTL		0x3124
#define WCD937X_MBHC_NEW_FSM_STATUS		0x3125
#define WCD937X_MBHC_NEW_ADC_RESULT		0x3126
#define WCD937X_TX_NEW_TX_CH2_SEL		0x3127
#define WCD937X_AUX_AUXPA			0x3128
#define WCD937X_AUXPA_CLK_EN_MASK		BIT(4)
#define WCD937X_AUXPA_CLK_EN_MASK		BIT(4)
#define WCD937X_LDORXTX_MODE			0x3129
#define WCD937X_LDORXTX_CONFIG			0x312A
#define WCD937X_DIE_CRACK_DIE_CRK_DET_EN	0x312C
#define WCD937X_DIE_CRACK_DIE_CRK_DET_OUT	0x312D
#define WCD937X_HPH_NEW_INT_RDAC_GAIN_CTL	0x3132
#define WCD937X_HPH_NEW_INT_RDAC_HD2_CTL_L	0x3133
#define WCD937X_HPH_NEW_INT_RDAC_VREF_CTL	0x3134
#define WCD937X_HPH_NEW_INT_RDAC_OVERRIDE_CTL	0x3135
#define WCD937X_HPH_NEW_INT_RDAC_HD2_CTL_R	0x3136
#define WCD937X_HPH_NEW_INT_PA_MISC1		0x3137
#define WCD937X_HPH_NEW_INT_PA_MISC2		0x3138
#define WCD937X_HPH_NEW_INT_PA_RDAC_MISC	0x3139
#define WCD937X_HPH_NEW_INT_HPH_TIMER1		0x313A
#define WCD937X_HPH_NEW_INT_HPH_TIMER2		0x313B
#define WCD937X_HPH_NEW_INT_HPH_TIMER3		0x313C
#define WCD937X_HPH_NEW_INT_HPH_TIMER4		0x313D
#define WCD937X_HPH_NEW_INT_PA_RDAC_MISC2	0x313E
#define WCD937X_HPH_NEW_INT_PA_RDAC_MISC3	0x313F
#define WCD937X_RX_NEW_INT_HPH_RDAC_BIAS_LOHIFI	0x3145
#define WCD937X_RX_NEW_INT_HPH_RDAC_BIAS_ULP	0x3146
#define WCD937X_RX_NEW_INT_HPH_RDAC_LDO_LP	0x3147
#define WCD937X_MBHC_NEW_INT_MOISTURE_DET_DC_CTRL			0x31AF
#define WCD937X_MBHC_NEW_INT_MOISTURE_DET_POLLING_CTRL			0x31B0
#define WCD937X_MOISTURE_EN_POLLING_MASK	BIT(2)
#define WCD937X_HSDET_PULLUP_C_MASK		GENMASK(4, 0)
#define WCD937X_MBHC_NEW_INT_MECH_DET_CURRENT	0x31B1
#define WCD937X_MBHC_NEW_INT_SPARE_2		0x31B2
#define WCD937X_EAR_INT_NEW_EAR_CHOPPER_CON	0x31B7
#define WCD937X_EAR_INT_NEW_CNP_VCM_CON1	0x31B8
#define WCD937X_EAR_INT_NEW_CNP_VCM_CON2	0x31B9
#define WCD937X_EAR_INT_NEW_EAR_DYNAMIC_BIAS	0x31BA
#define WCD937X_AUX_INT_EN_REG			0x31BD
#define WCD937X_AUX_INT_PA_CTRL			0x31BE
#define WCD937X_AUX_INT_SP_CTRL			0x31BF
#define WCD937X_AUX_INT_DAC_CTRL		0x31C0
#define WCD937X_AUX_INT_CLK_CTRL		0x31C1
#define WCD937X_AUX_INT_TEST_CTRL		0x31C2
#define WCD937X_AUX_INT_STATUS_REG		0x31C3
#define WCD937X_AUX_INT_MISC			0x31C4
#define WCD937X_LDORXTX_INT_BIAS		0x31C5
#define WCD937X_LDORXTX_INT_STB_LOADS_DTEST	0x31C6
#define WCD937X_LDORXTX_INT_TEST0		0x31C7
#define WCD937X_LDORXTX_INT_STARTUP_TIMER	0x31C8
#define WCD937X_LDORXTX_INT_TEST1		0x31C9
#define WCD937X_LDORXTX_INT_STATUS		0x31CA
#define WCD937X_SLEEP_INT_WATCHDOG_CTL_1	0x31D0
#define WCD937X_SLEEP_INT_WATCHDOG_CTL_2	0x31D1
#define WCD937X_DIE_CRACK_INT_DIE_CRK_DET_INT1	0x31D3
#define WCD937X_DIE_CRACK_INT_DIE_CRK_DET_INT2	0x31D4
#define WCD937X_DIGITAL_PAGE_REGISTER		0x3400
#define WCD937X_DIGITAL_CHIP_ID0		0x3401
#define WCD937X_DIGITAL_CHIP_ID1		0x3402
#define WCD937X_DIGITAL_CHIP_ID2		0x3403
#define WCD937X_DIGITAL_CHIP_ID3		0x3404
#define WCD937X_DIGITAL_CDC_RST_CTL		0x3406
#define WCD937X_DIGITAL_TOP_CLK_CFG		0x3407
#define WCD937X_DIGITAL_CDC_ANA_CLK_CTL		0x3408
#define WCD937X_DIGITAL_CDC_DIG_CLK_CTL		0x3409
#define WCD937X_DIGITAL_SWR_RST_EN		0x340A
#define WCD937X_DIGITAL_CDC_PATH_MODE		0x340B
#define WCD937X_DIGITAL_CDC_RX_RST		0x340C
#define WCD937X_DIGITAL_CDC_RX0_CTL		0x340D
#define WCD937X_DIGITAL_CDC_RX1_CTL		0x340E
#define WCD937X_DIGITAL_CDC_RX2_CTL		0x340F
#define WCD937X_DIGITAL_DEM_BYPASS_DATA0	0x3410
#define WCD937X_DIGITAL_DEM_BYPASS_DATA1	0x3411
#define WCD937X_DIGITAL_DEM_BYPASS_DATA2	0x3412
#define WCD937X_DIGITAL_DEM_BYPASS_DATA3	0x3413
#define WCD937X_DIGITAL_CDC_COMP_CTL_0		0x3414
#define WCD937X_DIGITAL_CDC_RX_DELAY_CTL	0x3417
#define WCD937X_DIGITAL_CDC_HPH_DSM_A1_0	0x3418
#define WCD937X_DIGITAL_CDC_HPH_DSM_A1_1	0x3419
#define WCD937X_DIGITAL_CDC_HPH_DSM_A2_0	0x341A
#define WCD937X_DIGITAL_CDC_HPH_DSM_A2_1	0x341B
#define WCD937X_DIGITAL_CDC_HPH_DSM_A3_0	0x341C
#define WCD937X_DIGITAL_CDC_HPH_DSM_A3_1	0x341D
#define WCD937X_DIGITAL_CDC_HPH_DSM_A4_0	0x341E
#define WCD937X_DIGITAL_CDC_HPH_DSM_A4_1	0x341F
#define WCD937X_DIGITAL_CDC_HPH_DSM_A5_0	0x3420
#define WCD937X_DIGITAL_CDC_HPH_DSM_A5_1	0x3421
#define WCD937X_DIGITAL_CDC_HPH_DSM_A6_0	0x3422
#define WCD937X_DIGITAL_CDC_HPH_DSM_A7_0	0x3423
#define WCD937X_DIGITAL_CDC_HPH_DSM_C_0		0x3424
#define WCD937X_DIGITAL_CDC_HPH_DSM_C_1		0x3425
#define WCD937X_DIGITAL_CDC_HPH_DSM_C_2		0x3426
#define WCD937X_DIGITAL_CDC_HPH_DSM_C_3		0x3427
#define WCD937X_DIGITAL_CDC_HPH_DSM_R1		0x3428
#define WCD937X_DIGITAL_CDC_HPH_DSM_R2		0x3429
#define WCD937X_DIGITAL_CDC_HPH_DSM_R3		0x342A
#define WCD937X_DIGITAL_CDC_HPH_DSM_R4		0x342B
#define WCD937X_DIGITAL_CDC_HPH_DSM_R5		0x342C
#define WCD937X_DIGITAL_CDC_HPH_DSM_R6		0x342D
#define WCD937X_DIGITAL_CDC_HPH_DSM_R7		0x342E
#define WCD937X_DIGITAL_CDC_AUX_DSM_A1_0	0x342F
#define WCD937X_DIGITAL_CDC_AUX_DSM_A1_1	0x3430
#define WCD937X_DIGITAL_CDC_AUX_DSM_A2_0	0x3431
#define WCD937X_DIGITAL_CDC_AUX_DSM_A2_1	0x3432
#define WCD937X_DIGITAL_CDC_AUX_DSM_A3_0	0x3433
#define WCD937X_DIGITAL_CDC_AUX_DSM_A3_1	0x3434
#define WCD937X_DIGITAL_CDC_AUX_DSM_A4_0	0x3435
#define WCD937X_DIGITAL_CDC_AUX_DSM_A4_1	0x3436
#define WCD937X_DIGITAL_CDC_AUX_DSM_A5_0	0x3437
#define WCD937X_DIGITAL_CDC_AUX_DSM_A5_1	0x3438
#define WCD937X_DIGITAL_CDC_AUX_DSM_A6_0	0x3439
#define WCD937X_DIGITAL_CDC_AUX_DSM_A7_0	0x343A
#define WCD937X_DIGITAL_CDC_AUX_DSM_C_0		0x343B
#define WCD937X_DIGITAL_CDC_AUX_DSM_C_1		0x343C
#define WCD937X_DIGITAL_CDC_AUX_DSM_C_2		0x343D
#define WCD937X_DIGITAL_CDC_AUX_DSM_C_3		0x343E
#define WCD937X_DIGITAL_CDC_AUX_DSM_R1		0x343F
#define WCD937X_DIGITAL_CDC_AUX_DSM_R2		0x3440
#define WCD937X_DIGITAL_CDC_AUX_DSM_R3		0x3441
#define WCD937X_DIGITAL_CDC_AUX_DSM_R4		0x3442
#define WCD937X_DIGITAL_CDC_AUX_DSM_R5		0x3443
#define WCD937X_DIGITAL_CDC_AUX_DSM_R6		0x3444
#define WCD937X_DIGITAL_CDC_AUX_DSM_R7		0x3445
#define WCD937X_DIGITAL_CDC_HPH_GAIN_RX_0	0x3446
#define WCD937X_DIGITAL_CDC_HPH_GAIN_RX_1	0x3447
#define WCD937X_DIGITAL_CDC_HPH_GAIN_DSD_0	0x3448
#define WCD937X_DIGITAL_CDC_HPH_GAIN_DSD_1	0x3449
#define WCD937X_DIGITAL_CDC_HPH_GAIN_DSD_2	0x344A
#define WCD937X_DIGITAL_CDC_AUX_GAIN_DSD_0	0x344B
#define WCD937X_DIGITAL_CDC_AUX_GAIN_DSD_1	0x344C
#define WCD937X_DIGITAL_CDC_AUX_GAIN_DSD_2	0x344D
#define WCD937X_DIGITAL_CDC_HPH_GAIN_CTL	0x344E
#define WCD937X_DIGITAL_CDC_AUX_GAIN_CTL	0x344F
#define WCD937X_DIGITAL_CDC_EAR_PATH_CTL	0x3450
#define WCD937X_DIGITAL_CDC_SWR_CLH		0x3451
#define WCD937X_DIGITAL_SWR_CLH_BYP		0x3452
#define WCD937X_DIGITAL_CDC_TX0_CTL		0x3453
#define WCD937X_DIGITAL_CDC_TX1_CTL		0x3454
#define WCD937X_DIGITAL_CDC_TX2_CTL		0x3455
#define WCD937X_DIGITAL_CDC_TX_RST		0x3456
#define WCD937X_DIGITAL_CDC_REQ_CTL		0x3457
#define WCD937X_DIGITAL_CDC_AMIC_CTL		0x345A
#define WCD937X_DIGITAL_CDC_DMIC_CTL		0x345B
#define WCD937X_DIGITAL_CDC_DMIC1_CTL		0x345C
#define WCD937X_DIGITAL_CDC_DMIC2_CTL		0x345D
#define WCD937X_DIGITAL_CDC_DMIC3_CTL		0x345E
#define WCD937X_DIGITAL_EFUSE_CTL		0x345F
#define WCD937X_DIGITAL_EFUSE_PRG_CTL		0x3460
#define WCD937X_DIGITAL_EFUSE_TEST_CTL_0	0x3461
#define WCD937X_DIGITAL_EFUSE_TEST_CTL_1	0x3462
#define WCD937X_DIGITAL_EFUSE_T_DATA_0		0x3463
#define WCD937X_DIGITAL_EFUSE_T_DATA_1		0x3464
#define WCD937X_DIGITAL_PDM_WD_CTL0		0x3465
#define WCD937X_DIGITAL_PDM_WD_CTL1		0x3466
#define WCD937X_DIGITAL_PDM_WD_CTL2		0x3467
#define WCD937X_DIGITAL_INTR_MODE		0x346A
#define WCD937X_DIGITAL_INTR_MASK_0		0x346B
#define WCD937X_DIGITAL_INTR_MASK_1		0x346C
#define WCD937X_DIGITAL_INTR_MASK_2		0x346D
#define WCD937X_DIGITAL_INTR_STATUS_0		0x346E
#define WCD937X_DIGITAL_INTR_STATUS_1		0x346F
#define WCD937X_DIGITAL_INTR_STATUS_2		0x3470
#define WCD937X_DIGITAL_INTR_CLEAR_0		0x3471
#define WCD937X_DIGITAL_INTR_CLEAR_1		0x3472
#define WCD937X_DIGITAL_INTR_CLEAR_2		0x3473
#define WCD937X_DIGITAL_INTR_LEVEL_0		0x3474
#define WCD937X_DIGITAL_INTR_LEVEL_1		0x3475
#define WCD937X_DIGITAL_INTR_LEVEL_2		0x3476
#define WCD937X_DIGITAL_INTR_SET_0		0x3477
#define WCD937X_DIGITAL_INTR_SET_1		0x3478
#define WCD937X_DIGITAL_INTR_SET_2		0x3479
#define WCD937X_DIGITAL_INTR_TEST_0		0x347A
#define WCD937X_DIGITAL_INTR_TEST_1		0x347B
#define WCD937X_DIGITAL_INTR_TEST_2		0x347C
#define WCD937X_DIGITAL_CDC_CONN_RX0_CTL	0x347F
#define WCD937X_DIGITAL_CDC_CONN_RX1_CTL	0x3480
#define WCD937X_DIGITAL_CDC_CONN_RX2_CTL	0x3481
#define WCD937X_DIGITAL_CDC_CONN_TX_CTL		0x3482
#define WCD937X_DIGITAL_LOOP_BACK_MODE		0x3483
#define WCD937X_DIGITAL_SWR_DAC_TEST		0x3484
#define WCD937X_DIGITAL_SWR_HM_TEST_RX_0	0x3485
#define WCD937X_DIGITAL_SWR_HM_TEST_TX_0	0x3491
#define WCD937X_DIGITAL_SWR_HM_TEST_RX_1	0x3492
#define WCD937X_DIGITAL_SWR_HM_TEST_TX_1	0x3493
#define WCD937X_DIGITAL_SWR_HM_TEST		0x3494
#define WCD937X_DIGITAL_PAD_CTL_PDM_RX0		0x3495
#define WCD937X_DIGITAL_PAD_CTL_PDM_RX1		0x3496
#define WCD937X_DIGITAL_PAD_CTL_PDM_TX0		0x3497
#define WCD937X_DIGITAL_PAD_CTL_PDM_TX1		0x3498
#define WCD937X_DIGITAL_PAD_INP_DIS_0		0x3499
#define WCD937X_DIGITAL_PAD_INP_DIS_1		0x349A
#define WCD937X_DIGITAL_DRIVE_STRENGTH_0	0x349B
#define WCD937X_DIGITAL_DRIVE_STRENGTH_1	0x349C
#define WCD937X_DIGITAL_DRIVE_STRENGTH_2	0x349D
#define WCD937X_DIGITAL_RX_DATA_EDGE_CTL	0x349E
#define WCD937X_DIGITAL_TX_DATA_EDGE_CTL	0x349F
#define WCD937X_DIGITAL_GPIO_MODE		0x34A0
#define WCD937X_DIGITAL_PIN_CTL_OE		0x34A1
#define WCD937X_DIGITAL_PIN_CTL_DATA_0		0x34A2
#define WCD937X_DIGITAL_PIN_CTL_DATA_1		0x34A3
#define WCD937X_DIGITAL_PIN_STATUS_0		0x34A4
#define WCD937X_DIGITAL_PIN_STATUS_1		0x34A5
#define WCD937X_DIGITAL_DIG_DEBUG_CTL		0x34A6
#define WCD937X_DIGITAL_DIG_DEBUG_EN		0x34A7
#define WCD937X_DIGITAL_ANA_CSR_DBG_ADD		0x34A8
#define WCD937X_DIGITAL_ANA_CSR_DBG_CTL		0x34A9
#define WCD937X_DIGITAL_SSP_DBG			0x34AA
#define WCD937X_DIGITAL_MODE_STATUS_0		0x34AB
#define WCD937X_DIGITAL_MODE_STATUS_1		0x34AC
#define WCD937X_DIGITAL_SPARE_0			0x34AD
#define WCD937X_DIGITAL_SPARE_1			0x34AE
#define WCD937X_DIGITAL_SPARE_2			0x34AF
#define WCD937X_DIGITAL_EFUSE_REG_0		0x34B0
#define WCD937X_DIGITAL_EFUSE_REG_1		0x34B1
#define WCD937X_DIGITAL_EFUSE_REG_2		0x34B2
#define WCD937X_DIGITAL_EFUSE_REG_3		0x34B3
#define WCD937X_DIGITAL_EFUSE_REG_4		0x34B4
#define WCD937X_DIGITAL_EFUSE_REG_5		0x34B5
#define WCD937X_DIGITAL_EFUSE_REG_6		0x34B6
#define WCD937X_DIGITAL_EFUSE_REG_7		0x34B7
#define WCD937X_DIGITAL_EFUSE_REG_8		0x34B8
#define WCD937X_DIGITAL_EFUSE_REG_9		0x34B9
#define WCD937X_DIGITAL_EFUSE_REG_10		0x34BA
#define WCD937X_DIGITAL_EFUSE_REG_11		0x34BB
#define WCD937X_DIGITAL_EFUSE_REG_12		0x34BC
#define WCD937X_DIGITAL_EFUSE_REG_13		0x34BD
#define WCD937X_DIGITAL_EFUSE_REG_14		0x34BE
#define WCD937X_DIGITAL_EFUSE_REG_15		0x34BF
#define WCD937X_DIGITAL_EFUSE_REG_16		0x34C0
#define WCD937X_DIGITAL_EFUSE_REG_17		0x34C1
#define WCD937X_DIGITAL_EFUSE_REG_18		0x34C2
#define WCD937X_DIGITAL_EFUSE_REG_19		0x34C3
#define WCD937X_DIGITAL_EFUSE_REG_20		0x34C4
#define WCD937X_DIGITAL_EFUSE_REG_21		0x34C5
#define WCD937X_DIGITAL_EFUSE_REG_22		0x34C6
#define WCD937X_DIGITAL_EFUSE_REG_23		0x34C7
#define WCD937X_DIGITAL_EFUSE_REG_24		0x34C8
#define WCD937X_DIGITAL_EFUSE_REG_25		0x34C9
#define WCD937X_DIGITAL_EFUSE_REG_26		0x34CA
#define WCD937X_DIGITAL_EFUSE_REG_27		0x34CB
#define WCD937X_DIGITAL_EFUSE_REG_28		0x34CC
#define WCD937X_DIGITAL_EFUSE_REG_29		0x34CD
#define WCD937X_DIGITAL_EFUSE_REG_30		0x34CE
#define WCD937X_DIGITAL_EFUSE_REG_31		0x34CF
#define WCD937X_MAX_REGISTER			(WCD937X_DIGITAL_EFUSE_REG_31)

#define WCD937X_MAX_MICBIAS			3
#define WCD937X_MAX_BULK_SUPPLY			4
#define WCD937X_MAX_TX_SWR_PORTS		4
#define WCD937X_MAX_SWR_PORTS			5
#define WCD937X_MAX_SWR_CH_IDS			15

struct wcd937x_sdw_ch_info {
	int port_num;
	unsigned int ch_mask;
};

#define WCD_SDW_CH(id, pn, cmask)	\
	[id] = {			\
		.port_num = pn,		\
		.ch_mask = cmask,	\
	}

struct wcd937x_priv;
struct wcd937x_sdw_priv {
	struct sdw_slave *sdev;
	struct sdw_stream_config sconfig;
	struct sdw_stream_runtime *sruntime;
	struct sdw_port_config port_config[WCD937X_MAX_SWR_PORTS];
	const struct wcd937x_sdw_ch_info *ch_info;
	bool port_enable[WCD937X_MAX_SWR_CH_IDS];
	int active_ports;
	bool is_tx;
	struct wcd937x_priv *wcd937x;
	struct irq_domain *slave_irq;
	struct regmap *regmap;
};

#if IS_ENABLED(CONFIG_SND_SOC_WCD937X_SDW)
int wcd937x_sdw_free(struct wcd937x_sdw_priv *wcd,
		     struct snd_pcm_substream *substream,
		     struct snd_soc_dai *dai);
int wcd937x_sdw_set_sdw_stream(struct wcd937x_sdw_priv *wcd,
			       struct snd_soc_dai *dai,
			       void *stream, int direction);
int wcd937x_sdw_hw_params(struct wcd937x_sdw_priv *wcd,
			  struct snd_pcm_substream *substream,
			  struct snd_pcm_hw_params *params,
			  struct snd_soc_dai *dai);

struct device *wcd937x_sdw_device_get(struct device_node *np);

#else
int wcd937x_sdw_free(struct wcd937x_sdw_priv *wcd,
		     struct snd_pcm_substream *substream,
		     struct snd_soc_dai *dai)
{
	return -EOPNOTSUPP;
}

int wcd937x_sdw_set_sdw_stream(struct wcd937x_sdw_priv *wcd,
			       struct snd_soc_dai *dai,
			       void *stream, int direction)
{
	return -EOPNOTSUPP;
}

int wcd937x_sdw_hw_params(struct wcd937x_sdw_priv *wcd,
			  struct snd_pcm_substream *substream,
			  struct snd_pcm_hw_params *params,
			  struct snd_soc_dai *dai)
{
	return -EOPNOTSUPP;
}
#endif

enum {
	/* INTR_CTRL_INT_MASK_0 */
	WCD937X_IRQ_MBHC_BUTTON_PRESS_DET = 0,
	WCD937X_IRQ_MBHC_BUTTON_RELEASE_DET,
	WCD937X_IRQ_MBHC_ELECT_INS_REM_DET,
	WCD937X_IRQ_MBHC_ELECT_INS_REM_LEG_DET,
	WCD937X_IRQ_MBHC_SW_DET,
	WCD937X_IRQ_HPHR_OCP_INT,
	WCD937X_IRQ_HPHR_CNP_INT,
	WCD937X_IRQ_HPHL_OCP_INT,

	/* INTR_CTRL_INT_MASK_1 */
	WCD937X_IRQ_HPHL_CNP_INT,
	WCD937X_IRQ_EAR_CNP_INT,
	WCD937X_IRQ_EAR_SCD_INT,
	WCD937X_IRQ_AUX_CNP_INT,
	WCD937X_IRQ_AUX_SCD_INT,
	WCD937X_IRQ_HPHL_PDM_WD_INT,
	WCD937X_IRQ_HPHR_PDM_WD_INT,
	WCD937X_IRQ_AUX_PDM_WD_INT,

	/* INTR_CTRL_INT_MASK_2 */
	WCD937X_IRQ_LDORT_SCD_INT,
	WCD937X_IRQ_MBHC_MOISTURE_INT,
	WCD937X_IRQ_HPHL_SURGE_DET_INT,
	WCD937X_IRQ_HPHR_SURGE_DET_INT,
	WCD937X_NUM_IRQS,
};

enum wcd937x_tx_sdw_ports {
	WCD937X_ADC_1_PORT = 1,
	WCD937X_ADC_2_3_PORT,
	WCD937X_DMIC_0_3_MBHC_PORT,
	WCD937X_DMIC_4_6_PORT,
};

enum wcd937x_tx_sdw_channels {
	WCD937X_ADC1,
	WCD937X_ADC2,
	WCD937X_ADC3,
	WCD937X_DMIC0,
	WCD937X_DMIC1,
	WCD937X_MBHC,
	WCD937X_DMIC2,
	WCD937X_DMIC3,
	WCD937X_DMIC4,
	WCD937X_DMIC5,
	WCD937X_DMIC6,
};

enum wcd937x_rx_sdw_ports {
	WCD937X_HPH_PORT = 1,
	WCD937X_CLSH_PORT,
	WCD937X_COMP_PORT,
	WCD937X_LO_PORT,
	WCD937X_DSD_PORT,
};

enum wcd937x_rx_sdw_channels {
	WCD937X_HPH_L,
	WCD937X_HPH_R,
	WCD937X_CLSH,
	WCD937X_COMP_L,
	WCD937X_COMP_R,
	WCD937X_LO,
	WCD937X_DSD_R,
	WCD937X_DSD_L,
};

#endif
