; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -mtriple=amdgcn-amd-amdhsa -S -atomic-expand %s | FileCheck %s
; RUN: opt -mtriple=r600-mesa-mesa3d -S -atomic-expand %s | FileCheck %s

define i32 @test_atomicrmw_nand_i32_flat(ptr %ptr, i32 %value) {
; CHECK-LABEL: @test_atomicrmw_nand_i32_flat(
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[PTR:%.*]], align 4
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP1]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; CHECK-NEXT:    [[TMP2:%.*]] = and i32 [[LOADED]], [[VALUE:%.*]]
; CHECK-NEXT:    [[NEW:%.*]] = xor i32 [[TMP2]], -1
; CHECK-NEXT:    [[TMP3:%.*]] = cmpxchg ptr [[PTR]], i32 [[LOADED]], i32 [[NEW]] seq_cst seq_cst
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP3]], 1
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP3]], 0
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret i32 [[NEWLOADED]]
;
  %res = atomicrmw nand ptr %ptr, i32 %value seq_cst
  ret i32 %res
}

define i32 @test_atomicrmw_nand_i32_global(ptr addrspace(1) %ptr, i32 %value) {
; CHECK-LABEL: @test_atomicrmw_nand_i32_global(
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr addrspace(1) [[PTR:%.*]], align 4
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP1]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; CHECK-NEXT:    [[TMP2:%.*]] = and i32 [[LOADED]], [[VALUE:%.*]]
; CHECK-NEXT:    [[NEW:%.*]] = xor i32 [[TMP2]], -1
; CHECK-NEXT:    [[TMP3:%.*]] = cmpxchg ptr addrspace(1) [[PTR]], i32 [[LOADED]], i32 [[NEW]] seq_cst seq_cst
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP3]], 1
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP3]], 0
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret i32 [[NEWLOADED]]
;
  %res = atomicrmw nand ptr addrspace(1) %ptr, i32 %value seq_cst
  ret i32 %res
}

define i32 @test_atomicrmw_nand_i32_local(ptr addrspace(3) %ptr, i32 %value) {
; CHECK-LABEL: @test_atomicrmw_nand_i32_local(
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr addrspace(3) [[PTR:%.*]], align 4
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP1]], [[TMP0:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ]
; CHECK-NEXT:    [[TMP2:%.*]] = and i32 [[LOADED]], [[VALUE:%.*]]
; CHECK-NEXT:    [[NEW:%.*]] = xor i32 [[TMP2]], -1
; CHECK-NEXT:    [[TMP3:%.*]] = cmpxchg ptr addrspace(3) [[PTR]], i32 [[LOADED]], i32 [[NEW]] seq_cst seq_cst
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP3]], 1
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP3]], 0
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret i32 [[NEWLOADED]]
;
  %res = atomicrmw nand ptr addrspace(3) %ptr, i32 %value seq_cst
  ret i32 %res
}
