; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown | FileCheck %s --check-prefix=X64 --check-prefix=SSE --check-prefix=SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse3 | FileCheck %s --check-prefix=X64 --check-prefix=SSE --check-prefix=SSE3
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+ssse3 | FileCheck %s --check-prefix=X64 --check-prefix=SSE --check-prefix=SSSE3
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.1 | FileCheck %s --check-prefix=X64 --check-prefix=SSE --check-prefix=SSE41
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefix=X64 --check-prefix=NOBW --check-prefix=AVX --check-prefix=AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefix=X64 --check-prefix=NOBW --check-prefix=AVX --check-prefix=AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vl | FileCheck %s --check-prefix=X64 --check-prefix=NOBW --check-prefix=AVX --check-prefix=AVX512VL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vl,+avx512bw,+avx512dq | FileCheck %s --check-prefix=X64 --check-prefix=AVX512VLBWDQ
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512dq,+avx512cd,+avx512vl | FileCheck %s --check-prefix=X64 --check-prefix=NOBW --check-prefix=AVX512 --check-prefix=AVX512VLCD
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512dq,+avx512cd | FileCheck %s --check-prefix=X64 --check-prefix=NOBW --check-prefix=AVX512 --check-prefix=AVX512CD
;
; Just one 32-bit run to make sure we do reasonable things for i64 lzcnt.
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+sse4.1 | FileCheck %s --check-prefix=X32-SSE

define <2 x i64> @testv2i64(<2 x i64> %in) nounwind {
; SSE2-LABEL: testv2i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrlq $1, %xmm1
; SSE2-NEXT:    por %xmm0, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    psrlq $2, %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrlq $4, %xmm1
; SSE2-NEXT:    por %xmm0, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    psrlq $8, %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrlq $16, %xmm1
; SSE2-NEXT:    por %xmm0, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    psrlq $32, %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    pxor %xmm0, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    psrlq $1, %xmm0
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE2-NEXT:    psubq %xmm0, %xmm1
; SSE2-NEXT:    movdqa {{.*#+}} xmm0 = [3689348814741910323,3689348814741910323]
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    pand %xmm0, %xmm2
; SSE2-NEXT:    psrlq $2, %xmm1
; SSE2-NEXT:    pand %xmm0, %xmm1
; SSE2-NEXT:    paddq %xmm2, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    psrlq $4, %xmm2
; SSE2-NEXT:    paddq %xmm1, %xmm2
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm2
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    psadbw %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE3-LABEL: testv2i64:
; SSE3:       # %bb.0:
; SSE3-NEXT:    movdqa %xmm0, %xmm1
; SSE3-NEXT:    psrlq $1, %xmm1
; SSE3-NEXT:    por %xmm0, %xmm1
; SSE3-NEXT:    movdqa %xmm1, %xmm0
; SSE3-NEXT:    psrlq $2, %xmm0
; SSE3-NEXT:    por %xmm1, %xmm0
; SSE3-NEXT:    movdqa %xmm0, %xmm1
; SSE3-NEXT:    psrlq $4, %xmm1
; SSE3-NEXT:    por %xmm0, %xmm1
; SSE3-NEXT:    movdqa %xmm1, %xmm0
; SSE3-NEXT:    psrlq $8, %xmm0
; SSE3-NEXT:    por %xmm1, %xmm0
; SSE3-NEXT:    movdqa %xmm0, %xmm1
; SSE3-NEXT:    psrlq $16, %xmm1
; SSE3-NEXT:    por %xmm0, %xmm1
; SSE3-NEXT:    movdqa %xmm1, %xmm0
; SSE3-NEXT:    psrlq $32, %xmm0
; SSE3-NEXT:    por %xmm1, %xmm0
; SSE3-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE3-NEXT:    pxor %xmm0, %xmm1
; SSE3-NEXT:    movdqa %xmm1, %xmm0
; SSE3-NEXT:    psrlq $1, %xmm0
; SSE3-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE3-NEXT:    psubq %xmm0, %xmm1
; SSE3-NEXT:    movdqa {{.*#+}} xmm0 = [3689348814741910323,3689348814741910323]
; SSE3-NEXT:    movdqa %xmm1, %xmm2
; SSE3-NEXT:    pand %xmm0, %xmm2
; SSE3-NEXT:    psrlq $2, %xmm1
; SSE3-NEXT:    pand %xmm0, %xmm1
; SSE3-NEXT:    paddq %xmm2, %xmm1
; SSE3-NEXT:    movdqa %xmm1, %xmm2
; SSE3-NEXT:    psrlq $4, %xmm2
; SSE3-NEXT:    paddq %xmm1, %xmm2
; SSE3-NEXT:    pand {{.*}}(%rip), %xmm2
; SSE3-NEXT:    pxor %xmm0, %xmm0
; SSE3-NEXT:    psadbw %xmm2, %xmm0
; SSE3-NEXT:    retq
;
; SSSE3-LABEL: testv2i64:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSSE3-NEXT:    movdqa %xmm0, %xmm1
; SSSE3-NEXT:    pand %xmm2, %xmm1
; SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; SSSE3-NEXT:    movdqa %xmm3, %xmm4
; SSSE3-NEXT:    pshufb %xmm1, %xmm4
; SSSE3-NEXT:    movdqa %xmm0, %xmm1
; SSSE3-NEXT:    psrlw $4, %xmm1
; SSSE3-NEXT:    pand %xmm2, %xmm1
; SSSE3-NEXT:    pxor %xmm2, %xmm2
; SSSE3-NEXT:    pshufb %xmm1, %xmm3
; SSSE3-NEXT:    pcmpeqb %xmm2, %xmm1
; SSSE3-NEXT:    pand %xmm4, %xmm1
; SSSE3-NEXT:    paddb %xmm3, %xmm1
; SSSE3-NEXT:    movdqa %xmm0, %xmm3
; SSSE3-NEXT:    pcmpeqb %xmm2, %xmm3
; SSSE3-NEXT:    psrlw $8, %xmm3
; SSSE3-NEXT:    pand %xmm1, %xmm3
; SSSE3-NEXT:    psrlw $8, %xmm1
; SSSE3-NEXT:    paddw %xmm3, %xmm1
; SSSE3-NEXT:    movdqa %xmm0, %xmm3
; SSSE3-NEXT:    pcmpeqw %xmm2, %xmm3
; SSSE3-NEXT:    psrld $16, %xmm3
; SSSE3-NEXT:    pand %xmm1, %xmm3
; SSSE3-NEXT:    psrld $16, %xmm1
; SSSE3-NEXT:    paddd %xmm3, %xmm1
; SSSE3-NEXT:    pcmpeqd %xmm2, %xmm0
; SSSE3-NEXT:    psrlq $32, %xmm0
; SSSE3-NEXT:    pand %xmm1, %xmm0
; SSSE3-NEXT:    psrlq $32, %xmm1
; SSSE3-NEXT:    paddq %xmm0, %xmm1
; SSSE3-NEXT:    movdqa %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: testv2i64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSE41-NEXT:    movdqa %xmm0, %xmm1
; SSE41-NEXT:    pand %xmm2, %xmm1
; SSE41-NEXT:    movdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; SSE41-NEXT:    movdqa %xmm3, %xmm4
; SSE41-NEXT:    pshufb %xmm1, %xmm4
; SSE41-NEXT:    movdqa %xmm0, %xmm1
; SSE41-NEXT:    psrlw $4, %xmm1
; SSE41-NEXT:    pand %xmm2, %xmm1
; SSE41-NEXT:    pxor %xmm2, %xmm2
; SSE41-NEXT:    pshufb %xmm1, %xmm3
; SSE41-NEXT:    pcmpeqb %xmm2, %xmm1
; SSE41-NEXT:    pand %xmm4, %xmm1
; SSE41-NEXT:    paddb %xmm3, %xmm1
; SSE41-NEXT:    movdqa %xmm0, %xmm3
; SSE41-NEXT:    pcmpeqb %xmm2, %xmm3
; SSE41-NEXT:    psrlw $8, %xmm3
; SSE41-NEXT:    pand %xmm1, %xmm3
; SSE41-NEXT:    psrlw $8, %xmm1
; SSE41-NEXT:    paddw %xmm3, %xmm1
; SSE41-NEXT:    movdqa %xmm0, %xmm3
; SSE41-NEXT:    pcmpeqw %xmm2, %xmm3
; SSE41-NEXT:    psrld $16, %xmm3
; SSE41-NEXT:    pand %xmm1, %xmm3
; SSE41-NEXT:    psrld $16, %xmm1
; SSE41-NEXT:    paddd %xmm3, %xmm1
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE41-NEXT:    psrlq $32, %xmm0
; SSE41-NEXT:    pand %xmm1, %xmm0
; SSE41-NEXT:    psrlq $32, %xmm1
; SSE41-NEXT:    paddq %xmm0, %xmm1
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: testv2i64:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovdqa {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX-NEXT:    vmovdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX-NEXT:    vpand %xmm1, %xmm4, %xmm1
; AVX-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX-NEXT:    vpcmpeqb %xmm4, %xmm1, %xmm5
; AVX-NEXT:    vpand %xmm5, %xmm2, %xmm2
; AVX-NEXT:    vpshufb %xmm1, %xmm3, %xmm1
; AVX-NEXT:    vpaddb %xmm1, %xmm2, %xmm1
; AVX-NEXT:    vpcmpeqb %xmm4, %xmm0, %xmm2
; AVX-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX-NEXT:    vpand %xmm2, %xmm1, %xmm2
; AVX-NEXT:    vpsrlw $8, %xmm1, %xmm1
; AVX-NEXT:    vpaddw %xmm2, %xmm1, %xmm1
; AVX-NEXT:    vpcmpeqw %xmm4, %xmm0, %xmm2
; AVX-NEXT:    vpsrld $16, %xmm2, %xmm2
; AVX-NEXT:    vpand %xmm2, %xmm1, %xmm2
; AVX-NEXT:    vpsrld $16, %xmm1, %xmm1
; AVX-NEXT:    vpaddd %xmm2, %xmm1, %xmm1
; AVX-NEXT:    vpcmpeqd %xmm4, %xmm0, %xmm0
; AVX-NEXT:    vpsrlq $32, %xmm0, %xmm0
; AVX-NEXT:    vpand %xmm0, %xmm1, %xmm0
; AVX-NEXT:    vpsrlq $32, %xmm1, %xmm1
; AVX-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
;
; AVX512VLBWDQ-LABEL: testv2i64:
; AVX512VLBWDQ:       # %bb.0:
; AVX512VLBWDQ-NEXT:    vmovdqa {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VLBWDQ-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX512VLBWDQ-NEXT:    vmovdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX512VLBWDQ-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX512VLBWDQ-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX512VLBWDQ-NEXT:    vpand %xmm1, %xmm4, %xmm1
; AVX512VLBWDQ-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512VLBWDQ-NEXT:    vpcmpeqb %xmm4, %xmm1, %xmm5
; AVX512VLBWDQ-NEXT:    vpand %xmm5, %xmm2, %xmm2
; AVX512VLBWDQ-NEXT:    vpshufb %xmm1, %xmm3, %xmm1
; AVX512VLBWDQ-NEXT:    vpaddb %xmm1, %xmm2, %xmm1
; AVX512VLBWDQ-NEXT:    vpcmpeqb %xmm4, %xmm0, %xmm2
; AVX512VLBWDQ-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX512VLBWDQ-NEXT:    vpand %xmm2, %xmm1, %xmm2
; AVX512VLBWDQ-NEXT:    vpsrlw $8, %xmm1, %xmm1
; AVX512VLBWDQ-NEXT:    vpaddw %xmm2, %xmm1, %xmm1
; AVX512VLBWDQ-NEXT:    vpcmpeqw %xmm4, %xmm0, %xmm2
; AVX512VLBWDQ-NEXT:    vpsrld $16, %xmm2, %xmm2
; AVX512VLBWDQ-NEXT:    vpand %xmm2, %xmm1, %xmm2
; AVX512VLBWDQ-NEXT:    vpsrld $16, %xmm1, %xmm1
; AVX512VLBWDQ-NEXT:    vpaddd %xmm2, %xmm1, %xmm1
; AVX512VLBWDQ-NEXT:    vpcmpeqd %xmm4, %xmm0, %xmm0
; AVX512VLBWDQ-NEXT:    vpsrlq $32, %xmm0, %xmm0
; AVX512VLBWDQ-NEXT:    vpand %xmm0, %xmm1, %xmm0
; AVX512VLBWDQ-NEXT:    vpsrlq $32, %xmm1, %xmm1
; AVX512VLBWDQ-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; AVX512VLBWDQ-NEXT:    retq
;
; AVX512VLCD-LABEL: testv2i64:
; AVX512VLCD:       # %bb.0:
; AVX512VLCD-NEXT:    vplzcntq %xmm0, %xmm0
; AVX512VLCD-NEXT:    retq
;
; AVX512CD-LABEL: testv2i64:
; AVX512CD:       # %bb.0:
; AVX512CD-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512CD-NEXT:    vplzcntq %zmm0, %zmm0
; AVX512CD-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512CD-NEXT:    vzeroupper
; AVX512CD-NEXT:    retq
;
; X32-SSE-LABEL: testv2i64:
; X32-SSE:       # %bb.0:
; X32-SSE-NEXT:    movdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; X32-SSE-NEXT:    movdqa %xmm0, %xmm1
; X32-SSE-NEXT:    pand %xmm2, %xmm1
; X32-SSE-NEXT:    movdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; X32-SSE-NEXT:    movdqa %xmm3, %xmm4
; X32-SSE-NEXT:    pshufb %xmm1, %xmm4
; X32-SSE-NEXT:    movdqa %xmm0, %xmm1
; X32-SSE-NEXT:    psrlw $4, %xmm1
; X32-SSE-NEXT:    pand %xmm2, %xmm1
; X32-SSE-NEXT:    pxor %xmm2, %xmm2
; X32-SSE-NEXT:    pshufb %xmm1, %xmm3
; X32-SSE-NEXT:    pcmpeqb %xmm2, %xmm1
; X32-SSE-NEXT:    pand %xmm4, %xmm1
; X32-SSE-NEXT:    paddb %xmm3, %xmm1
; X32-SSE-NEXT:    movdqa %xmm0, %xmm3
; X32-SSE-NEXT:    pcmpeqb %xmm2, %xmm3
; X32-SSE-NEXT:    psrlw $8, %xmm3
; X32-SSE-NEXT:    pand %xmm1, %xmm3
; X32-SSE-NEXT:    psrlw $8, %xmm1
; X32-SSE-NEXT:    paddw %xmm3, %xmm1
; X32-SSE-NEXT:    movdqa %xmm0, %xmm3
; X32-SSE-NEXT:    pcmpeqw %xmm2, %xmm3
; X32-SSE-NEXT:    psrld $16, %xmm3
; X32-SSE-NEXT:    pand %xmm1, %xmm3
; X32-SSE-NEXT:    psrld $16, %xmm1
; X32-SSE-NEXT:    paddd %xmm3, %xmm1
; X32-SSE-NEXT:    pcmpeqd %xmm2, %xmm0
; X32-SSE-NEXT:    psrlq $32, %xmm0
; X32-SSE-NEXT:    pand %xmm1, %xmm0
; X32-SSE-NEXT:    psrlq $32, %xmm1
; X32-SSE-NEXT:    paddq %xmm0, %xmm1
; X32-SSE-NEXT:    movdqa %xmm1, %xmm0
; X32-SSE-NEXT:    retl

  %out = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %in, i1 0)
  ret <2 x i64> %out
}

define <2 x i64> @testv2i64u(<2 x i64> %in) nounwind {
; SSE2-LABEL: testv2i64u:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrlq $1, %xmm1
; SSE2-NEXT:    por %xmm0, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    psrlq $2, %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrlq $4, %xmm1
; SSE2-NEXT:    por %xmm0, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    psrlq $8, %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrlq $16, %xmm1
; SSE2-NEXT:    por %xmm0, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    psrlq $32, %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    pxor %xmm0, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    psrlq $1, %xmm0
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE2-NEXT:    psubq %xmm0, %xmm1
; SSE2-NEXT:    movdqa {{.*#+}} xmm0 = [3689348814741910323,3689348814741910323]
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    pand %xmm0, %xmm2
; SSE2-NEXT:    psrlq $2, %xmm1
; SSE2-NEXT:    pand %xmm0, %xmm1
; SSE2-NEXT:    paddq %xmm2, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    psrlq $4, %xmm2
; SSE2-NEXT:    paddq %xmm1, %xmm2
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm2
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    psadbw %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE3-LABEL: testv2i64u:
; SSE3:       # %bb.0:
; SSE3-NEXT:    movdqa %xmm0, %xmm1
; SSE3-NEXT:    psrlq $1, %xmm1
; SSE3-NEXT:    por %xmm0, %xmm1
; SSE3-NEXT:    movdqa %xmm1, %xmm0
; SSE3-NEXT:    psrlq $2, %xmm0
; SSE3-NEXT:    por %xmm1, %xmm0
; SSE3-NEXT:    movdqa %xmm0, %xmm1
; SSE3-NEXT:    psrlq $4, %xmm1
; SSE3-NEXT:    por %xmm0, %xmm1
; SSE3-NEXT:    movdqa %xmm1, %xmm0
; SSE3-NEXT:    psrlq $8, %xmm0
; SSE3-NEXT:    por %xmm1, %xmm0
; SSE3-NEXT:    movdqa %xmm0, %xmm1
; SSE3-NEXT:    psrlq $16, %xmm1
; SSE3-NEXT:    por %xmm0, %xmm1
; SSE3-NEXT:    movdqa %xmm1, %xmm0
; SSE3-NEXT:    psrlq $32, %xmm0
; SSE3-NEXT:    por %xmm1, %xmm0
; SSE3-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE3-NEXT:    pxor %xmm0, %xmm1
; SSE3-NEXT:    movdqa %xmm1, %xmm0
; SSE3-NEXT:    psrlq $1, %xmm0
; SSE3-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE3-NEXT:    psubq %xmm0, %xmm1
; SSE3-NEXT:    movdqa {{.*#+}} xmm0 = [3689348814741910323,3689348814741910323]
; SSE3-NEXT:    movdqa %xmm1, %xmm2
; SSE3-NEXT:    pand %xmm0, %xmm2
; SSE3-NEXT:    psrlq $2, %xmm1
; SSE3-NEXT:    pand %xmm0, %xmm1
; SSE3-NEXT:    paddq %xmm2, %xmm1
; SSE3-NEXT:    movdqa %xmm1, %xmm2
; SSE3-NEXT:    psrlq $4, %xmm2
; SSE3-NEXT:    paddq %xmm1, %xmm2
; SSE3-NEXT:    pand {{.*}}(%rip), %xmm2
; SSE3-NEXT:    pxor %xmm0, %xmm0
; SSE3-NEXT:    psadbw %xmm2, %xmm0
; SSE3-NEXT:    retq
;
; SSSE3-LABEL: testv2i64u:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSSE3-NEXT:    movdqa %xmm0, %xmm1
; SSSE3-NEXT:    pand %xmm2, %xmm1
; SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; SSSE3-NEXT:    movdqa %xmm3, %xmm4
; SSSE3-NEXT:    pshufb %xmm1, %xmm4
; SSSE3-NEXT:    movdqa %xmm0, %xmm1
; SSSE3-NEXT:    psrlw $4, %xmm1
; SSSE3-NEXT:    pand %xmm2, %xmm1
; SSSE3-NEXT:    pxor %xmm2, %xmm2
; SSSE3-NEXT:    pshufb %xmm1, %xmm3
; SSSE3-NEXT:    pcmpeqb %xmm2, %xmm1
; SSSE3-NEXT:    pand %xmm4, %xmm1
; SSSE3-NEXT:    paddb %xmm3, %xmm1
; SSSE3-NEXT:    movdqa %xmm0, %xmm3
; SSSE3-NEXT:    pcmpeqb %xmm2, %xmm3
; SSSE3-NEXT:    psrlw $8, %xmm3
; SSSE3-NEXT:    pand %xmm1, %xmm3
; SSSE3-NEXT:    psrlw $8, %xmm1
; SSSE3-NEXT:    paddw %xmm3, %xmm1
; SSSE3-NEXT:    movdqa %xmm0, %xmm3
; SSSE3-NEXT:    pcmpeqw %xmm2, %xmm3
; SSSE3-NEXT:    psrld $16, %xmm3
; SSSE3-NEXT:    pand %xmm1, %xmm3
; SSSE3-NEXT:    psrld $16, %xmm1
; SSSE3-NEXT:    paddd %xmm3, %xmm1
; SSSE3-NEXT:    pcmpeqd %xmm2, %xmm0
; SSSE3-NEXT:    psrlq $32, %xmm0
; SSSE3-NEXT:    pand %xmm1, %xmm0
; SSSE3-NEXT:    psrlq $32, %xmm1
; SSSE3-NEXT:    paddq %xmm0, %xmm1
; SSSE3-NEXT:    movdqa %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: testv2i64u:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSE41-NEXT:    movdqa %xmm0, %xmm1
; SSE41-NEXT:    pand %xmm2, %xmm1
; SSE41-NEXT:    movdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; SSE41-NEXT:    movdqa %xmm3, %xmm4
; SSE41-NEXT:    pshufb %xmm1, %xmm4
; SSE41-NEXT:    movdqa %xmm0, %xmm1
; SSE41-NEXT:    psrlw $4, %xmm1
; SSE41-NEXT:    pand %xmm2, %xmm1
; SSE41-NEXT:    pxor %xmm2, %xmm2
; SSE41-NEXT:    pshufb %xmm1, %xmm3
; SSE41-NEXT:    pcmpeqb %xmm2, %xmm1
; SSE41-NEXT:    pand %xmm4, %xmm1
; SSE41-NEXT:    paddb %xmm3, %xmm1
; SSE41-NEXT:    movdqa %xmm0, %xmm3
; SSE41-NEXT:    pcmpeqb %xmm2, %xmm3
; SSE41-NEXT:    psrlw $8, %xmm3
; SSE41-NEXT:    pand %xmm1, %xmm3
; SSE41-NEXT:    psrlw $8, %xmm1
; SSE41-NEXT:    paddw %xmm3, %xmm1
; SSE41-NEXT:    movdqa %xmm0, %xmm3
; SSE41-NEXT:    pcmpeqw %xmm2, %xmm3
; SSE41-NEXT:    psrld $16, %xmm3
; SSE41-NEXT:    pand %xmm1, %xmm3
; SSE41-NEXT:    psrld $16, %xmm1
; SSE41-NEXT:    paddd %xmm3, %xmm1
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE41-NEXT:    psrlq $32, %xmm0
; SSE41-NEXT:    pand %xmm1, %xmm0
; SSE41-NEXT:    psrlq $32, %xmm1
; SSE41-NEXT:    paddq %xmm0, %xmm1
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: testv2i64u:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovdqa {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX-NEXT:    vmovdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX-NEXT:    vpand %xmm1, %xmm4, %xmm1
; AVX-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX-NEXT:    vpcmpeqb %xmm4, %xmm1, %xmm5
; AVX-NEXT:    vpand %xmm5, %xmm2, %xmm2
; AVX-NEXT:    vpshufb %xmm1, %xmm3, %xmm1
; AVX-NEXT:    vpaddb %xmm1, %xmm2, %xmm1
; AVX-NEXT:    vpcmpeqb %xmm4, %xmm0, %xmm2
; AVX-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX-NEXT:    vpand %xmm2, %xmm1, %xmm2
; AVX-NEXT:    vpsrlw $8, %xmm1, %xmm1
; AVX-NEXT:    vpaddw %xmm2, %xmm1, %xmm1
; AVX-NEXT:    vpcmpeqw %xmm4, %xmm0, %xmm2
; AVX-NEXT:    vpsrld $16, %xmm2, %xmm2
; AVX-NEXT:    vpand %xmm2, %xmm1, %xmm2
; AVX-NEXT:    vpsrld $16, %xmm1, %xmm1
; AVX-NEXT:    vpaddd %xmm2, %xmm1, %xmm1
; AVX-NEXT:    vpcmpeqd %xmm4, %xmm0, %xmm0
; AVX-NEXT:    vpsrlq $32, %xmm0, %xmm0
; AVX-NEXT:    vpand %xmm0, %xmm1, %xmm0
; AVX-NEXT:    vpsrlq $32, %xmm1, %xmm1
; AVX-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
;
; AVX512VLBWDQ-LABEL: testv2i64u:
; AVX512VLBWDQ:       # %bb.0:
; AVX512VLBWDQ-NEXT:    vmovdqa {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VLBWDQ-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX512VLBWDQ-NEXT:    vmovdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX512VLBWDQ-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX512VLBWDQ-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX512VLBWDQ-NEXT:    vpand %xmm1, %xmm4, %xmm1
; AVX512VLBWDQ-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512VLBWDQ-NEXT:    vpcmpeqb %xmm4, %xmm1, %xmm5
; AVX512VLBWDQ-NEXT:    vpand %xmm5, %xmm2, %xmm2
; AVX512VLBWDQ-NEXT:    vpshufb %xmm1, %xmm3, %xmm1
; AVX512VLBWDQ-NEXT:    vpaddb %xmm1, %xmm2, %xmm1
; AVX512VLBWDQ-NEXT:    vpcmpeqb %xmm4, %xmm0, %xmm2
; AVX512VLBWDQ-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX512VLBWDQ-NEXT:    vpand %xmm2, %xmm1, %xmm2
; AVX512VLBWDQ-NEXT:    vpsrlw $8, %xmm1, %xmm1
; AVX512VLBWDQ-NEXT:    vpaddw %xmm2, %xmm1, %xmm1
; AVX512VLBWDQ-NEXT:    vpcmpeqw %xmm4, %xmm0, %xmm2
; AVX512VLBWDQ-NEXT:    vpsrld $16, %xmm2, %xmm2
; AVX512VLBWDQ-NEXT:    vpand %xmm2, %xmm1, %xmm2
; AVX512VLBWDQ-NEXT:    vpsrld $16, %xmm1, %xmm1
; AVX512VLBWDQ-NEXT:    vpaddd %xmm2, %xmm1, %xmm1
; AVX512VLBWDQ-NEXT:    vpcmpeqd %xmm4, %xmm0, %xmm0
; AVX512VLBWDQ-NEXT:    vpsrlq $32, %xmm0, %xmm0
; AVX512VLBWDQ-NEXT:    vpand %xmm0, %xmm1, %xmm0
; AVX512VLBWDQ-NEXT:    vpsrlq $32, %xmm1, %xmm1
; AVX512VLBWDQ-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; AVX512VLBWDQ-NEXT:    retq
;
; AVX512VLCD-LABEL: testv2i64u:
; AVX512VLCD:       # %bb.0:
; AVX512VLCD-NEXT:    vplzcntq %xmm0, %xmm0
; AVX512VLCD-NEXT:    retq
;
; AVX512CD-LABEL: testv2i64u:
; AVX512CD:       # %bb.0:
; AVX512CD-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512CD-NEXT:    vplzcntq %zmm0, %zmm0
; AVX512CD-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512CD-NEXT:    vzeroupper
; AVX512CD-NEXT:    retq
;
; X32-SSE-LABEL: testv2i64u:
; X32-SSE:       # %bb.0:
; X32-SSE-NEXT:    movdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; X32-SSE-NEXT:    movdqa %xmm0, %xmm1
; X32-SSE-NEXT:    pand %xmm2, %xmm1
; X32-SSE-NEXT:    movdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; X32-SSE-NEXT:    movdqa %xmm3, %xmm4
; X32-SSE-NEXT:    pshufb %xmm1, %xmm4
; X32-SSE-NEXT:    movdqa %xmm0, %xmm1
; X32-SSE-NEXT:    psrlw $4, %xmm1
; X32-SSE-NEXT:    pand %xmm2, %xmm1
; X32-SSE-NEXT:    pxor %xmm2, %xmm2
; X32-SSE-NEXT:    pshufb %xmm1, %xmm3
; X32-SSE-NEXT:    pcmpeqb %xmm2, %xmm1
; X32-SSE-NEXT:    pand %xmm4, %xmm1
; X32-SSE-NEXT:    paddb %xmm3, %xmm1
; X32-SSE-NEXT:    movdqa %xmm0, %xmm3
; X32-SSE-NEXT:    pcmpeqb %xmm2, %xmm3
; X32-SSE-NEXT:    psrlw $8, %xmm3
; X32-SSE-NEXT:    pand %xmm1, %xmm3
; X32-SSE-NEXT:    psrlw $8, %xmm1
; X32-SSE-NEXT:    paddw %xmm3, %xmm1
; X32-SSE-NEXT:    movdqa %xmm0, %xmm3
; X32-SSE-NEXT:    pcmpeqw %xmm2, %xmm3
; X32-SSE-NEXT:    psrld $16, %xmm3
; X32-SSE-NEXT:    pand %xmm1, %xmm3
; X32-SSE-NEXT:    psrld $16, %xmm1
; X32-SSE-NEXT:    paddd %xmm3, %xmm1
; X32-SSE-NEXT:    pcmpeqd %xmm2, %xmm0
; X32-SSE-NEXT:    psrlq $32, %xmm0
; X32-SSE-NEXT:    pand %xmm1, %xmm0
; X32-SSE-NEXT:    psrlq $32, %xmm1
; X32-SSE-NEXT:    paddq %xmm0, %xmm1
; X32-SSE-NEXT:    movdqa %xmm1, %xmm0
; X32-SSE-NEXT:    retl

  %out = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %in, i1 -1)
  ret <2 x i64> %out
}

define <4 x i32> @testv4i32(<4 x i32> %in) nounwind {
; SSE2-LABEL: testv4i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrld $1, %xmm1
; SSE2-NEXT:    por %xmm0, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    psrld $2, %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrld $4, %xmm1
; SSE2-NEXT:    por %xmm0, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    psrld $8, %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrld $16, %xmm1
; SSE2-NEXT:    por %xmm0, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm0
; SSE2-NEXT:    psrld $1, %xmm0
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE2-NEXT:    psubd %xmm0, %xmm2
; SSE2-NEXT:    movdqa {{.*#+}} xmm0 = [858993459,858993459,858993459,858993459]
; SSE2-NEXT:    movdqa %xmm2, %xmm1
; SSE2-NEXT:    pand %xmm0, %xmm1
; SSE2-NEXT:    psrld $2, %xmm2
; SSE2-NEXT:    pand %xmm0, %xmm2
; SSE2-NEXT:    paddd %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm0
; SSE2-NEXT:    psrld $4, %xmm0
; SSE2-NEXT:    paddd %xmm2, %xmm0
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm2 = xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; SSE2-NEXT:    psadbw %xmm1, %xmm2
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    psadbw %xmm1, %xmm0
; SSE2-NEXT:    packuswb %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE3-LABEL: testv4i32:
; SSE3:       # %bb.0:
; SSE3-NEXT:    movdqa %xmm0, %xmm1
; SSE3-NEXT:    psrld $1, %xmm1
; SSE3-NEXT:    por %xmm0, %xmm1
; SSE3-NEXT:    movdqa %xmm1, %xmm0
; SSE3-NEXT:    psrld $2, %xmm0
; SSE3-NEXT:    por %xmm1, %xmm0
; SSE3-NEXT:    movdqa %xmm0, %xmm1
; SSE3-NEXT:    psrld $4, %xmm1
; SSE3-NEXT:    por %xmm0, %xmm1
; SSE3-NEXT:    movdqa %xmm1, %xmm0
; SSE3-NEXT:    psrld $8, %xmm0
; SSE3-NEXT:    por %xmm1, %xmm0
; SSE3-NEXT:    movdqa %xmm0, %xmm1
; SSE3-NEXT:    psrld $16, %xmm1
; SSE3-NEXT:    por %xmm0, %xmm1
; SSE3-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE3-NEXT:    pxor %xmm1, %xmm2
; SSE3-NEXT:    movdqa %xmm2, %xmm0
; SSE3-NEXT:    psrld $1, %xmm0
; SSE3-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE3-NEXT:    psubd %xmm0, %xmm2
; SSE3-NEXT:    movdqa {{.*#+}} xmm0 = [858993459,858993459,858993459,858993459]
; SSE3-NEXT:    movdqa %xmm2, %xmm1
; SSE3-NEXT:    pand %xmm0, %xmm1
; SSE3-NEXT:    psrld $2, %xmm2
; SSE3-NEXT:    pand %xmm0, %xmm2
; SSE3-NEXT:    paddd %xmm1, %xmm2
; SSE3-NEXT:    movdqa %xmm2, %xmm0
; SSE3-NEXT:    psrld $4, %xmm0
; SSE3-NEXT:    paddd %xmm2, %xmm0
; SSE3-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE3-NEXT:    pxor %xmm1, %xmm1
; SSE3-NEXT:    movdqa %xmm0, %xmm2
; SSE3-NEXT:    punpckhdq {{.*#+}} xmm2 = xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; SSE3-NEXT:    psadbw %xmm1, %xmm2
; SSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE3-NEXT:    psadbw %xmm1, %xmm0
; SSE3-NEXT:    packuswb %xmm2, %xmm0
; SSE3-NEXT:    retq
;
; SSSE3-LABEL: testv4i32:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSSE3-NEXT:    movdqa %xmm0, %xmm1
; SSSE3-NEXT:    pand %xmm2, %xmm1
; SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; SSSE3-NEXT:    movdqa %xmm3, %xmm4
; SSSE3-NEXT:    pshufb %xmm1, %xmm4
; SSSE3-NEXT:    movdqa %xmm0, %xmm1
; SSSE3-NEXT:    psrlw $4, %xmm1
; SSSE3-NEXT:    pand %xmm2, %xmm1
; SSSE3-NEXT:    pxor %xmm2, %xmm2
; SSSE3-NEXT:    pshufb %xmm1, %xmm3
; SSSE3-NEXT:    pcmpeqb %xmm2, %xmm1
; SSSE3-NEXT:    pand %xmm4, %xmm1
; SSSE3-NEXT:    paddb %xmm3, %xmm1
; SSSE3-NEXT:    movdqa %xmm0, %xmm3
; SSSE3-NEXT:    pcmpeqb %xmm2, %xmm3
; SSSE3-NEXT:    psrlw $8, %xmm3
; SSSE3-NEXT:    pand %xmm1, %xmm3
; SSSE3-NEXT:    psrlw $8, %xmm1
; SSSE3-NEXT:    paddw %xmm3, %xmm1
; SSSE3-NEXT:    pcmpeqw %xmm2, %xmm0
; SSSE3-NEXT:    psrld $16, %xmm0
; SSSE3-NEXT:    pand %xmm1, %xmm0
; SSSE3-NEXT:    psrld $16, %xmm1
; SSSE3-NEXT:    paddd %xmm0, %xmm1
; SSSE3-NEXT:    movdqa %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: testv4i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSE41-NEXT:    movdqa %xmm0, %xmm1
; SSE41-NEXT:    pand %xmm2, %xmm1
; SSE41-NEXT:    movdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; SSE41-NEXT:    movdqa %xmm3, %xmm4
; SSE41-NEXT:    pshufb %xmm1, %xmm4
; SSE41-NEXT:    movdqa %xmm0, %xmm1
; SSE41-NEXT:    psrlw $4, %xmm1
; SSE41-NEXT:    pand %xmm2, %xmm1
; SSE41-NEXT:    pxor %xmm2, %xmm2
; SSE41-NEXT:    pshufb %xmm1, %xmm3
; SSE41-NEXT:    pcmpeqb %xmm2, %xmm1
; SSE41-NEXT:    pand %xmm4, %xmm1
; SSE41-NEXT:    paddb %xmm3, %xmm1
; SSE41-NEXT:    movdqa %xmm0, %xmm3
; SSE41-NEXT:    pcmpeqb %xmm2, %xmm3
; SSE41-NEXT:    psrlw $8, %xmm3
; SSE41-NEXT:    pand %xmm1, %xmm3
; SSE41-NEXT:    psrlw $8, %xmm1
; SSE41-NEXT:    paddw %xmm3, %xmm1
; SSE41-NEXT:    pcmpeqw %xmm2, %xmm0
; SSE41-NEXT:    psrld $16, %xmm0
; SSE41-NEXT:    pand %xmm1, %xmm0
; SSE41-NEXT:    psrld $16, %xmm1
; SSE41-NEXT:    paddd %xmm0, %xmm1
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: testv4i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovdqa {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX-NEXT:    vmovdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX-NEXT:    vpand %xmm1, %xmm4, %xmm1
; AVX-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX-NEXT:    vpcmpeqb %xmm4, %xmm1, %xmm5
; AVX-NEXT:    vpand %xmm5, %xmm2, %xmm2
; AVX-NEXT:    vpshufb %xmm1, %xmm3, %xmm1
; AVX-NEXT:    vpaddb %xmm1, %xmm2, %xmm1
; AVX-NEXT:    vpcmpeqb %xmm4, %xmm0, %xmm2
; AVX-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX-NEXT:    vpand %xmm2, %xmm1, %xmm2
; AVX-NEXT:    vpsrlw $8, %xmm1, %xmm1
; AVX-NEXT:    vpaddw %xmm2, %xmm1, %xmm1
; AVX-NEXT:    vpcmpeqw %xmm4, %xmm0, %xmm0
; AVX-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX-NEXT:    vpand %xmm0, %xmm1, %xmm0
; AVX-NEXT:    vpsrld $16, %xmm1, %xmm1
; AVX-NEXT:    vpaddd %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
;
; AVX512VLBWDQ-LABEL: testv4i32:
; AVX512VLBWDQ:       # %bb.0:
; AVX512VLBWDQ-NEXT:    vmovdqa {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VLBWDQ-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX512VLBWDQ-NEXT:    vmovdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX512VLBWDQ-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX512VLBWDQ-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX512VLBWDQ-NEXT:    vpand %xmm1, %xmm4, %xmm1
; AVX512VLBWDQ-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512VLBWDQ-NEXT:    vpcmpeqb %xmm4, %xmm1, %xmm5
; AVX512VLBWDQ-NEXT:    vpand %xmm5, %xmm2, %xmm2
; AVX512VLBWDQ-NEXT:    vpshufb %xmm1, %xmm3, %xmm1
; AVX512VLBWDQ-NEXT:    vpaddb %xmm1, %xmm2, %xmm1
; AVX512VLBWDQ-NEXT:    vpcmpeqb %xmm4, %xmm0, %xmm2
; AVX512VLBWDQ-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX512VLBWDQ-NEXT:    vpand %xmm2, %xmm1, %xmm2
; AVX512VLBWDQ-NEXT:    vpsrlw $8, %xmm1, %xmm1
; AVX512VLBWDQ-NEXT:    vpaddw %xmm2, %xmm1, %xmm1
; AVX512VLBWDQ-NEXT:    vpcmpeqw %xmm4, %xmm0, %xmm0
; AVX512VLBWDQ-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX512VLBWDQ-NEXT:    vpand %xmm0, %xmm1, %xmm0
; AVX512VLBWDQ-NEXT:    vpsrld $16, %xmm1, %xmm1
; AVX512VLBWDQ-NEXT:    vpaddd %xmm0, %xmm1, %xmm0
; AVX512VLBWDQ-NEXT:    retq
;
; AVX512VLCD-LABEL: testv4i32:
; AVX512VLCD:       # %bb.0:
; AVX512VLCD-NEXT:    vplzcntd %xmm0, %xmm0
; AVX512VLCD-NEXT:    retq
;
; AVX512CD-LABEL: testv4i32:
; AVX512CD:       # %bb.0:
; AVX512CD-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512CD-NEXT:    vplzcntd %zmm0, %zmm0
; AVX512CD-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512CD-NEXT:    vzeroupper
; AVX512CD-NEXT:    retq
;
; X32-SSE-LABEL: testv4i32:
; X32-SSE:       # %bb.0:
; X32-SSE-NEXT:    movdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; X32-SSE-NEXT:    movdqa %xmm0, %xmm1
; X32-SSE-NEXT:    pand %xmm2, %xmm1
; X32-SSE-NEXT:    movdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; X32-SSE-NEXT:    movdqa %xmm3, %xmm4
; X32-SSE-NEXT:    pshufb %xmm1, %xmm4
; X32-SSE-NEXT:    movdqa %xmm0, %xmm1
; X32-SSE-NEXT:    psrlw $4, %xmm1
; X32-SSE-NEXT:    pand %xmm2, %xmm1
; X32-SSE-NEXT:    pxor %xmm2, %xmm2
; X32-SSE-NEXT:    pshufb %xmm1, %xmm3
; X32-SSE-NEXT:    pcmpeqb %xmm2, %xmm1
; X32-SSE-NEXT:    pand %xmm4, %xmm1
; X32-SSE-NEXT:    paddb %xmm3, %xmm1
; X32-SSE-NEXT:    movdqa %xmm0, %xmm3
; X32-SSE-NEXT:    pcmpeqb %xmm2, %xmm3
; X32-SSE-NEXT:    psrlw $8, %xmm3
; X32-SSE-NEXT:    pand %xmm1, %xmm3
; X32-SSE-NEXT:    psrlw $8, %xmm1
; X32-SSE-NEXT:    paddw %xmm3, %xmm1
; X32-SSE-NEXT:    pcmpeqw %xmm2, %xmm0
; X32-SSE-NEXT:    psrld $16, %xmm0
; X32-SSE-NEXT:    pand %xmm1, %xmm0
; X32-SSE-NEXT:    psrld $16, %xmm1
; X32-SSE-NEXT:    paddd %xmm0, %xmm1
; X32-SSE-NEXT:    movdqa %xmm1, %xmm0
; X32-SSE-NEXT:    retl

  %out = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %in, i1 0)
  ret <4 x i32> %out
}

define <4 x i32> @testv4i32u(<4 x i32> %in) nounwind {
; SSE2-LABEL: testv4i32u:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrld $1, %xmm1
; SSE2-NEXT:    por %xmm0, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    psrld $2, %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrld $4, %xmm1
; SSE2-NEXT:    por %xmm0, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    psrld $8, %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrld $16, %xmm1
; SSE2-NEXT:    por %xmm0, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE2-NEXT:    pxor %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm0
; SSE2-NEXT:    psrld $1, %xmm0
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE2-NEXT:    psubd %xmm0, %xmm2
; SSE2-NEXT:    movdqa {{.*#+}} xmm0 = [858993459,858993459,858993459,858993459]
; SSE2-NEXT:    movdqa %xmm2, %xmm1
; SSE2-NEXT:    pand %xmm0, %xmm1
; SSE2-NEXT:    psrld $2, %xmm2
; SSE2-NEXT:    pand %xmm0, %xmm2
; SSE2-NEXT:    paddd %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm0
; SSE2-NEXT:    psrld $4, %xmm0
; SSE2-NEXT:    paddd %xmm2, %xmm0
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    punpckhdq {{.*#+}} xmm2 = xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; SSE2-NEXT:    psadbw %xmm1, %xmm2
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    psadbw %xmm1, %xmm0
; SSE2-NEXT:    packuswb %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE3-LABEL: testv4i32u:
; SSE3:       # %bb.0:
; SSE3-NEXT:    movdqa %xmm0, %xmm1
; SSE3-NEXT:    psrld $1, %xmm1
; SSE3-NEXT:    por %xmm0, %xmm1
; SSE3-NEXT:    movdqa %xmm1, %xmm0
; SSE3-NEXT:    psrld $2, %xmm0
; SSE3-NEXT:    por %xmm1, %xmm0
; SSE3-NEXT:    movdqa %xmm0, %xmm1
; SSE3-NEXT:    psrld $4, %xmm1
; SSE3-NEXT:    por %xmm0, %xmm1
; SSE3-NEXT:    movdqa %xmm1, %xmm0
; SSE3-NEXT:    psrld $8, %xmm0
; SSE3-NEXT:    por %xmm1, %xmm0
; SSE3-NEXT:    movdqa %xmm0, %xmm1
; SSE3-NEXT:    psrld $16, %xmm1
; SSE3-NEXT:    por %xmm0, %xmm1
; SSE3-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE3-NEXT:    pxor %xmm1, %xmm2
; SSE3-NEXT:    movdqa %xmm2, %xmm0
; SSE3-NEXT:    psrld $1, %xmm0
; SSE3-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE3-NEXT:    psubd %xmm0, %xmm2
; SSE3-NEXT:    movdqa {{.*#+}} xmm0 = [858993459,858993459,858993459,858993459]
; SSE3-NEXT:    movdqa %xmm2, %xmm1
; SSE3-NEXT:    pand %xmm0, %xmm1
; SSE3-NEXT:    psrld $2, %xmm2
; SSE3-NEXT:    pand %xmm0, %xmm2
; SSE3-NEXT:    paddd %xmm1, %xmm2
; SSE3-NEXT:    movdqa %xmm2, %xmm0
; SSE3-NEXT:    psrld $4, %xmm0
; SSE3-NEXT:    paddd %xmm2, %xmm0
; SSE3-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE3-NEXT:    pxor %xmm1, %xmm1
; SSE3-NEXT:    movdqa %xmm0, %xmm2
; SSE3-NEXT:    punpckhdq {{.*#+}} xmm2 = xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; SSE3-NEXT:    psadbw %xmm1, %xmm2
; SSE3-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE3-NEXT:    psadbw %xmm1, %xmm0
; SSE3-NEXT:    packuswb %xmm2, %xmm0
; SSE3-NEXT:    retq
;
; SSSE3-LABEL: testv4i32u:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSSE3-NEXT:    movdqa %xmm0, %xmm1
; SSSE3-NEXT:    pand %xmm2, %xmm1
; SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; SSSE3-NEXT:    movdqa %xmm3, %xmm4
; SSSE3-NEXT:    pshufb %xmm1, %xmm4
; SSSE3-NEXT:    movdqa %xmm0, %xmm1
; SSSE3-NEXT:    psrlw $4, %xmm1
; SSSE3-NEXT:    pand %xmm2, %xmm1
; SSSE3-NEXT:    pxor %xmm2, %xmm2
; SSSE3-NEXT:    pshufb %xmm1, %xmm3
; SSSE3-NEXT:    pcmpeqb %xmm2, %xmm1
; SSSE3-NEXT:    pand %xmm4, %xmm1
; SSSE3-NEXT:    paddb %xmm3, %xmm1
; SSSE3-NEXT:    movdqa %xmm0, %xmm3
; SSSE3-NEXT:    pcmpeqb %xmm2, %xmm3
; SSSE3-NEXT:    psrlw $8, %xmm3
; SSSE3-NEXT:    pand %xmm1, %xmm3
; SSSE3-NEXT:    psrlw $8, %xmm1
; SSSE3-NEXT:    paddw %xmm3, %xmm1
; SSSE3-NEXT:    pcmpeqw %xmm2, %xmm0
; SSSE3-NEXT:    psrld $16, %xmm0
; SSSE3-NEXT:    pand %xmm1, %xmm0
; SSSE3-NEXT:    psrld $16, %xmm1
; SSSE3-NEXT:    paddd %xmm0, %xmm1
; SSSE3-NEXT:    movdqa %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: testv4i32u:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSE41-NEXT:    movdqa %xmm0, %xmm1
; SSE41-NEXT:    pand %xmm2, %xmm1
; SSE41-NEXT:    movdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; SSE41-NEXT:    movdqa %xmm3, %xmm4
; SSE41-NEXT:    pshufb %xmm1, %xmm4
; SSE41-NEXT:    movdqa %xmm0, %xmm1
; SSE41-NEXT:    psrlw $4, %xmm1
; SSE41-NEXT:    pand %xmm2, %xmm1
; SSE41-NEXT:    pxor %xmm2, %xmm2
; SSE41-NEXT:    pshufb %xmm1, %xmm3
; SSE41-NEXT:    pcmpeqb %xmm2, %xmm1
; SSE41-NEXT:    pand %xmm4, %xmm1
; SSE41-NEXT:    paddb %xmm3, %xmm1
; SSE41-NEXT:    movdqa %xmm0, %xmm3
; SSE41-NEXT:    pcmpeqb %xmm2, %xmm3
; SSE41-NEXT:    psrlw $8, %xmm3
; SSE41-NEXT:    pand %xmm1, %xmm3
; SSE41-NEXT:    psrlw $8, %xmm1
; SSE41-NEXT:    paddw %xmm3, %xmm1
; SSE41-NEXT:    pcmpeqw %xmm2, %xmm0
; SSE41-NEXT:    psrld $16, %xmm0
; SSE41-NEXT:    pand %xmm1, %xmm0
; SSE41-NEXT:    psrld $16, %xmm1
; SSE41-NEXT:    paddd %xmm0, %xmm1
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: testv4i32u:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovdqa {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX-NEXT:    vmovdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX-NEXT:    vpand %xmm1, %xmm4, %xmm1
; AVX-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX-NEXT:    vpcmpeqb %xmm4, %xmm1, %xmm5
; AVX-NEXT:    vpand %xmm5, %xmm2, %xmm2
; AVX-NEXT:    vpshufb %xmm1, %xmm3, %xmm1
; AVX-NEXT:    vpaddb %xmm1, %xmm2, %xmm1
; AVX-NEXT:    vpcmpeqb %xmm4, %xmm0, %xmm2
; AVX-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX-NEXT:    vpand %xmm2, %xmm1, %xmm2
; AVX-NEXT:    vpsrlw $8, %xmm1, %xmm1
; AVX-NEXT:    vpaddw %xmm2, %xmm1, %xmm1
; AVX-NEXT:    vpcmpeqw %xmm4, %xmm0, %xmm0
; AVX-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX-NEXT:    vpand %xmm0, %xmm1, %xmm0
; AVX-NEXT:    vpsrld $16, %xmm1, %xmm1
; AVX-NEXT:    vpaddd %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
;
; AVX512VLBWDQ-LABEL: testv4i32u:
; AVX512VLBWDQ:       # %bb.0:
; AVX512VLBWDQ-NEXT:    vmovdqa {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VLBWDQ-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX512VLBWDQ-NEXT:    vmovdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX512VLBWDQ-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX512VLBWDQ-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX512VLBWDQ-NEXT:    vpand %xmm1, %xmm4, %xmm1
; AVX512VLBWDQ-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512VLBWDQ-NEXT:    vpcmpeqb %xmm4, %xmm1, %xmm5
; AVX512VLBWDQ-NEXT:    vpand %xmm5, %xmm2, %xmm2
; AVX512VLBWDQ-NEXT:    vpshufb %xmm1, %xmm3, %xmm1
; AVX512VLBWDQ-NEXT:    vpaddb %xmm1, %xmm2, %xmm1
; AVX512VLBWDQ-NEXT:    vpcmpeqb %xmm4, %xmm0, %xmm2
; AVX512VLBWDQ-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX512VLBWDQ-NEXT:    vpand %xmm2, %xmm1, %xmm2
; AVX512VLBWDQ-NEXT:    vpsrlw $8, %xmm1, %xmm1
; AVX512VLBWDQ-NEXT:    vpaddw %xmm2, %xmm1, %xmm1
; AVX512VLBWDQ-NEXT:    vpcmpeqw %xmm4, %xmm0, %xmm0
; AVX512VLBWDQ-NEXT:    vpsrld $16, %xmm0, %xmm0
; AVX512VLBWDQ-NEXT:    vpand %xmm0, %xmm1, %xmm0
; AVX512VLBWDQ-NEXT:    vpsrld $16, %xmm1, %xmm1
; AVX512VLBWDQ-NEXT:    vpaddd %xmm0, %xmm1, %xmm0
; AVX512VLBWDQ-NEXT:    retq
;
; AVX512VLCD-LABEL: testv4i32u:
; AVX512VLCD:       # %bb.0:
; AVX512VLCD-NEXT:    vplzcntd %xmm0, %xmm0
; AVX512VLCD-NEXT:    retq
;
; AVX512CD-LABEL: testv4i32u:
; AVX512CD:       # %bb.0:
; AVX512CD-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512CD-NEXT:    vplzcntd %zmm0, %zmm0
; AVX512CD-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512CD-NEXT:    vzeroupper
; AVX512CD-NEXT:    retq
;
; X32-SSE-LABEL: testv4i32u:
; X32-SSE:       # %bb.0:
; X32-SSE-NEXT:    movdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; X32-SSE-NEXT:    movdqa %xmm0, %xmm1
; X32-SSE-NEXT:    pand %xmm2, %xmm1
; X32-SSE-NEXT:    movdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; X32-SSE-NEXT:    movdqa %xmm3, %xmm4
; X32-SSE-NEXT:    pshufb %xmm1, %xmm4
; X32-SSE-NEXT:    movdqa %xmm0, %xmm1
; X32-SSE-NEXT:    psrlw $4, %xmm1
; X32-SSE-NEXT:    pand %xmm2, %xmm1
; X32-SSE-NEXT:    pxor %xmm2, %xmm2
; X32-SSE-NEXT:    pshufb %xmm1, %xmm3
; X32-SSE-NEXT:    pcmpeqb %xmm2, %xmm1
; X32-SSE-NEXT:    pand %xmm4, %xmm1
; X32-SSE-NEXT:    paddb %xmm3, %xmm1
; X32-SSE-NEXT:    movdqa %xmm0, %xmm3
; X32-SSE-NEXT:    pcmpeqb %xmm2, %xmm3
; X32-SSE-NEXT:    psrlw $8, %xmm3
; X32-SSE-NEXT:    pand %xmm1, %xmm3
; X32-SSE-NEXT:    psrlw $8, %xmm1
; X32-SSE-NEXT:    paddw %xmm3, %xmm1
; X32-SSE-NEXT:    pcmpeqw %xmm2, %xmm0
; X32-SSE-NEXT:    psrld $16, %xmm0
; X32-SSE-NEXT:    pand %xmm1, %xmm0
; X32-SSE-NEXT:    psrld $16, %xmm1
; X32-SSE-NEXT:    paddd %xmm0, %xmm1
; X32-SSE-NEXT:    movdqa %xmm1, %xmm0
; X32-SSE-NEXT:    retl

  %out = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %in, i1 -1)
  ret <4 x i32> %out
}

define <8 x i16> @testv8i16(<8 x i16> %in) nounwind {
; SSE2-LABEL: testv8i16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrlw $1, %xmm1
; SSE2-NEXT:    por %xmm0, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    psrlw $2, %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrlw $4, %xmm1
; SSE2-NEXT:    por %xmm0, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    psrlw $8, %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    pxor %xmm0, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    psrlw $1, %xmm0
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE2-NEXT:    psubw %xmm0, %xmm1
; SSE2-NEXT:    movdqa {{.*#+}} xmm0 = [13107,13107,13107,13107,13107,13107,13107,13107]
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    pand %xmm0, %xmm2
; SSE2-NEXT:    psrlw $2, %xmm1
; SSE2-NEXT:    pand %xmm0, %xmm1
; SSE2-NEXT:    paddw %xmm2, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    psrlw $4, %xmm2
; SSE2-NEXT:    paddw %xmm1, %xmm2
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm0
; SSE2-NEXT:    psllw $8, %xmm0
; SSE2-NEXT:    paddb %xmm2, %xmm0
; SSE2-NEXT:    psrlw $8, %xmm0
; SSE2-NEXT:    retq
;
; SSE3-LABEL: testv8i16:
; SSE3:       # %bb.0:
; SSE3-NEXT:    movdqa %xmm0, %xmm1
; SSE3-NEXT:    psrlw $1, %xmm1
; SSE3-NEXT:    por %xmm0, %xmm1
; SSE3-NEXT:    movdqa %xmm1, %xmm0
; SSE3-NEXT:    psrlw $2, %xmm0
; SSE3-NEXT:    por %xmm1, %xmm0
; SSE3-NEXT:    movdqa %xmm0, %xmm1
; SSE3-NEXT:    psrlw $4, %xmm1
; SSE3-NEXT:    por %xmm0, %xmm1
; SSE3-NEXT:    movdqa %xmm1, %xmm0
; SSE3-NEXT:    psrlw $8, %xmm0
; SSE3-NEXT:    por %xmm1, %xmm0
; SSE3-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE3-NEXT:    pxor %xmm0, %xmm1
; SSE3-NEXT:    movdqa %xmm1, %xmm0
; SSE3-NEXT:    psrlw $1, %xmm0
; SSE3-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE3-NEXT:    psubw %xmm0, %xmm1
; SSE3-NEXT:    movdqa {{.*#+}} xmm0 = [13107,13107,13107,13107,13107,13107,13107,13107]
; SSE3-NEXT:    movdqa %xmm1, %xmm2
; SSE3-NEXT:    pand %xmm0, %xmm2
; SSE3-NEXT:    psrlw $2, %xmm1
; SSE3-NEXT:    pand %xmm0, %xmm1
; SSE3-NEXT:    paddw %xmm2, %xmm1
; SSE3-NEXT:    movdqa %xmm1, %xmm2
; SSE3-NEXT:    psrlw $4, %xmm2
; SSE3-NEXT:    paddw %xmm1, %xmm2
; SSE3-NEXT:    pand {{.*}}(%rip), %xmm2
; SSE3-NEXT:    movdqa %xmm2, %xmm0
; SSE3-NEXT:    psllw $8, %xmm0
; SSE3-NEXT:    paddb %xmm2, %xmm0
; SSE3-NEXT:    psrlw $8, %xmm0
; SSE3-NEXT:    retq
;
; SSSE3-LABEL: testv8i16:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSSE3-NEXT:    movdqa %xmm0, %xmm1
; SSSE3-NEXT:    pand %xmm2, %xmm1
; SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; SSSE3-NEXT:    movdqa %xmm3, %xmm4
; SSSE3-NEXT:    pshufb %xmm1, %xmm4
; SSSE3-NEXT:    movdqa %xmm0, %xmm1
; SSSE3-NEXT:    psrlw $4, %xmm1
; SSSE3-NEXT:    pand %xmm2, %xmm1
; SSSE3-NEXT:    pxor %xmm2, %xmm2
; SSSE3-NEXT:    pshufb %xmm1, %xmm3
; SSSE3-NEXT:    pcmpeqb %xmm2, %xmm1
; SSSE3-NEXT:    pand %xmm4, %xmm1
; SSSE3-NEXT:    paddb %xmm3, %xmm1
; SSSE3-NEXT:    pcmpeqb %xmm2, %xmm0
; SSSE3-NEXT:    psrlw $8, %xmm0
; SSSE3-NEXT:    pand %xmm1, %xmm0
; SSSE3-NEXT:    psrlw $8, %xmm1
; SSSE3-NEXT:    paddw %xmm0, %xmm1
; SSSE3-NEXT:    movdqa %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: testv8i16:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSE41-NEXT:    movdqa %xmm0, %xmm1
; SSE41-NEXT:    pand %xmm2, %xmm1
; SSE41-NEXT:    movdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; SSE41-NEXT:    movdqa %xmm3, %xmm4
; SSE41-NEXT:    pshufb %xmm1, %xmm4
; SSE41-NEXT:    movdqa %xmm0, %xmm1
; SSE41-NEXT:    psrlw $4, %xmm1
; SSE41-NEXT:    pand %xmm2, %xmm1
; SSE41-NEXT:    pxor %xmm2, %xmm2
; SSE41-NEXT:    pshufb %xmm1, %xmm3
; SSE41-NEXT:    pcmpeqb %xmm2, %xmm1
; SSE41-NEXT:    pand %xmm4, %xmm1
; SSE41-NEXT:    paddb %xmm3, %xmm1
; SSE41-NEXT:    pcmpeqb %xmm2, %xmm0
; SSE41-NEXT:    psrlw $8, %xmm0
; SSE41-NEXT:    pand %xmm1, %xmm0
; SSE41-NEXT:    psrlw $8, %xmm1
; SSE41-NEXT:    paddw %xmm0, %xmm1
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: testv8i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovdqa {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX-NEXT:    vmovdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX-NEXT:    vpand %xmm1, %xmm4, %xmm1
; AVX-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX-NEXT:    vpcmpeqb %xmm4, %xmm1, %xmm5
; AVX-NEXT:    vpand %xmm5, %xmm2, %xmm2
; AVX-NEXT:    vpshufb %xmm1, %xmm3, %xmm1
; AVX-NEXT:    vpaddb %xmm1, %xmm2, %xmm1
; AVX-NEXT:    vpcmpeqb %xmm4, %xmm0, %xmm0
; AVX-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX-NEXT:    vpand %xmm0, %xmm1, %xmm0
; AVX-NEXT:    vpsrlw $8, %xmm1, %xmm1
; AVX-NEXT:    vpaddw %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
;
; AVX512VLBWDQ-LABEL: testv8i16:
; AVX512VLBWDQ:       # %bb.0:
; AVX512VLBWDQ-NEXT:    vmovdqa {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VLBWDQ-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX512VLBWDQ-NEXT:    vmovdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX512VLBWDQ-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX512VLBWDQ-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX512VLBWDQ-NEXT:    vpand %xmm1, %xmm4, %xmm1
; AVX512VLBWDQ-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512VLBWDQ-NEXT:    vpcmpeqb %xmm4, %xmm1, %xmm5
; AVX512VLBWDQ-NEXT:    vpand %xmm5, %xmm2, %xmm2
; AVX512VLBWDQ-NEXT:    vpshufb %xmm1, %xmm3, %xmm1
; AVX512VLBWDQ-NEXT:    vpaddb %xmm1, %xmm2, %xmm1
; AVX512VLBWDQ-NEXT:    vpcmpeqb %xmm4, %xmm0, %xmm0
; AVX512VLBWDQ-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX512VLBWDQ-NEXT:    vpand %xmm0, %xmm1, %xmm0
; AVX512VLBWDQ-NEXT:    vpsrlw $8, %xmm1, %xmm1
; AVX512VLBWDQ-NEXT:    vpaddw %xmm0, %xmm1, %xmm0
; AVX512VLBWDQ-NEXT:    retq
;
; AVX512VLCD-LABEL: testv8i16:
; AVX512VLCD:       # %bb.0:
; AVX512VLCD-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX512VLCD-NEXT:    vplzcntd %ymm0, %ymm0
; AVX512VLCD-NEXT:    vpmovdw %ymm0, %xmm0
; AVX512VLCD-NEXT:    vpsubw {{.*}}(%rip), %xmm0, %xmm0
; AVX512VLCD-NEXT:    vzeroupper
; AVX512VLCD-NEXT:    retq
;
; AVX512CD-LABEL: testv8i16:
; AVX512CD:       # %bb.0:
; AVX512CD-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX512CD-NEXT:    vplzcntd %zmm0, %zmm0
; AVX512CD-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512CD-NEXT:    vpsubw {{.*}}(%rip), %xmm0, %xmm0
; AVX512CD-NEXT:    vzeroupper
; AVX512CD-NEXT:    retq
;
; X32-SSE-LABEL: testv8i16:
; X32-SSE:       # %bb.0:
; X32-SSE-NEXT:    movdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; X32-SSE-NEXT:    movdqa %xmm0, %xmm1
; X32-SSE-NEXT:    pand %xmm2, %xmm1
; X32-SSE-NEXT:    movdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; X32-SSE-NEXT:    movdqa %xmm3, %xmm4
; X32-SSE-NEXT:    pshufb %xmm1, %xmm4
; X32-SSE-NEXT:    movdqa %xmm0, %xmm1
; X32-SSE-NEXT:    psrlw $4, %xmm1
; X32-SSE-NEXT:    pand %xmm2, %xmm1
; X32-SSE-NEXT:    pxor %xmm2, %xmm2
; X32-SSE-NEXT:    pshufb %xmm1, %xmm3
; X32-SSE-NEXT:    pcmpeqb %xmm2, %xmm1
; X32-SSE-NEXT:    pand %xmm4, %xmm1
; X32-SSE-NEXT:    paddb %xmm3, %xmm1
; X32-SSE-NEXT:    pcmpeqb %xmm2, %xmm0
; X32-SSE-NEXT:    psrlw $8, %xmm0
; X32-SSE-NEXT:    pand %xmm1, %xmm0
; X32-SSE-NEXT:    psrlw $8, %xmm1
; X32-SSE-NEXT:    paddw %xmm0, %xmm1
; X32-SSE-NEXT:    movdqa %xmm1, %xmm0
; X32-SSE-NEXT:    retl
  %out = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %in, i1 0)
  ret <8 x i16> %out
}

define <8 x i16> @testv8i16u(<8 x i16> %in) nounwind {
; SSE2-LABEL: testv8i16u:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrlw $1, %xmm1
; SSE2-NEXT:    por %xmm0, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    psrlw $2, %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrlw $4, %xmm1
; SSE2-NEXT:    por %xmm0, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    psrlw $8, %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    pxor %xmm0, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    psrlw $1, %xmm0
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE2-NEXT:    psubw %xmm0, %xmm1
; SSE2-NEXT:    movdqa {{.*#+}} xmm0 = [13107,13107,13107,13107,13107,13107,13107,13107]
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    pand %xmm0, %xmm2
; SSE2-NEXT:    psrlw $2, %xmm1
; SSE2-NEXT:    pand %xmm0, %xmm1
; SSE2-NEXT:    paddw %xmm2, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    psrlw $4, %xmm2
; SSE2-NEXT:    paddw %xmm1, %xmm2
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm0
; SSE2-NEXT:    psllw $8, %xmm0
; SSE2-NEXT:    paddb %xmm2, %xmm0
; SSE2-NEXT:    psrlw $8, %xmm0
; SSE2-NEXT:    retq
;
; SSE3-LABEL: testv8i16u:
; SSE3:       # %bb.0:
; SSE3-NEXT:    movdqa %xmm0, %xmm1
; SSE3-NEXT:    psrlw $1, %xmm1
; SSE3-NEXT:    por %xmm0, %xmm1
; SSE3-NEXT:    movdqa %xmm1, %xmm0
; SSE3-NEXT:    psrlw $2, %xmm0
; SSE3-NEXT:    por %xmm1, %xmm0
; SSE3-NEXT:    movdqa %xmm0, %xmm1
; SSE3-NEXT:    psrlw $4, %xmm1
; SSE3-NEXT:    por %xmm0, %xmm1
; SSE3-NEXT:    movdqa %xmm1, %xmm0
; SSE3-NEXT:    psrlw $8, %xmm0
; SSE3-NEXT:    por %xmm1, %xmm0
; SSE3-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE3-NEXT:    pxor %xmm0, %xmm1
; SSE3-NEXT:    movdqa %xmm1, %xmm0
; SSE3-NEXT:    psrlw $1, %xmm0
; SSE3-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE3-NEXT:    psubw %xmm0, %xmm1
; SSE3-NEXT:    movdqa {{.*#+}} xmm0 = [13107,13107,13107,13107,13107,13107,13107,13107]
; SSE3-NEXT:    movdqa %xmm1, %xmm2
; SSE3-NEXT:    pand %xmm0, %xmm2
; SSE3-NEXT:    psrlw $2, %xmm1
; SSE3-NEXT:    pand %xmm0, %xmm1
; SSE3-NEXT:    paddw %xmm2, %xmm1
; SSE3-NEXT:    movdqa %xmm1, %xmm2
; SSE3-NEXT:    psrlw $4, %xmm2
; SSE3-NEXT:    paddw %xmm1, %xmm2
; SSE3-NEXT:    pand {{.*}}(%rip), %xmm2
; SSE3-NEXT:    movdqa %xmm2, %xmm0
; SSE3-NEXT:    psllw $8, %xmm0
; SSE3-NEXT:    paddb %xmm2, %xmm0
; SSE3-NEXT:    psrlw $8, %xmm0
; SSE3-NEXT:    retq
;
; SSSE3-LABEL: testv8i16u:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSSE3-NEXT:    movdqa %xmm0, %xmm1
; SSSE3-NEXT:    pand %xmm2, %xmm1
; SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; SSSE3-NEXT:    movdqa %xmm3, %xmm4
; SSSE3-NEXT:    pshufb %xmm1, %xmm4
; SSSE3-NEXT:    movdqa %xmm0, %xmm1
; SSSE3-NEXT:    psrlw $4, %xmm1
; SSSE3-NEXT:    pand %xmm2, %xmm1
; SSSE3-NEXT:    pxor %xmm2, %xmm2
; SSSE3-NEXT:    pshufb %xmm1, %xmm3
; SSSE3-NEXT:    pcmpeqb %xmm2, %xmm1
; SSSE3-NEXT:    pand %xmm4, %xmm1
; SSSE3-NEXT:    paddb %xmm3, %xmm1
; SSSE3-NEXT:    pcmpeqb %xmm2, %xmm0
; SSSE3-NEXT:    psrlw $8, %xmm0
; SSSE3-NEXT:    pand %xmm1, %xmm0
; SSSE3-NEXT:    psrlw $8, %xmm1
; SSSE3-NEXT:    paddw %xmm0, %xmm1
; SSSE3-NEXT:    movdqa %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: testv8i16u:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSE41-NEXT:    movdqa %xmm0, %xmm1
; SSE41-NEXT:    pand %xmm2, %xmm1
; SSE41-NEXT:    movdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; SSE41-NEXT:    movdqa %xmm3, %xmm4
; SSE41-NEXT:    pshufb %xmm1, %xmm4
; SSE41-NEXT:    movdqa %xmm0, %xmm1
; SSE41-NEXT:    psrlw $4, %xmm1
; SSE41-NEXT:    pand %xmm2, %xmm1
; SSE41-NEXT:    pxor %xmm2, %xmm2
; SSE41-NEXT:    pshufb %xmm1, %xmm3
; SSE41-NEXT:    pcmpeqb %xmm2, %xmm1
; SSE41-NEXT:    pand %xmm4, %xmm1
; SSE41-NEXT:    paddb %xmm3, %xmm1
; SSE41-NEXT:    pcmpeqb %xmm2, %xmm0
; SSE41-NEXT:    psrlw $8, %xmm0
; SSE41-NEXT:    pand %xmm1, %xmm0
; SSE41-NEXT:    psrlw $8, %xmm1
; SSE41-NEXT:    paddw %xmm0, %xmm1
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: testv8i16u:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovdqa {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX-NEXT:    vmovdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX-NEXT:    vpand %xmm1, %xmm4, %xmm1
; AVX-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX-NEXT:    vpcmpeqb %xmm4, %xmm1, %xmm5
; AVX-NEXT:    vpand %xmm5, %xmm2, %xmm2
; AVX-NEXT:    vpshufb %xmm1, %xmm3, %xmm1
; AVX-NEXT:    vpaddb %xmm1, %xmm2, %xmm1
; AVX-NEXT:    vpcmpeqb %xmm4, %xmm0, %xmm0
; AVX-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX-NEXT:    vpand %xmm0, %xmm1, %xmm0
; AVX-NEXT:    vpsrlw $8, %xmm1, %xmm1
; AVX-NEXT:    vpaddw %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
;
; AVX512VLBWDQ-LABEL: testv8i16u:
; AVX512VLBWDQ:       # %bb.0:
; AVX512VLBWDQ-NEXT:    vmovdqa {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VLBWDQ-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX512VLBWDQ-NEXT:    vmovdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX512VLBWDQ-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX512VLBWDQ-NEXT:    vpsrlw $4, %xmm0, %xmm4
; AVX512VLBWDQ-NEXT:    vpand %xmm1, %xmm4, %xmm1
; AVX512VLBWDQ-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512VLBWDQ-NEXT:    vpcmpeqb %xmm4, %xmm1, %xmm5
; AVX512VLBWDQ-NEXT:    vpand %xmm5, %xmm2, %xmm2
; AVX512VLBWDQ-NEXT:    vpshufb %xmm1, %xmm3, %xmm1
; AVX512VLBWDQ-NEXT:    vpaddb %xmm1, %xmm2, %xmm1
; AVX512VLBWDQ-NEXT:    vpcmpeqb %xmm4, %xmm0, %xmm0
; AVX512VLBWDQ-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX512VLBWDQ-NEXT:    vpand %xmm0, %xmm1, %xmm0
; AVX512VLBWDQ-NEXT:    vpsrlw $8, %xmm1, %xmm1
; AVX512VLBWDQ-NEXT:    vpaddw %xmm0, %xmm1, %xmm0
; AVX512VLBWDQ-NEXT:    retq
;
; AVX512VLCD-LABEL: testv8i16u:
; AVX512VLCD:       # %bb.0:
; AVX512VLCD-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX512VLCD-NEXT:    vplzcntd %ymm0, %ymm0
; AVX512VLCD-NEXT:    vpmovdw %ymm0, %xmm0
; AVX512VLCD-NEXT:    vpsubw {{.*}}(%rip), %xmm0, %xmm0
; AVX512VLCD-NEXT:    vzeroupper
; AVX512VLCD-NEXT:    retq
;
; AVX512CD-LABEL: testv8i16u:
; AVX512CD:       # %bb.0:
; AVX512CD-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX512CD-NEXT:    vplzcntd %zmm0, %zmm0
; AVX512CD-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512CD-NEXT:    vpsubw {{.*}}(%rip), %xmm0, %xmm0
; AVX512CD-NEXT:    vzeroupper
; AVX512CD-NEXT:    retq
;
; X32-SSE-LABEL: testv8i16u:
; X32-SSE:       # %bb.0:
; X32-SSE-NEXT:    movdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; X32-SSE-NEXT:    movdqa %xmm0, %xmm1
; X32-SSE-NEXT:    pand %xmm2, %xmm1
; X32-SSE-NEXT:    movdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; X32-SSE-NEXT:    movdqa %xmm3, %xmm4
; X32-SSE-NEXT:    pshufb %xmm1, %xmm4
; X32-SSE-NEXT:    movdqa %xmm0, %xmm1
; X32-SSE-NEXT:    psrlw $4, %xmm1
; X32-SSE-NEXT:    pand %xmm2, %xmm1
; X32-SSE-NEXT:    pxor %xmm2, %xmm2
; X32-SSE-NEXT:    pshufb %xmm1, %xmm3
; X32-SSE-NEXT:    pcmpeqb %xmm2, %xmm1
; X32-SSE-NEXT:    pand %xmm4, %xmm1
; X32-SSE-NEXT:    paddb %xmm3, %xmm1
; X32-SSE-NEXT:    pcmpeqb %xmm2, %xmm0
; X32-SSE-NEXT:    psrlw $8, %xmm0
; X32-SSE-NEXT:    pand %xmm1, %xmm0
; X32-SSE-NEXT:    psrlw $8, %xmm1
; X32-SSE-NEXT:    paddw %xmm0, %xmm1
; X32-SSE-NEXT:    movdqa %xmm1, %xmm0
; X32-SSE-NEXT:    retl
  %out = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %in, i1 -1)
  ret <8 x i16> %out
}

define <16 x i8> @testv16i8(<16 x i8> %in) nounwind {
; SSE2-LABEL: testv16i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrlw $1, %xmm1
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm1
; SSE2-NEXT:    por %xmm0, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    psrlw $2, %xmm0
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrlw $4, %xmm1
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSE2-NEXT:    pand %xmm2, %xmm1
; SSE2-NEXT:    por %xmm0, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm3, %xmm3
; SSE2-NEXT:    pxor %xmm1, %xmm3
; SSE2-NEXT:    movdqa %xmm3, %xmm0
; SSE2-NEXT:    psrlw $1, %xmm0
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE2-NEXT:    psubb %xmm0, %xmm3
; SSE2-NEXT:    movdqa {{.*#+}} xmm0 = [51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51]
; SSE2-NEXT:    movdqa %xmm3, %xmm1
; SSE2-NEXT:    pand %xmm0, %xmm1
; SSE2-NEXT:    psrlw $2, %xmm3
; SSE2-NEXT:    pand %xmm0, %xmm3
; SSE2-NEXT:    paddb %xmm1, %xmm3
; SSE2-NEXT:    movdqa %xmm3, %xmm0
; SSE2-NEXT:    psrlw $4, %xmm0
; SSE2-NEXT:    paddb %xmm3, %xmm0
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE3-LABEL: testv16i8:
; SSE3:       # %bb.0:
; SSE3-NEXT:    movdqa %xmm0, %xmm1
; SSE3-NEXT:    psrlw $1, %xmm1
; SSE3-NEXT:    pand {{.*}}(%rip), %xmm1
; SSE3-NEXT:    por %xmm0, %xmm1
; SSE3-NEXT:    movdqa %xmm1, %xmm0
; SSE3-NEXT:    psrlw $2, %xmm0
; SSE3-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE3-NEXT:    por %xmm1, %xmm0
; SSE3-NEXT:    movdqa %xmm0, %xmm1
; SSE3-NEXT:    psrlw $4, %xmm1
; SSE3-NEXT:    movdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSE3-NEXT:    pand %xmm2, %xmm1
; SSE3-NEXT:    por %xmm0, %xmm1
; SSE3-NEXT:    pcmpeqd %xmm3, %xmm3
; SSE3-NEXT:    pxor %xmm1, %xmm3
; SSE3-NEXT:    movdqa %xmm3, %xmm0
; SSE3-NEXT:    psrlw $1, %xmm0
; SSE3-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE3-NEXT:    psubb %xmm0, %xmm3
; SSE3-NEXT:    movdqa {{.*#+}} xmm0 = [51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51]
; SSE3-NEXT:    movdqa %xmm3, %xmm1
; SSE3-NEXT:    pand %xmm0, %xmm1
; SSE3-NEXT:    psrlw $2, %xmm3
; SSE3-NEXT:    pand %xmm0, %xmm3
; SSE3-NEXT:    paddb %xmm1, %xmm3
; SSE3-NEXT:    movdqa %xmm3, %xmm0
; SSE3-NEXT:    psrlw $4, %xmm0
; SSE3-NEXT:    paddb %xmm3, %xmm0
; SSE3-NEXT:    pand %xmm2, %xmm0
; SSE3-NEXT:    retq
;
; SSSE3-LABEL: testv16i8:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSSE3-NEXT:    movdqa %xmm0, %xmm3
; SSSE3-NEXT:    pand %xmm2, %xmm3
; SSSE3-NEXT:    movdqa {{.*#+}} xmm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; SSSE3-NEXT:    movdqa %xmm1, %xmm4
; SSSE3-NEXT:    pshufb %xmm3, %xmm4
; SSSE3-NEXT:    psrlw $4, %xmm0
; SSSE3-NEXT:    pand %xmm2, %xmm0
; SSSE3-NEXT:    pxor %xmm2, %xmm2
; SSSE3-NEXT:    pcmpeqb %xmm0, %xmm2
; SSSE3-NEXT:    pand %xmm4, %xmm2
; SSSE3-NEXT:    pshufb %xmm0, %xmm1
; SSSE3-NEXT:    paddb %xmm2, %xmm1
; SSSE3-NEXT:    movdqa %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: testv16i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSE41-NEXT:    movdqa %xmm0, %xmm3
; SSE41-NEXT:    pand %xmm2, %xmm3
; SSE41-NEXT:    movdqa {{.*#+}} xmm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; SSE41-NEXT:    movdqa %xmm1, %xmm4
; SSE41-NEXT:    pshufb %xmm3, %xmm4
; SSE41-NEXT:    psrlw $4, %xmm0
; SSE41-NEXT:    pand %xmm2, %xmm0
; SSE41-NEXT:    pxor %xmm2, %xmm2
; SSE41-NEXT:    pcmpeqb %xmm0, %xmm2
; SSE41-NEXT:    pand %xmm4, %xmm2
; SSE41-NEXT:    pshufb %xmm0, %xmm1
; SSE41-NEXT:    paddb %xmm2, %xmm1
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: testv16i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovdqa {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX-NEXT:    vmovdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vpcmpeqb %xmm1, %xmm0, %xmm1
; AVX-NEXT:    vpand %xmm1, %xmm2, %xmm1
; AVX-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
;
; AVX512VLBWDQ-LABEL: testv16i8:
; AVX512VLBWDQ:       # %bb.0:
; AVX512VLBWDQ-NEXT:    vmovdqa {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VLBWDQ-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX512VLBWDQ-NEXT:    vmovdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX512VLBWDQ-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX512VLBWDQ-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX512VLBWDQ-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX512VLBWDQ-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VLBWDQ-NEXT:    vpcmpeqb %xmm1, %xmm0, %xmm1
; AVX512VLBWDQ-NEXT:    vpand %xmm1, %xmm2, %xmm1
; AVX512VLBWDQ-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX512VLBWDQ-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX512VLBWDQ-NEXT:    retq
;
; AVX512-LABEL: testv16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovzxbd {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; AVX512-NEXT:    vplzcntd %zmm0, %zmm0
; AVX512-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512-NEXT:    vpsubb {{.*}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; X32-SSE-LABEL: testv16i8:
; X32-SSE:       # %bb.0:
; X32-SSE-NEXT:    movdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; X32-SSE-NEXT:    movdqa %xmm0, %xmm3
; X32-SSE-NEXT:    pand %xmm2, %xmm3
; X32-SSE-NEXT:    movdqa {{.*#+}} xmm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; X32-SSE-NEXT:    movdqa %xmm1, %xmm4
; X32-SSE-NEXT:    pshufb %xmm3, %xmm4
; X32-SSE-NEXT:    psrlw $4, %xmm0
; X32-SSE-NEXT:    pand %xmm2, %xmm0
; X32-SSE-NEXT:    pxor %xmm2, %xmm2
; X32-SSE-NEXT:    pcmpeqb %xmm0, %xmm2
; X32-SSE-NEXT:    pand %xmm4, %xmm2
; X32-SSE-NEXT:    pshufb %xmm0, %xmm1
; X32-SSE-NEXT:    paddb %xmm2, %xmm1
; X32-SSE-NEXT:    movdqa %xmm1, %xmm0
; X32-SSE-NEXT:    retl
  %out = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %in, i1 0)
  ret <16 x i8> %out
}

define <16 x i8> @testv16i8u(<16 x i8> %in) nounwind {
; SSE2-LABEL: testv16i8u:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrlw $1, %xmm1
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm1
; SSE2-NEXT:    por %xmm0, %xmm1
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    psrlw $2, %xmm0
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    psrlw $4, %xmm1
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSE2-NEXT:    pand %xmm2, %xmm1
; SSE2-NEXT:    por %xmm0, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm3, %xmm3
; SSE2-NEXT:    pxor %xmm1, %xmm3
; SSE2-NEXT:    movdqa %xmm3, %xmm0
; SSE2-NEXT:    psrlw $1, %xmm0
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE2-NEXT:    psubb %xmm0, %xmm3
; SSE2-NEXT:    movdqa {{.*#+}} xmm0 = [51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51]
; SSE2-NEXT:    movdqa %xmm3, %xmm1
; SSE2-NEXT:    pand %xmm0, %xmm1
; SSE2-NEXT:    psrlw $2, %xmm3
; SSE2-NEXT:    pand %xmm0, %xmm3
; SSE2-NEXT:    paddb %xmm1, %xmm3
; SSE2-NEXT:    movdqa %xmm3, %xmm0
; SSE2-NEXT:    psrlw $4, %xmm0
; SSE2-NEXT:    paddb %xmm3, %xmm0
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE3-LABEL: testv16i8u:
; SSE3:       # %bb.0:
; SSE3-NEXT:    movdqa %xmm0, %xmm1
; SSE3-NEXT:    psrlw $1, %xmm1
; SSE3-NEXT:    pand {{.*}}(%rip), %xmm1
; SSE3-NEXT:    por %xmm0, %xmm1
; SSE3-NEXT:    movdqa %xmm1, %xmm0
; SSE3-NEXT:    psrlw $2, %xmm0
; SSE3-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE3-NEXT:    por %xmm1, %xmm0
; SSE3-NEXT:    movdqa %xmm0, %xmm1
; SSE3-NEXT:    psrlw $4, %xmm1
; SSE3-NEXT:    movdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSE3-NEXT:    pand %xmm2, %xmm1
; SSE3-NEXT:    por %xmm0, %xmm1
; SSE3-NEXT:    pcmpeqd %xmm3, %xmm3
; SSE3-NEXT:    pxor %xmm1, %xmm3
; SSE3-NEXT:    movdqa %xmm3, %xmm0
; SSE3-NEXT:    psrlw $1, %xmm0
; SSE3-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE3-NEXT:    psubb %xmm0, %xmm3
; SSE3-NEXT:    movdqa {{.*#+}} xmm0 = [51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51]
; SSE3-NEXT:    movdqa %xmm3, %xmm1
; SSE3-NEXT:    pand %xmm0, %xmm1
; SSE3-NEXT:    psrlw $2, %xmm3
; SSE3-NEXT:    pand %xmm0, %xmm3
; SSE3-NEXT:    paddb %xmm1, %xmm3
; SSE3-NEXT:    movdqa %xmm3, %xmm0
; SSE3-NEXT:    psrlw $4, %xmm0
; SSE3-NEXT:    paddb %xmm3, %xmm0
; SSE3-NEXT:    pand %xmm2, %xmm0
; SSE3-NEXT:    retq
;
; SSSE3-LABEL: testv16i8u:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSSE3-NEXT:    movdqa %xmm0, %xmm3
; SSSE3-NEXT:    pand %xmm2, %xmm3
; SSSE3-NEXT:    movdqa {{.*#+}} xmm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; SSSE3-NEXT:    movdqa %xmm1, %xmm4
; SSSE3-NEXT:    pshufb %xmm3, %xmm4
; SSSE3-NEXT:    psrlw $4, %xmm0
; SSSE3-NEXT:    pand %xmm2, %xmm0
; SSSE3-NEXT:    pxor %xmm2, %xmm2
; SSSE3-NEXT:    pcmpeqb %xmm0, %xmm2
; SSSE3-NEXT:    pand %xmm4, %xmm2
; SSSE3-NEXT:    pshufb %xmm0, %xmm1
; SSSE3-NEXT:    paddb %xmm2, %xmm1
; SSSE3-NEXT:    movdqa %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: testv16i8u:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; SSE41-NEXT:    movdqa %xmm0, %xmm3
; SSE41-NEXT:    pand %xmm2, %xmm3
; SSE41-NEXT:    movdqa {{.*#+}} xmm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; SSE41-NEXT:    movdqa %xmm1, %xmm4
; SSE41-NEXT:    pshufb %xmm3, %xmm4
; SSE41-NEXT:    psrlw $4, %xmm0
; SSE41-NEXT:    pand %xmm2, %xmm0
; SSE41-NEXT:    pxor %xmm2, %xmm2
; SSE41-NEXT:    pcmpeqb %xmm0, %xmm2
; SSE41-NEXT:    pand %xmm4, %xmm2
; SSE41-NEXT:    pshufb %xmm0, %xmm1
; SSE41-NEXT:    paddb %xmm2, %xmm1
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: testv16i8u:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovdqa {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX-NEXT:    vmovdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vpcmpeqb %xmm1, %xmm0, %xmm1
; AVX-NEXT:    vpand %xmm1, %xmm2, %xmm1
; AVX-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
;
; AVX512VLBWDQ-LABEL: testv16i8u:
; AVX512VLBWDQ:       # %bb.0:
; AVX512VLBWDQ-NEXT:    vmovdqa {{.*#+}} xmm1 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VLBWDQ-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX512VLBWDQ-NEXT:    vmovdqa {{.*#+}} xmm3 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; AVX512VLBWDQ-NEXT:    vpshufb %xmm2, %xmm3, %xmm2
; AVX512VLBWDQ-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX512VLBWDQ-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX512VLBWDQ-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VLBWDQ-NEXT:    vpcmpeqb %xmm1, %xmm0, %xmm1
; AVX512VLBWDQ-NEXT:    vpand %xmm1, %xmm2, %xmm1
; AVX512VLBWDQ-NEXT:    vpshufb %xmm0, %xmm3, %xmm0
; AVX512VLBWDQ-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX512VLBWDQ-NEXT:    retq
;
; AVX512-LABEL: testv16i8u:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovzxbd {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; AVX512-NEXT:    vplzcntd %zmm0, %zmm0
; AVX512-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512-NEXT:    vpsubb {{.*}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; X32-SSE-LABEL: testv16i8u:
; X32-SSE:       # %bb.0:
; X32-SSE-NEXT:    movdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; X32-SSE-NEXT:    movdqa %xmm0, %xmm3
; X32-SSE-NEXT:    pand %xmm2, %xmm3
; X32-SSE-NEXT:    movdqa {{.*#+}} xmm1 = [4,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0]
; X32-SSE-NEXT:    movdqa %xmm1, %xmm4
; X32-SSE-NEXT:    pshufb %xmm3, %xmm4
; X32-SSE-NEXT:    psrlw $4, %xmm0
; X32-SSE-NEXT:    pand %xmm2, %xmm0
; X32-SSE-NEXT:    pxor %xmm2, %xmm2
; X32-SSE-NEXT:    pcmpeqb %xmm0, %xmm2
; X32-SSE-NEXT:    pand %xmm4, %xmm2
; X32-SSE-NEXT:    pshufb %xmm0, %xmm1
; X32-SSE-NEXT:    paddb %xmm2, %xmm1
; X32-SSE-NEXT:    movdqa %xmm1, %xmm0
; X32-SSE-NEXT:    retl
  %out = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %in, i1 -1)
  ret <16 x i8> %out
}

define <2 x i64> @foldv2i64() nounwind {
; SSE-LABEL: foldv2i64:
; SSE:       # %bb.0:
; SSE-NEXT:    movl $55, %eax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    retq
;
; NOBW-LABEL: foldv2i64:
; NOBW:       # %bb.0:
; NOBW-NEXT:    movl $55, %eax
; NOBW-NEXT:    vmovq %rax, %xmm0
; NOBW-NEXT:    retq
;
; AVX512VLBWDQ-LABEL: foldv2i64:
; AVX512VLBWDQ:       # %bb.0:
; AVX512VLBWDQ-NEXT:    movl $55, %eax
; AVX512VLBWDQ-NEXT:    vmovq %rax, %xmm0
; AVX512VLBWDQ-NEXT:    retq
;
; X32-SSE-LABEL: foldv2i64:
; X32-SSE:       # %bb.0:
; X32-SSE-NEXT:    movl $55, %eax
; X32-SSE-NEXT:    movd %eax, %xmm0
; X32-SSE-NEXT:    retl
  %out = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> <i64 256, i64 -1>, i1 0)
  ret <2 x i64> %out
}

define <2 x i64> @foldv2i64u() nounwind {
; SSE-LABEL: foldv2i64u:
; SSE:       # %bb.0:
; SSE-NEXT:    movl $55, %eax
; SSE-NEXT:    movq %rax, %xmm0
; SSE-NEXT:    retq
;
; NOBW-LABEL: foldv2i64u:
; NOBW:       # %bb.0:
; NOBW-NEXT:    movl $55, %eax
; NOBW-NEXT:    vmovq %rax, %xmm0
; NOBW-NEXT:    retq
;
; AVX512VLBWDQ-LABEL: foldv2i64u:
; AVX512VLBWDQ:       # %bb.0:
; AVX512VLBWDQ-NEXT:    movl $55, %eax
; AVX512VLBWDQ-NEXT:    vmovq %rax, %xmm0
; AVX512VLBWDQ-NEXT:    retq
;
; X32-SSE-LABEL: foldv2i64u:
; X32-SSE:       # %bb.0:
; X32-SSE-NEXT:    movl $55, %eax
; X32-SSE-NEXT:    movd %eax, %xmm0
; X32-SSE-NEXT:    retl
  %out = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> <i64 256, i64 -1>, i1 -1)
  ret <2 x i64> %out
}

define <4 x i32> @foldv4i32() nounwind {
; SSE-LABEL: foldv4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps {{.*#+}} xmm0 = [23,0,32,24]
; SSE-NEXT:    retq
;
; NOBW-LABEL: foldv4i32:
; NOBW:       # %bb.0:
; NOBW-NEXT:    vmovaps {{.*#+}} xmm0 = [23,0,32,24]
; NOBW-NEXT:    retq
;
; AVX512VLBWDQ-LABEL: foldv4i32:
; AVX512VLBWDQ:       # %bb.0:
; AVX512VLBWDQ-NEXT:    vmovaps {{.*#+}} xmm0 = [23,0,32,24]
; AVX512VLBWDQ-NEXT:    retq
;
; X32-SSE-LABEL: foldv4i32:
; X32-SSE:       # %bb.0:
; X32-SSE-NEXT:    movaps {{.*#+}} xmm0 = [23,0,32,24]
; X32-SSE-NEXT:    retl
  %out = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> <i32 256, i32 -1, i32 0, i32 255>, i1 0)
  ret <4 x i32> %out
}

define <4 x i32> @foldv4i32u() nounwind {
; SSE-LABEL: foldv4i32u:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps {{.*#+}} xmm0 = [23,0,32,24]
; SSE-NEXT:    retq
;
; NOBW-LABEL: foldv4i32u:
; NOBW:       # %bb.0:
; NOBW-NEXT:    vmovaps {{.*#+}} xmm0 = [23,0,32,24]
; NOBW-NEXT:    retq
;
; AVX512VLBWDQ-LABEL: foldv4i32u:
; AVX512VLBWDQ:       # %bb.0:
; AVX512VLBWDQ-NEXT:    vmovaps {{.*#+}} xmm0 = [23,0,32,24]
; AVX512VLBWDQ-NEXT:    retq
;
; X32-SSE-LABEL: foldv4i32u:
; X32-SSE:       # %bb.0:
; X32-SSE-NEXT:    movaps {{.*#+}} xmm0 = [23,0,32,24]
; X32-SSE-NEXT:    retl
  %out = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> <i32 256, i32 -1, i32 0, i32 255>, i1 -1)
  ret <4 x i32> %out
}

define <8 x i16> @foldv8i16() nounwind {
; SSE-LABEL: foldv8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps {{.*#+}} xmm0 = [7,0,16,8,16,13,11,9]
; SSE-NEXT:    retq
;
; NOBW-LABEL: foldv8i16:
; NOBW:       # %bb.0:
; NOBW-NEXT:    vmovaps {{.*#+}} xmm0 = [7,0,16,8,16,13,11,9]
; NOBW-NEXT:    retq
;
; AVX512VLBWDQ-LABEL: foldv8i16:
; AVX512VLBWDQ:       # %bb.0:
; AVX512VLBWDQ-NEXT:    vmovaps {{.*#+}} xmm0 = [7,0,16,8,16,13,11,9]
; AVX512VLBWDQ-NEXT:    retq
;
; X32-SSE-LABEL: foldv8i16:
; X32-SSE:       # %bb.0:
; X32-SSE-NEXT:    movaps {{.*#+}} xmm0 = [7,0,16,8,16,13,11,9]
; X32-SSE-NEXT:    retl
  %out = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> <i16 256, i16 -1, i16 0, i16 255, i16 -65536, i16 7, i16 24, i16 88>, i1 0)
  ret <8 x i16> %out
}

define <8 x i16> @foldv8i16u() nounwind {
; SSE-LABEL: foldv8i16u:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps {{.*#+}} xmm0 = [7,0,16,8,16,13,11,9]
; SSE-NEXT:    retq
;
; NOBW-LABEL: foldv8i16u:
; NOBW:       # %bb.0:
; NOBW-NEXT:    vmovaps {{.*#+}} xmm0 = [7,0,16,8,16,13,11,9]
; NOBW-NEXT:    retq
;
; AVX512VLBWDQ-LABEL: foldv8i16u:
; AVX512VLBWDQ:       # %bb.0:
; AVX512VLBWDQ-NEXT:    vmovaps {{.*#+}} xmm0 = [7,0,16,8,16,13,11,9]
; AVX512VLBWDQ-NEXT:    retq
;
; X32-SSE-LABEL: foldv8i16u:
; X32-SSE:       # %bb.0:
; X32-SSE-NEXT:    movaps {{.*#+}} xmm0 = [7,0,16,8,16,13,11,9]
; X32-SSE-NEXT:    retl
  %out = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> <i16 256, i16 -1, i16 0, i16 255, i16 -65536, i16 7, i16 24, i16 88>, i1 -1)
  ret <8 x i16> %out
}

define <16 x i8> @foldv16i8() nounwind {
; SSE-LABEL: foldv16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps {{.*#+}} xmm0 = [8,0,8,0,8,5,3,1,0,0,7,6,5,4,3,2]
; SSE-NEXT:    retq
;
; NOBW-LABEL: foldv16i8:
; NOBW:       # %bb.0:
; NOBW-NEXT:    vmovaps {{.*#+}} xmm0 = [8,0,8,0,8,5,3,1,0,0,7,6,5,4,3,2]
; NOBW-NEXT:    retq
;
; AVX512VLBWDQ-LABEL: foldv16i8:
; AVX512VLBWDQ:       # %bb.0:
; AVX512VLBWDQ-NEXT:    vmovaps {{.*#+}} xmm0 = [8,0,8,0,8,5,3,1,0,0,7,6,5,4,3,2]
; AVX512VLBWDQ-NEXT:    retq
;
; X32-SSE-LABEL: foldv16i8:
; X32-SSE:       # %bb.0:
; X32-SSE-NEXT:    movaps {{.*#+}} xmm0 = [8,0,8,0,8,5,3,1,0,0,7,6,5,4,3,2]
; X32-SSE-NEXT:    retl
  %out = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> <i8 256, i8 -1, i8 0, i8 255, i8 -65536, i8 7, i8 24, i8 88, i8 -2, i8 254, i8 1, i8 2, i8 4, i8 8, i8 16, i8 32>, i1 0)
  ret <16 x i8> %out
}

define <16 x i8> @foldv16i8u() nounwind {
; SSE-LABEL: foldv16i8u:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps {{.*#+}} xmm0 = [8,0,8,0,8,5,3,1,0,0,7,6,5,4,3,2]
; SSE-NEXT:    retq
;
; NOBW-LABEL: foldv16i8u:
; NOBW:       # %bb.0:
; NOBW-NEXT:    vmovaps {{.*#+}} xmm0 = [8,0,8,0,8,5,3,1,0,0,7,6,5,4,3,2]
; NOBW-NEXT:    retq
;
; AVX512VLBWDQ-LABEL: foldv16i8u:
; AVX512VLBWDQ:       # %bb.0:
; AVX512VLBWDQ-NEXT:    vmovaps {{.*#+}} xmm0 = [8,0,8,0,8,5,3,1,0,0,7,6,5,4,3,2]
; AVX512VLBWDQ-NEXT:    retq
;
; X32-SSE-LABEL: foldv16i8u:
; X32-SSE:       # %bb.0:
; X32-SSE-NEXT:    movaps {{.*#+}} xmm0 = [8,0,8,0,8,5,3,1,0,0,7,6,5,4,3,2]
; X32-SSE-NEXT:    retl
  %out = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> <i8 256, i8 -1, i8 0, i8 255, i8 -65536, i8 7, i8 24, i8 88, i8 -2, i8 254, i8 1, i8 2, i8 4, i8 8, i8 16, i8 32>, i1 -1)
  ret <16 x i8> %out
}

declare <2 x i64> @llvm.ctlz.v2i64(<2 x i64>, i1)
declare <4 x i32> @llvm.ctlz.v4i32(<4 x i32>, i1)
declare <8 x i16> @llvm.ctlz.v8i16(<8 x i16>, i1)
declare <16 x i8> @llvm.ctlz.v16i8(<16 x i8>, i1)
