; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc  -O0 -mtriple=mipsel-linux-gnu -global-isel -verify-machineinstrs %s -o -| FileCheck %s -check-prefixes=MIPS32,FP32
; RUN: llc  -O0 -mtriple=mipsel-linux-gnu -mattr=+fp64,+mips32r2 -global-isel -verify-machineinstrs %s -o -| FileCheck %s -check-prefixes=MIPS32,FP64

define i64 @f32toi64(float %a) {
; MIPS32-LABEL: f32toi64:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    .cfi_def_cfa_offset 24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    .cfi_offset 31, -4
; MIPS32-NEXT:    jal __fixsfdi
; MIPS32-NEXT:    nop
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    addiu $sp, $sp, 24
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %conv = fptosi float %a to i64
  ret i64 %conv
}

define i32 @f32toi32(float %a) {
; MIPS32-LABEL: f32toi32:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    trunc.w.s $f0, $f12
; MIPS32-NEXT:    mfc1 $2, $f0
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %conv = fptosi float %a to i32
  ret i32 %conv
}

define signext i16 @f32toi16(float %a) {
; MIPS32-LABEL: f32toi16:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    trunc.w.s $f0, $f12
; MIPS32-NEXT:    mfc1 $1, $f0
; MIPS32-NEXT:    sll $1, $1, 16
; MIPS32-NEXT:    sra $2, $1, 16
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %conv = fptosi float %a to i16
  ret i16 %conv
}

define signext i8 @f32toi8(float %a) {
; MIPS32-LABEL: f32toi8:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    trunc.w.s $f0, $f12
; MIPS32-NEXT:    mfc1 $1, $f0
; MIPS32-NEXT:    sll $1, $1, 24
; MIPS32-NEXT:    sra $2, $1, 24
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %conv = fptosi float %a to i8
  ret i8 %conv
}

define i64 @f64toi64(double %a) {
; MIPS32-LABEL: f64toi64:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    .cfi_def_cfa_offset 24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    .cfi_offset 31, -4
; MIPS32-NEXT:    jal __fixdfdi
; MIPS32-NEXT:    nop
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    addiu $sp, $sp, 24
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %conv = fptosi double %a to i64
  ret i64 %conv
}

define i32 @f64toi32(double %a) {
; MIPS32-LABEL: f64toi32:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    trunc.w.d $f0, $f12
; MIPS32-NEXT:    mfc1 $2, $f0
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %conv = fptosi double %a to i32
  ret i32 %conv
}

define signext i16 @f64toi16(double %a) {
; MIPS32-LABEL: f64toi16:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    trunc.w.d $f0, $f12
; MIPS32-NEXT:    mfc1 $1, $f0
; MIPS32-NEXT:    sll $1, $1, 16
; MIPS32-NEXT:    sra $2, $1, 16
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %conv = fptosi double %a to i16
  ret i16 %conv
}

define signext i8 @f64toi8(double %a) {
; MIPS32-LABEL: f64toi8:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    trunc.w.d $f0, $f12
; MIPS32-NEXT:    mfc1 $1, $f0
; MIPS32-NEXT:    sll $1, $1, 24
; MIPS32-NEXT:    sra $2, $1, 24
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %conv = fptosi double %a to i8
  ret i8 %conv
}

define i64 @f32tou64(float %a) {
; MIPS32-LABEL: f32tou64:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    .cfi_def_cfa_offset 24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    .cfi_offset 31, -4
; MIPS32-NEXT:    jal __fixunssfdi
; MIPS32-NEXT:    nop
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    addiu $sp, $sp, 24
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %conv = fptoui float %a to i64
  ret i64 %conv
}

define i64 @f64tou64(double %a) {
; MIPS32-LABEL: f64tou64:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    .cfi_def_cfa_offset 24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    .cfi_offset 31, -4
; MIPS32-NEXT:    jal __fixunsdfdi
; MIPS32-NEXT:    nop
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    addiu $sp, $sp, 24
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %conv = fptoui double %a to i64
  ret i64 %conv
}
