/*
 * Decompiled with CFR 0.152.
 */
package com.github.andrewoma.dexx.collection.internal.redblack;

import com.github.andrewoma.dexx.collection.Function;
import com.github.andrewoma.dexx.collection.KeyFunction;
import com.github.andrewoma.dexx.collection.Pair;
import com.github.andrewoma.dexx.collection.internal.redblack.DefaultTreeFactory;
import com.github.andrewoma.dexx.collection.internal.redblack.EntriesIterator;
import com.github.andrewoma.dexx.collection.internal.redblack.KeysIterator;
import com.github.andrewoma.dexx.collection.internal.redblack.Tree;
import com.github.andrewoma.dexx.collection.internal.redblack.TreeFactory;
import com.github.andrewoma.dexx.collection.internal.redblack.ValuesIterator;
import com.github.andrewoma.dexx.collection.internal.redblack.Zipper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class RedBlackTree<K, V> {
    private final TreeFactory factory;
    private final Comparator<? super K> ordering;
    private final KeyFunction<K, V> kf;
    private static final Comparator DEFAULT_COMPARATOR = new Comparator(){

        public int compare(@NotNull Object o1, @NotNull Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }
    };

    public RedBlackTree() {
        this(new DefaultTreeFactory(), null, null);
    }

    public RedBlackTree(TreeFactory factory, Comparator<? super K> ordering, KeyFunction<K, V> keyFunction) {
        this.factory = factory;
        this.kf = keyFunction;
        if (ordering == null) {
            ordering = DEFAULT_COMPARATOR;
        }
        this.ordering = ordering;
    }

    public KeyFunction<K, V> getKeyFunction() {
        return this.kf;
    }

    public Comparator<? super K> getOrdering() {
        return this.ordering == DEFAULT_COMPARATOR ? null : this.ordering;
    }

    public boolean isEmpty(Tree<K, V> tree) {
        return tree == null;
    }

    public boolean contains(Tree<K, V> tree, K x) {
        return this.lookup(tree, x) != null;
    }

    public V get(Tree<K, V> tree, K x) {
        Tree<K, V> lookup = this.lookup(tree, x);
        return lookup == null ? null : (V)lookup.getValue();
    }

    public Tree<K, V> lookup(Tree<K, V> tree, K x) {
        if (tree == null) {
            return null;
        }
        int cmp = this.ordering.compare(x, tree.getKey(this.kf));
        if (cmp < 0) {
            return this.lookup(tree.getLeft(), x);
        }
        if (cmp > 0) {
            return this.lookup(tree.getRight(), x);
        }
        return tree;
    }

    public static int count(Tree<?, ?> tree) {
        return tree == null ? 0 : tree.count();
    }

    public Tree<K, V> update(Tree<K, V> tree, K k, V v, boolean overwrite) {
        return this.blacken(this.upd(tree, k, v, overwrite));
    }

    public Tree<K, V> delete(Tree<K, V> tree, K k) {
        return this.blacken(this.del(tree, k));
    }

    public Tree<K, V> range(Tree<K, V> tree, K from, boolean fromInclusive, K until, boolean untilInclusive) {
        return this.blacken(this.doRange(tree, from, fromInclusive, until, untilInclusive));
    }

    public Tree<K, V> from(Tree<K, V> tree, K from, boolean inclusive) {
        return this.blacken(this.doFrom(tree, from, inclusive));
    }

    public Tree<K, V> until(Tree<K, V> tree, K key, boolean inclusive) {
        return this.blacken(this.doUntil(tree, key, inclusive));
    }

    public Tree<K, V> drop(Tree<K, V> tree, int n) {
        return this.blacken(this.doDrop(tree, n));
    }

    public Tree<K, V> take(Tree<K, V> tree, int n) {
        return this.blacken(this.doTake(tree, n));
    }

    public Tree<K, V> slice(Tree<K, V> tree, int from, int until) {
        return this.blacken(this.doSlice(tree, from, until));
    }

    public Tree<K, V> smallest(Tree<K, V> tree) {
        if (tree == null) {
            throw new NoSuchElementException("empty map");
        }
        Tree<K, V> result = tree;
        while (result.getLeft() != null) {
            result = result.getLeft();
        }
        return result;
    }

    public Tree<K, V> greatest(Tree<K, V> tree) {
        if (tree == null) {
            throw new NoSuchElementException("empty map");
        }
        Tree<K, V> result = tree;
        while (result.getRight() != null) {
            result = result.getRight();
        }
        return result;
    }

    public <U> void forEach(Tree<K, V> tree, Function<Pair<K, V>, U> f) {
        if (tree != null) {
            if (tree.getLeft() != null) {
                this.forEach(tree.getLeft(), f);
            }
            f.invoke(new Pair<K, V>(tree.getKey(this.kf), tree.getValue()));
            if (tree.getRight() != null) {
                this.forEach(tree.getRight(), f);
            }
        }
    }

    public Iterator<Pair<K, V>> iterator(Tree<K, V> tree) {
        return new EntriesIterator<K, V>(tree);
    }

    public Iterator<K> keysIterator(Tree<K, V> tree) {
        return new KeysIterator<K, V>(tree, this.kf);
    }

    public Iterator<V> valuesIterator(Tree<K, V> tree) {
        return new ValuesIterator<K, V>(tree);
    }

    private boolean isRedTree(Tree<?, ?> tree) {
        return tree != null && tree.isRed();
    }

    private boolean isBlackTree(Tree<?, ?> tree) {
        return tree != null && tree.isBlack();
    }

    private Tree<K, V> blacken(Tree<K, V> t) {
        return t == null ? null : t.black();
    }

    private Tree<K, V> mkTree(boolean isBlack, K k, V v, Tree<K, V> l, Tree<K, V> r) {
        return isBlack ? this.factory.black(k, v, l, r) : this.factory.red(k, v, l, r);
    }

    private Tree<K, V> balanceLeft(boolean isBlack, K z, V zv, Tree<K, V> l, Tree<K, V> d) {
        if (this.isRedTree(l) && this.isRedTree(l.getLeft())) {
            return this.factory.red(l.getKey(this.kf), l.getValue(), this.factory.black(l.getLeft().getKey(this.kf), l.getLeft().getValue(), l.getLeft().getLeft(), l.getLeft().getRight()), this.factory.black(z, zv, l.getRight(), d));
        }
        if (this.isRedTree(l) && this.isRedTree(l.getRight())) {
            return this.factory.red(l.getRight().getKey(this.kf), l.getRight().getValue(), this.factory.black(l.getKey(this.kf), l.getValue(), l.getLeft(), l.getRight().getLeft()), this.factory.black(z, zv, l.getRight().getRight(), d));
        }
        return this.mkTree(isBlack, z, zv, l, d);
    }

    private Tree<K, V> balanceRight(boolean isBlack, K x, V xv, Tree<K, V> a, Tree<K, V> r) {
        if (this.isRedTree(r) && this.isRedTree(r.getLeft())) {
            return this.factory.red(r.getLeft().getKey(this.kf), r.getLeft().getValue(), this.factory.black(x, xv, a, r.getLeft().getLeft()), this.factory.black(r.getKey(this.kf), r.getValue(), r.getLeft().getRight(), r.getRight()));
        }
        if (this.isRedTree(r) && this.isRedTree(r.getRight())) {
            return this.factory.red(r.getKey(this.kf), r.getValue(), this.factory.black(x, xv, a, r.getLeft()), this.factory.black(r.getRight().getKey(this.kf), r.getRight().getValue(), r.getRight().getLeft(), r.getRight().getRight()));
        }
        return this.mkTree(isBlack, x, xv, a, r);
    }

    private Tree<K, V> upd(Tree<K, V> tree, K k, V v, boolean overwrite) {
        if (tree == null) {
            return this.factory.red(k, v, null, null);
        }
        int cmp = this.ordering.compare(k, tree.getKey(this.kf));
        if (cmp < 0) {
            return this.balanceLeft(this.isBlackTree(tree), tree.getKey(this.kf), tree.getValue(), this.upd(tree.getLeft(), k, v, overwrite), tree.getRight());
        }
        if (cmp > 0) {
            return this.balanceRight(this.isBlackTree(tree), tree.getKey(this.kf), tree.getValue(), tree.getLeft(), this.upd(tree.getRight(), k, v, overwrite));
        }
        if (overwrite || !k.equals(tree.getKey(this.kf))) {
            return this.mkTree(this.isBlackTree(tree), k, v, tree.getLeft(), tree.getRight());
        }
        return tree;
    }

    private Tree<K, V> updNth(Tree<K, V> tree, int idx, K k, V v, boolean overwrite) {
        if (tree == null) {
            return this.mkTree(false, k, v, null, null);
        }
        int rank = RedBlackTree.count(tree.getLeft()) + 1;
        if (idx < rank) {
            return this.balanceLeft(this.isBlackTree(tree), tree.getKey(this.kf), tree.getValue(), this.updNth(tree.getLeft(), idx, k, v, overwrite), tree.getRight());
        }
        if (idx > rank) {
            return this.balanceRight(this.isBlackTree(tree), tree.getKey(this.kf), tree.getValue(), tree.getLeft(), this.updNth(tree.getRight(), idx - rank, k, v, overwrite));
        }
        if (overwrite) {
            return this.mkTree(this.isBlackTree(tree), k, v, tree.getLeft(), tree.getRight());
        }
        return tree;
    }

    private Tree<K, V> del(Tree<K, V> tree, K k) {
        if (tree == null) {
            return null;
        }
        int cmp = this.ordering.compare(k, tree.getKey(this.kf));
        if (cmp < 0) {
            return this.delLeft(tree, k);
        }
        if (cmp > 0) {
            return this.delRight(tree, k);
        }
        return this.append(tree.getLeft(), tree.getRight());
    }

    private Tree<K, V> balance(K x, V xv, Tree<K, V> tl, Tree<K, V> tr) {
        if (this.isRedTree(tl)) {
            if (this.isRedTree(tr)) {
                return this.factory.red(x, xv, tl.black(), tr.black());
            }
            if (this.isRedTree(tl.getLeft())) {
                return this.factory.red(tl.getKey(this.kf), tl.getValue(), tl.getLeft().black(), this.factory.black(x, xv, tl.getRight(), tr));
            }
            if (this.isRedTree(tl.getRight())) {
                return this.factory.red(tl.getRight().getKey(this.kf), tl.getRight().getValue(), this.factory.black(tl.getKey(this.kf), tl.getValue(), tl.getLeft(), tl.getRight().getLeft()), this.factory.black(x, xv, tl.getRight().getRight(), tr));
            }
            return this.factory.black(x, xv, tl, tr);
        }
        if (this.isRedTree(tr)) {
            if (this.isRedTree(tr.getRight())) {
                return this.factory.red(tr.getKey(this.kf), tr.getValue(), this.factory.black(x, xv, tl, tr.getLeft()), tr.getRight().black());
            }
            if (this.isRedTree(tr.getLeft())) {
                return this.factory.red(tr.getLeft().getKey(this.kf), tr.getLeft().getValue(), this.factory.black(x, xv, tl, tr.getLeft().getLeft()), this.factory.black(tr.getKey(this.kf), tr.getValue(), tr.getLeft().getRight(), tr.getRight()));
            }
            return this.factory.black(x, xv, tl, tr);
        }
        return this.factory.black(x, xv, tl, tr);
    }

    private Tree<K, V> subl(Tree<K, V> t) {
        if (this.isBlackTree(t)) {
            return t.red();
        }
        throw new RuntimeException("Defect: invariance violation; expected black, got " + t);
    }

    private Tree<K, V> balLeft(K x, V xv, Tree<K, V> tl, Tree<K, V> tr) {
        if (this.isRedTree(tl)) {
            return this.factory.red(x, xv, tl.black(), tr);
        }
        if (this.isBlackTree(tr)) {
            return this.balance(x, xv, tl, tr.red());
        }
        if (this.isRedTree(tr) && this.isBlackTree(tr.getLeft())) {
            return this.factory.red(tr.getLeft().getKey(this.kf), tr.getLeft().getValue(), this.factory.black(x, xv, tl, tr.getLeft().getLeft()), this.balance(tr.getKey(this.kf), tr.getValue(), tr.getLeft().getRight(), this.subl(tr.getRight())));
        }
        throw new RuntimeException("Defect: invariance violation");
    }

    private Tree<K, V> balRight(K x, V xv, Tree<K, V> tl, Tree<K, V> tr) {
        if (this.isRedTree(tr)) {
            return this.factory.red(x, xv, tl, tr.black());
        }
        if (this.isBlackTree(tl)) {
            return this.balance(x, xv, tl.red(), tr);
        }
        if (this.isRedTree(tl) && this.isBlackTree(tl.getRight())) {
            return this.factory.red(tl.getRight().getKey(this.kf), tl.getRight().getValue(), this.balance(tl.getKey(this.kf), tl.getValue(), this.subl(tl.getLeft()), tl.getRight().getLeft()), this.factory.black(x, xv, tl.getRight().getRight(), tr));
        }
        throw new RuntimeException("Defect: invariance violation");
    }

    private Tree<K, V> delLeft(Tree<K, V> tree, K k) {
        return this.isBlackTree(tree.getLeft()) ? this.balLeft(tree.getKey(this.kf), tree.getValue(), this.del(tree.getLeft(), k), tree.getRight()) : this.factory.red(tree.getKey(this.kf), tree.getValue(), this.del(tree.getLeft(), k), tree.getRight());
    }

    private Tree<K, V> delRight(Tree<K, V> tree, K k) {
        return this.isBlackTree(tree.getRight()) ? this.balRight(tree.getKey(this.kf), tree.getValue(), tree.getLeft(), this.del(tree.getRight(), k)) : this.factory.red(tree.getKey(this.kf), tree.getValue(), tree.getLeft(), this.del(tree.getRight(), k));
    }

    public Tree<K, V> append(Tree<K, V> tl, Tree<K, V> tr) {
        if (tl == null) {
            return tr;
        }
        if (tr == null) {
            return tl;
        }
        if (this.isRedTree(tl) && this.isRedTree(tr)) {
            Tree<K, V> bc = this.append(tl.getRight(), tr.getLeft());
            if (this.isRedTree(bc)) {
                return this.factory.red(bc.getKey(this.kf), bc.getValue(), this.factory.red(tl.getKey(this.kf), tl.getValue(), tl.getLeft(), bc.getLeft()), this.factory.red(tr.getKey(this.kf), tr.getValue(), bc.getRight(), tr.getRight()));
            }
            return this.factory.red(tl.getKey(this.kf), tl.getValue(), tl.getLeft(), this.factory.red(tr.getKey(this.kf), tr.getValue(), bc, tr.getRight()));
        }
        if (this.isBlackTree(tl) && this.isBlackTree(tr)) {
            Tree<K, V> bc = this.append(tl.getRight(), tr.getLeft());
            if (this.isRedTree(bc)) {
                return this.factory.red(bc.getKey(this.kf), bc.getValue(), this.factory.black(tl.getKey(this.kf), tl.getValue(), tl.getLeft(), bc.getLeft()), this.factory.black(tr.getKey(this.kf), tr.getValue(), bc.getRight(), tr.getRight()));
            }
            return this.balLeft(tl.getKey(this.kf), tl.getValue(), tl.getLeft(), this.factory.black(tr.getKey(this.kf), tr.getValue(), bc, tr.getRight()));
        }
        if (this.isRedTree(tr)) {
            return this.factory.red(tr.getKey(this.kf), tr.getValue(), this.append(tl, tr.getLeft()), tr.getRight());
        }
        if (this.isRedTree(tl)) {
            return this.factory.red(tl.getKey(this.kf), tl.getValue(), tl.getLeft(), this.append(tl.getRight(), tr));
        }
        throw new RuntimeException("unmatched tree on append: " + tl + ", " + tr);
    }

    private Tree<K, V> doFrom(Tree<K, V> tree, K from, boolean inclusive) {
        Tree<K, V> newLeft;
        if (tree == null) {
            return null;
        }
        if (inclusive) {
            if (this.ordering.compare(tree.getKey(this.kf), from) < 0) {
                return this.doFrom(tree.getRight(), from, true);
            }
        } else if (this.ordering.compare(tree.getKey(this.kf), from) <= 0) {
            return this.doFrom(tree.getRight(), from, false);
        }
        if ((newLeft = this.doFrom(tree.getLeft(), from, inclusive)) != null && newLeft.equals(tree.getLeft())) {
            return tree;
        }
        if (newLeft == null) {
            return this.upd(tree.getRight(), tree.getKey(this.kf), tree.getValue(), false);
        }
        return this.rebalance(tree, newLeft, tree.getRight());
    }

    private Tree<K, V> doUntil(Tree<K, V> tree, K until, boolean inclusive) {
        Tree<K, V> newRight;
        if (tree == null) {
            return null;
        }
        if (inclusive) {
            if (this.ordering.compare(until, tree.getKey(this.kf)) < 0) {
                return this.doUntil(tree.getLeft(), until, true);
            }
        } else if (this.ordering.compare(until, tree.getKey(this.kf)) <= 0) {
            return this.doUntil(tree.getLeft(), until, false);
        }
        if ((newRight = this.doUntil(tree.getRight(), until, inclusive)) != null && newRight.equals(tree.getRight())) {
            return tree;
        }
        if (newRight == null) {
            return this.upd(tree.getLeft(), tree.getKey(this.kf), tree.getValue(), false);
        }
        return this.rebalance(tree, tree.getLeft(), newRight);
    }

    private Tree<K, V> doRange(Tree<K, V> tree, K from, boolean fromInclusive, K until, boolean untilInclusive) {
        if (tree == null) {
            return null;
        }
        if (fromInclusive) {
            if (this.ordering.compare(tree.getKey(this.kf), from) < 0) {
                return this.doRange(tree.getRight(), from, true, until, untilInclusive);
            }
        } else if (this.ordering.compare(tree.getKey(this.kf), from) <= 0) {
            return this.doRange(tree.getRight(), from, false, until, untilInclusive);
        }
        if (untilInclusive) {
            if (this.ordering.compare(until, tree.getKey(this.kf)) < 0) {
                return this.doRange(tree.getLeft(), from, fromInclusive, until, true);
            }
        } else if (this.ordering.compare(until, tree.getKey(this.kf)) <= 0) {
            return this.doRange(tree.getLeft(), from, fromInclusive, until, false);
        }
        Tree<K, V> newLeft = this.doFrom(tree.getLeft(), from, fromInclusive);
        Tree<K, V> newRight = this.doUntil(tree.getRight(), until, untilInclusive);
        if (newLeft == tree.getLeft() && newRight == tree.getRight()) {
            return tree;
        }
        if (newLeft == null) {
            return this.upd(newRight, tree.getKey(this.kf), tree.getValue(), false);
        }
        if (newRight == null) {
            return this.upd(newLeft, tree.getKey(this.kf), tree.getValue(), false);
        }
        return this.rebalance(tree, newLeft, newRight);
    }

    private Tree<K, V> doDrop(Tree<K, V> tree, int n) {
        if (n <= 0) {
            return tree;
        }
        if (n >= RedBlackTree.count(tree)) {
            return null;
        }
        int count = RedBlackTree.count(tree.getLeft());
        if (n > count) {
            return this.doDrop(tree.getRight(), n - count - 1);
        }
        Tree<K, V> newLeft = this.doDrop(tree.getLeft(), n);
        if (newLeft == tree.getLeft()) {
            return tree;
        }
        if (newLeft == null) {
            return this.updNth(tree.getRight(), n - count - 1, tree.getKey(this.kf), tree.getValue(), false);
        }
        return this.rebalance(tree, newLeft, tree.getRight());
    }

    private Tree<K, V> doTake(Tree<K, V> tree, int n) {
        if (n <= 0) {
            return null;
        }
        if (n >= RedBlackTree.count(tree)) {
            return tree;
        }
        int count = RedBlackTree.count(tree.getLeft());
        if (n <= count) {
            return this.doTake(tree.getLeft(), n);
        }
        Tree<K, V> newRight = this.doTake(tree.getRight(), n - count - 1);
        if (newRight == tree.getRight()) {
            return tree;
        }
        if (newRight == null) {
            return this.updNth(tree.getLeft(), n, tree.getKey(this.kf), tree.getValue(), false);
        }
        return this.rebalance(tree, tree.getLeft(), newRight);
    }

    private Tree<K, V> doSlice(Tree<K, V> tree, int from, int until) {
        if (tree == null) {
            return null;
        }
        int count = RedBlackTree.count(tree.getLeft());
        if (from > count) {
            return this.doSlice(tree.getRight(), from - count - 1, until - count - 1);
        }
        if (until <= count) {
            return this.doSlice(tree.getLeft(), from, until);
        }
        Tree<K, V> newLeft = this.doDrop(tree.getLeft(), from);
        Tree<K, V> newRight = this.doTake(tree.getRight(), until - count - 1);
        if (newLeft == tree.getLeft() && newRight == tree.getRight()) {
            return tree;
        }
        if (newLeft == null) {
            return this.updNth(newRight, from - count - 1, tree.getKey(this.kf), tree.getValue(), false);
        }
        if (newRight == null) {
            return this.updNth(newLeft, until, tree.getKey(this.kf), tree.getValue(), false);
        }
        return this.rebalance(tree, newLeft, newRight);
    }

    private Zipper<K, V> compareDepth(Tree<K, V> left, Tree<K, V> right) {
        return this.unzipBoth(left, right, Collections.EMPTY_LIST, Collections.EMPTY_LIST, 0);
    }

    private List<Tree<K, V>> unzip(List<Tree<K, V>> zipper, boolean leftMost) {
        Tree<K, V> next;
        Tree<K, V> tree = next = leftMost ? zipper.get(0).getLeft() : zipper.get(0).getRight();
        if (next == null) {
            return zipper;
        }
        return this.unzip(this.cons(next, zipper), leftMost);
    }

    private <E> List<E> cons(E value, List<E> list) {
        ArrayList<E> result = new ArrayList<E>(list.size() + 1);
        result.add(value);
        result.addAll(list);
        return result;
    }

    private Zipper<K, V> unzipBoth(Tree<K, V> left, Tree<K, V> right, List<Tree<K, V>> leftZipper, List<Tree<K, V>> rightZipper, int smallerDepth) {
        if (this.isBlackTree(left) && this.isBlackTree(right)) {
            return this.unzipBoth(left.getRight(), right.getLeft(), this.cons(left, leftZipper), this.cons(right, rightZipper), smallerDepth + 1);
        }
        if (this.isRedTree(left) && this.isRedTree(right)) {
            return this.unzipBoth(left.getRight(), right.getLeft(), this.cons(left, leftZipper), this.cons(right, rightZipper), smallerDepth);
        }
        if (this.isRedTree(right)) {
            return this.unzipBoth(left, right.getLeft(), leftZipper, this.cons(right, rightZipper), smallerDepth);
        }
        if (this.isRedTree(left)) {
            return this.unzipBoth(left.getRight(), right, this.cons(left, leftZipper), rightZipper, smallerDepth);
        }
        if (left == null && right == null) {
            return new Zipper(Collections.EMPTY_LIST, true, false, smallerDepth);
        }
        if (left == null && this.isBlackTree(right)) {
            return new Zipper<K, V>(this.unzip(this.cons(right, rightZipper), true), false, true, smallerDepth);
        }
        if (this.isBlackTree(left) && right == null) {
            return new Zipper<K, V>(this.unzip(this.cons(left, leftZipper), false), false, false, smallerDepth);
        }
        throw new RuntimeException("unmatched trees in unzip: " + left + ", " + right);
    }

    private List<Tree<K, V>> findDepth(List<Tree<K, V>> zipper, int depth) {
        if (zipper.isEmpty()) {
            throw new RuntimeException("Defect: unexpected empty zipper while computing range");
        }
        if (this.isBlackTree(zipper.get(0))) {
            return depth <= 1 ? zipper : this.findDepth(zipper.subList(1, zipper.size()), depth - 1);
        }
        return this.findDepth(zipper.subList(1, zipper.size()), depth);
    }

    private Tree<K, V> rebalance(Tree<K, V> tree, Tree<K, V> newLeft, Tree<K, V> newRight) {
        Tree<K, V> blkNewLeft = this.blacken(newLeft);
        Tree<K, V> blkNewRight = this.blacken(newRight);
        Zipper<K, V> zipper = this.compareDepth(blkNewLeft, blkNewRight);
        if (zipper.levelled) {
            return this.factory.black(tree.getKey(this.kf), tree.getValue(), blkNewLeft, blkNewRight);
        }
        List zipFrom = this.findDepth(zipper.zipper, zipper.smallerDepth);
        Tree<K, V> result = zipper.leftMost ? this.factory.red(tree.getKey(this.kf), tree.getValue(), blkNewLeft, zipFrom.get(0)) : this.factory.red(tree.getKey(this.kf), tree.getValue(), zipFrom.get(0), blkNewRight);
        for (Tree<K, V> node : zipFrom.subList(1, zipFrom.size())) {
            if (zipper.leftMost) {
                result = this.balanceLeft(this.isBlackTree(node), node.getKey(this.kf), node.getValue(), result, node.getRight());
                continue;
            }
            result = this.balanceRight(this.isBlackTree(node), node.getKey(this.kf), node.getValue(), node.getLeft(), result);
        }
        return result;
    }
}

