/* GPhoto.c generated by valac 0.36.6, the Vala compiler
 * generated from GPhoto.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gphoto2/gphoto2-context.h>
#include <gphoto.h>
#include <gphoto2/gphoto2-camera.h>
#include <gphoto2/gphoto2-filesys.h>
#include <gphoto2/gphoto2-result.h>
#include <gphoto2/gphoto2-port-result.h>
#include <gphoto2/gphoto2-file.h>
#include <gphoto2/gphoto2-port-info-list.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <fcntl.h>
#include <sys/types.h>
#include <errno.h>
#include <gobject/gvaluecollector.h>


#define GP_TYPE_CONTEXT_WRAPPER (gp_context_wrapper_get_type ())
#define GP_CONTEXT_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GP_TYPE_CONTEXT_WRAPPER, GPContextWrapper))
#define GP_CONTEXT_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GP_TYPE_CONTEXT_WRAPPER, GPContextWrapperClass))
#define GP_IS_CONTEXT_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GP_TYPE_CONTEXT_WRAPPER))
#define GP_IS_CONTEXT_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GP_TYPE_CONTEXT_WRAPPER))
#define GP_CONTEXT_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GP_TYPE_CONTEXT_WRAPPER, GPContextWrapperClass))

typedef struct _GPContextWrapper GPContextWrapper;
typedef struct _GPContextWrapperClass GPContextWrapperClass;
typedef struct _GPContextWrapperPrivate GPContextWrapperPrivate;
#define _gp_context_unref0(var) ((var == NULL) ? NULL : (var = (gp_context_unref (var), NULL)))
typedef struct _GPParamSpecContextWrapper GPParamSpecContextWrapper;

#define GP_TYPE_SPIN_IDLE_WRAPPER (gp_spin_idle_wrapper_get_type ())
#define GP_SPIN_IDLE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GP_TYPE_SPIN_IDLE_WRAPPER, GPSpinIdleWrapper))
#define GP_SPIN_IDLE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GP_TYPE_SPIN_IDLE_WRAPPER, GPSpinIdleWrapperClass))
#define GP_IS_SPIN_IDLE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GP_TYPE_SPIN_IDLE_WRAPPER))
#define GP_IS_SPIN_IDLE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GP_TYPE_SPIN_IDLE_WRAPPER))
#define GP_SPIN_IDLE_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GP_TYPE_SPIN_IDLE_WRAPPER, GPSpinIdleWrapperClass))

typedef struct _GPSpinIdleWrapper GPSpinIdleWrapper;
typedef struct _GPSpinIdleWrapperClass GPSpinIdleWrapperClass;
typedef struct _GPSpinIdleWrapperPrivate GPSpinIdleWrapperPrivate;

#define TYPE_MEDIA_METADATA (media_metadata_get_type ())
#define MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_METADATA, MediaMetadata))
#define MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_METADATA, MediaMetadataClass))
#define IS_MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_METADATA))
#define IS_MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_METADATA))
#define MEDIA_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_METADATA, MediaMetadataClass))

typedef struct _MediaMetadata MediaMetadata;
typedef struct _MediaMetadataClass MediaMetadataClass;

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))

#define TYPE_PHOTO_PREVIEW (photo_preview_get_type ())
#define PHOTO_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_PREVIEW, PhotoPreview))
#define PHOTO_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_PREVIEW, PhotoPreviewClass))
#define IS_PHOTO_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_PREVIEW))
#define IS_PHOTO_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_PREVIEW))
#define PHOTO_PREVIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_PREVIEW, PhotoPreviewClass))

typedef struct _PhotoPreview PhotoPreview;
typedef struct _PhotoPreviewClass PhotoPreviewClass;
#define _photo_preview_unref0(var) ((var == NULL) ? NULL : (var = (photo_preview_unref (var), NULL)))
#define _gp_file_unref0(var) ((var == NULL) ? NULL : (var = (gp_file_unref (var), NULL)))

typedef enum  {
	GPHOTO_ERROR_LIBRARY
} GPhotoError;
#define GPHOTO_ERROR gphoto_error_quark ()
struct _GPContextWrapper {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GPContextWrapperPrivate * priv;
	GPContext* context;
};

struct _GPContextWrapperClass {
	GTypeClass parent_class;
	void (*finalize) (GPContextWrapper *self);
	void (*idle) (GPContextWrapper* self);
	void (*error) (GPContextWrapper* self, const gchar* text, void* data);
	void (*status) (GPContextWrapper* self, const gchar* text, void* data);
	void (*message) (GPContextWrapper* self, const gchar* text, void* data);
	void (*progress_start) (GPContextWrapper* self, gfloat current, const gchar* text, void* data);
	void (*progress_update) (GPContextWrapper* self, gfloat current, void* data);
	void (*progress_stop) (GPContextWrapper* self);
};

struct _GPParamSpecContextWrapper {
	GParamSpec parent_instance;
};

struct _GPSpinIdleWrapper {
	GPContextWrapper parent_instance;
	GPSpinIdleWrapperPrivate * priv;
};

struct _GPSpinIdleWrapperClass {
	GPContextWrapperClass parent_class;
};


static gpointer gp_context_wrapper_parent_class = NULL;
static gpointer gp_spin_idle_wrapper_parent_class = NULL;

GQuark gphoto_error_quark (void);
gpointer gp_context_wrapper_ref (gpointer instance);
void gp_context_wrapper_unref (gpointer instance);
GParamSpec* gp_param_spec_context_wrapper (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gp_value_set_context_wrapper (GValue* value, gpointer v_object);
void gp_value_take_context_wrapper (GValue* value, gpointer v_object);
gpointer gp_value_get_context_wrapper (const GValue* value);
GType gp_context_wrapper_get_type (void) G_GNUC_CONST;
enum  {
	GP_CONTEXT_WRAPPER_DUMMY_PROPERTY
};
GPContextWrapper* gp_context_wrapper_new (void);
GPContextWrapper* gp_context_wrapper_construct (GType object_type);
static void gp_context_wrapper_on_idle (GPContextWrapper* self, GPContext* context);
static void _gp_context_wrapper_on_idle_gp_context_idle_func (GPContext* context, gpointer self);
static void gp_context_wrapper_on_error (GPContextWrapper* self, GPContext* context, const gchar* text);
static void _gp_context_wrapper_on_error_gp_context_error_func (GPContext* context, const gchar* text, gpointer self);
static void gp_context_wrapper_on_status (GPContextWrapper* self, GPContext* context, const gchar* text);
static void _gp_context_wrapper_on_status_gp_context_status_func (GPContext* context, const gchar* text, gpointer self);
static void gp_context_wrapper_on_message (GPContextWrapper* self, GPContext* context, const gchar* text);
static void _gp_context_wrapper_on_message_gp_context_message_func (GPContext* context, const gchar* text, gpointer self);
static guint gp_context_wrapper_on_progress_start (GPContextWrapper* self, GPContext* context, gfloat target, const gchar* text);
static guint _gp_context_wrapper_on_progress_start_gp_context_progress_start_func (GPContext* context, gfloat target, const gchar* text, gpointer self);
static void gp_context_wrapper_on_progress_update (GPContextWrapper* self, GPContext* context, guint id, gfloat current);
static void _gp_context_wrapper_on_progress_update_gp_context_progress_update_func (GPContext* context, guint id, gfloat current, gpointer self);
static void gp_context_wrapper_on_progress_stop (GPContextWrapper* self, GPContext* context, guint id);
static void _gp_context_wrapper_on_progress_stop_gp_context_progress_stop_func (GPContext* context, guint id, gpointer self);
void gp_context_wrapper_idle (GPContextWrapper* self);
static void gp_context_wrapper_real_idle (GPContextWrapper* self);
void gp_context_wrapper_error (GPContextWrapper* self, const gchar* text, void* data);
static void gp_context_wrapper_real_error (GPContextWrapper* self, const gchar* text, void* data);
void gp_context_wrapper_status (GPContextWrapper* self, const gchar* text, void* data);
static void gp_context_wrapper_real_status (GPContextWrapper* self, const gchar* text, void* data);
void gp_context_wrapper_message (GPContextWrapper* self, const gchar* text, void* data);
static void gp_context_wrapper_real_message (GPContextWrapper* self, const gchar* text, void* data);
void gp_context_wrapper_progress_start (GPContextWrapper* self, gfloat current, const gchar* text, void* data);
static void gp_context_wrapper_real_progress_start (GPContextWrapper* self, gfloat current, const gchar* text, void* data);
void gp_context_wrapper_progress_update (GPContextWrapper* self, gfloat current, void* data);
static void gp_context_wrapper_real_progress_update (GPContextWrapper* self, gfloat current, void* data);
void gp_context_wrapper_progress_stop (GPContextWrapper* self);
static void gp_context_wrapper_real_progress_stop (GPContextWrapper* self);
static void gp_context_wrapper_finalize (GPContextWrapper * obj);
GType gp_spin_idle_wrapper_get_type (void) G_GNUC_CONST;
enum  {
	GP_SPIN_IDLE_WRAPPER_DUMMY_PROPERTY
};
GPSpinIdleWrapper* gp_spin_idle_wrapper_new (void);
GPSpinIdleWrapper* gp_spin_idle_wrapper_construct (GType object_type);
static void gp_spin_idle_wrapper_real_idle (GPContextWrapper* base);
void spin_event_loop (void);
static void gp_spin_idle_wrapper_real_progress_update (GPContextWrapper* base, gfloat current, void* data);
#define GP_MAX_FILENAME_LENGTH 63
#define GP_MAX_BASEDIR_LENGTH 255
gboolean gp_get_info (GPContext* context, Camera* camera, const gchar* folder, const gchar* filename, CameraFileInfo* info, GError** error);
GBytes* gp_camera_file_to_bytes (GPContext* context, CameraFile* file);
gpointer media_metadata_ref (gpointer instance);
void media_metadata_unref (gpointer instance);
GParamSpec* param_spec_media_metadata (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_media_metadata (GValue* value, gpointer v_object);
void value_take_media_metadata (GValue* value, gpointer v_object);
gpointer value_get_media_metadata (const GValue* value);
GType media_metadata_get_type (void) G_GNUC_CONST;
GType photo_metadata_get_type (void) G_GNUC_CONST;
PhotoMetadata* gp_get_fallback_metadata (Camera* camera, GPContext* context, const gchar* folder, const gchar* filename);
PhotoMetadata* photo_metadata_new (void);
PhotoMetadata* photo_metadata_construct (GType object_type);
void media_metadata_read_from_file (MediaMetadata* self, GFile* file, GError** error);
GdkPixbuf* gp_load_preview (GPContext* context, Camera* camera, const gchar* folder, const gchar* filename, gchar* * preview_md5, GError** error);
GBytes* gp_load_file_into_buffer (GPContext* context, Camera* camera, const gchar* folder, const gchar* filename, CameraFileType filetype, GError** error);
guint photo_metadata_get_preview_count (PhotoMetadata* self);
gpointer photo_preview_ref (gpointer instance);
void photo_preview_unref (gpointer instance);
GParamSpec* param_spec_photo_preview (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_preview (GValue* value, gpointer v_object);
void value_take_photo_preview (GValue* value, gpointer v_object);
gpointer value_get_photo_preview (const GValue* value);
GType photo_preview_get_type (void) G_GNUC_CONST;
PhotoPreview* photo_metadata_get_preview (PhotoMetadata* self, guint number);
GBytes* photo_preview_flatten (PhotoPreview* self, GError** error);
#define IMPORT_PREVIEW_MAX_SCALE 128
GdkPixbuf* gp_load_image (GPContext* context, Camera* camera, const gchar* folder, const gchar* filename, GError** error);
GInputStream* gp_load_file_into_stream (GPContext* context, Camera* camera, const gchar* folder, const gchar* filename, CameraFileType filetype, GError** error);
void gp_save_image (GPContext* context, Camera* camera, const gchar* folder, const gchar* filename, GFile* dest_file, GError** error);
PhotoMetadata* gp_load_metadata (GPContext* context, Camera* camera, const gchar* folder, const gchar* filename, GError** error);
void photo_metadata_read_from_app1_segment (PhotoMetadata* self, GBytes* buffer, GError** error);
GFile* app_dirs_get_temp_dir (void);


GQuark gphoto_error_quark (void) {
	return g_quark_from_static_string ("gphoto_error-quark");
}


static void _gp_context_wrapper_on_idle_gp_context_idle_func (GPContext* context, gpointer self) {
#line 18 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_on_idle ((GPContextWrapper*) self, context);
#line 229 "GPhoto.c"
}


static void _gp_context_wrapper_on_error_gp_context_error_func (GPContext* context, const gchar* text, gpointer self) {
#line 19 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_on_error ((GPContextWrapper*) self, context, text);
#line 236 "GPhoto.c"
}


static void _gp_context_wrapper_on_status_gp_context_status_func (GPContext* context, const gchar* text, gpointer self) {
#line 20 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_on_status ((GPContextWrapper*) self, context, text);
#line 243 "GPhoto.c"
}


static void _gp_context_wrapper_on_message_gp_context_message_func (GPContext* context, const gchar* text, gpointer self) {
#line 21 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_on_message ((GPContextWrapper*) self, context, text);
#line 250 "GPhoto.c"
}


static guint _gp_context_wrapper_on_progress_start_gp_context_progress_start_func (GPContext* context, gfloat target, const gchar* text, gpointer self) {
	guint result;
	result = gp_context_wrapper_on_progress_start ((GPContextWrapper*) self, context, target, text);
#line 22 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return result;
#line 259 "GPhoto.c"
}


static void _gp_context_wrapper_on_progress_update_gp_context_progress_update_func (GPContext* context, guint id, gfloat current, gpointer self) {
#line 22 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_on_progress_update ((GPContextWrapper*) self, context, id, current);
#line 266 "GPhoto.c"
}


static void _gp_context_wrapper_on_progress_stop_gp_context_progress_stop_func (GPContext* context, guint id, gpointer self) {
#line 22 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_on_progress_stop ((GPContextWrapper*) self, context, id);
#line 273 "GPhoto.c"
}


GPContextWrapper* gp_context_wrapper_construct (GType object_type) {
	GPContextWrapper* self = NULL;
	GPContext* _tmp0_;
	GPContext* _tmp1_;
	GPContext* _tmp2_;
	GPContext* _tmp3_;
	GPContext* _tmp4_;
#line 17 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	self = (GPContextWrapper*) g_type_create_instance (object_type);
#line 18 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp0_ = self->context;
#line 18 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_set_idle_func (_tmp0_, _gp_context_wrapper_on_idle_gp_context_idle_func, self);
#line 19 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp1_ = self->context;
#line 19 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_set_error_func (_tmp1_, _gp_context_wrapper_on_error_gp_context_error_func, self);
#line 20 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp2_ = self->context;
#line 20 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_set_status_func (_tmp2_, _gp_context_wrapper_on_status_gp_context_status_func, self);
#line 21 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp3_ = self->context;
#line 21 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_set_message_func (_tmp3_, _gp_context_wrapper_on_message_gp_context_message_func, self);
#line 22 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp4_ = self->context;
#line 22 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_set_progress_funcs (_tmp4_, _gp_context_wrapper_on_progress_start_gp_context_progress_start_func, _gp_context_wrapper_on_progress_update_gp_context_progress_update_func, _gp_context_wrapper_on_progress_stop_gp_context_progress_stop_func, self);
#line 17 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return self;
#line 308 "GPhoto.c"
}


GPContextWrapper* gp_context_wrapper_new (void) {
#line 17 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return gp_context_wrapper_construct (GP_TYPE_CONTEXT_WRAPPER);
#line 315 "GPhoto.c"
}


static void gp_context_wrapper_real_idle (GPContextWrapper* self) {
}


void gp_context_wrapper_idle (GPContextWrapper* self) {
#line 25 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 25 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	GP_CONTEXT_WRAPPER_GET_CLASS (self)->idle (self);
#line 328 "GPhoto.c"
}


static void gp_context_wrapper_real_error (GPContextWrapper* self, const gchar* text, void* data) {
#line 28 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (text != NULL);
#line 335 "GPhoto.c"
}


void gp_context_wrapper_error (GPContextWrapper* self, const gchar* text, void* data) {
#line 28 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 28 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	GP_CONTEXT_WRAPPER_GET_CLASS (self)->error (self, text, data);
#line 344 "GPhoto.c"
}


static void gp_context_wrapper_real_status (GPContextWrapper* self, const gchar* text, void* data) {
#line 31 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (text != NULL);
#line 351 "GPhoto.c"
}


void gp_context_wrapper_status (GPContextWrapper* self, const gchar* text, void* data) {
#line 31 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 31 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	GP_CONTEXT_WRAPPER_GET_CLASS (self)->status (self, text, data);
#line 360 "GPhoto.c"
}


static void gp_context_wrapper_real_message (GPContextWrapper* self, const gchar* text, void* data) {
#line 34 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (text != NULL);
#line 367 "GPhoto.c"
}


void gp_context_wrapper_message (GPContextWrapper* self, const gchar* text, void* data) {
#line 34 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 34 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	GP_CONTEXT_WRAPPER_GET_CLASS (self)->message (self, text, data);
#line 376 "GPhoto.c"
}


static void gp_context_wrapper_real_progress_start (GPContextWrapper* self, gfloat current, const gchar* text, void* data) {
#line 37 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (text != NULL);
#line 383 "GPhoto.c"
}


void gp_context_wrapper_progress_start (GPContextWrapper* self, gfloat current, const gchar* text, void* data) {
#line 37 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 37 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	GP_CONTEXT_WRAPPER_GET_CLASS (self)->progress_start (self, current, text, data);
#line 392 "GPhoto.c"
}


static void gp_context_wrapper_real_progress_update (GPContextWrapper* self, gfloat current, void* data) {
}


void gp_context_wrapper_progress_update (GPContextWrapper* self, gfloat current, void* data) {
#line 40 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 40 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	GP_CONTEXT_WRAPPER_GET_CLASS (self)->progress_update (self, current, data);
#line 405 "GPhoto.c"
}


static void gp_context_wrapper_real_progress_stop (GPContextWrapper* self) {
}


void gp_context_wrapper_progress_stop (GPContextWrapper* self) {
#line 43 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 43 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	GP_CONTEXT_WRAPPER_GET_CLASS (self)->progress_stop (self);
#line 418 "GPhoto.c"
}


static void gp_context_wrapper_on_idle (GPContextWrapper* self, GPContext* context) {
#line 46 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 46 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (context != NULL);
#line 47 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_idle (self);
#line 429 "GPhoto.c"
}


static void gp_context_wrapper_on_error (GPContextWrapper* self, GPContext* context, const gchar* text) {
	const gchar* _tmp0_;
#line 50 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 50 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (context != NULL);
#line 50 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (text != NULL);
#line 51 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp0_ = text;
#line 51 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_error (self, _tmp0_, NULL);
#line 445 "GPhoto.c"
}


static void gp_context_wrapper_on_status (GPContextWrapper* self, GPContext* context, const gchar* text) {
	const gchar* _tmp0_;
#line 54 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 54 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (context != NULL);
#line 54 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (text != NULL);
#line 55 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp0_ = text;
#line 55 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_status (self, _tmp0_, NULL);
#line 461 "GPhoto.c"
}


static void gp_context_wrapper_on_message (GPContextWrapper* self, GPContext* context, const gchar* text) {
	const gchar* _tmp0_;
#line 58 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 58 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (context != NULL);
#line 58 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (text != NULL);
#line 59 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp0_ = text;
#line 59 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_message (self, _tmp0_, NULL);
#line 477 "GPhoto.c"
}


static guint gp_context_wrapper_on_progress_start (GPContextWrapper* self, GPContext* context, gfloat target, const gchar* text) {
	guint result = 0U;
	gfloat _tmp0_;
	const gchar* _tmp1_;
#line 62 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (GP_IS_CONTEXT_WRAPPER (self), 0U);
#line 62 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (context != NULL, 0U);
#line 62 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (text != NULL, 0U);
#line 63 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp0_ = target;
#line 63 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp1_ = text;
#line 63 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_progress_start (self, _tmp0_, _tmp1_, NULL);
#line 65 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	result = (guint) 0;
#line 65 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return result;
#line 501 "GPhoto.c"
}


static void gp_context_wrapper_on_progress_update (GPContextWrapper* self, GPContext* context, guint id, gfloat current) {
	gfloat _tmp0_;
#line 68 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 68 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (context != NULL);
#line 69 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp0_ = current;
#line 69 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_progress_update (self, _tmp0_, NULL);
#line 515 "GPhoto.c"
}


static void gp_context_wrapper_on_progress_stop (GPContextWrapper* self, GPContext* context, guint id) {
#line 72 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 72 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (context != NULL);
#line 73 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_progress_stop (self);
#line 526 "GPhoto.c"
}


static void gp_value_context_wrapper_init (GValue* value) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	value->data[0].v_pointer = NULL;
#line 533 "GPhoto.c"
}


static void gp_value_context_wrapper_free_value (GValue* value) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (value->data[0].v_pointer) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		gp_context_wrapper_unref (value->data[0].v_pointer);
#line 542 "GPhoto.c"
	}
}


static void gp_value_context_wrapper_copy_value (const GValue* src_value, GValue* dest_value) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (src_value->data[0].v_pointer) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		dest_value->data[0].v_pointer = gp_context_wrapper_ref (src_value->data[0].v_pointer);
#line 552 "GPhoto.c"
	} else {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		dest_value->data[0].v_pointer = NULL;
#line 556 "GPhoto.c"
	}
}


static gpointer gp_value_context_wrapper_peek_pointer (const GValue* value) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return value->data[0].v_pointer;
#line 564 "GPhoto.c"
}


static gchar* gp_value_context_wrapper_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (collect_values[0].v_pointer) {
#line 571 "GPhoto.c"
		GPContextWrapper * object;
		object = collect_values[0].v_pointer;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		if (object->parent_instance.g_class == NULL) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 578 "GPhoto.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 582 "GPhoto.c"
		}
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		value->data[0].v_pointer = gp_context_wrapper_ref (object);
#line 586 "GPhoto.c"
	} else {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		value->data[0].v_pointer = NULL;
#line 590 "GPhoto.c"
	}
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return NULL;
#line 594 "GPhoto.c"
}


static gchar* gp_value_context_wrapper_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GPContextWrapper ** object_p;
	object_p = collect_values[0].v_pointer;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (!object_p) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 605 "GPhoto.c"
	}
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (!value->data[0].v_pointer) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		*object_p = NULL;
#line 611 "GPhoto.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		*object_p = value->data[0].v_pointer;
#line 615 "GPhoto.c"
	} else {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		*object_p = gp_context_wrapper_ref (value->data[0].v_pointer);
#line 619 "GPhoto.c"
	}
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return NULL;
#line 623 "GPhoto.c"
}


GParamSpec* gp_param_spec_context_wrapper (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GPParamSpecContextWrapper* spec;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (g_type_is_a (object_type, GP_TYPE_CONTEXT_WRAPPER), NULL);
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return G_PARAM_SPEC (spec);
#line 637 "GPhoto.c"
}


gpointer gp_value_get_context_wrapper (const GValue* value) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GP_TYPE_CONTEXT_WRAPPER), NULL);
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return value->data[0].v_pointer;
#line 646 "GPhoto.c"
}


void gp_value_set_context_wrapper (GValue* value, gpointer v_object) {
	GPContextWrapper * old;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GP_TYPE_CONTEXT_WRAPPER));
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	old = value->data[0].v_pointer;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (v_object) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GP_TYPE_CONTEXT_WRAPPER));
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		value->data[0].v_pointer = v_object;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		gp_context_wrapper_ref (value->data[0].v_pointer);
#line 666 "GPhoto.c"
	} else {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		value->data[0].v_pointer = NULL;
#line 670 "GPhoto.c"
	}
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (old) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		gp_context_wrapper_unref (old);
#line 676 "GPhoto.c"
	}
}


void gp_value_take_context_wrapper (GValue* value, gpointer v_object) {
	GPContextWrapper * old;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GP_TYPE_CONTEXT_WRAPPER));
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	old = value->data[0].v_pointer;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (v_object) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GP_TYPE_CONTEXT_WRAPPER));
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		value->data[0].v_pointer = v_object;
#line 695 "GPhoto.c"
	} else {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		value->data[0].v_pointer = NULL;
#line 699 "GPhoto.c"
	}
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (old) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		gp_context_wrapper_unref (old);
#line 705 "GPhoto.c"
	}
}


static void gp_context_wrapper_class_init (GPContextWrapperClass * klass) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_parent_class = g_type_class_peek_parent (klass);
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	((GPContextWrapperClass *) klass)->finalize = gp_context_wrapper_finalize;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	((GPContextWrapperClass *) klass)->idle = (void (*) (GPContextWrapper *)) gp_context_wrapper_real_idle;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	((GPContextWrapperClass *) klass)->error = (void (*) (GPContextWrapper *, const gchar*, void*)) gp_context_wrapper_real_error;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	((GPContextWrapperClass *) klass)->status = (void (*) (GPContextWrapper *, const gchar*, void*)) gp_context_wrapper_real_status;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	((GPContextWrapperClass *) klass)->message = (void (*) (GPContextWrapper *, const gchar*, void*)) gp_context_wrapper_real_message;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	((GPContextWrapperClass *) klass)->progress_start = (void (*) (GPContextWrapper *, gfloat, const gchar*, void*)) gp_context_wrapper_real_progress_start;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	((GPContextWrapperClass *) klass)->progress_update = (void (*) (GPContextWrapper *, gfloat, void*)) gp_context_wrapper_real_progress_update;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	((GPContextWrapperClass *) klass)->progress_stop = (void (*) (GPContextWrapper *)) gp_context_wrapper_real_progress_stop;
#line 729 "GPhoto.c"
}


static void gp_context_wrapper_instance_init (GPContextWrapper * self) {
	GPContext* _tmp0_;
#line 15 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp0_ = gp_context_new ();
#line 15 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	self->context = _tmp0_;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	self->ref_count = 1;
#line 741 "GPhoto.c"
}


static void gp_context_wrapper_finalize (GPContextWrapper * obj) {
	GPContextWrapper * self;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GP_TYPE_CONTEXT_WRAPPER, GPContextWrapper);
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_signal_handlers_destroy (self);
#line 15 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_gp_context_unref0 (self->context);
#line 753 "GPhoto.c"
}


GType gp_context_wrapper_get_type (void) {
	static volatile gsize gp_context_wrapper_type_id__volatile = 0;
	if (g_once_init_enter (&gp_context_wrapper_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gp_value_context_wrapper_init, gp_value_context_wrapper_free_value, gp_value_context_wrapper_copy_value, gp_value_context_wrapper_peek_pointer, "p", gp_value_context_wrapper_collect_value, "p", gp_value_context_wrapper_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GPContextWrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gp_context_wrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GPContextWrapper), 0, (GInstanceInitFunc) gp_context_wrapper_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gp_context_wrapper_type_id;
		gp_context_wrapper_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GPContextWrapper", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gp_context_wrapper_type_id__volatile, gp_context_wrapper_type_id);
	}
	return gp_context_wrapper_type_id__volatile;
}


gpointer gp_context_wrapper_ref (gpointer instance) {
	GPContextWrapper * self;
	self = instance;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_atomic_int_inc (&self->ref_count);
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return instance;
#line 778 "GPhoto.c"
}


void gp_context_wrapper_unref (gpointer instance) {
	GPContextWrapper * self;
	self = instance;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		GP_CONTEXT_WRAPPER_GET_CLASS (self)->finalize (self);
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 791 "GPhoto.c"
	}
}


GPSpinIdleWrapper* gp_spin_idle_wrapper_construct (GType object_type) {
	GPSpinIdleWrapper* self = NULL;
#line 79 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	self = (GPSpinIdleWrapper*) gp_context_wrapper_construct (object_type);
#line 79 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return self;
#line 802 "GPhoto.c"
}


GPSpinIdleWrapper* gp_spin_idle_wrapper_new (void) {
#line 79 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return gp_spin_idle_wrapper_construct (GP_TYPE_SPIN_IDLE_WRAPPER);
#line 809 "GPhoto.c"
}


static void gp_spin_idle_wrapper_real_idle (GPContextWrapper* base) {
	GPSpinIdleWrapper * self;
#line 82 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GP_TYPE_SPIN_IDLE_WRAPPER, GPSpinIdleWrapper);
#line 83 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	GP_CONTEXT_WRAPPER_CLASS (gp_spin_idle_wrapper_parent_class)->idle (G_TYPE_CHECK_INSTANCE_CAST (self, GP_TYPE_CONTEXT_WRAPPER, GPContextWrapper));
#line 85 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	spin_event_loop ();
#line 821 "GPhoto.c"
}


static void gp_spin_idle_wrapper_real_progress_update (GPContextWrapper* base, gfloat current, void* data) {
	GPSpinIdleWrapper * self;
	gfloat _tmp0_;
	void* _tmp1_;
#line 88 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GP_TYPE_SPIN_IDLE_WRAPPER, GPSpinIdleWrapper);
#line 89 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp0_ = current;
#line 89 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp1_ = data;
#line 89 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	GP_CONTEXT_WRAPPER_CLASS (gp_spin_idle_wrapper_parent_class)->progress_update (G_TYPE_CHECK_INSTANCE_CAST (self, GP_TYPE_CONTEXT_WRAPPER, GPContextWrapper), _tmp0_, _tmp1_);
#line 91 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	spin_event_loop ();
#line 839 "GPhoto.c"
}


static void gp_spin_idle_wrapper_class_init (GPSpinIdleWrapperClass * klass) {
#line 78 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_spin_idle_wrapper_parent_class = g_type_class_peek_parent (klass);
#line 78 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	((GPContextWrapperClass *) klass)->idle = (void (*) (GPContextWrapper *)) gp_spin_idle_wrapper_real_idle;
#line 78 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	((GPContextWrapperClass *) klass)->progress_update = (void (*) (GPContextWrapper *, gfloat, void*)) gp_spin_idle_wrapper_real_progress_update;
#line 850 "GPhoto.c"
}


static void gp_spin_idle_wrapper_instance_init (GPSpinIdleWrapper * self) {
}


GType gp_spin_idle_wrapper_get_type (void) {
	static volatile gsize gp_spin_idle_wrapper_type_id__volatile = 0;
	if (g_once_init_enter (&gp_spin_idle_wrapper_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GPSpinIdleWrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gp_spin_idle_wrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GPSpinIdleWrapper), 0, (GInstanceInitFunc) gp_spin_idle_wrapper_instance_init, NULL };
		GType gp_spin_idle_wrapper_type_id;
		gp_spin_idle_wrapper_type_id = g_type_register_static (GP_TYPE_CONTEXT_WRAPPER, "GPSpinIdleWrapper", &g_define_type_info, 0);
		g_once_init_leave (&gp_spin_idle_wrapper_type_id__volatile, gp_spin_idle_wrapper_type_id);
	}
	return gp_spin_idle_wrapper_type_id__volatile;
}


gboolean gp_get_info (GPContext* context, Camera* camera, const gchar* folder, const gchar* filename, CameraFileInfo* info, GError** error) {
	CameraFileInfo _vala_info = {0};
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	int res = 0;
	Camera* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	GPContext* _tmp11_;
	CameraFileInfo _tmp12_ = {0};
	int _tmp13_;
	int _tmp14_;
	GError * _inner_error_ = NULL;
#line 102 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (context != NULL, FALSE);
#line 102 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (camera != NULL, FALSE);
#line 102 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (folder != NULL, FALSE);
#line 102 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (filename != NULL, FALSE);
#line 104 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp1_ = folder;
#line 104 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp2_ = strlen (_tmp1_);
#line 104 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp3_ = _tmp2_;
#line 104 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp3_ > GP_MAX_BASEDIR_LENGTH) {
#line 104 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp0_ = TRUE;
#line 904 "GPhoto.c"
	} else {
		const gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
#line 104 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp4_ = filename;
#line 104 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp5_ = strlen (_tmp4_);
#line 104 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp6_ = _tmp5_;
#line 104 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp0_ = _tmp6_ > GP_MAX_FILENAME_LENGTH;
#line 917 "GPhoto.c"
	}
#line 104 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp0_) {
#line 921 "GPhoto.c"
		CameraFileInfo _tmp7_ = {0};
#line 105 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		 (_vala_info);
#line 105 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_vala_info = _tmp7_;
#line 107 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		result = FALSE;
#line 107 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		if (info) {
#line 107 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			*info = _vala_info;
#line 933 "GPhoto.c"
		} else {
#line 107 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			 (_vala_info);
#line 937 "GPhoto.c"
		}
#line 107 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return result;
#line 941 "GPhoto.c"
	}
#line 110 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp8_ = camera;
#line 110 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp9_ = folder;
#line 110 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp10_ = filename;
#line 110 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp11_ = context;
#line 110 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp13_ = gp_camera_file_get_info (_tmp8_, _tmp9_, _tmp10_, &_tmp12_, _tmp11_);
#line 110 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	 (_vala_info);
#line 110 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_vala_info = _tmp12_;
#line 110 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	res = _tmp13_;
#line 111 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp14_ = res;
#line 111 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp14_ != GP_OK) {
#line 963 "GPhoto.c"
		int _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		int _tmp18_;
		const gchar* _tmp19_;
		GError* _tmp20_;
		gboolean _tmp21_ = FALSE;
#line 112 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp15_ = res;
#line 112 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp16_ = folder;
#line 112 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp17_ = filename;
#line 112 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp18_ = res;
#line 112 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp19_ = gp_port_result_as_string (_tmp18_);
#line 112 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp20_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Error retrieving file information for %s/%s: %s", (gint) _tmp15_, _tmp16_, _tmp17_, _tmp19_);
#line 112 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = _tmp20_;
#line 112 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 112 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return _tmp21_;
#line 989 "GPhoto.c"
	}
#line 115 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	result = TRUE;
#line 115 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (info) {
#line 115 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		*info = _vala_info;
#line 997 "GPhoto.c"
	} else {
#line 115 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		 (_vala_info);
#line 1001 "GPhoto.c"
	}
#line 115 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return result;
#line 1005 "GPhoto.c"
}


static gpointer _GPHOTO_REF_FILE0 (gpointer self) {
#line 131 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return self ? GPHOTO_REF_FILE (self) : NULL;
#line 1012 "GPhoto.c"
}


GBytes* gp_camera_file_to_bytes (GPContext* context, CameraFile* file) {
	GBytes* result = NULL;
	guint8* data = NULL;
	gulong data_len = 0UL;
	int res = 0;
	CameraFile* _tmp0_;
	guint8* _tmp1_ = NULL;
	gulong _tmp2_ = 0UL;
	int _tmp3_;
	int _tmp4_;
	guint8* buffer = NULL;
	guint8* _tmp5_;
	gint buffer_length1;
	gint _buffer_size_;
	gulong _tmp6_;
	gint _tmp7_;
	guint8* _tmp8_;
	gint _tmp8__length1;
	CameraFile* _tmp9_;
	CameraFile* _tmp10_;
	GBytes* _tmp11_;
#line 118 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 118 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 124 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp0_ = file;
#line 124 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp3_ = gp_file_get_data_and_size (_tmp0_, &_tmp1_, &_tmp2_);
#line 124 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	data = _tmp1_;
#line 124 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	data_len = _tmp2_;
#line 124 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	res = _tmp3_;
#line 125 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp4_ = res;
#line 125 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp4_ != GP_OK) {
#line 126 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		result = NULL;
#line 126 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return result;
#line 1059 "GPhoto.c"
	}
#line 128 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp5_ = data;
#line 128 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	buffer = (guint8*) _tmp5_;
#line 128 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	buffer_length1 = sizeof (guint8) / sizeof (guint8);
#line 128 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_buffer_size_ = buffer_length1;
#line 129 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp6_ = data_len;
#line 129 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	buffer_length1 = (gint) _tmp6_;
#line 129 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp7_ = buffer_length1;
#line 131 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp8_ = buffer;
#line 131 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp8__length1 = buffer_length1;
#line 131 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp9_ = file;
#line 131 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp10_ = _GPHOTO_REF_FILE0 (_tmp9_);
#line 131 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp11_ = g_bytes_new_with_free_func (_tmp8_, (gsize) _tmp8__length1, gp_file_unref, _tmp10_);
#line 131 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	result = _tmp11_;
#line 131 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return result;
#line 1089 "GPhoto.c"
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_;
	glong _tmp16_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	gchar* _tmp21_;
#line 1355 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1356 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1356 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1356 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1357 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1357 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 1122 "GPhoto.c"
		glong _tmp3_;
		glong _tmp4_;
#line 1358 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1358 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1358 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 1131 "GPhoto.c"
	}
#line 1360 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1360 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 1137 "GPhoto.c"
		glong _tmp6_;
		glong _tmp7_;
#line 1361 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1361 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1361 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 1146 "GPhoto.c"
	}
#line 1363 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1363 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 1152 "GPhoto.c"
		glong _tmp10_;
		glong _tmp11_;
#line 1363 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1363 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1363 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 1161 "GPhoto.c"
	} else {
#line 1363 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 1165 "GPhoto.c"
	}
#line 1363 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1364 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1364 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 1173 "GPhoto.c"
		glong _tmp14_;
		glong _tmp15_;
#line 1364 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1364 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1364 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 1182 "GPhoto.c"
	} else {
#line 1364 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 1186 "GPhoto.c"
	}
#line 1364 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1365 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1365 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1365 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1366 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1366 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1366 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1366 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1366 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1366 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 1208 "GPhoto.c"
}


PhotoMetadata* gp_get_fallback_metadata (Camera* camera, GPContext* context, const gchar* folder, const gchar* filename) {
	PhotoMetadata* result = NULL;
	CameraStorageInformation* sifs = NULL;
	gint count = 0;
	Camera* _tmp0_;
	GPContext* _tmp1_;
	gint _tmp2_ = 0;
	GPPortInfo port_info = {0};
	Camera* _tmp3_;
	GPPortInfo _tmp4_ = {0};
	gchar* path = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* prefix = NULL;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gboolean _tmp9_;
	PhotoMetadata* metadata = NULL;
	PhotoMetadata* _tmp17_;
	GError * _inner_error_ = NULL;
#line 137 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (camera != NULL, NULL);
#line 137 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 137 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (folder != NULL, NULL);
#line 137 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 138 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	sifs = NULL;
#line 139 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	count = 0;
#line 140 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp0_ = camera;
#line 140 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp1_ = context;
#line 140 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_camera_get_storageinfo (_tmp0_, &sifs, &_tmp2_, _tmp1_);
#line 140 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	count = _tmp2_;
#line 143 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp3_ = camera;
#line 143 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_camera_get_port_info (_tmp3_, &_tmp4_);
#line 143 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	 (port_info);
#line 143 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	port_info = _tmp4_;
#line 146 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_port_info_get_path (port_info, &_tmp5_);
#line 146 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_free0 (path);
#line 146 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 146 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	path = _tmp6_;
#line 148 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp7_ = g_strdup ("disk:");
#line 148 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	prefix = _tmp7_;
#line 149 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp8_ = path;
#line 149 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp9_ = g_str_has_prefix (_tmp8_, prefix);
#line 149 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp9_) {
#line 1278 "GPhoto.c"
		const gchar* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		const gchar* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gchar* _tmp16_;
#line 150 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp10_ = path;
#line 150 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp11_ = strlen (prefix);
#line 150 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp12_ = _tmp11_;
#line 150 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp13_ = path;
#line 150 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp14_ = strlen (_tmp13_);
#line 150 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp15_ = _tmp14_;
#line 150 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp16_ = string_slice (_tmp10_, (glong) _tmp12_, (glong) _tmp15_);
#line 150 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (path);
#line 150 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		path = _tmp16_;
#line 1304 "GPhoto.c"
	} else {
#line 152 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		result = NULL;
#line 152 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (prefix);
#line 152 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (path);
#line 152 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		 (port_info);
#line 152 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return result;
#line 1316 "GPhoto.c"
	}
#line 154 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp17_ = photo_metadata_new ();
#line 154 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	metadata = _tmp17_;
#line 1322 "GPhoto.c"
	{
		PhotoMetadata* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		GFile* _tmp28_;
		GFile* _tmp29_;
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp18_ = metadata;
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp19_ = path;
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp20_ = folder;
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp21_ = g_strconcat (_tmp19_, _tmp20_, NULL);
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp22_ = _tmp21_;
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp23_ = g_strconcat (_tmp22_, "/", NULL);
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp24_ = _tmp23_;
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp25_ = filename;
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp26_ = g_strconcat (_tmp24_, _tmp25_, NULL);
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp27_ = _tmp26_;
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp28_ = g_file_new_for_path (_tmp27_);
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp29_ = _tmp28_;
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		media_metadata_read_from_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, TYPE_MEDIA_METADATA, MediaMetadata), _tmp29_, &_inner_error_);
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_object_unref0 (_tmp29_);
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (_tmp27_);
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (_tmp24_);
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (_tmp22_);
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1372 "GPhoto.c"
			goto __catch69_g_error;
		}
	}
	goto __finally69;
	__catch69_g_error:
	{
#line 155 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_clear_error (&_inner_error_);
#line 155 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = NULL;
#line 158 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_media_metadata_unref0 (metadata);
#line 158 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		metadata = NULL;
#line 1387 "GPhoto.c"
	}
	__finally69:
#line 155 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 155 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_media_metadata_unref0 (metadata);
#line 155 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (prefix);
#line 155 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (path);
#line 155 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		 (port_info);
#line 155 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 155 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_clear_error (&_inner_error_);
#line 155 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 1406 "GPhoto.c"
	}
#line 161 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	result = metadata;
#line 161 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_free0 (prefix);
#line 161 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_free0 (path);
#line 161 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	 (port_info);
#line 161 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return result;
#line 1418 "GPhoto.c"
}


static gpointer _g_bytes_ref0 (gpointer self) {
#line 185 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return self ? g_bytes_ref (self) : NULL;
#line 1425 "GPhoto.c"
}


GdkPixbuf* gp_load_preview (GPContext* context, Camera* camera, const gchar* folder, const gchar* filename, gchar* * preview_md5, GError** error) {
	gchar* _vala_preview_md5 = NULL;
	GdkPixbuf* result = NULL;
	GBytes* raw = NULL;
	GBytes* out_bytes = NULL;
	GBytes* _tmp25_;
	GBytes* _tmp26_;
	GBytes* _tmp27_;
	gchar* _tmp28_;
	GMemoryInputStream* mins = NULL;
	GBytes* _tmp29_;
	GMemoryInputStream* _tmp30_;
	GdkPixbuf* _tmp31_ = NULL;
	GMemoryInputStream* _tmp32_;
	GdkPixbuf* _tmp33_;
	GdkPixbuf* _tmp34_;
	GError * _inner_error_ = NULL;
#line 164 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 164 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (camera != NULL, NULL);
#line 164 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (folder != NULL, NULL);
#line 164 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 166 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	raw = NULL;
#line 167 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	out_bytes = NULL;
#line 168 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_free0 (_vala_preview_md5);
#line 168 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_vala_preview_md5 = NULL;
#line 1462 "GPhoto.c"
	{
		GBytes* _tmp0_ = NULL;
		GPContext* _tmp1_;
		Camera* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		GBytes* _tmp5_;
		GBytes* _tmp6_;
#line 171 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp1_ = context;
#line 171 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp2_ = camera;
#line 171 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp3_ = folder;
#line 171 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp4_ = filename;
#line 171 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp5_ = gp_load_file_into_buffer (_tmp1_, _tmp2_, _tmp3_, _tmp4_, GP_FILE_TYPE_PREVIEW, &_inner_error_);
#line 171 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp0_ = _tmp5_;
#line 171 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1485 "GPhoto.c"
			goto __catch70_g_error;
		}
#line 171 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp6_ = _tmp0_;
#line 171 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp0_ = NULL;
#line 171 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (raw);
#line 171 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		raw = _tmp6_;
#line 170 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (_tmp0_);
#line 1498 "GPhoto.c"
	}
	goto __finally70;
	__catch70_g_error:
	{
		PhotoMetadata* metadata = NULL;
		Camera* _tmp7_;
		GPContext* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		PhotoMetadata* _tmp11_;
		PhotoMetadata* _tmp12_;
		PhotoMetadata* _tmp13_;
		guint _tmp14_;
		PhotoPreview* preview = NULL;
		PhotoMetadata* _tmp15_;
		PhotoMetadata* _tmp16_;
		guint _tmp17_;
		PhotoPreview* _tmp18_;
		GBytes* _tmp19_ = NULL;
		PhotoPreview* _tmp20_;
		GBytes* _tmp21_;
		GBytes* _tmp22_;
		GBytes* _tmp23_;
		gchar* _tmp24_;
#line 170 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_clear_error (&_inner_error_);
#line 170 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = NULL;
#line 173 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp7_ = camera;
#line 173 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp8_ = context;
#line 173 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp9_ = folder;
#line 173 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp10_ = filename;
#line 173 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp11_ = gp_get_fallback_metadata (_tmp7_, _tmp8_, _tmp9_, _tmp10_);
#line 173 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		metadata = _tmp11_;
#line 174 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp12_ = metadata;
#line 174 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		if (NULL == _tmp12_) {
#line 175 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			result = NULL;
#line 175 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			_media_metadata_unref0 (metadata);
#line 175 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			_g_bytes_unref0 (out_bytes);
#line 175 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			_g_bytes_unref0 (raw);
#line 175 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			if (preview_md5) {
#line 175 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
				*preview_md5 = _vala_preview_md5;
#line 1555 "GPhoto.c"
			} else {
#line 175 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
				_g_free0 (_vala_preview_md5);
#line 1559 "GPhoto.c"
			}
#line 175 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			return result;
#line 1563 "GPhoto.c"
		}
#line 176 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp13_ = metadata;
#line 176 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp14_ = photo_metadata_get_preview_count (_tmp13_);
#line 176 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		if (((guint) 0) == _tmp14_) {
#line 177 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			result = NULL;
#line 177 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			_media_metadata_unref0 (metadata);
#line 177 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			_g_bytes_unref0 (out_bytes);
#line 177 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			_g_bytes_unref0 (raw);
#line 177 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			if (preview_md5) {
#line 177 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
				*preview_md5 = _vala_preview_md5;
#line 1583 "GPhoto.c"
			} else {
#line 177 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
				_g_free0 (_vala_preview_md5);
#line 1587 "GPhoto.c"
			}
#line 177 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			return result;
#line 1591 "GPhoto.c"
		}
#line 180 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp15_ = metadata;
#line 180 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp16_ = metadata;
#line 180 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp17_ = photo_metadata_get_preview_count (_tmp16_);
#line 180 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp18_ = photo_metadata_get_preview (_tmp15_, _tmp17_ - 1);
#line 180 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		preview = _tmp18_;
#line 181 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp20_ = preview;
#line 181 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp21_ = photo_preview_flatten (_tmp20_, &_inner_error_);
#line 181 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp19_ = _tmp21_;
#line 181 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 181 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			_photo_preview_unref0 (preview);
#line 181 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			_media_metadata_unref0 (metadata);
#line 1615 "GPhoto.c"
			goto __finally70;
		}
#line 181 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp22_ = _tmp19_;
#line 181 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp19_ = NULL;
#line 181 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (raw);
#line 181 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		raw = _tmp22_;
#line 182 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp23_ = raw;
#line 182 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp24_ = g_compute_checksum_for_bytes (G_CHECKSUM_MD5, _tmp23_);
#line 182 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (_vala_preview_md5);
#line 182 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_vala_preview_md5 = _tmp24_;
#line 170 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (_tmp19_);
#line 170 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_photo_preview_unref0 (preview);
#line 170 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_media_metadata_unref0 (metadata);
#line 1640 "GPhoto.c"
	}
	__finally70:
#line 170 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 170 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 170 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (out_bytes);
#line 170 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (raw);
#line 170 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 1653 "GPhoto.c"
	}
#line 185 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp25_ = raw;
#line 185 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp26_ = _g_bytes_ref0 (_tmp25_);
#line 185 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_bytes_unref0 (out_bytes);
#line 185 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	out_bytes = _tmp26_;
#line 186 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp27_ = out_bytes;
#line 186 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp28_ = g_compute_checksum_for_bytes (G_CHECKSUM_MD5, _tmp27_);
#line 186 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_free0 (_vala_preview_md5);
#line 186 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_vala_preview_md5 = _tmp28_;
#line 188 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp29_ = raw;
#line 188 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp30_ = (GMemoryInputStream*) g_memory_input_stream_new_from_bytes (_tmp29_);
#line 188 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	mins = _tmp30_;
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp32_ = mins;
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp33_ = gdk_pixbuf_new_from_stream_at_scale (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, g_input_stream_get_type (), GInputStream), IMPORT_PREVIEW_MAX_SCALE, IMPORT_PREVIEW_MAX_SCALE, TRUE, NULL, &_inner_error_);
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp31_ = _tmp33_;
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_object_unref0 (mins);
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (out_bytes);
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (raw);
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 1695 "GPhoto.c"
	}
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp34_ = _tmp31_;
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp31_ = NULL;
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	result = _tmp34_;
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_object_unref0 (_tmp31_);
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_object_unref0 (mins);
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_bytes_unref0 (out_bytes);
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_bytes_unref0 (raw);
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (preview_md5) {
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		*preview_md5 = _vala_preview_md5;
#line 1715 "GPhoto.c"
	} else {
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (_vala_preview_md5);
#line 1719 "GPhoto.c"
	}
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return result;
#line 1723 "GPhoto.c"
}


GdkPixbuf* gp_load_image (GPContext* context, Camera* camera, const gchar* folder, const gchar* filename, GError** error) {
	GdkPixbuf* result = NULL;
	GInputStream* ins = NULL;
	GPContext* _tmp0_;
	Camera* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GInputStream* _tmp4_;
	GInputStream* _tmp5_;
	GdkPixbuf* _tmp6_ = NULL;
	GInputStream* _tmp7_;
	GdkPixbuf* _tmp8_;
	GdkPixbuf* _tmp9_;
	GError * _inner_error_ = NULL;
#line 193 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 193 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (camera != NULL, NULL);
#line 193 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (folder != NULL, NULL);
#line 193 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 195 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp0_ = context;
#line 195 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp1_ = camera;
#line 195 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp2_ = folder;
#line 195 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp3_ = filename;
#line 195 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp4_ = gp_load_file_into_stream (_tmp0_, _tmp1_, _tmp2_, _tmp3_, GP_FILE_TYPE_NORMAL, &_inner_error_);
#line 195 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	ins = _tmp4_;
#line 195 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 195 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 195 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 1767 "GPhoto.c"
	}
#line 196 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp5_ = ins;
#line 196 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp5_ == NULL) {
#line 197 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		result = NULL;
#line 197 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_object_unref0 (ins);
#line 197 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return result;
#line 1779 "GPhoto.c"
	}
#line 199 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp7_ = ins;
#line 199 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp8_ = gdk_pixbuf_new_from_stream (_tmp7_, NULL, &_inner_error_);
#line 199 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp6_ = _tmp8_;
#line 199 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 199 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 199 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_object_unref0 (ins);
#line 199 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 1795 "GPhoto.c"
	}
#line 199 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp9_ = _tmp6_;
#line 199 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp6_ = NULL;
#line 199 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	result = _tmp9_;
#line 199 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_object_unref0 (_tmp6_);
#line 199 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_object_unref0 (ins);
#line 199 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return result;
#line 1809 "GPhoto.c"
}


void gp_save_image (GPContext* context, Camera* camera, const gchar* folder, const gchar* filename, GFile* dest_file, GError** error) {
	gint fd = 0;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	CameraFile* camera_file = NULL;
	int res = 0;
	gint _tmp12_;
	CameraFile* _tmp13_ = NULL;
	int _tmp14_;
	int _tmp15_;
	Camera* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	CameraFile* _tmp23_;
	GPContext* _tmp24_;
	int _tmp25_;
	int _tmp26_;
	GError * _inner_error_ = NULL;
#line 202 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (context != NULL);
#line 202 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (camera != NULL);
#line 202 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (folder != NULL);
#line 202 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (filename != NULL);
#line 202 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (G_IS_FILE (dest_file));
#line 203 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp0_ = dest_file;
#line 203 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 203 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp2_ = _tmp1_;
#line 203 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp3_ = creat (_tmp2_, (mode_t) 0640);
#line 203 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp4_ = _tmp3_;
#line 203 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_free0 (_tmp2_);
#line 203 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	fd = _tmp4_;
#line 204 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp5_ = fd;
#line 204 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp5_ < 0) {
#line 1863 "GPhoto.c"
		gint _tmp6_;
		GFile* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		GError* _tmp10_;
		GError* _tmp11_;
#line 205 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp6_ = errno;
#line 205 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp7_ = dest_file;
#line 205 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp8_ = g_file_get_path (_tmp7_);
#line 205 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp9_ = _tmp8_;
#line 205 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp10_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "[%d] Error creating file %s: %m", _tmp6_, _tmp9_);
#line 205 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp11_ = _tmp10_;
#line 205 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (_tmp9_);
#line 205 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = _tmp11_;
#line 205 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 205 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return;
#line 1890 "GPhoto.c"
	}
#line 209 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp12_ = fd;
#line 209 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp14_ = gp_file_new_from_fd (&_tmp13_, _tmp12_);
#line 209 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_gp_file_unref0 (camera_file);
#line 209 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	camera_file = _tmp13_;
#line 209 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	res = _tmp14_;
#line 210 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp15_ = res;
#line 210 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp15_ != GP_OK) {
#line 1906 "GPhoto.c"
		int _tmp16_;
		int _tmp17_;
		const gchar* _tmp18_;
		GError* _tmp19_;
#line 211 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp16_ = res;
#line 211 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp17_ = res;
#line 211 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp18_ = gp_port_result_as_string (_tmp17_);
#line 211 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp19_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Error allocating camera file: %s", (gint) _tmp16_, _tmp18_);
#line 211 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = _tmp19_;
#line 211 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 211 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_gp_file_unref0 (camera_file);
#line 211 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return;
#line 1927 "GPhoto.c"
	}
#line 214 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp20_ = camera;
#line 214 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp21_ = folder;
#line 214 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp22_ = filename;
#line 214 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp23_ = camera_file;
#line 214 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp24_ = context;
#line 214 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp25_ = gp_camera_file_get (_tmp20_, _tmp21_, _tmp22_, GP_FILE_TYPE_NORMAL, _tmp23_, _tmp24_);
#line 214 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	res = _tmp25_;
#line 215 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp26_ = res;
#line 215 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp26_ != GP_OK) {
#line 1947 "GPhoto.c"
		int _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		int _tmp30_;
		const gchar* _tmp31_;
		GError* _tmp32_;
#line 216 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp27_ = res;
#line 216 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp28_ = folder;
#line 216 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp29_ = filename;
#line 216 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp30_ = res;
#line 216 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp31_ = gp_port_result_as_string (_tmp30_);
#line 216 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp32_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Error retrieving file object for %s/%s: %s", (gint) _tmp27_, _tmp28_, _tmp29_, _tmp31_);
#line 216 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = _tmp32_;
#line 216 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 216 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_gp_file_unref0 (camera_file);
#line 216 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return;
#line 1974 "GPhoto.c"
	}
#line 202 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_gp_file_unref0 (camera_file);
#line 1978 "GPhoto.c"
}


static gint _vala_g_bytes_get_length (GBytes* self) {
	gint result;
	gsize _tmp0_;
#line 5013 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 5015 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = g_bytes_get_size (self);
#line 5015 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	result = (gint) _tmp0_;
#line 5015 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 1993 "GPhoto.c"
}


PhotoMetadata* gp_load_metadata (GPContext* context, Camera* camera, const gchar* folder, const gchar* filename, GError** error) {
	PhotoMetadata* result = NULL;
	GBytes* camera_raw = NULL;
	gboolean _tmp12_ = FALSE;
	GBytes* _tmp13_;
	PhotoMetadata* metadata = NULL;
	PhotoMetadata* _tmp17_;
	PhotoMetadata* _tmp18_;
	GBytes* _tmp19_;
	GError * _inner_error_ = NULL;
#line 221 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 221 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (camera != NULL, NULL);
#line 221 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (folder != NULL, NULL);
#line 221 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 223 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	camera_raw = NULL;
#line 2017 "GPhoto.c"
	{
		GBytes* _tmp0_ = NULL;
		GPContext* _tmp1_;
		Camera* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		GBytes* _tmp5_;
		GBytes* _tmp6_;
#line 225 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp1_ = context;
#line 225 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp2_ = camera;
#line 225 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp3_ = folder;
#line 225 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp4_ = filename;
#line 225 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp5_ = gp_load_file_into_buffer (_tmp1_, _tmp2_, _tmp3_, _tmp4_, GP_FILE_TYPE_EXIF, &_inner_error_);
#line 225 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp0_ = _tmp5_;
#line 225 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2040 "GPhoto.c"
			goto __catch71_g_error;
		}
#line 225 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp6_ = _tmp0_;
#line 225 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp0_ = NULL;
#line 225 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (camera_raw);
#line 225 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		camera_raw = _tmp6_;
#line 224 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (_tmp0_);
#line 2053 "GPhoto.c"
	}
	goto __finally71;
	__catch71_g_error:
	{
		Camera* _tmp7_;
		GPContext* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		PhotoMetadata* _tmp11_;
#line 224 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_clear_error (&_inner_error_);
#line 224 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = NULL;
#line 227 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp7_ = camera;
#line 227 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp8_ = context;
#line 227 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp9_ = folder;
#line 227 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp10_ = filename;
#line 227 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp11_ = gp_get_fallback_metadata (_tmp7_, _tmp8_, _tmp9_, _tmp10_);
#line 227 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		result = _tmp11_;
#line 227 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (camera_raw);
#line 227 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return result;
#line 2083 "GPhoto.c"
	}
	__finally71:
#line 224 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 224 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 224 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (camera_raw);
#line 224 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 2094 "GPhoto.c"
	}
#line 230 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp13_ = camera_raw;
#line 230 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp13_ == NULL) {
#line 230 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp12_ = TRUE;
#line 2102 "GPhoto.c"
	} else {
		GBytes* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
#line 230 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp14_ = camera_raw;
#line 230 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp15_ = _vala_g_bytes_get_length (_tmp14_);
#line 230 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp16_ = _tmp15_;
#line 230 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp12_ = _tmp16_ == 0;
#line 2115 "GPhoto.c"
	}
#line 230 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp12_) {
#line 231 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		result = NULL;
#line 231 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (camera_raw);
#line 231 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return result;
#line 2125 "GPhoto.c"
	}
#line 233 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp17_ = photo_metadata_new ();
#line 233 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	metadata = _tmp17_;
#line 234 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp18_ = metadata;
#line 234 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp19_ = camera_raw;
#line 234 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	photo_metadata_read_from_app1_segment (_tmp18_, _tmp19_, &_inner_error_);
#line 234 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 234 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 234 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_media_metadata_unref0 (metadata);
#line 234 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (camera_raw);
#line 234 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 2147 "GPhoto.c"
	}
#line 236 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	result = metadata;
#line 236 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_bytes_unref0 (camera_raw);
#line 236 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return result;
#line 2155 "GPhoto.c"
}


GInputStream* gp_load_file_into_stream (GPContext* context, Camera* camera, const gchar* folder, const gchar* filename, CameraFileType filetype, GError** error) {
	GInputStream* result = NULL;
	CameraFile* camera_file = NULL;
	int res = 0;
	CameraFile* _tmp0_ = NULL;
	int _tmp1_;
	int _tmp2_;
	Camera* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	CameraFileType _tmp10_;
	GPContext* _tmp11_;
	int _tmp12_;
	int _tmp13_;
	GBytes* bytes = NULL;
	GPContext* _tmp20_;
	GBytes* _tmp21_;
	GBytes* _tmp22_;
	GFile* temp = NULL;
	GFile* _tmp25_;
	GFile* _tmp26_;
	GFile* _tmp27_;
	GFile* _tmp28_;
	GFile* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	int _tmp32_;
	int _tmp33_;
	GFileInputStream* _tmp44_ = NULL;
	GFile* _tmp45_;
	GFileInputStream* _tmp46_;
	GFileInputStream* _tmp47_;
	GError * _inner_error_ = NULL;
#line 241 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 241 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (camera != NULL, NULL);
#line 241 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (folder != NULL, NULL);
#line 241 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 244 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp1_ = gp_file_new (&_tmp0_);
#line 244 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_gp_file_unref0 (camera_file);
#line 244 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	camera_file = _tmp0_;
#line 244 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	res = _tmp1_;
#line 245 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp2_ = res;
#line 245 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp2_ != GP_OK) {
#line 2212 "GPhoto.c"
		int _tmp3_;
		int _tmp4_;
		const gchar* _tmp5_;
		GError* _tmp6_;
#line 246 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp3_ = res;
#line 246 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp4_ = res;
#line 246 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp5_ = gp_port_result_as_string (_tmp4_);
#line 246 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp6_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Error allocating camera file: %s", (gint) _tmp3_, _tmp5_);
#line 246 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = _tmp6_;
#line 246 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 246 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_gp_file_unref0 (camera_file);
#line 246 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 2233 "GPhoto.c"
	}
#line 248 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp7_ = camera;
#line 248 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp8_ = folder;
#line 248 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp9_ = filename;
#line 248 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp10_ = filetype;
#line 248 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp11_ = context;
#line 248 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp12_ = gp_camera_file_get (_tmp7_, _tmp8_, _tmp9_, _tmp10_, camera_file, _tmp11_);
#line 248 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	res = _tmp12_;
#line 249 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp13_ = res;
#line 249 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp13_ != GP_OK) {
#line 2253 "GPhoto.c"
		int _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		int _tmp17_;
		const gchar* _tmp18_;
		GError* _tmp19_;
#line 250 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp14_ = res;
#line 250 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp15_ = folder;
#line 250 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp16_ = filename;
#line 250 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp17_ = res;
#line 250 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp18_ = gp_port_result_as_string (_tmp17_);
#line 250 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp19_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Error retrieving file object for %s/%s: %s", (gint) _tmp14_, _tmp15_, _tmp16_, _tmp18_);
#line 250 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = _tmp19_;
#line 250 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 250 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_gp_file_unref0 (camera_file);
#line 250 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 2280 "GPhoto.c"
	}
#line 256 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp20_ = context;
#line 256 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp21_ = gp_camera_file_to_bytes (_tmp20_, camera_file);
#line 256 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	bytes = _tmp21_;
#line 257 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp22_ = bytes;
#line 257 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp22_ != NULL) {
#line 2292 "GPhoto.c"
		GBytes* _tmp23_;
		GMemoryInputStream* _tmp24_;
#line 258 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp23_ = bytes;
#line 258 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp24_ = (GMemoryInputStream*) g_memory_input_stream_new_from_bytes (_tmp23_);
#line 258 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, g_input_stream_get_type (), GInputStream);
#line 258 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (bytes);
#line 258 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_gp_file_unref0 (camera_file);
#line 258 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return result;
#line 2307 "GPhoto.c"
	}
#line 262 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp25_ = app_dirs_get_temp_dir ();
#line 262 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp26_ = _tmp25_;
#line 262 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp27_ = g_file_get_child (_tmp26_, "import.tmp");
#line 262 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp28_ = _tmp27_;
#line 262 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_object_unref0 (_tmp26_);
#line 262 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	temp = _tmp28_;
#line 263 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp29_ = temp;
#line 263 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp30_ = g_file_get_path (_tmp29_);
#line 263 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp31_ = _tmp30_;
#line 263 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp32_ = gp_file_save (camera_file, _tmp31_);
#line 263 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	res = _tmp32_;
#line 263 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_free0 (_tmp31_);
#line 264 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp33_ = res;
#line 264 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp33_ != GP_OK) {
#line 2337 "GPhoto.c"
		int _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		GFile* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		int _tmp40_;
		const gchar* _tmp41_;
		GError* _tmp42_;
		GError* _tmp43_;
#line 265 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp34_ = res;
#line 265 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp35_ = folder;
#line 265 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp36_ = filename;
#line 265 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp37_ = temp;
#line 265 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp38_ = g_file_get_path (_tmp37_);
#line 265 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp39_ = _tmp38_;
#line 265 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp40_ = res;
#line 265 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp41_ = gp_port_result_as_string (_tmp40_);
#line 265 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp42_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Error copying file %s/%s to %s: %s", (gint) _tmp34_, _tmp35_, _tmp36_, _tmp39_, _tmp41_);
#line 265 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp43_ = _tmp42_;
#line 265 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (_tmp39_);
#line 265 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = _tmp43_;
#line 265 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 265 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_object_unref0 (temp);
#line 265 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (bytes);
#line 265 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_gp_file_unref0 (camera_file);
#line 265 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 2382 "GPhoto.c"
	}
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp45_ = temp;
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp46_ = g_file_read (_tmp45_, NULL, &_inner_error_);
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp44_ = _tmp46_;
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_object_unref0 (temp);
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_bytes_unref0 (bytes);
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_gp_file_unref0 (camera_file);
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 2402 "GPhoto.c"
	}
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp47_ = _tmp44_;
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp44_ = NULL;
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, g_input_stream_get_type (), GInputStream);
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_object_unref0 (_tmp44_);
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_object_unref0 (temp);
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_bytes_unref0 (bytes);
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_gp_file_unref0 (camera_file);
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return result;
#line 2420 "GPhoto.c"
}


GBytes* gp_load_file_into_buffer (GPContext* context, Camera* camera, const gchar* folder, const gchar* filename, CameraFileType filetype, GError** error) {
	GBytes* result = NULL;
	CameraFile* camera_file = NULL;
	int res = 0;
	CameraFile* _tmp0_ = NULL;
	int _tmp1_;
	int _tmp2_;
	Camera* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	CameraFileType _tmp10_;
	CameraFile* _tmp11_;
	GPContext* _tmp12_;
	int _tmp13_;
	int _tmp14_;
	GPContext* _tmp21_;
	CameraFile* _tmp22_;
	GBytes* _tmp23_;
	GError * _inner_error_ = NULL;
#line 272 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 272 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (camera != NULL, NULL);
#line 272 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (folder != NULL, NULL);
#line 272 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 275 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp1_ = gp_file_new (&_tmp0_);
#line 275 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_gp_file_unref0 (camera_file);
#line 275 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	camera_file = _tmp0_;
#line 275 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	res = _tmp1_;
#line 276 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp2_ = res;
#line 276 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp2_ != GP_OK) {
#line 2463 "GPhoto.c"
		int _tmp3_;
		int _tmp4_;
		const gchar* _tmp5_;
		GError* _tmp6_;
#line 277 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp3_ = res;
#line 277 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp4_ = res;
#line 277 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp5_ = gp_port_result_as_string (_tmp4_);
#line 277 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp6_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Error allocating camera file: %s", (gint) _tmp3_, _tmp5_);
#line 277 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = _tmp6_;
#line 277 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 277 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_gp_file_unref0 (camera_file);
#line 277 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 2484 "GPhoto.c"
	}
#line 279 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp7_ = camera;
#line 279 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp8_ = folder;
#line 279 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp9_ = filename;
#line 279 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp10_ = filetype;
#line 279 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp11_ = camera_file;
#line 279 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp12_ = context;
#line 279 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp13_ = gp_camera_file_get (_tmp7_, _tmp8_, _tmp9_, _tmp10_, _tmp11_, _tmp12_);
#line 279 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	res = _tmp13_;
#line 280 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp14_ = res;
#line 280 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp14_ != GP_OK) {
#line 2506 "GPhoto.c"
		int _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		int _tmp18_;
		const gchar* _tmp19_;
		GError* _tmp20_;
#line 281 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp15_ = res;
#line 281 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp16_ = folder;
#line 281 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp17_ = filename;
#line 281 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp18_ = res;
#line 281 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp19_ = gp_port_result_as_string (_tmp18_);
#line 281 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp20_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Error retrieving file object for %s/%s: %s", (gint) _tmp15_, _tmp16_, _tmp17_, _tmp19_);
#line 281 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = _tmp20_;
#line 281 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 281 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_gp_file_unref0 (camera_file);
#line 281 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 2533 "GPhoto.c"
	}
#line 284 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp21_ = context;
#line 284 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp22_ = camera_file;
#line 284 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp23_ = gp_camera_file_to_bytes (_tmp21_, _tmp22_);
#line 284 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	result = _tmp23_;
#line 284 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_gp_file_unref0 (camera_file);
#line 284 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return result;
#line 2547 "GPhoto.c"
}



