.TH ETEX 1 "27 May 2018" "Web2C @VERSION@"
.\"=====================================================================
.if n .ds MF Metafont
.if t .ds MF Metafont
.if t .ds TX \fRT\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X\fP
.if n .ds TX TeX
.ie t .ds OX \fIT\v'+0.25m'E\v'-0.25m'X\fP
.el .ds OX TeX
.\" BX definition must follow TX so BX can use TX
.if t .ds BX \fRB\s-2IB\s0\fP\*(TX
.if n .ds BX BibTeX
.\" LX definition must follow TX so LX can use TX
.if t .ds LX \fRL\\h'-0.36m'\\v'-0.15v'\s-2A\s0\\h'-0.15m'\\v'0.15v'\fP\*(TX
.if n .ds LX LaTeX
.if t .ds AX \fRA\\h'-0.1667m'\\v'0.20v'M\\v'-0.20v'\\h'-0.125m'S\fP\*(TX
.if n .ds AX AmSTeX
.if t .ds AY \fRA\\h'-0.1667m'\\v'0.20v'M\\v'-0.20v'\\h'-0.125m'S\fP\*(LX
.if n .ds AY AmSLaTeX
.if n .ds WB Web
.if t .ds WB W\s-2EB\s0
.\"=====================================================================
.SH NAME
etex \- extended (plain) TeX
.SH SYNOPSIS
.B etex
.RI [ options ]
.RI [ \fB&\fPformat ]
.RI [ file | \fB\e\fPcommands ]
.\"=====================================================================
.SH DESCRIPTION
Run the e-\*(TX typesetter on
.IR file ,
by default creating
.IR file.dvi .
If the file argument has no extension, ".tex" will be appended to it. 
Instead of a filename, a set of e-\*(TX commands can be given, the first
of which must start with a backslash.
With a 
.BI & format
argument e-\*(TX uses a different set of precompiled commands,
contained in
.IR format\fB.fmt\fP ;
it is usually better to use the
.B -fmt
.I format
option instead.
.PP
e-\*(TX is the first concrete result of an international research &
development project, the NTS Project, which was established under the
aegis of DANTE e.V. during 1992. The aims of the project are to
perpetuate and develop the spirit and philosophy of \*(TX, whilst
respecting Knuth's wish that \*(TX should remain frozen.
.PP
e-\*(TX can be used in two different modes: in
.I compatibility mode
it is supposed to be completely interchangeable with standard \*(TX.
In
.I extended mode
several new primitives are added that facilitate (among other things)
bidirectional typesetting.
.PP
An extended mode format is generated by prefixing the name of the
source file for the format with an asterisk (*).
.PP
e-\*(TX's handling of its command-line arguments is similar to that of
the other \*(TX programs in the
.I web2c
implementation.
.\"=====================================================================
.SH OPTIONS
This version of e-\*(TX understands the following command line options.
.TP
.BI -fmt \ format
Use
.I format
as the name of the format to be used, instead of the name by which
e-\*(TX was called or a
.I %&
line.
.TP
.B -enc
Enable the enc\*(TX extensions.  This option is only effective in
combination with
.BR -ini .
For documentation of the enc\*(TX extensions see
.BR http://www.olsak.net/enctex.html .
.TP
.B -etex
Enable the e-\*(TX extensions.  This option is only effective in
combination with
.BR -ini .
.TP
.B -file-line-error
Print error messages in the form
.I file:line:error
which is similar to the way many compilers format them.
.TP
.B -no-file-line-error
Disable printing error messages in the
.I file:line:error
style.
.TP
.B -file-line-error-style
This is the old name of the
.B -file-line-error
option.
.TP
.B -halt-on-error
Exit with an error code when an error is encountered during processing.
.TP
.B -help
Print help message and exit.
.TP
.B -ini
Start in
.I INI
mode, which is used to dump formats.  The
.I INI
mode can be used for typesetting, but no format is preloaded, and
basic initializations like setting catcodes may be required.
.TP
.BI -interaction \ mode
Sets the interaction mode.  The mode can be either
.IR batchmode ,
.IR nonstopmode ,
.IR scrollmode ,
and
.IR errorstopmode .
The meaning of these modes is the same as that of the corresponding
\ecommands.
.TP
.B -ipc
Send DVI output to a socket as well as the usual output file.  Whether
this option is available is the choice of the installer.
.TP
.B -ipc-start
As
.BR -ipc ,
and starts the server at the other end as well.  Whether this option
is available is the choice of the installer.
.TP
.BI -jobname \ name
Use
.I name
for the job name, instead of deriving it from the name of the input file.
.TP
.BI -kpathsea-debug \ bitmask
Sets path searching debugging flags according to the bitmask.  See the
.I Kpathsea
manual for details.
.TP
.BI -mktex \ fmt
Enable
.RI mktex fmt ,
where
.I fmt
must be either
.I tex
or
.IR tfm .
.TP
.B -mltex
Enable ML\*(TX extensions.  Only effective in combination with
.BR -ini .
.TP
.BI -no-mktex \ fmt
Disable
.RI mktex fmt ,
where
.I fmt
must be either
.I tex
or
.IR tfm .
.TP
.BI -output-comment \ string
Use
.I string
for the
.I DVI
file comment instead of the date.
.TP
.BI -output-directory \ directory
Write output files in
.I directory
instead of the current directory.  Look up input files in
.I directory
first, the along the normal search path.
.TP
.B -parse-first-line
If the first line of the main input file begins with
.I %&
parse it to look for a dump name or a
.B -translate-file
option.
.TP
.B -no-parse-first-line
Disable parsing of the first line of the main input file.
.TP
.BI -progname \ name
Pretend to be program
.IR name .
This affects both the format used and the search paths.
.TP
.B -recorder
Enable the filename recorder.  This leaves a trace of the files opened
for input and output in a file with extension
.IR .fls .
.TP
.B -shell-escape
Enable the
.BI \ewrite18{ command }
construct.  The
.I command
can be any shell command.  This construct is normally
disallowed for security reasons.
.TP
.B -no-shell-escape
Disable the
.BI \ewrite18{ command }
construct, even if it is enabled in the
.I texmf.cnf
file.
.TP
.B -src-specials
Insert source specials into the
.I DVI
file.
.TP
.BI -src-specials \ where
Insert source specials in certain placed of the
.I DVI
file.
.I where
is a comma-separated value list:
.IR cr ,
.IR display ,
.IR hbox ,
.IR math ,
.IR par ,
.IR parent ,
or
.IR vbox .
.TP
.BI -translate-file \ tcxname
Use the
.I tcxname
translation table to set the mapping of input characters and
re-mapping of output characters.
.TP
.BI -default-translate-file \ tcxname
Like
.B -translate-file
except that a
.I %&
line can overrule this setting.
.TP
.B -version
Print version information and exit.
.\"=====================================================================
.SH ENVIRONMENT
See the Kpathsearch library documentation (the `Path specifications'
node) for precise details of how the environment variables are used.
The
.B kpsewhich
utility can be used to query the values of the variables.
.PP
One caveat: In most e-\*(TX formats, you cannot use ~ in a filename you
give directly to e-\*(TX, because ~ is an active character, and hence is
expanded, not taken as part of the filename.  Other programs, such as
\*(MF, do not have this problem.
.PP
.TP
.B TEXMFOUTPUT
Normally, e-\*(TX puts its output files in the current directory.  If
any output file cannot be opened there, it tries to open it in the
directory specified in the environment variable TEXMFOUTPUT.
There is no default value for that variable.  For example, if you say
.I etex paper
and the current directory is not writable, if TEXMFOUTPUT has
the value
.IR /tmp ,
e-\*(TX attempts to create
.I /tmp/paper.log
(and
.IR /tmp/paper.dvi ,
if any output is produced.)  TEXMFOUTPUT is also checked for input
files, as \*(TX often generates files that need to be subsequently
read; for input, no suffixes (such as ``.tex'') are added by default,
the input name is simply checked as given.
.TP
.B TEXINPUTS
Search path for
.I \einput
and
.I \eopenin
files.
This should start with ``.'', so
that user files are found before system files.  An empty path
component will be replaced with the paths defined in the
.I texmf.cnf
file.  For example, set TEXINPUTS to ".:/home/user/tex:" to prepend the
current directory and ``/home/user/tex'' to the standard search path.
.TP
.B TEXFORMATS
Search path for format files.
.TP
.B TEXPOOL
search path for
.B etex
internal strings.
.TP
.B TEXEDIT
Command template for switching to editor.  The default, usually
.BR vi ,
is set when e-\*(TX is compiled.
.TP
.B TFMFONTS
Search path for font metric
.RI ( .tfm )
files.
.\"=====================================================================
.SH FILES
The location of the files mentioned below varies from system to
system.  Use the
.B kpsewhich
utility to find their locations.
.TP
.I etex.pool
Text file containing e-\*(TX's internal strings.
.TP
.I texfonts.map
Filename mapping definitions.
.TP
.I *.tfm
Metric files for e-\*(TX's fonts.
.TP
.I *.fmt
Predigested e-\*(TX format (.\|fmt) files.
.\"=====================================================================
.SH NOTES
Starting with version 1.40, pdf\*(TX incorporates the e-\*(TX
extensions, so in this installation e\*(TX may be just a symbolic link to
pdf\*(TX.  See 
.BR pdftex (1).
This manual page is not meant to be exhaustive.  The complete
documentation for this version of e-\*(TX can be found in the info
manual
.IR "Web2C: A TeX implementation" .
.\"=====================================================================
.SH BUGS
This version of e-\*(TX implements a number of optional extensions.
In fact, many of these extensions conflict to a greater or lesser
extent with the definition of e-\*(TX.  When such extensions are
enabled, the banner printed when e-\*(TX starts is changed to print
.B e-TeXk
instead of
.BR e-TeX .
.PP
This version of e-\*(TX fails to trap arithmetic overflow when
dimensions are added or subtracted.  Cases where this occurs are rare,
but when it does the generated
.I DVI
file will be invalid.
.\"=====================================================================
.SH "SEE ALSO"
.BR pdftex (1),
.BR tex (1),
.BR mf (1).
.\"=====================================================================
.SH AUTHORS
e-\*(TX was developed by Peter Breitenlohner and the NTS team; Peter
later continued its development outside of the team.
.PP
\*(TX was designed by Donald E. Knuth,
who implemented it using his \*(WB system for Pascal programs.
It was ported to Unix at Stanford by Howard Trickey, and
at Cornell by Pavel Curtis.
The version now offered with the Unix \*(TX distribution is that
generated by the \*(WB to C system
.RB ( web2c ),
originally written by Tomas Rokicki and Tim Morgan.
.PP
The enc\*(TX extensions were written by Petr Olsak.
