/* This file is generated by venus-protocol git-e05ae158. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_RENDERER_DESCRIPTOR_SET_H
#define VN_PROTOCOL_RENDERER_DESCRIPTOR_SET_H

#include "vn_protocol_renderer_structs.h"

/*
 * These structs/unions/commands are not included
 *
 *   vkUpdateDescriptorSetWithTemplate
 */

/* struct VkDescriptorSetVariableDescriptorCountAllocateInfo chain */

static inline void *
vn_decode_VkDescriptorSetVariableDescriptorCountAllocateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkDescriptorSetVariableDescriptorCountAllocateInfo_self_temp(struct vn_cs_decoder *dec, VkDescriptorSetVariableDescriptorCountAllocateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->descriptorSetCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->descriptorSetCount);
        val->pDescriptorCounts = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pDescriptorCounts) * array_size);
        if (!val->pDescriptorCounts) return;
        vn_decode_uint32_t_array(dec, (uint32_t *)val->pDescriptorCounts, array_size);
    } else {
        vn_decode_array_size(dec, 0);
        val->pDescriptorCounts = NULL;
    }
}

static inline void
vn_decode_VkDescriptorSetVariableDescriptorCountAllocateInfo_temp(struct vn_cs_decoder *dec, VkDescriptorSetVariableDescriptorCountAllocateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkDescriptorSetVariableDescriptorCountAllocateInfo_pnext_temp(dec);
    vn_decode_VkDescriptorSetVariableDescriptorCountAllocateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkDescriptorSetVariableDescriptorCountAllocateInfo_handle_self(VkDescriptorSetVariableDescriptorCountAllocateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->descriptorSetCount */
    /* skip val->pDescriptorCounts */
}

static inline void
vn_replace_VkDescriptorSetVariableDescriptorCountAllocateInfo_handle(VkDescriptorSetVariableDescriptorCountAllocateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO:
            vn_replace_VkDescriptorSetVariableDescriptorCountAllocateInfo_handle_self((VkDescriptorSetVariableDescriptorCountAllocateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkDescriptorSetAllocateInfo chain */

static inline void *
vn_decode_VkDescriptorSetAllocateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkDescriptorSetVariableDescriptorCountAllocateInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkDescriptorSetAllocateInfo_pnext_temp(dec);
            vn_decode_VkDescriptorSetVariableDescriptorCountAllocateInfo_self_temp(dec, (VkDescriptorSetVariableDescriptorCountAllocateInfo *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkDescriptorSetAllocateInfo_self_temp(struct vn_cs_decoder *dec, VkDescriptorSetAllocateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkDescriptorPool_lookup(dec, &val->descriptorPool);
    vn_decode_uint32_t(dec, &val->descriptorSetCount);
    if (vn_peek_array_size(dec)) {
        val->pSetLayouts = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pSetLayouts) * val->descriptorSetCount);
        if (!val->pSetLayouts) return;
        vn_decode_array_size(dec, val->descriptorSetCount);
        for (uint32_t i = 0; i < val->descriptorSetCount; i++)
            vn_decode_VkDescriptorSetLayout_lookup(dec, &((VkDescriptorSetLayout *)val->pSetLayouts)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        val->pSetLayouts = NULL;
    }
}

static inline void
vn_decode_VkDescriptorSetAllocateInfo_temp(struct vn_cs_decoder *dec, VkDescriptorSetAllocateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkDescriptorSetAllocateInfo_pnext_temp(dec);
    vn_decode_VkDescriptorSetAllocateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkDescriptorSetAllocateInfo_handle_self(VkDescriptorSetAllocateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    vn_replace_VkDescriptorPool_handle(&val->descriptorPool);
    /* skip val->descriptorSetCount */
    if (val->pSetLayouts) {
       for (uint32_t i = 0; i < val->descriptorSetCount; i++)
            vn_replace_VkDescriptorSetLayout_handle(&((VkDescriptorSetLayout *)val->pSetLayouts)[i]);
    }
}

static inline void
vn_replace_VkDescriptorSetAllocateInfo_handle(VkDescriptorSetAllocateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO:
            vn_replace_VkDescriptorSetAllocateInfo_handle_self((VkDescriptorSetAllocateInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO:
            vn_replace_VkDescriptorSetVariableDescriptorCountAllocateInfo_handle_self((VkDescriptorSetVariableDescriptorCountAllocateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkDescriptorImageInfo */

static inline void
vn_decode_VkDescriptorImageInfo_temp(struct vn_cs_decoder *dec, VkDescriptorImageInfo *val)
{
    vn_decode_VkSampler_lookup(dec, &val->sampler);
    vn_decode_VkImageView_lookup(dec, &val->imageView);
    vn_decode_VkImageLayout(dec, &val->imageLayout);
}

static inline void
vn_replace_VkDescriptorImageInfo_handle(VkDescriptorImageInfo *val)
{
    vn_replace_VkSampler_handle(&val->sampler);
    vn_replace_VkImageView_handle(&val->imageView);
    /* skip val->imageLayout */
}

/* struct VkDescriptorBufferInfo */

static inline void
vn_decode_VkDescriptorBufferInfo_temp(struct vn_cs_decoder *dec, VkDescriptorBufferInfo *val)
{
    vn_decode_VkBuffer_lookup(dec, &val->buffer);
    vn_decode_VkDeviceSize(dec, &val->offset);
    vn_decode_VkDeviceSize(dec, &val->range);
}

static inline void
vn_replace_VkDescriptorBufferInfo_handle(VkDescriptorBufferInfo *val)
{
    vn_replace_VkBuffer_handle(&val->buffer);
    /* skip val->offset */
    /* skip val->range */
}

/* struct VkWriteDescriptorSet chain */

static inline void *
vn_decode_VkWriteDescriptorSet_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkWriteDescriptorSet_self_temp(struct vn_cs_decoder *dec, VkWriteDescriptorSet *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkDescriptorSet_lookup(dec, &val->dstSet);
    vn_decode_uint32_t(dec, &val->dstBinding);
    vn_decode_uint32_t(dec, &val->dstArrayElement);
    vn_decode_uint32_t(dec, &val->descriptorCount);
    vn_decode_VkDescriptorType(dec, &val->descriptorType);
    if (vn_peek_array_size(dec)) {
        val->pImageInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pImageInfo) * val->descriptorCount);
        if (!val->pImageInfo) return;
        vn_decode_array_size(dec, val->descriptorCount);
        for (uint32_t i = 0; i < val->descriptorCount; i++)
            vn_decode_VkDescriptorImageInfo_temp(dec, &((VkDescriptorImageInfo *)val->pImageInfo)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        val->pImageInfo = NULL;
    }
    if (vn_peek_array_size(dec)) {
        val->pBufferInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pBufferInfo) * val->descriptorCount);
        if (!val->pBufferInfo) return;
        vn_decode_array_size(dec, val->descriptorCount);
        for (uint32_t i = 0; i < val->descriptorCount; i++)
            vn_decode_VkDescriptorBufferInfo_temp(dec, &((VkDescriptorBufferInfo *)val->pBufferInfo)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        val->pBufferInfo = NULL;
    }
    if (vn_peek_array_size(dec)) {
        val->pTexelBufferView = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pTexelBufferView) * val->descriptorCount);
        if (!val->pTexelBufferView) return;
        vn_decode_array_size(dec, val->descriptorCount);
        for (uint32_t i = 0; i < val->descriptorCount; i++)
            vn_decode_VkBufferView_lookup(dec, &((VkBufferView *)val->pTexelBufferView)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        val->pTexelBufferView = NULL;
    }
}

static inline void
vn_decode_VkWriteDescriptorSet_temp(struct vn_cs_decoder *dec, VkWriteDescriptorSet *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET);

    val->sType = stype;
    val->pNext = vn_decode_VkWriteDescriptorSet_pnext_temp(dec);
    vn_decode_VkWriteDescriptorSet_self_temp(dec, val);
}

static inline void
vn_replace_VkWriteDescriptorSet_handle_self(VkWriteDescriptorSet *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    vn_replace_VkDescriptorSet_handle(&val->dstSet);
    /* skip val->dstBinding */
    /* skip val->dstArrayElement */
    /* skip val->descriptorCount */
    /* skip val->descriptorType */
    if (val->pImageInfo) {
       for (uint32_t i = 0; i < val->descriptorCount; i++)
            vn_replace_VkDescriptorImageInfo_handle(&((VkDescriptorImageInfo *)val->pImageInfo)[i]);
    }
    if (val->pBufferInfo) {
       for (uint32_t i = 0; i < val->descriptorCount; i++)
            vn_replace_VkDescriptorBufferInfo_handle(&((VkDescriptorBufferInfo *)val->pBufferInfo)[i]);
    }
    if (val->pTexelBufferView) {
       for (uint32_t i = 0; i < val->descriptorCount; i++)
            vn_replace_VkBufferView_handle(&((VkBufferView *)val->pTexelBufferView)[i]);
    }
}

static inline void
vn_replace_VkWriteDescriptorSet_handle(VkWriteDescriptorSet *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET:
            vn_replace_VkWriteDescriptorSet_handle_self((VkWriteDescriptorSet *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkCopyDescriptorSet chain */

static inline void *
vn_decode_VkCopyDescriptorSet_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkCopyDescriptorSet_self_temp(struct vn_cs_decoder *dec, VkCopyDescriptorSet *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkDescriptorSet_lookup(dec, &val->srcSet);
    vn_decode_uint32_t(dec, &val->srcBinding);
    vn_decode_uint32_t(dec, &val->srcArrayElement);
    vn_decode_VkDescriptorSet_lookup(dec, &val->dstSet);
    vn_decode_uint32_t(dec, &val->dstBinding);
    vn_decode_uint32_t(dec, &val->dstArrayElement);
    vn_decode_uint32_t(dec, &val->descriptorCount);
}

static inline void
vn_decode_VkCopyDescriptorSet_temp(struct vn_cs_decoder *dec, VkCopyDescriptorSet *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_COPY_DESCRIPTOR_SET);

    val->sType = stype;
    val->pNext = vn_decode_VkCopyDescriptorSet_pnext_temp(dec);
    vn_decode_VkCopyDescriptorSet_self_temp(dec, val);
}

static inline void
vn_replace_VkCopyDescriptorSet_handle_self(VkCopyDescriptorSet *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    vn_replace_VkDescriptorSet_handle(&val->srcSet);
    /* skip val->srcBinding */
    /* skip val->srcArrayElement */
    vn_replace_VkDescriptorSet_handle(&val->dstSet);
    /* skip val->dstBinding */
    /* skip val->dstArrayElement */
    /* skip val->descriptorCount */
}

static inline void
vn_replace_VkCopyDescriptorSet_handle(VkCopyDescriptorSet *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_COPY_DESCRIPTOR_SET:
            vn_replace_VkCopyDescriptorSet_handle_self((VkCopyDescriptorSet *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

static inline void vn_decode_vkAllocateDescriptorSets_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkAllocateDescriptorSets *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    if (vn_decode_simple_pointer(dec)) {
        args->pAllocateInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pAllocateInfo));
        if (!args->pAllocateInfo) return;
        vn_decode_VkDescriptorSetAllocateInfo_temp(dec, (VkDescriptorSetAllocateInfo *)args->pAllocateInfo);
    } else {
        args->pAllocateInfo = NULL;
    }
    if (vn_peek_array_size(dec)) {
        args->pDescriptorSets = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pDescriptorSets) * args->pAllocateInfo->descriptorSetCount);
        if (!args->pDescriptorSets) return;
        vn_decode_array_size(dec, args->pAllocateInfo->descriptorSetCount);
        for (uint32_t i = 0; i < args->pAllocateInfo->descriptorSetCount; i++)
            vn_decode_VkDescriptorSet(dec, &args->pDescriptorSets[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pDescriptorSets = NULL;
    }
}

static inline void vn_replace_vkAllocateDescriptorSets_args_handle(struct vn_command_vkAllocateDescriptorSets *args)
{
    vn_replace_VkDevice_handle(&args->device);
    if (args->pAllocateInfo)
        vn_replace_VkDescriptorSetAllocateInfo_handle((VkDescriptorSetAllocateInfo *)args->pAllocateInfo);
    /* skip args->pDescriptorSets */
}

static inline void vn_encode_vkAllocateDescriptorSets_reply(struct vn_cs_encoder *enc, const struct vn_command_vkAllocateDescriptorSets *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkAllocateDescriptorSets_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->device */
    /* skip args->pAllocateInfo */
    if (args->pDescriptorSets) {
        vn_encode_array_size(enc, args->pAllocateInfo->descriptorSetCount);
        for (uint32_t i = 0; i < args->pAllocateInfo->descriptorSetCount; i++)
            vn_encode_VkDescriptorSet(enc, &args->pDescriptorSets[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void vn_decode_vkFreeDescriptorSets_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkFreeDescriptorSets *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_VkDescriptorPool_lookup(dec, &args->descriptorPool);
    vn_decode_uint32_t(dec, &args->descriptorSetCount);
    if (vn_peek_array_size(dec)) {
        args->pDescriptorSets = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pDescriptorSets) * args->descriptorSetCount);
        if (!args->pDescriptorSets) return;
        vn_decode_array_size(dec, args->descriptorSetCount);
        for (uint32_t i = 0; i < args->descriptorSetCount; i++)
            vn_decode_VkDescriptorSet_lookup(dec, &((VkDescriptorSet *)args->pDescriptorSets)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pDescriptorSets = NULL;
    }
}

static inline void vn_replace_vkFreeDescriptorSets_args_handle(struct vn_command_vkFreeDescriptorSets *args)
{
    vn_replace_VkDevice_handle(&args->device);
    vn_replace_VkDescriptorPool_handle(&args->descriptorPool);
    /* skip args->descriptorSetCount */
    if (args->pDescriptorSets) {
       for (uint32_t i = 0; i < args->descriptorSetCount; i++)
            vn_replace_VkDescriptorSet_handle(&((VkDescriptorSet *)args->pDescriptorSets)[i]);
    }
}

static inline void vn_encode_vkFreeDescriptorSets_reply(struct vn_cs_encoder *enc, const struct vn_command_vkFreeDescriptorSets *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkFreeDescriptorSets_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->device */
    /* skip args->descriptorPool */
    /* skip args->descriptorSetCount */
    /* skip args->pDescriptorSets */
}

static inline void vn_decode_vkUpdateDescriptorSets_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkUpdateDescriptorSets *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_uint32_t(dec, &args->descriptorWriteCount);
    if (vn_peek_array_size(dec)) {
        args->pDescriptorWrites = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pDescriptorWrites) * args->descriptorWriteCount);
        if (!args->pDescriptorWrites) return;
        vn_decode_array_size(dec, args->descriptorWriteCount);
        for (uint32_t i = 0; i < args->descriptorWriteCount; i++)
            vn_decode_VkWriteDescriptorSet_temp(dec, &((VkWriteDescriptorSet *)args->pDescriptorWrites)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pDescriptorWrites = NULL;
    }
    vn_decode_uint32_t(dec, &args->descriptorCopyCount);
    if (vn_peek_array_size(dec)) {
        args->pDescriptorCopies = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pDescriptorCopies) * args->descriptorCopyCount);
        if (!args->pDescriptorCopies) return;
        vn_decode_array_size(dec, args->descriptorCopyCount);
        for (uint32_t i = 0; i < args->descriptorCopyCount; i++)
            vn_decode_VkCopyDescriptorSet_temp(dec, &((VkCopyDescriptorSet *)args->pDescriptorCopies)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pDescriptorCopies = NULL;
    }
}

static inline void vn_replace_vkUpdateDescriptorSets_args_handle(struct vn_command_vkUpdateDescriptorSets *args)
{
    vn_replace_VkDevice_handle(&args->device);
    /* skip args->descriptorWriteCount */
    if (args->pDescriptorWrites) {
       for (uint32_t i = 0; i < args->descriptorWriteCount; i++)
            vn_replace_VkWriteDescriptorSet_handle(&((VkWriteDescriptorSet *)args->pDescriptorWrites)[i]);
    }
    /* skip args->descriptorCopyCount */
    if (args->pDescriptorCopies) {
       for (uint32_t i = 0; i < args->descriptorCopyCount; i++)
            vn_replace_VkCopyDescriptorSet_handle(&((VkCopyDescriptorSet *)args->pDescriptorCopies)[i]);
    }
}

static inline void vn_encode_vkUpdateDescriptorSets_reply(struct vn_cs_encoder *enc, const struct vn_command_vkUpdateDescriptorSets *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkUpdateDescriptorSets_EXT});

    /* skip args->device */
    /* skip args->descriptorWriteCount */
    /* skip args->pDescriptorWrites */
    /* skip args->descriptorCopyCount */
    /* skip args->pDescriptorCopies */
}

static inline void vn_dispatch_vkAllocateDescriptorSets(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkAllocateDescriptorSets args;

    if (!ctx->dispatch_vkAllocateDescriptorSets) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkAllocateDescriptorSets_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkAllocateDescriptorSets(ctx, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && args.ret < VK_SUCCESS) {
        switch (args.ret) {
        case VK_ERROR_FORMAT_NOT_SUPPORTED:
            break;
        default:
            vn_dispatch_debug_log(ctx, "vkAllocateDescriptorSets returned %d", args.ret);
            break;
        }
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkAllocateDescriptorSets_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkFreeDescriptorSets(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkFreeDescriptorSets args;

    if (!ctx->dispatch_vkFreeDescriptorSets) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkFreeDescriptorSets_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkFreeDescriptorSets(ctx, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && args.ret < VK_SUCCESS) {
        switch (args.ret) {
        case VK_ERROR_FORMAT_NOT_SUPPORTED:
            break;
        default:
            vn_dispatch_debug_log(ctx, "vkFreeDescriptorSets returned %d", args.ret);
            break;
        }
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkFreeDescriptorSets_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkUpdateDescriptorSets(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkUpdateDescriptorSets args;

    if (!ctx->dispatch_vkUpdateDescriptorSets) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkUpdateDescriptorSets_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkUpdateDescriptorSets(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkUpdateDescriptorSets_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

#endif /* VN_PROTOCOL_RENDERER_DESCRIPTOR_SET_H */
