/*
 * Copyright (C) 2016 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"

#if ENABLE(VARIATION_FONTS)

#include "CSSFontVariationValue.h"

#include <wtf/text/StringBuilder.h>

namespace WebCore {

CSSFontVariationValue::CSSFontVariationValue(FontTag tag, float value)
    : CSSValue(FontVariationClass)
    , m_tag(tag)
    , m_value(value)
{
}

String CSSFontVariationValue::customCSSText() const
{
    StringBuilder builder;
    builder.append('\'');
    for (char c : m_tag)
        builder.append(c);
    builder.appendLiteral("' ");
    builder.appendNumber(m_value);
    return builder.toString();
}

bool CSSFontVariationValue::equals(const CSSFontVariationValue& other) const
{
    return m_tag == other.m_tag && m_value == other.m_value;
}

}

#endif // ENABLE(VARIATION_FONTS)
