/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* Test of DBG_*() and dfnstat() */
#include <stdio.h>
#ifndef _MICROC_
#include <stdlib.h>
#include <string.h>
#endif
#define SUPPL_LOG_MEMORY
#define SUPPL_LOG_FUNCTION
#include "suppldbg.h"
#include "dfn.h"

void hlpScreen()
{	exit(127);
}

static void t1(int fmodes, int attr, char *fattr)
{	DBG_ENTER("t1", "usr")

	DBG_INFO( ("condition is %s", (fmodes & attr)? "true": "false") )

	printf("is %s: %s\n"
	 , fattr, (fmodes & attr) != 0? "yes": "no");

	DBG_EXIT
}

static void t(int fmodes, int attr, char *fattr)
{	DBG_ENTER("t", "usr")
	DBG_ARGUMENTS( ("fmode=0x%04x, attr=0x%04x, fattr=\"%s\""
		, fmodes, attr, fattr) )

	assert(fattr);

		/* Change the logging modes temporarily */
	DBG_PUSH_STATE
		/* Change logging so that file "t.c" is no longer logged at all */
//	DBG_CHANGE_STATE("C-SUPPL;f-t.c")

	t1(fmodes, attr, fattr);

	DBG_POP_STATE

	DBG_EXIT
}

main(int argc, char **argv)
{	int a;

	/** The DBG_ENTER() macro is used in its broken up format
		in order to have the opening of "main" to be logged **/
	DBG_ENTER1
		/* log everything incl. SUPPL library */
	DBG_CHANGE_STATE("l+;C+,+SUPPL")
	DBG_ENTER2("main", "usr")

	if(argc <= 1) {
		puts("Requires one argument to retrieve the attribues from");
		DBG_RETURN_U( 40)
	}
	printf("%s = 0x%x\n", argv[1], a = dfnstat(argv[1]));
	t(a, DFN_WRITE, "writeable");
	t(a, DFN_READ, "readable");
	t(a, DFN_FILE, "file");
	t(a, DFN_DIRECTORY, "directory");
	t(a, DFN_LABEL, "volume label");
	t(a, DFN_HIDDEN, "hidden");
	t(a, DFN_SYSTEM, "important for system");

	DBG_RETURN_U( 0)
}
