/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Map;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Illumina;
import picard.illumina.IlluminaLaneMetrics;
import picard.illumina.IlluminaPhasingMetrics;
import picard.illumina.parser.ReadStructure;
import picard.illumina.parser.Tile;
import picard.illumina.parser.TileMetricsUtil;

@CommandLineProgramProperties(usage="Collects Illumina lane metrics for the given basecalling analysis directory", usageShort="Collects Illumina lane metrics for the given basecalling analysis directory", programGroup=Illumina.class)
public class CollectIlluminaLaneMetrics
extends CommandLineProgram {
    static final String USAGE = "Collects Illumina lane metrics for the given basecalling analysis directory";
    @Option(doc="The Illumina run directory of the run for which the lane metrics are to be generated")
    public File RUN_DIRECTORY;
    @Option(doc="The directory to which the output file will be written")
    public File OUTPUT_DIRECTORY;
    @Option(doc="The prefix to be prepended to the file name of the output file; an appropriate suffix will be applied", shortName="O")
    public String OUTPUT_PREFIX;
    @Option(doc="A description of the logical structure of clusters in an Illumina Run, i.e. a description of the structure IlluminaBasecallsToSam assumes the  data to be in. It should consist of integer/character pairs describing the number of cycles and the type of those cycles (B for Barcode, T for Template, and S for skip).  E.g. If the input data consists of 80 base clusters and we provide a read structure of \"36T8B8S28T\" then, before being converted to SAM records those bases will be split into 4 reads where read one consists of 36 cycles of template, read two consists of 8 cycles of barcode, read three will be an 8 base read of skipped cycles and read four is another 28 cycle template read.  The read consisting of skipped cycles would NOT be included in output SAM/BAM file read groups.", shortName="RS")
    public ReadStructure READ_STRUCTURE;

    @Override
    protected int doWork() {
        MetricsFile laneMetricsFile = this.getMetricsFile();
        MetricsFile phasingMetricsFile = this.getMetricsFile();
        IlluminaLaneMetricsCollector.collectLaneMetrics(this.RUN_DIRECTORY, this.OUTPUT_DIRECTORY, this.OUTPUT_PREFIX, laneMetricsFile, phasingMetricsFile, this.READ_STRUCTURE);
        return 0;
    }

    public static void main(String[] args) {
        new CollectIlluminaLaneMetrics().instanceMainWithExit(args);
    }

    public static class IlluminaLaneMetricsCollector {
        private static final Log LOG = Log.getInstance(IlluminaLaneMetricsCollector.class);

        public static Map<Integer, Collection<Tile>> readLaneTiles(File illuminaRunDirectory, ReadStructure readStructure) {
            Collection<Tile> tiles;
            try {
                tiles = TileMetricsUtil.parseTileMetrics(TileMetricsUtil.renderTileMetricsFileFromBasecallingDirectory(illuminaRunDirectory), readStructure);
            }
            catch (FileNotFoundException e) {
                throw new PicardException("Unable to open laneMetrics file.", e);
            }
            return CollectionUtil.partition(tiles, (CollectionUtil.Partitioner)new CollectionUtil.Partitioner<Tile, Integer>(){

                public Integer getPartition(Tile tile) {
                    return tile.getLaneNumber();
                }
            });
        }

        public static void collectLaneMetrics(File runDirectory, File outputDirectory, String outputPrefix, MetricsFile<MetricBase, Comparable<?>> laneMetricsFile, MetricsFile<MetricBase, Comparable<?>> phasingMetricsFile, ReadStructure readStructure) {
            Map<Integer, Collection<Tile>> laneTiles = IlluminaLaneMetricsCollector.readLaneTiles(runDirectory, readStructure);
            IlluminaLaneMetricsCollector.writeLaneMetrics(laneTiles, outputDirectory, outputPrefix, laneMetricsFile);
            IlluminaLaneMetricsCollector.writePhasingMetrics(laneTiles, outputDirectory, outputPrefix, phasingMetricsFile);
        }

        public static File writePhasingMetrics(Map<Integer, Collection<Tile>> laneTiles, File outputDirectory, String outputPrefix, MetricsFile<MetricBase, Comparable<?>> phasingMetricsFile) {
            for (Map.Entry<Integer, Collection<Tile>> entry : laneTiles.entrySet()) {
                for (IlluminaPhasingMetrics phasingMetric : IlluminaPhasingMetrics.getPhasingMetricsForTiles(entry.getKey().longValue(), entry.getValue())) {
                    phasingMetricsFile.addMetric((MetricBase)phasingMetric);
                }
            }
            return IlluminaLaneMetricsCollector.writeMetrics(phasingMetricsFile, outputDirectory, outputPrefix, IlluminaPhasingMetrics.getExtension());
        }

        public static File writeLaneMetrics(Map<Integer, Collection<Tile>> laneTiles, File outputDirectory, String outputPrefix, MetricsFile<MetricBase, Comparable<?>> laneMetricsFile) {
            for (Map.Entry<Integer, Collection<Tile>> entry : laneTiles.entrySet()) {
                IlluminaLaneMetrics laneMetric = new IlluminaLaneMetrics();
                laneMetric.LANE = entry.getKey().longValue();
                laneMetric.CLUSTER_DENSITY = IlluminaLaneMetricsCollector.calculateLaneDensityFromTiles(entry.getValue());
                laneMetricsFile.addMetric((MetricBase)laneMetric);
            }
            return IlluminaLaneMetricsCollector.writeMetrics(laneMetricsFile, outputDirectory, outputPrefix, IlluminaLaneMetrics.getExtension());
        }

        private static File writeMetrics(MetricsFile<MetricBase, Comparable<?>> metricsFile, File outputDirectory, String outputPrefix, String outputExtension) {
            File outputFile = new File(outputDirectory, String.format("%s.%s", outputPrefix, outputExtension));
            LOG.info(new Object[]{String.format("Writing %s lane metrics to %s ...", metricsFile.getMetrics().size(), outputFile)});
            metricsFile.write(outputFile);
            return outputFile;
        }

        private static double calculateLaneDensityFromTiles(Collection<Tile> tiles) {
            double area = 0.0;
            double clusters = 0.0;
            for (Tile tile : tiles) {
                area += (double)(tile.getClusterCount() / tile.getClusterDensity());
                clusters += (double)tile.getClusterCount();
            }
            return clusters / area;
        }
    }
}

