/*################################################################################
# Linux Management Providers (LMP), OS provider package
# Copyright (C) 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
################################################################################*/

#include "OpenDRIM_RegisteredOSProfileAccess.h"

const string _InstanceID="OpenDRIM:OS:1.0.0";

int OS_OpenDRIM_RegisteredOSProfile_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int OS_OpenDRIM_RegisteredOSProfile_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int OS_OpenDRIM_RegisteredOSProfile_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_RegisteredOSProfile>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	OpenDRIM_RegisteredOSProfile instance;
	instance.setInstanceID(_InstanceID);
	
	if (discriminant == "ei")
		CF_assert(OS_OpenDRIM_RegisteredOSProfile_populate(instance, errorMessage));
	
	result.push_back(instance);
	_L_;
	return OK;
}

int OS_OpenDRIM_RegisteredOSProfile_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_RegisteredOSProfile& instance, const char** properties, string& errorMessage) {
	_E_;
	string InstanceID;
	instance.getInstanceID(InstanceID);
	
	if (!CF_strCmpNoCase(InstanceID, _InstanceID))
	{
		errorMessage="No Instance";
		return NOT_FOUND;
	}
	
	CF_assert(OS_OpenDRIM_RegisteredOSProfile_populate(instance, errorMessage));
	_L_;
	return OK;
}

int OS_OpenDRIM_RegisteredOSProfile_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredOSProfile& newInstance, const OpenDRIM_RegisteredOSProfile& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int OS_OpenDRIM_RegisteredOSProfile_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredOSProfile& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int OS_OpenDRIM_RegisteredOSProfile_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredOSProfile& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int OS_OpenDRIM_RegisteredOSProfile_populate(OpenDRIM_RegisteredOSProfile& instance, string& errorMessage) {
	_E_;
	
	vector<unsigned short> AdvertiseTypes;
	
	//Registred name of profile which is listed in Standard
	instance.setRegisteredName("OS Status");
	
	//Registred version of Profile
	instance.setRegisteredVersion("1.0.0");
	
	//OS Profile Registred organization - 2 (DMTF)
	instance.setRegisteredOrganization(2);
	
	AdvertiseTypes.push_back(2);			// Not Advertised
	instance.setAdvertiseTypes(AdvertiseTypes);
	
	_L_;
	return OK;
}

