#!/bin/sh
set -o errexit

###
# Copyright (c) 2015-2022, Antoine Le Gonidec <vv221@dotslashplay.it>
# Copyright (c) 2016-2022, Mopi
# Copyright (c) 2017-2022, Jacek Szafarkiewicz
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# This software is provided by the copyright holders and contributors "as is"
# and any express or implied warranties, including, but not limited to, the
# implied warranties of merchantability and fitness for a particular purpose
# are disclaimed. In no event shall the copyright holder or contributors be
# liable for any direct, indirect, incidental, special, exemplary, or
# consequential damages (including, but not limited to, procurement of
# substitute goods or services; loss of use, data, or profits; or business
# interruption) however caused and on any theory of liability, whether in
# contract, strict liability, or tort (including negligence or otherwise)
# arising in any way out of the use of this software, even if advised of the
# possibility of such damage.
###

###
# Anno 1503
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220115.5

# Set game-specific variables

GAME_ID='anno-1503'
GAME_NAME='Anno 1503'

ARCHIVE_BASE_EN_0='setup_anno_1503_2.0.0.5.exe'
ARCHIVE_BASE_EN_0_MD5='a7b6aeb2c5f96e2fab12d1ef12f3b4af'
ARCHIVE_BASE_EN_0_TYPE='innosetup'
ARCHIVE_BASE_EN_0_SIZE='1600000'
ARCHIVE_BASE_EN_0_VERSION='3.0.43-gog2.0.0.5'
ARCHIVE_BASE_EN_0_URL='https://www.gog.com/game/anno_1503_ad'

ARCHIVE_BASE_FR_0='setup_anno_1503_french_2.0.0.5.exe'
ARCHIVE_BASE_FR_0_MD5='b2ebc98d0dc97350ede75098633bfbd8'
ARCHIVE_BASE_FR_0_TYPE='innosetup'
ARCHIVE_BASE_FR_0_SIZE='1500000'
ARCHIVE_BASE_FR_0_VERSION='3.0.43-gog2.0.0.5'
ARCHIVE_BASE_FR_0_URL='https://www.gog.com/game/anno_1503_ad'

CONTENT_PATH_DEFAULT='app'
ARCHIVE_DOC_L10N_FILES='
manual.pdf'
ARCHIVE_GAME_BIN_FILES='
*.exe
*.dll'
ARCHIVE_GAME_L10N_FILES='
texte.dat
toolgfx/bodenschtze.inc
toolgfx/bodenschtze.tex
toolgfx/mainmedium8.zei
toolgfx/mainmedium.zei.old
toolgfx/mainsmall8.zei
toolgfx/pk_*.tex
toolgfx/startup.tex
videos/1001.bik
videos/1002.bik
videos/1004.bik
videos/1005.bik
videos/1006.bik
videos/1007.bik
videos/1009.bik
help
samples
scenes
speech'
ARCHIVE_GAME_DATA_FILES='
anlagen.dat
figuren*.dat
instanthelplinks.txt
videos/1000.bik
videos/1003.bik
videos/1008.bik
data
music
profiles
textures
toolgfx'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='1503startup.exe'
APP_MAIN_ICON='1503startup.exe'

PACKAGES_LIST='PKG_BIN PKG_L10N PKG_DATA'

PKG_L10N_ID="${GAME_ID}-l10n"
PKG_L10N_ID_EN="${PKG_L10N_ID}-en"
PKG_L10N_ID_FR="${PKG_L10N_ID}-fr"
PKG_L10N_PROVIDE="$PKG_L10N_ID"
PKG_L10N_DESCRIPTION_EN='English localization'
PKG_L10N_DESCRIPTION_FR='French localization'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID $PKG_L10N_ID wine"

# Work around missing background music
# cf. https://bugs.winehq.org/show_bug.cgi?id=16096

APP_WINETRICKS="$APP_WINETRICKS directmusic"
PKG_BIN_DEPS="$PKG_BIN_DEPS winetricks"

# Use persistent storage for user data

DATA_DIRS="$DATA_DIRS ./SaveGame"

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_BIN'
icons_get_from_package 'APP_MAIN'
icons_move_to 'PKG_DATA'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
