//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _sphusp_10.cc
// Copyright (C) 2014 Toru Shiozaki
//
// Author: Hai-Anh Le <anh@u.northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <cassert>
#include <src/integral/ecp/sphusplist.h>

using namespace std;
using namespace bagel;

vector<double> SphUSPList::sphusp_10(const int m) {

  vector<double> c;
  constexpr double coeff[1386] = {   0.000000000000000e+00,   7.673951182219900e+00,   0.000000000000000e+00,  -9.208741418663880e+01,   0.000000000000000e+00,
   1.933835697919415e+02,   0.000000000000000e+00,  -9.208741418663880e+01,   0.000000000000000e+00,   7.673951182219900e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   3.088705769902543e+01,   0.000000000000000e+00,  -2.882792051909040e+02,
   0.000000000000000e+00,   4.324188077863560e+02,   0.000000000000000e+00,  -1.235482307961017e+02,   0.000000000000000e+00,
   3.431895299891714e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,  -4.453815461763347e+00,   0.000000000000000e+00,   2.672289277058008e+01,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,  -2.672289277058008e+01,   0.000000000000000e+00,   4.453815461763347e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   8.016867831174025e+01,   0.000000000000000e+00,  -5.611807481821818e+02,
   0.000000000000000e+00,   5.611807481821818e+02,   0.000000000000000e+00,  -8.016867831174025e+01,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,  -2.863763513582591e+01,   0.000000000000000e+00,   1.145505405433037e+02,
   0.000000000000000e+00,   5.727527027165183e+01,   0.000000000000000e+00,  -8.182181467378832e+01,   0.000000000000000e+00,
   4.091090733689416e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   1.527340540577382e+02,   0.000000000000000e+00,  -7.636702702886910e+02,   0.000000000000000e+00,
   4.582021621732146e+02,   0.000000000000000e+00,  -2.181915057967689e+01,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   2.976705744527138e+00,   0.000000000000000e+00,  -3.968940992702851e+00,   0.000000000000000e+00,
  -1.389129347445998e+01,   0.000000000000000e+00,  -3.968940992702851e+00,   0.000000000000000e+00,   2.976705744527138e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,  -9.525458382486842e+01,   0.000000000000000e+00,   2.222606955913596e+02,
   0.000000000000000e+00,   2.222606955913596e+02,   0.000000000000000e+00,  -9.525458382486842e+01,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   2.222606955913596e+02,
   0.000000000000000e+00,  -7.408689853045321e+02,   0.000000000000000e+00,   2.222606955913596e+02,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   2.218705464592268e+01,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,  -6.212375300858349e+01,   0.000000000000000e+00,  -3.549928743347628e+01,   0.000000000000000e+00,
   4.437410929184535e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,  -2.070791766952783e+02,   0.000000000000000e+00,   2.070791766952783e+02,   0.000000000000000e+00,
   3.727425180515010e+02,   0.000000000000000e+00,  -4.141583533905567e+01,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   2.484950120343340e+02,   0.000000000000000e+00,  -4.969900240686679e+02,   0.000000000000000e+00,
   4.969900240686680e+01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,  -1.870976726712969e+00,   0.000000000000000e+00,  -3.741953453425938e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   3.741953453425938e+00,   0.000000000000000e+00,   1.870976726712969e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   7.858102252194469e+01,   0.000000000000000e+00,   7.858102252194469e+01,
   0.000000000000000e+00,  -7.858102252194469e+01,   0.000000000000000e+00,  -7.858102252194469e+01,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,  -3.143240900877788e+02,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   3.143240900877788e+02,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   2.095493933918525e+02,   0.000000000000000e+00,  -2.095493933918525e+02,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,  -1.389129347445998e+01,   0.000000000000000e+00,  -3.704344926522661e+01,
   0.000000000000000e+00,  -2.778258694891996e+01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   4.630431158153326e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   1.666955216935197e+02,   0.000000000000000e+00,   2.778258694891995e+02,   0.000000000000000e+00,
   5.556517389783991e+01,   0.000000000000000e+00,  -5.556517389783991e+01,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,  -3.333910433870394e+02,   0.000000000000000e+00,  -2.222606955913596e+02,   0.000000000000000e+00,
   1.111303477956798e+02,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   1.270061117664912e+02,   0.000000000000000e+00,  -4.233537058883040e+01,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   9.081022627604556e-01,   0.000000000000000e+00,   3.632409051041822e+00,   0.000000000000000e+00,
   5.448613576562733e+00,   0.000000000000000e+00,   3.632409051041822e+00,   0.000000000000000e+00,   9.081022627604556e-01,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,  -4.358890861250187e+01,   0.000000000000000e+00,  -1.307667258375056e+02,
   0.000000000000000e+00,  -1.307667258375056e+02,   0.000000000000000e+00,  -4.358890861250187e+01,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   2.179445430625093e+02,
   0.000000000000000e+00,   4.358890861250187e+02,   0.000000000000000e+00,   2.179445430625093e+02,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,  -2.324741792666766e+02,   0.000000000000000e+00,  -2.324741792666766e+02,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   4.981589555714499e+01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   4.718637772708115e+00,   0.000000000000000e+00,   1.887455109083246e+01,
   0.000000000000000e+00,   2.831182663624869e+01,   0.000000000000000e+00,   1.887455109083246e+01,   0.000000000000000e+00,
   4.718637772708115e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,  -6.291517030277488e+01,   0.000000000000000e+00,  -1.887455109083246e+02,   0.000000000000000e+00,
  -1.887455109083246e+02,   0.000000000000000e+00,  -6.291517030277488e+01,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   1.509964087266597e+02,   0.000000000000000e+00,   3.019928174533194e+02,   0.000000000000000e+00,
   1.509964087266597e+02,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,  -8.628366212951983e+01,   0.000000000000000e+00,  -8.628366212951983e+01,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   9.587073569946647e+00,
   0.000000000000000e+00,  -3.181304937373671e-01,   0.000000000000000e+00,  -1.590652468686835e+00,   0.000000000000000e+00,  -3.181304937373671e+00,
   0.000000000000000e+00,  -3.181304937373671e+00,   0.000000000000000e+00,  -1.590652468686835e+00,   0.000000000000000e+00,
  -3.181304937373671e-01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   1.590652468686836e+01,   0.000000000000000e+00,   6.362609874747342e+01,   0.000000000000000e+00,
   9.543914812121012e+01,   0.000000000000000e+00,   6.362609874747342e+01,   0.000000000000000e+00,   1.590652468686836e+01,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,  -8.483479832996454e+01,   0.000000000000000e+00,
  -2.545043949898936e+02,   0.000000000000000e+00,  -2.545043949898936e+02,   0.000000000000000e+00,  -8.483479832996454e+01,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   1.018017579959575e+02,   0.000000000000000e+00,   2.036035159919149e+02,   0.000000000000000e+00,
   1.018017579959575e+02,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
  -2.908621657027356e+01,   0.000000000000000e+00,  -2.908621657027356e+01,   0.000000000000000e+00,   0.000000000000000e+00,
   1.292720736456603e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   4.718637772708115e+00,   0.000000000000000e+00,   1.887455109083246e+01,   0.000000000000000e+00,
   2.831182663624869e+01,   0.000000000000000e+00,   1.887455109083246e+01,   0.000000000000000e+00,   4.718637772708115e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
  -6.291517030277488e+01,   0.000000000000000e+00,  -1.887455109083246e+02,   0.000000000000000e+00,  -1.887455109083246e+02,
   0.000000000000000e+00,  -6.291517030277488e+01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   1.509964087266597e+02,   0.000000000000000e+00,   3.019928174533194e+02,   0.000000000000000e+00,   1.509964087266597e+02,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,  -8.628366212951983e+01,   0.000000000000000e+00,  -8.628366212951983e+01,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   9.587073569946647e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   4.540511313802278e-01,   0.000000000000000e+00,   1.362153394140683e+00,   0.000000000000000e+00,   9.081022627604556e-01,
   0.000000000000000e+00,  -9.081022627604556e-01,   0.000000000000000e+00,  -1.362153394140683e+00,   0.000000000000000e+00,
  -4.540511313802278e-01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,  -2.179445430625093e+01,   0.000000000000000e+00,  -4.358890861250187e+01,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   4.358890861250187e+01,   0.000000000000000e+00,   2.179445430625093e+01,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   1.089722715312547e+02,   0.000000000000000e+00,
   1.089722715312547e+02,   0.000000000000000e+00,  -1.089722715312547e+02,   0.000000000000000e+00,  -1.089722715312547e+02,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,  -1.162370896333383e+02,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   1.162370896333383e+02,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   2.490794777857250e+01,   0.000000000000000e+00,  -2.490794777857250e+01,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,  -4.630431158153326e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   2.778258694891996e+01,   0.000000000000000e+00,   3.704344926522661e+01,   0.000000000000000e+00,   1.389129347445998e+01,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   5.556517389783991e+01,   0.000000000000000e+00,  -5.556517389783991e+01,   0.000000000000000e+00,  -2.778258694891995e+02,
   0.000000000000000e+00,  -1.666955216935197e+02,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
  -1.111303477956798e+02,   0.000000000000000e+00,   2.222606955913596e+02,   0.000000000000000e+00,   3.333910433870394e+02,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   4.233537058883040e+01,   0.000000000000000e+00,  -1.270061117664912e+02,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,  -4.677441816782422e-01,   0.000000000000000e+00,   1.403232545034727e+00,   0.000000000000000e+00,   6.548418543495391e+00,
   0.000000000000000e+00,   6.548418543495391e+00,   0.000000000000000e+00,   1.403232545034727e+00,   0.000000000000000e+00,
  -4.677441816782422e-01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   1.964525563048617e+01,   0.000000000000000e+00,  -7.858102252194469e+01,   0.000000000000000e+00,
  -1.964525563048617e+02,   0.000000000000000e+00,  -7.858102252194469e+01,   0.000000000000000e+00,   1.964525563048617e+01,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,  -7.858102252194469e+01,   0.000000000000000e+00,
   3.929051126097235e+02,   0.000000000000000e+00,   3.929051126097235e+02,   0.000000000000000e+00,  -7.858102252194469e+01,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   5.238734834796313e+01,   0.000000000000000e+00,  -3.143240900877788e+02,   0.000000000000000e+00,
   5.238734834796313e+01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   4.437410929184535e+00,   0.000000000000000e+00,  -3.549928743347628e+01,   0.000000000000000e+00,
  -6.212375300858349e+01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   2.218705464592268e+01,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
  -4.141583533905567e+01,   0.000000000000000e+00,   3.727425180515010e+02,   0.000000000000000e+00,   2.070791766952783e+02,
   0.000000000000000e+00,  -2.070791766952783e+02,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   4.969900240686680e+01,   0.000000000000000e+00,  -4.969900240686679e+02,   0.000000000000000e+00,   2.484950120343340e+02,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   4.961176240878564e-01,   0.000000000000000e+00,  -6.449529113142133e+00,   0.000000000000000e+00,  -6.945646737229989e+00,
   0.000000000000000e+00,   6.945646737229989e+00,   0.000000000000000e+00,   6.449529113142133e+00,   0.000000000000000e+00,
  -4.961176240878564e-01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,  -1.587576397081140e+01,   0.000000000000000e+00,   2.222606955913596e+02,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,  -2.222606955913596e+02,   0.000000000000000e+00,   1.587576397081140e+01,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   3.704344926522661e+01,   0.000000000000000e+00,
  -5.556517389783991e+02,   0.000000000000000e+00,   5.556517389783991e+02,   0.000000000000000e+00,  -3.704344926522661e+01,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,  -4.091090733689416e+00,   0.000000000000000e+00,   8.182181467378832e+01,   0.000000000000000e+00,
  -5.727527027165183e+01,   0.000000000000000e+00,  -1.145505405433037e+02,   0.000000000000000e+00,   2.863763513582591e+01,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   2.181915057967689e+01,   0.000000000000000e+00,  -4.582021621732146e+02,   0.000000000000000e+00,   7.636702702886910e+02,
   0.000000000000000e+00,  -1.527340540577382e+02,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,  -5.567269327204184e-01,   0.000000000000000e+00,   1.503162718345130e+01,   0.000000000000000e+00,  -2.338253117425757e+01,
   0.000000000000000e+00,  -2.338253117425757e+01,   0.000000000000000e+00,   1.503162718345130e+01,   0.000000000000000e+00,
  -5.567269327204184e-01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   1.002108478896753e+01,   0.000000000000000e+00,  -2.805903740910909e+02,   0.000000000000000e+00,
   7.014759352277272e+02,   0.000000000000000e+00,  -2.805903740910909e+02,   0.000000000000000e+00,   1.002108478896753e+01,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   3.431895299891714e+00,   0.000000000000000e+00,  -1.235482307961017e+02,   0.000000000000000e+00,
   4.324188077863560e+02,   0.000000000000000e+00,  -2.882792051909040e+02,   0.000000000000000e+00,   3.088705769902543e+01,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   7.673951182219900e-01,   0.000000000000000e+00,  -3.453278031998955e+01,   0.000000000000000e+00,   1.611529748266179e+02,
   0.000000000000000e+00,  -1.611529748266179e+02,   0.000000000000000e+00,   3.453278031998955e+01,   0.000000000000000e+00,
  -7.673951182219900e-01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00};

  assert(abs(m) <= 10);
  const int size_c = (10 + 1) * (10 + 2) / 2;
  const int mu = m + 10;
  const int i0 = mu * size_c;
  for (int i = i0; i != i0 + size_c; ++i) c.push_back(coeff[i]);
  return c;

}
