#!/usr/bin/env python
# -*- coding: utf-8 -*-
# generated by wxGlade 0.6.3 on Sun Jun 28 15:24:06 2009

import wx
import os, tempfile
import BIB

# begin wxGlade: extracode
# end wxGlade



class MoveFile(wx.Dialog):
    def __init__(self, *args, **kwds):
        # begin wxGlade: MoveFile.__init__
        kwds["style"] = wx.DEFAULT_DIALOG_STYLE
        wx.Dialog.__init__(self, *args, **kwds)
        self.label_1 = wx.StaticText(self, -1, "The selected file is not located in the default location\nWould you like to move and rename it?", style=wx.ALIGN_CENTRE)
        self.label_2 = wx.StaticText(self, -1, "Current location")
        self.text_ctrl_oldname = wx.TextCtrl(self, -1, "", style=wx.TE_READONLY)
        self.label_3 = wx.StaticText(self, -1, "Move to $FILES/")
        self.text_ctrl_newname = wx.TextCtrl(self, -1, "")
        self.static_line_1 = wx.StaticLine(self, -1)
        self.checkbox_dontask = wx.CheckBox(self, -1, "Do it automatically and don't ask again")
        self.static_line_2 = wx.StaticLine(self, -1)
        self.button_cancel = wx.Button(self, wx.ID_NO, "")
        self.button_yes = wx.Button(self, wx.ID_YES, "")

        self.__set_properties()
        self.__do_layout()

        self.Bind(wx.EVT_CHECKBOX, self.onCheck, self.checkbox_dontask)
        self.Bind(wx.EVT_BUTTON, self.onClose, self.button_cancel)
        self.Bind(wx.EVT_BUTTON, self.onOK, self.button_yes)
        # end wxGlade

    def __set_properties(self):
        # begin wxGlade: MoveFile.__set_properties
        self.SetTitle("Rename file")
        self.label_1.SetFont(wx.Font(12, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        self.button_yes.SetDefault()
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: MoveFile.__do_layout
        sizer_1 = wx.BoxSizer(wx.VERTICAL)
        sizer_2 = wx.BoxSizer(wx.HORIZONTAL)
        grid_sizer_1 = wx.FlexGridSizer(2, 2, 5, 5)
        sizer_1.Add(self.label_1, 0, wx.ALL, 5)
        grid_sizer_1.Add(self.label_2, 0, wx.ALIGN_CENTER_VERTICAL, 0)
        grid_sizer_1.Add(self.text_ctrl_oldname, 0, wx.EXPAND, 0)
        grid_sizer_1.Add(self.label_3, 0, wx.ALIGN_CENTER_VERTICAL, 0)
        grid_sizer_1.Add(self.text_ctrl_newname, 0, wx.EXPAND, 0)
        grid_sizer_1.AddGrowableCol(1)
        sizer_1.Add(grid_sizer_1, 1, wx.ALL|wx.EXPAND, 5)
        sizer_1.Add(self.static_line_1, 0, wx.EXPAND, 0)
        sizer_1.Add(self.checkbox_dontask, 0, wx.ALL, 5)
        sizer_1.Add(self.static_line_2, 0, wx.EXPAND, 0)
        sizer_2.Add(self.button_cancel, 0, wx.ALL, 5)
        sizer_2.Add(self.button_yes, 0, wx.ALL, 5)
        sizer_1.Add(sizer_2, 1, wx.ALIGN_RIGHT, 0)
        self.SetSizer(sizer_1)
        sizer_1.Fit(self)
        self.Layout()
        # end wxGlade

    def onCheck(self, event): # wxGlade: MoveFile.<event_handler>
        BIB.MOVEAUTO = self.checkbox_dontask.IsChecked()
    
    def __newname(self,identifier,extension):
        f = tempfile.NamedTemporaryFile('w+b',-1,extension,"%s_"%identifier, BIB.FILES )
        name = os.path.basename(f.name)
        f.close()
        return name
    
    def setValues(self,identifier,oldname,dontask):
        self.text_ctrl_oldname.SetValue(oldname)
        self.checkbox_dontask.SetValue(dontask)
        self.text_ctrl_newname.SetValue(\
            self.__newname(identifier,os.path.splitext(os.path.basename(oldname))[1]) )
            
    def rename(self):
        os.rename(self.text_ctrl_oldname.GetValue(),\
                os.path.join( BIB.FILES, self.text_ctrl_newname.GetValue() ))
        return os.path.join( BIB.FILES, self.text_ctrl_newname.GetValue() )

    def onClose(self, event): # wxGlade: MoveFile.<event_handler>
        self.EndModal( wx.ID_NO )

    def onOK(self, event): # wxGlade: MoveFile.<event_handler>
        self.EndModal( wx.ID_YES )

# end of class MoveFile


if __name__ == "__main__":
    app = wx.PySimpleApp(0)
    wx.InitAllImageHandlers()
    dialog_1 = MoveFile(None, -1, "")
    app.SetTopWindow(dialog_1)
    dialog_1.Show()
    app.MainLoop()
