"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Wizard = void 0;
const tslib_1 = require("tslib");
const jsx_runtime_1 = require("react/jsx-runtime");
const react_1 = require("react");
const react_styles_1 = require("@patternfly/react-styles");
const wizard_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/Wizard/wizard"));
const c_wizard_Height_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/c_wizard_Height'));
const types_1 = require("./types");
const utils_1 = require("./utils");
const WizardContext_1 = require("./WizardContext");
const WizardToggle_1 = require("./WizardToggle");
const WizardNavInternal_1 = require("./WizardNavInternal");
const Wizard = (_a) => {
    var { children, footer, height, width, className, header, nav, navAriaLabel, startIndex = 1, isVisitRequired = false, isProgressive = false, onStepChange, onSave, onClose, shouldFocusContent = true } = _a, wrapperProps = tslib_1.__rest(_a, ["children", "footer", "height", "width", "className", "header", "nav", "navAriaLabel", "startIndex", "isVisitRequired", "isProgressive", "onStepChange", "onSave", "onClose", "shouldFocusContent"]);
    const [activeStepIndex, setActiveStepIndex] = (0, react_1.useState)(startIndex);
    const initialSteps = (0, utils_1.buildSteps)(children);
    const firstStepRef = (0, react_1.useRef)(initialSteps[startIndex - 1]);
    const wrapperRef = (0, react_1.useRef)(null);
    // When the startIndex maps to a parent step, focus on the first sub-step
    (0, react_1.useEffect)(() => {
        if ((0, types_1.isWizardParentStep)(firstStepRef.current)) {
            setActiveStepIndex(startIndex + 1);
        }
    }, [startIndex]);
    // When the number of steps changes and pushes activeStepIndex out of bounds, reset back to startIndex
    (0, react_1.useEffect)(() => {
        if (activeStepIndex > initialSteps.length) {
            setActiveStepIndex(startIndex);
        }
    }, [initialSteps, activeStepIndex, startIndex]);
    const focusMainContentElement = () => setTimeout(() => {
        var _a;
        ((_a = wrapperRef === null || wrapperRef === void 0 ? void 0 : wrapperRef.current) === null || _a === void 0 ? void 0 : _a.focus) && wrapperRef.current.focus();
    }, 0);
    const goToNextStep = (event, steps = initialSteps) => {
        const newStep = steps.find((step) => step.index > activeStepIndex && (0, utils_1.isStepEnabled)(steps, step));
        if (activeStepIndex >= steps.length || !(newStep === null || newStep === void 0 ? void 0 : newStep.index)) {
            return onSave ? onSave(event) : onClose === null || onClose === void 0 ? void 0 : onClose(event);
        }
        setActiveStepIndex(newStep === null || newStep === void 0 ? void 0 : newStep.index);
        onStepChange === null || onStepChange === void 0 ? void 0 : onStepChange(event, newStep, steps[activeStepIndex - 1], types_1.WizardStepChangeScope.Next);
        shouldFocusContent && focusMainContentElement();
    };
    const goToPrevStep = (event, steps = initialSteps) => {
        const newStep = [...steps]
            .reverse()
            .find((step) => step.index < activeStepIndex && (0, utils_1.isStepEnabled)(steps, step));
        setActiveStepIndex(newStep === null || newStep === void 0 ? void 0 : newStep.index);
        onStepChange === null || onStepChange === void 0 ? void 0 : onStepChange(event, newStep, steps[activeStepIndex - 1], types_1.WizardStepChangeScope.Back);
        shouldFocusContent && focusMainContentElement();
    };
    const goToStepByIndex = (event, steps = initialSteps, index) => {
        const lastStepIndex = steps.length + 1;
        // Handle index when out of bounds or hidden
        if (index < 1) {
            index = 1;
        }
        else if (index > lastStepIndex) {
            index = lastStepIndex;
        }
        const currStep = steps[index - 1];
        const prevStep = steps[activeStepIndex - 1];
        setActiveStepIndex(index);
        onStepChange === null || onStepChange === void 0 ? void 0 : onStepChange(event, currStep, prevStep, types_1.WizardStepChangeScope.Nav);
    };
    const goToStepById = (steps = initialSteps, id) => {
        const step = steps.find((step) => step.id === id);
        const stepIndex = step === null || step === void 0 ? void 0 : step.index;
        const lastStepIndex = steps.length + 1;
        if (stepIndex > 0 && stepIndex < lastStepIndex && !step.isDisabled && !step.isHidden) {
            setActiveStepIndex(stepIndex);
        }
    };
    const goToStepByName = (steps = initialSteps, name) => {
        const step = steps.find((step) => step.name === name);
        const stepIndex = step === null || step === void 0 ? void 0 : step.index;
        const lastStepIndex = steps.length + 1;
        if (stepIndex > 0 && stepIndex < lastStepIndex && !step.isDisabled && !step.isHidden) {
            setActiveStepIndex(stepIndex);
        }
    };
    return ((0, jsx_runtime_1.jsx)(WizardContext_1.WizardContextProvider, { steps: initialSteps, activeStepIndex: activeStepIndex, footer: footer, onNext: goToNextStep, onBack: goToPrevStep, onClose: onClose, goToStepById: goToStepById, goToStepByName: goToStepByName, goToStepByIndex: goToStepByIndex, shouldFocusContent: shouldFocusContent, mainWrapperRef: wrapperRef, children: (0, jsx_runtime_1.jsxs)("div", Object.assign({ className: (0, react_styles_1.css)(wizard_1.default.wizard, className), style: Object.assign(Object.assign({}, (height ? { [c_wizard_Height_1.default.name]: typeof height === 'number' ? `${height}px` : height } : {})), (width ? { width } : {})) }, wrapperProps, { children: [header, (0, jsx_runtime_1.jsx)(WizardInternal, { nav: nav, navAriaLabel: navAriaLabel, isVisitRequired: isVisitRequired, isProgressive: isProgressive })] })) }));
};
exports.Wizard = Wizard;
const WizardInternal = ({ nav, navAriaLabel, isVisitRequired, isProgressive }) => {
    const { activeStep, steps, footer, goToStepByIndex } = (0, WizardContext_1.useWizardContext)();
    const [isNavExpanded, setIsNavExpanded] = (0, react_1.useState)(false);
    const wizardNav = (0, react_1.useMemo)(() => {
        if ((0, types_1.isCustomWizardNav)(nav)) {
            return typeof nav === 'function' ? nav(isNavExpanded, steps, activeStep, goToStepByIndex) : nav;
        }
        return ((0, jsx_runtime_1.jsx)(WizardNavInternal_1.WizardNavInternal, { nav: nav, navAriaLabel: navAriaLabel, isNavExpanded: isNavExpanded, isVisitRequired: isVisitRequired, isProgressive: isProgressive }));
    }, [activeStep, isVisitRequired, isProgressive, goToStepByIndex, isNavExpanded, nav, navAriaLabel, steps]);
    return ((0, jsx_runtime_1.jsx)(WizardToggle_1.WizardToggle, { nav: wizardNav, footer: footer, steps: steps, activeStep: activeStep, isNavExpanded: isNavExpanded, toggleNavExpanded: () => setIsNavExpanded((prevIsExpanded) => !prevIsExpanded) }));
};
exports.Wizard.displayName = 'Wizard';
//# sourceMappingURL=Wizard.js.map