#ifndef _MARKPOOL_H
#define _MARKPOOL_H

// A class that hands out fwmarks from a given range in a thread-safe fashion.
// If the range is empty, it returns 0.

#include <pthread.h>
#include <queue>

class MarkPool {
public:
	// Limits are [start, end>. Numbers are 16-bit, so above 65535 do not make sense.
	MarkPool(int start, int end);

	int get_mark();
	void release_mark(int mark);
	
private:
	int start, end;

	pthread_mutex_t mutex;
	std::queue<int> free_marks;
};

#endif  // !defined(_MARKPOOL_H)
