#include "sa_compare.h"

#include <arpa/inet.h>
#include <assert.h>
#include <string.h>

bool Sockaddr6Compare::operator() (const sockaddr_in6 &a, const sockaddr_in6 &b) const
{
	assert(a.sin6_family == AF_INET6);
	assert(b.sin6_family == AF_INET6);
	int addr_cmp = memcmp(&a.sin6_addr, &b.sin6_addr, sizeof(a.sin6_addr));
	if (addr_cmp == 0) {
		return (ntohs(a.sin6_port) < ntohs(b.sin6_port));
	} else {
		return (addr_cmp < 0);
	}
}
