/*********************                                                        */
/*! \file module_template.h
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2018 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Contains code for handling command-line options.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.h file.
 **/

#include "cvc4_private.h"

#ifndef __CVC4__OPTIONS__QUANTIFIERS_H
#define __CVC4__OPTIONS__QUANTIFIERS_H

#include "options/options.h"

#include "options/quantifiers_modes.h"


#define CVC4_OPTIONS__QUANTIFIERS__FOR_OPTION_HOLDER \
  aggressiveMiniscopeQuant__option_t::type aggressiveMiniscopeQuant;\
  bool aggressiveMiniscopeQuant__setByUser__; \
  cbqi__option_t::type cbqi;\
  bool cbqi__setByUser__; \
  cbqiAll__option_t::type cbqiAll;\
  bool cbqiAll__setByUser__; \
  cbqiBv__option_t::type cbqiBv;\
  bool cbqiBv__setByUser__; \
  cbqiBvConcInv__option_t::type cbqiBvConcInv;\
  bool cbqiBvConcInv__setByUser__; \
  cbqiBvIneqMode__option_t::type cbqiBvIneqMode;\
  bool cbqiBvIneqMode__setByUser__; \
  cbqiBvInterleaveValue__option_t::type cbqiBvInterleaveValue;\
  bool cbqiBvInterleaveValue__setByUser__; \
  cbqiBvLinearize__option_t::type cbqiBvLinearize;\
  bool cbqiBvLinearize__setByUser__; \
  cbqiBvRmExtract__option_t::type cbqiBvRmExtract;\
  bool cbqiBvRmExtract__setByUser__; \
  cbqiBvSolveNl__option_t::type cbqiBvSolveNl;\
  bool cbqiBvSolveNl__setByUser__; \
  cbqiFullEffort__option_t::type cbqiFullEffort;\
  bool cbqiFullEffort__setByUser__; \
  cbqiInnermost__option_t::type cbqiInnermost;\
  bool cbqiInnermost__setByUser__; \
  cbqiLitDepend__option_t::type cbqiLitDepend;\
  bool cbqiLitDepend__setByUser__; \
  cbqiMidpoint__option_t::type cbqiMidpoint;\
  bool cbqiMidpoint__setByUser__; \
  cbqiMinBounds__option_t::type cbqiMinBounds;\
  bool cbqiMinBounds__setByUser__; \
  cbqiModel__option_t::type cbqiModel;\
  bool cbqiModel__setByUser__; \
  cbqiMultiInst__option_t::type cbqiMultiInst;\
  bool cbqiMultiInst__setByUser__; \
  cbqiNestedQE__option_t::type cbqiNestedQE;\
  bool cbqiNestedQE__setByUser__; \
  cbqiNopt__option_t::type cbqiNopt;\
  bool cbqiNopt__setByUser__; \
  cbqiPreRegInst__option_t::type cbqiPreRegInst;\
  bool cbqiPreRegInst__setByUser__; \
  recurseCbqi__option_t::type recurseCbqi;\
  bool recurseCbqi__setByUser__; \
  cbqiRepeatLit__option_t::type cbqiRepeatLit;\
  bool cbqiRepeatLit__setByUser__; \
  cbqiRoundUpLowerLia__option_t::type cbqiRoundUpLowerLia;\
  bool cbqiRoundUpLowerLia__setByUser__; \
  cbqiSat__option_t::type cbqiSat;\
  bool cbqiSat__setByUser__; \
  cbqiUseInfInt__option_t::type cbqiUseInfInt;\
  bool cbqiUseInfInt__setByUser__; \
  cbqiUseInfReal__option_t::type cbqiUseInfReal;\
  bool cbqiUseInfReal__setByUser__; \
  cegisSample__option_t::type cegisSample;\
  bool cegisSample__setByUser__; \
  ceGuidedInst__option_t::type ceGuidedInst;\
  bool ceGuidedInst__setByUser__; \
  cegqiSingleInvAbort__option_t::type cegqiSingleInvAbort;\
  bool cegqiSingleInvAbort__setByUser__; \
  cegqiSingleInvPartial__option_t::type cegqiSingleInvPartial;\
  bool cegqiSingleInvPartial__setByUser__; \
  cegqiSingleInvReconstruct__option_t::type cegqiSingleInvReconstruct;\
  bool cegqiSingleInvReconstruct__setByUser__; \
  cegqiSingleInvReconstructConst__option_t::type cegqiSingleInvReconstructConst;\
  bool cegqiSingleInvReconstructConst__setByUser__; \
  cegqiSolMinCore__option_t::type cegqiSolMinCore;\
  bool cegqiSolMinCore__setByUser__; \
  cegqiSolMinInst__option_t::type cegqiSolMinInst;\
  bool cegqiSolMinInst__setByUser__; \
  cegqiSingleInvMode__option_t::type cegqiSingleInvMode;\
  bool cegqiSingleInvMode__setByUser__; \
  condRewriteQuant__option_t::type condRewriteQuant;\
  bool condRewriteQuant__setByUser__; \
  condVarSplitQuantAgg__option_t::type condVarSplitQuantAgg;\
  bool condVarSplitQuantAgg__setByUser__; \
  condVarSplitQuant__option_t::type condVarSplitQuant;\
  bool condVarSplitQuant__setByUser__; \
  conjectureFilterActiveTerms__option_t::type conjectureFilterActiveTerms;\
  bool conjectureFilterActiveTerms__setByUser__; \
  conjectureFilterCanonical__option_t::type conjectureFilterCanonical;\
  bool conjectureFilterCanonical__setByUser__; \
  conjectureFilterModel__option_t::type conjectureFilterModel;\
  bool conjectureFilterModel__setByUser__; \
  conjectureGen__option_t::type conjectureGen;\
  bool conjectureGen__setByUser__; \
  conjectureGenGtEnum__option_t::type conjectureGenGtEnum;\
  bool conjectureGenGtEnum__setByUser__; \
  conjectureGenMaxDepth__option_t::type conjectureGenMaxDepth;\
  bool conjectureGenMaxDepth__setByUser__; \
  conjectureGenPerRound__option_t::type conjectureGenPerRound;\
  bool conjectureGenPerRound__setByUser__; \
  conjectureUeeIntro__option_t::type conjectureUeeIntro;\
  bool conjectureUeeIntro__setByUser__; \
  conjectureNoFilter__option_t::type conjectureNoFilter;\
  bool conjectureNoFilter__setByUser__; \
  dtStcInduction__option_t::type dtStcInduction;\
  bool dtStcInduction__setByUser__; \
  dtVarExpandQuant__option_t::type dtVarExpandQuant;\
  bool dtVarExpandQuant__setByUser__; \
  eMatching__option_t::type eMatching;\
  bool eMatching__setByUser__; \
  elimExtArithQuant__option_t::type elimExtArithQuant;\
  bool elimExtArithQuant__setByUser__; \
  elimTautQuant__option_t::type elimTautQuant;\
  bool elimTautQuant__setByUser__; \
  finiteModelFind__option_t::type finiteModelFind;\
  bool finiteModelFind__setByUser__; \
  fmfBound__option_t::type fmfBound;\
  bool fmfBound__setByUser__; \
  fmfBoundInt__option_t::type fmfBoundInt;\
  bool fmfBoundInt__setByUser__; \
  fmfBoundLazy__option_t::type fmfBoundLazy;\
  bool fmfBoundLazy__setByUser__; \
  fmfBoundMinMode__option_t::type fmfBoundMinMode;\
  bool fmfBoundMinMode__setByUser__; \
  fmfEmptySorts__option_t::type fmfEmptySorts;\
  bool fmfEmptySorts__setByUser__; \
  fmfFmcSimple__option_t::type fmfFmcSimple;\
  bool fmfFmcSimple__setByUser__; \
  fmfFreshDistConst__option_t::type fmfFreshDistConst;\
  bool fmfFreshDistConst__setByUser__; \
  fmfFunWellDefined__option_t::type fmfFunWellDefined;\
  bool fmfFunWellDefined__setByUser__; \
  fmfFunWellDefinedRelevant__option_t::type fmfFunWellDefinedRelevant;\
  bool fmfFunWellDefinedRelevant__setByUser__; \
  fmfInstEngine__option_t::type fmfInstEngine;\
  bool fmfInstEngine__setByUser__; \
  fmfInstGen__option_t::type fmfInstGen;\
  bool fmfInstGen__setByUser__; \
  fmfInstGenOneQuantPerRound__option_t::type fmfInstGenOneQuantPerRound;\
  bool fmfInstGenOneQuantPerRound__setByUser__; \
  fullSaturateInterleave__option_t::type fullSaturateInterleave;\
  bool fullSaturateInterleave__setByUser__; \
  fullSaturateQuant__option_t::type fullSaturateQuant;\
  bool fullSaturateQuant__setByUser__; \
  fullSaturateQuantRd__option_t::type fullSaturateQuantRd;\
  bool fullSaturateQuantRd__setByUser__; \
  globalNegate__option_t::type globalNegate;\
  bool globalNegate__setByUser__; \
  hoMatching__option_t::type hoMatching;\
  bool hoMatching__setByUser__; \
  hoMatchingVarArgPriority__option_t::type hoMatchingVarArgPriority;\
  bool hoMatchingVarArgPriority__setByUser__; \
  hoMergeTermDb__option_t::type hoMergeTermDb;\
  bool hoMergeTermDb__setByUser__; \
  incrementTriggers__option_t::type incrementTriggers;\
  bool incrementTriggers__setByUser__; \
  inferArithTriggerEq__option_t::type inferArithTriggerEq;\
  bool inferArithTriggerEq__setByUser__; \
  inferArithTriggerEqExp__option_t::type inferArithTriggerEqExp;\
  bool inferArithTriggerEqExp__setByUser__; \
  instLevelInputOnly__option_t::type instLevelInputOnly;\
  bool instLevelInputOnly__setByUser__; \
  instMaxLevel__option_t::type instMaxLevel;\
  bool instMaxLevel__setByUser__; \
  instNoEntail__option_t::type instNoEntail;\
  bool instNoEntail__setByUser__; \
  instNoModelTrue__option_t::type instNoModelTrue;\
  bool instNoModelTrue__setByUser__; \
  instPropagate__option_t::type instPropagate;\
  bool instPropagate__setByUser__; \
  instWhenPhase__option_t::type instWhenPhase;\
  bool instWhenPhase__setByUser__; \
  instWhenStrictInterleave__option_t::type instWhenStrictInterleave;\
  bool instWhenStrictInterleave__setByUser__; \
  instWhenTcFirst__option_t::type instWhenTcFirst;\
  bool instWhenTcFirst__setByUser__; \
  instWhenMode__option_t::type instWhenMode;\
  bool instWhenMode__setByUser__; \
  intWfInduction__option_t::type intWfInduction;\
  bool intWfInduction__setByUser__; \
  iteDtTesterSplitQuant__option_t::type iteDtTesterSplitQuant;\
  bool iteDtTesterSplitQuant__setByUser__; \
  iteLiftQuant__option_t::type iteLiftQuant;\
  bool iteLiftQuant__setByUser__; \
  literalMatchMode__option_t::type literalMatchMode;\
  bool literalMatchMode__setByUser__; \
  localTheoryExt__option_t::type localTheoryExt;\
  bool localTheoryExt__setByUser__; \
  ltePartialInst__option_t::type ltePartialInst;\
  bool ltePartialInst__setByUser__; \
  lteRestrictInstClosure__option_t::type lteRestrictInstClosure;\
  bool lteRestrictInstClosure__setByUser__; \
  macrosQuant__option_t::type macrosQuant;\
  bool macrosQuant__setByUser__; \
  macrosQuantMode__option_t::type macrosQuantMode;\
  bool macrosQuantMode__setByUser__; \
  mbqiInterleave__option_t::type mbqiInterleave;\
  bool mbqiInterleave__setByUser__; \
  fmfOneInstPerRound__option_t::type fmfOneInstPerRound;\
  bool fmfOneInstPerRound__setByUser__; \
  fmfOneQuantPerRound__option_t::type fmfOneQuantPerRound;\
  bool fmfOneQuantPerRound__setByUser__; \
  mbqiMode__option_t::type mbqiMode;\
  bool mbqiMode__setByUser__; \
  miniscopeQuant__option_t::type miniscopeQuant;\
  bool miniscopeQuant__setByUser__; \
  miniscopeQuantFreeVar__option_t::type miniscopeQuantFreeVar;\
  bool miniscopeQuantFreeVar__setByUser__; \
  multiTriggerCache__option_t::type multiTriggerCache;\
  bool multiTriggerCache__setByUser__; \
  multiTriggerLinear__option_t::type multiTriggerLinear;\
  bool multiTriggerLinear__setByUser__; \
  multiTriggerPriority__option_t::type multiTriggerPriority;\
  bool multiTriggerPriority__setByUser__; \
  multiTriggerWhenSingle__option_t::type multiTriggerWhenSingle;\
  bool multiTriggerWhenSingle__setByUser__; \
  partialTriggers__option_t::type partialTriggers;\
  bool partialTriggers__setByUser__; \
  preSkolemQuant__option_t::type preSkolemQuant;\
  bool preSkolemQuant__setByUser__; \
  preSkolemQuantAgg__option_t::type preSkolemQuantAgg;\
  bool preSkolemQuantAgg__setByUser__; \
  preSkolemQuantNested__option_t::type preSkolemQuantNested;\
  bool preSkolemQuantNested__setByUser__; \
  prenexQuantUser__option_t::type prenexQuantUser;\
  bool prenexQuantUser__setByUser__; \
  prenexQuant__option_t::type prenexQuant;\
  bool prenexQuant__setByUser__; \
  pureThTriggers__option_t::type pureThTriggers;\
  bool pureThTriggers__setByUser__; \
  purifyDtTriggers__option_t::type purifyDtTriggers;\
  bool purifyDtTriggers__setByUser__; \
  purifyTriggers__option_t::type purifyTriggers;\
  bool purifyTriggers__setByUser__; \
  qcfAllConflict__option_t::type qcfAllConflict;\
  bool qcfAllConflict__setByUser__; \
  qcfEagerCheckRd__option_t::type qcfEagerCheckRd;\
  bool qcfEagerCheckRd__setByUser__; \
  qcfEagerTest__option_t::type qcfEagerTest;\
  bool qcfEagerTest__setByUser__; \
  qcfNestedConflict__option_t::type qcfNestedConflict;\
  bool qcfNestedConflict__setByUser__; \
  qcfSkipRd__option_t::type qcfSkipRd;\
  bool qcfSkipRd__setByUser__; \
  qcfTConstraint__option_t::type qcfTConstraint;\
  bool qcfTConstraint__setByUser__; \
  qcfVoExp__option_t::type qcfVoExp;\
  bool qcfVoExp__setByUser__; \
  quantAlphaEquiv__option_t::type quantAlphaEquiv;\
  bool quantAlphaEquiv__setByUser__; \
  quantAntiSkolem__option_t::type quantAntiSkolem;\
  bool quantAntiSkolem__setByUser__; \
  quantConflictFind__option_t::type quantConflictFind;\
  bool quantConflictFind__setByUser__; \
  qcfMode__option_t::type qcfMode;\
  bool qcfMode__setByUser__; \
  qcfWhenMode__option_t::type qcfWhenMode;\
  bool qcfWhenMode__setByUser__; \
  quantDynamicSplit__option_t::type quantDynamicSplit;\
  bool quantDynamicSplit__setByUser__; \
  quantEpr__option_t::type quantEpr;\
  bool quantEpr__setByUser__; \
  quantEprMatching__option_t::type quantEprMatching;\
  bool quantEprMatching__setByUser__; \
  quantFunWellDefined__option_t::type quantFunWellDefined;\
  bool quantFunWellDefined__setByUser__; \
  quantInduction__option_t::type quantInduction;\
  bool quantInduction__setByUser__; \
  quantModelEe__option_t::type quantModelEe;\
  bool quantModelEe__setByUser__; \
  quantRepMode__option_t::type quantRepMode;\
  bool quantRepMode__setByUser__; \
  quantSplit__option_t::type quantSplit;\
  bool quantSplit__setByUser__; \
  registerQuantBodyTerms__option_t::type registerQuantBodyTerms;\
  bool registerQuantBodyTerms__setByUser__; \
  relationalTriggers__option_t::type relationalTriggers;\
  bool relationalTriggers__setByUser__; \
  relevantTriggers__option_t::type relevantTriggers;\
  bool relevantTriggers__setByUser__; \
  quantRewriteRules__option_t::type quantRewriteRules;\
  bool quantRewriteRules__setByUser__; \
  rrOneInstPerRound__option_t::type rrOneInstPerRound;\
  bool rrOneInstPerRound__setByUser__; \
  strictTriggers__option_t::type strictTriggers;\
  bool strictTriggers__setByUser__; \
  sygusAddConstGrammar__option_t::type sygusAddConstGrammar;\
  bool sygusAddConstGrammar__setByUser__; \
  sygusInvAutoUnfold__option_t::type sygusInvAutoUnfold;\
  bool sygusInvAutoUnfold__setByUser__; \
  sygusBoolIteReturnConst__option_t::type sygusBoolIteReturnConst;\
  bool sygusBoolIteReturnConst__setByUser__; \
  sygusEvalUnfold__option_t::type sygusEvalUnfold;\
  bool sygusEvalUnfold__setByUser__; \
  sygusEvalUnfoldBool__option_t::type sygusEvalUnfoldBool;\
  bool sygusEvalUnfoldBool__setByUser__; \
  sygusExtRew__option_t::type sygusExtRew;\
  bool sygusExtRew__setByUser__; \
  sygusGrammarNorm__option_t::type sygusGrammarNorm;\
  bool sygusGrammarNorm__setByUser__; \
  sygusInference__option_t::type sygusInference;\
  bool sygusInference__setByUser__; \
  sygusInvTemplWhenSyntax__option_t::type sygusInvTemplWhenSyntax;\
  bool sygusInvTemplWhenSyntax__setByUser__; \
  sygusInvTemplMode__option_t::type sygusInvTemplMode;\
  bool sygusInvTemplMode__setByUser__; \
  sygusMinGrammar__option_t::type sygusMinGrammar;\
  bool sygusMinGrammar__setByUser__; \
  sygusUnifPbe__option_t::type sygusUnifPbe;\
  bool sygusUnifPbe__setByUser__; \
  sygusQePreproc__option_t::type sygusQePreproc;\
  bool sygusQePreproc__setByUser__; \
  sygusRefEval__option_t::type sygusRefEval;\
  bool sygusRefEval__setByUser__; \
  sygusRepairConst__option_t::type sygusRepairConst;\
  bool sygusRepairConst__setByUser__; \
  sygusRew__option_t::type sygusRew;\
  bool sygusRew__setByUser__; \
  sygusRewSynth__option_t::type sygusRewSynth;\
  bool sygusRewSynth__setByUser__; \
  sygusRewSynthAccel__option_t::type sygusRewSynthAccel;\
  bool sygusRewSynthAccel__setByUser__; \
  sygusRewSynthCheck__option_t::type sygusRewSynthCheck;\
  bool sygusRewSynthCheck__setByUser__; \
  sygusRewSynthFilterCong__option_t::type sygusRewSynthFilterCong;\
  bool sygusRewSynthFilterCong__setByUser__; \
  sygusRewSynthFilterMatch__option_t::type sygusRewSynthFilterMatch;\
  bool sygusRewSynthFilterMatch__setByUser__; \
  sygusRewSynthFilterOrder__option_t::type sygusRewSynthFilterOrder;\
  bool sygusRewSynthFilterOrder__setByUser__; \
  sygusRewVerify__option_t::type sygusRewVerify;\
  bool sygusRewVerify__setByUser__; \
  sygusRewVerifyAbort__option_t::type sygusRewVerifyAbort;\
  bool sygusRewVerifyAbort__setByUser__; \
  sygusSampleGrammar__option_t::type sygusSampleGrammar;\
  bool sygusSampleGrammar__setByUser__; \
  sygusSamples__option_t::type sygusSamples;\
  bool sygusSamples__setByUser__; \
  sygusStream__option_t::type sygusStream;\
  bool sygusStream__setByUser__; \
  sygusTemplEmbedGrammar__option_t::type sygusTemplEmbedGrammar;\
  bool sygusTemplEmbedGrammar__setByUser__; \
  sygusUnif__option_t::type sygusUnif;\
  bool sygusUnif__setByUser__; \
  termDbMode__option_t::type termDbMode;\
  bool termDbMode__setByUser__; \
  trackInstLemmas__option_t::type trackInstLemmas;\
  bool trackInstLemmas__setByUser__; \
  triggerActiveSelMode__option_t::type triggerActiveSelMode;\
  bool triggerActiveSelMode__setByUser__; \
  triggerSelMode__option_t::type triggerSelMode;\
  bool triggerSelMode__setByUser__; \
  userPatternsQuant__option_t::type userPatternsQuant;\
  bool userPatternsQuant__setByUser__; \
  varElimQuant__option_t::type varElimQuant;\
  bool varElimQuant__setByUser__; \
  varIneqElimQuant__option_t::type varIneqElimQuant;\
  bool varIneqElimQuant__setByUser__;


namespace CVC4 {

namespace options {

extern struct CVC4_PUBLIC aggressiveMiniscopeQuant__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} aggressiveMiniscopeQuant CVC4_PUBLIC;
extern struct CVC4_PUBLIC cbqi__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cbqi CVC4_PUBLIC;
extern struct CVC4_PUBLIC cbqiAll__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cbqiAll CVC4_PUBLIC;
extern struct CVC4_PUBLIC cbqiBv__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cbqiBv CVC4_PUBLIC;
extern struct CVC4_PUBLIC cbqiBvConcInv__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cbqiBvConcInv CVC4_PUBLIC;
extern struct CVC4_PUBLIC cbqiBvIneqMode__option_t
{
  typedef CVC4::theory::quantifiers::CbqiBvIneqMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cbqiBvIneqMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC cbqiBvInterleaveValue__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cbqiBvInterleaveValue CVC4_PUBLIC;
extern struct CVC4_PUBLIC cbqiBvLinearize__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cbqiBvLinearize CVC4_PUBLIC;
extern struct CVC4_PUBLIC cbqiBvRmExtract__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cbqiBvRmExtract CVC4_PUBLIC;
extern struct CVC4_PUBLIC cbqiBvSolveNl__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cbqiBvSolveNl CVC4_PUBLIC;
extern struct CVC4_PUBLIC cbqiFullEffort__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cbqiFullEffort CVC4_PUBLIC;
extern struct CVC4_PUBLIC cbqiInnermost__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cbqiInnermost CVC4_PUBLIC;
extern struct CVC4_PUBLIC cbqiLitDepend__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} cbqiLitDepend CVC4_PUBLIC;
extern struct CVC4_PUBLIC cbqiMidpoint__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cbqiMidpoint CVC4_PUBLIC;
extern struct CVC4_PUBLIC cbqiMinBounds__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} cbqiMinBounds CVC4_PUBLIC;
extern struct CVC4_PUBLIC cbqiModel__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cbqiModel CVC4_PUBLIC;
extern struct CVC4_PUBLIC cbqiMultiInst__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cbqiMultiInst CVC4_PUBLIC;
extern struct CVC4_PUBLIC cbqiNestedQE__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cbqiNestedQE CVC4_PUBLIC;
extern struct CVC4_PUBLIC cbqiNopt__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} cbqiNopt CVC4_PUBLIC;
extern struct CVC4_PUBLIC cbqiPreRegInst__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cbqiPreRegInst CVC4_PUBLIC;
extern struct CVC4_PUBLIC recurseCbqi__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} recurseCbqi CVC4_PUBLIC;
extern struct CVC4_PUBLIC cbqiRepeatLit__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cbqiRepeatLit CVC4_PUBLIC;
extern struct CVC4_PUBLIC cbqiRoundUpLowerLia__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} cbqiRoundUpLowerLia CVC4_PUBLIC;
extern struct CVC4_PUBLIC cbqiSat__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cbqiSat CVC4_PUBLIC;
extern struct CVC4_PUBLIC cbqiUseInfInt__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cbqiUseInfInt CVC4_PUBLIC;
extern struct CVC4_PUBLIC cbqiUseInfReal__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cbqiUseInfReal CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegisSample__option_t
{
  typedef CVC4::theory::quantifiers::CegisSampleMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cegisSample CVC4_PUBLIC;
extern struct CVC4_PUBLIC ceGuidedInst__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} ceGuidedInst CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiSingleInvAbort__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} cegqiSingleInvAbort CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiSingleInvPartial__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} cegqiSingleInvPartial CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiSingleInvReconstruct__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} cegqiSingleInvReconstruct CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiSingleInvReconstructConst__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} cegqiSingleInvReconstructConst CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiSolMinCore__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} cegqiSolMinCore CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiSolMinInst__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} cegqiSolMinInst CVC4_PUBLIC;
extern struct CVC4_PUBLIC cegqiSingleInvMode__option_t
{
  typedef CVC4::theory::quantifiers::CegqiSingleInvMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} cegqiSingleInvMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC condRewriteQuant__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} condRewriteQuant CVC4_PUBLIC;
extern struct CVC4_PUBLIC condVarSplitQuantAgg__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} condVarSplitQuantAgg CVC4_PUBLIC;
extern struct CVC4_PUBLIC condVarSplitQuant__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} condVarSplitQuant CVC4_PUBLIC;
extern struct CVC4_PUBLIC conjectureFilterActiveTerms__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} conjectureFilterActiveTerms CVC4_PUBLIC;
extern struct CVC4_PUBLIC conjectureFilterCanonical__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} conjectureFilterCanonical CVC4_PUBLIC;
extern struct CVC4_PUBLIC conjectureFilterModel__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} conjectureFilterModel CVC4_PUBLIC;
extern struct CVC4_PUBLIC conjectureGen__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} conjectureGen CVC4_PUBLIC;
extern struct CVC4_PUBLIC conjectureGenGtEnum__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
} conjectureGenGtEnum CVC4_PUBLIC;
extern struct CVC4_PUBLIC conjectureGenMaxDepth__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
} conjectureGenMaxDepth CVC4_PUBLIC;
extern struct CVC4_PUBLIC conjectureGenPerRound__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
} conjectureGenPerRound CVC4_PUBLIC;
extern struct CVC4_PUBLIC conjectureUeeIntro__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} conjectureUeeIntro CVC4_PUBLIC;
extern struct CVC4_PUBLIC conjectureNoFilter__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} conjectureNoFilter CVC4_PUBLIC;
extern struct CVC4_PUBLIC dtStcInduction__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} dtStcInduction CVC4_PUBLIC;
extern struct CVC4_PUBLIC dtVarExpandQuant__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} dtVarExpandQuant CVC4_PUBLIC;
extern struct CVC4_PUBLIC eMatching__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} eMatching CVC4_PUBLIC;
extern struct CVC4_PUBLIC elimExtArithQuant__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} elimExtArithQuant CVC4_PUBLIC;
extern struct CVC4_PUBLIC elimTautQuant__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} elimTautQuant CVC4_PUBLIC;
extern struct CVC4_PUBLIC finiteModelFind__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} finiteModelFind CVC4_PUBLIC;
extern struct CVC4_PUBLIC fmfBound__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} fmfBound CVC4_PUBLIC;
extern struct CVC4_PUBLIC fmfBoundInt__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} fmfBoundInt CVC4_PUBLIC;
extern struct CVC4_PUBLIC fmfBoundLazy__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} fmfBoundLazy CVC4_PUBLIC;
extern struct CVC4_PUBLIC fmfBoundMinMode__option_t
{
  typedef CVC4::theory::quantifiers::FmfBoundMinMode type;
  type operator()() const;
  bool wasSetByUser() const;
} fmfBoundMinMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC fmfEmptySorts__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} fmfEmptySorts CVC4_PUBLIC;
extern struct CVC4_PUBLIC fmfFmcSimple__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} fmfFmcSimple CVC4_PUBLIC;
extern struct CVC4_PUBLIC fmfFreshDistConst__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} fmfFreshDistConst CVC4_PUBLIC;
extern struct CVC4_PUBLIC fmfFunWellDefined__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} fmfFunWellDefined CVC4_PUBLIC;
extern struct CVC4_PUBLIC fmfFunWellDefinedRelevant__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} fmfFunWellDefinedRelevant CVC4_PUBLIC;
extern struct CVC4_PUBLIC fmfInstEngine__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} fmfInstEngine CVC4_PUBLIC;
extern struct CVC4_PUBLIC fmfInstGen__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} fmfInstGen CVC4_PUBLIC;
extern struct CVC4_PUBLIC fmfInstGenOneQuantPerRound__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} fmfInstGenOneQuantPerRound CVC4_PUBLIC;
extern struct CVC4_PUBLIC fullSaturateInterleave__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} fullSaturateInterleave CVC4_PUBLIC;
extern struct CVC4_PUBLIC fullSaturateQuant__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} fullSaturateQuant CVC4_PUBLIC;
extern struct CVC4_PUBLIC fullSaturateQuantRd__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} fullSaturateQuantRd CVC4_PUBLIC;
extern struct CVC4_PUBLIC globalNegate__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} globalNegate CVC4_PUBLIC;
extern struct CVC4_PUBLIC hoMatching__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} hoMatching CVC4_PUBLIC;
extern struct CVC4_PUBLIC hoMatchingVarArgPriority__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} hoMatchingVarArgPriority CVC4_PUBLIC;
extern struct CVC4_PUBLIC hoMergeTermDb__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} hoMergeTermDb CVC4_PUBLIC;
extern struct CVC4_PUBLIC incrementTriggers__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} incrementTriggers CVC4_PUBLIC;
extern struct CVC4_PUBLIC inferArithTriggerEq__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} inferArithTriggerEq CVC4_PUBLIC;
extern struct CVC4_PUBLIC inferArithTriggerEqExp__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} inferArithTriggerEqExp CVC4_PUBLIC;
extern struct CVC4_PUBLIC instLevelInputOnly__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} instLevelInputOnly CVC4_PUBLIC;
extern struct CVC4_PUBLIC instMaxLevel__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} instMaxLevel CVC4_PUBLIC;
extern struct CVC4_PUBLIC instNoEntail__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} instNoEntail CVC4_PUBLIC;
extern struct CVC4_PUBLIC instNoModelTrue__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} instNoModelTrue CVC4_PUBLIC;
extern struct CVC4_PUBLIC instPropagate__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} instPropagate CVC4_PUBLIC;
extern struct CVC4_PUBLIC instWhenPhase__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} instWhenPhase CVC4_PUBLIC;
extern struct CVC4_PUBLIC instWhenStrictInterleave__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} instWhenStrictInterleave CVC4_PUBLIC;
extern struct CVC4_PUBLIC instWhenTcFirst__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} instWhenTcFirst CVC4_PUBLIC;
extern struct CVC4_PUBLIC instWhenMode__option_t
{
  typedef CVC4::theory::quantifiers::InstWhenMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} instWhenMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC intWfInduction__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} intWfInduction CVC4_PUBLIC;
extern struct CVC4_PUBLIC iteDtTesterSplitQuant__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} iteDtTesterSplitQuant CVC4_PUBLIC;
extern struct CVC4_PUBLIC iteLiftQuant__option_t
{
  typedef CVC4::theory::quantifiers::IteLiftQuantMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} iteLiftQuant CVC4_PUBLIC;
extern struct CVC4_PUBLIC literalMatchMode__option_t
{
  typedef CVC4::theory::quantifiers::LiteralMatchMode type;
  type operator()() const;
  bool wasSetByUser() const;
} literalMatchMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC localTheoryExt__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} localTheoryExt CVC4_PUBLIC;
extern struct CVC4_PUBLIC ltePartialInst__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} ltePartialInst CVC4_PUBLIC;
extern struct CVC4_PUBLIC lteRestrictInstClosure__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} lteRestrictInstClosure CVC4_PUBLIC;
extern struct CVC4_PUBLIC macrosQuant__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} macrosQuant CVC4_PUBLIC;
extern struct CVC4_PUBLIC macrosQuantMode__option_t
{
  typedef CVC4::theory::quantifiers::MacrosQuantMode type;
  type operator()() const;
  bool wasSetByUser() const;
} macrosQuantMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC mbqiInterleave__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} mbqiInterleave CVC4_PUBLIC;
extern struct CVC4_PUBLIC fmfOneInstPerRound__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} fmfOneInstPerRound CVC4_PUBLIC;
extern struct CVC4_PUBLIC fmfOneQuantPerRound__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} fmfOneQuantPerRound CVC4_PUBLIC;
extern struct CVC4_PUBLIC mbqiMode__option_t
{
  typedef CVC4::theory::quantifiers::MbqiMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} mbqiMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC miniscopeQuant__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} miniscopeQuant CVC4_PUBLIC;
extern struct CVC4_PUBLIC miniscopeQuantFreeVar__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} miniscopeQuantFreeVar CVC4_PUBLIC;
extern struct CVC4_PUBLIC multiTriggerCache__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} multiTriggerCache CVC4_PUBLIC;
extern struct CVC4_PUBLIC multiTriggerLinear__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} multiTriggerLinear CVC4_PUBLIC;
extern struct CVC4_PUBLIC multiTriggerPriority__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} multiTriggerPriority CVC4_PUBLIC;
extern struct CVC4_PUBLIC multiTriggerWhenSingle__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} multiTriggerWhenSingle CVC4_PUBLIC;
extern struct CVC4_PUBLIC partialTriggers__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} partialTriggers CVC4_PUBLIC;
extern struct CVC4_PUBLIC preSkolemQuant__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} preSkolemQuant CVC4_PUBLIC;
extern struct CVC4_PUBLIC preSkolemQuantAgg__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} preSkolemQuantAgg CVC4_PUBLIC;
extern struct CVC4_PUBLIC preSkolemQuantNested__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} preSkolemQuantNested CVC4_PUBLIC;
extern struct CVC4_PUBLIC prenexQuantUser__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} prenexQuantUser CVC4_PUBLIC;
extern struct CVC4_PUBLIC prenexQuant__option_t
{
  typedef CVC4::theory::quantifiers::PrenexQuantMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} prenexQuant CVC4_PUBLIC;
extern struct CVC4_PUBLIC pureThTriggers__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} pureThTriggers CVC4_PUBLIC;
extern struct CVC4_PUBLIC purifyDtTriggers__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} purifyDtTriggers CVC4_PUBLIC;
extern struct CVC4_PUBLIC purifyTriggers__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} purifyTriggers CVC4_PUBLIC;
extern struct CVC4_PUBLIC qcfAllConflict__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} qcfAllConflict CVC4_PUBLIC;
extern struct CVC4_PUBLIC qcfEagerCheckRd__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} qcfEagerCheckRd CVC4_PUBLIC;
extern struct CVC4_PUBLIC qcfEagerTest__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} qcfEagerTest CVC4_PUBLIC;
extern struct CVC4_PUBLIC qcfNestedConflict__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} qcfNestedConflict CVC4_PUBLIC;
extern struct CVC4_PUBLIC qcfSkipRd__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} qcfSkipRd CVC4_PUBLIC;
extern struct CVC4_PUBLIC qcfTConstraint__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} qcfTConstraint CVC4_PUBLIC;
extern struct CVC4_PUBLIC qcfVoExp__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} qcfVoExp CVC4_PUBLIC;
extern struct CVC4_PUBLIC quantAlphaEquiv__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} quantAlphaEquiv CVC4_PUBLIC;
extern struct CVC4_PUBLIC quantAntiSkolem__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} quantAntiSkolem CVC4_PUBLIC;
extern struct CVC4_PUBLIC quantConflictFind__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} quantConflictFind CVC4_PUBLIC;
extern struct CVC4_PUBLIC qcfMode__option_t
{
  typedef CVC4::theory::quantifiers::QcfMode type;
  type operator()() const;
  bool wasSetByUser() const;
} qcfMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC qcfWhenMode__option_t
{
  typedef CVC4::theory::quantifiers::QcfWhenMode type;
  type operator()() const;
  bool wasSetByUser() const;
} qcfWhenMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC quantDynamicSplit__option_t
{
  typedef CVC4::theory::quantifiers::QuantDSplitMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} quantDynamicSplit CVC4_PUBLIC;
extern struct CVC4_PUBLIC quantEpr__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} quantEpr CVC4_PUBLIC;
extern struct CVC4_PUBLIC quantEprMatching__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} quantEprMatching CVC4_PUBLIC;
extern struct CVC4_PUBLIC quantFunWellDefined__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} quantFunWellDefined CVC4_PUBLIC;
extern struct CVC4_PUBLIC quantInduction__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} quantInduction CVC4_PUBLIC;
extern struct CVC4_PUBLIC quantModelEe__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} quantModelEe CVC4_PUBLIC;
extern struct CVC4_PUBLIC quantRepMode__option_t
{
  typedef CVC4::theory::quantifiers::QuantRepMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} quantRepMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC quantSplit__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} quantSplit CVC4_PUBLIC;
extern struct CVC4_PUBLIC registerQuantBodyTerms__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} registerQuantBodyTerms CVC4_PUBLIC;
extern struct CVC4_PUBLIC relationalTriggers__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} relationalTriggers CVC4_PUBLIC;
extern struct CVC4_PUBLIC relevantTriggers__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} relevantTriggers CVC4_PUBLIC;
extern struct CVC4_PUBLIC quantRewriteRules__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} quantRewriteRules CVC4_PUBLIC;
extern struct CVC4_PUBLIC rrOneInstPerRound__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} rrOneInstPerRound CVC4_PUBLIC;
extern struct CVC4_PUBLIC strictTriggers__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} strictTriggers CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusAddConstGrammar__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusAddConstGrammar CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusInvAutoUnfold__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusInvAutoUnfold CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusBoolIteReturnConst__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusBoolIteReturnConst CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusEvalUnfold__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusEvalUnfold CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusEvalUnfoldBool__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusEvalUnfoldBool CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusExtRew__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusExtRew CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusGrammarNorm__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusGrammarNorm CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusInference__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusInference CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusInvTemplWhenSyntax__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusInvTemplWhenSyntax CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusInvTemplMode__option_t
{
  typedef CVC4::theory::quantifiers::SygusInvTemplMode type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusInvTemplMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusMinGrammar__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusMinGrammar CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusUnifPbe__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusUnifPbe CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusQePreproc__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusQePreproc CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusRefEval__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusRefEval CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusRepairConst__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusRepairConst CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusRew__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusRew CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusRewSynth__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusRewSynth CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusRewSynthAccel__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusRewSynthAccel CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusRewSynthCheck__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusRewSynthCheck CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusRewSynthFilterCong__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusRewSynthFilterCong CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusRewSynthFilterMatch__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusRewSynthFilterMatch CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusRewSynthFilterOrder__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusRewSynthFilterOrder CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusRewVerify__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusRewVerify CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusRewVerifyAbort__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusRewVerifyAbort CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusSampleGrammar__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusSampleGrammar CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusSamples__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusSamples CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusStream__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusStream CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusTemplEmbedGrammar__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusTemplEmbedGrammar CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusUnif__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusUnif CVC4_PUBLIC;
extern struct CVC4_PUBLIC termDbMode__option_t
{
  typedef CVC4::theory::quantifiers::TermDbMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} termDbMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC trackInstLemmas__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} trackInstLemmas CVC4_PUBLIC;
extern struct CVC4_PUBLIC triggerActiveSelMode__option_t
{
  typedef CVC4::theory::quantifiers::TriggerActiveSelMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} triggerActiveSelMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC triggerSelMode__option_t
{
  typedef CVC4::theory::quantifiers::TriggerSelMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} triggerSelMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC userPatternsQuant__option_t
{
  typedef CVC4::theory::quantifiers::UserPatMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} userPatternsQuant CVC4_PUBLIC;
extern struct CVC4_PUBLIC varElimQuant__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} varElimQuant CVC4_PUBLIC;
extern struct CVC4_PUBLIC varIneqElimQuant__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} varIneqElimQuant CVC4_PUBLIC;


}  // namespace options

template <> const options::aggressiveMiniscopeQuant__option_t::type& Options::operator[](
    options::aggressiveMiniscopeQuant__option_t) const;
template <> bool Options::wasSetByUser(options::aggressiveMiniscopeQuant__option_t) const;
template <> void Options::assignBool(
    options::aggressiveMiniscopeQuant__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cbqi__option_t,
    const options::cbqi__option_t::type& x);
template <> const options::cbqi__option_t::type& Options::operator[](
    options::cbqi__option_t) const;
template <> bool Options::wasSetByUser(options::cbqi__option_t) const;
template <> void Options::assignBool(
    options::cbqi__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cbqiAll__option_t,
    const options::cbqiAll__option_t::type& x);
template <> const options::cbqiAll__option_t::type& Options::operator[](
    options::cbqiAll__option_t) const;
template <> bool Options::wasSetByUser(options::cbqiAll__option_t) const;
template <> void Options::assignBool(
    options::cbqiAll__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cbqiBv__option_t,
    const options::cbqiBv__option_t::type& x);
template <> const options::cbqiBv__option_t::type& Options::operator[](
    options::cbqiBv__option_t) const;
template <> bool Options::wasSetByUser(options::cbqiBv__option_t) const;
template <> void Options::assignBool(
    options::cbqiBv__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cbqiBvConcInv__option_t,
    const options::cbqiBvConcInv__option_t::type& x);
template <> const options::cbqiBvConcInv__option_t::type& Options::operator[](
    options::cbqiBvConcInv__option_t) const;
template <> bool Options::wasSetByUser(options::cbqiBvConcInv__option_t) const;
template <> void Options::assignBool(
    options::cbqiBvConcInv__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cbqiBvIneqMode__option_t,
    const options::cbqiBvIneqMode__option_t::type& x);
template <> const options::cbqiBvIneqMode__option_t::type& Options::operator[](
    options::cbqiBvIneqMode__option_t) const;
template <> bool Options::wasSetByUser(options::cbqiBvIneqMode__option_t) const;
template <> void Options::assign(
    options::cbqiBvIneqMode__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::cbqiBvInterleaveValue__option_t,
    const options::cbqiBvInterleaveValue__option_t::type& x);
template <> const options::cbqiBvInterleaveValue__option_t::type& Options::operator[](
    options::cbqiBvInterleaveValue__option_t) const;
template <> bool Options::wasSetByUser(options::cbqiBvInterleaveValue__option_t) const;
template <> void Options::assignBool(
    options::cbqiBvInterleaveValue__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cbqiBvLinearize__option_t,
    const options::cbqiBvLinearize__option_t::type& x);
template <> const options::cbqiBvLinearize__option_t::type& Options::operator[](
    options::cbqiBvLinearize__option_t) const;
template <> bool Options::wasSetByUser(options::cbqiBvLinearize__option_t) const;
template <> void Options::assignBool(
    options::cbqiBvLinearize__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cbqiBvRmExtract__option_t,
    const options::cbqiBvRmExtract__option_t::type& x);
template <> const options::cbqiBvRmExtract__option_t::type& Options::operator[](
    options::cbqiBvRmExtract__option_t) const;
template <> bool Options::wasSetByUser(options::cbqiBvRmExtract__option_t) const;
template <> void Options::assignBool(
    options::cbqiBvRmExtract__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cbqiBvSolveNl__option_t,
    const options::cbqiBvSolveNl__option_t::type& x);
template <> const options::cbqiBvSolveNl__option_t::type& Options::operator[](
    options::cbqiBvSolveNl__option_t) const;
template <> bool Options::wasSetByUser(options::cbqiBvSolveNl__option_t) const;
template <> void Options::assignBool(
    options::cbqiBvSolveNl__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cbqiFullEffort__option_t,
    const options::cbqiFullEffort__option_t::type& x);
template <> const options::cbqiFullEffort__option_t::type& Options::operator[](
    options::cbqiFullEffort__option_t) const;
template <> bool Options::wasSetByUser(options::cbqiFullEffort__option_t) const;
template <> void Options::assignBool(
    options::cbqiFullEffort__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cbqiInnermost__option_t,
    const options::cbqiInnermost__option_t::type& x);
template <> const options::cbqiInnermost__option_t::type& Options::operator[](
    options::cbqiInnermost__option_t) const;
template <> bool Options::wasSetByUser(options::cbqiInnermost__option_t) const;
template <> void Options::assignBool(
    options::cbqiInnermost__option_t,
    std::string option,
    bool value);
template <> const options::cbqiLitDepend__option_t::type& Options::operator[](
    options::cbqiLitDepend__option_t) const;
template <> bool Options::wasSetByUser(options::cbqiLitDepend__option_t) const;
template <> void Options::assignBool(
    options::cbqiLitDepend__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cbqiMidpoint__option_t,
    const options::cbqiMidpoint__option_t::type& x);
template <> const options::cbqiMidpoint__option_t::type& Options::operator[](
    options::cbqiMidpoint__option_t) const;
template <> bool Options::wasSetByUser(options::cbqiMidpoint__option_t) const;
template <> void Options::assignBool(
    options::cbqiMidpoint__option_t,
    std::string option,
    bool value);
template <> const options::cbqiMinBounds__option_t::type& Options::operator[](
    options::cbqiMinBounds__option_t) const;
template <> bool Options::wasSetByUser(options::cbqiMinBounds__option_t) const;
template <> void Options::assignBool(
    options::cbqiMinBounds__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cbqiModel__option_t,
    const options::cbqiModel__option_t::type& x);
template <> const options::cbqiModel__option_t::type& Options::operator[](
    options::cbqiModel__option_t) const;
template <> bool Options::wasSetByUser(options::cbqiModel__option_t) const;
template <> void Options::assignBool(
    options::cbqiModel__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cbqiMultiInst__option_t,
    const options::cbqiMultiInst__option_t::type& x);
template <> const options::cbqiMultiInst__option_t::type& Options::operator[](
    options::cbqiMultiInst__option_t) const;
template <> bool Options::wasSetByUser(options::cbqiMultiInst__option_t) const;
template <> void Options::assignBool(
    options::cbqiMultiInst__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cbqiNestedQE__option_t,
    const options::cbqiNestedQE__option_t::type& x);
template <> const options::cbqiNestedQE__option_t::type& Options::operator[](
    options::cbqiNestedQE__option_t) const;
template <> bool Options::wasSetByUser(options::cbqiNestedQE__option_t) const;
template <> void Options::assignBool(
    options::cbqiNestedQE__option_t,
    std::string option,
    bool value);
template <> const options::cbqiNopt__option_t::type& Options::operator[](
    options::cbqiNopt__option_t) const;
template <> bool Options::wasSetByUser(options::cbqiNopt__option_t) const;
template <> void Options::assignBool(
    options::cbqiNopt__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cbqiPreRegInst__option_t,
    const options::cbqiPreRegInst__option_t::type& x);
template <> const options::cbqiPreRegInst__option_t::type& Options::operator[](
    options::cbqiPreRegInst__option_t) const;
template <> bool Options::wasSetByUser(options::cbqiPreRegInst__option_t) const;
template <> void Options::assignBool(
    options::cbqiPreRegInst__option_t,
    std::string option,
    bool value);
template <> const options::recurseCbqi__option_t::type& Options::operator[](
    options::recurseCbqi__option_t) const;
template <> bool Options::wasSetByUser(options::recurseCbqi__option_t) const;
template <> void Options::assignBool(
    options::recurseCbqi__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cbqiRepeatLit__option_t,
    const options::cbqiRepeatLit__option_t::type& x);
template <> const options::cbqiRepeatLit__option_t::type& Options::operator[](
    options::cbqiRepeatLit__option_t) const;
template <> bool Options::wasSetByUser(options::cbqiRepeatLit__option_t) const;
template <> void Options::assignBool(
    options::cbqiRepeatLit__option_t,
    std::string option,
    bool value);
template <> const options::cbqiRoundUpLowerLia__option_t::type& Options::operator[](
    options::cbqiRoundUpLowerLia__option_t) const;
template <> bool Options::wasSetByUser(options::cbqiRoundUpLowerLia__option_t) const;
template <> void Options::assignBool(
    options::cbqiRoundUpLowerLia__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cbqiSat__option_t,
    const options::cbqiSat__option_t::type& x);
template <> const options::cbqiSat__option_t::type& Options::operator[](
    options::cbqiSat__option_t) const;
template <> bool Options::wasSetByUser(options::cbqiSat__option_t) const;
template <> void Options::assignBool(
    options::cbqiSat__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cbqiUseInfInt__option_t,
    const options::cbqiUseInfInt__option_t::type& x);
template <> const options::cbqiUseInfInt__option_t::type& Options::operator[](
    options::cbqiUseInfInt__option_t) const;
template <> bool Options::wasSetByUser(options::cbqiUseInfInt__option_t) const;
template <> void Options::assignBool(
    options::cbqiUseInfInt__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cbqiUseInfReal__option_t,
    const options::cbqiUseInfReal__option_t::type& x);
template <> const options::cbqiUseInfReal__option_t::type& Options::operator[](
    options::cbqiUseInfReal__option_t) const;
template <> bool Options::wasSetByUser(options::cbqiUseInfReal__option_t) const;
template <> void Options::assignBool(
    options::cbqiUseInfReal__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cegisSample__option_t,
    const options::cegisSample__option_t::type& x);
template <> const options::cegisSample__option_t::type& Options::operator[](
    options::cegisSample__option_t) const;
template <> bool Options::wasSetByUser(options::cegisSample__option_t) const;
template <> void Options::assign(
    options::cegisSample__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::ceGuidedInst__option_t,
    const options::ceGuidedInst__option_t::type& x);
template <> const options::ceGuidedInst__option_t::type& Options::operator[](
    options::ceGuidedInst__option_t) const;
template <> bool Options::wasSetByUser(options::ceGuidedInst__option_t) const;
template <> void Options::assignBool(
    options::ceGuidedInst__option_t,
    std::string option,
    bool value);
template <> const options::cegqiSingleInvAbort__option_t::type& Options::operator[](
    options::cegqiSingleInvAbort__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiSingleInvAbort__option_t) const;
template <> void Options::assignBool(
    options::cegqiSingleInvAbort__option_t,
    std::string option,
    bool value);
template <> const options::cegqiSingleInvPartial__option_t::type& Options::operator[](
    options::cegqiSingleInvPartial__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiSingleInvPartial__option_t) const;
template <> void Options::assignBool(
    options::cegqiSingleInvPartial__option_t,
    std::string option,
    bool value);
template <> const options::cegqiSingleInvReconstruct__option_t::type& Options::operator[](
    options::cegqiSingleInvReconstruct__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiSingleInvReconstruct__option_t) const;
template <> void Options::assignBool(
    options::cegqiSingleInvReconstruct__option_t,
    std::string option,
    bool value);
template <> const options::cegqiSingleInvReconstructConst__option_t::type& Options::operator[](
    options::cegqiSingleInvReconstructConst__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiSingleInvReconstructConst__option_t) const;
template <> void Options::assignBool(
    options::cegqiSingleInvReconstructConst__option_t,
    std::string option,
    bool value);
template <> const options::cegqiSolMinCore__option_t::type& Options::operator[](
    options::cegqiSolMinCore__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiSolMinCore__option_t) const;
template <> void Options::assignBool(
    options::cegqiSolMinCore__option_t,
    std::string option,
    bool value);
template <> const options::cegqiSolMinInst__option_t::type& Options::operator[](
    options::cegqiSolMinInst__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiSolMinInst__option_t) const;
template <> void Options::assignBool(
    options::cegqiSolMinInst__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::cegqiSingleInvMode__option_t,
    const options::cegqiSingleInvMode__option_t::type& x);
template <> const options::cegqiSingleInvMode__option_t::type& Options::operator[](
    options::cegqiSingleInvMode__option_t) const;
template <> bool Options::wasSetByUser(options::cegqiSingleInvMode__option_t) const;
template <> void Options::assign(
    options::cegqiSingleInvMode__option_t,
    std::string option,
    std::string value);
template <> const options::condRewriteQuant__option_t::type& Options::operator[](
    options::condRewriteQuant__option_t) const;
template <> bool Options::wasSetByUser(options::condRewriteQuant__option_t) const;
template <> void Options::assignBool(
    options::condRewriteQuant__option_t,
    std::string option,
    bool value);
template <> const options::condVarSplitQuantAgg__option_t::type& Options::operator[](
    options::condVarSplitQuantAgg__option_t) const;
template <> bool Options::wasSetByUser(options::condVarSplitQuantAgg__option_t) const;
template <> void Options::assignBool(
    options::condVarSplitQuantAgg__option_t,
    std::string option,
    bool value);
template <> const options::condVarSplitQuant__option_t::type& Options::operator[](
    options::condVarSplitQuant__option_t) const;
template <> bool Options::wasSetByUser(options::condVarSplitQuant__option_t) const;
template <> void Options::assignBool(
    options::condVarSplitQuant__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::conjectureFilterActiveTerms__option_t,
    const options::conjectureFilterActiveTerms__option_t::type& x);
template <> const options::conjectureFilterActiveTerms__option_t::type& Options::operator[](
    options::conjectureFilterActiveTerms__option_t) const;
template <> bool Options::wasSetByUser(options::conjectureFilterActiveTerms__option_t) const;
template <> void Options::assignBool(
    options::conjectureFilterActiveTerms__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::conjectureFilterCanonical__option_t,
    const options::conjectureFilterCanonical__option_t::type& x);
template <> const options::conjectureFilterCanonical__option_t::type& Options::operator[](
    options::conjectureFilterCanonical__option_t) const;
template <> bool Options::wasSetByUser(options::conjectureFilterCanonical__option_t) const;
template <> void Options::assignBool(
    options::conjectureFilterCanonical__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::conjectureFilterModel__option_t,
    const options::conjectureFilterModel__option_t::type& x);
template <> const options::conjectureFilterModel__option_t::type& Options::operator[](
    options::conjectureFilterModel__option_t) const;
template <> bool Options::wasSetByUser(options::conjectureFilterModel__option_t) const;
template <> void Options::assignBool(
    options::conjectureFilterModel__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::conjectureGen__option_t,
    const options::conjectureGen__option_t::type& x);
template <> const options::conjectureGen__option_t::type& Options::operator[](
    options::conjectureGen__option_t) const;
template <> bool Options::wasSetByUser(options::conjectureGen__option_t) const;
template <> void Options::assignBool(
    options::conjectureGen__option_t,
    std::string option,
    bool value);
template <> const options::conjectureGenGtEnum__option_t::type& Options::operator[](
    options::conjectureGenGtEnum__option_t) const;
template <> bool Options::wasSetByUser(options::conjectureGenGtEnum__option_t) const;
template <> void Options::assign(
    options::conjectureGenGtEnum__option_t,
    std::string option,
    std::string value);
template <> const options::conjectureGenMaxDepth__option_t::type& Options::operator[](
    options::conjectureGenMaxDepth__option_t) const;
template <> bool Options::wasSetByUser(options::conjectureGenMaxDepth__option_t) const;
template <> void Options::assign(
    options::conjectureGenMaxDepth__option_t,
    std::string option,
    std::string value);
template <> const options::conjectureGenPerRound__option_t::type& Options::operator[](
    options::conjectureGenPerRound__option_t) const;
template <> bool Options::wasSetByUser(options::conjectureGenPerRound__option_t) const;
template <> void Options::assign(
    options::conjectureGenPerRound__option_t,
    std::string option,
    std::string value);
template <> const options::conjectureUeeIntro__option_t::type& Options::operator[](
    options::conjectureUeeIntro__option_t) const;
template <> bool Options::wasSetByUser(options::conjectureUeeIntro__option_t) const;
template <> void Options::assignBool(
    options::conjectureUeeIntro__option_t,
    std::string option,
    bool value);
template <> const options::conjectureNoFilter__option_t::type& Options::operator[](
    options::conjectureNoFilter__option_t) const;
template <> bool Options::wasSetByUser(options::conjectureNoFilter__option_t) const;
template <> void Options::assignBool(
    options::conjectureNoFilter__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::dtStcInduction__option_t,
    const options::dtStcInduction__option_t::type& x);
template <> const options::dtStcInduction__option_t::type& Options::operator[](
    options::dtStcInduction__option_t) const;
template <> bool Options::wasSetByUser(options::dtStcInduction__option_t) const;
template <> void Options::assignBool(
    options::dtStcInduction__option_t,
    std::string option,
    bool value);
template <> const options::dtVarExpandQuant__option_t::type& Options::operator[](
    options::dtVarExpandQuant__option_t) const;
template <> bool Options::wasSetByUser(options::dtVarExpandQuant__option_t) const;
template <> void Options::assignBool(
    options::dtVarExpandQuant__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::eMatching__option_t,
    const options::eMatching__option_t::type& x);
template <> const options::eMatching__option_t::type& Options::operator[](
    options::eMatching__option_t) const;
template <> bool Options::wasSetByUser(options::eMatching__option_t) const;
template <> void Options::assignBool(
    options::eMatching__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::elimExtArithQuant__option_t,
    const options::elimExtArithQuant__option_t::type& x);
template <> const options::elimExtArithQuant__option_t::type& Options::operator[](
    options::elimExtArithQuant__option_t) const;
template <> bool Options::wasSetByUser(options::elimExtArithQuant__option_t) const;
template <> void Options::assignBool(
    options::elimExtArithQuant__option_t,
    std::string option,
    bool value);
template <> const options::elimTautQuant__option_t::type& Options::operator[](
    options::elimTautQuant__option_t) const;
template <> bool Options::wasSetByUser(options::elimTautQuant__option_t) const;
template <> void Options::assignBool(
    options::elimTautQuant__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::finiteModelFind__option_t,
    const options::finiteModelFind__option_t::type& x);
template <> const options::finiteModelFind__option_t::type& Options::operator[](
    options::finiteModelFind__option_t) const;
template <> bool Options::wasSetByUser(options::finiteModelFind__option_t) const;
template <> void Options::assignBool(
    options::finiteModelFind__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::fmfBound__option_t,
    const options::fmfBound__option_t::type& x);
template <> const options::fmfBound__option_t::type& Options::operator[](
    options::fmfBound__option_t) const;
template <> bool Options::wasSetByUser(options::fmfBound__option_t) const;
template <> void Options::assignBool(
    options::fmfBound__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::fmfBoundInt__option_t,
    const options::fmfBoundInt__option_t::type& x);
template <> const options::fmfBoundInt__option_t::type& Options::operator[](
    options::fmfBoundInt__option_t) const;
template <> bool Options::wasSetByUser(options::fmfBoundInt__option_t) const;
template <> void Options::assignBool(
    options::fmfBoundInt__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::fmfBoundLazy__option_t,
    const options::fmfBoundLazy__option_t::type& x);
template <> const options::fmfBoundLazy__option_t::type& Options::operator[](
    options::fmfBoundLazy__option_t) const;
template <> bool Options::wasSetByUser(options::fmfBoundLazy__option_t) const;
template <> void Options::assignBool(
    options::fmfBoundLazy__option_t,
    std::string option,
    bool value);
template <> const options::fmfBoundMinMode__option_t::type& Options::operator[](
    options::fmfBoundMinMode__option_t) const;
template <> bool Options::wasSetByUser(options::fmfBoundMinMode__option_t) const;
template <> void Options::assign(
    options::fmfBoundMinMode__option_t,
    std::string option,
    std::string value);
template <> const options::fmfEmptySorts__option_t::type& Options::operator[](
    options::fmfEmptySorts__option_t) const;
template <> bool Options::wasSetByUser(options::fmfEmptySorts__option_t) const;
template <> void Options::assignBool(
    options::fmfEmptySorts__option_t,
    std::string option,
    bool value);
template <> const options::fmfFmcSimple__option_t::type& Options::operator[](
    options::fmfFmcSimple__option_t) const;
template <> bool Options::wasSetByUser(options::fmfFmcSimple__option_t) const;
template <> void Options::assignBool(
    options::fmfFmcSimple__option_t,
    std::string option,
    bool value);
template <> const options::fmfFreshDistConst__option_t::type& Options::operator[](
    options::fmfFreshDistConst__option_t) const;
template <> bool Options::wasSetByUser(options::fmfFreshDistConst__option_t) const;
template <> void Options::assignBool(
    options::fmfFreshDistConst__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::fmfFunWellDefined__option_t,
    const options::fmfFunWellDefined__option_t::type& x);
template <> const options::fmfFunWellDefined__option_t::type& Options::operator[](
    options::fmfFunWellDefined__option_t) const;
template <> bool Options::wasSetByUser(options::fmfFunWellDefined__option_t) const;
template <> void Options::assignBool(
    options::fmfFunWellDefined__option_t,
    std::string option,
    bool value);
template <> const options::fmfFunWellDefinedRelevant__option_t::type& Options::operator[](
    options::fmfFunWellDefinedRelevant__option_t) const;
template <> bool Options::wasSetByUser(options::fmfFunWellDefinedRelevant__option_t) const;
template <> void Options::assignBool(
    options::fmfFunWellDefinedRelevant__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::fmfInstEngine__option_t,
    const options::fmfInstEngine__option_t::type& x);
template <> const options::fmfInstEngine__option_t::type& Options::operator[](
    options::fmfInstEngine__option_t) const;
template <> bool Options::wasSetByUser(options::fmfInstEngine__option_t) const;
template <> void Options::assignBool(
    options::fmfInstEngine__option_t,
    std::string option,
    bool value);
template <> const options::fmfInstGen__option_t::type& Options::operator[](
    options::fmfInstGen__option_t) const;
template <> bool Options::wasSetByUser(options::fmfInstGen__option_t) const;
template <> void Options::assignBool(
    options::fmfInstGen__option_t,
    std::string option,
    bool value);
template <> const options::fmfInstGenOneQuantPerRound__option_t::type& Options::operator[](
    options::fmfInstGenOneQuantPerRound__option_t) const;
template <> bool Options::wasSetByUser(options::fmfInstGenOneQuantPerRound__option_t) const;
template <> void Options::assignBool(
    options::fmfInstGenOneQuantPerRound__option_t,
    std::string option,
    bool value);
template <> const options::fullSaturateInterleave__option_t::type& Options::operator[](
    options::fullSaturateInterleave__option_t) const;
template <> bool Options::wasSetByUser(options::fullSaturateInterleave__option_t) const;
template <> void Options::assignBool(
    options::fullSaturateInterleave__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::fullSaturateQuant__option_t,
    const options::fullSaturateQuant__option_t::type& x);
template <> const options::fullSaturateQuant__option_t::type& Options::operator[](
    options::fullSaturateQuant__option_t) const;
template <> bool Options::wasSetByUser(options::fullSaturateQuant__option_t) const;
template <> void Options::assignBool(
    options::fullSaturateQuant__option_t,
    std::string option,
    bool value);
template <> const options::fullSaturateQuantRd__option_t::type& Options::operator[](
    options::fullSaturateQuantRd__option_t) const;
template <> bool Options::wasSetByUser(options::fullSaturateQuantRd__option_t) const;
template <> void Options::assignBool(
    options::fullSaturateQuantRd__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::globalNegate__option_t,
    const options::globalNegate__option_t::type& x);
template <> const options::globalNegate__option_t::type& Options::operator[](
    options::globalNegate__option_t) const;
template <> bool Options::wasSetByUser(options::globalNegate__option_t) const;
template <> void Options::assignBool(
    options::globalNegate__option_t,
    std::string option,
    bool value);
template <> const options::hoMatching__option_t::type& Options::operator[](
    options::hoMatching__option_t) const;
template <> bool Options::wasSetByUser(options::hoMatching__option_t) const;
template <> void Options::assignBool(
    options::hoMatching__option_t,
    std::string option,
    bool value);
template <> const options::hoMatchingVarArgPriority__option_t::type& Options::operator[](
    options::hoMatchingVarArgPriority__option_t) const;
template <> bool Options::wasSetByUser(options::hoMatchingVarArgPriority__option_t) const;
template <> void Options::assignBool(
    options::hoMatchingVarArgPriority__option_t,
    std::string option,
    bool value);
template <> const options::hoMergeTermDb__option_t::type& Options::operator[](
    options::hoMergeTermDb__option_t) const;
template <> bool Options::wasSetByUser(options::hoMergeTermDb__option_t) const;
template <> void Options::assignBool(
    options::hoMergeTermDb__option_t,
    std::string option,
    bool value);
template <> const options::incrementTriggers__option_t::type& Options::operator[](
    options::incrementTriggers__option_t) const;
template <> bool Options::wasSetByUser(options::incrementTriggers__option_t) const;
template <> void Options::assignBool(
    options::incrementTriggers__option_t,
    std::string option,
    bool value);
template <> const options::inferArithTriggerEq__option_t::type& Options::operator[](
    options::inferArithTriggerEq__option_t) const;
template <> bool Options::wasSetByUser(options::inferArithTriggerEq__option_t) const;
template <> void Options::assignBool(
    options::inferArithTriggerEq__option_t,
    std::string option,
    bool value);
template <> const options::inferArithTriggerEqExp__option_t::type& Options::operator[](
    options::inferArithTriggerEqExp__option_t) const;
template <> bool Options::wasSetByUser(options::inferArithTriggerEqExp__option_t) const;
template <> void Options::assignBool(
    options::inferArithTriggerEqExp__option_t,
    std::string option,
    bool value);
template <> const options::instLevelInputOnly__option_t::type& Options::operator[](
    options::instLevelInputOnly__option_t) const;
template <> bool Options::wasSetByUser(options::instLevelInputOnly__option_t) const;
template <> void Options::assignBool(
    options::instLevelInputOnly__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::instMaxLevel__option_t,
    const options::instMaxLevel__option_t::type& x);
template <> const options::instMaxLevel__option_t::type& Options::operator[](
    options::instMaxLevel__option_t) const;
template <> bool Options::wasSetByUser(options::instMaxLevel__option_t) const;
template <> void Options::assign(
    options::instMaxLevel__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::instNoEntail__option_t,
    const options::instNoEntail__option_t::type& x);
template <> const options::instNoEntail__option_t::type& Options::operator[](
    options::instNoEntail__option_t) const;
template <> bool Options::wasSetByUser(options::instNoEntail__option_t) const;
template <> void Options::assignBool(
    options::instNoEntail__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::instNoModelTrue__option_t,
    const options::instNoModelTrue__option_t::type& x);
template <> const options::instNoModelTrue__option_t::type& Options::operator[](
    options::instNoModelTrue__option_t) const;
template <> bool Options::wasSetByUser(options::instNoModelTrue__option_t) const;
template <> void Options::assignBool(
    options::instNoModelTrue__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::instPropagate__option_t,
    const options::instPropagate__option_t::type& x);
template <> const options::instPropagate__option_t::type& Options::operator[](
    options::instPropagate__option_t) const;
template <> bool Options::wasSetByUser(options::instPropagate__option_t) const;
template <> void Options::assignBool(
    options::instPropagate__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::instWhenPhase__option_t,
    const options::instWhenPhase__option_t::type& x);
template <> const options::instWhenPhase__option_t::type& Options::operator[](
    options::instWhenPhase__option_t) const;
template <> bool Options::wasSetByUser(options::instWhenPhase__option_t) const;
template <> void Options::assign(
    options::instWhenPhase__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::instWhenStrictInterleave__option_t,
    const options::instWhenStrictInterleave__option_t::type& x);
template <> const options::instWhenStrictInterleave__option_t::type& Options::operator[](
    options::instWhenStrictInterleave__option_t) const;
template <> bool Options::wasSetByUser(options::instWhenStrictInterleave__option_t) const;
template <> void Options::assignBool(
    options::instWhenStrictInterleave__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::instWhenTcFirst__option_t,
    const options::instWhenTcFirst__option_t::type& x);
template <> const options::instWhenTcFirst__option_t::type& Options::operator[](
    options::instWhenTcFirst__option_t) const;
template <> bool Options::wasSetByUser(options::instWhenTcFirst__option_t) const;
template <> void Options::assignBool(
    options::instWhenTcFirst__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::instWhenMode__option_t,
    const options::instWhenMode__option_t::type& x);
template <> const options::instWhenMode__option_t::type& Options::operator[](
    options::instWhenMode__option_t) const;
template <> bool Options::wasSetByUser(options::instWhenMode__option_t) const;
template <> void Options::assign(
    options::instWhenMode__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::intWfInduction__option_t,
    const options::intWfInduction__option_t::type& x);
template <> const options::intWfInduction__option_t::type& Options::operator[](
    options::intWfInduction__option_t) const;
template <> bool Options::wasSetByUser(options::intWfInduction__option_t) const;
template <> void Options::assignBool(
    options::intWfInduction__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::iteDtTesterSplitQuant__option_t,
    const options::iteDtTesterSplitQuant__option_t::type& x);
template <> const options::iteDtTesterSplitQuant__option_t::type& Options::operator[](
    options::iteDtTesterSplitQuant__option_t) const;
template <> bool Options::wasSetByUser(options::iteDtTesterSplitQuant__option_t) const;
template <> void Options::assignBool(
    options::iteDtTesterSplitQuant__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::iteLiftQuant__option_t,
    const options::iteLiftQuant__option_t::type& x);
template <> const options::iteLiftQuant__option_t::type& Options::operator[](
    options::iteLiftQuant__option_t) const;
template <> bool Options::wasSetByUser(options::iteLiftQuant__option_t) const;
template <> void Options::assign(
    options::iteLiftQuant__option_t,
    std::string option,
    std::string value);
template <> const options::literalMatchMode__option_t::type& Options::operator[](
    options::literalMatchMode__option_t) const;
template <> bool Options::wasSetByUser(options::literalMatchMode__option_t) const;
template <> void Options::assign(
    options::literalMatchMode__option_t,
    std::string option,
    std::string value);
template <> const options::localTheoryExt__option_t::type& Options::operator[](
    options::localTheoryExt__option_t) const;
template <> bool Options::wasSetByUser(options::localTheoryExt__option_t) const;
template <> void Options::assignBool(
    options::localTheoryExt__option_t,
    std::string option,
    bool value);
template <> const options::ltePartialInst__option_t::type& Options::operator[](
    options::ltePartialInst__option_t) const;
template <> bool Options::wasSetByUser(options::ltePartialInst__option_t) const;
template <> void Options::assignBool(
    options::ltePartialInst__option_t,
    std::string option,
    bool value);
template <> const options::lteRestrictInstClosure__option_t::type& Options::operator[](
    options::lteRestrictInstClosure__option_t) const;
template <> bool Options::wasSetByUser(options::lteRestrictInstClosure__option_t) const;
template <> void Options::assignBool(
    options::lteRestrictInstClosure__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::macrosQuant__option_t,
    const options::macrosQuant__option_t::type& x);
template <> const options::macrosQuant__option_t::type& Options::operator[](
    options::macrosQuant__option_t) const;
template <> bool Options::wasSetByUser(options::macrosQuant__option_t) const;
template <> void Options::assignBool(
    options::macrosQuant__option_t,
    std::string option,
    bool value);
template <> const options::macrosQuantMode__option_t::type& Options::operator[](
    options::macrosQuantMode__option_t) const;
template <> bool Options::wasSetByUser(options::macrosQuantMode__option_t) const;
template <> void Options::assign(
    options::macrosQuantMode__option_t,
    std::string option,
    std::string value);
template <> const options::mbqiInterleave__option_t::type& Options::operator[](
    options::mbqiInterleave__option_t) const;
template <> bool Options::wasSetByUser(options::mbqiInterleave__option_t) const;
template <> void Options::assignBool(
    options::mbqiInterleave__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::fmfOneInstPerRound__option_t,
    const options::fmfOneInstPerRound__option_t::type& x);
template <> const options::fmfOneInstPerRound__option_t::type& Options::operator[](
    options::fmfOneInstPerRound__option_t) const;
template <> bool Options::wasSetByUser(options::fmfOneInstPerRound__option_t) const;
template <> void Options::assignBool(
    options::fmfOneInstPerRound__option_t,
    std::string option,
    bool value);
template <> const options::fmfOneQuantPerRound__option_t::type& Options::operator[](
    options::fmfOneQuantPerRound__option_t) const;
template <> bool Options::wasSetByUser(options::fmfOneQuantPerRound__option_t) const;
template <> void Options::assignBool(
    options::fmfOneQuantPerRound__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::mbqiMode__option_t,
    const options::mbqiMode__option_t::type& x);
template <> const options::mbqiMode__option_t::type& Options::operator[](
    options::mbqiMode__option_t) const;
template <> bool Options::wasSetByUser(options::mbqiMode__option_t) const;
template <> void Options::assign(
    options::mbqiMode__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::miniscopeQuant__option_t,
    const options::miniscopeQuant__option_t::type& x);
template <> const options::miniscopeQuant__option_t::type& Options::operator[](
    options::miniscopeQuant__option_t) const;
template <> bool Options::wasSetByUser(options::miniscopeQuant__option_t) const;
template <> void Options::assignBool(
    options::miniscopeQuant__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::miniscopeQuantFreeVar__option_t,
    const options::miniscopeQuantFreeVar__option_t::type& x);
template <> const options::miniscopeQuantFreeVar__option_t::type& Options::operator[](
    options::miniscopeQuantFreeVar__option_t) const;
template <> bool Options::wasSetByUser(options::miniscopeQuantFreeVar__option_t) const;
template <> void Options::assignBool(
    options::miniscopeQuantFreeVar__option_t,
    std::string option,
    bool value);
template <> const options::multiTriggerCache__option_t::type& Options::operator[](
    options::multiTriggerCache__option_t) const;
template <> bool Options::wasSetByUser(options::multiTriggerCache__option_t) const;
template <> void Options::assignBool(
    options::multiTriggerCache__option_t,
    std::string option,
    bool value);
template <> const options::multiTriggerLinear__option_t::type& Options::operator[](
    options::multiTriggerLinear__option_t) const;
template <> bool Options::wasSetByUser(options::multiTriggerLinear__option_t) const;
template <> void Options::assignBool(
    options::multiTriggerLinear__option_t,
    std::string option,
    bool value);
template <> const options::multiTriggerPriority__option_t::type& Options::operator[](
    options::multiTriggerPriority__option_t) const;
template <> bool Options::wasSetByUser(options::multiTriggerPriority__option_t) const;
template <> void Options::assignBool(
    options::multiTriggerPriority__option_t,
    std::string option,
    bool value);
template <> const options::multiTriggerWhenSingle__option_t::type& Options::operator[](
    options::multiTriggerWhenSingle__option_t) const;
template <> bool Options::wasSetByUser(options::multiTriggerWhenSingle__option_t) const;
template <> void Options::assignBool(
    options::multiTriggerWhenSingle__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::partialTriggers__option_t,
    const options::partialTriggers__option_t::type& x);
template <> const options::partialTriggers__option_t::type& Options::operator[](
    options::partialTriggers__option_t) const;
template <> bool Options::wasSetByUser(options::partialTriggers__option_t) const;
template <> void Options::assignBool(
    options::partialTriggers__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::preSkolemQuant__option_t,
    const options::preSkolemQuant__option_t::type& x);
template <> const options::preSkolemQuant__option_t::type& Options::operator[](
    options::preSkolemQuant__option_t) const;
template <> bool Options::wasSetByUser(options::preSkolemQuant__option_t) const;
template <> void Options::assignBool(
    options::preSkolemQuant__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::preSkolemQuantAgg__option_t,
    const options::preSkolemQuantAgg__option_t::type& x);
template <> const options::preSkolemQuantAgg__option_t::type& Options::operator[](
    options::preSkolemQuantAgg__option_t) const;
template <> bool Options::wasSetByUser(options::preSkolemQuantAgg__option_t) const;
template <> void Options::assignBool(
    options::preSkolemQuantAgg__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::preSkolemQuantNested__option_t,
    const options::preSkolemQuantNested__option_t::type& x);
template <> const options::preSkolemQuantNested__option_t::type& Options::operator[](
    options::preSkolemQuantNested__option_t) const;
template <> bool Options::wasSetByUser(options::preSkolemQuantNested__option_t) const;
template <> void Options::assignBool(
    options::preSkolemQuantNested__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::prenexQuantUser__option_t,
    const options::prenexQuantUser__option_t::type& x);
template <> const options::prenexQuantUser__option_t::type& Options::operator[](
    options::prenexQuantUser__option_t) const;
template <> bool Options::wasSetByUser(options::prenexQuantUser__option_t) const;
template <> void Options::assignBool(
    options::prenexQuantUser__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::prenexQuant__option_t,
    const options::prenexQuant__option_t::type& x);
template <> const options::prenexQuant__option_t::type& Options::operator[](
    options::prenexQuant__option_t) const;
template <> bool Options::wasSetByUser(options::prenexQuant__option_t) const;
template <> void Options::assign(
    options::prenexQuant__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::pureThTriggers__option_t,
    const options::pureThTriggers__option_t::type& x);
template <> const options::pureThTriggers__option_t::type& Options::operator[](
    options::pureThTriggers__option_t) const;
template <> bool Options::wasSetByUser(options::pureThTriggers__option_t) const;
template <> void Options::assignBool(
    options::pureThTriggers__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::purifyDtTriggers__option_t,
    const options::purifyDtTriggers__option_t::type& x);
template <> const options::purifyDtTriggers__option_t::type& Options::operator[](
    options::purifyDtTriggers__option_t) const;
template <> bool Options::wasSetByUser(options::purifyDtTriggers__option_t) const;
template <> void Options::assignBool(
    options::purifyDtTriggers__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::purifyTriggers__option_t,
    const options::purifyTriggers__option_t::type& x);
template <> const options::purifyTriggers__option_t::type& Options::operator[](
    options::purifyTriggers__option_t) const;
template <> bool Options::wasSetByUser(options::purifyTriggers__option_t) const;
template <> void Options::assignBool(
    options::purifyTriggers__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::qcfAllConflict__option_t,
    const options::qcfAllConflict__option_t::type& x);
template <> const options::qcfAllConflict__option_t::type& Options::operator[](
    options::qcfAllConflict__option_t) const;
template <> bool Options::wasSetByUser(options::qcfAllConflict__option_t) const;
template <> void Options::assignBool(
    options::qcfAllConflict__option_t,
    std::string option,
    bool value);
template <> const options::qcfEagerCheckRd__option_t::type& Options::operator[](
    options::qcfEagerCheckRd__option_t) const;
template <> bool Options::wasSetByUser(options::qcfEagerCheckRd__option_t) const;
template <> void Options::assignBool(
    options::qcfEagerCheckRd__option_t,
    std::string option,
    bool value);
template <> const options::qcfEagerTest__option_t::type& Options::operator[](
    options::qcfEagerTest__option_t) const;
template <> bool Options::wasSetByUser(options::qcfEagerTest__option_t) const;
template <> void Options::assignBool(
    options::qcfEagerTest__option_t,
    std::string option,
    bool value);
template <> const options::qcfNestedConflict__option_t::type& Options::operator[](
    options::qcfNestedConflict__option_t) const;
template <> bool Options::wasSetByUser(options::qcfNestedConflict__option_t) const;
template <> void Options::assignBool(
    options::qcfNestedConflict__option_t,
    std::string option,
    bool value);
template <> const options::qcfSkipRd__option_t::type& Options::operator[](
    options::qcfSkipRd__option_t) const;
template <> bool Options::wasSetByUser(options::qcfSkipRd__option_t) const;
template <> void Options::assignBool(
    options::qcfSkipRd__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::qcfTConstraint__option_t,
    const options::qcfTConstraint__option_t::type& x);
template <> const options::qcfTConstraint__option_t::type& Options::operator[](
    options::qcfTConstraint__option_t) const;
template <> bool Options::wasSetByUser(options::qcfTConstraint__option_t) const;
template <> void Options::assignBool(
    options::qcfTConstraint__option_t,
    std::string option,
    bool value);
template <> const options::qcfVoExp__option_t::type& Options::operator[](
    options::qcfVoExp__option_t) const;
template <> bool Options::wasSetByUser(options::qcfVoExp__option_t) const;
template <> void Options::assignBool(
    options::qcfVoExp__option_t,
    std::string option,
    bool value);
template <> const options::quantAlphaEquiv__option_t::type& Options::operator[](
    options::quantAlphaEquiv__option_t) const;
template <> bool Options::wasSetByUser(options::quantAlphaEquiv__option_t) const;
template <> void Options::assignBool(
    options::quantAlphaEquiv__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::quantAntiSkolem__option_t,
    const options::quantAntiSkolem__option_t::type& x);
template <> const options::quantAntiSkolem__option_t::type& Options::operator[](
    options::quantAntiSkolem__option_t) const;
template <> bool Options::wasSetByUser(options::quantAntiSkolem__option_t) const;
template <> void Options::assignBool(
    options::quantAntiSkolem__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::quantConflictFind__option_t,
    const options::quantConflictFind__option_t::type& x);
template <> const options::quantConflictFind__option_t::type& Options::operator[](
    options::quantConflictFind__option_t) const;
template <> bool Options::wasSetByUser(options::quantConflictFind__option_t) const;
template <> void Options::assignBool(
    options::quantConflictFind__option_t,
    std::string option,
    bool value);
template <> const options::qcfMode__option_t::type& Options::operator[](
    options::qcfMode__option_t) const;
template <> bool Options::wasSetByUser(options::qcfMode__option_t) const;
template <> void Options::assign(
    options::qcfMode__option_t,
    std::string option,
    std::string value);
template <> const options::qcfWhenMode__option_t::type& Options::operator[](
    options::qcfWhenMode__option_t) const;
template <> bool Options::wasSetByUser(options::qcfWhenMode__option_t) const;
template <> void Options::assign(
    options::qcfWhenMode__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::quantDynamicSplit__option_t,
    const options::quantDynamicSplit__option_t::type& x);
template <> const options::quantDynamicSplit__option_t::type& Options::operator[](
    options::quantDynamicSplit__option_t) const;
template <> bool Options::wasSetByUser(options::quantDynamicSplit__option_t) const;
template <> void Options::assign(
    options::quantDynamicSplit__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::quantEpr__option_t,
    const options::quantEpr__option_t::type& x);
template <> const options::quantEpr__option_t::type& Options::operator[](
    options::quantEpr__option_t) const;
template <> bool Options::wasSetByUser(options::quantEpr__option_t) const;
template <> void Options::assignBool(
    options::quantEpr__option_t,
    std::string option,
    bool value);
template <> const options::quantEprMatching__option_t::type& Options::operator[](
    options::quantEprMatching__option_t) const;
template <> bool Options::wasSetByUser(options::quantEprMatching__option_t) const;
template <> void Options::assignBool(
    options::quantEprMatching__option_t,
    std::string option,
    bool value);
template <> const options::quantFunWellDefined__option_t::type& Options::operator[](
    options::quantFunWellDefined__option_t) const;
template <> bool Options::wasSetByUser(options::quantFunWellDefined__option_t) const;
template <> void Options::assignBool(
    options::quantFunWellDefined__option_t,
    std::string option,
    bool value);
template <> const options::quantInduction__option_t::type& Options::operator[](
    options::quantInduction__option_t) const;
template <> bool Options::wasSetByUser(options::quantInduction__option_t) const;
template <> void Options::assignBool(
    options::quantInduction__option_t,
    std::string option,
    bool value);
template <> const options::quantModelEe__option_t::type& Options::operator[](
    options::quantModelEe__option_t) const;
template <> bool Options::wasSetByUser(options::quantModelEe__option_t) const;
template <> void Options::assignBool(
    options::quantModelEe__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::quantRepMode__option_t,
    const options::quantRepMode__option_t::type& x);
template <> const options::quantRepMode__option_t::type& Options::operator[](
    options::quantRepMode__option_t) const;
template <> bool Options::wasSetByUser(options::quantRepMode__option_t) const;
template <> void Options::assign(
    options::quantRepMode__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::quantSplit__option_t,
    const options::quantSplit__option_t::type& x);
template <> const options::quantSplit__option_t::type& Options::operator[](
    options::quantSplit__option_t) const;
template <> bool Options::wasSetByUser(options::quantSplit__option_t) const;
template <> void Options::assignBool(
    options::quantSplit__option_t,
    std::string option,
    bool value);
template <> const options::registerQuantBodyTerms__option_t::type& Options::operator[](
    options::registerQuantBodyTerms__option_t) const;
template <> bool Options::wasSetByUser(options::registerQuantBodyTerms__option_t) const;
template <> void Options::assignBool(
    options::registerQuantBodyTerms__option_t,
    std::string option,
    bool value);
template <> const options::relationalTriggers__option_t::type& Options::operator[](
    options::relationalTriggers__option_t) const;
template <> bool Options::wasSetByUser(options::relationalTriggers__option_t) const;
template <> void Options::assignBool(
    options::relationalTriggers__option_t,
    std::string option,
    bool value);
template <> const options::relevantTriggers__option_t::type& Options::operator[](
    options::relevantTriggers__option_t) const;
template <> bool Options::wasSetByUser(options::relevantTriggers__option_t) const;
template <> void Options::assignBool(
    options::relevantTriggers__option_t,
    std::string option,
    bool value);
template <> const options::quantRewriteRules__option_t::type& Options::operator[](
    options::quantRewriteRules__option_t) const;
template <> bool Options::wasSetByUser(options::quantRewriteRules__option_t) const;
template <> void Options::assignBool(
    options::quantRewriteRules__option_t,
    std::string option,
    bool value);
template <> const options::rrOneInstPerRound__option_t::type& Options::operator[](
    options::rrOneInstPerRound__option_t) const;
template <> bool Options::wasSetByUser(options::rrOneInstPerRound__option_t) const;
template <> void Options::assignBool(
    options::rrOneInstPerRound__option_t,
    std::string option,
    bool value);
template <> const options::strictTriggers__option_t::type& Options::operator[](
    options::strictTriggers__option_t) const;
template <> bool Options::wasSetByUser(options::strictTriggers__option_t) const;
template <> void Options::assignBool(
    options::strictTriggers__option_t,
    std::string option,
    bool value);
template <> const options::sygusAddConstGrammar__option_t::type& Options::operator[](
    options::sygusAddConstGrammar__option_t) const;
template <> bool Options::wasSetByUser(options::sygusAddConstGrammar__option_t) const;
template <> void Options::assignBool(
    options::sygusAddConstGrammar__option_t,
    std::string option,
    bool value);
template <> const options::sygusInvAutoUnfold__option_t::type& Options::operator[](
    options::sygusInvAutoUnfold__option_t) const;
template <> bool Options::wasSetByUser(options::sygusInvAutoUnfold__option_t) const;
template <> void Options::assignBool(
    options::sygusInvAutoUnfold__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusBoolIteReturnConst__option_t,
    const options::sygusBoolIteReturnConst__option_t::type& x);
template <> const options::sygusBoolIteReturnConst__option_t::type& Options::operator[](
    options::sygusBoolIteReturnConst__option_t) const;
template <> bool Options::wasSetByUser(options::sygusBoolIteReturnConst__option_t) const;
template <> void Options::assignBool(
    options::sygusBoolIteReturnConst__option_t,
    std::string option,
    bool value);
template <> const options::sygusEvalUnfold__option_t::type& Options::operator[](
    options::sygusEvalUnfold__option_t) const;
template <> bool Options::wasSetByUser(options::sygusEvalUnfold__option_t) const;
template <> void Options::assignBool(
    options::sygusEvalUnfold__option_t,
    std::string option,
    bool value);
template <> const options::sygusEvalUnfoldBool__option_t::type& Options::operator[](
    options::sygusEvalUnfoldBool__option_t) const;
template <> bool Options::wasSetByUser(options::sygusEvalUnfoldBool__option_t) const;
template <> void Options::assignBool(
    options::sygusEvalUnfoldBool__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusExtRew__option_t,
    const options::sygusExtRew__option_t::type& x);
template <> const options::sygusExtRew__option_t::type& Options::operator[](
    options::sygusExtRew__option_t) const;
template <> bool Options::wasSetByUser(options::sygusExtRew__option_t) const;
template <> void Options::assignBool(
    options::sygusExtRew__option_t,
    std::string option,
    bool value);
template <> const options::sygusGrammarNorm__option_t::type& Options::operator[](
    options::sygusGrammarNorm__option_t) const;
template <> bool Options::wasSetByUser(options::sygusGrammarNorm__option_t) const;
template <> void Options::assignBool(
    options::sygusGrammarNorm__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusInference__option_t,
    const options::sygusInference__option_t::type& x);
template <> const options::sygusInference__option_t::type& Options::operator[](
    options::sygusInference__option_t) const;
template <> bool Options::wasSetByUser(options::sygusInference__option_t) const;
template <> void Options::assignBool(
    options::sygusInference__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusInvTemplWhenSyntax__option_t,
    const options::sygusInvTemplWhenSyntax__option_t::type& x);
template <> const options::sygusInvTemplWhenSyntax__option_t::type& Options::operator[](
    options::sygusInvTemplWhenSyntax__option_t) const;
template <> bool Options::wasSetByUser(options::sygusInvTemplWhenSyntax__option_t) const;
template <> void Options::assignBool(
    options::sygusInvTemplWhenSyntax__option_t,
    std::string option,
    bool value);
template <> const options::sygusInvTemplMode__option_t::type& Options::operator[](
    options::sygusInvTemplMode__option_t) const;
template <> bool Options::wasSetByUser(options::sygusInvTemplMode__option_t) const;
template <> void Options::assign(
    options::sygusInvTemplMode__option_t,
    std::string option,
    std::string value);
template <> const options::sygusMinGrammar__option_t::type& Options::operator[](
    options::sygusMinGrammar__option_t) const;
template <> bool Options::wasSetByUser(options::sygusMinGrammar__option_t) const;
template <> void Options::assignBool(
    options::sygusMinGrammar__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusUnifPbe__option_t,
    const options::sygusUnifPbe__option_t::type& x);
template <> const options::sygusUnifPbe__option_t::type& Options::operator[](
    options::sygusUnifPbe__option_t) const;
template <> bool Options::wasSetByUser(options::sygusUnifPbe__option_t) const;
template <> void Options::assignBool(
    options::sygusUnifPbe__option_t,
    std::string option,
    bool value);
template <> const options::sygusQePreproc__option_t::type& Options::operator[](
    options::sygusQePreproc__option_t) const;
template <> bool Options::wasSetByUser(options::sygusQePreproc__option_t) const;
template <> void Options::assignBool(
    options::sygusQePreproc__option_t,
    std::string option,
    bool value);
template <> const options::sygusRefEval__option_t::type& Options::operator[](
    options::sygusRefEval__option_t) const;
template <> bool Options::wasSetByUser(options::sygusRefEval__option_t) const;
template <> void Options::assignBool(
    options::sygusRefEval__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusRepairConst__option_t,
    const options::sygusRepairConst__option_t::type& x);
template <> const options::sygusRepairConst__option_t::type& Options::operator[](
    options::sygusRepairConst__option_t) const;
template <> bool Options::wasSetByUser(options::sygusRepairConst__option_t) const;
template <> void Options::assignBool(
    options::sygusRepairConst__option_t,
    std::string option,
    bool value);
template <> const options::sygusRew__option_t::type& Options::operator[](
    options::sygusRew__option_t) const;
template <> bool Options::wasSetByUser(options::sygusRew__option_t) const;
template <> void Options::assignBool(
    options::sygusRew__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusRewSynth__option_t,
    const options::sygusRewSynth__option_t::type& x);
template <> const options::sygusRewSynth__option_t::type& Options::operator[](
    options::sygusRewSynth__option_t) const;
template <> bool Options::wasSetByUser(options::sygusRewSynth__option_t) const;
template <> void Options::assignBool(
    options::sygusRewSynth__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusRewSynthAccel__option_t,
    const options::sygusRewSynthAccel__option_t::type& x);
template <> const options::sygusRewSynthAccel__option_t::type& Options::operator[](
    options::sygusRewSynthAccel__option_t) const;
template <> bool Options::wasSetByUser(options::sygusRewSynthAccel__option_t) const;
template <> void Options::assignBool(
    options::sygusRewSynthAccel__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusRewSynthCheck__option_t,
    const options::sygusRewSynthCheck__option_t::type& x);
template <> const options::sygusRewSynthCheck__option_t::type& Options::operator[](
    options::sygusRewSynthCheck__option_t) const;
template <> bool Options::wasSetByUser(options::sygusRewSynthCheck__option_t) const;
template <> void Options::assignBool(
    options::sygusRewSynthCheck__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusRewSynthFilterCong__option_t,
    const options::sygusRewSynthFilterCong__option_t::type& x);
template <> const options::sygusRewSynthFilterCong__option_t::type& Options::operator[](
    options::sygusRewSynthFilterCong__option_t) const;
template <> bool Options::wasSetByUser(options::sygusRewSynthFilterCong__option_t) const;
template <> void Options::assignBool(
    options::sygusRewSynthFilterCong__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusRewSynthFilterMatch__option_t,
    const options::sygusRewSynthFilterMatch__option_t::type& x);
template <> const options::sygusRewSynthFilterMatch__option_t::type& Options::operator[](
    options::sygusRewSynthFilterMatch__option_t) const;
template <> bool Options::wasSetByUser(options::sygusRewSynthFilterMatch__option_t) const;
template <> void Options::assignBool(
    options::sygusRewSynthFilterMatch__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusRewSynthFilterOrder__option_t,
    const options::sygusRewSynthFilterOrder__option_t::type& x);
template <> const options::sygusRewSynthFilterOrder__option_t::type& Options::operator[](
    options::sygusRewSynthFilterOrder__option_t) const;
template <> bool Options::wasSetByUser(options::sygusRewSynthFilterOrder__option_t) const;
template <> void Options::assignBool(
    options::sygusRewSynthFilterOrder__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusRewVerify__option_t,
    const options::sygusRewVerify__option_t::type& x);
template <> const options::sygusRewVerify__option_t::type& Options::operator[](
    options::sygusRewVerify__option_t) const;
template <> bool Options::wasSetByUser(options::sygusRewVerify__option_t) const;
template <> void Options::assignBool(
    options::sygusRewVerify__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusRewVerifyAbort__option_t,
    const options::sygusRewVerifyAbort__option_t::type& x);
template <> const options::sygusRewVerifyAbort__option_t::type& Options::operator[](
    options::sygusRewVerifyAbort__option_t) const;
template <> bool Options::wasSetByUser(options::sygusRewVerifyAbort__option_t) const;
template <> void Options::assignBool(
    options::sygusRewVerifyAbort__option_t,
    std::string option,
    bool value);
template <> const options::sygusSampleGrammar__option_t::type& Options::operator[](
    options::sygusSampleGrammar__option_t) const;
template <> bool Options::wasSetByUser(options::sygusSampleGrammar__option_t) const;
template <> void Options::assignBool(
    options::sygusSampleGrammar__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusSamples__option_t,
    const options::sygusSamples__option_t::type& x);
template <> const options::sygusSamples__option_t::type& Options::operator[](
    options::sygusSamples__option_t) const;
template <> bool Options::wasSetByUser(options::sygusSamples__option_t) const;
template <> void Options::assign(
    options::sygusSamples__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::sygusStream__option_t,
    const options::sygusStream__option_t::type& x);
template <> const options::sygusStream__option_t::type& Options::operator[](
    options::sygusStream__option_t) const;
template <> bool Options::wasSetByUser(options::sygusStream__option_t) const;
template <> void Options::assignBool(
    options::sygusStream__option_t,
    std::string option,
    bool value);
template <> const options::sygusTemplEmbedGrammar__option_t::type& Options::operator[](
    options::sygusTemplEmbedGrammar__option_t) const;
template <> bool Options::wasSetByUser(options::sygusTemplEmbedGrammar__option_t) const;
template <> void Options::assignBool(
    options::sygusTemplEmbedGrammar__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusUnif__option_t,
    const options::sygusUnif__option_t::type& x);
template <> const options::sygusUnif__option_t::type& Options::operator[](
    options::sygusUnif__option_t) const;
template <> bool Options::wasSetByUser(options::sygusUnif__option_t) const;
template <> void Options::assignBool(
    options::sygusUnif__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::termDbMode__option_t,
    const options::termDbMode__option_t::type& x);
template <> const options::termDbMode__option_t::type& Options::operator[](
    options::termDbMode__option_t) const;
template <> bool Options::wasSetByUser(options::termDbMode__option_t) const;
template <> void Options::assign(
    options::termDbMode__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::trackInstLemmas__option_t,
    const options::trackInstLemmas__option_t::type& x);
template <> const options::trackInstLemmas__option_t::type& Options::operator[](
    options::trackInstLemmas__option_t) const;
template <> bool Options::wasSetByUser(options::trackInstLemmas__option_t) const;
template <> void Options::assignBool(
    options::trackInstLemmas__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::triggerActiveSelMode__option_t,
    const options::triggerActiveSelMode__option_t::type& x);
template <> const options::triggerActiveSelMode__option_t::type& Options::operator[](
    options::triggerActiveSelMode__option_t) const;
template <> bool Options::wasSetByUser(options::triggerActiveSelMode__option_t) const;
template <> void Options::assign(
    options::triggerActiveSelMode__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::triggerSelMode__option_t,
    const options::triggerSelMode__option_t::type& x);
template <> const options::triggerSelMode__option_t::type& Options::operator[](
    options::triggerSelMode__option_t) const;
template <> bool Options::wasSetByUser(options::triggerSelMode__option_t) const;
template <> void Options::assign(
    options::triggerSelMode__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::userPatternsQuant__option_t,
    const options::userPatternsQuant__option_t::type& x);
template <> const options::userPatternsQuant__option_t::type& Options::operator[](
    options::userPatternsQuant__option_t) const;
template <> bool Options::wasSetByUser(options::userPatternsQuant__option_t) const;
template <> void Options::assign(
    options::userPatternsQuant__option_t,
    std::string option,
    std::string value);
template <> const options::varElimQuant__option_t::type& Options::operator[](
    options::varElimQuant__option_t) const;
template <> bool Options::wasSetByUser(options::varElimQuant__option_t) const;
template <> void Options::assignBool(
    options::varElimQuant__option_t,
    std::string option,
    bool value);
template <> const options::varIneqElimQuant__option_t::type& Options::operator[](
    options::varIneqElimQuant__option_t) const;
template <> bool Options::wasSetByUser(options::varIneqElimQuant__option_t) const;
template <> void Options::assignBool(
    options::varIneqElimQuant__option_t,
    std::string option,
    bool value);


namespace options {

inline aggressiveMiniscopeQuant__option_t::type aggressiveMiniscopeQuant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool aggressiveMiniscopeQuant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline cbqi__option_t::type cbqi__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cbqi__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cbqi__option_t::set(const cbqi__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cbqiAll__option_t::type cbqiAll__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cbqiAll__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cbqiAll__option_t::set(const cbqiAll__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cbqiBv__option_t::type cbqiBv__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cbqiBv__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cbqiBv__option_t::set(const cbqiBv__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cbqiBvConcInv__option_t::type cbqiBvConcInv__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cbqiBvConcInv__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cbqiBvConcInv__option_t::set(const cbqiBvConcInv__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cbqiBvIneqMode__option_t::type cbqiBvIneqMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cbqiBvIneqMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cbqiBvIneqMode__option_t::set(const cbqiBvIneqMode__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cbqiBvInterleaveValue__option_t::type cbqiBvInterleaveValue__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cbqiBvInterleaveValue__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cbqiBvInterleaveValue__option_t::set(const cbqiBvInterleaveValue__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cbqiBvLinearize__option_t::type cbqiBvLinearize__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cbqiBvLinearize__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cbqiBvLinearize__option_t::set(const cbqiBvLinearize__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cbqiBvRmExtract__option_t::type cbqiBvRmExtract__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cbqiBvRmExtract__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cbqiBvRmExtract__option_t::set(const cbqiBvRmExtract__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cbqiBvSolveNl__option_t::type cbqiBvSolveNl__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cbqiBvSolveNl__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cbqiBvSolveNl__option_t::set(const cbqiBvSolveNl__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cbqiFullEffort__option_t::type cbqiFullEffort__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cbqiFullEffort__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cbqiFullEffort__option_t::set(const cbqiFullEffort__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cbqiInnermost__option_t::type cbqiInnermost__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cbqiInnermost__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cbqiInnermost__option_t::set(const cbqiInnermost__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cbqiLitDepend__option_t::type cbqiLitDepend__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cbqiLitDepend__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline cbqiMidpoint__option_t::type cbqiMidpoint__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cbqiMidpoint__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cbqiMidpoint__option_t::set(const cbqiMidpoint__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cbqiMinBounds__option_t::type cbqiMinBounds__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cbqiMinBounds__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline cbqiModel__option_t::type cbqiModel__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cbqiModel__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cbqiModel__option_t::set(const cbqiModel__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cbqiMultiInst__option_t::type cbqiMultiInst__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cbqiMultiInst__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cbqiMultiInst__option_t::set(const cbqiMultiInst__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cbqiNestedQE__option_t::type cbqiNestedQE__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cbqiNestedQE__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cbqiNestedQE__option_t::set(const cbqiNestedQE__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cbqiNopt__option_t::type cbqiNopt__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cbqiNopt__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline cbqiPreRegInst__option_t::type cbqiPreRegInst__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cbqiPreRegInst__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cbqiPreRegInst__option_t::set(const cbqiPreRegInst__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline recurseCbqi__option_t::type recurseCbqi__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool recurseCbqi__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline cbqiRepeatLit__option_t::type cbqiRepeatLit__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cbqiRepeatLit__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cbqiRepeatLit__option_t::set(const cbqiRepeatLit__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cbqiRoundUpLowerLia__option_t::type cbqiRoundUpLowerLia__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cbqiRoundUpLowerLia__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline cbqiSat__option_t::type cbqiSat__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cbqiSat__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cbqiSat__option_t::set(const cbqiSat__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cbqiUseInfInt__option_t::type cbqiUseInfInt__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cbqiUseInfInt__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cbqiUseInfInt__option_t::set(const cbqiUseInfInt__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cbqiUseInfReal__option_t::type cbqiUseInfReal__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cbqiUseInfReal__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cbqiUseInfReal__option_t::set(const cbqiUseInfReal__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cegisSample__option_t::type cegisSample__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegisSample__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cegisSample__option_t::set(const cegisSample__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline ceGuidedInst__option_t::type ceGuidedInst__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool ceGuidedInst__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void ceGuidedInst__option_t::set(const ceGuidedInst__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline cegqiSingleInvAbort__option_t::type cegqiSingleInvAbort__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiSingleInvAbort__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline cegqiSingleInvPartial__option_t::type cegqiSingleInvPartial__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiSingleInvPartial__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline cegqiSingleInvReconstruct__option_t::type cegqiSingleInvReconstruct__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiSingleInvReconstruct__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline cegqiSingleInvReconstructConst__option_t::type cegqiSingleInvReconstructConst__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiSingleInvReconstructConst__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline cegqiSolMinCore__option_t::type cegqiSolMinCore__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiSolMinCore__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline cegqiSolMinInst__option_t::type cegqiSolMinInst__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiSolMinInst__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline cegqiSingleInvMode__option_t::type cegqiSingleInvMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cegqiSingleInvMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void cegqiSingleInvMode__option_t::set(const cegqiSingleInvMode__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline condRewriteQuant__option_t::type condRewriteQuant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool condRewriteQuant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline condVarSplitQuantAgg__option_t::type condVarSplitQuantAgg__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool condVarSplitQuantAgg__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline condVarSplitQuant__option_t::type condVarSplitQuant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool condVarSplitQuant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline conjectureFilterActiveTerms__option_t::type conjectureFilterActiveTerms__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool conjectureFilterActiveTerms__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void conjectureFilterActiveTerms__option_t::set(const conjectureFilterActiveTerms__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline conjectureFilterCanonical__option_t::type conjectureFilterCanonical__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool conjectureFilterCanonical__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void conjectureFilterCanonical__option_t::set(const conjectureFilterCanonical__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline conjectureFilterModel__option_t::type conjectureFilterModel__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool conjectureFilterModel__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void conjectureFilterModel__option_t::set(const conjectureFilterModel__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline conjectureGen__option_t::type conjectureGen__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool conjectureGen__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void conjectureGen__option_t::set(const conjectureGen__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline conjectureGenGtEnum__option_t::type conjectureGenGtEnum__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool conjectureGenGtEnum__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline conjectureGenMaxDepth__option_t::type conjectureGenMaxDepth__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool conjectureGenMaxDepth__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline conjectureGenPerRound__option_t::type conjectureGenPerRound__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool conjectureGenPerRound__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline conjectureUeeIntro__option_t::type conjectureUeeIntro__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool conjectureUeeIntro__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline conjectureNoFilter__option_t::type conjectureNoFilter__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool conjectureNoFilter__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline dtStcInduction__option_t::type dtStcInduction__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool dtStcInduction__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void dtStcInduction__option_t::set(const dtStcInduction__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline dtVarExpandQuant__option_t::type dtVarExpandQuant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool dtVarExpandQuant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline eMatching__option_t::type eMatching__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool eMatching__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void eMatching__option_t::set(const eMatching__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline elimExtArithQuant__option_t::type elimExtArithQuant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool elimExtArithQuant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void elimExtArithQuant__option_t::set(const elimExtArithQuant__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline elimTautQuant__option_t::type elimTautQuant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool elimTautQuant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline finiteModelFind__option_t::type finiteModelFind__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool finiteModelFind__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void finiteModelFind__option_t::set(const finiteModelFind__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline fmfBound__option_t::type fmfBound__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fmfBound__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void fmfBound__option_t::set(const fmfBound__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline fmfBoundInt__option_t::type fmfBoundInt__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fmfBoundInt__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void fmfBoundInt__option_t::set(const fmfBoundInt__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline fmfBoundLazy__option_t::type fmfBoundLazy__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fmfBoundLazy__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void fmfBoundLazy__option_t::set(const fmfBoundLazy__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline fmfBoundMinMode__option_t::type fmfBoundMinMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fmfBoundMinMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline fmfEmptySorts__option_t::type fmfEmptySorts__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fmfEmptySorts__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline fmfFmcSimple__option_t::type fmfFmcSimple__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fmfFmcSimple__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline fmfFreshDistConst__option_t::type fmfFreshDistConst__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fmfFreshDistConst__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline fmfFunWellDefined__option_t::type fmfFunWellDefined__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fmfFunWellDefined__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void fmfFunWellDefined__option_t::set(const fmfFunWellDefined__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline fmfFunWellDefinedRelevant__option_t::type fmfFunWellDefinedRelevant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fmfFunWellDefinedRelevant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline fmfInstEngine__option_t::type fmfInstEngine__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fmfInstEngine__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void fmfInstEngine__option_t::set(const fmfInstEngine__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline fmfInstGen__option_t::type fmfInstGen__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fmfInstGen__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline fmfInstGenOneQuantPerRound__option_t::type fmfInstGenOneQuantPerRound__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fmfInstGenOneQuantPerRound__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline fullSaturateInterleave__option_t::type fullSaturateInterleave__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fullSaturateInterleave__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline fullSaturateQuant__option_t::type fullSaturateQuant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fullSaturateQuant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void fullSaturateQuant__option_t::set(const fullSaturateQuant__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline fullSaturateQuantRd__option_t::type fullSaturateQuantRd__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fullSaturateQuantRd__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline globalNegate__option_t::type globalNegate__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool globalNegate__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void globalNegate__option_t::set(const globalNegate__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline hoMatching__option_t::type hoMatching__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool hoMatching__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline hoMatchingVarArgPriority__option_t::type hoMatchingVarArgPriority__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool hoMatchingVarArgPriority__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline hoMergeTermDb__option_t::type hoMergeTermDb__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool hoMergeTermDb__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline incrementTriggers__option_t::type incrementTriggers__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool incrementTriggers__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline inferArithTriggerEq__option_t::type inferArithTriggerEq__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool inferArithTriggerEq__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline inferArithTriggerEqExp__option_t::type inferArithTriggerEqExp__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool inferArithTriggerEqExp__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline instLevelInputOnly__option_t::type instLevelInputOnly__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool instLevelInputOnly__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline instMaxLevel__option_t::type instMaxLevel__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool instMaxLevel__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void instMaxLevel__option_t::set(const instMaxLevel__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline instNoEntail__option_t::type instNoEntail__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool instNoEntail__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void instNoEntail__option_t::set(const instNoEntail__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline instNoModelTrue__option_t::type instNoModelTrue__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool instNoModelTrue__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void instNoModelTrue__option_t::set(const instNoModelTrue__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline instPropagate__option_t::type instPropagate__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool instPropagate__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void instPropagate__option_t::set(const instPropagate__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline instWhenPhase__option_t::type instWhenPhase__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool instWhenPhase__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void instWhenPhase__option_t::set(const instWhenPhase__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline instWhenStrictInterleave__option_t::type instWhenStrictInterleave__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool instWhenStrictInterleave__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void instWhenStrictInterleave__option_t::set(const instWhenStrictInterleave__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline instWhenTcFirst__option_t::type instWhenTcFirst__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool instWhenTcFirst__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void instWhenTcFirst__option_t::set(const instWhenTcFirst__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline instWhenMode__option_t::type instWhenMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool instWhenMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void instWhenMode__option_t::set(const instWhenMode__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline intWfInduction__option_t::type intWfInduction__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool intWfInduction__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void intWfInduction__option_t::set(const intWfInduction__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline iteDtTesterSplitQuant__option_t::type iteDtTesterSplitQuant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool iteDtTesterSplitQuant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void iteDtTesterSplitQuant__option_t::set(const iteDtTesterSplitQuant__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline iteLiftQuant__option_t::type iteLiftQuant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool iteLiftQuant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void iteLiftQuant__option_t::set(const iteLiftQuant__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline literalMatchMode__option_t::type literalMatchMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool literalMatchMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline localTheoryExt__option_t::type localTheoryExt__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool localTheoryExt__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline ltePartialInst__option_t::type ltePartialInst__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool ltePartialInst__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline lteRestrictInstClosure__option_t::type lteRestrictInstClosure__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool lteRestrictInstClosure__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline macrosQuant__option_t::type macrosQuant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool macrosQuant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void macrosQuant__option_t::set(const macrosQuant__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline macrosQuantMode__option_t::type macrosQuantMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool macrosQuantMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline mbqiInterleave__option_t::type mbqiInterleave__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool mbqiInterleave__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline fmfOneInstPerRound__option_t::type fmfOneInstPerRound__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fmfOneInstPerRound__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void fmfOneInstPerRound__option_t::set(const fmfOneInstPerRound__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline fmfOneQuantPerRound__option_t::type fmfOneQuantPerRound__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool fmfOneQuantPerRound__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline mbqiMode__option_t::type mbqiMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool mbqiMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void mbqiMode__option_t::set(const mbqiMode__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline miniscopeQuant__option_t::type miniscopeQuant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool miniscopeQuant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void miniscopeQuant__option_t::set(const miniscopeQuant__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline miniscopeQuantFreeVar__option_t::type miniscopeQuantFreeVar__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool miniscopeQuantFreeVar__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void miniscopeQuantFreeVar__option_t::set(const miniscopeQuantFreeVar__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline multiTriggerCache__option_t::type multiTriggerCache__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool multiTriggerCache__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline multiTriggerLinear__option_t::type multiTriggerLinear__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool multiTriggerLinear__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline multiTriggerPriority__option_t::type multiTriggerPriority__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool multiTriggerPriority__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline multiTriggerWhenSingle__option_t::type multiTriggerWhenSingle__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool multiTriggerWhenSingle__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline partialTriggers__option_t::type partialTriggers__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool partialTriggers__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void partialTriggers__option_t::set(const partialTriggers__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline preSkolemQuant__option_t::type preSkolemQuant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool preSkolemQuant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void preSkolemQuant__option_t::set(const preSkolemQuant__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline preSkolemQuantAgg__option_t::type preSkolemQuantAgg__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool preSkolemQuantAgg__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void preSkolemQuantAgg__option_t::set(const preSkolemQuantAgg__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline preSkolemQuantNested__option_t::type preSkolemQuantNested__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool preSkolemQuantNested__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void preSkolemQuantNested__option_t::set(const preSkolemQuantNested__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline prenexQuantUser__option_t::type prenexQuantUser__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool prenexQuantUser__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void prenexQuantUser__option_t::set(const prenexQuantUser__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline prenexQuant__option_t::type prenexQuant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool prenexQuant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void prenexQuant__option_t::set(const prenexQuant__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline pureThTriggers__option_t::type pureThTriggers__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool pureThTriggers__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void pureThTriggers__option_t::set(const pureThTriggers__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline purifyDtTriggers__option_t::type purifyDtTriggers__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool purifyDtTriggers__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void purifyDtTriggers__option_t::set(const purifyDtTriggers__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline purifyTriggers__option_t::type purifyTriggers__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool purifyTriggers__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void purifyTriggers__option_t::set(const purifyTriggers__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline qcfAllConflict__option_t::type qcfAllConflict__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool qcfAllConflict__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void qcfAllConflict__option_t::set(const qcfAllConflict__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline qcfEagerCheckRd__option_t::type qcfEagerCheckRd__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool qcfEagerCheckRd__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline qcfEagerTest__option_t::type qcfEagerTest__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool qcfEagerTest__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline qcfNestedConflict__option_t::type qcfNestedConflict__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool qcfNestedConflict__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline qcfSkipRd__option_t::type qcfSkipRd__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool qcfSkipRd__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline qcfTConstraint__option_t::type qcfTConstraint__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool qcfTConstraint__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void qcfTConstraint__option_t::set(const qcfTConstraint__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline qcfVoExp__option_t::type qcfVoExp__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool qcfVoExp__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline quantAlphaEquiv__option_t::type quantAlphaEquiv__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool quantAlphaEquiv__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline quantAntiSkolem__option_t::type quantAntiSkolem__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool quantAntiSkolem__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void quantAntiSkolem__option_t::set(const quantAntiSkolem__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline quantConflictFind__option_t::type quantConflictFind__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool quantConflictFind__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void quantConflictFind__option_t::set(const quantConflictFind__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline qcfMode__option_t::type qcfMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool qcfMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline qcfWhenMode__option_t::type qcfWhenMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool qcfWhenMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline quantDynamicSplit__option_t::type quantDynamicSplit__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool quantDynamicSplit__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void quantDynamicSplit__option_t::set(const quantDynamicSplit__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline quantEpr__option_t::type quantEpr__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool quantEpr__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void quantEpr__option_t::set(const quantEpr__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline quantEprMatching__option_t::type quantEprMatching__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool quantEprMatching__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline quantFunWellDefined__option_t::type quantFunWellDefined__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool quantFunWellDefined__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline quantInduction__option_t::type quantInduction__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool quantInduction__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline quantModelEe__option_t::type quantModelEe__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool quantModelEe__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline quantRepMode__option_t::type quantRepMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool quantRepMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void quantRepMode__option_t::set(const quantRepMode__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline quantSplit__option_t::type quantSplit__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool quantSplit__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void quantSplit__option_t::set(const quantSplit__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline registerQuantBodyTerms__option_t::type registerQuantBodyTerms__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool registerQuantBodyTerms__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline relationalTriggers__option_t::type relationalTriggers__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool relationalTriggers__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline relevantTriggers__option_t::type relevantTriggers__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool relevantTriggers__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline quantRewriteRules__option_t::type quantRewriteRules__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool quantRewriteRules__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline rrOneInstPerRound__option_t::type rrOneInstPerRound__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool rrOneInstPerRound__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline strictTriggers__option_t::type strictTriggers__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool strictTriggers__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusAddConstGrammar__option_t::type sygusAddConstGrammar__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusAddConstGrammar__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusInvAutoUnfold__option_t::type sygusInvAutoUnfold__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusInvAutoUnfold__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusBoolIteReturnConst__option_t::type sygusBoolIteReturnConst__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusBoolIteReturnConst__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusBoolIteReturnConst__option_t::set(const sygusBoolIteReturnConst__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusEvalUnfold__option_t::type sygusEvalUnfold__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusEvalUnfold__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusEvalUnfoldBool__option_t::type sygusEvalUnfoldBool__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusEvalUnfoldBool__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusExtRew__option_t::type sygusExtRew__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusExtRew__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusExtRew__option_t::set(const sygusExtRew__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusGrammarNorm__option_t::type sygusGrammarNorm__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusGrammarNorm__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusInference__option_t::type sygusInference__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusInference__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusInference__option_t::set(const sygusInference__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusInvTemplWhenSyntax__option_t::type sygusInvTemplWhenSyntax__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusInvTemplWhenSyntax__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusInvTemplWhenSyntax__option_t::set(const sygusInvTemplWhenSyntax__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusInvTemplMode__option_t::type sygusInvTemplMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusInvTemplMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusMinGrammar__option_t::type sygusMinGrammar__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusMinGrammar__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusUnifPbe__option_t::type sygusUnifPbe__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusUnifPbe__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusUnifPbe__option_t::set(const sygusUnifPbe__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusQePreproc__option_t::type sygusQePreproc__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusQePreproc__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusRefEval__option_t::type sygusRefEval__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusRefEval__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusRepairConst__option_t::type sygusRepairConst__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusRepairConst__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusRepairConst__option_t::set(const sygusRepairConst__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusRew__option_t::type sygusRew__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusRew__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusRewSynth__option_t::type sygusRewSynth__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusRewSynth__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusRewSynth__option_t::set(const sygusRewSynth__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusRewSynthAccel__option_t::type sygusRewSynthAccel__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusRewSynthAccel__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusRewSynthAccel__option_t::set(const sygusRewSynthAccel__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusRewSynthCheck__option_t::type sygusRewSynthCheck__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusRewSynthCheck__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusRewSynthCheck__option_t::set(const sygusRewSynthCheck__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusRewSynthFilterCong__option_t::type sygusRewSynthFilterCong__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusRewSynthFilterCong__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusRewSynthFilterCong__option_t::set(const sygusRewSynthFilterCong__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusRewSynthFilterMatch__option_t::type sygusRewSynthFilterMatch__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusRewSynthFilterMatch__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusRewSynthFilterMatch__option_t::set(const sygusRewSynthFilterMatch__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusRewSynthFilterOrder__option_t::type sygusRewSynthFilterOrder__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusRewSynthFilterOrder__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusRewSynthFilterOrder__option_t::set(const sygusRewSynthFilterOrder__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusRewVerify__option_t::type sygusRewVerify__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusRewVerify__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusRewVerify__option_t::set(const sygusRewVerify__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusRewVerifyAbort__option_t::type sygusRewVerifyAbort__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusRewVerifyAbort__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusRewVerifyAbort__option_t::set(const sygusRewVerifyAbort__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusSampleGrammar__option_t::type sygusSampleGrammar__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusSampleGrammar__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusSamples__option_t::type sygusSamples__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusSamples__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusSamples__option_t::set(const sygusSamples__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusStream__option_t::type sygusStream__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusStream__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusStream__option_t::set(const sygusStream__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusTemplEmbedGrammar__option_t::type sygusTemplEmbedGrammar__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusTemplEmbedGrammar__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusUnif__option_t::type sygusUnif__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusUnif__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusUnif__option_t::set(const sygusUnif__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline termDbMode__option_t::type termDbMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool termDbMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void termDbMode__option_t::set(const termDbMode__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline trackInstLemmas__option_t::type trackInstLemmas__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool trackInstLemmas__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void trackInstLemmas__option_t::set(const trackInstLemmas__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline triggerActiveSelMode__option_t::type triggerActiveSelMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool triggerActiveSelMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void triggerActiveSelMode__option_t::set(const triggerActiveSelMode__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline triggerSelMode__option_t::type triggerSelMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool triggerSelMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void triggerSelMode__option_t::set(const triggerSelMode__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline userPatternsQuant__option_t::type userPatternsQuant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool userPatternsQuant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void userPatternsQuant__option_t::set(const userPatternsQuant__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline varElimQuant__option_t::type varElimQuant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool varElimQuant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline varIneqElimQuant__option_t::type varIneqElimQuant__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool varIneqElimQuant__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}


}  // namespace options
}  // namespace CVC4

#endif /* __CVC4__OPTIONS__QUANTIFIERS_H */
