﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using System;
using System.Security.Cryptography;
using System.Text;

namespace Microsoft.CodeAnalysis.Internal.Log;

internal static class AnalyzerNameForTelemetry
{
    public static string ComputeSha256Hash(string name)
    {
        using var sha256 = SHA256.Create();
        return Convert.ToBase64String(sha256.ComputeHash(Encoding.UTF8.GetBytes(name)));
    }
}
