/*
 * FCML - Free Code Manipulation Library.
 * Copyright (C) 2010-2015 Slawomir Wojtasiak
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <fcml_assembler.h>
#include "instructions_b_t.h"
#include "instructions_base_t.h"

fcml_bool fcml_tf_instructions_b_suite_init(void) {
    return FCML_TRUE;
}

fcml_bool fcml_tf_instructions_b_suite_cleanup(void) {
    return FCML_TRUE;
}

void fcml_tf_instruction_BLENDPD_VBLENDPD(void) {
    FCML_I32( "blendpd xmm2,xmmword ptr [ecx+eax],0ffh", 0x66, 0x0F, 0x3a, 0x0D, 0x14, 0x01, 0xFF );
    FCML_I64( "blendpd xmm2,xmmword ptr [rcx+rax],0ffh", 0x66, 0x0F, 0x3a, 0x0D, 0x14, 0x01, 0xFF );
    FCML_A64( "blendpd $0xff,(%rcx,%rax),%xmm2", 0x66, 0x0F, 0x3a, 0x0D, 0x14, 0x01, 0xFF );
    FCML_I64( "vblendpd ymm10,ymm14,ymmword ptr [r9+rax],20h", 0xC4, 0x43, 0x0D, 0x0D, 0x14, 0x01, 0x20 );
    FCML_I32_D( "vblendpd xmm2,xmm7,xmmword ptr [ecx+eax],20h", 0xC4, 0xC3, 0x41, 0x0D, 0x14, 0x01, 0x20 ); /* REX.B ignored in 32bit mode.*/
    FCML_I32_D( "vblendpd xmm2,xmm2,xmmword ptr [ecx+eax],20h", 0xC4, 0xC3, 0x69, 0x0D, 0x14, 0x01, 0x20 ); /* REX.B ignored in 32bit mode.*/
    FCML_I32( "vblendpd xmm2,xmm7,xmmword ptr [ecx+eax],20h", 0xC4, 0xE3, 0x41, 0x0D, 0x14, 0x01, 0x20 );
    FCML_I32( "vblendpd xmm2,xmm2,xmmword ptr [ecx+eax],20h", 0xC4, 0xE3, 0x69, 0x0D, 0x14, 0x01, 0x20 );
    FCML_A32( "vblendpd $0x20,(%ecx,%eax),%xmm2,%xmm2", 0xC4, 0xE3, 0x69, 0x0D, 0x14, 0x01, 0x20 );
}

void fcml_tf_instruction_BLENDPS_VBLENDPS(void) {
    FCML_I32( "blendps xmm2,xmmword ptr [ecx+eax],0ffh", 0x66, 0x0F, 0x3a, 0x0C, 0x14, 0x01, 0xFF );
    FCML_A64( "blendps $0xff,(%rcx,%rax),%xmm2", 0x66, 0x0F, 0x3a, 0x0C, 0x14, 0x01, 0xFF );
    FCML_I64( "vblendps ymm10,ymm14,ymmword ptr [r9+rax],20h", 0xC4, 0x43, 0x0D, 0x0C, 0x14, 0x01, 0x20 );
    FCML_I32( "vblendps xmm2,xmm7,xmmword ptr [ecx+eax],20h", 0xC4, 0xE3, 0x41, 0x0C, 0x14, 0x01, 0x20 );
    FCML_I32( "vblendps xmm2,xmm2,xmmword ptr [ecx+eax],20h", 0xC4, 0xE3, 0x69, 0x0C, 0x14, 0x01, 0x20 );
    FCML_A64( "vblendps $0x20,(%rcx,%rax),%xmm2,%xmm2", 0xC4, 0xE3, 0x69, 0x0C, 0x14, 0x01, 0x20 );
}

void fcml_tf_instruction_BLENDVPD_VBLENDVPD(void) {
    FCML_I32( "blendvpd xmm2,xmmword ptr [ecx+eax],xmm0", 0x66, 0x0F, 0x38, 0x15, 0x14, 0x01 );
    FCML_I64( "blendvpd xmm2,xmmword ptr [rcx+rax],xmm0", 0x66, 0x0F, 0x38, 0x15, 0x14, 0x01 );
    FCML_A64( "blendvpd %xmm0,(%rcx,%rax),%xmm2", 0x66, 0x0F, 0x38, 0x15, 0x14, 0x01 );
    FCML_I64( "vblendvpd ymm10,ymm14,ymmword ptr [r9+rax],ymm2", 0xC4, 0x43, 0x0D, 0x4B, 0x14, 0x01, 0x20 );
    FCML_A64( "vblendvpd %ymm2,(%r9,%rax),%ymm14,%ymm10", 0xC4, 0x43, 0x0D, 0x4B, 0x14, 0x01, 0x20 );
    FCML_I32( "vblendvpd xmm2,xmm7,xmmword ptr [ecx+eax],xmm2", 0xC4, 0xE3, 0x41, 0x4B, 0x14, 0x01, 0x20 );
    FCML_I32_A( "vblendvpd xmm2,xmm7,[ecx+eax],xmm2", 0xC4, 0xE3, 0x41, 0x4B, 0x14, 0x01, 0x20 );
    FCML_I32_D( "vblendvpd xmm2,xmm2,xmmword ptr [ecx+eax],xmm2", 0xC4, 0xE3, 0x69, 0x4B, 0x14, 0x01, 0xA0 );
    FCML_I32( "vblendvpd xmm2,xmm2,xmmword ptr [ecx+eax],xmm2", 0xC4, 0xE3, 0x69, 0x4B, 0x14, 0x01, 0x20 );
    FCML_A32( "vblendvpd %xmm2,(%ecx,%eax),%xmm2,%xmm2", 0xC4, 0xE3, 0x69, 0x4B, 0x14, 0x01, 0x20 );
}

void fcml_tf_instruction_BLENDVPS_VBLENDVPS(void) {
    FCML_I32( "blendvps xmm2,xmmword ptr [ecx+eax],xmm0", 0x66, 0x0F, 0x38, 0x14, 0x14, 0x01 );
    FCML_I64( "blendvps xmm2,xmmword ptr [rcx+rax],xmm0", 0x66, 0x0F, 0x38, 0x14, 0x14, 0x01 );
    FCML_A64( "blendvps %xmm0,(%rcx,%rax),%xmm2", 0x66, 0x0F, 0x38, 0x14, 0x14, 0x01 );
    FCML_I64( "vblendvps ymm10,ymm14,ymmword ptr [r9+rax],ymm2", 0xC4, 0x43, 0x0D, 0x4A, 0x14, 0x01, 0x20 );
    FCML_I64_A( "vblendvps ymm10,ymm14,[r9+rax],ymm2", 0xC4, 0x43, 0x0D, 0x4A, 0x14, 0x01, 0x20 );
    FCML_I32( "vblendvps xmm2,xmm7,xmmword ptr [ecx+eax],xmm2", 0xC4, 0xE3, 0x41, 0x4A, 0x14, 0x01, 0x20 );
    FCML_I32_D( "vblendvps xmm2,xmm2,xmmword ptr [ecx+eax],xmm2", 0xC4, 0xC3, 0x69, 0x4A, 0x14, 0x01, 0xA0 );
    FCML_A32( "vblendvps %xmm2,(%ecx,%eax),%xmm2,%xmm2", 0xC4, 0xE3, 0x69, 0x4A, 0x14, 0x01, 0x20 );
}

void fcml_tf_instruction_BOUND(void) {
    FCML_I32( "bound esi,qword ptr [eax]", 0x62, 0x30 );
    FCML_I32_A( "bound esi,[eax]", 0x62, 0x30 );
    FCML_A32( "bound %esi,(%eax)", 0x62, 0x30 );
    FCML_I32( "bound si,dword ptr [eax]", 0x66, 0x62, 0x30 );
    FCML_I32( "bound si,dword ptr [bx+si]", 0x66, 0x67, 0x62, 0x30 );
    /* Not supported in 64.
     */
    FCML_I64_FAILED( "bound si,dword ptr [eax]", 0x62, 0x30 );
    /* Addressing not supported, only memory addressing is allowed here.
     */
    FCML_I64_FAILED( "bound si,dword ptr eax", 0x62, 0xc0 );
}

void fcml_tf_instruction_BSF(void) {
    FCML_I32( "bsf esp,dword ptr [ebp+04030201h]", 0x0f, 0xbc, 0xa5, 0x01, 0x02, 0x03, 0x04 );
    FCML_I32( "bsf sp,word ptr [di+0201h]", 0x66, 0x67, 0x0f, 0xbc, 0xa5, 0x01, 0x02 );
    FCML_A32( "bsf 0x0201(%di),%sp", 0x66, 0x67, 0x0f, 0xbc, 0xa5, 0x01, 0x02 );
    FCML_I32( "bsf esp,dword ptr [di+0201h]", 0x67, 0x0f, 0xbc, 0xa5, 0x01, 0x02 );
    FCML_I64( "bsf r12,qword ptr [r9+rcx*4+0000000000000001h]", 0x4D, 0x0f, 0xbc, 0x64, 0x89, 0x01 );
    FCML_A64( "bsf 0x0000000000000001(%r9,%rcx,4),%r12", 0x4D, 0x0f, 0xbc, 0x64, 0x89, 0x01 );
}

void fcml_tf_instruction_BSR(void) {
    /* We can only assemble BSR instructions, because they are always disassembled to BSF.
     */
    FCML_I32_A( "bsr esp,dword ptr [ebp+04030201h]", 0x0f, 0xbc, 0xa5, 0x01, 0x02, 0x03, 0x04 );
    FCML_A32_A( "bsr 0x04030201(%ebp),%esp", 0x0f, 0xbc, 0xa5, 0x01, 0x02, 0x03, 0x04 );
    FCML_I32_A( "bsr sp,word ptr [di+0201h]", 0x66, 0x67, 0x0f, 0xbc, 0xa5, 0x01, 0x02 );
    FCML_I32_A( "bsr esp,dword ptr [di+0201h]", 0x67, 0x0f, 0xbc, 0xa5, 0x01, 0x02 );
    FCML_I64_A( "bsr r12,qword ptr [r9+rcx*4+0000000000000001h]", 0x4D, 0x0f, 0xbc, 0x64, 0x89, 0x01 );
    FCML_A64_A( "bsr 0x00000001(%r9,%rcx,4),%r12", 0x4D, 0x0f, 0xbc, 0x64, 0x89, 0x01 );
}

void fcml_tf_instruction_BSWAP(void) {

    FCML_I3264( "bswap eax", 0x0f, 0xc8 );
    FCML_I3264( "bswap ecx", 0x0f, 0xc9 );
    FCML_I3264( "bswap edx", 0x0f, 0xca );
    FCML_I3264( "bswap ebx", 0x0f, 0xcb );
    FCML_I3264( "bswap esp", 0x0f, 0xcc );
    FCML_I3264( "bswap ebp", 0x0f, 0xcd );
    FCML_I3264( "bswap esi", 0x0f, 0xce );
    FCML_I3264( "bswap edi", 0x0f, 0xcf );

    FCML_I3264_D( "bswap eax", 0x66, 0x0f, 0xc8 );
    FCML_A32_A( "bswap %eax", 0x0f, 0xc8 );
    FCML_I3264_D( "bswap ecx", 0x66, 0x0f, 0xc9 );
    FCML_I3264_D( "bswap edx", 0x66, 0x0f, 0xca );
    FCML_I3264_D( "bswap ebx", 0x66, 0x0f, 0xcb );
    FCML_I3264_D( "bswap esp", 0x66, 0x0f, 0xcc );
    FCML_I3264_D( "bswap ebp", 0x66, 0x0f, 0xcd );
    FCML_I3264_D( "bswap esi", 0x66, 0x0f, 0xce );
    FCML_I3264_D( "bswap edi", 0x66, 0x0f, 0xcf );

    FCML_I64( "bswap r8", 0x49, 0x0f, 0xc8 );
    FCML_A64( "bswap %r8", 0x49, 0x0f, 0xc8 );
    FCML_I64( "bswap r9", 0x49, 0x0f, 0xc9 );
    FCML_I64( "bswap r10", 0x49, 0x0f, 0xca );
    FCML_I64( "bswap r11", 0x49, 0x0f, 0xcb );
    FCML_I64( "bswap r12", 0x49, 0x0f, 0xcc );
    FCML_I64( "bswap r13", 0x49, 0x0f, 0xcd );
    FCML_I64( "bswap r14", 0x49, 0x0f, 0xce );
    FCML_I64( "bswap r15", 0x49, 0x0f, 0xcf );
}

void fcml_tf_instruction_BT(void) {

    FCML_I32( "bt dword ptr [esi],eax", 0x0F, 0xA3, 0x06 );
    FCML_A32( "bt %eax,(%esi)", 0x0F, 0xA3, 0x06 );
    FCML_I32( "bt word ptr [esi],ax", 0x66, 0x0F, 0xA3, 0x06 );
    FCML_I32( "bt dword ptr [0201h],eax", 0x67, 0x0F, 0xA3, 0x06, 0x01, 0x02 );
    FCML_A32( "bt %eax,0x0201", 0x67, 0x0F, 0xA3, 0x06, 0x01, 0x02 );

    FCML_I64( "bt dword ptr [rdi+0000000004030201h],05h", 0x0F, 0xBA, 0xA7, 0x01, 0x02, 0x03, 0x4, 0x05 );
    FCML_A64( "btl $0x05,0x0000000004030201(%rdi)", 0x0F, 0xBA, 0xA7, 0x01, 0x02, 0x03, 0x4, 0x05 );
    /* Memory data size has to be set. Default size is not supported (and probably won't be) like it is in GAS.
     */
    FCML_A64_A_FAILED( "bt $0x05,0x0000000004030201(%rdi)", 0x0F, 0xBA, 0xA7, 0x01, 0x02, 0x03, 0x4, 0x05 );

    FCML_I64( "bt dword ptr [edi+04030201h],05h", 0x67, 0x0F, 0xBA, 0xA7, 0x01, 0x02, 0x03, 0x4, 0x05 );
    FCML_I32( "bt dword ptr [edi+04030201h],05h", 0x0f, 0xba, 0xa7, 0x01, 0x02, 0x03, 0x04, 0x05 );

    FCML_I64( "bt qword ptr [rdi+0000000004030201h],05h", 0x48, 0x0F, 0xBA, 0xA7, 0x01, 0x02, 0x03, 0x4, 0x05 );

    FCML_I64( "bt qword ptr [rdi+0000000004030201h],0ffh", 0x48, 0x0F, 0xBA, 0xA7, 0x01, 0x02, 0x03, 0x4, 0xff );
}

void fcml_tf_instruction_BTC(void) {

    FCML_I32( "btc dword ptr [esi],eax", 0x0F, 0xBB, 0x06 );
    FCML_A32( "btc %eax,(%esi)", 0x0F, 0xBB, 0x06 );
    FCML_I32( "btc eax,eax", 0x0F, 0xBB, 0xC0 );
    FCML_I32_A_FAILED( "lock btc eax,eax", 0xF0, 0x0F, 0xBB, 0xC0 );
    /* Such addressing mode is supported but only by disassembler, assembler doesn't allow it.
     */
    FCML_I32_D( "lock btc eax,eax", 0xF0, 0x0F, 0xBB, 0xC0 );
    FCML_I32( "lock btc dword ptr [esi],eax", 0xF0, 0x0F, 0xBB, 0x06 );
    FCML_I32( "xacquire lock btc dword ptr [esi],eax", 0xF2, 0xF0, 0x0F, 0xBB, 0x06 );
    FCML_I32( "xrelease lock btc dword ptr [esi],eax", 0xF3, 0xF0, 0x0F, 0xBB, 0x06 );
    FCML_I32( "btc word ptr [esi],ax", 0x66, 0x0F, 0xBB, 0x06 );
    FCML_I32( "btc dword ptr [0201h],eax", 0x67, 0x0F, 0xBB, 0x06, 0x01, 0x02 );

    FCML_I64( "btc dword ptr [rdi+0000000004030201h],05h", 0x0F, 0xBA, 0xBF, 0x01, 0x02, 0x03, 0x4, 0x05 );
    FCML_A64( "btcl $0x05,0x0000000004030201(%rdi)", 0x0F, 0xBA, 0xBF, 0x01, 0x02, 0x03, 0x4, 0x05 );

    FCML_I64( "btc dword ptr [edi+04030201h],05h", 0x67, 0x0F, 0xBA, 0xBF, 0x01, 0x02, 0x03, 0x4, 0x05 );

    FCML_I64( "btc qword ptr [rdi+0000000004030201h],05h", 0x48, 0x0F, 0xBA, 0xBF, 0x01, 0x02, 0x03, 0x4, 0x05 );

    FCML_I64( "btc qword ptr [rdi+0000000004030201h],0ffh", 0x48, 0x0F, 0xBA, 0xBF, 0x01, 0x02, 0x03, 0x4, 0xff );
    FCML_I64( "lock btc qword ptr [rdi+0000000004030201h],0ffh", 0xF0, 0x48, 0x0F, 0xBA, 0xBF, 0x01, 0x02, 0x03, 0x4, 0xff );
    FCML_I64( "xacquire lock btc qword ptr [rdi+0000000004030201h],0ffh", 0xF2, 0xF0, 0x48, 0x0F, 0xBA, 0xBF, 0x01, 0x02, 0x03, 0x4, 0xff );
    FCML_I64( "xrelease lock btc qword ptr [rdi+0000000004030201h],0ffh", 0xF3, 0xF0, 0x48, 0x0F, 0xBA, 0xBF, 0x01, 0x02, 0x03, 0x4, 0xff );
}

void fcml_tf_instruction_BTR(void) {

    FCML_I32( "btr dword ptr [esi],eax", 0x0F, 0xB3, 0x06 );
    FCML_I32( "lock btr dword ptr [esi],eax", 0xF0, 0x0F, 0xB3, 0x06 );
    FCML_I32( "xacquire lock btr dword ptr [esi],eax", 0xF2, 0xF0, 0x0F, 0xB3, 0x06 );
    FCML_I32( "xrelease lock btr dword ptr [esi],eax", 0xF3, 0xF0, 0x0F, 0xB3, 0x06 );
    FCML_I32( "btr word ptr [esi],ax", 0x66, 0x0F, 0xB3, 0x06 );
    FCML_A32( "btr %ax,(%esi)", 0x66, 0x0F, 0xB3, 0x06 );
    FCML_I32( "btr dword ptr [0201h],eax", 0x67, 0x0F, 0xB3, 0x06, 0x01, 0x02 );
    FCML_I32_A( "btr [00000201h],eax", 0x0F, 0xB3, 0x05, 0x01, 0x02, 0x00, 0x00 );

    FCML_I64( "btr dword ptr [rdi+0000000004030201h],05h", 0x0F, 0xBA, 0xB7, 0x01, 0x02, 0x03, 0x4, 0x05 );
    FCML_A64( "btrl $0x05,0x0000000004030201(%rdi)", 0x0F, 0xBA, 0xB7, 0x01, 0x02, 0x03, 0x4, 0x05 );
    FCML_A64( "btrq $0x05,0x0000000004030201(%rdi)", 0x48, 0x0f, 0xba, 0xb7, 0x01, 0x02, 0x03, 0x04, 0x05 );
    FCML_A64( "btrw $0x05,0x0000000004030201(%rdi)", 0x66, 0x0f, 0xba, 0xb7, 0x01, 0x02, 0x03, 0x04, 0x05 );

    FCML_I64( "btr dword ptr [edi+04030201h],05h", 0x67, 0x0F, 0xBA, 0xB7, 0x01, 0x02, 0x03, 0x4, 0x05 );

    FCML_I64( "btr qword ptr [rdi+0000000004030201h],05h", 0x48, 0x0F, 0xBA, 0xB7, 0x01, 0x02, 0x03, 0x4, 0x05 );

    FCML_I64( "btr qword ptr [rdi+0000000004030201h],0ffh", 0x48, 0x0F, 0xBA, 0xB7, 0x01, 0x02, 0x03, 0x4, 0xff );
    FCML_I64( "lock btr qword ptr [rdi+0000000004030201h],0ffh", 0xF0, 0x48, 0x0F, 0xBA, 0xB7, 0x01, 0x02, 0x03, 0x4, 0xff );
    FCML_I64( "xacquire lock btr qword ptr [rdi+0000000004030201h],0ffh", 0xF2, 0xF0, 0x48, 0x0F, 0xBA, 0xB7, 0x01, 0x02, 0x03, 0x4, 0xff );
    FCML_I64( "xrelease lock btr qword ptr [rdi+0000000004030201h],0ffh", 0xF3, 0xF0, 0x48, 0x0F, 0xBA, 0xB7, 0x01, 0x02, 0x03, 0x4, 0xff );
}

void fcml_tf_instruction_BTS(void) {

    FCML_I32( "bts dword ptr [esi],eax", 0x0F, 0xAB, 0x06 );
    FCML_I32( "bts word ptr [esi],ax", 0x66, 0x0F, 0xAB, 0x06 );
    FCML_I32( "bts dword ptr [0201h],eax", 0x67, 0x0F, 0xAB, 0x06, 0x01, 0x02 );
    FCML_A32( "bts %eax,0x0201", 0x67, 0x0F, 0xAB, 0x06, 0x01, 0x02 );
    FCML_I32( "lock bts dword ptr [0201h],eax", 0xF0, 0x67, 0x0F, 0xAB, 0x06, 0x01, 0x02 );
    FCML_I32( "xacquire lock bts dword ptr [0201h],eax", 0xF2, 0xF0, 0x67, 0x0F, 0xAB, 0x06, 0x01, 0x02 );
    FCML_I32( "xrelease lock bts dword ptr [0201h],eax", 0xF3, 0xF0, 0x67, 0x0F, 0xAB, 0x06, 0x01, 0x02 );

    FCML_I64( "bts dword ptr [rdi+0000000004030201h],05h", 0x0F, 0xBA, 0xAF, 0x01, 0x02, 0x03, 0x4, 0x05 );

    FCML_I64( "bts dword ptr [edi+04030201h],05h", 0x67, 0x0F, 0xBA, 0xAF, 0x01, 0x02, 0x03, 0x4, 0x05 );
    FCML_A64( "btsl $0x05,0x04030201(%edi)", 0x67, 0x0F, 0xBA, 0xAF, 0x01, 0x02, 0x03, 0x4, 0x05 );

    FCML_I64( "bts qword ptr [rdi+0000000004030201h],05h", 0x48, 0x0F, 0xBA, 0xAF, 0x01, 0x02, 0x03, 0x4, 0x05 );

    FCML_I64( "lock bts qword ptr [rdi+0000000004030201h],0ffh", 0xF0, 0x48, 0x0F, 0xBA, 0xAF, 0x01, 0x02, 0x03, 0x4, 0xff );
    FCML_I64( "xacquire lock bts qword ptr [rdi+0000000004030201h],0ffh", 0xF2, 0xF0, 0x48, 0x0F, 0xBA, 0xAF, 0x01, 0x02, 0x03, 0x4, 0xff );
    FCML_I64( "xrelease lock bts qword ptr [rdi+0000000004030201h],0ffh", 0xF3, 0xF0, 0x48, 0x0F, 0xBA, 0xAF, 0x01, 0x02, 0x03, 0x4, 0xff );
}

void fcml_tf_instruction_BEXR(void) {

    FCML_I32( "bexr eax,dword ptr [eax],edi", 0xC4, 0xE2, 0x40, 0xF7, 0x00 );
    FCML_I32( "bexr eax,eax,edi", 0xC4, 0xE2, 0x40, 0xF7, 0xC0 );

    FCML_I64( "bexr rax,qword ptr [rax],rdi", 0xC4, 0xE2, 0xC0, 0xF7, 0x00 );
    FCML_I64( "bexr rax,rax,rdi", 0xC4, 0xE2, 0xC0, 0xF7, 0xC0 );
}

void fcml_tf_instruction_BEXTR(void) {

    FCML_I32( "bextr eax,dword ptr [eax],04030201h", 0x8F, 0xEA, 0x78, 0x10, 0x00, 0x01, 0x02, 0x03, 0x04 );
    FCML_A64( "bextr $0x04030201,(%rax),%eax", 0x8F, 0xEA, 0x78, 0x10, 0x00, 0x01, 0x02, 0x03, 0x04 );
    FCML_I32( "bextr eax,eax,04030201h", 0x8F, 0xEA, 0x78, 0x10, 0xC0, 0x01, 0x02, 0x03, 0x04 );

    FCML_I64( "bextr rax,qword ptr [rax],04030201h", 0x8F, 0xEA, 0xF8, 0x10, 0x00, 0x01, 0x02, 0x03, 0x04 );
    FCML_A64( "bextr $0x04030201,(%rax),%rax", 0x8F, 0xEA, 0xF8, 0x10, 0x00, 0x01, 0x02, 0x03, 0x04 );
    FCML_I64( "bextr rax,rax,04030201h", 0x8F, 0xEA, 0xF8, 0x10, 0xC0, 0x01, 0x02, 0x03, 0x04 );

    FCML_A64( "bextr $0x04030201,(%rax),%eax", 0x8f, 0xea, 0x78, 0x10, 0x00, 0x01, 0x02, 0x03, 0x04 );
    FCML_A64( "bextr $0x04030201,(%rax),%eax", 0x8f, 0xea, 0x78, 0x10, 0x00, 0x01, 0x02, 0x03, 0x04 );
    FCML_A64( "bextr $0x04030201,%eax,%eax", 0x8f, 0xea, 0x78, 0x10, 0xc0, 0x01, 0x02, 0x03, 0x04 );
    FCML_A64( "bextr $0x04030201,(%rax),%rax", 0x8f, 0xea, 0xf8, 0x10, 0x00, 0x01, 0x02, 0x03, 0x04 );
    FCML_A64( "bextr $0x04030201,(%rax),%rax", 0x8f, 0xea, 0xf8, 0x10, 0x00, 0x01, 0x02, 0x03, 0x04 );
    FCML_A64( "bextr $0x04030201,%rax,%rax", 0x8f, 0xea, 0xf8, 0x10, 0xc0, 0x01, 0x02, 0x03, 0x04 );
}

void fcml_tf_instruction_BLCFILL(void) {

    FCML_I32( "blcfill ebx,dword ptr [eax]", 0x8F, 0xE9, 0x60, 0x01, 0x08 );
    FCML_A32( "blcfill (%eax),%ebx", 0x8F, 0xE9, 0x60, 0x01, 0x08 );
    FCML_I32( "blcfill ebx,eax", 0x8F, 0xE9, 0x60, 0x01, 0xC8 );

    FCML_I64( "blcfill rbx,qword ptr [rax]", 0x8F, 0xE9, 0xE0, 0x01, 0x08 );
    FCML_A64( "blcfill (%rax),%rbx", 0x8F, 0xE9, 0xE0, 0x01, 0x08 );
    FCML_I64( "blcfill rbx,rax", 0x8F, 0xE9, 0xE0, 0x01, 0xC8 );
}

void fcml_tf_instruction_BLCI(void) {

    FCML_I32( "blci ebx,dword ptr [eax]", 0x8F, 0xE9, 0x60, 0x02, 0x30 );
    FCML_A64( "blci (%rax),%ebx", 0x8F, 0xE9, 0x60, 0x02, 0x30 );
    FCML_I32( "blci ebx,eax", 0x8F, 0xE9, 0x60, 0x02, 0xF0 );

    FCML_I64( "blci rbx,qword ptr [rax]", 0x8F, 0xE9, 0xE0, 0x02, 0x30 );
    FCML_A64( "blci (%rax),%rbx", 0x8F, 0xE9, 0xE0, 0x02, 0x30 );
    FCML_I64( "blci rbx,rax", 0x8F, 0xE9, 0xE0, 0x02, 0xF0 );
}

void fcml_tf_instruction_BLCIC(void) {

    FCML_I32( "blcic ebx,dword ptr [eax]", 0x8F, 0xE9, 0x60, 0x01, 0x28 );
    FCML_A64( "blcic (%rax),%ebx", 0x8F, 0xE9, 0x60, 0x01, 0x28 );
    FCML_I32( "blcic ebx,eax", 0x8F, 0xE9, 0x60, 0x01, 0xE8 );

    FCML_I64( "blcic rbx,qword ptr [rax]", 0x8F, 0xE9, 0xE0, 0x01, 0x28 );
    FCML_I64( "blcic rbx,rax", 0x8F, 0xE9, 0xE0, 0x01, 0xE8 );
    FCML_A64( "blcic %rax,%rbx", 0x8F, 0xE9, 0xE0, 0x01, 0xE8 );
}

void fcml_tf_instruction_BLCMSK(void) {

    FCML_I32( "blcmsk ebx,dword ptr [eax]", 0x8F, 0xE9, 0x60, 0x02, 0x08 );
    FCML_A64( "blcmsk (%rax),%ebx", 0x8F, 0xE9, 0x60, 0x02, 0x08 );
    FCML_I32( "blcmsk ebx,eax", 0x8F, 0xE9, 0x60, 0x02, 0xC8 );

    FCML_I64( "blcmsk rbx,qword ptr [rax]", 0x8F, 0xE9, 0xE0, 0x02, 0x08 );
    FCML_A64( "blcmsk (%rax),%rbx", 0x8F, 0xE9, 0xE0, 0x02, 0x08 );
    FCML_I64( "blcmsk rbx,rax", 0x8F, 0xE9, 0xE0, 0x02, 0xC8 );
}

void fcml_tf_instruction_BLCS(void) {

    FCML_I32( "blcs ebx,dword ptr [eax]", 0x8F, 0xE9, 0x60, 0x01, 0x18 );
    FCML_A64( "blcs (%rax),%ebx", 0x8F, 0xE9, 0x60, 0x01, 0x18 );
    FCML_I32( "blcs ebx,eax", 0x8F, 0xE9, 0x60, 0x01, 0xD8 );

    FCML_I64( "blcs rbx,qword ptr [rax]", 0x8F, 0xE9, 0xE0, 0x01, 0x18 );
    FCML_A64( "blcs (%rax),%rbx", 0x8F, 0xE9, 0xE0, 0x01, 0x18 );
    FCML_I64( "blcs rbx,rax", 0x8F, 0xE9, 0xE0, 0x01, 0xD8 );
}

void fcml_tf_instruction_BLSFILL(void) {

    FCML_I32( "blsfill ebx,dword ptr [eax]", 0x8F, 0xE9, 0x60, 0x01, 0x10 );
    FCML_A64( "blsfill (%rax),%ebx", 0x8F, 0xE9, 0x60, 0x01, 0x10 );
    FCML_I32( "blsfill ebx,eax", 0x8F, 0xE9, 0x60, 0x01, 0xD0 );

    FCML_I64( "blsfill rbx,qword ptr [rax]", 0x8F, 0xE9, 0xE0, 0x01, 0x10 );
    FCML_I64( "blsfill rbx,rax", 0x8F, 0xE9, 0xE0, 0x01, 0xD0 );
    FCML_A64( "blsfill %rax,%rbx", 0x8F, 0xE9, 0xE0, 0x01, 0xD0 );
}

void fcml_tf_instruction_BLSI(void) {

    FCML_I32( "blsi edi,dword ptr [eax]", 0xC4, 0xE2, 0x40, 0xF3, 0x18 );
    FCML_A64( "blsi (%rax),%edi", 0xC4, 0xE2, 0x40, 0xF3, 0x18 );
    FCML_I32( "blsi edi,eax", 0xC4, 0xE2, 0x40, 0xF3, 0xD8 );

    FCML_I64( "blsi rdi,qword ptr [rax]", 0xC4, 0xE2, 0xC0, 0xF3, 0x18 );
    FCML_A64( "blsi (%rax),%rdi", 0xC4, 0xE2, 0xC0, 0xF3, 0x18 );
    FCML_I64( "blsi rdi,rax", 0xC4, 0xE2, 0xC0, 0xF3, 0xD8 );
}

void fcml_tf_instruction_BLSIC(void) {

    FCML_I32( "blsic ebx,dword ptr [eax]", 0x8F, 0xE9, 0x60, 0x01, 0x30 );
    FCML_A64( "blsic (%rax),%ebx", 0x8F, 0xE9, 0x60, 0x01, 0x30 );
    FCML_I32( "blsic ebx,eax", 0x8F, 0xE9, 0x60, 0x01, 0xF0 );

    FCML_I64( "blsic rbx,qword ptr [rax]", 0x8F, 0xE9, 0xE0, 0x01, 0x30 );
    FCML_I64( "blsic rbx,rax", 0x8F, 0xE9, 0xE0, 0x01, 0xF0 );
    FCML_A64( "blsic %rax,%rbx", 0x8F, 0xE9, 0xE0, 0x01, 0xF0 );
}

void fcml_tf_instruction_BLSMSK(void) {

    FCML_I32( "blsmsk edi,dword ptr [eax]", 0xC4, 0xE2, 0x40, 0xF3, 0x10 );
    FCML_A64( "blsmsk (%rax),%edi", 0xC4, 0xE2, 0x40, 0xF3, 0x10 );
    FCML_I32( "blsmsk edi,eax", 0xC4, 0xE2, 0x40, 0xF3, 0xD0 );

    FCML_I64( "blsmsk rdi,qword ptr [rax]", 0xC4, 0xE2, 0xC0, 0xF3, 0x10 );
    FCML_I64( "blsmsk rdi,rax", 0xC4, 0xE2, 0xC0, 0xF3, 0xD0 );
    FCML_A64( "blsmsk %rax,%rdi", 0xC4, 0xE2, 0xC0, 0xF3, 0xD0 );
}

void fcml_tf_instruction_BLSR(void) {

    FCML_I32( "blsr edi,dword ptr [eax]", 0xC4, 0xE2, 0x40, 0xF3, 0x08 );
    FCML_A64( "blsr (%rax),%edi", 0xC4, 0xE2, 0x40, 0xF3, 0x08 );
    FCML_I32( "blsr edi,eax", 0xC4, 0xE2, 0x40, 0xF3, 0xC8 );

    FCML_I64( "blsr rdi,qword ptr [rax]", 0xC4, 0xE2, 0xC0, 0xF3, 0x08 );
    FCML_I64( "blsr rdi,rax", 0xC4, 0xE2, 0xC0, 0xF3, 0xC8 );
    FCML_A64( "blsr %rax,%rdi", 0xC4, 0xE2, 0xC0, 0xF3, 0xC8 );
}

void fcml_tf_instruction_BZHI(void) {

    FCML_I32( "bzhi eax,dword ptr [eax],edi", 0xC4, 0xE2, 0x40, 0xF5, 0x00 );
    FCML_A64( "bzhi %edi,(%rax),%eax", 0xC4, 0xE2, 0x40, 0xF5, 0x00 );
    FCML_I32( "bzhi eax,eax,edi", 0xC4, 0xE2, 0x40, 0xF5, 0xC0 );

    FCML_I64( "bzhi rax,qword ptr [rax],rdi", 0xC4, 0xE2, 0xC0, 0xF5, 0x00 );
    FCML_I64( "bzhi rax,rax,rdi", 0xC4, 0xE2, 0xC0, 0xF5, 0xC0 );
    FCML_A64( "bzhi %rdi,%rax,%rax", 0xC4, 0xE2, 0xC0, 0xF5, 0xC0 );
}

fcml_stf_test_case fctl_ti_instructions_b[] = {
    { "fcml_tf_instruction_BLENDPD_VBLENDPD", fcml_tf_instruction_BLENDPD_VBLENDPD },
    { "fcml_tf_instruction_BLENDPS_VBLENDPS", fcml_tf_instruction_BLENDPS_VBLENDPS },
    { "fcml_tf_instruction_BLENDVPD_VBLENDVPD", fcml_tf_instruction_BLENDVPD_VBLENDVPD },
    { "fcml_tf_instruction_BLENDVPS_VBLENDVPS", fcml_tf_instruction_BLENDVPS_VBLENDVPS },
    { "fcml_tf_instruction_BOUND", fcml_tf_instruction_BOUND },
    { "fcml_tf_instruction_BSF", fcml_tf_instruction_BSF },
    { "fcml_tf_instruction_BSR", fcml_tf_instruction_BSR },
    { "fcml_tf_instruction_BSWAP", fcml_tf_instruction_BSWAP },
    { "fcml_tf_instruction_BT", fcml_tf_instruction_BT },
    { "fcml_tf_instruction_BTC", fcml_tf_instruction_BTC },
    { "fcml_tf_instruction_BTR", fcml_tf_instruction_BTR },
    { "fcml_tf_instruction_BTS", fcml_tf_instruction_BTS },
    { "fcml_tf_instruction_BEXR", fcml_tf_instruction_BEXR },
    { "fcml_tf_instruction_BEXTR", fcml_tf_instruction_BEXTR },
    { "fcml_tf_instruction_BLCFILL", fcml_tf_instruction_BLCFILL },
    { "fcml_tf_instruction_BLCI", fcml_tf_instruction_BLCI },
    { "fcml_tf_instruction_BLCIC", fcml_tf_instruction_BLCIC },
    { "fcml_tf_instruction_BLCMSK", fcml_tf_instruction_BLCMSK },
    { "fcml_tf_instruction_BLCS", fcml_tf_instruction_BLCS },
    { "fcml_tf_instruction_BLSFILL", fcml_tf_instruction_BLSFILL },
    { "fcml_tf_instruction_BLSI", fcml_tf_instruction_BLSI },
    { "fcml_tf_instruction_BLSIC", fcml_tf_instruction_BLSIC },
    { "fcml_tf_instruction_BLSMSK", fcml_tf_instruction_BLSMSK },
    { "fcml_tf_instruction_BLSR", fcml_tf_instruction_BLSR },
    { "fcml_tf_instruction_BZHI", fcml_tf_instruction_BZHI },
    FCML_STF_NULL_TEST
};

fcml_stf_test_suite fctl_si_instructions_b = {
    "suite-fctl_ti_instructions_b", fcml_tf_instructions_b_suite_init, fcml_tf_instructions_b_suite_cleanup, fctl_ti_instructions_b,
};



