#
# colors.py -- color definitions
#
# Eric Jeschke (eric@naoj.org)
#
# Copyright (c) Eric R. Jeschke.  All rights reserved.
# This is open-source software licensed under a BSD license.
# Please see the file LICENSE.txt for details.
#

import re

color_dict = {
 'aliceblue': (0.9411764705882353, 0.9725490196078431, 1.0),  # noqa
 'antiquewhite': (0.9803921568627451, 0.9215686274509803, 0.8431372549019608),
 'antiquewhite1': (1.0, 0.9372549019607843, 0.8588235294117647),
 'antiquewhite2': (0.9333333333333333, 0.8745098039215686, 0.8),
 'antiquewhite3': (0.803921568627451, 0.7529411764705882, 0.6901960784313725),
 'antiquewhite4': (0.5450980392156862,
                   0.5137254901960784,
                   0.47058823529411764),
 'aquamarine': (0.4980392156862745, 1.0, 0.8313725490196079),
 'aquamarine1': (0.4980392156862745, 1.0, 0.8313725490196079),
 'aquamarine2': (0.4627450980392157, 0.9333333333333333, 0.7764705882352941),
 'aquamarine3': (0.4, 0.803921568627451, 0.6666666666666666),
 'aquamarine4': (0.27058823529411763, 0.5450980392156862, 0.4549019607843137),
 'azure': (0.9411764705882353, 1.0, 1.0),
 'azure1': (0.9411764705882353, 1.0, 1.0),
 'azure2': (0.8784313725490196, 0.9333333333333333, 0.9333333333333333),
 'azure3': (0.7568627450980392, 0.803921568627451, 0.803921568627451),
 'azure4': (0.5137254901960784, 0.5450980392156862, 0.5450980392156862),
 'beige': (0.9607843137254902, 0.9607843137254902, 0.8627450980392157),
 'bisque': (1.0, 0.8941176470588236, 0.7686274509803922),
 'bisque1': (1.0, 0.8941176470588236, 0.7686274509803922),
 'bisque2': (0.9333333333333333, 0.8352941176470589, 0.7176470588235294),
 'bisque3': (0.803921568627451, 0.7176470588235294, 0.6196078431372549),
 'bisque4': (0.5450980392156862, 0.49019607843137253, 0.4196078431372549),
 'black': (0.0, 0.0, 0.0),
 'blanchedalmond': (1.0, 0.9215686274509803, 0.803921568627451),
 'blue': (0.0, 0.0, 1.0),
 'blue1': (0.0, 0.0, 1.0),
 'blue2': (0.0, 0.0, 0.9333333333333333),
 'blue3': (0.0, 0.0, 0.803921568627451),
 'blue4': (0.0, 0.0, 0.5450980392156862),
 'blueviolet': (0.5411764705882353, 0.16862745098039217, 0.8862745098039215),
 'brown': (0.6470588235294118, 0.16470588235294117, 0.16470588235294117),
 'brown1': (1.0, 0.25098039215686274, 0.25098039215686274),
 'brown2': (0.9333333333333333, 0.23137254901960785, 0.23137254901960785),
 'brown3': (0.803921568627451, 0.2, 0.2),
 'brown4': (0.5450980392156862, 0.13725490196078433, 0.13725490196078433),
 'burlywood': (0.8705882352941177, 0.7215686274509804, 0.5294117647058824),
 'burlywood1': (1.0, 0.8274509803921568, 0.6078431372549019),
 'burlywood2': (0.9333333333333333, 0.7725490196078432, 0.5686274509803921),
 'burlywood3': (0.803921568627451, 0.6666666666666666, 0.49019607843137253),
 'burlywood4': (0.5450980392156862, 0.45098039215686275, 0.3333333333333333),
 'cadetblue': (0.37254901960784315, 0.6196078431372549, 0.6274509803921569),
 'cadetblue1': (0.596078431372549, 0.9607843137254902, 1.0),
 'cadetblue2': (0.5568627450980392, 0.8980392156862745, 0.9333333333333333),
 'cadetblue3': (0.47843137254901963, 0.7725490196078432, 0.803921568627451),
 'cadetblue4': (0.3254901960784314, 0.5254901960784314, 0.5450980392156862),
 'chartreuse': (0.4980392156862745, 1.0, 0.0),
 'chartreuse1': (0.4980392156862745, 1.0, 0.0),
 'chartreuse2': (0.4627450980392157, 0.9333333333333333, 0.0),
 'chartreuse3': (0.4, 0.803921568627451, 0.0),
 'chartreuse4': (0.27058823529411763, 0.5450980392156862, 0.0),
 'chocolate': (0.8235294117647058, 0.4117647058823529, 0.11764705882352941),
 'chocolate1': (1.0, 0.4980392156862745, 0.1411764705882353),
 'chocolate2': (0.9333333333333333, 0.4627450980392157, 0.12941176470588237),
 'chocolate3': (0.803921568627451, 0.4, 0.11372549019607843),
 'chocolate4': (0.5450980392156862, 0.27058823529411763, 0.07450980392156863),
 'coral': (1.0, 0.4980392156862745, 0.3137254901960784),
 'coral1': (1.0, 0.4470588235294118, 0.33725490196078434),
 'coral2': (0.9333333333333333, 0.41568627450980394, 0.3137254901960784),
 'coral3': (0.803921568627451, 0.3568627450980392, 0.27058823529411763),
 'coral4': (0.5450980392156862, 0.24313725490196078, 0.1843137254901961),
 'cornflowerblue': (0.39215686274509803,
                    0.5843137254901961,
                    0.9294117647058824),
 'cornsilk': (1.0, 0.9725490196078431, 0.8627450980392157),
 'cornsilk1': (1.0, 0.9725490196078431, 0.8627450980392157),
 'cornsilk2': (0.9333333333333333, 0.9098039215686274, 0.803921568627451),
 'cornsilk3': (0.803921568627451, 0.7843137254901961, 0.6941176470588235),
 'cornsilk4': (0.5450980392156862, 0.5333333333333333, 0.47058823529411764),
 'cyan': (0.0, 1.0, 1.0),
 'cyan1': (0.0, 1.0, 1.0),
 'cyan2': (0.0, 0.9333333333333333, 0.9333333333333333),
 'cyan3': (0.0, 0.803921568627451, 0.803921568627451),
 'cyan4': (0.0, 0.5450980392156862, 0.5450980392156862),
 'darkblue': (0.0, 0.0, 0.5450980392156862),
 'darkcyan': (0.0, 0.5450980392156862, 0.5450980392156862),
 'darkgoldenrod': (0.7215686274509804,
                   0.5254901960784314,
                   0.043137254901960784),
 'darkgoldenrod1': (1.0, 0.7254901960784313, 0.058823529411764705),
 'darkgoldenrod2': (0.9333333333333333,
                    0.6784313725490196,
                    0.054901960784313725),
 'darkgoldenrod3': (0.803921568627451,
                    0.5843137254901961,
                    0.047058823529411764),
 'darkgoldenrod4': (0.5450980392156862,
                    0.396078431372549,
                    0.03137254901960784),
 'darkgray': (0.6627450980392157, 0.6627450980392157, 0.6627450980392157),
 'darkgreen': (0.0, 0.39215686274509803, 0.0),
 'darkgrey': (0.6627450980392157, 0.6627450980392157, 0.6627450980392157),
 'darkkhaki': (0.7411764705882353, 0.7176470588235294, 0.4196078431372549),
 'darkmagenta': (0.5450980392156862, 0.0, 0.5450980392156862),
 'darkolivegreen': (0.3333333333333333,
                    0.4196078431372549,
                    0.1843137254901961),
 'darkolivegreen1': (0.792156862745098, 1.0, 0.4392156862745098),
 'darkolivegreen2': (0.7372549019607844,
                     0.9333333333333333,
                     0.40784313725490196),
 'darkolivegreen3': (0.6352941176470588,
                     0.803921568627451,
                     0.35294117647058826),
 'darkolivegreen4': (0.43137254901960786,
                     0.5450980392156862,
                     0.23921568627450981),
 'darkorange': (1.0, 0.5490196078431373, 0.0),
 'darkorange1': (1.0, 0.4980392156862745, 0.0),
 'darkorange2': (0.9333333333333333, 0.4627450980392157, 0.0),
 'darkorange3': (0.803921568627451, 0.4, 0.0),
 'darkorange4': (0.5450980392156862, 0.27058823529411763, 0.0),
 'darkorchid': (0.6, 0.19607843137254902, 0.8),
 'darkorchid1': (0.7490196078431373, 0.24313725490196078, 1.0),
 'darkorchid2': (0.6980392156862745, 0.22745098039215686, 0.9333333333333333),
 'darkorchid3': (0.6039215686274509, 0.19607843137254902, 0.803921568627451),
 'darkorchid4': (0.40784313725490196, 0.13333333333333333, 0.5450980392156862),
 'darkred': (0.5450980392156862, 0.0, 0.0),
 'darksalmon': (0.9137254901960784, 0.5882352941176471, 0.47843137254901963),
 'darkseagreen': (0.5607843137254902, 0.7372549019607844, 0.5607843137254902),
 'darkseagreen1': (0.7568627450980392, 1.0, 0.7568627450980392),
 'darkseagreen2': (0.7058823529411765, 0.9333333333333333, 0.7058823529411765),
 'darkseagreen3': (0.6078431372549019, 0.803921568627451, 0.6078431372549019),
 'darkseagreen4': (0.4117647058823529, 0.5450980392156862, 0.4117647058823529),
 'darkslateblue': (0.2823529411764706,
                   0.23921568627450981,
                   0.5450980392156862),
 'darkslategray': (0.1843137254901961,
                   0.30980392156862746,
                   0.30980392156862746),
 'darkslategray1': (0.592156862745098, 1.0, 1.0),
 'darkslategray2': (0.5529411764705883,
                    0.9333333333333333,
                    0.9333333333333333),
 'darkslategray3': (0.4745098039215686, 0.803921568627451, 0.803921568627451),
 'darkslategray4': (0.3215686274509804,
                    0.5450980392156862,
                    0.5450980392156862),
 'darkslategrey': (0.1843137254901961,
                   0.30980392156862746,
                   0.30980392156862746),
 'darkturquoise': (0.0, 0.807843137254902, 0.8196078431372549),
 'darkviolet': (0.5803921568627451, 0.0, 0.8274509803921568),
 'debianred': (0.8431372549019608, 0.027450980392156862, 0.3176470588235294),
 'deeppink': (1.0, 0.0784313725490196, 0.5764705882352941),
 'deeppink1': (1.0, 0.0784313725490196, 0.5764705882352941),
 'deeppink2': (0.9333333333333333, 0.07058823529411765, 0.5372549019607843),
 'deeppink3': (0.803921568627451, 0.06274509803921569, 0.4627450980392157),
 'deeppink4': (0.5450980392156862, 0.0392156862745098, 0.3137254901960784),
 'deepskyblue': (0.0, 0.7490196078431373, 1.0),
 'deepskyblue1': (0.0, 0.7490196078431373, 1.0),
 'deepskyblue2': (0.0, 0.6980392156862745, 0.9333333333333333),
 'deepskyblue3': (0.0, 0.6039215686274509, 0.803921568627451),
 'deepskyblue4': (0.0, 0.40784313725490196, 0.5450980392156862),
 'dimgray': (0.4117647058823529, 0.4117647058823529, 0.4117647058823529),
 'dimgrey': (0.4117647058823529, 0.4117647058823529, 0.4117647058823529),
 'dodgerblue': (0.11764705882352941, 0.5647058823529412, 1.0),
 'dodgerblue1': (0.11764705882352941, 0.5647058823529412, 1.0),
 'dodgerblue2': (0.10980392156862745, 0.5254901960784314, 0.9333333333333333),
 'dodgerblue3': (0.09411764705882353, 0.4549019607843137, 0.803921568627451),
 'dodgerblue4': (0.06274509803921569, 0.3058823529411765, 0.5450980392156862),
 'firebrick': (0.6980392156862745, 0.13333333333333333, 0.13333333333333333),
 'firebrick1': (1.0, 0.18823529411764706, 0.18823529411764706),
 'firebrick2': (0.9333333333333333, 0.17254901960784313, 0.17254901960784313),
 'firebrick3': (0.803921568627451, 0.14901960784313725, 0.14901960784313725),
 'firebrick4': (0.5450980392156862, 0.10196078431372549, 0.10196078431372549),
 'floralwhite': (1.0, 0.9803921568627451, 0.9411764705882353),
 'forestgreen': (0.13333333333333333, 0.5450980392156862, 0.13333333333333333),
 'gainsboro': (0.8627450980392157, 0.8627450980392157, 0.8627450980392157),
 'ghostwhite': (0.9725490196078431, 0.9725490196078431, 1.0),
 'gold': (1.0, 0.8431372549019608, 0.0),
 'gold1': (1.0, 0.8431372549019608, 0.0),
 'gold2': (0.9333333333333333, 0.788235294117647, 0.0),
 'gold3': (0.803921568627451, 0.6784313725490196, 0.0),
 'gold4': (0.5450980392156862, 0.4588235294117647, 0.0),
 'goldenrod': (0.8549019607843137, 0.6470588235294118, 0.12549019607843137),
 'goldenrod1': (1.0, 0.7568627450980392, 0.1450980392156863),
 'goldenrod2': (0.9333333333333333, 0.7058823529411765, 0.13333333333333333),
 'goldenrod3': (0.803921568627451, 0.6078431372549019, 0.11372549019607843),
 'goldenrod4': (0.5450980392156862, 0.4117647058823529, 0.0784313725490196),
 'gray': (0.7450980392156863, 0.7450980392156863, 0.7450980392156863),
 'gray0': (0.0, 0.0, 0.0),
 'gray1': (0.011764705882352941, 0.011764705882352941, 0.011764705882352941),
 'gray10': (0.10196078431372549, 0.10196078431372549, 0.10196078431372549),
 'gray100': (1.0, 1.0, 1.0),
 'gray11': (0.10980392156862745, 0.10980392156862745, 0.10980392156862745),
 'gray12': (0.12156862745098039, 0.12156862745098039, 0.12156862745098039),
 'gray13': (0.12941176470588237, 0.12941176470588237, 0.12941176470588237),
 'gray14': (0.1411764705882353, 0.1411764705882353, 0.1411764705882353),
 'gray15': (0.14901960784313725, 0.14901960784313725, 0.14901960784313725),
 'gray16': (0.1607843137254902, 0.1607843137254902, 0.1607843137254902),
 'gray17': (0.16862745098039217, 0.16862745098039217, 0.16862745098039217),
 'gray18': (0.1803921568627451, 0.1803921568627451, 0.1803921568627451),
 'gray19': (0.18823529411764706, 0.18823529411764706, 0.18823529411764706),
 'gray2': (0.0196078431372549, 0.0196078431372549, 0.0196078431372549),
 'gray20': (0.2, 0.2, 0.2),
 'gray21': (0.21176470588235294, 0.21176470588235294, 0.21176470588235294),
 'gray22': (0.2196078431372549, 0.2196078431372549, 0.2196078431372549),
 'gray23': (0.23137254901960785, 0.23137254901960785, 0.23137254901960785),
 'gray24': (0.23921568627450981, 0.23921568627450981, 0.23921568627450981),
 'gray25': (0.25098039215686274, 0.25098039215686274, 0.25098039215686274),
 'gray26': (0.25882352941176473, 0.25882352941176473, 0.25882352941176473),
 'gray27': (0.27058823529411763, 0.27058823529411763, 0.27058823529411763),
 'gray28': (0.2784313725490196, 0.2784313725490196, 0.2784313725490196),
 'gray29': (0.2901960784313726, 0.2901960784313726, 0.2901960784313726),
 'gray3': (0.03137254901960784, 0.03137254901960784, 0.03137254901960784),
 'gray30': (0.30196078431372547, 0.30196078431372547, 0.30196078431372547),
 'gray31': (0.30980392156862746, 0.30980392156862746, 0.30980392156862746),
 'gray32': (0.3215686274509804, 0.3215686274509804, 0.3215686274509804),
 'gray33': (0.32941176470588235, 0.32941176470588235, 0.32941176470588235),
 'gray34': (0.3411764705882353, 0.3411764705882353, 0.3411764705882353),
 'gray35': (0.34901960784313724, 0.34901960784313724, 0.34901960784313724),
 'gray36': (0.3607843137254902, 0.3607843137254902, 0.3607843137254902),
 'gray37': (0.3686274509803922, 0.3686274509803922, 0.3686274509803922),
 'gray38': (0.3803921568627451, 0.3803921568627451, 0.3803921568627451),
 'gray39': (0.38823529411764707, 0.38823529411764707, 0.38823529411764707),
 'gray4': (0.0392156862745098, 0.0392156862745098, 0.0392156862745098),
 'gray40': (0.4, 0.4, 0.4),
 'gray41': (0.4117647058823529, 0.4117647058823529, 0.4117647058823529),
 'gray42': (0.4196078431372549, 0.4196078431372549, 0.4196078431372549),
 'gray43': (0.43137254901960786, 0.43137254901960786, 0.43137254901960786),
 'gray44': (0.4392156862745098, 0.4392156862745098, 0.4392156862745098),
 'gray45': (0.45098039215686275, 0.45098039215686275, 0.45098039215686275),
 'gray46': (0.4588235294117647, 0.4588235294117647, 0.4588235294117647),
 'gray47': (0.47058823529411764, 0.47058823529411764, 0.47058823529411764),
 'gray48': (0.47843137254901963, 0.47843137254901963, 0.47843137254901963),
 'gray49': (0.49019607843137253, 0.49019607843137253, 0.49019607843137253),
 'gray5': (0.050980392156862744, 0.050980392156862744, 0.050980392156862744),
 'gray50': (0.4980392156862745, 0.4980392156862745, 0.4980392156862745),
 'gray51': (0.5098039215686274, 0.5098039215686274, 0.5098039215686274),
 'gray52': (0.5215686274509804, 0.5215686274509804, 0.5215686274509804),
 'gray53': (0.5294117647058824, 0.5294117647058824, 0.5294117647058824),
 'gray54': (0.5411764705882353, 0.5411764705882353, 0.5411764705882353),
 'gray55': (0.5490196078431373, 0.5490196078431373, 0.5490196078431373),
 'gray56': (0.5607843137254902, 0.5607843137254902, 0.5607843137254902),
 'gray57': (0.5686274509803921, 0.5686274509803921, 0.5686274509803921),
 'gray58': (0.5803921568627451, 0.5803921568627451, 0.5803921568627451),
 'gray59': (0.5882352941176471, 0.5882352941176471, 0.5882352941176471),
 'gray6': (0.058823529411764705, 0.058823529411764705, 0.058823529411764705),
 'gray60': (0.6, 0.6, 0.6),
 'gray61': (0.611764705882353, 0.611764705882353, 0.611764705882353),
 'gray62': (0.6196078431372549, 0.6196078431372549, 0.6196078431372549),
 'gray63': (0.6313725490196078, 0.6313725490196078, 0.6313725490196078),
 'gray64': (0.6392156862745098, 0.6392156862745098, 0.6392156862745098),
 'gray65': (0.6509803921568628, 0.6509803921568628, 0.6509803921568628),
 'gray66': (0.6588235294117647, 0.6588235294117647, 0.6588235294117647),
 'gray67': (0.6705882352941176, 0.6705882352941176, 0.6705882352941176),
 'gray68': (0.6784313725490196, 0.6784313725490196, 0.6784313725490196),
 'gray69': (0.6901960784313725, 0.6901960784313725, 0.6901960784313725),
 'gray7': (0.07058823529411765, 0.07058823529411765, 0.07058823529411765),
 'gray70': (0.7019607843137254, 0.7019607843137254, 0.7019607843137254),
 'gray71': (0.7098039215686275, 0.7098039215686275, 0.7098039215686275),
 'gray72': (0.7215686274509804, 0.7215686274509804, 0.7215686274509804),
 'gray73': (0.7294117647058823, 0.7294117647058823, 0.7294117647058823),
 'gray74': (0.7411764705882353, 0.7411764705882353, 0.7411764705882353),
 'gray75': (0.7490196078431373, 0.7490196078431373, 0.7490196078431373),
 'gray76': (0.7607843137254902, 0.7607843137254902, 0.7607843137254902),
 'gray77': (0.7686274509803922, 0.7686274509803922, 0.7686274509803922),
 'gray78': (0.7803921568627451, 0.7803921568627451, 0.7803921568627451),
 'gray79': (0.788235294117647, 0.788235294117647, 0.788235294117647),
 'gray8': (0.0784313725490196, 0.0784313725490196, 0.0784313725490196),
 'gray80': (0.8, 0.8, 0.8),
 'gray81': (0.8117647058823529, 0.8117647058823529, 0.8117647058823529),
 'gray82': (0.8196078431372549, 0.8196078431372549, 0.8196078431372549),
 'gray83': (0.8313725490196079, 0.8313725490196079, 0.8313725490196079),
 'gray84': (0.8392156862745098, 0.8392156862745098, 0.8392156862745098),
 'gray85': (0.8509803921568627, 0.8509803921568627, 0.8509803921568627),
 'gray86': (0.8588235294117647, 0.8588235294117647, 0.8588235294117647),
 'gray87': (0.8705882352941177, 0.8705882352941177, 0.8705882352941177),
 'gray88': (0.8784313725490196, 0.8784313725490196, 0.8784313725490196),
 'gray89': (0.8901960784313725, 0.8901960784313725, 0.8901960784313725),
 'gray9': (0.09019607843137255, 0.09019607843137255, 0.09019607843137255),
 'gray90': (0.8980392156862745, 0.8980392156862745, 0.8980392156862745),
 'gray91': (0.9098039215686274, 0.9098039215686274, 0.9098039215686274),
 'gray92': (0.9215686274509803, 0.9215686274509803, 0.9215686274509803),
 'gray93': (0.9294117647058824, 0.9294117647058824, 0.9294117647058824),
 'gray94': (0.9411764705882353, 0.9411764705882353, 0.9411764705882353),
 'gray95': (0.9490196078431372, 0.9490196078431372, 0.9490196078431372),
 'gray96': (0.9607843137254902, 0.9607843137254902, 0.9607843137254902),
 'gray97': (0.9686274509803922, 0.9686274509803922, 0.9686274509803922),
 'gray98': (0.9803921568627451, 0.9803921568627451, 0.9803921568627451),
 'gray99': (0.9882352941176471, 0.9882352941176471, 0.9882352941176471),
 'green': (0.0, 1.0, 0.0),
 'green1': (0.0, 1.0, 0.0),
 'green2': (0.0, 0.9333333333333333, 0.0),
 'green3': (0.0, 0.803921568627451, 0.0),
 'green4': (0.0, 0.5450980392156862, 0.0),
 'greenyellow': (0.6784313725490196, 1.0, 0.1843137254901961),
 'grey': (0.7450980392156863, 0.7450980392156863, 0.7450980392156863),
 'grey0': (0.0, 0.0, 0.0),
 'grey1': (0.011764705882352941, 0.011764705882352941, 0.011764705882352941),
 'grey10': (0.10196078431372549, 0.10196078431372549, 0.10196078431372549),
 'grey100': (1.0, 1.0, 1.0),
 'grey11': (0.10980392156862745, 0.10980392156862745, 0.10980392156862745),
 'grey12': (0.12156862745098039, 0.12156862745098039, 0.12156862745098039),
 'grey13': (0.12941176470588237, 0.12941176470588237, 0.12941176470588237),
 'grey14': (0.1411764705882353, 0.1411764705882353, 0.1411764705882353),
 'grey15': (0.14901960784313725, 0.14901960784313725, 0.14901960784313725),
 'grey16': (0.1607843137254902, 0.1607843137254902, 0.1607843137254902),
 'grey17': (0.16862745098039217, 0.16862745098039217, 0.16862745098039217),
 'grey18': (0.1803921568627451, 0.1803921568627451, 0.1803921568627451),
 'grey19': (0.18823529411764706, 0.18823529411764706, 0.18823529411764706),
 'grey2': (0.0196078431372549, 0.0196078431372549, 0.0196078431372549),
 'grey20': (0.2, 0.2, 0.2),
 'grey21': (0.21176470588235294, 0.21176470588235294, 0.21176470588235294),
 'grey22': (0.2196078431372549, 0.2196078431372549, 0.2196078431372549),
 'grey23': (0.23137254901960785, 0.23137254901960785, 0.23137254901960785),
 'grey24': (0.23921568627450981, 0.23921568627450981, 0.23921568627450981),
 'grey25': (0.25098039215686274, 0.25098039215686274, 0.25098039215686274),
 'grey26': (0.25882352941176473, 0.25882352941176473, 0.25882352941176473),
 'grey27': (0.27058823529411763, 0.27058823529411763, 0.27058823529411763),
 'grey28': (0.2784313725490196, 0.2784313725490196, 0.2784313725490196),
 'grey29': (0.2901960784313726, 0.2901960784313726, 0.2901960784313726),
 'grey3': (0.03137254901960784, 0.03137254901960784, 0.03137254901960784),
 'grey30': (0.30196078431372547, 0.30196078431372547, 0.30196078431372547),
 'grey31': (0.30980392156862746, 0.30980392156862746, 0.30980392156862746),
 'grey32': (0.3215686274509804, 0.3215686274509804, 0.3215686274509804),
 'grey33': (0.32941176470588235, 0.32941176470588235, 0.32941176470588235),
 'grey34': (0.3411764705882353, 0.3411764705882353, 0.3411764705882353),
 'grey35': (0.34901960784313724, 0.34901960784313724, 0.34901960784313724),
 'grey36': (0.3607843137254902, 0.3607843137254902, 0.3607843137254902),
 'grey37': (0.3686274509803922, 0.3686274509803922, 0.3686274509803922),
 'grey38': (0.3803921568627451, 0.3803921568627451, 0.3803921568627451),
 'grey39': (0.38823529411764707, 0.38823529411764707, 0.38823529411764707),
 'grey4': (0.0392156862745098, 0.0392156862745098, 0.0392156862745098),
 'grey40': (0.4, 0.4, 0.4),
 'grey41': (0.4117647058823529, 0.4117647058823529, 0.4117647058823529),
 'grey42': (0.4196078431372549, 0.4196078431372549, 0.4196078431372549),
 'grey43': (0.43137254901960786, 0.43137254901960786, 0.43137254901960786),
 'grey44': (0.4392156862745098, 0.4392156862745098, 0.4392156862745098),
 'grey45': (0.45098039215686275, 0.45098039215686275, 0.45098039215686275),
 'grey46': (0.4588235294117647, 0.4588235294117647, 0.4588235294117647),
 'grey47': (0.47058823529411764, 0.47058823529411764, 0.47058823529411764),
 'grey48': (0.47843137254901963, 0.47843137254901963, 0.47843137254901963),
 'grey49': (0.49019607843137253, 0.49019607843137253, 0.49019607843137253),
 'grey5': (0.050980392156862744, 0.050980392156862744, 0.050980392156862744),
 'grey50': (0.4980392156862745, 0.4980392156862745, 0.4980392156862745),
 'grey51': (0.5098039215686274, 0.5098039215686274, 0.5098039215686274),
 'grey52': (0.5215686274509804, 0.5215686274509804, 0.5215686274509804),
 'grey53': (0.5294117647058824, 0.5294117647058824, 0.5294117647058824),
 'grey54': (0.5411764705882353, 0.5411764705882353, 0.5411764705882353),
 'grey55': (0.5490196078431373, 0.5490196078431373, 0.5490196078431373),
 'grey56': (0.5607843137254902, 0.5607843137254902, 0.5607843137254902),
 'grey57': (0.5686274509803921, 0.5686274509803921, 0.5686274509803921),
 'grey58': (0.5803921568627451, 0.5803921568627451, 0.5803921568627451),
 'grey59': (0.5882352941176471, 0.5882352941176471, 0.5882352941176471),
 'grey6': (0.058823529411764705, 0.058823529411764705, 0.058823529411764705),
 'grey60': (0.6, 0.6, 0.6),
 'grey61': (0.611764705882353, 0.611764705882353, 0.611764705882353),
 'grey62': (0.6196078431372549, 0.6196078431372549, 0.6196078431372549),
 'grey63': (0.6313725490196078, 0.6313725490196078, 0.6313725490196078),
 'grey64': (0.6392156862745098, 0.6392156862745098, 0.6392156862745098),
 'grey65': (0.6509803921568628, 0.6509803921568628, 0.6509803921568628),
 'grey66': (0.6588235294117647, 0.6588235294117647, 0.6588235294117647),
 'grey67': (0.6705882352941176, 0.6705882352941176, 0.6705882352941176),
 'grey68': (0.6784313725490196, 0.6784313725490196, 0.6784313725490196),
 'grey69': (0.6901960784313725, 0.6901960784313725, 0.6901960784313725),
 'grey7': (0.07058823529411765, 0.07058823529411765, 0.07058823529411765),
 'grey70': (0.7019607843137254, 0.7019607843137254, 0.7019607843137254),
 'grey71': (0.7098039215686275, 0.7098039215686275, 0.7098039215686275),
 'grey72': (0.7215686274509804, 0.7215686274509804, 0.7215686274509804),
 'grey73': (0.7294117647058823, 0.7294117647058823, 0.7294117647058823),
 'grey74': (0.7411764705882353, 0.7411764705882353, 0.7411764705882353),
 'grey75': (0.7490196078431373, 0.7490196078431373, 0.7490196078431373),
 'grey76': (0.7607843137254902, 0.7607843137254902, 0.7607843137254902),
 'grey77': (0.7686274509803922, 0.7686274509803922, 0.7686274509803922),
 'grey78': (0.7803921568627451, 0.7803921568627451, 0.7803921568627451),
 'grey79': (0.788235294117647, 0.788235294117647, 0.788235294117647),
 'grey8': (0.0784313725490196, 0.0784313725490196, 0.0784313725490196),
 'grey80': (0.8, 0.8, 0.8),
 'grey81': (0.8117647058823529, 0.8117647058823529, 0.8117647058823529),
 'grey82': (0.8196078431372549, 0.8196078431372549, 0.8196078431372549),
 'grey83': (0.8313725490196079, 0.8313725490196079, 0.8313725490196079),
 'grey84': (0.8392156862745098, 0.8392156862745098, 0.8392156862745098),
 'grey85': (0.8509803921568627, 0.8509803921568627, 0.8509803921568627),
 'grey86': (0.8588235294117647, 0.8588235294117647, 0.8588235294117647),
 'grey87': (0.8705882352941177, 0.8705882352941177, 0.8705882352941177),
 'grey88': (0.8784313725490196, 0.8784313725490196, 0.8784313725490196),
 'grey89': (0.8901960784313725, 0.8901960784313725, 0.8901960784313725),
 'grey9': (0.09019607843137255, 0.09019607843137255, 0.09019607843137255),
 'grey90': (0.8980392156862745, 0.8980392156862745, 0.8980392156862745),
 'grey91': (0.9098039215686274, 0.9098039215686274, 0.9098039215686274),
 'grey92': (0.9215686274509803, 0.9215686274509803, 0.9215686274509803),
 'grey93': (0.9294117647058824, 0.9294117647058824, 0.9294117647058824),
 'grey94': (0.9411764705882353, 0.9411764705882353, 0.9411764705882353),
 'grey95': (0.9490196078431372, 0.9490196078431372, 0.9490196078431372),
 'grey96': (0.9607843137254902, 0.9607843137254902, 0.9607843137254902),
 'grey97': (0.9686274509803922, 0.9686274509803922, 0.9686274509803922),
 'grey98': (0.9803921568627451, 0.9803921568627451, 0.9803921568627451),
 'grey99': (0.9882352941176471, 0.9882352941176471, 0.9882352941176471),
 'honeydew': (0.9411764705882353, 1.0, 0.9411764705882353),
 'honeydew1': (0.9411764705882353, 1.0, 0.9411764705882353),
 'honeydew2': (0.8784313725490196, 0.9333333333333333, 0.8784313725490196),
 'honeydew3': (0.7568627450980392, 0.803921568627451, 0.7568627450980392),
 'honeydew4': (0.5137254901960784, 0.5450980392156862, 0.5137254901960784),
 'hotpink': (1.0, 0.4117647058823529, 0.7058823529411765),
 'hotpink1': (1.0, 0.43137254901960786, 0.7058823529411765),
 'hotpink2': (0.9333333333333333, 0.41568627450980394, 0.6549019607843137),
 'hotpink3': (0.803921568627451, 0.3764705882352941, 0.5647058823529412),
 'hotpink4': (0.5450980392156862, 0.22745098039215686, 0.3843137254901961),
 'indianred': (0.803921568627451, 0.3607843137254902, 0.3607843137254902),
 'indianred1': (1.0, 0.41568627450980394, 0.41568627450980394),
 'indianred2': (0.9333333333333333, 0.38823529411764707, 0.38823529411764707),
 'indianred3': (0.803921568627451, 0.3333333333333333, 0.3333333333333333),
 'indianred4': (0.5450980392156862, 0.22745098039215686, 0.22745098039215686),
 'ivory': (1.0, 1.0, 0.9411764705882353),
 'ivory1': (1.0, 1.0, 0.9411764705882353),
 'ivory2': (0.9333333333333333, 0.9333333333333333, 0.8784313725490196),
 'ivory3': (0.803921568627451, 0.803921568627451, 0.7568627450980392),
 'ivory4': (0.5450980392156862, 0.5450980392156862, 0.5137254901960784),
 'khaki': (0.9411764705882353, 0.9019607843137255, 0.5490196078431373),
 'khaki1': (1.0, 0.9647058823529412, 0.5607843137254902),
 'khaki2': (0.9333333333333333, 0.9019607843137255, 0.5215686274509804),
 'khaki3': (0.803921568627451, 0.7764705882352941, 0.45098039215686275),
 'khaki4': (0.5450980392156862, 0.5254901960784314, 0.3058823529411765),
 'lavender': (0.9019607843137255, 0.9019607843137255, 0.9803921568627451),
 'lavenderblush': (1.0, 0.9411764705882353, 0.9607843137254902),
 'lavenderblush1': (1.0, 0.9411764705882353, 0.9607843137254902),
 'lavenderblush2': (0.9333333333333333,
                    0.8784313725490196,
                    0.8980392156862745),
 'lavenderblush3': (0.803921568627451, 0.7568627450980392, 0.7725490196078432),
 'lavenderblush4': (0.5450980392156862,
                    0.5137254901960784,
                    0.5254901960784314),
 'lawngreen': (0.48627450980392156, 0.9882352941176471, 0.0),
 'lemonchiffon': (1.0, 0.9803921568627451, 0.803921568627451),
 'lemonchiffon1': (1.0, 0.9803921568627451, 0.803921568627451),
 'lemonchiffon2': (0.9333333333333333, 0.9137254901960784, 0.7490196078431373),
 'lemonchiffon3': (0.803921568627451, 0.788235294117647, 0.6470588235294118),
 'lemonchiffon4': (0.5450980392156862, 0.5372549019607843, 0.4392156862745098),
 'lightblue': (0.6784313725490196, 0.8470588235294118, 0.9019607843137255),
 'lightblue1': (0.7490196078431373, 0.9372549019607843, 1.0),
 'lightblue2': (0.6980392156862745, 0.8745098039215686, 0.9333333333333333),
 'lightblue3': (0.6039215686274509, 0.7529411764705882, 0.803921568627451),
 'lightblue4': (0.40784313725490196, 0.5137254901960784, 0.5450980392156862),
 'lightcoral': (0.9411764705882353, 0.5019607843137255, 0.5019607843137255),
 'lightcyan': (0.8784313725490196, 1.0, 1.0),
 'lightcyan1': (0.8784313725490196, 1.0, 1.0),
 'lightcyan2': (0.8196078431372549, 0.9333333333333333, 0.9333333333333333),
 'lightcyan3': (0.7058823529411765, 0.803921568627451, 0.803921568627451),
 'lightcyan4': (0.47843137254901963, 0.5450980392156862, 0.5450980392156862),
 'lightgoldenrod': (0.9333333333333333,
                    0.8666666666666667,
                    0.5098039215686274),
 'lightgoldenrod1': (1.0, 0.9254901960784314, 0.5450980392156862),
 'lightgoldenrod2': (0.9333333333333333,
                     0.8627450980392157,
                     0.5098039215686274),
 'lightgoldenrod3': (0.803921568627451,
                     0.7450980392156863,
                     0.4392156862745098),
 'lightgoldenrod4': (0.5450980392156862,
                     0.5058823529411764,
                     0.2980392156862745),
 'lightgoldenrodyellow': (0.9803921568627451,
                          0.9803921568627451,
                          0.8235294117647058),
 'lightgray': (0.8274509803921568, 0.8274509803921568, 0.8274509803921568),
 'lightgreen': (0.5647058823529412, 0.9333333333333333, 0.5647058823529412),
 'lightgrey': (0.8274509803921568, 0.8274509803921568, 0.8274509803921568),
 'lightpink': (1.0, 0.7137254901960784, 0.7568627450980392),
 'lightpink1': (1.0, 0.6823529411764706, 0.7254901960784313),
 'lightpink2': (0.9333333333333333, 0.6352941176470588, 0.6784313725490196),
 'lightpink3': (0.803921568627451, 0.5490196078431373, 0.5843137254901961),
 'lightpink4': (0.5450980392156862, 0.37254901960784315, 0.396078431372549),
 'lightsalmon': (1.0, 0.6274509803921569, 0.47843137254901963),
 'lightsalmon1': (1.0, 0.6274509803921569, 0.47843137254901963),
 'lightsalmon2': (0.9333333333333333, 0.5843137254901961, 0.4470588235294118),
 'lightsalmon3': (0.803921568627451, 0.5058823529411764, 0.3843137254901961),
 'lightsalmon4': (0.5450980392156862, 0.3411764705882353, 0.25882352941176473),
 'lightseagreen': (0.12549019607843137,
                   0.6980392156862745,
                   0.6666666666666666),
 'lightskyblue': (0.5294117647058824, 0.807843137254902, 0.9803921568627451),
 'lightskyblue1': (0.6901960784313725, 0.8862745098039215, 1.0),
 'lightskyblue2': (0.6431372549019608, 0.8274509803921568, 0.9333333333333333),
 'lightskyblue3': (0.5529411764705883, 0.7137254901960784, 0.803921568627451),
 'lightskyblue4': (0.3764705882352941, 0.4823529411764706, 0.5450980392156862),
 'lightslateblue': (0.5176470588235295, 0.4392156862745098, 1.0),
 'lightslategray': (0.4666666666666667, 0.5333333333333333, 0.6),
 'lightslategrey': (0.4666666666666667, 0.5333333333333333, 0.6),
 'lightsteelblue': (0.6901960784313725,
                    0.7686274509803922,
                    0.8705882352941177),
 'lightsteelblue1': (0.792156862745098, 0.8823529411764706, 1.0),
 'lightsteelblue2': (0.7372549019607844,
                     0.8235294117647058,
                     0.9333333333333333),
 'lightsteelblue3': (0.6352941176470588,
                     0.7098039215686275,
                     0.803921568627451),
 'lightsteelblue4': (0.43137254901960786,
                     0.4823529411764706,
                     0.5450980392156862),
 'lightyellow': (1.0, 1.0, 0.8784313725490196),
 'lightyellow1': (1.0, 1.0, 0.8784313725490196),
 'lightyellow2': (0.9333333333333333, 0.9333333333333333, 0.8196078431372549),
 'lightyellow3': (0.803921568627451, 0.803921568627451, 0.7058823529411765),
 'lightyellow4': (0.5450980392156862, 0.5450980392156862, 0.47843137254901963),
 'limegreen': (0.19607843137254902, 0.803921568627451, 0.19607843137254902),
 'linen': (0.9803921568627451, 0.9411764705882353, 0.9019607843137255),
 'magenta': (1.0, 0.0, 1.0),
 'magenta1': (1.0, 0.0, 1.0),
 'magenta2': (0.9333333333333333, 0.0, 0.9333333333333333),
 'magenta3': (0.803921568627451, 0.0, 0.803921568627451),
 'magenta4': (0.5450980392156862, 0.0, 0.5450980392156862),
 'maroon': (0.6901960784313725, 0.18823529411764706, 0.3764705882352941),
 'maroon1': (1.0, 0.20392156862745098, 0.7019607843137254),
 'maroon2': (0.9333333333333333, 0.18823529411764706, 0.6549019607843137),
 'maroon3': (0.803921568627451, 0.1607843137254902, 0.5647058823529412),
 'maroon4': (0.5450980392156862, 0.10980392156862745, 0.3843137254901961),
 'mediumaquamarine': (0.4, 0.803921568627451, 0.6666666666666666),
 'mediumblue': (0.0, 0.0, 0.803921568627451),
 'mediumorchid': (0.7294117647058823, 0.3333333333333333, 0.8274509803921568),
 'mediumorchid1': (0.8784313725490196, 0.4, 1.0),
 'mediumorchid2': (0.8196078431372549,
                   0.37254901960784315,
                   0.9333333333333333),
 'mediumorchid3': (0.7058823529411765, 0.3215686274509804, 0.803921568627451),
 'mediumorchid4': (0.47843137254901963,
                   0.21568627450980393,
                   0.5450980392156862),
 'mediumpurple': (0.5764705882352941, 0.4392156862745098, 0.8588235294117647),
 'mediumpurple1': (0.6705882352941176, 0.5098039215686274, 1.0),
 'mediumpurple2': (0.6235294117647059, 0.4745098039215686, 0.9333333333333333),
 'mediumpurple3': (0.5372549019607843, 0.40784313725490196, 0.803921568627451),
 'mediumpurple4': (0.36470588235294116,
                   0.2784313725490196,
                   0.5450980392156862),
 'mediumseagreen': (0.23529411764705882,
                    0.7019607843137254,
                    0.44313725490196076),
 'mediumslateblue': (0.4823529411764706,
                     0.40784313725490196,
                     0.9333333333333333),
 'mediumspringgreen': (0.0, 0.9803921568627451, 0.6039215686274509),
 'mediumturquoise': (0.2823529411764706, 0.8196078431372549, 0.8),
 'mediumvioletred': (0.7803921568627451,
                     0.08235294117647059,
                     0.5215686274509804),
 'midnightblue': (0.09803921568627451,
                  0.09803921568627451,
                  0.4392156862745098),
 'mintcream': (0.9607843137254902, 1.0, 0.9803921568627451),
 'mistyrose': (1.0, 0.8941176470588236, 0.8823529411764706),
 'mistyrose1': (1.0, 0.8941176470588236, 0.8823529411764706),
 'mistyrose2': (0.9333333333333333, 0.8352941176470589, 0.8235294117647058),
 'mistyrose3': (0.803921568627451, 0.7176470588235294, 0.7098039215686275),
 'mistyrose4': (0.5450980392156862, 0.49019607843137253, 0.4823529411764706),
 'moccasin': (1.0, 0.8941176470588236, 0.7098039215686275),
 'navajowhite': (1.0, 0.8705882352941177, 0.6784313725490196),
 'navajowhite1': (1.0, 0.8705882352941177, 0.6784313725490196),
 'navajowhite2': (0.9333333333333333, 0.8117647058823529, 0.6313725490196078),
 'navajowhite3': (0.803921568627451, 0.7019607843137254, 0.5450980392156862),
 'navajowhite4': (0.5450980392156862, 0.4745098039215686, 0.3686274509803922),
 'navy': (0.0, 0.0, 0.5019607843137255),
 'navyblue': (0.0, 0.0, 0.5019607843137255),
 'oldlace': (0.9921568627450981, 0.9607843137254902, 0.9019607843137255),
 'olivedrab': (0.4196078431372549, 0.5568627450980392, 0.13725490196078433),
 'olivedrab1': (0.7529411764705882, 1.0, 0.24313725490196078),
 'olivedrab2': (0.7019607843137254, 0.9333333333333333, 0.22745098039215686),
 'olivedrab3': (0.6039215686274509, 0.803921568627451, 0.19607843137254902),
 'olivedrab4': (0.4117647058823529, 0.5450980392156862, 0.13333333333333333),
 'orange': (1.0, 0.6470588235294118, 0.0),
 'orange1': (1.0, 0.6470588235294118, 0.0),
 'orange2': (0.9333333333333333, 0.6039215686274509, 0.0),
 'orange3': (0.803921568627451, 0.5215686274509804, 0.0),
 'orange4': (0.5450980392156862, 0.35294117647058826, 0.0),
 'orangered': (1.0, 0.27058823529411763, 0.0),
 'orangered1': (1.0, 0.27058823529411763, 0.0),
 'orangered2': (0.9333333333333333, 0.25098039215686274, 0.0),
 'orangered3': (0.803921568627451, 0.21568627450980393, 0.0),
 'orangered4': (0.5450980392156862, 0.1450980392156863, 0.0),
 'orchid': (0.8549019607843137, 0.4392156862745098, 0.8392156862745098),
 'orchid1': (1.0, 0.5137254901960784, 0.9803921568627451),
 'orchid2': (0.9333333333333333, 0.47843137254901963, 0.9137254901960784),
 'orchid3': (0.803921568627451, 0.4117647058823529, 0.788235294117647),
 'orchid4': (0.5450980392156862, 0.2784313725490196, 0.5372549019607843),
 'palegoldenrod': (0.9333333333333333, 0.9098039215686274, 0.6666666666666666),
 'palegreen': (0.596078431372549, 0.984313725490196, 0.596078431372549),
 'palegreen1': (0.6039215686274509, 1.0, 0.6039215686274509),
 'palegreen2': (0.5647058823529412, 0.9333333333333333, 0.5647058823529412),
 'palegreen3': (0.48627450980392156, 0.803921568627451, 0.48627450980392156),
 'palegreen4': (0.32941176470588235, 0.5450980392156862, 0.32941176470588235),
 'paleturquoise': (0.6862745098039216, 0.9333333333333333, 0.9333333333333333),
 'paleturquoise1': (0.7333333333333333, 1.0, 1.0),
 'paleturquoise2': (0.6823529411764706,
                    0.9333333333333333,
                    0.9333333333333333),
 'paleturquoise3': (0.5882352941176471, 0.803921568627451, 0.803921568627451),
 'paleturquoise4': (0.4, 0.5450980392156862, 0.5450980392156862),
 'palevioletred': (0.8588235294117647, 0.4392156862745098, 0.5764705882352941),
 'palevioletred1': (1.0, 0.5098039215686274, 0.6705882352941176),
 'palevioletred2': (0.9333333333333333,
                    0.4745098039215686,
                    0.6235294117647059),
 'palevioletred3': (0.803921568627451,
                    0.40784313725490196,
                    0.5372549019607843),
 'palevioletred4': (0.5450980392156862,
                    0.2784313725490196,
                    0.36470588235294116),
 'papayawhip': (1.0, 0.9372549019607843, 0.8352941176470589),
 'peachpuff': (1.0, 0.8549019607843137, 0.7254901960784313),
 'peachpuff1': (1.0, 0.8549019607843137, 0.7254901960784313),
 'peachpuff2': (0.9333333333333333, 0.796078431372549, 0.6784313725490196),
 'peachpuff3': (0.803921568627451, 0.6862745098039216, 0.5843137254901961),
 'peachpuff4': (0.5450980392156862, 0.4666666666666667, 0.396078431372549),
 'peru': (0.803921568627451, 0.5215686274509804, 0.24705882352941178),
 'pink': (1.0, 0.7529411764705882, 0.796078431372549),
 'pink1': (1.0, 0.7098039215686275, 0.7725490196078432),
 'pink2': (0.9333333333333333, 0.6627450980392157, 0.7215686274509804),
 'pink3': (0.803921568627451, 0.5686274509803921, 0.6196078431372549),
 'pink4': (0.5450980392156862, 0.38823529411764707, 0.4235294117647059),
 'plum': (0.8666666666666667, 0.6274509803921569, 0.8666666666666667),
 'plum1': (1.0, 0.7333333333333333, 1.0),
 'plum2': (0.9333333333333333, 0.6823529411764706, 0.9333333333333333),
 'plum3': (0.803921568627451, 0.5882352941176471, 0.803921568627451),
 'plum4': (0.5450980392156862, 0.4, 0.5450980392156862),
 'powderblue': (0.6901960784313725, 0.8784313725490196, 0.9019607843137255),
 'purple': (0.6274509803921569, 0.12549019607843137, 0.9411764705882353),
 'purple1': (0.6078431372549019, 0.18823529411764706, 1.0),
 'purple2': (0.5686274509803921, 0.17254901960784313, 0.9333333333333333),
 'purple3': (0.49019607843137253, 0.14901960784313725, 0.803921568627451),
 'purple4': (0.3333333333333333, 0.10196078431372549, 0.5450980392156862),
 'red': (1.0, 0.0, 0.0),
 'red1': (1.0, 0.0, 0.0),
 'red2': (0.9333333333333333, 0.0, 0.0),
 'red3': (0.803921568627451, 0.0, 0.0),
 'red4': (0.5450980392156862, 0.0, 0.0),
 'rosybrown': (0.7372549019607844, 0.5607843137254902, 0.5607843137254902),
 'rosybrown1': (1.0, 0.7568627450980392, 0.7568627450980392),
 'rosybrown2': (0.9333333333333333, 0.7058823529411765, 0.7058823529411765),
 'rosybrown3': (0.803921568627451, 0.6078431372549019, 0.6078431372549019),
 'rosybrown4': (0.5450980392156862, 0.4117647058823529, 0.4117647058823529),
 'royalblue': (0.2549019607843137, 0.4117647058823529, 0.8823529411764706),
 'royalblue1': (0.2823529411764706, 0.4627450980392157, 1.0),
 'royalblue2': (0.2627450980392157, 0.43137254901960786, 0.9333333333333333),
 'royalblue3': (0.22745098039215686, 0.37254901960784315, 0.803921568627451),
 'royalblue4': (0.15294117647058825, 0.25098039215686274, 0.5450980392156862),
 'saddlebrown': (0.5450980392156862, 0.27058823529411763, 0.07450980392156863),
 'salmon': (0.9803921568627451, 0.5019607843137255, 0.4470588235294118),
 'salmon1': (1.0, 0.5490196078431373, 0.4117647058823529),
 'salmon2': (0.9333333333333333, 0.5098039215686274, 0.3843137254901961),
 'salmon3': (0.803921568627451, 0.4392156862745098, 0.32941176470588235),
 'salmon4': (0.5450980392156862, 0.2980392156862745, 0.2235294117647059),
 'sandybrown': (0.9568627450980393, 0.6431372549019608, 0.3764705882352941),
 'seagreen': (0.1803921568627451, 0.5450980392156862, 0.3411764705882353),
 'seagreen1': (0.32941176470588235, 1.0, 0.6235294117647059),
 'seagreen2': (0.3058823529411765, 0.9333333333333333, 0.5803921568627451),
 'seagreen3': (0.2627450980392157, 0.803921568627451, 0.5019607843137255),
 'seagreen4': (0.1803921568627451, 0.5450980392156862, 0.3411764705882353),
 'seashell': (1.0, 0.9607843137254902, 0.9333333333333333),
 'seashell1': (1.0, 0.9607843137254902, 0.9333333333333333),
 'seashell2': (0.9333333333333333, 0.8980392156862745, 0.8705882352941177),
 'seashell3': (0.803921568627451, 0.7725490196078432, 0.7490196078431373),
 'seashell4': (0.5450980392156862, 0.5254901960784314, 0.5098039215686274),
 'sienna': (0.6274509803921569, 0.3215686274509804, 0.17647058823529413),
 'sienna1': (1.0, 0.5098039215686274, 0.2784313725490196),
 'sienna2': (0.9333333333333333, 0.4745098039215686, 0.25882352941176473),
 'sienna3': (0.803921568627451, 0.40784313725490196, 0.2235294117647059),
 'sienna4': (0.5450980392156862, 0.2784313725490196, 0.14901960784313725),
 'skyblue': (0.5294117647058824, 0.807843137254902, 0.9215686274509803),
 'skyblue1': (0.5294117647058824, 0.807843137254902, 1.0),
 'skyblue2': (0.49411764705882355, 0.7529411764705882, 0.9333333333333333),
 'skyblue3': (0.4235294117647059, 0.6509803921568628, 0.803921568627451),
 'skyblue4': (0.2901960784313726, 0.4392156862745098, 0.5450980392156862),
 'slateblue': (0.41568627450980394, 0.35294117647058826, 0.803921568627451),
 'slateblue1': (0.5137254901960784, 0.43529411764705883, 1.0),
 'slateblue2': (0.47843137254901963, 0.403921568627451, 0.9333333333333333),
 'slateblue3': (0.4117647058823529, 0.34901960784313724, 0.803921568627451),
 'slateblue4': (0.2784313725490196, 0.23529411764705882, 0.5450980392156862),
 'slategray': (0.4392156862745098, 0.5019607843137255, 0.5647058823529412),
 'slategray1': (0.7764705882352941, 0.8862745098039215, 1.0),
 'slategray2': (0.7254901960784313, 0.8274509803921568, 0.9333333333333333),
 'slategray3': (0.6235294117647059, 0.7137254901960784, 0.803921568627451),
 'slategray4': (0.4235294117647059, 0.4823529411764706, 0.5450980392156862),
 'slategrey': (0.4392156862745098, 0.5019607843137255, 0.5647058823529412),
 'snow': (1.0, 0.9803921568627451, 0.9803921568627451),
 'snow1': (1.0, 0.9803921568627451, 0.9803921568627451),
 'snow2': (0.9333333333333333, 0.9137254901960784, 0.9137254901960784),
 'snow3': (0.803921568627451, 0.788235294117647, 0.788235294117647),
 'snow4': (0.5450980392156862, 0.5372549019607843, 0.5372549019607843),
 'springgreen': (0.0, 1.0, 0.4980392156862745),
 'springgreen1': (0.0, 1.0, 0.4980392156862745),
 'springgreen2': (0.0, 0.9333333333333333, 0.4627450980392157),
 'springgreen3': (0.0, 0.803921568627451, 0.4),
 'springgreen4': (0.0, 0.5450980392156862, 0.27058823529411763),
 'steelblue': (0.27450980392156865, 0.5098039215686274, 0.7058823529411765),
 'steelblue1': (0.38823529411764707, 0.7215686274509804, 1.0),
 'steelblue2': (0.3607843137254902, 0.6745098039215687, 0.9333333333333333),
 'steelblue3': (0.30980392156862746, 0.5803921568627451, 0.803921568627451),
 'steelblue4': (0.21176470588235294, 0.39215686274509803, 0.5450980392156862),
 'tan': (0.8235294117647058, 0.7058823529411765, 0.5490196078431373),
 'tan1': (1.0, 0.6470588235294118, 0.30980392156862746),
 'tan2': (0.9333333333333333, 0.6039215686274509, 0.28627450980392155),
 'tan3': (0.803921568627451, 0.5215686274509804, 0.24705882352941178),
 'tan4': (0.5450980392156862, 0.35294117647058826, 0.16862745098039217),
 'thistle': (0.8470588235294118, 0.7490196078431373, 0.8470588235294118),
 'thistle1': (1.0, 0.8823529411764706, 1.0),
 'thistle2': (0.9333333333333333, 0.8235294117647058, 0.9333333333333333),
 'thistle3': (0.803921568627451, 0.7098039215686275, 0.803921568627451),
 'thistle4': (0.5450980392156862, 0.4823529411764706, 0.5450980392156862),
 'tomato': (1.0, 0.38823529411764707, 0.2784313725490196),
 'tomato1': (1.0, 0.38823529411764707, 0.2784313725490196),
 'tomato2': (0.9333333333333333, 0.3607843137254902, 0.25882352941176473),
 'tomato3': (0.803921568627451, 0.30980392156862746, 0.2235294117647059),
 'tomato4': (0.5450980392156862, 0.21176470588235294, 0.14901960784313725),
 'turquoise': (0.25098039215686274, 0.8784313725490196, 0.8156862745098039),
 'turquoise1': (0.0, 0.9607843137254902, 1.0),
 'turquoise2': (0.0, 0.8980392156862745, 0.9333333333333333),
 'turquoise3': (0.0, 0.7725490196078432, 0.803921568627451),
 'turquoise4': (0.0, 0.5254901960784314, 0.5450980392156862),
 'violet': (0.9333333333333333, 0.5098039215686274, 0.9333333333333333),
 'violetred': (0.8156862745098039, 0.12549019607843137, 0.5647058823529412),
 'violetred1': (1.0, 0.24313725490196078, 0.5882352941176471),
 'violetred2': (0.9333333333333333, 0.22745098039215686, 0.5490196078431373),
 'violetred3': (0.803921568627451, 0.19607843137254902, 0.47058823529411764),
 'violetred4': (0.5450980392156862, 0.13333333333333333, 0.3215686274509804),
 'wheat': (0.9607843137254902, 0.8705882352941177, 0.7019607843137254),
 'wheat1': (1.0, 0.9058823529411765, 0.7294117647058823),
 'wheat2': (0.9333333333333333, 0.8470588235294118, 0.6823529411764706),
 'wheat3': (0.803921568627451, 0.7294117647058823, 0.5882352941176471),
 'wheat4': (0.5450980392156862, 0.49411764705882355, 0.4),
 'white': (1.0, 1.0, 1.0),
 'whitesmoke': (0.9607843137254902, 0.9607843137254902, 0.9607843137254902),
 'yellow': (1.0, 1.0, 0.0),
 'yellow1': (1.0, 1.0, 0.0),
 'yellow2': (0.9333333333333333, 0.9333333333333333, 0.0),
 'yellow3': (0.803921568627451, 0.803921568627451, 0.0),
 'yellow4': (0.5450980392156862, 0.5450980392156862, 0.0),
 'yellowgreen': (0.6039215686274509, 0.803921568627451, 0.19607843137254902),
 }

color_list = []


def recalc_color_list():
    global color_list
    color_list = list(color_dict.keys())
    color_list.sort()


def lookup_color(name, format='tuple'):
    color = None
    if name.startswith('#'):
        # hex notation
        name = name[1:]
        color = (int(name[:2], 16) / 255.0,
                 int(name[2:4], 16) / 255.0,
                 int(name[4:6], 16) / 255.0)
    else:
        # must be a name
        try:
            color = color_dict[name]
        except KeyError:
            raise KeyError("%s color does not exist in color_dict" % name)

    if format == 'tuple':
        return color
    elif format == 'hash':
        return "#%02x%02x%02x" % (
            int(color[0] * 255), int(color[1] * 255), int(color[2] * 255))
    else:
        raise ValueError("format needs to be 'tuple' or 'hash'")


def _validate_color_tuple(tup):
    if not isinstance(tup, (tuple, list)):
        raise TypeError("the color element must be a tuple or list")

    if len(tup) != 3:
        raise ValueError("length of color tuple must be 3 specifying RBG values")

    for rbg_value in tup:
        if rbg_value < 0.0 or rbg_value > 1.0:
            raise ValueError("RBG value can only be a number between 0 and 1")


def add_color(name, tup):
    _validate_color_tuple(tup)

    global color_dict
    color_dict[name] = tuple(tup)
    recalc_color_list()


# TODO: Should this throw KeyError if key not present or silently pass?
def remove_color(name):
    global color_dict
    try:
        del color_dict[name]
    except KeyError:
        raise KeyError("%s color does not exist in color_dict" % name)
    recalc_color_list()


def get_colors():
    return color_list


def scan_rgbtxt(filepath):
    with open(filepath, 'r') as in_f:
        buf = in_f.read()

    return scan_rgbtxt_buf(buf)


def scan_rgbtxt_buf(buf):
    res = {}

    for line in buf.split('\n'):
        match = re.match(r"^\s*(\d+)\s+(\d+)\s+(\d+)\s+([\w_]+)\s*$", line)
        if match:
            r, g, b, name = match.groups()
            r = float(r) / 255.0
            g = float(g) / 255.0
            b = float(b) / 255.0
            name = name.lower()
            res[name] = (r, g, b)

    return res


# create initial color list
recalc_color_list()


if __name__ == "__main__":
    import sys
    import pprint
    res = scan_rgbtxt(sys.argv[1])
    pprint.pprint(res)

# END
