/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.content;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public final class LocalBroadcastManager {
    private static final String TAG = "LocalBroadcastManager";
    private static final boolean DEBUG = false;
    private final Context mAppContext;
    private final HashMap<BroadcastReceiver, ArrayList<IntentFilter>> mReceivers = new HashMap();
    private final HashMap<String, ArrayList<ReceiverRecord>> mActions = new HashMap();
    private final ArrayList<BroadcastRecord> mPendingBroadcasts = new ArrayList();
    static final int MSG_EXEC_PENDING_BROADCASTS = 1;
    private final Handler mHandler;
    private static final Object mLock = new Object();
    private static LocalBroadcastManager mInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocalBroadcastManager getInstance(Context context) {
        Object object = mLock;
        synchronized (object) {
            if (mInstance == null) {
                mInstance = new LocalBroadcastManager(context.getApplicationContext());
            }
            return mInstance;
        }
    }

    private LocalBroadcastManager(Context context) {
        this.mAppContext = context;
        this.mHandler = new Handler(context.getMainLooper()){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        LocalBroadcastManager.this.executePendingBroadcasts();
                        break;
                    }
                    default: {
                        super.handleMessage(msg);
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        HashMap<BroadcastReceiver, ArrayList<IntentFilter>> hashMap = this.mReceivers;
        synchronized (hashMap) {
            ReceiverRecord entry = new ReceiverRecord(filter, receiver);
            ArrayList<Object> filters = this.mReceivers.get(receiver);
            if (filters == null) {
                filters = new ArrayList(1);
                this.mReceivers.put(receiver, filters);
            }
            filters.add(filter);
            for (int i = 0; i < filter.countActions(); ++i) {
                String action = filter.getAction(i);
                ArrayList<ReceiverRecord> entries = this.mActions.get(action);
                if (entries == null) {
                    entries = new ArrayList(1);
                    this.mActions.put(action, entries);
                }
                entries.add(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterReceiver(BroadcastReceiver receiver) {
        HashMap<BroadcastReceiver, ArrayList<IntentFilter>> hashMap = this.mReceivers;
        synchronized (hashMap) {
            ArrayList<IntentFilter> filters = this.mReceivers.remove(receiver);
            if (filters == null) {
                return;
            }
            for (int i = 0; i < filters.size(); ++i) {
                IntentFilter filter = filters.get(i);
                for (int j = 0; j < filter.countActions(); ++j) {
                    String action = filter.getAction(j);
                    ArrayList<ReceiverRecord> receivers = this.mActions.get(action);
                    if (receivers == null) continue;
                    for (int k = 0; k < receivers.size(); ++k) {
                        if (receivers.get((int)k).receiver != receiver) continue;
                        receivers.remove(k);
                        --k;
                    }
                    if (receivers.size() > 0) continue;
                    this.mActions.remove(action);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendBroadcast(Intent intent) {
        HashMap<BroadcastReceiver, ArrayList<IntentFilter>> hashMap = this.mReceivers;
        synchronized (hashMap) {
            ArrayList<ReceiverRecord> entries;
            boolean debug;
            String action = intent.getAction();
            String type = intent.resolveTypeIfNeeded(this.mAppContext.getContentResolver());
            Uri data = intent.getData();
            String scheme = intent.getScheme();
            Set categories = intent.getCategories();
            boolean bl = debug = (intent.getFlags() & 8) != 0;
            if (debug) {
                Log.v((String)TAG, (String)("Resolving type " + type + " scheme " + scheme + " of intent " + intent));
            }
            if ((entries = this.mActions.get(intent.getAction())) != null) {
                int i;
                if (debug) {
                    Log.v((String)TAG, (String)("Action list: " + entries));
                }
                ArrayList<ReceiverRecord> receivers = null;
                for (i = 0; i < entries.size(); ++i) {
                    String reason;
                    ReceiverRecord receiver = entries.get(i);
                    if (debug) {
                        Log.v((String)TAG, (String)("Matching against filter " + receiver.filter));
                    }
                    if (receiver.broadcasting) {
                        if (!debug) continue;
                        Log.v((String)TAG, (String)"  Filter's target already added");
                        continue;
                    }
                    int match = receiver.filter.match(action, type, scheme, data, categories, TAG);
                    if (match >= 0) {
                        if (debug) {
                            Log.v((String)TAG, (String)("  Filter matched!  match=0x" + Integer.toHexString(match)));
                        }
                        if (receivers == null) {
                            receivers = new ArrayList<ReceiverRecord>();
                        }
                        receivers.add(receiver);
                        receiver.broadcasting = true;
                        continue;
                    }
                    if (!debug) continue;
                    switch (match) {
                        case -3: {
                            reason = "action";
                            break;
                        }
                        case -4: {
                            reason = "category";
                            break;
                        }
                        case -2: {
                            reason = "data";
                            break;
                        }
                        case -1: {
                            reason = "type";
                            break;
                        }
                        default: {
                            reason = "unknown reason";
                        }
                    }
                    Log.v((String)TAG, (String)("  Filter did not match: " + reason));
                }
                if (receivers != null) {
                    for (i = 0; i < receivers.size(); ++i) {
                        ((ReceiverRecord)receivers.get((int)i)).broadcasting = false;
                    }
                    this.mPendingBroadcasts.add(new BroadcastRecord(intent, receivers));
                    if (!this.mHandler.hasMessages(1)) {
                        this.mHandler.sendEmptyMessage(1);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public void sendBroadcastSync(Intent intent) {
        if (this.sendBroadcast(intent)) {
            this.executePendingBroadcasts();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executePendingBroadcasts() {
        block3: while (true) {
            BroadcastRecord[] brs = null;
            HashMap<BroadcastReceiver, ArrayList<IntentFilter>> hashMap = this.mReceivers;
            synchronized (hashMap) {
                int N = this.mPendingBroadcasts.size();
                if (N <= 0) {
                    return;
                }
                brs = new BroadcastRecord[N];
                this.mPendingBroadcasts.toArray(brs);
                this.mPendingBroadcasts.clear();
            }
            int i = 0;
            while (true) {
                if (i >= brs.length) continue block3;
                BroadcastRecord br = brs[i];
                for (int j = 0; j < br.receivers.size(); ++j) {
                    br.receivers.get((int)j).receiver.onReceive(this.mAppContext, br.intent);
                }
                ++i;
            }
            break;
        }
    }

    private static class BroadcastRecord {
        final Intent intent;
        final ArrayList<ReceiverRecord> receivers;

        BroadcastRecord(Intent _intent, ArrayList<ReceiverRecord> _receivers) {
            this.intent = _intent;
            this.receivers = _receivers;
        }
    }

    private static class ReceiverRecord {
        final IntentFilter filter;
        final BroadcastReceiver receiver;
        boolean broadcasting;

        ReceiverRecord(IntentFilter _filter, BroadcastReceiver _receiver) {
            this.filter = _filter;
            this.receiver = _receiver;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(128);
            builder.append("Receiver{");
            builder.append(this.receiver);
            builder.append(" filter=");
            builder.append(this.filter);
            builder.append("}");
            return builder.toString();
        }
    }
}

