<?php

// +---------------------------------------------------------------------------+
// | This file is part of the Agavi package.                                   |
// | Copyright (c) 2005-2011 the Agavi Project.                                |
// |                                                                           |
// | For the full copyright and license information, please view the LICENSE   |
// | file that was distributed with this source code. You can also view the    |
// | LICENSE file online at http://www.agavi.org/LICENSE.txt                   |
// |   vi: set noexpandtab:                                                    |
// |   Local Variables:                                                        |
// |   indent-tabs-mode: t                                                     |
// |   End:                                                                    |
// +---------------------------------------------------------------------------+

/**
 * Represents any transformation that may occur for a given input.
 *
 * @package    agavi
 * @subpackage build
 *
 * @author     Noah Fontes <noah.fontes@bitextender.com>
 * @copyright  Authors
 * @copyright  The Agavi Project
 *
 * @since      1.0.0
 *
 * @version    $Id: AgaviTransform.class.php 4667 2011-05-20 12:34:58Z david $
 */
abstract class AgaviTransform
{
	/**
	 * @var        mixed The input to transform.
	 */
	protected $input = null;

	/**
	 * Sets the input.
	 *
	 * @param      mixed The input to transform.
	 *
	 * @author     Noah Fontes <noah.fontes@bitextender.com>
	 * @since      1.0.0
	 */
	public function setInput($input)
	{
		$this->input = $input;
	}

	/**
	 * Gets the input.
	 *
	 * @return     mixed The input to be transformed.
	 *
	 * @author     Noah Fontes <noah.fontes@bitextender.com>
	 * @since      1.0.0
	 */
	public function getInput()
	{
		return $this->input;
	}

	/**
	 * Transforms the input according to the parameters of the transformation.
	 *
	 * @return     mixed The result of the transformation.
	 *
	 * @author     Noah Fontes <noah.fontes@bitextender.com>
	 * @since      1.0.0
	 */
	abstract public function transform();
}

?>