#!/bin/sh -e

VERSION=$1
TAR=../jaxb-api_$VERSION.orig.tar.xz
DIR=jaxb-api-$VERSION
TAG=$(echo "jaxb-api-$VERSION" | sed -re's/~(alpha|beta)/-\1-/')

mkdir -p $DIR/src/main/java/
wget http://repo1.maven.org/maven2/javax/xml/bind/jaxb-api/$VERSION/jaxb-api-$VERSION-sources.jar
wget http://repo1.maven.org/maven2/javax/xml/bind/jaxb-api/$VERSION/jaxb-api-$VERSION.pom \
    -O $DIR/pom.xml
jar xvf jaxb-api-$VERSION-sources.jar
mv javax $DIR/src/main/java/

XZ_OPT=--best tar -c -J -f $TAR $DIR

rm -rf $DIR ../$TAG jaxb-api-$VERSION-sources.jar META-INF

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir && echo "moved $TAR to $origDir"
fi
