#ifndef _SDL_GLUE_H
#define _SDL_GLUE_H

#include <KayaAPI.h>
#include <stdfuns.h>
#include "SDL/SDL.h"

extern "C" {
  wchar_t* do_sdlerror();
  void sdl_init();
  void* do_newsurface(void* vmptr, kint x, kint y, kint bpp, kint flags);
  void do_sdlflip(void* screen);
  void* do_loadsurface(void* vmptr, wchar_t* rawfn);
  int do_sdlblit(void* srcptr, void* destptr, 
		  kint sl, kint st, kint sw, kint sh,
		  kint dl, kint dt, kint dw, kint dh);

  void* do_waitevent();
  kint event_type(void* eptr);
  kint do_getkeymod(void* eptr);
  kint do_getkeynum(void* eptr);
  kint do_getmmx(void* eptr);
  kint do_getmmy(void* eptr);
  kint do_getmbp(void* eptr);
  kint do_getmpx(void* eptr);
  kint do_getmpy(void* eptr);

  void do_sdltransparency(void* sptr, kint r, kint g, kint b, kint a);
  void do_drawrect(void* sptr, 
		   kint l, kint t, kint w, kint h,
		   kint r, kint g, kint b, kint a);

  void do_setwmtitles(wchar_t* window, wchar_t* icon);
  void do_seticon(void* icon);

}

#endif
