package latexDraw.parsers;

import java.text.ParseException;

import latexDraw.lang.LaTeXDrawLang;


/** 
 * A fatal error parsing exception occurs during the parsing
 * of a file and when the end of the file is reached whereas it is unexpected.
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 01/30/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class FatalErrorParsingException extends ParseException
{
	private static final long serialVersionUID = 1L;
	
	/** The message of the exception */
	protected String msg;
	
	
	/**
	 * The constructor by default
	 */
	public FatalErrorParsingException()
	{
		this(""); //$NON-NLS-1$
	}
	
	
	/**
	 * The constructor using a message
	 * @param message The message of the exception to display
	 */
	public FatalErrorParsingException(String message)
	{
		super(message, -1);
		msg = message==null ? "" : message;//$NON-NLS-1$
	}
	
	
	
	@Override
	public String toString()
	{
		return "<html>"+msg+LaTeXDrawLang.getString1_6("FatalErrorParsingException.0");//$NON-NLS-1$ //$NON-NLS-2$
	}
}
