package latexDraw.parsers;

/** 
 *  This class allows the management of exceptions : a command
 *  not fully managed can generate an <code>NotFullyManagedException</code>.
 *  
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE.  See the GNU General Public License for more details.<br>
 * <br>
 * 10/21/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class NotFullyManagedException extends NotYetManagedException
{
	private static final long serialVersionUID = 1L;

	
	public NotFullyManagedException(String cmd, int nl)
	{
		super(cmd, nl);
	}
	
	@Override
	public String toString()
	{
		return "Line "+ nLine + " : the command "+command+" is not yet fully managed!";//$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
	}
}
