/*
 * Copyright (c) 2007 - 2015 Joseph Gaeddert
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

//
// fftfilt_cccf_data_h7x256.c: autotest fftfilt data
//

#include <complex.h>

float complex fftfilt_cccf_data_h7x256_h[] = {
   -0.007281364501 +   0.082790547609*_Complex_I,
    0.009967260063 +  -0.094733065367*_Complex_I,
    0.081317949295 +  -0.022636219859*_Complex_I,
   -0.065424275398 +  -0.051597696543*_Complex_I,
    0.014696654677 +  -0.083596301079*_Complex_I,
   -0.061433798075 +   0.010713580251*_Complex_I,
   -0.225753474236 +   0.128715121746*_Complex_I};

float complex fftfilt_cccf_data_h7x256_x[] = {
   -0.224034833908 +  -0.008699086308*_Complex_I,
   -0.049732953310 +  -0.031826138496*_Complex_I,
    0.076697158813 +   0.011335625499*_Complex_I,
   -0.036047935486 +   0.081799823046*_Complex_I,
   -0.034496423602 +   0.116949427128*_Complex_I,
    0.041598823667 +   0.101615536213*_Complex_I,
    0.210013437271 +  -0.035565614700*_Complex_I,
   -0.012152856588 +  -0.011570352316*_Complex_I,
   -0.028147217631 +   0.166729998589*_Complex_I,
   -0.167404901981 +   0.187454140186*_Complex_I,
   -0.026512432098 +   0.261313009262*_Complex_I,
    0.102972781658 +  -0.004534423724*_Complex_I,
    0.059284800291 +   0.183526933193*_Complex_I,
    0.030326950550 +  -0.089217764139*_Complex_I,
   -0.018447282910 +  -0.049126222730*_Complex_I,
    0.113261175156 +   0.002915558405*_Complex_I,
   -0.135392773151 +   0.014876940846*_Complex_I,
    0.004361338913 +   0.021383246779*_Complex_I,
   -0.202443695068 +  -0.054077798128*_Complex_I,
   -0.004843016341 +   0.108202099800*_Complex_I,
    0.001668977737 +   0.194661521912*_Complex_I,
   -0.010195496678 +   0.196535933018*_Complex_I,
    0.034973055124 +  -0.061964601278*_Complex_I,
   -0.102277493477 +   0.223646140099*_Complex_I,
   -0.023419928551 +   0.070746564865*_Complex_I,
   -0.159975051880 +  -0.097339767218*_Complex_I,
    0.106308436394 +  -0.067826884985*_Complex_I,
    0.009907814115 +  -0.101035916805*_Complex_I,
    0.091246986389 +  -0.126393759251*_Complex_I,
    0.155365455151 +   0.032811716199*_Complex_I,
   -0.050400662422 +   0.005999959260*_Complex_I,
    0.098249650002 +   0.119454848766*_Complex_I,
    0.043273428082 +   0.037401539087*_Complex_I,
   -0.023780041933 +  -0.059200626612*_Complex_I,
   -0.123366844654 +   0.054930090904*_Complex_I,
    0.036521813273 +  -0.093353188038*_Complex_I,
   -0.127803146839 +  -0.129888510704*_Complex_I,
    0.010239485651 +  -0.006050923839*_Complex_I,
    0.073504078388 +   0.019415560365*_Complex_I,
   -0.071594107151 +   0.259088206291*_Complex_I,
   -0.164907193184 +  -0.230266833305*_Complex_I,
   -0.047658449411 +  -0.051974463463*_Complex_I,
    0.126409828663 +   0.080523037910*_Complex_I,
   -0.015694612265 +  -0.041679582000*_Complex_I,
    0.247366762161 +   0.014814090729*_Complex_I,
   -0.128671801090 +   0.043787026405*_Complex_I,
    0.059505617619 +  -0.051679652929*_Complex_I,
   -0.031817299128 +  -0.116028845310*_Complex_I,
   -0.059748482704 +   0.052395486832*_Complex_I,
    0.057849615812 +   0.112650203705*_Complex_I,
    0.024142844975 +  -0.127626419067*_Complex_I,
   -0.021054366231 +  -0.034706163406*_Complex_I,
    0.115030443668 +  -0.228685379028*_Complex_I,
    0.046825522184 +  -0.056672191620*_Complex_I,
    0.033698257804 +   0.121798670292*_Complex_I,
    0.054840600491 +  -0.057236319780*_Complex_I,
    0.099697828293 +   0.019323211908*_Complex_I,
   -0.155612981319 +  -0.004370240867*_Complex_I,
   -0.004620010406 +  -0.084638983011*_Complex_I,
    0.070532739162 +   0.011928464472*_Complex_I,
   -0.109211897850 +  -0.102859199047*_Complex_I,
   -0.081594198942 +  -0.078812837601*_Complex_I,
    0.043022164702 +  -0.170342290401*_Complex_I,
   -0.121134638786 +   0.000720720459*_Complex_I,
   -0.113152539730 +   0.049016854167*_Complex_I,
   -0.044530594349 +  -0.051119738817*_Complex_I,
    0.072675555944 +   0.022612531483*_Complex_I,
    0.079078042507 +  -0.004720374569*_Complex_I,
    0.139414632320 +  -0.062684261799*_Complex_I,
    0.047556161880 +   0.004797710106*_Complex_I,
    0.099456727505 +  -0.072699415684*_Complex_I,
    0.042401811481 +   0.080890959501*_Complex_I,
    0.153871464729 +  -0.013893789053*_Complex_I,
    0.071284359694 +   0.021137169003*_Complex_I,
   -0.167169976234 +  -0.071725249290*_Complex_I,
   -0.107850408554 +  -0.217037105560*_Complex_I,
   -0.074640941620 +  -0.056393194199*_Complex_I,
   -0.088496351242 +  -0.011706933379*_Complex_I,
   -0.055197536945 +   0.114396464825*_Complex_I,
   -0.016207906604 +   0.147190082073*_Complex_I,
    0.027984252572 +  -0.018767827749*_Complex_I,
   -0.159589684010 +  -0.021223792434*_Complex_I,
    0.258048582077 +  -0.011464864016*_Complex_I,
   -0.028931617737 +   0.055535191298*_Complex_I,
    0.090275204182 +  -0.104534256458*_Complex_I,
    0.007160897553 +  -0.012574975193*_Complex_I,
    0.074187409878 +  -0.067596536875*_Complex_I,
   -0.129586255550 +  -0.095341777802*_Complex_I,
    0.025683063269 +   0.037984248996*_Complex_I,
   -0.097140216827 +   0.072665137053*_Complex_I,
   -0.060703277588 +  -0.020677544177*_Complex_I,
   -0.111789143085 +   0.069817501307*_Complex_I,
    0.058083856106 +   0.050827920437*_Complex_I,
    0.050110381842 +  -0.096382743120*_Complex_I,
   -0.003128097579 +   0.086557382345*_Complex_I,
   -0.162541246414 +  -0.290272450447*_Complex_I,
    0.149705743790 +  -0.195581960678*_Complex_I,
   -0.037328532338 +  -0.068566280603*_Complex_I,
   -0.028459328413 +  -0.020298738778*_Complex_I,
    0.030010712147 +  -0.021110333502*_Complex_I,
    0.040339571238 +   0.037839868665*_Complex_I,
    0.014134916663 +  -0.117352914810*_Complex_I,
   -0.077330631018 +  -0.119114518166*_Complex_I,
   -0.022596450150 +   0.134884607792*_Complex_I,
    0.031885313988 +  -0.092574226856*_Complex_I,
    0.050890713930 +  -0.056063300371*_Complex_I,
   -0.065839445591 +   0.059127074480*_Complex_I,
    0.234607529640 +  -0.133058774471*_Complex_I,
    0.102069032192 +  -0.076372599602*_Complex_I,
   -0.075891935825 +  -0.020809832215*_Complex_I,
   -0.090930736065 +  -0.085748946667*_Complex_I,
    0.017342594266 +   0.031213536859*_Complex_I,
    0.038657885790 +   0.025738736987*_Complex_I,
    0.060605341196 +  -0.119861590862*_Complex_I,
    0.073895943165 +  -0.044689002633*_Complex_I,
    0.105450510979 +  -0.160455989838*_Complex_I,
   -0.124542450905 +   0.046032539010*_Complex_I,
    0.045331561565 +   0.000319873891*_Complex_I,
    0.024264129996 +   0.026674240828*_Complex_I,
   -0.105825412273 +  -0.020621740818*_Complex_I,
    0.088798046112 +  -0.188584482670*_Complex_I,
   -0.106230950356 +   0.102003884315*_Complex_I,
    0.094149869680 +   0.040696659684*_Complex_I,
   -0.034001356363 +   0.107437086105*_Complex_I,
   -0.018224966526 +   0.112718844414*_Complex_I,
    0.017100249231 +  -0.115852773190*_Complex_I,
   -0.033193737268 +  -0.000597832398*_Complex_I,
    0.000483878236 +  -0.106654667854*_Complex_I,
   -0.058922708035 +   0.047018918395*_Complex_I,
   -0.062014073133 +  -0.023304754496*_Complex_I,
    0.044369766116 +  -0.168211150169*_Complex_I,
    0.130730128288 +  -0.172116661072*_Complex_I,
    0.145810830593 +  -0.078202575445*_Complex_I,
    0.064167177677 +  -0.028775659204*_Complex_I,
   -0.080559664965 +   0.030702465773*_Complex_I,
    0.099988013506 +   0.068486881256*_Complex_I,
    0.037929025292 +  -0.016449454427*_Complex_I,
    0.170670747757 +  -0.075250750780*_Complex_I,
    0.063665509224 +   0.095736193657*_Complex_I,
   -0.004959807545 +   0.029583230615*_Complex_I,
    0.001406790875 +   0.107474470139*_Complex_I,
   -0.118572568893 +  -0.044207367301*_Complex_I,
    0.006175531074 +   0.128024518490*_Complex_I,
   -0.140851879120 +  -0.023605427146*_Complex_I,
   -0.107514488697 +   0.124532020092*_Complex_I,
    0.002869207598 +  -0.137480175495*_Complex_I,
    0.107076263428 +   0.171094465256*_Complex_I,
   -0.154599738121 +   0.276871156693*_Complex_I,
    0.101584804058 +   0.051078712940*_Complex_I,
    0.080567914248 +   0.072715389729*_Complex_I,
   -0.118250894547 +   0.203802919388*_Complex_I,
   -0.204971146584 +  -0.016665045917*_Complex_I,
   -0.066708135605 +  -0.131536126137*_Complex_I,
   -0.121210551262 +   0.006252479553*_Complex_I,
    0.061139965057 +   0.027922019362*_Complex_I,
   -0.019852848351 +   0.013758929074*_Complex_I,
    0.124678170681 +   0.068077403307*_Complex_I,
    0.114459848404 +  -0.033342263103*_Complex_I,
    0.177140033245 +  -0.072824108601*_Complex_I,
    0.044942480326 +  -0.185283625126*_Complex_I,
    0.130411398411 +   0.241176652908*_Complex_I,
    0.184130918980 +  -0.040936833620*_Complex_I,
   -0.000141406199 +   0.054715901613*_Complex_I,
   -0.069603371620 +   0.036669918895*_Complex_I,
   -0.061578559875 +   0.032855123281*_Complex_I,
    0.056589269638 +  -0.058769983053*_Complex_I,
    0.182259237766 +   0.049186679721*_Complex_I,
    0.065936774015 +   0.027898868918*_Complex_I,
   -0.065557408333 +  -0.070153760910*_Complex_I,
    0.054138237238 +  -0.027161026001*_Complex_I,
   -0.018398490548 +  -0.110003650188*_Complex_I,
    0.002755430155 +   0.078435707092*_Complex_I,
    0.013758489490 +  -0.113180506229*_Complex_I,
   -0.051234912872 +  -0.005474814028*_Complex_I,
   -0.104593336582 +   0.080550593138*_Complex_I,
    0.007267350703 +  -0.125861871243*_Complex_I,
    0.107477843761 +   0.046790626645*_Complex_I,
    0.039212217927 +  -0.116215384007*_Complex_I,
    0.124826478958 +  -0.081632637978*_Complex_I,
    0.125280117989 +   0.320632147789*_Complex_I,
   -0.007471156120 +   0.104660058022*_Complex_I,
   -0.115239381790 +  -0.076022726297*_Complex_I,
   -0.094622492790 +  -0.057151579857*_Complex_I,
   -0.168905770779 +  -0.250946950912*_Complex_I,
   -0.108807468414 +   0.001907045953*_Complex_I,
    0.070568650961 +   0.086386668682*_Complex_I,
   -0.001869313978 +   0.037941047549*_Complex_I,
   -0.025408759713 +   0.082414060831*_Complex_I,
    0.144938981533 +   0.203817605972*_Complex_I,
    0.069982367754 +   0.049768888950*_Complex_I,
    0.016490152478 +   0.074179810286*_Complex_I,
    0.105687451363 +  -0.110984444618*_Complex_I,
    0.113551545143 +   0.109880757332*_Complex_I,
   -0.057247632742 +   0.134226346016*_Complex_I,
   -0.147579395771 +   0.089595174789*_Complex_I,
   -0.066095471382 +  -0.101449275017*_Complex_I,
   -0.099719625711 +   0.069632160664*_Complex_I,
   -0.010588133335 +   0.072132295370*_Complex_I,
    0.121390247345 +   0.038519486785*_Complex_I,
   -0.018545143306 +  -0.181026077271*_Complex_I,
    0.063769525290 +  -0.064973735809*_Complex_I,
   -0.069635564089 +  -0.033288177848*_Complex_I,
   -0.191137075424 +  -0.041628292203*_Complex_I,
    0.078501302004 +   0.084461838007*_Complex_I,
    0.057879024744 +  -0.055903303623*_Complex_I,
   -0.024872413278 +  -0.012924948335*_Complex_I,
    0.030974438787 +   0.053028428555*_Complex_I,
    0.108443212509 +   0.096264117956*_Complex_I,
    0.020256328583 +   0.141622221470*_Complex_I,
   -0.014323671162 +   0.037487837672*_Complex_I,
   -0.054792886972 +  -0.018909129500*_Complex_I,
    0.112955272198 +  -0.105722856522*_Complex_I,
    0.076327735186 +  -0.023400066793*_Complex_I,
    0.050041192770 +  -0.111338639259*_Complex_I,
   -0.152574229240 +   0.112567448616*_Complex_I,
   -0.100790119171 +   0.151508641243*_Complex_I,
   -0.132981181145 +  -0.022067332268*_Complex_I,
   -0.039436492324 +  -0.142156898975*_Complex_I,
    0.272883749008 +  -0.021410278976*_Complex_I,
    0.016576641798 +   0.044247716665*_Complex_I,
   -0.043560856581 +   0.035046094656*_Complex_I,
    0.048125803471 +   0.009931682050*_Complex_I,
    0.067209833860 +   0.107492733002*_Complex_I,
   -0.046075564623 +   0.075197333097*_Complex_I,
   -0.102803206444 +   0.086919504404*_Complex_I,
    0.082356423140 +   0.014404250681*_Complex_I,
   -0.008545895666 +   0.062289041281*_Complex_I,
   -0.137773501873 +  -0.077222770452*_Complex_I,
    0.011148673296 +   0.004276630655*_Complex_I,
   -0.013848714530 +   0.030436140299*_Complex_I,
   -0.032711941004 +  -0.004091787338*_Complex_I,
   -0.068230164051 +  -0.041420990229*_Complex_I,
   -0.153997719288 +  -0.011947461963*_Complex_I,
    0.104870522022 +   0.007879497856*_Complex_I,
   -0.012260202318 +   0.097705692053*_Complex_I,
    0.105240559578 +   0.005197756737*_Complex_I,
   -0.052444481850 +   0.019592680037*_Complex_I,
   -0.111304521561 +  -0.082899254560*_Complex_I,
    0.143180394173 +   0.084308052063*_Complex_I,
   -0.081846255064 +   0.013113263249*_Complex_I,
   -0.046875402331 +   0.172497475147*_Complex_I,
   -0.101886129379 +   0.027100220323*_Complex_I,
   -0.120501518250 +  -0.011151956767*_Complex_I,
   -0.069285804033 +  -0.066505169868*_Complex_I,
    0.135213494301 +  -0.155834245682*_Complex_I,
    0.120262145996 +  -0.073802947998*_Complex_I,
    0.083161532879 +   0.151243543625*_Complex_I,
    0.032715103030 +   0.113134217262*_Complex_I,
    0.029656037688 +   0.049728840590*_Complex_I,
   -0.002572274208 +  -0.116174411774*_Complex_I,
   -0.028744161129 +   0.043948829174*_Complex_I,
   -0.039567849040 +   0.071218341589*_Complex_I,
   -0.008260916919 +  -0.064960545301*_Complex_I,
    0.065007799864 +  -0.006339413673*_Complex_I,
   -0.060093468428 +   0.035650527477*_Complex_I,
    0.056396996975 +   0.005192263052*_Complex_I};

float complex fftfilt_cccf_data_h7x256_y[] = {
    0.002351481406 +  -0.018484625365*_Complex_I,
   -0.000060077369 +   0.017251119786*_Complex_I,
   -0.023422599244 +   0.015025306572*_Complex_I,
    0.004772403706 +  -0.000066271937*_Complex_I,
    0.002043987108 +   0.022957322244*_Complex_I,
    0.006971825136 +   0.011730423896*_Complex_I,
    0.075044907061 +  -0.010178051817*_Complex_I,
    0.030543599209 +  -0.014597024085*_Complex_I,
   -0.004187564049 +  -0.012444862513*_Complex_I,
   -0.008030018509 +  -0.052716125275*_Complex_I,
   -0.014464683212 +  -0.025509129789*_Complex_I,
   -0.010946291967 +   0.010946463449*_Complex_I,
   -0.019083957948 +   0.052439959673*_Complex_I,
    0.066017066062 +  -0.011801681075*_Complex_I,
    0.012681132555 +  -0.044881829563*_Complex_I,
    0.013761162913 +  -0.101272173584*_Complex_I,
   -0.025754029961 +  -0.084604999250*_Complex_I,
   -0.029077685715 +   0.014810788777*_Complex_I,
   -0.052203914324 +  -0.045501878664*_Complex_I,
    0.002605824684 +   0.042542814124*_Complex_I,
   -0.020042313554 +   0.020106358559*_Complex_I,
   -0.001164073801 +   0.033904434250*_Complex_I,
    0.054491738690 +   0.009310176063*_Complex_I,
    0.008515506861 +  -0.011753395733*_Complex_I,
    0.094828569883 +  -0.026525642698*_Complex_I,
    0.008210310591 +  -0.020111342169*_Complex_I,
   -0.019624361168 +  -0.039339738841*_Complex_I,
   -0.014390113878 +  -0.046568094370*_Complex_I,
    0.022417994509 +   0.019882474081*_Complex_I,
   -0.042352866908 +  -0.063076024765*_Complex_I,
    0.006168688437 +  -0.049455732212*_Complex_I,
    0.024885397093 +   0.019187383987*_Complex_I,
   -0.027570701811 +   0.012482396648*_Complex_I,
    0.034892258750 +   0.024754673210*_Complex_I,
   -0.019859377031 +   0.024455238102*_Complex_I,
   -0.017573930231 +   0.012206492330*_Complex_I,
   -0.000030036343 +  -0.018861530511*_Complex_I,
   -0.047303454990 +  -0.008979343421*_Complex_I,
   -0.032862144074 +   0.013096445775*_Complex_I,
   -0.003290051529 +   0.000967363362*_Complex_I,
    0.056330016511 +  -0.016207422066*_Complex_I,
   -0.009913108504 +   0.058827181838*_Complex_I,
    0.034154084481 +  -0.006877816529*_Complex_I,
    0.020659033034 +   0.020329190951*_Complex_I,
   -0.033737500188 +   0.029784749533*_Complex_I,
   -0.014787869426 +  -0.101188110643*_Complex_I,
    0.104978906788 +   0.041126486668*_Complex_I,
   -0.014250954609 +  -0.012495039834*_Complex_I,
   -0.033482494554 +  -0.025221829498*_Complex_I,
   -0.021831072247 +   0.022276580945*_Complex_I,
   -0.039699732339 +   0.032109615994*_Complex_I,
    0.015186398989 +  -0.019223783117*_Complex_I,
    0.015617783227 +   0.023435548030*_Complex_I,
    0.008665069769 +   0.010930457080*_Complex_I,
   -0.019797730380 +  -0.050654536825*_Complex_I,
   -0.031473081271 +  -0.002299268225*_Complex_I,
   -0.012475915927 +   0.033630086770*_Complex_I,
    0.012117088154 +  -0.022047521436*_Complex_I,
    0.018953771446 +   0.084550384232*_Complex_I,
   -0.038474316372 +   0.008379280035*_Complex_I,
   -0.004152321333 +  -0.040424140749*_Complex_I,
   -0.015770397680 +   0.041094196479*_Complex_I,
   -0.032229291824 +   0.007648330888*_Complex_I,
    0.017449905676 +  -0.027618778546*_Complex_I,
   -0.006186370902 +   0.022452120667*_Complex_I,
   -0.030800615243 +   0.036816080788*_Complex_I,
    0.022326504033 +   0.029342855626*_Complex_I,
    0.033861836665 +   0.027757022091*_Complex_I,
    0.033294890809 +   0.063126561257*_Complex_I,
    0.026195622962 +  -0.034339699352*_Complex_I,
    0.036201082469 +  -0.036428336260*_Complex_I,
   -0.008587770526 +  -0.012485601384*_Complex_I,
   -0.015622310942 +  -0.008490102192*_Complex_I,
   -0.031068211782 +   0.008958937995*_Complex_I,
   -0.007527617323 +  -0.009025029679*_Complex_I,
   -0.003515003755 +   0.009061780897*_Complex_I,
   -0.050680655889 +   0.006806632206*_Complex_I,
   -0.037393296454 +  -0.018572129400*_Complex_I,
   -0.068556095005 +   0.055060185831*_Complex_I,
   -0.034772327965 +   0.025392795717*_Complex_I,
    0.068529963519 +   0.033603853922*_Complex_I,
    0.068141793595 +   0.036809357702*_Complex_I,
    0.044397919943 +   0.034591392907*_Complex_I,
    0.016558611126 +  -0.038538049919*_Complex_I,
    0.039037787845 +  -0.030382584037*_Complex_I,
   -0.047508232653 +  -0.037136167083*_Complex_I,
    0.022633104346 +  -0.021161468084*_Complex_I,
    0.019417536232 +  -0.025786181928*_Complex_I,
   -0.073279279420 +   0.029450944763*_Complex_I,
   -0.028480466565 +  -0.024506456063*_Complex_I,
    0.002785948604 +   0.049355785551*_Complex_I,
   -0.027211045311 +   0.018218457773*_Complex_I,
    0.010057004283 +   0.043364801389*_Complex_I,
    0.052591845448 +   0.024521644529*_Complex_I,
   -0.007103268409 +  -0.008581702223*_Complex_I,
    0.054820608058 +  -0.043395183529*_Complex_I,
    0.007024973331 +   0.024411987870*_Complex_I,
   -0.021388284266 +  -0.082405595490*_Complex_I,
   -0.016087426094 +   0.012722301935*_Complex_I,
   -0.051447296267 +   0.037652130140*_Complex_I,
   -0.020486080157 +  -0.013825054104*_Complex_I,
    0.077051270037 +   0.059321440673*_Complex_I,
   -0.007177045570 +   0.063268745704*_Complex_I,
   -0.007356525502 +  -0.002336907547*_Complex_I,
    0.015196504414 +   0.005533310901*_Complex_I,
   -0.020595977716 +   0.027771059823*_Complex_I,
   -0.024966648066 +  -0.018445080957*_Complex_I,
    0.039144080425 +   0.064591816908*_Complex_I,
    0.010537647232 +  -0.002822061917*_Complex_I,
    0.002315709356 +  -0.065572625222*_Complex_I,
   -0.004442911821 +   0.023522751103*_Complex_I,
   -0.037537461559 +   0.002025051546*_Complex_I,
   -0.015345245866 +  -0.018745889894*_Complex_I,
   -0.028196845561 +   0.086992050424*_Complex_I,
   -0.020218420272 +   0.034974063899*_Complex_I,
    0.039213934957 +  -0.014112442962*_Complex_I,
    0.010679269036 +  -0.019758241192*_Complex_I,
   -0.019147387264 +  -0.013125586740*_Complex_I,
   -0.043295632029 +   0.009486453379*_Complex_I,
    0.005284847258 +   0.018994059412*_Complex_I,
   -0.002085765180 +   0.059479538243*_Complex_I,
   -0.029236803469 +   0.019741499311*_Complex_I,
    0.035349982194 +  -0.019550030169*_Complex_I,
   -0.041053561980 +   0.019272334294*_Complex_I,
    0.004781302105 +  -0.011012070475*_Complex_I,
    0.045646671834 +   0.021045605276*_Complex_I,
    0.012770406300 +   0.038111716908*_Complex_I,
    0.027329675786 +  -0.046058315366*_Complex_I,
   -0.039771978581 +   0.000217202102*_Complex_I,
   -0.009660565931 +  -0.044728920362*_Complex_I,
   -0.009225975226 +   0.004924878144*_Complex_I,
    0.002703841656 +   0.032097754317*_Complex_I,
    0.004813881897 +  -0.003380733447*_Complex_I,
    0.004987905899 +   0.008151460089*_Complex_I,
   -0.013488990428 +  -0.042016257678*_Complex_I,
   -0.009691719041 +   0.004147526727*_Complex_I,
   -0.001915632244 +   0.039683487703*_Complex_I,
    0.003401771653 +   0.072636903863*_Complex_I,
   -0.039215694844 +   0.021883077630*_Complex_I,
    0.017168617098 +  -0.011912327212*_Complex_I,
   -0.007318874653 +  -0.021289530606*_Complex_I,
   -0.021564667106 +  -0.032135038803*_Complex_I,
   -0.018800999207 +   0.028531206788*_Complex_I,
   -0.021400100758 +   0.015792926127*_Complex_I,
   -0.021993149924 +   0.008754610031*_Complex_I,
    0.006936290706 +   0.000597376601*_Complex_I,
   -0.021466822342 +   0.006078512969*_Complex_I,
    0.032723812926 +  -0.038751398566*_Complex_I,
    0.024881623268 +   0.028431503514*_Complex_I,
    0.023419199688 +  -0.017541455668*_Complex_I,
    0.050912833475 +  -0.066376947294*_Complex_I,
    0.054697680345 +   0.030926451912*_Complex_I,
   -0.032668768209 +  -0.026228308942*_Complex_I,
   -0.011814848889 +  -0.099139861759*_Complex_I,
   -0.019161603567 +   0.029704427790*_Complex_I,
   -0.036750148181 +   0.005099535581*_Complex_I,
    0.009675516891 +  -0.040182618193*_Complex_I,
    0.058423255788 +  -0.009856816276*_Complex_I,
    0.059012388904 +   0.021583146036*_Complex_I,
    0.037149929970 +  -0.044837871667*_Complex_I,
   -0.043274833420 +  -0.019633669057*_Complex_I,
    0.003526349344 +  -0.033434222301*_Complex_I,
   -0.050076212918 +  -0.003722989863*_Complex_I,
   -0.025867292105 +  -0.013323971651*_Complex_I,
   -0.021737697568 +   0.042999651371*_Complex_I,
    0.007346070802 +   0.030458687290*_Complex_I,
   -0.075005823056 +  -0.018314546864*_Complex_I,
   -0.022152256082 +   0.019384502494*_Complex_I,
    0.017499070564 +  -0.019824208197*_Complex_I,
    0.001505234864 +  -0.027164808784*_Complex_I,
    0.011030624309 +  -0.041209715189*_Complex_I,
   -0.026294492121 +   0.019222017912*_Complex_I,
   -0.050856019432 +   0.008735996115*_Complex_I,
   -0.027403486053 +   0.008700019502*_Complex_I,
    0.006815542339 +  -0.009666401504*_Complex_I,
    0.006105705172 +   0.040222173395*_Complex_I,
   -0.012075903008 +   0.033397015302*_Complex_I,
    0.012019759958 +  -0.021944616302*_Complex_I,
    0.017925084955 +   0.052323963578*_Complex_I,
   -0.030587094207 +  -0.037431463625*_Complex_I,
    0.042390892393 +  -0.046071078594*_Complex_I,
    0.020356789621 +   0.037541180532*_Complex_I,
   -0.029260492422 +  -0.016824122043*_Complex_I,
    0.038403000345 +   0.018077265958*_Complex_I,
   -0.050358282861 +   0.031195025615*_Complex_I,
   -0.103007313184 +  -0.046673399500*_Complex_I,
   -0.015001996713 +   0.007412936952*_Complex_I,
    0.030614255358 +   0.024026842526*_Complex_I,
    0.030514848064 +   0.031032426681*_Complex_I,
    0.103356759873 +   0.027622431036*_Complex_I,
    0.043667006406 +  -0.014369006727*_Complex_I,
    0.002636002600 +  -0.019049360571*_Complex_I,
   -0.002989929744 +  -0.026987627040*_Complex_I,
   -0.001094610254 +  -0.070463253033*_Complex_I,
   -0.052461850294 +  -0.027889438408*_Complex_I,
   -0.019216539397 +  -0.007771079643*_Complex_I,
   -0.022329844508 +  -0.013265024739*_Complex_I,
   -0.001032810892 +   0.043621747952*_Complex_I,
   -0.037166418731 +   0.024063055407*_Complex_I,
    0.025171222560 +  -0.045359590807*_Complex_I,
    0.034025739768 +  -0.022421529929*_Complex_I,
    0.025417150018 +  -0.024301770390*_Complex_I,
    0.015009353323 +  -0.045864470900*_Complex_I,
   -0.057523653826 +   0.003583092215*_Complex_I,
   -0.034434260403 +   0.016881949843*_Complex_I,
    0.035644457860 +   0.058158734255*_Complex_I,
   -0.011112332655 +   0.028514917481*_Complex_I,
    0.027994412412 +  -0.000205339299*_Complex_I,
    0.041965151118 +  -0.028140201223*_Complex_I,
   -0.010670315886 +  -0.004680002358*_Complex_I,
    0.008782107185 +   0.015284218025*_Complex_I,
    0.025707610980 +  -0.002674567128*_Complex_I,
   -0.018895101407 +  -0.019624170860*_Complex_I,
   -0.019911769609 +  -0.024108802516*_Complex_I,
   -0.050134730896 +  -0.049361961836*_Complex_I,
   -0.012519484934 +  -0.027194287781*_Complex_I,
    0.005428457404 +   0.015715697375*_Complex_I,
   -0.005238127738 +   0.060099693736*_Complex_I,
   -0.019908892893 +   0.058463294088*_Complex_I,
    0.020429924866 +   0.006302169131*_Complex_I,
    0.039448100593 +  -0.046219948910*_Complex_I,
   -0.015700342290 +  -0.047106832460*_Complex_I,
    0.029509140574 +  -0.026543641019*_Complex_I,
    0.028367751154 +   0.020535031374*_Complex_I,
   -0.052572208167 +   0.041630709393*_Complex_I,
   -0.001077487262 +  -0.000376269684*_Complex_I,
    0.009826813537 +  -0.019618490100*_Complex_I,
    0.019631481777 +  -0.007463103449*_Complex_I,
   -0.034282389268 +   0.002382911984*_Complex_I,
   -0.002559574060 +  -0.045197738751*_Complex_I,
    0.021242907296 +  -0.020034144666*_Complex_I,
   -0.026802493199 +   0.013457289582*_Complex_I,
    0.000954596220 +  -0.020243773142*_Complex_I,
    0.034013053731 +   0.024387771984*_Complex_I,
   -0.020040092793 +  -0.001711964654*_Complex_I,
    0.022898948260 +   0.014147183418*_Complex_I,
    0.004346236707 +  -0.000881433760*_Complex_I,
    0.056049489865 +  -0.020165330024*_Complex_I,
    0.010340548926 +   0.003943868642*_Complex_I,
   -0.020562812005 +  -0.025528198571*_Complex_I,
   -0.012419521606 +  -0.000626407753*_Complex_I,
   -0.026985254984 +   0.006236327937*_Complex_I,
    0.035672449990 +   0.000476818088*_Complex_I,
    0.034040270392 +   0.009473149874*_Complex_I,
   -0.021617320834 +   0.027702717665*_Complex_I,
    0.010577232861 +  -0.016439967770*_Complex_I,
   -0.018705783473 +  -0.051973816043*_Complex_I,
    0.017231348174 +  -0.025014597024*_Complex_I,
    0.027788678270 +  -0.014081809821*_Complex_I,
    0.035390113297 +  -0.001427819683*_Complex_I,
   -0.010424664995 +   0.044346140061*_Complex_I,
   -0.018385369373 +   0.007862320395*_Complex_I,
   -0.032248235088 +  -0.015582515953*_Complex_I,
   -0.037693834890 +  -0.014701063462*_Complex_I,
   -0.006787010773 +  -0.016420585935*_Complex_I,
    0.026470441729 +   0.040610897283*_Complex_I};

