package tests::ConfigDlfStreamSpecTest;

use strict;

use tests::ConfigSpecTest;

use base qw/tests::ConfigTypeSpecBase/;

use Lire::Config::DlfStreamSpec;
use Lire::Config::ConfigSpec;
use Lire::PluginManager;
use Lire::DlfAnalyser;
use Lire::Test::Mock;

sub new {
    my $self = shift->SUPER::new( @_ );
    return $self;
}

sub set_up {
    my $self = $_[0];

    $self->SUPER::set_up();

    $self->{'test1'} = new_proxy Lire::Test::Mock( 'Lire::DlfAnalyser' );
    $self->{'test1'}->set_result( 'name' => 'test1-analyser',
                                  'src_schema' => 'test',
                                  'dst_schema' => 'test-extended',
                                  'title' => 'Test 1 Analyser',
                                  'description' =>
                                  '<para>Description.</para>' );

    $self->{'test2'} = new_proxy Lire::Test::Mock( 'Lire::DlfAnalyser' );
    $self->{'test2'}->set_result( 'name' => 'test2-analyser',
                                  'src_schema' => 'test',
                                  'dst_schema' => 'test-extended',
                                  'title' => 'Test 2 Analyser',
                                  'description' =>
                                  '<para>Description 2.</para>' );
    $self->{'test3'} = new_proxy Lire::Test::Mock( 'Lire::DlfAnalyser' );
    $self->{'test3'}->set_result( 'name' => 'test3-analyser',
                                  'src_schema' => 'other',
                                  'dst_schema' => 'test-extended',
                                  'title' => 'Test 3 Analyser',
                                  'description' =>
                                  '<para>Description 3.</para>' );
    $self->{'test4'} = new_proxy Lire::Test::Mock( 'Lire::DlfAnalyser' );
    $self->{'test4'}->set_result( 'name' => 'test4-analyser',
                                  'src_schema' => 'test',
                                  'dst_schema' => 'test-another',
                                  'title' => 'Test 4 Analyser',
                                  'description' =>
                                  '<para>Description 4.</para>' );

    $self->set_up_plugin_mgr();
    foreach my $key ( qw/test1 test2 test3 test4/ ) {
        Lire::PluginManager->register_plugin( $self->{$key} );
    }

    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    return;
}

sub set_up_spec {
    my $self = $_[0];

    $self->{'cfg'}{'_lr_config_spec'} = new Lire::Config::ConfigSpec();
    $self->SUPER::set_up_spec();

    return;
}

sub type {
    return 'Lire::Config::DlfStreamSpec';
}

sub test_new {
    my $self = $_[0];

    # We cannot uses SUPER::test_new() because we override summary()
    # and description.

    my $spec = new Lire::Config::DlfStreamSpec( 'name' => 'test' );
    my $components = [ $spec->components() ];
    $self->assert_num_equals( 3, scalar @$components );
    $self->assert_isa( 'Lire::Config::IntegerSpec', $components->[0] );
    $self->assert_str_equals( 'keep_days', $components->[0]->name() );
    my $keep_days_dflt = new Lire::Config::Scalar( 'spec' => $components->[0],
                                                   'value' => 60 );
    $self->assert_deep_equals( $keep_days_dflt, $components->[0]->default() );

    $self->assert_isa( 'Lire::Config::DlfAnalyserSpec', $components->[1] );
    $self->assert_str_equals( 'test', $components->[1]->src_schema() );
    $self->assert_str_equals( 'test-another', $components->[1]->name() );
    $self->assert_isa( 'Lire::Config::DlfAnalyserSpec', $components->[2] );
    $self->assert_str_equals( 'test-extended', $components->[2]->name() );
}

sub test__extension_schemas {
    my $self = $_[0];

    my $spec = new Lire::Config::DlfStreamSpec( 'name' => 'test' );
    $self->assert_deep_equals( [ 'test-another', 'test-extended' ],
                               $spec->_extension_schemas() );
}

1;

