/*
 * @(#)MouseMovedCaptureEvent.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.uicapture.v1.event;

import java.awt.Robot;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;


/**
 * An event object which stores a capture event.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   Jan 4, 2002
 */
public class MouseMovedCaptureEvent extends MouseCaptureEvent
{
    /**
     * @serial
     */
    private int x = -1;
    
    /**
     * @serial
     */
    private int y = -1;
    
    public MouseMovedCaptureEvent( MouseEvent event )
    {
        super( CE_MOUSE_MOVED, event );
        
        this.x = event.getX();
        this.y = event.getY();
    }
    
    
    public MouseMovedCaptureEvent( int x, int y )
    {
        super( CE_MOUSE_MOVED );
        
        this.x = x;
        this.y = y;
    }
    
    
    public int getX()
    {
        return this.x;
    }
    
    
    public int getY()
    {
        return this.y;
    }
    
    
    /**
     * Reenacts the event that this CaptureEvent represents underneath it
     * all.
     */
    public void performEvent( Robot r )
    {
        super.performEvent( r );
        r.mouseMove( getX(), getY() );
    }
}

