/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

// This is the ideal state of our ESLint config that we'll use for open source
// projects. It doesn't reflect the current state of our internal code base as
// it is, but as it would be if it were created today.

const globals = require('fbjs-eslint-utils/globals');
const maxLenIgnorePattern = require('fbjs-eslint-utils/shared').maxLenIgnorePattern;

module.exports = {

  parser: '@babel/eslint-parser',

  parserOptions: {
    ecmaVersion: 7,
    sourceType: 'module',
    ecmaFeatures: {
      globalReturn: true,
      jsx: true,
      experimentalObjectRestSpread: true,
    },
  },

  env: {
    atomtest: true,
    browser: true,
    es6: true,
    jasmine: true,
    jest: true,
    node: true,
  },

  globals: Object.assign({
    atom: false,
    document: false,
    window: false,
    HTMLElement: false,
    WebSocket: false,
  }, globals),

  rules: {
    // Possible Errors (http://eslint.org/docs/rules/#possible-errors)
    'no-cond-assign': 1,
    'no-console': 1,
    'no-constant-condition': [1, {checkLoops: false}],
    'no-control-regex': 1,
    'no-debugger': 2,
    'no-dupe-args': 2,
    'no-dupe-keys': 2,
    'no-duplicate-case': 1,
    'no-empty': [1, {allowEmptyCatch: true}],
    'no-empty-character-class': 1,
    'no-ex-assign': 1,
    'no-extra-boolean-cast': 1,
    'no-extra-parens': 0,
    'no-extra-semi': 1,
    'no-func-assign': 2,
    'no-inner-declarations': 1,
    'no-invalid-regexp': 1,
    'no-irregular-whitespace': 1,
    'no-obj-calls': 2,
    'no-prototype-builtins': 0,
    'no-regex-spaces': 1,
    'no-sparse-arrays': 2,
    'no-template-curly-in-string': 0,
    'no-unexpected-multiline': 1,
    'no-unreachable': 2,
    'no-unsafe-finally': 1,
    'no-unsafe-negation': 2,
    'use-isnan': 2,
    'valid-jsdoc': 0,
    'valid-typeof': 2,

    // Best Practices (http://eslint.org/docs/rules/#best-practices)
    'accessor-pairs': [1, {setWithoutGet: true}],
    'array-callback-return': 1,
    'block-scoped-var': 0,
    'class-methods-use-this': 0,
    'complexity': 0,
    'consistent-return': 1,
    'curly': 1,
    'default-case': 0,
    'dot-location': [1, 'property'],
    'dot-notation': 1,
    'eqeqeq': [1, 'allow-null'],
    'guard-for-in': 0,
    'no-alert': 1,
    'no-await-in-loop': 1,
    'no-caller': 2,
    'no-case-declarations': 1,
    'no-div-regex': 1,
    'no-else-return': 0,
    'no-empty-function': 0,
    'no-empty-pattern': 1,
    'no-eq-null': 0,
    'no-eval': 2,
    'no-extend-native': 1,
    'no-extra-bind': 1,
    'no-extra-label': 1,
    'no-fallthrough': 1,
    'no-floating-decimal': 2,
    'no-global-assign': [2],
    'no-implicit-coercion': 0,
    'no-implicit-globals': 0,
    'no-implied-eval': 2,
    'no-invalid-this': 0,
    'no-iterator': 1,
    'no-labels': [2, {allowLoop: true, allowSwitch: true}],
    'no-lone-blocks': 1,
    'no-loop-func': 0,
    'no-magic-numbers': 0,
    'no-multi-spaces': [1, {exceptions: {Property: true}}],
    'no-multi-str': 2,
    'no-new-func': 2,
    'no-new-wrappers': 1,
    'no-new': 1,
    'no-octal': 1,
    'no-octal-escape': 1,
    'no-param-reassign': 1,
    'no-proto': 2,
    'no-redeclare': [1, {builtinGlobals: true}],
    'no-restricted-properties': 0,
    'no-return-assign': 1,
    'no-return-await': 0,
    'no-script-url': 2,
    'no-self-assign': 1,
    'no-self-compare': 1,
    'no-sequences': 1,
    'no-throw-literal': 1,
    'no-unmodified-loop-condition': 0,
    'no-unused-expressions': 0, // allowShortCircuit?
    'no-unused-labels': 1,
    'no-useless-call': 1,
    'no-useless-concat': 1,
    'no-useless-escape': 1,
    'no-useless-return': 1,
    'no-void': 1,
    'no-warning-comments': 0,
    'no-with': 1,
    'radix': 1,
    'require-await': 1,
    'vars-on-top': 0,
    'wrap-iife': [1, 'inside'],
    'yoda': 1,

    // Strict Mode (http://eslint.org/docs/rules/#strict-mode)
    'strict': 1,

    // Variables (http://eslint.org/docs/rules/#variables)
    'init-declarations': 0,
    'no-catch-shadow': 2,
    'no-delete-var': 2,
    'no-label-var': 1,
    'no-restricted-globals': 0,
    'no-shadow-restricted-names': 1,
    'no-shadow': 1,
    'no-undef-init': 0,
    'no-undef': 2,
    'no-undefined': 0,
    'no-unused-vars': [1, {args: 'none'}],
    'no-use-before-define': 0,

    // Node.js and CommonJS (http://eslint.org/docs/rules/#nodejs-and-commonjs)
    'callback-return': 0,
    'global-require': 0,
    'handle-callback-err': 1,
    'no-mixed-requires': 0,
    'no-new-require': 1,
    'no-path-concat': 1,
    'no-process-env': 0,
    'no-process-exit': 0,
    'no-restricted-modules': 0,
    'no-sync': 0,

    // Stylistic Issues (http://eslint.org/docs/rules/#stylistic-issues)
    'array-bracket-spacing': 1,
    'block-spacing': 1,
    'brace-style': [1, '1tbs', {allowSingleLine: true}],
    'camelcase': [1, {properties: 'always'}],
    'capitalized-comments': 0,
    'comma-dangle': [1, {arrays: 'always-multiline', objects: 'always-multiline', imports: 'always-multiline', exports: 'always-multiline', functions: 'always-multiline'}],
    'comma-spacing': 1,
    'comma-style': 1,
    'computed-property-spacing': 1,
    'consistent-this': 0,
    'eol-last': 1,
    'func-call-spacing': 1,
    'func-name-matching': 0,
    'func-names': 0,
    'func-style': 0,
    'id-blacklist': 0,
    'id-length': 0,
    'id-match': 0,
    'indent': [1, 2, {SwitchCase: 1}],
    'jsx-quotes': [1, 'prefer-double'],
    'key-spacing': [1, {beforeColon: false, afterColon: true}],
    'keyword-spacing': 1,
    'line-comment-position': 0,
    'linebreak-style': 1,
    'lines-around-comment': 0,
    'lines-around-directive': 0,
    'max-depth': 0,
    'max-len': [1, 120, {tabWidth: 2, ignoreUrls: true, ignorePattern: maxLenIgnorePattern}],
    'max-lines': 0,
    'max-nested-callbacks': 0,
    'max-params': 0,
    'max-statements': 0,
    'max-statements-per-line': 0,
    'multiline-ternary': 0,
    'new-cap': 0,
    'new-parens': 2,
    'newline-after-var': 0,
    'newline-before-return': 0,
    'newline-per-chained-call': 0,
    'no-array-constructor': 1,
    'no-bitwise': 1,
    'no-continue': 0,
    'no-inline-comments': 0,
    'no-lonely-if': 0,
    'no-mixed-operators': 0,
    'no-mixed-spaces-and-tabs': 2,
    'no-multiple-empty-lines': [1, {max: 2, maxBOF: 0, maxEOF: 1}],
    'no-negated-condition': 0,
    'no-nested-ternary': 0,
    'no-new-object': 1,
    'no-plusplus': 0,
    'no-restricted-syntax': 0,
    'no-tabs': 2,
    'no-ternary': 0,
    'no-trailing-spaces': 1,
    'no-underscore-dangle': 0,
    'no-unneeded-ternary': 1,
    'no-whitespace-before-property': 1,
    'object-curly-newline': 0,
    'object-curly-spacing': 1,
    'object-property-newline': 0,
    'one-var-declaration-per-line': 0,
    'one-var': [1, {initialized: 'never'}],
    'operator-assignment': 1,
    'operator-linebreak': 0,
    'padded-blocks': 0,
    'quote-props': [1, 'consistent-as-needed'],
    'quotes': [1, 'single', 'avoid-escape'],
    'require-jsdoc': 0,
    'semi-spacing': 1,
    'semi': 1,
    'sort-keys': 0,
    'sort-vars': 0,
    'space-before-blocks': 1,
    'space-before-function-paren': [1, {anonymous: 'never', named: 'never', asyncArrow: 'always'}],
    'space-in-parens': [1, 'never'],
    'space-infix-ops': [1, {int32Hint: true}],
    'space-unary-ops': [1, {words: true, nonwords: false}],
    'spaced-comment': [1, 'always', {line: {exceptions: ['-', 'eslint', 'global']}, block: {balanced: true}}],
    'unicode-bom': [1, 'never'],
    'wrap-regex': 0,

    // ECMAScript 6 (http://eslint.org/docs/rules/#ecmascript-6)
    'arrow-body-style': 0,
    'arrow-parens': [1, 'as-needed'],
    'arrow-spacing': 1,
    'constructor-super': 2,
    'generator-star-spacing': 1,
    'no-class-assign': 1,
    'no-confusing-arrow': [1, {allowParens: true}],
    'no-const-assign': 2,
    'no-dupe-class-members': 2,
    'no-duplicate-imports': 1,
    'no-new-symbol': 1,
    'no-restricted-imports': 0,
    'no-this-before-super': 2,
    'no-useless-computed-key': 1,
    'no-useless-constructor': 1,
    'no-var': 1,
    'no-useless-rename': 1,
    'object-shorthand': 1,
    'prefer-arrow-callback': [1, {allowNamedFunctions: true}],
    'prefer-const': 1,
    'prefer-numeric-literals': 0,
    'prefer-rest-params': 1,
    'prefer-spread': 1,
    'prefer-template': 0,
    'require-yield': 0,
    'rest-spread-spacing': 1,
    'sort-imports': 0,
    'symbol-description': 1,
    'template-curly-spacing': 1,
    'yield-star-spacing': 1,

    // Babel (https://github.com/babel/eslint-plugin-babel)
    'babel/new-cap': 0,
    'babel/object-curly-spacing': 0,
    'babel/no-invalid-this': 0,
    'babel/no-await-in-loop': 0, // deprecated; now using 'no-await-in-loop' from eslint core

    // ft-flow (https://github.com/flow-typed/eslint-plugin-ft-flow)
    'ft-flow/boolean-style': 1,
    'ft-flow/define-flow-type': 1,
    'ft-flow/delimiter-dangle': [1, 'always-multiline'],
    'ft-flow/generic-spacing': 1,
    'ft-flow/no-dupe-keys': 1,
    'ft-flow/no-primitive-constructor-types': 1,
    'ft-flow/no-weak-types': 1,
    'ft-flow/object-type-delimiter': 1,
    'ft-flow/require-parameter-type': 0,
    'ft-flow/require-return-type': 0,
    'ft-flow/require-valid-file-annotation': 0,
    'ft-flow/require-variable-type': 0,
    'ft-flow/semi': 1,
    'ft-flow/sort-keys': 0,
    'ft-flow/space-after-type-colon': [1, 'always'],
    'ft-flow/space-before-generic-bracket': 1,
    'ft-flow/space-before-type-colon': 1,
    'ft-flow/type-id-match': 0,
    'ft-flow/union-intersection-spacing': 1,
    'ft-flow/use-flow-type': 1,
    'ft-flow/valid-syntax': 0,

    // Jasmine (https://github.com/tlvince/eslint-plugin-jasmine)
    'jasmine/missing-expect': 0,
    'jasmine/named-spy': 0,
    'jasmine/no-assign-spyon': 0,
    'jasmine/no-disabled-tests': 1,
    'jasmine/no-focused-tests': 2,
    'jasmine/no-spec-dupes': [1, 'branch'],
    'jasmine/no-suite-callback-args': 0,
    'jasmine/no-suite-dupes': [1, 'branch'],
    'jasmine/no-unsafe-spy': 1,
    'jasmine/no-global-setup': 1,
    'jasmine/valid-expect': 0,

    // prefer-object-spread (https://github.com/bryanrsmith/eslint-plugin-prefer-object-spread)
    'prefer-object-spread/prefer-object-spread': 1,

    // React (https://github.com/yannickcr/eslint-plugin-react)
    'react/display-name': 0,
    'react/forbid-component-props': 0,
    'react/forbid-prop-types': 0,
    'react/no-children-prop': 0,
    'react/no-danger': 0,
    'react/no-danger-with-children': 0,
    'react/no-deprecated': 1,
    'react/no-did-mount-set-state': 0,
    'react/no-did-update-set-state': 0,
    'react/no-direct-mutation-state': 1,
    'react/no-find-dom-node': 0,
    'react/no-is-mounted': 1,
    'react/no-multi-comp': 0,
    'react/no-render-return-value': 0,
    'react/no-set-state': 0,
    'react/no-string-refs': 0,
    'react/no-unescaped-entities': 0,
    'react/no-unknown-property': 1,
    'react/no-unused-prop-types': 0,
    'react/prefer-es6-class': 0,
    'react/prefer-stateless-function': 0,
    'react/prop-types': 1,
    'react/react-in-jsx-scope': 1,
    'react/require-optimization': 0,
    'react/require-render-return': 0,
    'react/self-closing-comp': 1,
    'react/sort-comp': 0,
    'react/sort-prop-types': 0,
    'react/style-prop-object': 0,
    'react/jsx-boolean-value': 0,
    'react/jsx-closing-bracket-location': [1, {selfClosing: 'tag-aligned', nonEmpty: 'after-props'}],
    'react/jsx-curly-spacing': [1, 'never'],
    'react/jsx-equals-spacing': [1, 'never'],
    'react/jsx-filename-extension': 0,
    'react/jsx-first-prop-new-line': 0,
    'react/jsx-handler-names': 0,
    'react/jsx-indent': [1, 2],
    'react/jsx-indent-props': [1, 2],
    'react/jsx-key': 1,
    'react/jsx-max-props-per-line': 0,
    'react/jsx-no-bind': 0,
    'react/jsx-no-comment-textnodes': 1,
    'react/jsx-no-duplicate-props': 2,
    'react/jsx-no-literals': 0,
    'react/jsx-no-target-blank': 0,
    'react/jsx-no-undef': 2,
    'react/jsx-pascal-case': 0,
    'react/jsx-sort-props': 0,
    'react/jsx-tag-spacing': [1, {beforeSelfClosing: 'always'}],
    'react/jsx-uses-react': 1,
    'react/jsx-uses-vars': 1,
    'react/jsx-wrap-multilines': 1,
  },

  plugins: [
    'babel',
    'ft-flow',
    'jasmine',
    'prefer-object-spread',
    'react',
  ],
};
