# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1708-1 (git-core)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63222);
 script_cve_id("CVE-2008-5516", "CVE-2008-5517");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1708-1 (git-core)";
 script_name(name);

 desc = "The remote host is missing an update to git-core
announced via advisory DSA 1708-1.

It was discovered that gitweb, the web interface for the Git version
control system, contained several vulnerabilities:

Remote attackers could use crafted requests to execute shell commands on
the web server, using the snapshot generation and pickaxe search
functionality (CVE-2008-5516).

Local users with write access to the configuration of a Git repository
served by gitweb could cause gitweb to execute arbitrary shell commands
with the permission of the web server (CVE-2008-5517).

For the stable distribution (etch), these problems have been fixed in
version 1.4.4.4-4+etch1.

For the unstable distribution (sid) and testing distribution (lenny),
the remote shell command injection issuei (CVE-2008-5516) has been fixed
in version 1.5.6-1.  The other issue will be fixed soon.

We recommend that you upgrade your Git packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201708-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1708-1 (git-core)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gitweb", ver:"1.4.4.4-4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-daemon-run", ver:"1.4.4.4-4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-svn", ver:"1.4.4.4-4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gitk", ver:"1.4.4.4-4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-doc", ver:"1.4.4.4-4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-email", ver:"1.4.4.4-4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-arch", ver:"1.4.4.4-4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-cvs", ver:"1.4.4.4-4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"git-core", ver:"1.4.4.4-4+etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
