# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1887-1 (rails)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64919);
 script_cve_id("CVE-2009-3009");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.3");
 script_tag(name:"risk_factor", value:"Medium");
 script_name("Debian Security Advisory DSA 1887-1 (rails)");

 desc = "The remote host is missing an update to rails
announced via advisory DSA 1887-1.


Brian Mastenbrook discovered that rails, the MVC ruby based framework
geared for web application development, is prone to cross-site scripting
attacks via malformed strings in the form helper.


For the stable distribution (lenny), this problem has been fixed in
version 2.1.0-7.

For the oldstable distribution (etch) security support has been
discontinued. It has been reported that rails in oldstable is unusable
and several features that are affected by security issues are broken due
to programming issues. It is highly recommended to upgrade to the
version in stable (lenny).

For the testing distribution (squeeze) and the unstable distribution
(sid), this problem has been fixed in version 2.2.3-1.


We recommend that you upgrade your rails packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201887-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1887-1 (rails)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"rails", ver:"2.1.0-7", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
