##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ftpshell_client_detect.nasl 5061 2009-09-30 16:54:10Z sep $
#
# FTPShell Client Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900961);
  script_version("$Revision: 1.0$");
  script_tag(name:"risk_factor", value:"None");
  script_name("FTPShell Client Version Detection");
  desc = "
  Overview: This script detects the installed version of FTPShell Client
  and sets the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Set the KB for the version of FTPShell Client");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

if(!registry_key_exists(key:key)){
    exit(0);
}

foreach item (registry_enum_keys(key:key))
{
  fclntName = registry_get_sz(key:key + item, item:"DisplayName");

  if("FTPShell Client" >< fclntName)
  {
    fclntPath = registry_get_sz(key:key + item, item:"UninstallString");
    fclntPath = ereg_replace(pattern:'\"(.*)\"',replace:"\1",string:fclntPath);
    fclntPath = fclntPath - 'unins000.exe' + 'readme.txt';

    if(isnull(fclntPath)){
      exit(0);
    }

    share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:fclntPath);
    file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:fclntPath);
    readmeText = read_file(share:share, file:file, offset:0, count:500);

    if(readmeText)
    {
      shellVer = eregmatch(pattern:"Version +: ([0-9.]+).?([a-zA-Z]+.?[0-9]+)?",
                           string:readmeText);
      if(!isnull(shellVer[1]))
      {
        if(!isnull(shellVer[2]))
        {
          shellVer[2] = ereg_replace(pattern:" ",string:shellVer[2],replace:"");
          shellVer = shellVer[1] + "." + shellVer[2];
        }
        else
           shellVer = shellVer[1];

        if(shellVer){
          set_kb_item(name:"FTPShell/Client/Ver", value:shellVer);
          security_note(data:"FTPShell Client version " + shellVer +
                             " was detected on the host");
        }
      }
    }
  }
}
