##############################################################################
#
#  RealVNC vncviewer.exe Remote DoS Vulnerability (Win)
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/04
#
#  Revision: 1.1 
#
#  Log: schandan
#  Issue #0081
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
 script_id(900019);
 script_cve_id("CVE-2008-3493");
 script_bugtraq_id(30499);
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("$Revision: 1.2 $");
 script_tag(name:"cvss_base", value:"4.3");
 script_tag(name:"risk_factor", value:"Medium");
 script_category(ACT_GATHER_INFO);
 script_family("Denial of Service");
 script_name("RealVNC vncviewer.exe Remote DoS Vulnerability (Win)");
 script_summary("Check for the version of RealVNC");
 desc = " 
 Overview : This host is installed with RealVNC product, which is prone to
 denial of service vulnerability.

 Vulnerability Insight :

        The flaw is caused due to lack of adequate boundary check while
        parsing user supplied data. 

        Impact : Remote attacker can cause application to crash,
        denying the service, and also can execute arbitrary code.

 Impact Level : Application.

 Affected Software/OS :
        RealVNC 4.1.2 and prior on Windows (All).

 Fix : Upgrade to RealVNC Version 4.5.3 or later
 For updates refer, http://www.realvnc.com/

 References : http://www.securityfocus.com/bid/30499/discuss

 CVSS Score :
        CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
        CVSS Temporal Score : 3.9
 Risk factor : Medium";
 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl", "find_service.nes");
 script_require_keys("SMB/WindowsVersion");
 script_require_ports("Services/vnc", 139, 445);
 exit(0);
}


 include("smb_nt.inc");

 vncPort = get_kb_item("Services/vnc");
 if(!vncPort){
	vncPort = 5900;
 }

 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 vncVer = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
 			      "\Uninstall\WinVNC_is1",
		 	  item:"DisplayVersion");
 if(!vncVer){
	vncVer = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
			             "\Uninstall\RealVNC_is1",
				 item:"DisplayVersion");
 }

 if(!vncVer){
	exit(0);
 }

 if(ereg(pattern:"^([0-3]\..*|4\.(0\..*|1\.[0-2]))$", string:vncVer)){
	security_warning(vncPort);
 }
