% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flextable_sizes.R
\name{fit_to_width}
\alias{fit_to_width}
\title{Fit a flextable to a maximum width}
\usage{
fit_to_width(x, max_width, inc = 1L, max_iter = 20, unit = "in")
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{max_width}{maximum width to fit in inches}

\item{inc}{the font size decrease for each step}

\item{max_iter}{maximum iterations}

\item{unit}{unit for max_width, one of "in", "cm", "mm".}
}
\description{
decrease font size for each cell incrementally until
it fits a given max_width.
}
\examples{
ft_1 <- qflextable(head(mtcars))
ft_1 <- width(ft_1, width = 1)
ft_1

ft_2 <- fit_to_width(ft_1, max_width = 4)
ft_2
}
\seealso{
Other functions for flextable size management: 
\code{\link{autofit}()},
\code{\link{dim.flextable}()},
\code{\link{dim_pretty}()},
\code{\link{flextable_dim}()},
\code{\link{height}()},
\code{\link{hrule}()},
\code{\link{ncol_keys}()},
\code{\link{nrow_part}()},
\code{\link{width}()}
}
\concept{functions for flextable size management}
