% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/props.R
\name{props}
\alias{is.ggvis_props}
\alias{props}
\title{Manage a list of properties.}
\usage{
props(..., .props = NULL, inherit = TRUE, env = parent.frame())

is.ggvis_props(x)
}
\arguments{
\item{...}{A set of name-value pairs. The name should be a valid vega
  property.

  The first two unnamed components are taken to be \code{x} and \code{y}.
  Any additional unnamed components will raise an error.}

\item{.props}{When calling \code{props} from other functions, you'll
often have a list of quoted function functions. You can pass that function
to the \code{.props} argument instead of messing around with
substitute. In other words, \code{.props} lets you opt out of the
non-standard evaluation that \code{props} does.}

\item{inherit}{If \code{TRUE}, the defaults, will inherit from properties
from the parent layer If \code{FALSE}, it will start from nothing.}

\item{env}{The environment in which to evaluate variable properties.}

\item{x}{an object to test for props-ness.}
}
\description{
\code{props()} provides a tool for concise creation of \code{prop} objects
using a set of conventions designed to capture the most common use cases.
If you need something less common, you'll need to use \code{\link{prop}} to
access all possible options.
}
\section{Heuristics}{


If the values are not already objects of class \code{prop}, \code{props}
uses the following heuristics to when creating the prop:

\itemize{
 \item atomic vectors, e.g. \code{x = 1}: scaled = FALSE
 \item an interative input, e.g. \code{x = input_slider}:
    scaled = FALSE
 \item a formula containing a single value, e.g. \code{x ~ 1}:
    scaled = TRUE
 \item a formula containing a name or expression, \code{x ~ mpg}:
    scaled = TRUE
}
}

\section{Non-standard evaluation}{


\code{props} uses non-standard evaluation in a slightly unusual way:
if you provide a formula input, the LHS of the formula will provide the
name of the component. In otherwise, \code{props(x = y ~ 1)} is the
same as \code{props(y ~ 1)}.

You can combine variables from the dataset and variables defined in the
local environment: expressions will be evaluated in the environment which
the formula was defined.

If you have the name of a variable in a string, see the
props vignette for how to create the needed property mapping.
}

\section{Enter, exit, hover, and update events}{


There are four different property events that the marks
can use. These can, for example, be used to change the appearance of a mark
when the mouse cursor is hovering over it: when the mark is hovered over, it
uses the hover event, and when the mark isn't hovered over, it uses the
update event

\itemize{
  \item enter: This event is used by marks when they are added to a plot.
  \item update: This event is used by marks after they have entered, and
    also after they have been hovered over.
  \item exit: This event is used by marks as they are removed from a plot.
  \item hover: This event is used when the mouse cursor is over the mark.
}

You can specify the event for a property, by putting a period and the
event after the property name. For example,
\code{props(fill.update := "black", fill.hover := "red")} will make a mark
have a black fill normally, and red fill when it is hovered over.

The default event is update, so if you run \code{props(fill := "red")},
this is equivalent to \code{props(fill.update := "red")}.

In practice, the enter and exit events are useful only when the update has
a duration (and is therefore not instantaneous). The update event can be
thought of as the "default" state.
}

\section{Key property}{


In addition to the standard properties, there is a special optional property
called \code{key}. This is useful for plots with dynamic data and smooth
transitions: as the data changes, the key is used to tell the plot how the
new data rows should be matched to the old data rows. Note that the key must
be an unscaled value. Additionally, the key property doesn't have a event,
since it is independent of enter, update, exit, and hover events.
}

\section{Properties}{


You can set the following mark properties:

\itemize{
\item  x  The first (typically left-most) x-coordinate.
\item  x2 The second (typically right-most) x-coordinate.
\item  width The width of the mark (if supported).
\item  y The first (typically top-most) y-coordinate.
\item  y2 The second (typically bottom-most) y-coordinate.
\item  height The height of the mark (if supported).
\item  opacity The overall opacity.
\item  fill The fill color.
\item  fillOpacity The fill opacity
\item  stroke The stroke color.
\item  strokeWidth The stroke width, in pixels.
\item  strokeOpacity The stroke opacity.
\item  size [symbol] The pixel area of the symbol. For example in the case
  of circles, the radius is determined in part by the square root of the size
  value.
\item  shape [symbol] The symbol shape to use. One of circle (default),
  square, cross, diamond, triangle-up, or triangle-down (symbol only)
\item  innerRadius [arc] The inner radius of the arc, in pixels.
\item  outerRadius [arc] The outer radius of the arc, in pixels.
\item  startAngle [arc] The start angle of the arc, in radians.
\item  endAngle [arc] The end angle of the arc, in radians.
\item  interpolate [area, line] The line interpolation method to use. One
  of linear, step-before, step-after, basis, basis-open, cardinal,
  cardinal-open, monotone.
\item  tension [area, line] Depending on the interpolation type, sets the
  tension parameter.
\item  url [image] The URL from which to retrieve the image.
\item  align [image, text] The horizontal alignment of the object. One of
  left, right, center.
\item  baseline [image, text] The vertical alignment of the object. One of
  top, middle, bottom.
\item  text [text] The text to display.
\item  dx [text] The horizontal margin, in pixels, between the text label
  and its anchor point. The value is ignored if the align property is center.
\item  dy [text] The vertical margin, in pixels, between the text label
  and its anchor point. The value is ignored if the baseline property is
  middle.
\item  angle [text] The rotation angle of the text, in degrees.
\item  font [text] The typeface to set the text in (e.g., Helvetica Neue).
\item  fontSize [text] The font size, in pixels.
\item  fontWeight [text] The font weight (e.g., bold).
\item  fontStyle [text] The font style (e.g., italic).
}

To each property, you can assign any property object (\code{\link{prop}})
either locally (i.e. in the mark), or in a parent \code{layer}.
}
\examples{
# Set to constant values
props(x := 1, y := 2)
# Map to variables in the dataset
props(x = ~mpg, y = ~cyl)
# Set to a constant value in the data space
props(x = 1, y = 1)
# Use an interactive slider
props(opacity := input_slider(0, 1))

# To control other settings (like custom scales, mult and offset)
# use a prop object
props(prop("x", "old", scale = "x", offset = -1))

# Red when hovered over, black otherwise (these are equivalent)
props(fill := "black", fill.hover := "red")
props(fill.update := "black", fill.hover := "red")

# Use a column called id as the key (for dynamic data)
props(key := ~id)

# Explicitly create prop objects. The following are equivalent:
props(fill = ~cyl)
props(fill.update = ~cyl)
props(prop("fill", ~cyl))
props(prop("fill", ~cyl, scale = "fill", event = "update"))

# Prop objects can be programmatically created and added:
property <- "fill"
expr <- parse(text = "wt/mpg")[[1]]
p <- prop(property, expr)
props(p)

# Using .props
props(.props = list(x = 1, y = 2))
props(.props = list(x = ~mpg, y = ~cyl))
props(.props = list(quote(x := ~mpg)))
}

