% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/burst.R
\name{burst}
\alias{burst}
\title{Enumerate integer r-vectors summing to n}
\usage{
burst(n, r = n)
}
\arguments{
\item{n}{integer to sum to}

\item{r}{number of components}
}
\value{
a matrix whose rows are the n-tuples
}
\description{
Determine all r-vectors with nonnegative integer entries summing to n.  Note
that this is not intended to be optimized.
}
\examples{
burst(3)

burst(3, 1)
burst(3, 2)
burst(3, 3)
burst(3, 4)

rowSums(burst(4))
rowSums( burst(3, 2) )
rowSums( burst(3, 3) )
rowSums( burst(3, 4) )


burst(10, 4) # all possible 2x2 contingency tables with n=10
burst(10, 4) / 10 # all possible empirical relative frequencies

}
