% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin.var.R
\name{binVariable}
\alias{binVariable}
\title{Bin a Numeric Variable}
\usage{
binVariable(
  x,
  bins = 4,
  method = c("intervals", "proportions", "natural"),
  labels = FALSE
)
}
\arguments{
\item{x}{numeric variable to be binned.}

\item{bins}{number of bins.}

\item{method}{one of \code{"intervals"} for equal-width bins; \code{"proportions"} for equal-count bins; \code{"natural"} for cut points between bins to be determined by a k-means clustering.}

\item{labels}{if \code{FALSE}, numeric labels will be used for the factor levels; if \code{NULL}, the cut points are used to define labels; otherwise a character vector of level names.}
}
\value{
A factor.
}
\description{
Bin a Numeric Variable
}
\details{
Create a factor dissecting the range of a numeric variable into bins of equal width, (roughly) equal frequency, or at "natural" cut points.
The \code{\link[base]{cut}} function is used to create the factor.
}
\examples{
summary(binVariable(rnorm(100), method="prop", labels=letters[1:4]))

}
\seealso{
\code{\link[base]{cut}}, \code{\link[stats]{kmeans}}.
}
\author{
Dan Putler, slightly modified by John Fox (5 Dec 04 & 5 Mar 13) with the original author's permission.
}
\keyword{manip}
