% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SuperPredictor.R
\name{SuperPredictor}
\alias{SuperPredictor}
\title{Formula interface for SuperLearner::SuperLearner}
\usage{
SuperPredictor(
  formula,
  data,
  family = "binomial",
  SL.library = c("SL.glm", "SL.glm.interaction", "SL.ranger"),
  ...
)
}
\arguments{
\item{formula}{where the left hand side specifies the outcome and the right hand side the predictors}

\item{data}{data set in which formula can be evaluated}

\item{family}{the outcome family. default is binomial}

\item{SL.library}{the SuperLearner libraries}

\item{...}{passed to SuperLearner::SuperLearner}
}
\description{
Formula interface for SuperLearner::SuperLearner
}
\details{
Formula interface for SuperLearner::SuperLearner
##' @param formula
}
\examples{
\dontrun{
if(requireNamespace("SuperLearner",quietly=TRUE)){
library(SuperLearner)
library(data.table)
d = sampleData(338, outcome="binary")
spfit = SuperPredictor(Y~X1+X2+X3+X4+X5+X6+X7+X8+X9+X10,data=d)
predictRisk(spfit)
x <- Score(list(spfit),data=d,formula=Y~1)
}
}
}
