// Copyright 2014 The Rust Project Developers. See the COPYRIGHT
// file at the top-level directory of this distribution and at
// http://rust-lang.org/COPYRIGHT.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

// run-pass

fn main() {
    let v = vec![1, 2, 3];
    let boxed: Box<Iterator<Item=i32>> = Box::new(v.into_iter());
    assert_eq!(boxed.max(), Some(3));

    let v = vec![1, 2, 3];
    let boxed: &mut Iterator<Item=i32> = &mut v.into_iter();
    assert_eq!(boxed.max(), Some(3));
}
