#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-06-24 09:24:55 
# conf/unconfig.sh

### P A R A M S
MYVERBOSE=
if [ "$1" = "-v" ]; then
	MYVERBOSE="-v"
	shift
fi
MYPAM=
if [ "$1" = "-pam" ];then
	MYPAM='True'
	shift
fi
MYADMIN="$1"
MYADMINPWD="$2"
#echo "admin=${MYADMIN}"
#echo "admin passwd=${MYADMINPWD}"
#echo "pam=${MYPAM}"

### I N C L U D E S
. ./_include.sh

### S T A R T

if [ ! -z "${MYPAM}" ]; then
	echo "+begin pam winbind uninstall"
	case ${DISTRIBUTION} in
		Redhat|Fedora|Mandriva)
			./unconfig-pam_winbind.sh "all" "system-auth"
			;;
		Debian|Ubuntu)
			./unconfig-pam_winbind.sh "auth" "common-auth" "account" "common-account" "password" "common-password" "session" "common-session"
			;;
		*)
		echo "Unsupported distribution" >&2
		exit 1
		;;
	esac
	echo "+end pam winbind uninstall"
fi

echo "[1]"
./unconfig-smb.sh

echo "[2]"
./unconfig-nss.sh

echo "[3]"
./unconfig-winbind.sh

echo "[4]"
./leave-domain.sh ${MYVERBOSE} "${MYADMIN}" "${MYADMINPWD}"

#./unconfig-smbconf.sh
#./unconfig-kerberos.sh

echo "[uninstall ok]"
exit 0
